/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.jakartaee.bcel.classfile.Node;
import org.apache.tomcat.jakartaee.bcel.classfile.Utility;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;

public final class InnerClass
implements Cloneable,
Node {
    private int innerClassIndex;
    private int outerClassIndex;
    private int innerNameIndex;
    private int innerAccessFlags;

    public InnerClass(InnerClass c) {
        this(c.getInnerClassIndex(), c.getOuterClassIndex(), c.getInnerNameIndex(), c.getInnerAccessFlags());
    }

    InnerClass(DataInput file) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort());
    }

    public InnerClass(int innerClassIndex, int outerClassIndex, int innerNameIndex, int innerAccessFlags) {
        this.innerClassIndex = innerClassIndex;
        this.outerClassIndex = outerClassIndex;
        this.innerNameIndex = innerNameIndex;
        this.innerAccessFlags = innerAccessFlags;
    }

    @Override
    public void accept(Visitor v) {
        v.visitInnerClass(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.innerClassIndex);
        file.writeShort(this.outerClassIndex);
        file.writeShort(this.innerNameIndex);
        file.writeShort(this.innerAccessFlags);
    }

    public int getInnerAccessFlags() {
        return this.innerAccessFlags;
    }

    public int getInnerClassIndex() {
        return this.innerClassIndex;
    }

    public int getInnerNameIndex() {
        return this.innerNameIndex;
    }

    public int getOuterClassIndex() {
        return this.outerClassIndex;
    }

    public void setInnerAccessFlags(int innerAccessFlags) {
        this.innerAccessFlags = innerAccessFlags;
    }

    public void setInnerClassIndex(int innerClassIndex) {
        this.innerClassIndex = innerClassIndex;
    }

    public void setInnerNameIndex(int innerNameIndex) {
        this.innerNameIndex = innerNameIndex;
    }

    public void setOuterClassIndex(int outerClassIndex) {
        this.outerClassIndex = outerClassIndex;
    }

    public String toString() {
        return "InnerClass(" + this.innerClassIndex + ", " + this.outerClassIndex + ", " + this.innerNameIndex + ", " + this.innerAccessFlags + ")";
    }

    public String toString(ConstantPool constantPool) {
        String outer_class_name;
        String inner_class_name = constantPool.getConstantString(this.innerClassIndex, (byte)7);
        inner_class_name = Utility.compactClassName(inner_class_name, false);
        if (this.outerClassIndex != 0) {
            outer_class_name = constantPool.getConstantString(this.outerClassIndex, (byte)7);
            outer_class_name = " of class " + Utility.compactClassName(outer_class_name, false);
        } else {
            outer_class_name = "";
        }
        String inner_name = this.innerNameIndex != 0 ? ((ConstantUtf8)constantPool.getConstant(this.innerNameIndex, (byte)1)).getBytes() : "(anonymous)";
        String access = Utility.accessToString(this.innerAccessFlags, true);
        access = access.isEmpty() ? "" : access + " ";
        return "  " + access + inner_name + "=class " + inner_class_name + outer_class_name;
    }

    public InnerClass copy() {
        try {
            return (InnerClass)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

