/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Adapter;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.UpgradeProcessorInternal;
import org.apache.coyote.http2.Http2AsyncUpgradeHandler;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.tomcat.util.net.SocketWrapperBase;

public class Http2Protocol
implements UpgradeProtocol {
    static final long DEFAULT_READ_TIMEOUT = 5000L;
    static final long DEFAULT_WRITE_TIMEOUT = 5000L;
    static final long DEFAULT_KEEP_ALIVE_TIMEOUT = 20000L;
    static final long DEFAULT_STREAM_READ_TIMEOUT = 20000L;
    static final long DEFAULT_STREAM_WRITE_TIMEOUT = 20000L;
    static final long DEFAULT_MAX_CONCURRENT_STREAMS = 100L;
    static final int DEFAULT_MAX_CONCURRENT_STREAM_EXECUTION = 20;
    static final int DEFAULT_OVERHEAD_COUNT_FACTOR = 1;
    static final int DEFAULT_OVERHEAD_CONTINUATION_THRESHOLD = 1024;
    static final int DEFAULT_OVERHEAD_DATA_THRESHOLD = 1024;
    static final int DEFAULT_OVERHEAD_WINDOW_UPDATE_THRESHOLD = 1024;
    private static final String HTTP_UPGRADE_NAME = "h2c";
    private static final String ALPN_NAME = "h2";
    private static final byte[] ALPN_IDENTIFIER = "h2".getBytes(StandardCharsets.UTF_8);
    private long readTimeout = 5000L;
    private long writeTimeout = 5000L;
    private long keepAliveTimeout = 20000L;
    private long streamReadTimeout = 20000L;
    private long streamWriteTimeout = 20000L;
    private long maxConcurrentStreams = 100L;
    private int maxConcurrentStreamExecution = 20;
    private int initialWindowSize = 65535;
    private int maxHeaderCount = 100;
    private int maxTrailerCount = 100;
    private int overheadCountFactor = 1;
    private int overheadContinuationThreshold = 1024;
    private int overheadDataThreshold = 1024;
    private int overheadWindowUpdateThreshold = 1024;
    private boolean initiatePingDisabled = false;
    private boolean useSendfile = true;
    private AbstractHttp11Protocol<?> http11Protocol = null;

    @Override
    public String getHttpUpgradeName(boolean isSSLEnabled) {
        if (isSSLEnabled) {
            return null;
        }
        return HTTP_UPGRADE_NAME;
    }

    @Override
    public byte[] getAlpnIdentifier() {
        return ALPN_IDENTIFIER;
    }

    @Override
    public String getAlpnName() {
        return ALPN_NAME;
    }

    @Override
    public Processor getProcessor(SocketWrapperBase<?> socketWrapper, Adapter adapter) {
        UpgradeProcessorInternal processor = new UpgradeProcessorInternal(socketWrapper, new UpgradeToken(this.getInternalUpgradeHandler(socketWrapper, adapter, null), null, null));
        return processor;
    }

    @Override
    public InternalHttpUpgradeHandler getInternalUpgradeHandler(SocketWrapperBase<?> socketWrapper, Adapter adapter, Request coyoteRequest) {
        return socketWrapper.hasAsyncIO() ? new Http2AsyncUpgradeHandler(this, adapter, coyoteRequest) : new Http2UpgradeHandler(this, adapter, coyoteRequest);
    }

    @Override
    public boolean accept(Request request) {
        Enumeration<String> settings = request.getMimeHeaders().values("HTTP2-Settings");
        int count = 0;
        while (settings.hasMoreElements()) {
            ++count;
            settings.nextElement();
        }
        if (count != 1) {
            return false;
        }
        Enumeration<String> connection = request.getMimeHeaders().values("Connection");
        boolean found = false;
        while (connection.hasMoreElements() && !found) {
            found = connection.nextElement().contains("HTTP2-Settings");
        }
        return found;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public long getStreamReadTimeout() {
        return this.streamReadTimeout;
    }

    public void setStreamReadTimeout(long streamReadTimeout) {
        this.streamReadTimeout = streamReadTimeout;
    }

    public long getStreamWriteTimeout() {
        return this.streamWriteTimeout;
    }

    public void setStreamWriteTimeout(long streamWriteTimeout) {
        this.streamWriteTimeout = streamWriteTimeout;
    }

    public long getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(long maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public int getMaxConcurrentStreamExecution() {
        return this.maxConcurrentStreamExecution;
    }

    public void setMaxConcurrentStreamExecution(int maxConcurrentStreamExecution) {
        this.maxConcurrentStreamExecution = maxConcurrentStreamExecution;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public void setUseSendfile(boolean useSendfile) {
        this.useSendfile = useSendfile;
    }

    boolean isTrailerHeaderAllowed(String headerName) {
        return this.http11Protocol.isTrailerHeaderAllowed(headerName);
    }

    public void setMaxHeaderCount(int maxHeaderCount) {
        this.maxHeaderCount = maxHeaderCount;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public int getMaxHeaderSize() {
        return this.http11Protocol.getMaxHttpHeaderSize();
    }

    public void setMaxTrailerCount(int maxTrailerCount) {
        this.maxTrailerCount = maxTrailerCount;
    }

    public int getMaxTrailerCount() {
        return this.maxTrailerCount;
    }

    public int getMaxTrailerSize() {
        return this.http11Protocol.getMaxTrailerSize();
    }

    public int getOverheadCountFactor() {
        return this.overheadCountFactor;
    }

    public void setOverheadCountFactor(int overheadCountFactor) {
        this.overheadCountFactor = overheadCountFactor;
    }

    public int getOverheadContinuationThreshold() {
        return this.overheadContinuationThreshold;
    }

    public void setOverheadContinuationThreshold(int overheadContinuationThreshold) {
        this.overheadContinuationThreshold = overheadContinuationThreshold;
    }

    public int getOverheadDataThreshold() {
        return this.overheadDataThreshold;
    }

    public void setOverheadDataThreshold(int overheadDataThreshold) {
        this.overheadDataThreshold = overheadDataThreshold;
    }

    public int getOverheadWindowUpdateThreshold() {
        return this.overheadWindowUpdateThreshold;
    }

    public void setOverheadWindowUpdateThreshold(int overheadWindowUpdateThreshold) {
        this.overheadWindowUpdateThreshold = overheadWindowUpdateThreshold;
    }

    public void setInitiatePingDisabled(boolean initiatePingDisabled) {
        this.initiatePingDisabled = initiatePingDisabled;
    }

    public boolean getInitiatePingDisabled() {
        return this.initiatePingDisabled;
    }

    public boolean useCompression(Request request, Response response) {
        return this.http11Protocol.useCompression(request, response);
    }

    public ContinueResponseTiming getContinueResponseTimingInternal() {
        return this.http11Protocol.getContinueResponseTimingInternal();
    }

    public AbstractProtocol<?> getHttp11Protocol() {
        return this.http11Protocol;
    }

    @Override
    public void setHttp11Protocol(AbstractProtocol<?> http11Protocol) {
        this.http11Protocol = (AbstractHttp11Protocol)http11Protocol;
    }
}

