/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.tomcat.jakartaee.Converter;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.Util;

public class ClassConverter
implements Converter {
    @Override
    public boolean accepts(String filename) {
        String extension = Util.getExtension(filename);
        return "class".equals(extension);
    }

    @Override
    public void convert(InputStream src, OutputStream dest, EESpecProfile profile) throws IOException {
        ClassParser parser = new ClassParser(src, "unknown");
        JavaClass javaClass = parser.parse();
        Constant[] constantPool = javaClass.getConstantPool().getConstantPool();
        for (int i = 0; i < constantPool.length; i = (int)((short)(i + 1))) {
            if (!(constantPool[i] instanceof ConstantUtf8)) continue;
            ConstantUtf8 c = (ConstantUtf8)constantPool[i];
            String str = c.getBytes();
            c = new ConstantUtf8(profile.convert(str));
            constantPool[i] = c;
        }
        javaClass.dump(dest);
    }
}

