/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.Migration;
import org.apache.tomcat.jakartaee.StringManager;

public class MigrationCLI {
    private static final Logger logger = Logger.getLogger(MigrationCLI.class.getCanonicalName());
    private static final StringManager sm = StringManager.getManager(MigrationCLI.class);
    private static final String PROFILE_ARG = "-profile=";

    public static void main(String[] args) {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%5$s%n");
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        if (arguments.contains("-verbose")) {
            Logger.getGlobal().getParent().getHandlers()[0].setLevel(Level.FINE);
            Logger.getGlobal().getParent().setLevel(Level.FINE);
            arguments.remove("-verbose");
        }
        Migration migration = new Migration();
        boolean valid = false;
        String source = null;
        String dest = null;
        if (arguments.size() == 3 && ((String)arguments.get(0)).startsWith(PROFILE_ARG)) {
            source = (String)arguments.get(1);
            dest = (String)arguments.get(2);
            valid = true;
            try {
                migration.setEESpecProfile(EESpecProfile.valueOf(((String)arguments.get(0)).substring(PROFILE_ARG.length())));
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
        }
        if (arguments.size() == 2) {
            source = (String)arguments.get(0);
            dest = (String)arguments.get(1);
            valid = true;
        }
        if (!valid) {
            MigrationCLI.usage();
            System.exit(1);
        }
        migration.setSource(new File(source));
        migration.setDestination(new File(dest));
        boolean result = false;
        try {
            result = migration.execute();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, sm.getString("migration.error"), e);
            result = false;
        }
        if (!result) {
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println(sm.getString("migration.usage"));
    }
}

