/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.jakartaee.Converter;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.Util;

public class TextConverter
implements Converter {
    private static final List<String> supportedExtensions = new ArrayList<String>();

    @Override
    public boolean accepts(String filename) {
        String extension = Util.getExtension(filename);
        return supportedExtensions.contains(extension);
    }

    @Override
    public void convert(InputStream src, OutputStream dest, EESpecProfile profile) throws IOException {
        String srcString = Util.toString(src, StandardCharsets.ISO_8859_1);
        String destString = profile.convert(srcString);
        ByteArrayInputStream bais = new ByteArrayInputStream(destString.getBytes(StandardCharsets.ISO_8859_1));
        Util.copy(bais, dest);
    }

    static {
        supportedExtensions.add("java");
        supportedExtensions.add("jsp");
        supportedExtensions.add("jspx");
        supportedExtensions.add("tag");
        supportedExtensions.add("tagx");
        supportedExtensions.add("tld");
        supportedExtensions.add("txt");
        supportedExtensions.add("xml");
    }
}

