/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee;

import java.io.File;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.apache.tomcat.jakartaee.AntHandler;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.Migration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MigrationTask
extends Task {
    private File src;
    private File dest;
    private String profile = EESpecProfile.TOMCAT.toString();

    public void setSrc(File src) {
        this.src = src;
    }

    public void setDest(File dest) {
        this.dest = dest;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void execute() throws BuildException {
        Logger logger = Logger.getLogger(Migration.class.getCanonicalName());
        logger.setUseParentHandlers(false);
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        logger.addHandler(new AntHandler(this));
        EESpecProfile profile = null;
        try {
            profile = EESpecProfile.valueOf(this.profile.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new BuildException("Invalid profile specified: " + this.profile, this.getLocation());
        }
        Migration migration = new Migration();
        migration.setSource(this.src);
        migration.setDestination(this.dest);
        migration.setEESpecProfile(profile);
        boolean success = false;
        try {
            success = migration.execute();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        if (!success) {
            throw new BuildException("Migration failed", this.getLocation());
        }
    }
}

