#!C:/Perl/bin/perl
use strict;
use warnings;
use Getopt::Long;
require Win32;
use Config;
use ExtUtils::MakeMaker;
use File::Basename;
use File::Spec::Functions;
require 'util.pl';

BEGIN {
    die 'This script is intended for Win32' unless $^O =~ /Win32/i;
}

my ($apache, $help);
GetOptions( 'with-apache2=s' => \$apache,
	    'help' => \$help,
	    ) or usage($0);
usage($0) if $help;

my @path_ext;
path_ext();
$apache ||= search(); 

for my $file (qw(apxs_win32.pl apr_win32.pl apu_win32.pl) ) {
    push @ARGV, "--with-apache2=$apache";
    unless (my $return = do $file) {
	warn "Cannot parse $file: $@" if $@;
	warn "Cannot do $file: $!"    unless defined $return;
	warn "Cannot run $file"       unless $return;
    }
}

sub search {
    my $apache;
    if (my $bin = which('Apache')) {
        (my $candidate = dirname($bin)) =~ s!bin$!!;
        if (-d $candidate and check($candidate)) {
            $apache = $candidate;
        }
    }
    unless ($apache and -d $apache) {
        $apache = prompt("Please give the path to your Apache2 installation:",
                         $apache);
    }
    die "Can't find a suitable Apache2 installation!" 
        unless ($apache and -d $apache and check($apache));
    
    $apache = Win32::GetShortPathName($apache);
    $apache =~ s!\\$!!;
    my $ans = prompt(qq{\nUse "$apache" for your Apache2 directory?}, 'yes');
    unless ($ans =~ /^y/i) {
        die <<'END';

Please run this configuration script again, and give
the --with-apache2=C:\Path\to\Apache2 option to specify
the desired top-level Apache2 directory.

END
    }
    return $apache;
}

sub drives {
    my @drives = ();
    eval{require Win32API::File;};
    return map {"$_:\\"} ('C' .. 'Z') if $@;
    my @r = Win32API::File::getLogicalDrives();
    return unless @r > 0;
    for (@r) {
        my $t = Win32API::File::GetDriveType($_);
        push @drives, $_ if ($t == 3 or $t == 4);
    }
    return @drives > 0 ? @drives : undef;
}

sub path_ext {
    if ($ENV{PATHEXT}) {
        push @path_ext, split ';', $ENV{PATHEXT};
        for my $ext (@path_ext) {
            $ext =~ s/^\.*(.+)$/$1/;
        }
    }
    else {
        #Win9X: doesn't have PATHEXT
        push @path_ext, qw(com exe bat);
    }
}

sub which {
    my $program = shift;
    return unless $program;
    my @extras = ();
    my @drives = drives();
    if (@drives > 0) {
        for my $drive (@drives) {
            for ('Apache2', 'Program Files/Apache2',
                 'Program Files/Apache Group/Apache2') {
                my $bin = catfile $drive, $_, 'bin';
                push @extras, $bin if (-d $bin);
            }
        }
    }
    my @a = map {catfile($_, $program) } 
        (path(), @extras);
    for my $base(@a) {
        return $base if -x $base;
        for my $ext (@path_ext) {
            return "$base.$ext" if -x "$base.$ext";
        }
    }
    return;
}
