#!C:/Perl/bin/perl
use strict;
use warnings;
use Getopt::Long;
require Win32;
use Config;
use ExtUtils::MakeMaker;
require 'util.pl';
my ($apache, $help);
GetOptions( 'with-apache2=s' => \$apache,
	    'help' => \$help,
	    ) or usage($0);
usage($0) if $help;

unless (defined $apache and -d $apache) {
    $apache = prompt("Please give the path to your Apache2 installation:",
		     $apache);
}
die "Can't find a suitable Apache2 installation!" 
    unless (-d $apache and check($apache));

$apache = Win32::GetShortPathName($apache);
$apache =~ s!\\!/!g;

(my $perl = which('perl')) =~ s!\\!/!g;
my %subs_cfg = (
                '%APACHE2%' => $apache,
                '%AWK%' => which('awk') || which('gawk') || '',
                '%CC%' => $Config{cc},
                '%CPP%' => $Config{cpp},
                '%SHELL%' => $ENV{COMSPEC},
                '%LD%' => $Config{ld},
               );

my $pat = join '|', keys %subs_cfg;
my $build_dir = $apache . '/build';
my $cfg_mk = $build_dir . '/config_vars.mk';
unless (-d $build_dir) {
    mkdir $build_dir or die "Cannot mkdir $build_dir: $!";
}
open(my $cfg, ">$cfg_mk")
    or die qq{Cannot open $cfg_mk: $!};
while (<DATA>) {
    s/($pat)/$subs_cfg{$1}/;
    print $cfg $_;
}
close $cfg;

my %subs_apxs = (
                 '%perlbin%' => which('perl'),
                 '%exp_installbuilddir%' => $build_dir,
                 '%RM_F%' => qq{$perl -MExtUtils::Command -e rm_f},
                 '%CP%' => qq{$perl -MExtUtils::Command -e cp},
                 '%CHMOD%' => qq{$perl -MExtUtils::Command -e chmod},
                 '%TOUCH%' => qq{$perl -MExtUtils::Command -e touch},
                 );
$pat = join '|', keys %subs_apxs;
my $apxs_out = $apache . '/bin/apxs.pl';
my $apxs_in = 'apxs_win32';
open(my $out, ">$apxs_out")
    or die "Cannot open $apxs_out: $!";
open(my $in, $apxs_in)
    or die "Cannot open $apxs_in: $!";
while (<$in>) {
    s/($pat)/$subs_apxs{$1}/;
    print $out $_;
}
close $in;
close $out;

system ('pl2bat', $apxs_out) == 0 
    or die "system pl2bat $apxs_out failed: $?";
print qq{\napxs.bat has been created under $apache/bin.\n\n};

__DATA__
exp_exec_prefix = %APACHE2%
rel_exec_prefix =
exp_bindir = %APACHE2%/bin
rel_bindir = bin
exp_sbindir = %APACHE2%/bin
rel_sbindir = bin
exp_libdir = %APACHE2%/lib
rel_libdir = lib
exp_libexecdir = %APACHE2%/modules
rel_libexecdir = modules
exp_sysconfdir = %APACHE2%/conf
rel_sysconfdir = conf
exp_datadir = %APACHE2%
rel_datadir =
exp_installbuilddir = %APACHE2%/build
rel_installbuilddir = build
exp_errordir = %APACHE2%/error
rel_errordir = error
exp_iconsdir = %APACHE2%/icons
rel_iconsdir = icons
exp_htdocsdir = %APACHE2%/htdocs
rel_htdocsdir = htdocs
exp_manualdir = %APACHE2%/manual
rel_manualdir = manual
exp_cgidir = %APACHE2%/cgi-bin
rel_cgidir = cgi-bin
exp_includedir = %APACHE2%/include
rel_includedir = include
exp_localstatedir = %APACHE2%
rel_localstatedir =
exp_runtimedir = %APACHE2%/logs
rel_runtimedir = logs
exp_logfiledir = %APACHE2%/logs
rel_logfiledir = logs
exp_proxycachedir = %APACHE2%/proxy
rel_proxycachedir = proxy
SHLTCFLAGS = 
LTCFLAGS =
MPM_NAME = winnt
MPM_SUBDIR_NAME = winnt
htpasswd_LTFLAGS =
htdigest_LTFLAGS =
rotatelogs_LTFLAGS =
logresolve_LTFLAGS =
htdbm_LTFLAGS =
ab_LTFLAGS =
checkgid_LTFLAGS =
APACHECTL_ULIMIT =
progname = Apache.exe
MPM_LIB = server/mpm/winnt/
OS = win32
OS_DIR = win32
BUILTIN_LIBS =
SHLIBPATH_VAR = 
OS_SPECIFIC_VARS =
PRE_SHARED_CMDS =
POST_SHARED_CMDS = 
shared_build =
AP_LIBS =
AP_BUILD_SRCLIB_DIRS = apr apr-util
AP_CLEAN_SRCLIB_DIRS = apr-util apr
abs_srcdir = 
bindir = ${exec_prefix}/bin
sbindir = ${exec_prefix}/bin
cgidir = ${datadir}/cgi-bin
logfiledir = ${localstatedir}/logs
exec_prefix = ${prefix}
datadir = ${prefix}
localstatedir = ${prefix}
mandir = ${prefix}/man
libdir = ${exec_prefix}/lib
libexecdir = ${exec_prefix}/modules
htdocsdir = ${datadir}/htdocs
manualdir = ${datadir}/manual
includedir = ${prefix}/include
errordir = ${datadir}/error
iconsdir = ${datadir}/icons
sysconfdir = ${prefix}/conf
sysconf = httpd.conf
installbuilddir = ${datadir}/build
runtimedir = ${localstatedir}/logs
proxycachedir = ${localstatedir}/proxy
other_targets =
unix_progname = httpd
prefix = %APACHE2%
AWK = %AWK%
CC = %CC%
LD = %LD%
CPP = %CPP%
CXX =
CPPFLAGS =
CFLAGS = /nologo /MD /W3 /O2 /D "WIN32" /D "_WINDOWS" /D "NDEBUG"
CXXFLAGS =
LTFLAGS =
LDFLAGS = kernel32.lib /nologo /subsystem:windows /dll /machine:I386 /libpath:"${prefix}/lib"
LT_LDFLAGS = 
SH_LDFLAGS =
HTTPD_LDFLAGS =
UTIL_LDFLAGS =
LIBS =
DEFS =
INCLUDES =
NOTEST_CPPFLAGS = 
NOTEST_CFLAGS =
NOTEST_CXXFLAGS =
NOTEST_LDFLAGS =
NOTEST_LIBS =
EXTRA_CPPFLAGS = 
EXTRA_CFLAGS = 
EXTRA_CXXFLAGS =
EXTRA_LDFLAGS =
EXTRA_LIBS =
EXTRA_INCLUDES = 
LIBTOOL = 
SHELL = %SHELL%
MODULE_DIRS = aaa filters loggers metadata proxy http generators mappers
MODULE_CLEANDIRS = arch/win32 cache echo experimental ssl test dav/main dav/fs
PORT = 80
nonssl_listen_stmt_1 =
nonssl_listen_stmt_2 = Listen @@Port@@
CORE_IMPLIB_FILE =
CORE_IMPLIB =
SH_LIBS =
SH_LIBTOOL =
MK_IMPLIB =
INSTALL_PROG_FLAGS =
DSO_MODULES =
APR_BINDIR = %APACHE2%/bin
APR_INCLUDEDIR = 
APU_BINDIR = %APACHE2%/bin
APU_INCLUDEDIR = 
