/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * Original Copyright (c) 2005 Covalent Technologies
 *
 * FTP Protocol module for Apache 2.0
 */

/*
 * A simple example of how to override a commmand.  The FTP hooks will
 * run all handlers for a command, until a module returns anything other
 * than DECLINED.  All core commands are registered as FTP_HOOK_LAST, so
 * any module can override using FTP_HOOK_MIDDLE or FTP_HOOK_FIRST.
 *
 * -rpm 2/28/2001
 */

#include "mod_ftp.h"

extern AP_MODULE_DECLARE_DATA module ftp_cmd_pwd_module;

static int mod_ftp_cmd_pwd2(request_rec *r, const char *arg)
{
    ftp_connection *fc = ftp_get_module_config(r->connection->conn_config);

    fc->response_notes = apr_psprintf(r->pool,
                                      "PWD command has been overridden by "
                                      "an external module!");
    return FTP_REPLY_PATH_CREATED;
}

static void register_hooks(apr_pool_t *p)
{
    ftp_hook_cmd("PWD", mod_ftp_cmd_pwd2, FTP_HOOK_MIDDLE,
                 FTP_NEED_LOGIN | FTP_TAKE0,
                 "This command does not do anything.");
}

AP_MODULE_DECLARE_DATA module ftp_cmd_pwd_module = {
    STANDARD20_MODULE_STUFF,
    NULL,                       /* create per-directory config structure */
    NULL,                       /* merge per-directory config structures */
    NULL,                       /* create per-server config structure */
    NULL,                       /* merge per-server config structures */
    NULL,                       /* command apr_table_t */
    register_hooks              /* register hooks */
};
