dnl Licensed to the Apache Software Foundation (ASF) under one or more
dnl contributor license agreements.  See the NOTICE file distributed with
dnl this work for additional information regarding copyright ownership.
dnl The ASF licenses this file to You under the Apache License, Version 2.0
dnl (the "License"); you may not use this file except in compliance with
dnl the License.  You may obtain a copy of the License at
dnl
dnl       http://www.apache.org/licenses/LICENSE-2.0
dnl
dnl Unless required by applicable law or agreed to in writing, software
dnl distributed under the License is distributed on an "AS IS" BASIS,
dnl WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
dnl See the License for the specific language governing permissions and
dnl limitations under the License.

dnl #  start of module specific part
APACHE_MODPATH_INIT(ftp)

dnl #  list of module object files
ftp_objs="dnl
mod_ftp.lo dnl
ftp_commands.lo dnl
ftp_connection.lo dnl
ftp_data_connection.lo dnl
ftp_data_filters.lo dnl
ftp_filters.lo dnl
ftp_inet_pton.lo dnl
ftp_limitlogin.lo dnl
ftp_log.lo dnl
ftp_message.lo dnl
ftp_protocol.lo dnl
ftp_request.lo dnl
ftp_util.lo dnl
"
dnl #  hook module into the Autoconf mechanism (--enable-ftp option)
APACHE_MODULE(ftp, [FTP Protocol support (mod_ftp)], $ftp_objs, , no, [
    AC_CHECK_FUNCS(fchmod)
    AC_CHECK_HEADERS(arpa/ftp.h)
    AC_CHECK_HEADERS(netinet/ip.h)
])

APACHE_MODULE(ftp_cmd_pwd, [Example FTP cmd extension (mod_ftp_cmd_pwd)], mod_ftp_cmd_pwd.lo, , no)

dnl #  end of module specific part
APACHE_MODPATH_FINISH

