/* Copyright 2002-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Apache.Web.Version.h Version declaration macros

#ifndef APACHE_WEB_VERSION

// The MAJOR.MINOR revision should reflect the Apache release this module 
// is built for.  The httpd release guidelines from version 4.0.43 onwards
// assure us that the binaries remain backwards compatibile, within each
// major.minor httpd release.
//
#define APACHE_WEB_VER_MAJOR 2
#define APACHE_WEB_VER_MINOR 0

// The n.n.SUBVS should reflect each mod_aspdotnet/Apache.Web release
//
#define APACHE_WEB_VER_SUBVS 0

// The n.n.n.BUILD must be bumped every time Apache.Web class interfaces change.
// This ensures that a specific build of mod_aspdotnet loads it's correponding
// build of Apache.Web, and that multiple builds of Apache.Web coexist in the GAC.
//
#define APACHE_WEB_VER_BUILD 2000

// Define APACHE_WEB_VER_RELEASE as 1 for a non-dev, release build, when rolling
// the distribution .zip sources or binary release.
//
#define APACHE_WEB_VER_RELEASE 1

#define APACHE_WEB_VERSION_CSV \
    APACHE_WEB_VER_MAJOR,\
    APACHE_WEB_VER_MINOR,\
    APACHE_WEB_VER_SUBVS,\
    APACHE_WEB_VER_BUILD

// Properly quote a value as a string in the C preprocessor
#define APW_STRINGIFY(n) APW_STRINGIFY_HELPER(n)
// Helper macro for APR_STRINGIFY
#define APW_STRINGIFY_HELPER(n) #n

#define APACHE_WEB_VERSION \
    APW_STRINGIFY(APACHE_WEB_VER_MAJOR ##. \
                ##APACHE_WEB_VER_MINOR ##. \
                ##APACHE_WEB_VER_SUBVS ##. \
                ##APACHE_WEB_VER_BUILD)

#endif // APACHE_WEB_VERSION
