<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_remoteip - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_remoteip</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_remoteip.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_remoteip.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Remplace l'adresse IP du client
pour la requte par l'adresse IP prsente par un mandataire ou un
rpartiteur de charge via les en-ttes de la requte.
</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>remoteip_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_remoteip.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module permet de traiter le client qui a initi la
    requte en tant que client original du point de vue de httpd 
    des fins d'autorisation et de connexion, mme si ce client se
    trouve derrire un rpartiteur de charge, un serveur frontal, ou un
    serveur mandataire.</p>

    <p>Le module remplace l'adresse IP du client
    pour la connexion par l'adresse IP indique dans
    l'en-tte de requte configur via la directive
    <code class="directive"><a href="#remoteipheader">RemoteIPHeader</a></code>.</p>

    <p>Ce module implmente aussi la partie serveur du <a href="http://blog.haproxy.com/haproxy/proxy-protocol/">protocole PROXY</a>
    de HAProxy via la directive <code class="directive"><a href="#remoteipproxyprotocol">RemoteIPProxyProtocol</a></code>.</p>

    <p>Une fois sa valeur modifie comme indiqu, cette adresse IP client est
    utilise pour la fonctionnalit <code class="directive"><a href="../mod/mod_authz_core.html#require">Require ip</a></code> de <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code> ;
    elle est aussi affiche par <code class="module"><a href="../mod/mod_status.html">mod_status</a></code>, et enregistre via
    les chanes de formatage <code>%a</code> des modules
    <code class="module"><a href="../mod/mod_log_config.html">mod_log_config</a></code> et <code class="module"><a href="../mod/core.html">core</a></code>.  L'adresse IP
    client sous-jacente de la connexion est enregistre via la chane de
    formatage <code>%{c}a</code>.  </p>

    <div class="warning">Il est essentiel de n'activer cette
    fonctionnalit que pour les requtes en provenance des serveurs
    intermdiaires (mandataires, etc...) auxquels le serveur peut faire
    confiance, car il est trivial pour le client distant d'usurper
    l'identit d'un autre client.</div>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#processing">Traitement des adresses distantes</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#remoteipheader">RemoteIPHeader</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#remoteipinternalproxy">RemoteIPInternalProxy</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#remoteipinternalproxylist">RemoteIPInternalProxyList</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#remoteipproxiesheader">RemoteIPProxiesHeader</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#remoteipproxyprotocol">RemoteIPProxyProtocol</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#remoteipproxyprotocolexceptions">RemoteIPProxyProtocolExceptions</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#remoteiptrustedproxy">RemoteIPTrustedProxy</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#remoteiptrustedproxylist">RemoteIPTrustedProxyList</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_remoteip">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_remoteip">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code></li>
<li><code class="module"><a href="../mod/mod_status.html">mod_status</a></code></li>
<li><code class="module"><a href="../mod/mod_log_config.html">mod_log_config</a></code></li>
<li><a href="http://www.haproxy.org/download/1.8/doc/proxy-protocol.txt">Proxy Protocol
Spec</a></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="processing" id="processing">Traitement des adresses distantes</a></h2>

    <p>Par dfaut, Apache identifie le client via la valeur client_ip de la
    connexion, et de cette valeur dcoulent les valeurs remote_host et
    remote_logname de la connexion. Ces champs jouent un rle
    dans l'authentification, l'autorisation et la journalisation, ainsi que
    dans d'autres traitements effectus par d'autres modules
    chargeables.</p>

    <p>mod_remoteip remplace l'adresse IP client de la connexion par l'adresse IP client
    indique par exemple par un mandataire ou un rpartiteur de charge
    pour toute la dure de la requte. Un rpartiteur de charge pourra ainsi
    tablir une connexion keepalive de longue dure avec le serveur, chaque
    requte conservant alors l'adresse IP client correcte bien que l'adresse IP
    client sous-jacente du rpartiteur de charge reste inchange.</p>

    <p>Lorsque la valeur de l'en-tte comporte plusieurs adresses IP
    client spares par des virgules, celles-ci sont traites de la
    droite vers la gauche. Le traitement s'arrte lorsque l'adresse IP
    client courante n'est pas digne de confiance pour prsenter
    l'adresse IP prcdente. Le champ d'en-tte est alors mis  jour de
    faon  ne contenir que cette liste d'adresses non confirmes, ou
    bien, si toutes les adresses IP sont dignes de confiance, cet
    en-tte est tout bonnement supprim de la requte.</p>

    <p>Lors du remplacement de l'adresse IP client, le module stocke
    la liste des htes intermdiaires dans un mmo
    remoteip-proxy-ip-list, que l'on peut faire enregistrer par
    <code class="module"><a href="../mod/mod_log_config.html">mod_log_config</a></code> en utilisant le symbole de format
    <code>%{remoteip-proxy-ip-list}n</code>. Si l'administrateur doit
    stocker ceci dans un en-tte additionnel, la mme valeur peut aussi
    tre enregistre sous la forme d'un en-tte en utilisant la
    directive <code class="directive"><a href="#remoteipproxiesheader">RemoteIPProxiesHeader</a></code>.</p>

    <div class="note"><h3>Adresses IPv4 converties au format IPv6</h3>
    Avec httpd, d'une manire gnrale, toute adresse IPv4 convertie au
    format IPv6 est enregistre sous sa forme IPv4.</div>

    <div class="note"><h3>Adresses internes (prives)</h3>
    Tous les blocs d'adresses internes 10/8, 172.16/12, 192.168/16,
    169.254/16 and 127/8 (ainsi que les adresses IPv6 en dehors du bloc
    public 2000::/3 block) ne sont values par mod_remoteip que lorsque
    des mandataires internes (intranet)
    <code class="directive"><a href="#remoteipinternalproxy">RemoteIPInternalProxy</a></code> sont enregistrs.</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="remoteipheader" id="remoteipheader">Directive</a> <a name="RemoteIPHeader" id="RemoteIPHeader">RemoteIPHeader</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le champ d'en-tte qui contiendra les adresses IP
du client</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoteIPHeader <var>en-tte</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_remoteip</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#remoteipheader">RemoteIPHeader</a></code> indique 
    <code class="module"><a href="../mod/mod_remoteip.html">mod_remoteip</a></code> de traiter la valeur de
    l'<var>en-tte</var> spcifi comme l'adresse IP du client, ou comme
    une liste d'adresses IP clients intermdiaires, en fonction de la
    configuration des directives
    <code class="directive"><a href="#remoteipinternalproxy">RemoteIPInternalProxy</a></code> et
    <code class="directive"><a href="#remoteiptrustedproxy">RemoteIPTrustedProxy</a></code>. Si ces
    deux dernires directives ne sont pas utilises,
    <code class="module"><a href="../mod/mod_remoteip.html">mod_remoteip</a></code> traitera tout hte prsentant une adresse non
    interne dans l'en-tte <code class="directive"><a href="#remoteipheader">RemoteIPHeader</a></code> comme hte de confiance.</p>
    
    <div class="warning">Si ces deux dernires
    directives ne sont pas utilises, <code class="module"><a href="../mod/mod_remoteip.html">mod_remoteip</a></code>
    traitera tout hte prsentant une adresse non interne
    dans l'en-tte <code class="directive"><a href="#remoteipheader">RemoteIPHeader</a></code> comme hte de
    confiance.</div>

    <div class="example"><h3>Exemple  usage interne (rpartiteur de
    charge)</h3><pre class="prettyprint lang-config">RemoteIPHeader X-Client-IP</pre>
</div>

    <div class="example"><h3>Exemple dans le cas d'un mandataire</h3><pre class="prettyprint lang-config">RemoteIPHeader X-Forwarded-For</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="remoteipinternalproxy" id="remoteipinternalproxy">Directive</a> <a name="RemoteIPInternalProxy" id="RemoteIPInternalProxy">RemoteIPInternalProxy</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dclare les adresses IP intranet clients comme dignes de
confiance pour prsenter la valeur RemoteIPHeader</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoteIPInternalProxy
<var>ip-mandataire</var>|<var>ip-mandataire/sous-rseau</var>|<var>nom-hte</var> ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_remoteip</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#remoteipinternalproxy">RemoteIPInternalProxy</a></code> permet
    d'ajouter une ou plusieurs adresses (ou blocs d'adresses) auxquelles
    on peut faire confiance pour prsenter une valeur RemoteIPHeader
    valide de l'adresse IP du client. A la diffrence de la directive
    <code class="directive"><a href="#remoteiptrustedproxy">RemoteIPTrustedProxy</a></code>, toute adresse IP
    prsente dans cet en-tte, y comprises les adresses intranet
    prives, sont considres comme dignes de confiance lorsqu'elles
    sont indiques par ces mandataires.</p>

    <div class="example"><h3>Exemple  usage interne (rpartiteur de
    charge)</h3><pre class="prettyprint lang-config">RemoteIPHeader X-Client-IP
RemoteIPInternalProxy 10.0.2.0/24
RemoteIPInternalProxy gateway.localdomain</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="remoteipinternalproxylist" id="remoteipinternalproxylist">Directive</a> <a name="RemoteIPInternalProxyList" id="RemoteIPInternalProxyList">RemoteIPInternalProxyList</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dclare les adresses IP intranet clients comme dignes de
confiance pour prsenter la valeur RemoteIPHeader</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoteIPInternalProxyList <var>nom-fichier</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_remoteip</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#remoteipinternalproxylist">RemoteIPInternalProxyList</a></code>
    permet de spcifier un fichier parcouru au dmarrage du serveur pour
    construire une liste d'adresses (ou blocs d'adresses), auxquelles
    on peut faire confiance pour prsenter une valeur RemoteIPHeader
    valide de l'adresse IP du client.</p>

    <p>Le caractre '<code>#</code>' indique une ligne de commentaires,
    sinon, toutes les lignes spares par un caractre <code>nouvelle
    ligne</code> ou
    tous les lments d'une ligne spars par un espace sont traits de
    la mme faon qu'avec la directive
    <code class="directive"><a href="#remoteipinternalproxy">RemoteIPInternalProxy</a></code>.</p>

    <div class="example"><h3>Exemple  usage interne (rpartiteur de
    charge)</h3><pre class="prettyprint lang-config">RemoteIPHeader X-Client-IP
RemoteIPInternalProxyList conf/trusted-proxies.lst</pre>
</div>

    <div class="example"><h3>contenu de conf/mandataires-de-confiance.lst</h3><pre>         # Nos mandataires internes de confiance
         10.0.2.0/24         # Tout le monde dans le groupe de test
         passerelle.domaine-local # Le frontal rpartiteur de charge</pre></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="remoteipproxiesheader" id="remoteipproxiesheader">Directive</a> <a name="RemoteIPProxiesHeader" id="RemoteIPProxiesHeader">RemoteIPProxiesHeader</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dclare le champ d'en-tte qui contiendra toutes les
adresses IP intermdiaires</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoteIPProxiesHeader <var>Nom_en-tte</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_remoteip</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#remoteipproxiesheader">RemoteIPProxiesHeader</a></code> permet
    de spcifier l'en-tte dans lequel <code class="module"><a href="../mod/mod_remoteip.html">mod_remoteip</a></code> va
    collecter une liste de toutes les adresses IP clients intermdiaires
    auxquelles on pourra faire confiance pour rsoudre l'adresse IP
    client de la requte. Notez que les adresses intermdiaires
    <code class="directive"><a href="#remoteiptrustedproxy">RemoteIPTrustedProxy</a></code> sont enregistres dans
    cet en-tte, alors que toute adresse intermdiaire
    <code class="directive"><a href="#remoteipinternalproxy">RemoteIPInternalProxy</a></code> est omise.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">RemoteIPHeader X-Forwarded-For
RemoteIPProxiesHeader X-Forwarded-By</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="remoteipproxyprotocol" id="remoteipproxyprotocol">Directive</a> <a name="RemoteIPProxyProtocol" id="RemoteIPProxyProtocol">RemoteIPProxyProtocol</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active ou dsactive la gestion du protocole PROXY</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoteIPProxyProtocol On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_remoteip</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.31 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive">RemoteIPProxyProtocol</code> permet
    d'activer ou de dsactiver la prise en compte et la gestion de l'en-tte de
    connexion du protocole PROXY. Si elle est dfinie  <code>On</code>, la
    demande du client <em>doit</em> envoyer l'en-tte appropri pour chaque
    nouvelle connexion, sinon cette dernire sera ferme  moins qu'il ne fasse
    partie de la liste, dfinie via la directive <code class="directive"><a href="#remoteipproxyprotocoldisablehosts">RemoteIPProxyProtocolDisableHosts</a></code>, des
    htes pour lesquels le protocole PROXY est dsactiv.</p>

    <p>Bien que cette directive peut tre dfinie au niveau de n'importe quel
    serveur virtuel, il est important de garder  l'esprit que, tant donn que
    le protocole PROXY est bas sur la connexion et agnostique quant au
    protocle, son activation/dsactivation est base sur le couple adresse
    IP/port. Cela signifie que si plusieurs serveurs virtuels  base de nom sont
    configurs avec le mme couple adresse IP/port, et si vous activez le
    protocole PROXY pour l'un d'entre eux, il le sera aussi pour tous les autres
    (avec le mme couple adresse IP/port). Cela signifie aussi que si vous
    tentez d'activer le protocole PROXY pour un serveur virtuel et de le
    dsactiver pour un autre, cela ne marchera pas ; dans ce dernier cas, la
    dernire directive l'emporte sur les autres et une notification sera
    enregistre dans le journal pour indiquer les rglages qui ont t annuls.</p>

    <pre class="prettyprint lang-config">Listen 80
&lt;VirtualHost *:80&gt;
    ServerName www.example.com
    RemoteIPProxyProtocol On

    #Les requtes pour ce serveur virtuel doivent contenir un en-tte du
    #protocole PROXY. Si ce n'est pas le cas, la connexion sera ferme.
&lt;/VirtualHost&gt;

Listen 8080
&lt;VirtualHost *:8080&gt;
    ServerName www.example.com
    RemoteIPProxyProtocol On
    RemoteIPProxyProtocolExceptions 127.0.0.1 10.0.0.0/8

    #Les requtes pour ce serveur virtuel doivent contenir un en-tte du
    #protocole PROXY. Si ce n'est pas le cas, la connexion sera ferme  moins
    que sa source ne soit localhost ou la gamme d'adresses RFC1918 10.x.x.x
&lt;/VirtualHost&gt;</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="remoteipproxyprotocolexceptions" id="remoteipproxyprotocolexceptions">Directive</a> <a name="RemoteIPProxyProtocolExceptions" id="RemoteIPProxyProtocolExceptions">RemoteIPProxyProtocolExceptions</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dsactive la prise en compte de l'en-tte PROXY pour certains htes
ou rseaux</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoteIPProxyProtocolExceptions host|range [host|range] [host|range]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_remoteip</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>RemoteIPProxyProtocolExceptions est disponible  partir de la
version 2.4.31 du serveur HTTP Apache</td></tr>
</table>
    <p>La directive <code class="directive">RemoteIPProxyProtocol</code> permet de
    contrler la prise en compte de l'en-tte de connexion du protocole PROXY.
    Il est parfois souhaitable d'exiger pour certains clients la
    prsence de l'en-tte PROXY, mais aussi de permettre aux autres clients de
    se connecter sans ce dernier. Cette directive permet  l'administrateur du
    serveur d'autoriser cette possibilit  un hte isol ou  une gamme d'htes
    au format CIDR.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="remoteiptrustedproxy" id="remoteiptrustedproxy">Directive</a> <a name="RemoteIPTrustedProxy" id="RemoteIPTrustedProxy">RemoteIPTrustedProxy</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dclare les adresses IP clientes de l'intranet dignes de
confiance pour prsenter la valeur RemoteIPHeader</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoteIPTrustedProxy
<var>ip-mandataire</var>|<var>ip-mandataire/sous-rseau</var>|<var>nom-hte</var> ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_remoteip</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#remoteiptrustedproxy">RemoteIPTrustedProxy</a></code> permet
    d'ajouter une ou plusieurs adresses, ou blocs d'adresses, auxquelles
    on peut faire confiance pour prsenter une valeur RemoteIPHeader
    valide de l'adresse IP du client. A la diffrence de la directive
    <code class="directive"><a href="#remoteipinternalproxy">RemoteIPInternalProxy</a></code>, toutes les adresses IP
    intranet ou prives indiques par de tels mandataires, y compris les
    blocs d'adresses 10/8, 172.16/12, 192.168/16, 169.254/16 et 127/8
    (ou situe en dehors du bloc IPv6 public 2000::/3), ne sont pas
    dignes de confiance en tant qu'adresses IP distantes, et se situent
     gauche dans le contenu de l'en-tte
    <code class="directive"><a href="#remoteipheader">RemoteIPHeader</a></code>.</p>

    <div class="example"><h3>Exemple d'adresse de confiance (rpartiteur de
    charge</h3><pre class="prettyprint lang-config">RemoteIPHeader X-Forwarded-For
RemoteIPTrustedProxy 10.0.2.16/28
RemoteIPTrustedProxy proxy.example.com</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="remoteiptrustedproxylist" id="remoteiptrustedproxylist">Directive</a> <a name="RemoteIPTrustedProxyList" id="RemoteIPTrustedProxyList">RemoteIPTrustedProxyList</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dclare les adresses IP intranet clients comme dignes de
confiance pour prsenter la valeur RemoteIPHeader</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RemoteIPTrustedProxyList <var>nom-fichier</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_remoteip</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#remoteiptrustedproxylist">RemoteIPTrustedProxyList</a></code>
    permet de spcifier un fichier parcouru au dmarrage du serveur pour
    construire une liste d'adresses (ou blocs d'adresses), auxquelles
    on peut faire confiance pour prsenter une valeur RemoteIPHeader
    valide de l'adresse IP du client.</p>

    <p>Le caractre '<code>#</code>' indique une ligne de commentaires,
    sinon, toutes les lignes spares par un caractre nouvelle ligne ou
    tous les lments d'une ligne spars par un espace sont traits de
    la mme faon qu'avec la directive
    <code class="directive"><a href="#remoteiptrustedproxy">RemoteIPTrustedProxy</a></code>.</p>

    <div class="example"><h3>Exemple d'adresse de confiance (rpartiteur de
    charge</h3><pre class="prettyprint lang-config">RemoteIPHeader X-Forwarded-For
RemoteIPTrustedProxyList conf/trusted-proxies.lst</pre>
</div>

    <div class="example"><h3>conf/mandataires-de-confiance.lst contents</h3><p><code>
       # Mandataires externes identifis<br />
       192.0.2.16/28         #groupe wap phone de mandataires<br />
       proxy.isp.example.com #un FAI bien connu
    </code></p></div>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_remoteip.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_remoteip.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_remoteip.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>