<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Quand ne pas utiliser mod_rewrite - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Rewrite</a></div><div id="page-content"><div id="preamble"><h1>Quand ne pas utiliser mod_rewrite</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/avoid.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/avoid.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>


<p>Ce document est un complment  la <a href="../mod/mod_rewrite.html">Documentation de rfrence</a> de
<code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. Il dcrit peut-tre un des concepts les
plus importants  propos de mod_rewrite -  savoir, quand doit-on viter
de l'utiliser.</p>

<p>mod_rewrite doit tre considr comme un dernier recours,
lorsqu'aucune alternative n'est possible. Utiliser mod_rewrite lorsqu'il
existe des alternatives plus simples conduit  des configurations
confuses, fragiles, et difficiles  maintenir. La comprhension des
autres alternatives disponibles est une tape trs importante sur le
chemin de la matrise de mod_rewrite.</p>

<p>Vous devez vous attacher  comprendre le
fonctionnement des exemples, car la plupart d'entre eux ne
fonctionneront pas sur votre systme si vous vous contentez de les
copier/coller dans vos fichiers de configuration.</p>

<p>Le cas le plus courant dans lequel <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> est
l'outil appropri est la situation o la seule solution envisageable
ncessite l'accs aux fichiers de configuration du serveur, alors que
cet accs ne vous est pas accord. Certaines directives de configuration
ne sont disponibles que dans le fichier de configuration du serveur. Si
vous ne pouvez agir que sur les fichiers .htaccess, vous devrez donc
vous tourner vers <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>.</p>

</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#redirect">Redirection simple</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#alias">Alias d'URL</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#vhosts">Hbergement virtuel</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxy">Mandat simple</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#setenv">Test de variables d'environnement</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="../mod/mod_rewrite.html">Documentation du module mod_rewrite</a></li><li><a href="intro.html">Introduction  mod_rewrite</a></li><li><a href="remapping.html">Redirection et remise en
correspondance</a></li><li><a href="access.html">Contrle d'accs</a></li><li><a href="vhosts.html">Serveurs virtuels</a></li><li><a href="proxy.html">Serveurs mandataires</a></li><li><a href="rewritemap.html">Utilisation de RewriteMap</a></li><li><a href="advanced.html">Techniques avances</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="redirect" id="redirect">Redirection simple</a></h2>


<p><code class="module"><a href="../mod/mod_alias.html">mod_alias</a></code> fournit les directives <code class="directive"><a href="../mod/mod_alias.html#redirect">Redirect</a></code> et <code class="directive"><a href="../mod/mod_alias.html#redirectmatch">RedirectMatch</a></code> qui permettent de
rediriger une URL vers une autre. Plutt que d'utiliser la directive
<code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> pour ce genre de
redirection simple d'une URL ou d'une classe d'URLs vers une autre, on
prfrera l'utilisation de ces directives. En outre, avec
<code>RedirectMatch</code>, vous pouvez inclure une expression
rationnelle dans votre critre de redirection, ce qui vous permet de
bnficier de nombreux avantages de la directive
<code>RewriteRule</code>.</p>

<p>Une utilisation courante de la directive <code>RewriteRule</code> est
la redirection de toute une classe d'URLs. Par exemple, toutes les URLs
faisant rfrence au rpertoire <code>/un</code> doivent tre
rediriges vers <code>http://un.example.com/</code>, ou toutes les
requtes <code>http</code> doivent tre rediriges vers
<code>https</code>.</p>

<p>Pour ce faire, il est prfrable d'utiliser la directive
<code>Redirect</code>. Souvenez-vous que la directive
<code>Redirect</code> conserve les informations relatives au chemin. En
d'autres termes, la redirection d'une URL <code>/un</code> va aussi
rediriger toutes les URLs de niveaux infrieurs comme
<code>/un/deux.html</code> et <code>/un/trois/quatre.html</code>.</p>

<p>Pour rediriger les URLs sous <code>/un</code> vers
<code>http://un.example.com/</code>, utilisez cette dfinition :</p>

<div class="example"><p><code>
Redirect /un/ http://un.example.com/
</code></p></div>

<p>Pour rediriger les URLs <code>http</code> vers <code>https</code>,
utilisez cette dfinition :</p>

<div class="example"><p><code>
&lt;VirtualHost *:80&gt;
ServerName www.example.com<br />
Redirect / https://www.example.com/<br />
&lt;/VirtualHost &gt;
<br />
&lt;VirtualHost *:443&gt;
ServerName www.example.com<br />
<br />
# ... insrer ici la configuration SSL<br />
&lt;/VirtualHost &gt;
</code></p></div>

<p>L'utilisation de la directive <code>RewriteRule</code> pour accomplir
cette tche peut se justifier s'il existe d'autres directives
<code>RewriteRule</code> dans la mme porte. En effet, lorsque des
directives <code>Redirect</code> et <code>RewriteRule</code> se trouvent
dans la mme porte, les directives <code>RewriteRule</code> sont
excutes en premier, sans tenir compte de leur ordre d'apparition dans
le fichier de configuration.</p>

<p>Dans le cas de la redirection <em>http-vers-https</em>, l'utilisation
de rgles <code>RewriteRule</code> se justifie si vous n'avez pas accs
au fichier de configuration principal, et devez donc accomplir cette
tche au sein d'un fichier <code>.htaccess</code>.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="alias" id="alias">Alias d'URL</a></h2>
<p>La directive <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code> permet
de mettre en correspondance un URI avec un rpertoire, ce dernier tant
en gnral situ en dehors de l'arborescence dfinie par la directive
<code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code>. Bien qu'il soit
possible d'effectuer cette mise en correspondance avec
<code>mod_rewrite</code>, il est prfrable d'utiliser la directive
<code>Alias</code> pour des raisons de simplicit et de performances.</p>

<div class="example"><h3>Utilisation de la directive Alias</h3><p><code>
Alias /chats /var/www/virtualhosts/felin/htdocs
</code></p></div>

<p>
Pour effectuer cette mise en correspondance, <code>mod_rewrite</code>
s'impose si vous n'avez pas accs aux fichiers de configuration du
serveur. En effet, la directive Alias ne peut pas tre utilise dans un
fichier <code>.htaccess</code>, mais seulement dans un contexte de
serveur principal ou de serveur virtuel.
</p>

<p>En outre, vous pouvez arriver au mme rsultat avec les liens
symboliques, pourvu que <code>Options FollowSymLinks</code> soit activ
sur votre serveur.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="vhosts" id="vhosts">Hbergement virtuel</a></h2>
<p>Bien qu'il soit possible de grer les <a href="vhosts.html">serveurs
virtuels avec mod_rewrite</a>, il s'agit rarement de la bonne mthode.
Il est pratiquement toujours prfrable de crer des blocs
&lt;VirtualHost&gt; individuels. Dans l'ventualit o vous devez grer
un grand nombre de serveurs virtuels, vous devez vous tourner vers
<code class="module"><a href="../mod/mod_vhost_alias.html">mod_vhost_alias</a></code> pour crer ces serveurs
automatiquement.</p>

<p>Il est aussi possible d'utiliser des modules tiers comme <a href="http://www.cri.ensmp.fr/~coelho/mod_macro/">mod_macro</a> pour
crer un grand nombre de serveurs virtuels dynamiquement.</p>

<p>L'utilisation de <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> pour la cration de
serveurs virtuels peut se rvler approprie si votre service
d'hbergement ne vous permet pas d'accder aux fichiers de configuration
du serveur, et que vous vous trouvez par consquent oblig de passer par les
fichiers <code>.htaccess</code>.</p>

<p>Voir le document <a href="vhosts.html">cration de serveurs virtuels
avec mod_rewrite</a> pour plus de dtails sur la manire d'y parvenir si
cela semble tre tout de mme la meilleure approche.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="proxy" id="proxy">Mandat simple</a></h2>

<p>La directive <code>RewriteRule</code> fournit le drapeau <a href="flags.html#flag_p">[P]</a> qui permet de faire passer les URIs
rcrits par <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>.</p>

<div class="example"><p><code>
RewriteRule ^/?images(.*) http://serveur-images.local/images$1 [P]
</code></p></div>

<p>Cependant, dans les nombreux cas o aucune correspondance au modle
n'est vraiment ncessaire, comme dans l'exemple ci-dessus, il est
prfrable d'utiliser la directive <code class="directive"><a href="../mod/mod_proxy.html#proxypass">ProxyPass</a></code>. L'exemple prcdent pourrait
tre remplac par :</p>

<div class="example"><p><code>
ProxyPass /images/ http://serveur-images.local/images/
</code></p></div>

<p>Que vous utilisiez <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> ou <code class="directive"><a href="../mod/mod_proxy.html#proxypass">ProxyPass</a></code>, vous devrez dans tous les cas
utiliser aussi la directive <code class="directive"><a href="../mod/mod_proxy.html#proxypassreverse">ProxyPassReverse</a></code> pour intercepter les
redirections en provenance du serveur d'arrire-plan :</p>

<div class="example"><p><code>
ProxyPassReverse /images/ http://serveur-images.local/images/
</code></p></div>

<p>Vous devrez cependant tout de mme utiliser <code>RewriteRule</code>
lorsque d'autres <code>RewriteRule</code>s se trouvent dans la mme porte,
car elles agissent en gnral avant les directives
<code>ProxyPass</code>, et peuvent ainsi les court-circuiter.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="setenv" id="setenv">Test de variables d'environnement</a></h2>

<p><code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> est souvent utilis pour effectuer une
action en fonction de la prsence ou de l'absence d'une variable
d'environnement particulire ou d'un en-tte de requte, ce qui peut
tre accompli de manire plus efficace via la directive <code class="directive"><a href="../mod/core.html#if">&lt;If&gt;</a></code>.</p>

<p>Considrons par exemple le scnario courant o la directive
<code class="directive">RewriteRule</code> est utilise pour forcer un nom
d'hte canonique, tel que <code>www.example.com</code> au lieu de
<code>example.com</code>. Il est possible d'utiliser  la place la
directive <code class="directive"><a href="../mod/core.html#if">&lt;If&gt;</a></code> comme
suit :</p>

<div class="example"><p><code>
&lt;If "$req{Host} != 'www.example.com'"&gt;<br />
RedirectMatch (.*) http://www.example.com$1<br />
&lt;/If&gt;
</code></p></div>

<p>On peut utiliser cette technique dans de nombreux scnarios courants
en remplacement de <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> pour effectuer des actions
en fonction d'en-ttes de requtes ou de rponses, ou de variables
d'environnement.</p>

<p>Voir en particulier la <a href="../expr.html">documentation sur
l'valuation des expressions</a> pour une vue d'ensemble des types
d'expressions que vous pouvez utiliser dans les sections &lt;If&gt;,
ainsi que dans certaines directives.</p>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/avoid.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/avoid.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2012 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>