<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Dtails sur le fonctionnement des serveurs virtuels - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Serveurs virtuels</a></div><div id="page-content"><div id="preamble"><h1>Dtails sur le fonctionnement des serveurs virtuels</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/vhosts/details.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/vhosts/details.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/vhosts/details.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/vhosts/details.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
<div class="outofdate">Cette traduction peut tre prime. Vrifiez la version
            anglaise pour les changements rcents.</div>


    <p>Le code grant les serveurs virtuels a t rcrit  partir de
    zro dans <strong>Apache 1.3</strong>. Ce document vise  expliquer
    dans le dtail comment Apache procde lors du choix de l'utilisation
    d'un serveur virtuel en fonction d'une requte reue. L'apparition
    de la directive  <code class="directive"><a href="../mod/core.html#namevirtualhost">NameVirtualHost</a></code>
    a rendu beaucoup plus facile et plus sre la configuration des
    serveurs virtuels par rapport aux versions prcdant la 1.3.</p>

    <p>Si vous voulez juste <cite>que a marche</cite> sans en
    comprendre le fonctionnement, voici <a href="examples.html">quelques
    exemples</a>.</p>

</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#configparsing">Interprtation des fichiers
de configuration</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#hostmatching">Choix du serveur virtuel</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#tips">Trucs et astuces</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="configparsing" id="configparsing">Interprtation des fichiers
de configuration</a></h2>

    <p>Un <em>serveur  principal (main_server)</em> contient toutes
    les dfinitions qui apparaissent en dehors des sections
    <code>&lt;VirtualHost&gt;</code>. Les serveurs virtuels, aussi
    appels <em>vhosts</em> (pour virtual hosts), sont dfinis par les
    sections <code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>.</p>

    <p>Les directives
    <code class="directive"><a href="../mod/mpm_common.html#listen">Listen</a></code>,
    <code class="directive"><a href="../mod/core.html#servername">ServerName</a></code>,
    <code class="directive"><a href="../mod/core.html#serverpath">ServerPath</a></code>,
    et <code class="directive"><a href="../mod/core.html#serveralias">ServerAlias</a></code>
    peuvent tre places n'importe o dans le cadre de dfinition d'un
    serveur. Cependant, chaque fois que l'une d'elles est lue, elle crase
    ses instances prcdentes (dans le contexte du mme serveur).</p>

    <p>La valeur par dfaut du champ <code>Listen</code> pour le serveur
    principal est de 80. Le serveur principal n'a pas de valeur par
    dfaut pour <code>ServerPath</code> ni pour <code>ServerAlias</code>.
    La valeur par dfaut de <code>ServerName</code> est dduite  partir
    de l'adresses IP du serveur.</p>

    <p>La directive Listen associe au serveur principal a deux utilits.
    La premire dtermine le port rseau sur lequel Apache va couter.
    La deuxime spcifie le port qui sera utilis dans les URIs absolus
    lors des redirections.</p>

    <p> la diffrence du serveur principal, les ports des serveurs
    virtuels <em>n</em>'affectent <em>pas</em> les ports sur lesquels
    Apache se met  l'coute.</p>

    <p>Chaque adresse incluse dans une directive <code>VirtualHost</code>
    peut disposer d'un port optionnel. Si le port n'est pas prcis, il
    prend par dfaut la dernire valeur de <code>Listen</code> lue dans
    la configuration du serveur principal. Le port particulier
    <code>*</code> reprsente un joker qui correspond  tous les ports.
    L'ensemble des adresses (y compris les rsultats multiples
    <code>A</code> issus des requtes DNS) est appel <em>jeu
    d'adresses</em> du serveur virtuel.</p>

    <p> moins qu'une directive
    <code class="directive"><a href="../mod/core.html#namevirtualhost">NameVirtualHost</a></code> ne soit utilise
    pour une adresse IP spcifique, le premier serveur virtuel avec
    cette adresse est considr comme un <em>serveur virtuel par-IP</em>.
    L'adresse IP peut galement prendre la valeur joker <code>*</code>.</p>

    <p>Dans les cas o l'on souhaite utiliser un <em>serveur virtuel
    par nom</em>, la directive <code>NameVirtualHost</code> <em>doit</em>
    apparatre avec l'adresse IP choisie. En d'autres termes, vous devez
    spcifier dans votre fichier de configuration l'adresse IP des noms
    de domaine (CNAME) de vos serveurs virtuels par nom au moyen de
    la directive <code>NameVirtualHost</code>.</p>

    <p>On peut utiliser plusieurs directives <code>NameVirtualHost</code>
    pour un groupe de directives <code>VirtualHost</code>, mais seule
    une directive <code>NameVirtualHost</code> doit tre utilise pour
    chaque couple IP:port donn.</p>

    <p>L'ordre d'apparition des directives <code>NameVirtualHost</code>
    et <code>VirtualHost</code> est sans importance, ce qui fait que
    les deux exemples suivants ont des effets identiques (seul l'ordre
    des directives <code>VirtualHost</code> pour <em>un</em> jeu
    d'adresses est important, voir ci-dessous)&nbsp;:</p>

<table><tr>
<td><div class="example"><p><code>
  NameVirtualHost 111.22.33.44<br />
  &lt;VirtualHost 111.22.33.44&gt;<br />
  # serveur A<br />
  ...<br />
  &lt;/VirtualHost&gt;<br />
  &lt;VirtualHost 111.22.33.44&gt;<br />
  # serveur B<br />
  ...<br />
  &lt;/VirtualHost&gt;<br />
  <br />
  NameVirtualHost 111.22.33.55<br />
  &lt;VirtualHost 111.22.33.55&gt;<br />
  # serveur C<br />
  ...<br />
  &lt;/VirtualHost&gt;<br />
  &lt;VirtualHost 111.22.33.55&gt;<br />
  # serveur D<br />
  ...<br />
  &lt;/VirtualHost&gt;
</code></p></div></td>
<td><div class="example"><p><code>
  &lt;VirtualHost 111.22.33.44&gt;<br />
  # serveur A<br />
  &lt;/VirtualHost&gt;<br />
  &lt;VirtualHost 111.22.33.55&gt;<br />
  # serveur C<br />
  ...<br />
  &lt;/VirtualHost&gt;<br />
  &lt;VirtualHost 111.22.33.44&gt;<br />
  # serveur B<br />
  ...<br />
  &lt;/VirtualHost&gt;<br />
  &lt;VirtualHost 111.22.33.55&gt;<br />
  # serveur D<br />
  ...<br />
  &lt;/VirtualHost&gt;<br />
  <br />
  NameVirtualHost 111.22.33.44<br />
  NameVirtualHost 111.22.33.55<br />
  <br />
</code></p></div></td>
</tr></table>


    <p>(Il est conseill d'adopter le choix de gauche pour faciliter
    la lisibilit des fichiers de configuration.)</p>

    <p>Aprs la lecture de la directive <code>VirtualHost</code>, le
    serveur virtuel se voit attribuer une valeur <code>Listen</code>
    par dfaut qui est la valeur du port associ au premier nom spcifi
    dans sa directive <code>VirtualHost</code>.</p>

    <p>La liste complte des noms d'une directive <code>VirtualHost</code>
    est gre exactement comme des <code>ServerAlias</code> (mais ne
    sont pas crass par d'autres <code>ServerAlias</code>) si tous
    les noms sont rsolus dans ce jeu d'adresse.  noter que les tats
    <code>Listen</code> de ce serveur virtuel sont sans incidence sur
    les ports attibus au jeu d'adresses.</p>

    <p>Pendant la phase d'initialisation, une liste de chaque adresse
    IP est gnre et introduite dans une table de 'hash'. Si une
    adresse IP est utilise dans une directive <code>NameVirtualHost</code>,
    cette liste contient les noms des serveurs virtuels pour cette
    adresse. Si aucun serveur virtuel n'est dfini pour cette adresse,
    la directive <code>NameVirtualHost</code> est ignore et un message
    est envoy au journal d'erreurs. Quand un serveur virtuel par IP
    est utilis, la table de 'hash' reste vide.</p>

    <p>La fonction de 'hash' tant rapide, le temps d'excution d'un
    'hash' sur une adresse IP lors d'une requte est minimale et
    quasiment imperceptible. De plus, la table est optimise pour les
    adresses IP dont le dernier octet est le seul  changer.</p>

    <p>Pour chaque serveur virtuel, diverses valeurs sont initialises
    par dfaut. En particulier&nbsp;:</p>

    <ol>
      <li>Dans le cas o un serveur virtuel ne contient pas de directives
      <code class="directive"><a href="../mod/core.html#serveradmin">ServerAdmin</a></code>,
      <code class="directive"><a href="../mod/core.html#resourceconfig">ResourceConfig</a></code>,
      <code class="directive"><a href="../mod/core.html#accessconfig">AccessConfig</a></code>,
      <code class="directive"><a href="../mod/core.html#timeout">Timeout</a></code>,
      <code class="directive"><a href="../mod/core.html#keepalivetimeout">KeepAliveTimeout</a></code>,
      <code class="directive"><a href="../mod/core.html#keepalive">KeepAlive</a></code>,
      <code class="directive"><a href="../mod/core.html#maxkeepaliverequests">MaxKeepAliveRequests</a></code>,
      <code class="directive"><a href="../mod/core.html#receivebuffersize">ReceiveBufferSize</a></code>,
      ou <code class="directive"><a href="../mod/core.html#sendbuffersize">SendBufferSize</a></code>,
      alors la valeur de chacun de ces paramtres est hrite de celle du
      serveur principal. (C'est  dire, hrite de la valeur finale aprs
      lecture de la configuration du serveur principal.)</li>

      <li>Les permissions par dfaut sur les rpertoires de chaque
      serveur virtuel sont assembles avec celles du serveur principal.
      Elles concernent galement toutes les informations de configuration
      par rpertoire pour tous les modules.</li>

      <li>Les configurations par serveur pour chaque module sont assembles
       partir de celles du serveur principal.</li>
    </ol>

    <p>L'essentiel des valeurs de configuration des serveurs virtuels
    provient de valeurs par dfaut issues du serveur principal.
    Mais la position dans le fichier de configuration des directives
    du serveur principal n'a pas d'importance -- l'ensemble de la
    configuration du serveur principal est lu avant que ces valeurs par
    dfaut soient appliques aux serveur virtuels. Ainsi, mme si la
    dfinition d'une valeur apparat aprs celle d'un serveur virtuel,
    cette valeur peut affecter la definition du serveur virtuel.</p>

    <p>Dans le cas o le serveur principal n'a pas de <code>ServerName</code>
     ce stade, le nom de la machine sur laquelle tourne le programme
    <code class="program"><a href="../programs/httpd.html">httpd</a></code> est utilis  sa place. Nous appellerons
    <em>jeu d'adresses du serveur principal</em> les adresses IP
    renvoyes par une rsolution DNS sur le <code>ServerName</code>
    du serveur principal.</p>

    <p>Pour tous les champs <code>ServerName</code> non dfinis, dans
    le cas d'une configuration en serveur virtuel par nom, la valeur
    adopte par dfaut est la premire adresse donne dans la section
    <code>VirtualHost</code> qui dfinit le serveur virtuel.</p>

    <p>Si un serveur virtuel contient la valeur magique
    <code>_default_</code>, il fonctionne sur le mme <code>ServerName</code>
    que le serveur principal.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="hostmatching" id="hostmatching">Choix du serveur virtuel</a></h2>

    <p> la rception d'une requte, le serveur procde comme suit pour
    dterminer quel serveur virtuel utiliser&nbsp;:</p>

    <h3><a name="hashtable" id="hashtable">Vrification dans la table de hash</a></h3>

    <p>Aprs que le client se soit connect, l'adresse
    IP  laquelle le client s'est connect est recherche dans la
    table de hash IP interne.</p>

    <p>Si la rsolution de l'adresse IP n'aboutit pas (adresse IP non
    trouve), la requte est servie par le serveur virtuel
    <code>_default_</code> s'il est dfini pour le port correspondant
     la requte. Sinon, elle est servie par le serveur principal.</p>

    <p>Si l'adresse IP n'est pas trouve dans la table de hash, la
    recherche du numro de port peut aussi se terminer par une
    correspondance  un <code>NameVirtualHost *</code> qui est gr
    ensuite comme les autres serveurs virtuels par noms.</p>

    <p>Si une liste est bien trouve dans la table pour l'adresse
    IP recherche, l'tape suivante est de dterminer s'il s'agit
    d'un serveur virtuel par nom ou par IP.</p>

    

    <h3><a name="ipbased" id="ipbased">Serveur virtuel par IP</a></h3>

    <p>Si l'entre trouve dispose d'une liste de noms vide, c'est
    qu'il s'agit d'un serveur virtuel par IP, et aucun autre choix
    n'est plus  faire&nbsp;; la requte est servie par ce serveur virtuel.</p>

    

    <h3><a name="namebased" id="namebased">Serveur virtuel par nom</a></h3>

    <p>Si l'entre trouve correspond  un serveur virtuel par nom,
    la liste de noms contient au moins une structure de serveurs
    virtuels. Les serveurs virtuels se prsentent dans cette liste
    dans le mme ordre que la lecture des directives <code>VirtualHost</code>
    dans le fichier de configuration.</p>

    <p>Le premier serveur virtuel de cette liste (donc, le premier
    serveur virtuel du fichier de configuration
    attribu  l'adresse IP spcifie)
    se voit attribuer la plus grande priorit, ce
    qui signifie que c'est lui qui traite les requtes prsentant un
    nom de serveur invalide ou ne prsentant pas de champ
    <code>Host:</code> dans l'en-tte.</p>

    <p>Si un champ <code>Host:</code> est transmis dans l'en-tte de
    la requte, son occurrence est recherche dans la liste et le
    premier serveur virtuel qui prsente un <code>ServerName</code>
    ou un <code>ServerAlias</code> correspondant est choisi pour
    servir la requte. Il est possible que le champ <code>Host:</code>
    contienne un numro de port, mais Apache utilise toujours le
    port sur lequel il a effectivement reu la requte.</p>

    <p>Dans le cas o le client a envoy une requte en HTTP/1.0 sans
    champ d'en-tte <code>Host:</code>, il est impossible de
    dterminer le serveur auquel le client veut se connecter&nbsp;; l'URI
    de la requte est recherch dans tous les <code>ServerPath</code>
    existants. Le premier chemin trouv est utilis et la requte est
    servie par le serveur virtuel correspondant.</p>

    <p>Si aucun serveur virtuel n'est trouv, la requte est servie
    par le premier serveur virtuel qui coute sur le port demand et
    qui est sur la liste associe  l'adresse IP vers laquelle la
    requte a t envoye (comme dj prcis ci-avant).</p>

    

    <h3><a name="persistent" id="persistent">Connexions persistantes</a></h3>

    <p>La recherche par adresse IP dcrite ci-avant n'est faite
    qu'<em>une fois</em> pour chaque session TCP/IP, alors que la
    recherche par nom est ralise pour <em>chaque</em> requte au
    cours d'une connexion persistante (KeepAlive). En d'autres termes,
    il est possible pour un client de faire des requtes sur
    diffrents serveurs virtuels par nom, au cours d'une unique
    connexion persistante.</p>

    

    <h3><a name="absoluteURI" id="absoluteURI">URI absolu</a></h3>

    <p>Au cas o l'URI de la requte est absolu, et que son nom de
    serveur et son port correspondent au serveur principal (ou l'un
    des serveurs virtuels configurs), <em>et</em> qu'ils correspondent
     l'adresse et au port de la requte, alors l'URI est amput
    de son prfixe protocole/nom de serveur/port et trait par le
    serveur correspondant (principal ou virtuel). Si cette correspondance
    n'existe pas, l'URI reste inchang et la requte est considre
    comme une requte d'un serveur mandataire (proxy).</p>


<h3><a name="observations" id="observations">Observations</a></h3>

    <ul>
      <li>Les serveurs virtuels par nom et par IP n'interfrent
      jamais entre eux. Les serveurs virtuels par IP ne sont joignables
      qu'au travers de leur(s) adresse(s) IP propre(s), et en aucun
      cas par une autre adresse. Les serveurs virtuels par nom
      ne sont accessibles que par leur(s) adresse(s) IP qui ne peuvent
      tre dfinies qu'au moyen de la directive
      <code>NameVirtualHost</code>.</li>

      <li>Les vrifications sur <code>ServerAlias</code> et
      <code>ServerPath</code> ne sont jamais ralises pour les
      serveurs virtuels par IP.</li>

      <li>L'ordre dans lequel sont agencs dans le fichier de
      configuration le serveur virtuel <code>_default_</code>, les
      serveurs virtuels par nom et par IP, et la directive
      <code>NameVirtualHost</code> est sans incidence sur le
      fonctionnement. Seul l'ordre des serveurs virtuels par nom
      pour une adresse donne a une importance. Le serveur virtuel
      par nom qui est prsent en premier dans la configuration se
      voit attribu la priorit la plus haute pour les requtes
      arrivant sur son jeu d'adresses IP.</li>

      <li>Pour des raisons de scurit, le numro de port prsent
      dans le champ d'en-tte <code>Host:</code> n'est jamais utilis
      pour les tests de correspondances. Apache ne prend en compte
      que le numro de port sur lequel le client a envoy la requte.</li>

      <li>Si une directive <code>ServerPath</code> existe, et se
      trouve tre prfixe d'une autre directive <code>ServerPath</code>
      qui apparat plus loin dans la configuration, la premire
      sera toujours utilise et la deuxime jamais. (Ceci ne se
      produit que dans le cas o aucun champ <code>Host:</code>
      n'a t prsent par le client pour distinguer les deux.)</li>

      <li>Dans le cas o deux serveurs virtuels par IP ont une
      adresse en commun, le serveur virtuel qui apparat en premier
      dans la configuration est toujours choisi. Ce genre de chose
      peut arriver par inadvertance. Le serveur envoie une alerte
      dans le journal d'erreurs si ce cas se prsente.</li>

      <li>Le serveur virtuel <code>_default_</code> ne sert la requte
      que si aucun autre serveur virtuel travaillant sur l'adresse
      IP <em>et</em> le port demands n'est trouv. La requte n'est
      traite que si le numro de port qui a reu la requte est
      associ au serveur virtuel <code>_default_</code> (qui par
      dfaut, correspond  <code>Listen</code>). Un port joker peut
      tre spcifi (<em>comme dans</em> <code>_default_:*</code>)
      pour rcuprer les requtes sur tous les ports ouverts. Ceci
      est galement applicable aux serveurs virtuels
      <code>NameVirtualHost *</code>.</li>

      <li>Le serveur principal ne sert les requtes que
      lorsque l'adresse IP et le port demands par le client ne
      correspondent  aucun serveur virtuel (y compris un serveur
      virtuel <code>_default_</code>). En d'autres termes, le serveur
      principal n'est utile que pour les combinaisons adresse/port
      non spcifies (sauf quand un serveur virtuel <code>_default_</code>
      correspond au port).</li>

      <li>Ni les serveurs virtuels <code>_default_</code>, ni le
      serveur principal ne sont utiliss pour traiter une requte
      avec un champ d'en-tte <code>Host:</code> inconnu ou manquant
      lorsque l'adresse (et le port) de connexion correspondent 
      des serveurs virtuels par nom, par exemple, dans une directive
      <code>NameVirtualHost</code>.</li>

      <li>Il ne faut jamais employer de noms DNS dans des directives
      <code>VirtualHost</code>, car cela oblige le serveur a s'appuyer
      sur le DNS au moment du dmarrage. De plus, vous vous exposez
       des problmes de scurit si vous n'avez pas la matrise du
      DNS pour la totalit de vos domaines. Voir la documentation
      <a href="../dns-caveats.html">disponible ici</a>, ainsi que
      les deux points prciss ci-aprs.</li>

      <li>Un nom de serveur <code>ServerName</code> devrait toujours
      tre indiqu pour chaque serveur virtuel. Sans cela, une
      rsolution DNS est ncessaire pour chaque serveur virtuel.</li>
      </ul>
      

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="tips" id="tips">Trucs et astuces</a></h2>

    <p>En plus des points voqus sur la page des
    <a href="../dns-caveats.html#tips">problmes lis au DNS</a>,
    voici quelques points intressants&nbsp;:</p>

    <ul>
      <li>Toujours positionner les dfinitions relatives au serveur
      principal avant toute dfinition <code>VirtualHost</code>.
      (Ceci amliore grandement la lisibilit de la configuration
      -- la manire dont la configuration est interprte aprs la
      lecture des fichiers ne met pas en vidence le fait que les
      dfinitions positionnes avant et surtout aprs les serveurs
      virtuels peuvent impacter le fonctionnement de tous les
      serveurs virtuels.)</li>

      <li>Toujours regrouper les dfinitions <code>NameVirtualHost</code>
      et <code>VirtualHost</code> correspondantes
      dans la configuration pour une meilleure lisibilit.</li>

      <li>viter les <code>ServerPaths</code> qui sont prfixes
      d'autres <code>ServerPaths</code>. Si cela ne peut tre vit,
      veillez  ce que le serveur virtuel contenant le prfixe le plus
      long (donc le plus prcis) apparaisse dans le fichier de
      configuration avant le plus court. (<em>par exemple</em>,
      "ServerPath /abc" est  spcifier aprs  "ServerPath /abc/def").</li>
    </ul>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/vhosts/details.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/vhosts/details.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/vhosts/details.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/vhosts/details.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2010 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>