<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Les drapeaux du module Apache mod_rewrite - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Rewrite</a></div><div id="page-content"><div id="preamble"><h1>Les drapeaux du module Apache mod_rewrite</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/flags.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/flags.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>

<p>Ce document dcrit les drapeaux disponibles dans la directive
<code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code>, en fournissant
des explications dtailles et des exemples. Vous n'y trouverez pas
une liste exhaustive de tous les drapeaux disponibles, c'est pourquoi
vous devez aussi consulter la documentation de rfrence.</p>
</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#introduction">Introduction</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flags">Les drapeaux</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="../mod/mod_rewrite.html">Documentation du module</a></li><li><a href="tech.html">Dtails techniques</a></li><li><a href="rewrite_guide.html">Guide de rcriture - exemples
utiles</a></li><li><a href="rewrite_guide_advanced.html">Guide de rcriture
avance - exemples utiles avancs</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="introduction" id="introduction">Introduction</a></h2>
<p>Le comportement des directives <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> peut tre modifi par un ou
plusieurs drapeaux. Les drapeaux sont situs en fin de rgle, entours
de crochets, et spars le cas chant par des virgules.</p>
<div class="example"><p><code>
RewriteRule modle cible [drapeau1,drapeau2,drapeau3]
</code></p></div>

<p>Les drapeaux ont tous une forme courte, comme <code>CO</code>, ainsi
qu'une forme longue, comme <code>cookie</code>. Certains drapeaux
peuvent avoir un ou plusieurs arguments. Les drapeaux sont insensibles 
la casse.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flags" id="flags">Les drapeaux</a></h2>

<p>Chaque drapeau possde une forme longue et une forme courte. Bien que
la forme courte soit la plus couramment utilise, nous vous recommandons
de vous familiariser avec les drapeaux sous leur forme longue, afin de
bien mmoriser ce que chaque drapeau est suppos faire.</p>

<p>Chaque drapeau disponible est prsent ici, avec un exemple
d'utilisation.</p>

<h3><a name="flag_b" id="flag_b">B</a></h3>
<p>Avec le drapeau [B], la directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> chappe les caractres
non-alphanumriques avant d'appliquer la transformation.</p>


<h3><a name="flag_c" id="flag_c">C|chain</a></h3>
<p>Le drapeau [C] ou [chain] indique que la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> est chane avec la
suivante. Autrement dit, si la rgle s'applique, elle est traite
normalement et passe le contrle  la rgle suivante. Par contre, si
elle ne s'applique pas, la rgle suivante, ainsi que toutes les rgles
chanes qui suivent, seront sautes.</p>



<h3><a name="flag_co" id="flag_co">CO|cookie</a></h3>
<p>Le drapeau [CO], ou [cookie], vous permet de dfinir un cookie
lorsqu'une rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code>
s'applique. Il possde cinq arguments dont trois sont obligatoires et
deux optionnels.</p>
<p>Vous devez dclarer un nom et une valeur pour dfinir le cookie,
ainsi que le domaine pour lequel vous souhaitez que le cookie soit
valide. Vous pouvez aussi dfinir la dure de vie du cookie, ainsi que
le chemin pour lequel il doit tre renvoy.</p>
<p>Par dfaut, la dure de vie du cookie correspond  la session du
navigateur en cours.</p>
<p>Par dfaut, le chemin pour lequel le cookie sera valide est "/" -
c'est  dire, pour tout le site web.</p>
<p>Voici un exemple :</p>

<div class="example"><p><code>
RewriteEngine On<br />
RewriteRule ^/index\.html - [CO=frontdoor:yes:.apache.org:1440:/]
</code></p></div>

<p>Dans l'exemple ci-dessus, la rgle ne rcrit
pas la requte. La cible de rcriture "-"
indique  mod_rewrite de transmettre la requte sans
modification. Par contre, il
dfinit un cookie nomm 'frontdoor' avec une valeur 'yes'. Le cookie est
valide pour tout hte situ dans le domaine <code>.apache.org</code>. Sa
dure de vie est limite  1440 minutes (24 heures), et il sera renvoy
pour tous les URIs.</p>



<h3><a name="flag_dpi" id="flag_dpi">DPI|discardpathinfo</a></h3>
<p>Avec le drapeau DPI, la partie PATH_INFO de l'URI
rcrit est supprime.</p>




<h3><a name="flag_e" id="flag_e">E|env</a></h3>
<p>Avec le drapeau [E], ou [env], vous pouvez dfinir la valeur d'une
variable d'environnement. Notez que certaines variables d'environnement
peuvent tre dfinies aprs le traitement de la rgle, annulant par
la-mme ce que vous avez dfini. Voir le <a href="../env.html">document
sur les variables d'environnement</a> pour plus de dtails sur le
fonctionnement des variables d'environnement.</p>

<p>L'exemple suivant dfinit une variable d'environnement nomme 'image'
avec une valeur de '1' si l'URI de la requte correspond  un fichier
image. Cette variable d'environnement est ensuite utilise pour exclure
une telle requte du journal des accs.</p>

<div class="example"><p><code>
RewriteRule \.(png|gif|jpg) - [E=image:1]<br />
CustomLog logs/access_log combined env=!image
</code></p></div>

<p>Notez que le mme effet peut tre obtenu  l'aide de la directive
<code class="directive"><a href="../mod/mod_setenvif.html#setenvif">SetEnvIf</a></code>. Cette technique
est prsente  titre d'exemple et non de recommandation.</p>


<h3><a name="flag_f" id="flag_f">F|forbidden</a></h3>
<p>L'utilisation du drapeau [F] permet de faire envoyer par Apache au
client un code de statut "403 Forbidden". Le mme effet peut tre obtenu 
l'aide de la directive <code class="directive"><a href="../mod/mod_access.html#deny">Deny</a></code>,
mais ce drapeau offre plus de souplesse dans l'attribution d'un statut
Forbidden.</p>

<p>La rgle suivante va interdire la tlchargement de fichiers
<code>.exe</code> depuis votre serveur.</p>

<div class="example"><p><code>
RewriteRule \.exe - [F]
</code></p></div>

<p>Cet exemple utilise la syntaxe "-" pour la cible de rcriture, ce
qui signifie que l'URI de la requte n'est pas modifi. Il n'y a aucune
raison de rcrire un URI, si vous avez l'intention d'interdire la
requte.</p>



<h3><a name="flag_g" id="flag_g">G|gone</a></h3>
<p>Le drapeau [G] permet de faire envoyer par Apache un code de statut
"410 Gone" avec la rponse. Ce code indique qu'une ressource qui tait
disponible auparavant ne l'est plus actuellement.</p>

<p>Comme dans le cas du drapeau [F], on utilise en gnral la syntaxe
"-" pour la cible de rcriture lorsqu'on utilise le drapeau [G] :</p>

<div class="example"><p><code>
RewriteRule ancienne-ressource - [G,NC]
</code></p></div>


<h3><a name="flag_h" id="flag_h">H|handler</a></h3>
<p>Force le traitement de la requte rsultante par le gestionnaire
spcifi. Par exemple, on peut utiliser ce drapeau pour forcer
l'interprtation de tous les fichiers sans extension par le gestionnaire
php :</p>

<div class="example"><p><code>
RewriteRule !\. - [H=application/x-httpd-php]
</code></p></div>

<p>
L'expression rationnelle ci-dessus - <code>!\.</code> - correspond 
toute requte qui ne contient pas le caractre <code>.</code>.
</p>
<p>On peut aussi utiliser ce drapeau pour forcer l'utilisation d'un
certain gestionnaire en fonction de certaines conditions. Par exemple,
l'extrait suivant utilis dans un contexte de niveau serveur permet de
faire en sorte que les fichiers <code>.php</code> soient
<em>affichs</em> par <code>mod_php</code> dans le cas o ils font
l'objet d'une requte avec l'extension <code>.phps</code> :
</p>

<div class="example"><p><code>
RewriteRule ^(/source/.+\.php)s$ $1 [H=application/x-httpd-php-source]
</code></p></div>

<p>L'expression rationnelle ci-dessus -
<code>^(/source/.+\.php)s$</code> - va correspondre  toute requte qui
dbutera par <code>/source/</code>, continuera par 1 ou n caractres
puis par <code>.phps</code>. La rfrence arrire $1 fait rfrence  la
correspondance capture entre parenthses de l'expression
rationnelle.</p>




<h3><a name="flag_l" id="flag_l">L|last</a></h3>
<p>Lorsque le drapeau [L] est prsent, <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>
arrte le traitement du jeu de rgles. Cela signifie dans la plupart des
situations que si la rgle s'applique, aucune autre rgle ne sera
traite.</p>

<p>Si vous utilisez des rgles <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> dans des fichiers
<code>.htaccess</code> ou des sections <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>, il est important d'avoir quelques
notions sur la manire dont les rgles sont traites. Pour simplifier,
une fois les rgles traites, la requte rcrite est passe  nouveau
au moteur d'interprtation des URLs afin que ce dernier puisse la
traiter. Il est possible qu'au cours du traitement de la requte
rcrite, le fichier <code>.htaccess</code> ou la section <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> soient  nouveau
rencontrs, entranant un nouveau traitement du jeu de rgles depuis le
dbut. Cette situation se prsente le plus souvent lorsqu'une des rgles
provoque une redirection - interne ou externe - ce qui rinitialise le
traitement de la requte.</p>

<p>Si vous utilisez des directives <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> dans un de ces contextes,
il importe par consquent de prvoir explicitement des tapes permettant
d'viter un bouclage infini sur les rgles,
et de ne pas compter seulement sur
le drapeau [L] pour terminer l'excution d'une srie de rgles, comme
dcrit ci-dessous.</p>

<p>Dans l'exemple donn ici, toute requte est rcrite en
<code>index.php</code>, la requte originale tant ajoute comme chane
de requte en argument  <code>index.php</code> ; cependant, la
directive <code class="directive"><a href="../mod/mod_rewrite.html#rewritecond">RewriteCond</a></code> permet de s'assurer que si
la requte concerne dj <code>index.php</code>, la directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> sera saute.</p>

<div class="example"><p><code>
RewriteCond %{REQUEST_URI} !=index\.php<br />
RewriteRule ^(.*) index.php?req=$1 [L]
</code></p></div>


<h3><a name="flag_n" id="flag_n">N|next</a></h3>
<p>Le drapeau [N] provoque un redmarrage du traitement des rgles
depuis le dbut ;  utiliser avec prcautions car il peut provoquer un
bouclage infini.
</p>
<p>
Le drapeau [Next] peut servir, par exemple,
 remplacer de manire rptitive
une chane de caractre ou une lettre dans une requte. Dans l'exemple
suivant, chaque occurence de A sera remplace par B dans la requte, et
ceci jusqu'il n'y ait plus de A  remplacer.
</p>

<div class="example"><p><code>
RewriteRule (.*)A(.*) $1B$2 [N]
</code></p></div>

<p>Vous pouvez vous reprsenter ce traitement comme une boucle
<code>while</code> : tant que le modle de la rgle correspond (c'est 
dire, tant que l'URI contient un <code>A</code>),
effectuer la substitution (c'est  dire, remplacer le <code>A</code> par
un <code>B</code>).</p>



<h3><a name="flag_nc" id="flag_nc">NC|nocase</a></h3>
<p>Avec le drapeau [NC], le modle de la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> est compar  la requte de
manire insensible  la casse. C'est  dire que cette comparaison
s'effectue sans tenir compte des majuscules/minuscules dans l'URI
compar.</p>

<p>Dans l'exemple suivant, toute requte pour un fichier image sera
transmise par Apache  votre serveur d'images ddi. La correspondance est
insensible  la casse, si bien que par exemple, <code>.jpg</code> aussi
bien que <code>.JPG</code> seront accepts.</p>

<div class="example"><p><code>
RewriteRule (.*\.(jpg|gif|png))$ http://images.example.com$1 [P,NC]
</code></p></div>


<h3><a name="flag_ne" id="flag_ne">NE|noescape</a></h3>
<p>Par dfaut, les caractres spciaux, comme <code>&amp;</code> et
<code>?</code>, sont convertis en leur quivalent
hexadcimal. Le drapeau [NE] permet d'viter cette conversion.
</p>

<div class="example"><p><code>
RewriteRule ^/ancre/(.+) /grosse-page.html#$1 [NE,R]
</code></p></div>

<p>
Dans l'exemple ci-dessus, <code>/anchor/xyz</code> est rcrit en
<code>/bigpage.html#xyz</code>. En l'absence du drapeau [NE], le #
aurait t converti en son quivalent hexadcimal, <code>%23</code>, ce
qui aurait provoqu un code d'erreur "404 Not Found".
</p>



<h3><a name="flag_ns" id="flag_ns">NS|nosubreq</a></h3>
<p>Le drapeau [NS] empche la rgle de s'appliquer aux sous-requtes.
Par exemple, une page incluse au moyen d'une SSI (Server
Side Include) est une sous-requte, et vous ne voudrez peut-tre pas que
la rcriture s'applique  ces sous-requtes.</p>

<p>
Les images, scripts java, ou fichiers css, chargs en tant que partie
d'une page html, ne sont pas des sous-requtes - le navigateur les
appelle sous forme de requtes HTTP  part entire.
</p>


<h3><a name="flag_p" id="flag_p">P|proxy</a></h3>
<p>L'utilisation du drapeau [P] entrane le traitement de la requte par
le module <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>, et ceci via une requte de
mandataire. Par exemple, si vous voulez que toutes les requtes d'images
soient traites par un serveur d'images annexe, vous pouvez utiliser
une rgle de ce style :</p>

<div class="example"><p><code>
RewriteRule (.*)\.(jpg|gif|png) http://images.example.com$1.$2 [P]
</code></p></div>

<p>L'utilisation du drapeau [P] provoque aussi l'effet du drapeau [L] -
autrement dit, la requte est immdiatement envoye au mandataire, et
toute rgle ultrieure sera ignore.</p>



<h3><a name="flag_pt" id="flag_pt">PT|passthrough</a></h3>

<p>
Par dfaut, la cible (ou chane de substitution) d'une rgle
RewriteRule est sense tre un chemin de fichier. Avec le drapeau [PT],
par contre, elle est traite comme un URI. Autrement dit, avec le
drapeau [PT], le rsultat de la rgle  <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> est pass  nouveau au
systme de mise en correspondance des URLs avec le systme de fichiers,
de faon  ce que les systmes de mise en correspondance bass sur les
chemins de fichiers, comme la directive <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code>, par exemple, puissent avoir une
chance d'accomplir leur tche.
</p>

<p>
Si par exemple, vous avez un <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code> pour /icons, et une rgle  <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> qui renvoie vers /icons,
vous devez utiliser le drapeau [PT] pour tre sr que l'<code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code> sera bien valu.
</p>

<div class="example"><p><code>
Alias /icons /usr/local/apache/icons<br />
RewriteRule /pics/(.+)\.jpg /icons/$1.gif [PT]
</code></p></div>

<p>
Dans l'exemple prcdent, en l'absence du drapeau [PT], l'Alias aurait
t ignor, ce qui aurait provoqu une erreur 'File not found'.
</p>



<h3><a name="flag_qsa" id="flag_qsa">QSA|qsappend</a></h3>
<p>
Quand l'URI de remplacement contient une chane de requte, le
comportement par dfaut de la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> est de supprimer la <code>
query string</code> (il s'agit des paramtres ventuellement passs dans l'URL aprs le
caractre <code>?</code>, usuellement pour les formulaires traits par la
mthode HTTP <code>GET</code>) existante, et de la remplacer par celle nouvellement cre.
Avec le drapeau [QSA], les chanes de requte peuvent tre combines.
</p>

<p>Considrons la rgle suivante :</p>

<div class="example"><p><code>
RewriteRule /pages/(.+) /page.php?page=$1 [QSA]
</code></p></div>

<p>Avec le drapeau [QSA], une requte pour
<code>/pages/123?one=two</code> sera rcrite en
<code>/page.php?page=123&amp;one=two</code>. Sans le drapeau [QSA], la
mme requte sera rcrite en <code>/page.php?page=123</code> -
autrement dit, la chane de requte (<code>query string</code>) existante sera supprime.
</p>


<h3><a name="flag_r" id="flag_r">R|redirect</a></h3>
<p>
L'utilisation du drapeau [R] provoque l'envoi d'une redirection au
navigateur. Si une URL pleinement qualifie (FQDN - fully qualified domain name)
 est spcifie (c'est  dire incluant <code>http://nom-du-serveur/</code>),
 une redirection sera effectue vers cette adresse. Dans le cas contraire,
 c'est le nom du serveur local qui sera utilis pour gnrer l'URL envoye avec la
redirection.
</p>

<p>
Un code de statut entre 300 et 399 peut tre spcifi, le code 302 tant
utilis par dfaut si aucun code n'est spcifi.
</p>

<p>
Vous utiliserez presque toujours [R] en conjonction avec [L] (c'est 
dire [R,L]), car employ seul, le drapeau [R] prfixe l'URI avec
<code>http://cet-hte[:ce-port]</code>, mais passe ensuite cette adresse
 la rgle suivante, ce qui provoquera le plus souvent des
avertissements 'Invalid URI in request'.
</p>



<h3><a name="flag_s" id="flag_s">S|skip</a></h3>
<p>Le drapeau [S] sert  sauter des rgles que vous ne voulez pas voir
excuter. Ceci peut s'interprter comme une instruction
<code>goto</code>  dans votre jeu de rgles de rcriture. Dans
l'exemple suivant, nous ne voulons excuter la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> que si l'URI demand ne
correspond pas  un fichier existant.</p>

<div class="example"><p><code>
# La requte concerne-t-elle un fichier qui n'existe pas ?<br />
RewriteCond %{REQUEST_FILENAME} !-f<br />
RewriteCond %{REQUEST_FILENAME} !-d<br />
# Si c'est la cas, on saute les deux rgles de rcriture suivantes<br />
RewriteRule .? - [S=2]<br />
<br />
RewriteRule (.*\.gif) images.php?$1<br />
RewriteRule (.*\.html) docs.php?$1
</code></p></div>

<p>Cette technique trouve son utilit dans le fait qu'une directive
<code class="directive"><a href="../mod/mod_rewrite.html#rewritecond">RewriteCond</a></code> ne s'applique
qu' la rgle qui la suit immdiatement. Ainsi, si vous voulez
qu'une directive <code>RewriteCond</code> s'applique  plusieurs rgles
<code>RewriteRule</code>, vous pouvez utiliser le drapeau [Skip].</p>



<h3><a name="flag_t" id="flag_t">T|type</a></h3>
<p>Dfinit le type MIME de la rponse rsultante renvoye. L'effet est
identique  celui de la directive <code class="directive"><a href="../mod/mod_mime.html#addtype">AddType</a></code>.</p>

<p>Par exemple, vous pouvez utiliser la technique suivante pour servir
du code source Perl en tant que plein texte, s'il est requis d'une
certaine manire :</p>

<div class="example"><p><code>
# Sert les fichier .pl en tant que plein texte<br />
RewriteRule \.pl$ - [T=text/plain]
</code></p></div>

<p>Ou encore, si vous possdez une camra qui produit des fichiers
images jpeg sans extension, vous pouvez forcer le renvoi de ces images
avec le type MIME correct en se basant sur le nom du fichier :</p>

<div class="example"><p><code>
# Les fichiers dont le nom contient 'IMG' sont des images jpg.<br />
RewriteRule IMG - [T=image/jpg]
</code></p></div>

<p>Notez cependant qu'il s'agit d'un exemple trivial, et que le problme
aurait pu tre rsolu en utilisant  la place la directive <code class="directive"><a href="../mod/core.html#filesmatch">&lt;FilesMatch&gt;</a></code>. Il faut toujours
envisager la possibilit d'une solution alternative  un problme avant
d'avoir recours  la rcriture, qui sera toujours moins efficace qu'une
solution alternative.</p>


</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/flags.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/flags.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2010 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>