<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Introduction au module Apache mod_rewrite - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Rewrite</a></div><div id="page-content"><div id="preamble"><h1>Introduction au module Apache mod_rewrite</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/intro.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/intro.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>

<p>Ce document est un complment  la <a href="../mod/mod_rewrite.html">documentation de rfrence</a> du module
<code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. Il dcrit les concepts de base dont la
connaissance est ncessaire pour l'utilisation de
<code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. D'autres documents entrent d'avantage dans
les dtails, mais celui-ci devrait aider le dbutant  se mouiller les
pieds.
</p>
</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#introduction">Introduction</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#regex">Expressions rationnelles</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewriterule">Les bases des rgles de rcriture</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flags">Drapeaux de rcriture</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewritecond">Conditions de rcriture</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewritemap">Tables de rcriture</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#htaccess">Fichiers .htaccess</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="../mod/mod_rewrite.html">Documentation du
module mod_rewrite</a></li><li><a href="remapping.html">Redirection and remise en
correspondance</a></li><li><a href="access.html">Contrle d'accs</a></li><li><a href="vhosts.html">Serveurs virtuels</a></li><li><a href="proxy.html">Mise en cache</a></li><li><a href="rewritemap.html">Utilisation de RewriteMap</a></li><li><a href="advanced.html">Techniques avances et conseils</a></li><li><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="introduction" id="introduction">Introduction</a></h2>
<p>Le module Apache <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> est un module puissant
et sophistiqu qui permet la rcriture des URLs. Grce  lui, vous
pouvez effectuer quasiment tous les types de rcriture d'URLs dont vous
avez besoin. Il est cependant assez complexe, et peut paratre
intimidant au dbutant. Certains ont aussi tendance  traiter les
rgles de rcriture comme des incantations magiques, et  les utiliser
sans vraiment comprendre leur manire d'agir.</p>

<p>Ce document a pour ambition d'tre suffisamment explicite pour
permettre la comprhension, et non la copie en aveugle, de ce qui suit.
</p>

<p>Gardez  l'esprit que de nombreuses tches de manipulation d'URLs
courantes n'ont pas besoin de la puissance et de la complexit de
<code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. Pour les tches simples, voir
<code class="module"><a href="../mod/mod_alias.html">mod_alias</a></code> et la documentation sur la <a href="../urlmapping.html">Mise en correspondance des URLs avec le
systme de fichiers</a>.</p>

<p>Enfin, avant de procder, assurez-vous d'avoir configur la directive
<code class="directive"><a href="../mod/mod_rewrite.html#rewritelog">RewriteLog</a></code>. Bien que ce
fichier journal puisse contenir une quantit impressionnante d'informations,
il s'avre indispensable pour le dbogage des problmes avec la
configuration de <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>, car il vous indiquera
exactement la manire dont chaque rgle est traite.</p>

<div class="note">
<p>On ne peut pas utiliser la directive RewriteLog dans les fichiers
.htaccess, car elle doit tre dfinie au niveau du fichier
de configuration du serveur principal.</p>
</div>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="regex" id="regex">Expressions rationnelles</a></h2>

<p>mod_rewrite utilise le vocabulaire des <a href="http://pcre.org/">Expressions rationnelles compatibles Perl</a>.
Ce document n'a pas pour prtention d'tre une rfrence dtaille des
expressions rationnelles. A cet effet, nous recommandons les <a href="http://pcre.org/pcre.txt">pages de manuel de PCRE</a>, la <a href="http://perldoc.perl.org/perlre.html">page de manuel des
expressions rationnelles Perl</a>, et l'ouvrage <a href="http://www.oreilly.com/catalog/regex2/index.html">Mastering
Regular Expressions, by Jeffrey Friedl</a>.</p>

<p>Dans ce document, nous avons pour but de vous fournir suffisamment de
vocabulaire des expressions rationnelles pour vous mettre le pied 
l'trier, sans tre dpass, en esprant que les directives <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> vous apparatront comme des
formules scientifiques, plutt que comme des incantations magiques.</p>

<h3><a name="regexvocab" id="regexvocab">Vocabulaire des expressions rationnelles</a></h3>

<p>Vous trouverez dans ce qui suit le minimum  connatre pour tre en
mesure d'crire des expressions rationnelles et des rgles <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code>. Ceci ne reprsente
certainement pas un vocabulaire des expressions rationnelles complet,
mais constitue un bon point de dpart, et devrait vous aider 
dchiffrer les expressions rationnelles simples, et  crire vos propres
expressions.</p>

<table>
<tr>
<th>Motif</th>
<th>Signification</th>
<th>Exemple</th>
</tr>

<tr><td><code>.</code></td><td>Correspond  tout caractre unique
</td><td><code>c.t</code> correspondra  <code>cat</code>,
<code>cot</code>, <code>cut</code>, etc.</td></tr>
<tr><td><code>+</code></td><td>Rpte le caractre de correspondance
prcdent une ou plusieurs fois</td>
<td><code>a+</code> correspond  <code>a</code>, <code>aa</code>,
<code>aaa</code>, etc.</td></tr>
<tr><td><code>*</code></td><td>Rpte le caractre de correspondance
prcdent zro ou plusieurs fois</td>
<td><code>a*</code> correspond  tout ce  quoi correspond
<code>a+</code>, mais correspond aussi  la chane vide.</td></tr>
<tr><td><code>?</code></td><td>Rend la correspondance optionnelle.</td><td>
<code>colou?r</code> correspondra  <code>color</code> et <code>colour</code>.</td>
</tr>
<tr><td><code>^</code></td><td>Appel ancrage, correspond au dbut de la
chane</td>
<td><code>^a</code> correspond  une chane qui commence par
<code>a</code></td></tr>
<tr><td><code>$</code></td><td>L'autre ancrage, correspond  la fin de
la chane.</td>
<td><code>a$</code> correspond  une chane qui se termine par
<code>a</code>.</td></tr>
<tr><td><code>( )</code></td><td>Regroupe plusieurs caractres en une
seule entit, et conserve une correspondance  des fins d'utilisation
dans une rfrence arrire.</td>
<td><code>(ab)+</code>
correspond  <code>ababab</code> -  savoir, le <code>+</code>
s'applique au groupe.
Pour plus de dtails sur les rfrences arrires, voir <a href="#InternalBackRefs">ci-dessous</a>.</td></tr>
<tr><td><code>[ ]</code></td><td>Une classe de caractres - correspond 
un des caractres de la classe</td>
<td><code>c[uoa]t</code> correspond  <code>cut</code>,
<code>cot</code> ou <code>cat</code>.</td></tr>
<tr><td><code>[^ ]</code></td><td>Ngation de la classe de caractres -
correspond  tout caractre ne faisant pas partie de la classe</td>
<td><code>c[^/]t</code> correspond  <code>cat</code> ou
<code>c=t</code> mais pas  <code>c/t</code></td></tr>
</table>

<p>Avec <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>, le caractre <code>!</code> peut
prfixer une expression rationnelle afin d'en exprimer la ngation.
Autrement dit, une chane ne correspondra que si elle ne correspond pas
 l'expression situe aprs le <code>!</code>.</p>



<h3><a name="InternalBackRefs" id="InternalBackRefs">Disponibilit des rfrences
arrires dans les expressions rationnelles</a></h3>

      <p>Vous devez vous souvenir d'une chose importante : chaque fois
      que vous utilisez des parenthses dans un <em>Modle</em> ou dans
      un des <em>modles de conditions</em>, des rfrences arrires
      sont cres en interne et peuvent tre rappeles via les chanes
      <code>$N</code> et <code>%N</code> (voir ci-dessous). Ces
      rfrences sont disponibles lors de la cration des chanes de
      <em>Substitution</em> et des <em>Chanes de test</em>. La
      figure 1
      montre  quels endroits les rfrences arrires sont suceptibles
      d'tre dveloppes, et illustre le flux des comparaisons
      effectues par les rgles RewriteRule et RewriteCond.</p>

<p class="figure">
      <img src="../images/rewrite_rule_flow.png" alt="Flux des comparaisons effectues par les rgles RewriteRule       et RewriteCond" /><br />
      <dfn>Figure 1 :</dfn> Le cheminement d'une rfrence arrire 
      travers une rgle.
</p>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="rewriterule" id="rewriterule">Les bases des rgles de rcriture</a></h2>
<p>Une rgle de rcriture <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> est constitue de trois
arguments spars par des espaces. Les arguments sont :</p>
<ol>
<li><var>Modle</var>: le modle des URLs auxquelles la rgle doit
s'appliquer;</li>
<li><var>Substitution</var>: vers quoi la requte correspondante doit tre
transforme;</li>
<li><var>[drapeaux]</var>: options affectant la requte rcrite.</li>
</ol>

<p>Le <var>Modle</var> est toujours une <a href="#regex">expression
rationnelle</a> compare au chemin de l'URL de la requte entrante (la
partie situe aprs le nom d'hte mais avant tout point d'interrogation
qui indique le dbut d'une chane de requte).</p>

<p class="figure">
      <img src="../images/syntax_rewriterule.png" alt="Syntaxe de la directive RewriteRule" /><br />
      <dfn>Figure 2 :</dfn> Syntaxe de la directive RewriteRule.
</p>

<p>La chane de <var>Substitution</var> peut, quant  elle, tre de
trois types :</p>

<dl>
<dt>Un chemin complet du systme de fichiers vers une ressource</dt>
<dd>
<div class="example"><p><code>
RewriteRule ^/jeux.* /usr/local/jeux/web
</code></p></div>
<p>Ceci peut faire correspondre une requte  toute localisation voulue de
votre systme de fichiers, un peu comme la directive <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code>.</p>
</dd>

<dt>Un chemin web vers une ressource</dt>
<dd>
<div class="example"><p><code>
RewriteRule ^/foo$ /bar
</code></p></div>
<p>Si la directive <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code> a
pour valeur <code>/usr/local/apache2/htdocs</code>, cette rgle va faire
correspondre les requtes pour <code>http://example.com/foo</code> au
chemin <code>/usr/local/apache2/htdocs/bar</code>.</p>
</dd>

<dt>Une URL absolue</dt>
<dd>
<div class="example"><p><code>
RewriteRule ^/produits/vues$ http://site2.example.com/voirproduits.html [R]
</code></p></div>
<p>Ceci informe le client qu'il doit effectuer une nouvelle requte vers
l'URL spcifie.</p>
</dd>
</dl>

<p>La chane de <var>Substitution</var> peut aussi contenir des
<em>rfrences arrires</em> vers des parties du chemin d'URL entrant
correspondant au <var>Modle</var>. Considrons ce qui suit :</p>
<div class="example"><p><code>
RewriteRule ^/produits/(.*)/view$ /var/web/produitsdb/$1
</code></p></div>
<p>La variable <code>$1</code> sera remplace par tout texte
correspondant  l'expression situe entre les parenthses dans le
<var>Modle</var>. Par exemple, une requte pour
<code>http://example.com/produits/r14df/vue</code> correspondra au
chemin <code>/var/web/produitsdb/r14df</code>.</p>

<p>S'il y a plus d'une expression entre parenthses, elle seront
accessibles selon leur ordre d'apparition via les variables
<code>$1</code>, <code>$2</code>, <code>$3</code>, etc...</p>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flags" id="flags">Drapeaux de rcriture</a></h2>
<p>Le comportement d'une rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> peut tre modifi par la
prsence d'un ou plusieurs drapeaux en fin de rgle. Par exemple, les
conditions de correspondance d'une rgle peuvent tre rendues
insensibles  la casse par la prsence du drapeau <code>[NC]</code> :
</p>
<div class="example"><p><code>
RewriteRule ^puppy.html petitchien.html [NC]
</code></p></div>

<p>Pour une liste des drapeaux disponibles, leurs significations, et des
exemples, voir le document <a href="flags.html">Drapeaux de
rcriture</a>.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="rewritecond" id="rewritecond">Conditions de rcriture</a></h2>
<p>Il est possible d'utiliser une ou plusieurs directives <code class="directive"><a href="../mod/mod_rewrite.html#rewritecond">RewriteCond</a></code> pour restreindre les types
de requtes auxquelles devra s'appliquer la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> suivante. Le premier
argument est une variable dcrivant une caractristique de la requte,
le second argument est une <a href="#regex">expression rationnelle</a>
qui doit correspondre  la variable, et un troisime argument optionnel
est une liste de drapeaux qui modifient la manire dont la
correspondance est value.</p>

<p class="figure">
      <img src="../images/syntax_rewritecond.png" alt="Syntaxe de la directive RewriteCond" /><br />
      <dfn>Figure 3 :</dfn> Syntaxe de la directive RewriteCond
</p>


<p>Par exemple, pour renvoyer toutes les requtes en provenance d'une
certaine tranche d'adresses IP vers un autre serveur, vous pouvez
utiliser :</p>
<div class="example"><p><code>
RewriteCond %{REMOTE_ADDR} ^10\.2\.<br />
RewriteRule (.*) http://intranet.example.com$1
</code></p></div>

<p>Si vous spcifiez plus d'une directive <code class="directive"><a href="../mod/mod_rewrite.html#rewritecond">RewriteCond</a></code>, ces directives
doivent toutes tre satisfaites pour que la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> suivante s'applique. Par exemple,
pour interdire les requtes qui contiennent le mot "hack" dans la chane
de requte, sauf si elles contiennent aussi un cookie contenant le mot
"go", vous pouvez utiliser :</p>
<div class="example"><p><code>
RewriteCond %{QUERY_STRING} hack<br />
RewriteCond %{HTTP_COOKIE} !go<br />
RewriteRule .* - [F]
</code></p></div>
<p>Notez que le point d'exclamation indique une correspondance ngative
; ainsi, la rgle n'est applique que si le cookie ne contient pas "go"</p>

<p>Les correspondances dans les expressions rationnelles contenues dans
les directives <code class="directive"><a href="../mod/mod_rewrite.html#rewritecond">RewriteCond</a></code>
peuvent constituer des parties de la chane de <var>Substitution</var>
de la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> via
les variables <code>%1</code>, <code>%2</code>, etc... Par
exemple, ce qui suit va diriger la requte vers un rpertoire diffrent
en fonction du nom d'hte utilis pour accder au site :</p>
<div class="example"><p><code>
RewriteCond %{HTTP_HOST} (.*)<br />
RewriteRule ^/(.*) /sites/%1/$1
</code></p></div>
<p>Si la requte concernait <code>http://example.com/foo/bar</code>,
alors <code>%1</code> contiendrait <code>example.com</code> et
<code>$1</code> contiendrait <code>foo/bar</code>.</p>



</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="rewritemap" id="rewritemap">Tables de rcriture</a></h2>

<p>La directive <code class="directive"><a href="../mod/mod_rewrite.html#rewritemap">RewriteMap</a></code>
permet en quelque sorte de faire appel  une fonction externe pour
effectuer la rcriture  votre place. Tout ceci est dcrit plus en
dtails dans la <a href="rewritemap.html">Documentation supplmentaire
sur RewriteMap</a>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="htaccess" id="htaccess">Fichiers .htaccess</a></h2>

<p>La rcriture est en gnral dfinie au niveau de la configuration du
serveur principal (en dehors de toute section <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>) ou dans une section  <code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>. Il s'agit l de la
manire la plus simple de mettre en oeuvre la rcriture et nous la
recommandons. Il est possible, cependant, de mettre en oeuvre la
rcriture au sein d'une section <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> ou d'un fichier <a href="../howto/htaccess.html"><code>.htaccess</code></a> ; ce type de
configuration est cependant plus complexe. Cette technique est appele
rcriture par rpertoire.</p>

<p>La principale diffrence avec les rcritures au niveau du serveur rside
dans le fait que le prfixe du chemin du rpertoire contenant le fichier
<code>.htaccess</code> est supprim avant la mise en correspondance dans
la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code>. De
plus, on doit utiliser la directive <code class="directive"><a href="../mod/mod_rewrite.html#rewritebase">RewriteBase</a></code> pour s'assurer que la
requte est correctement mise en correspondance.</p>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/intro.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/intro.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2010 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>