<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Hbergement virtuel de masse configur dynamiquement - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Hbergement virtuel</a></div><div id="page-content"><div id="preamble"><h1>Hbergement virtuel de masse configur dynamiquement</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/vhosts/mass.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/vhosts/mass.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/vhosts/mass.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/vhosts/mass.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>


    <p>Ce document propose une mthode performante pour servir un nombre
    quelconque d'htes virtuels avec le serveur web httpd Apache.
    </p>

</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#motivation">A qui ce document est-il destin ?</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#overview">Vue d'ensemble</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#simple">Mthode simple d'hbergement virtuel
dynamique</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#homepages">Un systme de pages d'accueil hberges
virtuellement</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#combinations">Utiliser plusieurs systmes
d'hbergement virtuel sur le mme serveur</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ipbased">Pour un hbergement virtuel par IP plus
efficace</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#simple.rewrite">Configuration de base pour un
hbergement virtuel dynamique utilisant
<code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code></a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#homepages.rewrite">Un systme de pages d'accueil qui
utilise<code>mod_rewrite</code></a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#xtra-conf">Utilisation d'un fichier de configuration
spar pour les serveurs virtuels</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="motivation" id="motivation">A qui ce document est-il destin ?</a></h2>

    <p>Les techniques dcrites ici vous concernent si votre
    <code>httpd.conf</code> contient de nombreuses sections
    <code>&lt;VirtualHost&gt;</code> trs semblables,
    dans le style :</p>

<div class="example"><p><code>
NameVirtualHost 111.22.33.44<br />
&lt;VirtualHost 111.22.33.44&gt;<br />
<span class="indent">
    ServerName                 www.customer-1.com<br />
    DocumentRoot        /www/hosts/www.customer-1.com/docs<br />
    ScriptAlias  /cgi-bin/  /www/hosts/www.customer-1.com/cgi-bin<br />
</span>
&lt;/VirtualHost&gt;<br />
&lt;VirtualHost 111.22.33.44&gt;<br />
<span class="indent">
    ServerName                 www.customer-2.com<br />
    DocumentRoot        /www/hosts/www.customer-2.com/docs<br />
    ScriptAlias  /cgi-bin/  /www/hosts/www.customer-2.com/cgi-bin<br />
</span>
&lt;/VirtualHost&gt;<br />
# bla bla bla<br />
&lt;VirtualHost 111.22.33.44&gt;<br />
<span class="indent">
    ServerName                 www.customer-N.com<br />
    DocumentRoot        /www/hosts/www.customer-N.com/docs<br />
    ScriptAlias  /cgi-bin/  /www/hosts/www.customer-N.com/cgi-bin<br />
</span>
&lt;/VirtualHost&gt;
</code></p></div>

    <p>L'ide de base consiste  remplacer toutes les configurations
    <code>&lt;VirtualHost&gt;</code> par un mcanisme qui les gnre
    dynamiquement. Ceci prsente certains avantages :</p>

    <ol>
      <li>Votre fichier de configuration est plus petit, ainsi Apache
      dmarre plus rapidement et consomme moins de mmoire.</li>

      <li>Pour ajouter des serveurs virtuels, il suffit de crer les
      rpertoires appropris dans le systme de fichiers et les entres
      dans le DNS - il n'est plus ncessaire de reconfigurer ou de
      redmarrer Apache.</li>
    </ol>

    <p>Le principal dsavantage rside dans le fait que vous ne pouvez
    pas dfinir un fichier journal diffrent pour chaque serveur
    virtuel. De toute faon, ce serait une mauvaise ide si vous avez de
    nombreux serveurs virtuels, car cela ncessiterait un nombre
    important de descripteurs de fichiers. Il est prfrable de
    rediriger les journaux via un pipe ou une pile fifo vers un
    programme, et faire en sorte que ce dernier distribue les journaux
    les concernant aux diffrents clients (Ce qui peut aussi servir 
    accumuler des donnes  des fins de statistiques, etc...).</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="overview" id="overview">Vue d'ensemble</a></h2>

    <p>Un serveur virtuel peut tre dfini par deux informations : son
    adresse IP, et le contenu de l'en-tte <code>Host:</code> de la
    requte HTTP. La technique d'hbergement virtuel dynamique de masse
    utilise ici consiste  insrer automatiquement ces informations
    dans le chemin du fichier  utiliser pour rpondre  la requte. On
    peut y parvenir assez facilement en utilisant
    <code class="module"><a href="../mod/mod_vhost_alias.html">mod_vhost_alias</a></code> avec Apache 2.0, mais on peut aussi
    utiliser <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. Par dfaut, ces deux modules
    sont dsactivs ; vous devez activer l'un d'eux lors de la
    compilation et de la configuration d'Apache si vous voulez utiliser
    cette technique.</p>

    <p>Certains paramtres doivent tre adapts pour que le serveur
    dynamique se prsente comme un serveur dynamique normal. Le plus
    important est le nom du serveur, qu'Apache utilise pour gnrer des
    URLs d'auto-rfrencement, etc... Il est dfini via la directive
    <code>ServerName</code>, et les CGIs peuvent s'y rfrer via la
    variable d'environnement <code>SERVER_NAME</code>. Sa vritable
    valeur utilise  l'excution est contrle par la dfinition de la
    directive
    <code class="directive"><a href="../mod/core.html#usecanonicalname">UseCanonicalName</a></code>. Avec
    <code>UseCanonicalName Off</code>, le nom du serveur correspond au
    contenu de l'en-tte <code>Host:</code> de la requte. Avec
    <code>UseCanonicalName DNS</code>, il est extrait d'une recherche
    DNS inverse sur l'adresse IP du serveur virtuel. La premire
    configuration est utilise pour l'hbergement virtuel dynamique par
    nom, et la deuxime pour l'hbergement virtuel dynamique par IP. Si
    Apache ne peut pas dterminer le nom du serveur, soit parce qu'il
    n'y a pas d'en-tte <code>Host:</code>, soit parce que la recherche
    DNS a chou, il prend en compte la valeur dfinie par la directive
    <code>ServerName</code>.</p>

    <p>L'autre paramtre  adapter est la racine des documents (dfinie
    via la directive <code>DocumentRoot</code> et disponible pour les
    CGIs via la variable d'environnement <code>DOCUMENT_ROOT</code>).
    Dans une configuration classique, il est utilis par le module core
    pour faire correspondre les URIs aux noms de fichiers, mais lorsque
    la configuration du serveur comporte des serveurs virtuels, ce
    traitement doit tre pris en charge par un autre module (soit
    <code>mod_vhost_alias</code>, soit <code>mod_rewrite</code>), qui
    utilise un mthode de correspondance diffrente. Aucun de ces
    modules ne se chargeant de dfinir la variable d'environnement
    <code>DOCUMENT_ROOT</code>, si des CGIs ou des documents SSI
    doivent en faire usage, ils obtiendront une valeur errone.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="simple" id="simple">Mthode simple d'hbergement virtuel
dynamique</a></h2>

    <p>Cet extrait de fichier <code>httpd.conf</code> implmente
    l'hbergement virtuel dcrit dans la section <a href="#motivation"> qui ce document est-il destin ?</a> ci-dessus,
    mais selon une mthode gnrique utilisant
    <code>mod_vhost_alias</code>.</p>

<div class="example"><p><code>
# extrait le nom du serveur de l'en-tte Host:<br />
UseCanonicalName Off<br />
<br />
# ce format de journal peut tre clat en journaux par serveur virtuel
#  l'aide du premier champ<br />
LogFormat "%V %h %l %u %t \"%r\" %s %b" vcommon<br />
CustomLog logs/access_log vcommon<br />
<br />
# inclut le nom du serveur dans les noms de fichiers ressources
# ncessaires aux traitements des requtes<br />
VirtualDocumentRoot /www/hosts/%0/docs<br />
VirtualScriptAlias  /www/hosts/%0/cgi-bin
</code></p></div>

    <p>Pour changer cette configuration en solution de serveur virtuel
    par IP, il suffit de remplacer <code>UseCanonicalName
    Off</code> par <code>UseCanonicalName DNS</code>. Le nom du serveur
    insr dans le nom de fichier sera alors dduit de l'adresse IP du
    serveur virtuel.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="homepages" id="homepages">Un systme de pages d'accueil hberges
virtuellement</a></h2>

    <p>Il s'agit d'une adaptation du systme ci-dessus, ajust pour un
    serveur de pages d'accueil de FAI. Avec une configuration un peu
    plus complique, on peut extraire des sous-chanes de caractres du
    nom du serveur pour les utiliser dans le nom de fichier afin, par
    exemple, de dfinir <code>/home/user/</code> comme emplacement des
    documents pour <code>www.user.isp.com</code>. Un seul rpertoire
    <code>cgi-bin</code> suffit pour l'ensemble des
    serveurs virtuels.</p>

<div class="example"><p><code>
# les directives prliminaires sont identiques  celles de l'exemple
# ci-dessus ; il vient ensuite :<br />
<br />
# insertion d'une partie du nom du serveur dans les noms de fichiers<br />
VirtualDocumentRoot /www/hosts/%2/docs<br />
<br />
# rpertoire cgi-bin unique<br />
ScriptAlias  /cgi-bin/  /www/std-cgi/<br />
</code></p></div>

    <p>Vous trouverez des exemples plus labors d'utilisation de la
    directive <code>VirtualDocumentRoot</code> dans la documentation du
    module <code class="module"><a href="../mod/mod_vhost_alias.html">mod_vhost_alias</a></code>.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="combinations" id="combinations">Utiliser plusieurs systmes
d'hbergement virtuel sur le mme serveur</a></h2>

    <p>Moyennant une configuration un peu plus complique, vous pouvez
    contrler la porte des diffrentes configurations d'hbergement
    virtuel  l'aide des directives <code>&lt;VirtualHost&gt;</code>
    normales d'Apache. Par exemple, on peut associer une adresse IP pour
    les pages d'accueil des clients en gnral, et une autre pour les
    clients commerciaux avec la configuration suivante. Cette
    configuration peut bien entendu tre combine avec les sections
    <code>&lt;VirtualHost&gt;</code> conventionnelles.</p>

<div class="example"><p><code>
UseCanonicalName Off<br />
<br />
LogFormat "%V %h %l %u %t \"%r\" %s %b" vcommon<br />
<br />
&lt;Directory /www/commercial&gt;<br />
<span class="indent">
    Options FollowSymLinks<br />
    AllowOverride All<br />
</span>
&lt;/Directory&gt;<br />
<br />
&lt;Directory /www/homepages&gt;<br />
<span class="indent">
    Options FollowSymLinks<br />
    AllowOverride None<br />
</span>
&lt;/Directory&gt;<br />
<br />
&lt;VirtualHost 111.22.33.44&gt;<br />
<span class="indent">
    ServerName www.commercial.isp.com<br />
    <br />
    CustomLog logs/access_log.commercial vcommon<br />
    <br />
    VirtualDocumentRoot /www/commercial/%0/docs<br />
    VirtualScriptAlias  /www/commercial/%0/cgi-bin<br />
</span>
&lt;/VirtualHost&gt;<br />
<br />
&lt;VirtualHost 111.22.33.45&gt;<br />
<span class="indent">
    ServerName www.homepages.isp.com<br />
    <br />
    CustomLog logs/access_log.homepages vcommon<br />
    <br />
    VirtualDocumentRoot /www/homepages/%0/docs<br />
    ScriptAlias         /cgi-bin/ /www/std-cgi/<br />
</span>
&lt;/VirtualHost&gt;
</code></p></div>

<div class="note">
	<h3>Note</h3>
	<p>Si le premier bloc VirtualHost ne comporte <em>pas</em> de
	directive <code class="directive"><a href="../mod/core.html#servername">ServerName</a></code>, c'est
	le nom issu d'une recherche DNS inverse  partir de l'adresse IP
	du serveur virtuel qui sera utilis. Si ce nom ne correspond pas
	 celui que vous voulez utiliser, vous pouvez ajouter une entre
	de remplacement (<code>ServerName
	none.example.com</code>) pour viter ce comportement.</p>
</div>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="ipbased" id="ipbased">Pour un hbergement virtuel par IP plus
efficace</a></h2>

    <p>Les changements de configuration suggrs pour transformer <a href="#simple">le premier exemple</a> en hbergement virtuel par IP
    conduisent  une configuration peu efficace. Chaque requte
    ncessite une nouvelle recherche DNS. Pour viter cette surcharge de
    travail, le systme de fichiers peut tre organis pour correspondre
    aux adresses IP, plutt qu'aux noms de serveurs, supprimant par
    la-mme la ncessit d'une recherche DNS. La journalisation doit
    aussi tre adapte pour fonctionner sur un tel systme.</p>

<div class="example"><p><code>
# obtention du nom du serveur par recherche DNS inverse
# sur l'adresse IP<br />
UseCanonicalName DNS<br />
<br />
# insertion de l'adresse IP dans les journaux afin de pouvoir les
# clater<br />
LogFormat "%A %h %l %u %t \"%r\" %s %b" vcommon<br />
CustomLog logs/access_log vcommon<br />
<br />
# insertion de l'adresse IP dans les noms de fichiers<br />
VirtualDocumentRootIP /www/hosts/%0/docs<br />
VirtualScriptAliasIP  /www/hosts/%0/cgi-bin<br />
</code></p></div>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="simple.rewrite" id="simple.rewrite">Configuration de base pour un
hbergement virtuel dynamique utilisant
<code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code></a></h2>

    <p>Cet extrait de <code>httpd.conf</code> fournit le mme service
    que le <a href="#simple">premier exemple</a>. La premire moiti est
    trs similaire  sa contre-partie du <a href="#simple">premier
    exemple</a>, mis  part quelques changements  des fins de
    compatibilit ascendante et ncessaires au bon fonctionnement de la
    partie concernant <code>mod_rewrite</code> ; la seconde moiti
    configure <code>mod_rewrite</code> pour l'accomplissement du travail
    proprement dit.</p>

    <p>Cet exemple comporte quelques astuces assez spciales : par
    dfaut, <code>mod_rewrite</code> effectue son traitement avant les
    autres modules de transformation d'URI (<code>mod_alias</code>
    etc...) - ainsi, si vous voulez utiliser ces modules, il faut en
    tenir compte dans la configuration de <code>mod_rewrite</code>. De
    mme, l'implmentation d'un serveur virtuel dynamique quivalent 
    <code>ScriptAlias</code> demande une certaine manipulation.</p>

<div class="example"><p><code>
# obtention du nom du serveur par la valeur de l'en-tte Host:<br />
UseCanonicalName Off<br />
<br />
# journaux pouvant tre clats en journaux par serveurs virtuels<br />
LogFormat "%{Host}i %h %l %u %t \"%r\" %s %b" vcommon<br />
CustomLog logs/access_log vcommon<br />
<br />
&lt;Directory /www/hosts&gt;<br />
<span class="indent">
    # ExecCGI est ici ncessaire car nous ne pouvons pas forcer
    # l'excution des CGI de la manire dont ScriptAlias le fait<br />
    Options FollowSymLinks ExecCGI<br />
</span>
&lt;/Directory&gt;<br />
<br />
# et maintenant, nous entrons dans le vif du sujet<br />
<br />
RewriteEngine On<br />
<br />
# un nom de serveur dduit de l'en-tte Host: dans pratiquement tous les
# cas<br />
RewriteMap  lowercase  int:tolower<br />
<br />
## traitement des documents normaux en premier:<br />
# permet le fonctionnement de "Alias /icons/" -  rpter pour les
# autres aliases<br />
RewriteCond  %{REQUEST_URI}  !^/icons/<br />
# permet le fonctionnement des CGIs<br />
RewriteCond  %{REQUEST_URI}  !^/cgi-bin/<br />
# la petite manipulation magique<br />
RewriteRule  ^/(.*)$  /www/hosts/${lowercase:%{SERVER_NAME}}/docs/$1<br />
<br />
## on s'occupe maintenant des CGIs - on doit imposer l'utilisation d'un
# gestionnaire<br />
RewriteCond  %{REQUEST_URI}  ^/cgi-bin/<br />
RewriteRule  ^/(.*)$  /www/hosts/${lowercase:%{SERVER_NAME}}/cgi-bin/$1  [H=cgi-script]<br />
<br />
# c'est tout !
</code></p></div>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="homepages.rewrite" id="homepages.rewrite">Un systme de pages d'accueil qui
utilise<code>mod_rewrite</code></a></h2>

    <p>Il s'agit d'une variante qui permet d'obtenir le mme rsultat
    que le <a href="#homepages">deuxime exemple</a>.</p>

<div class="example"><p><code>
RewriteEngine on<br />
<br />
RewriteMap   lowercase  int:tolower<br />
<br />
# permet l'excution des CGIs<br />
RewriteCond  %{REQUEST_URI}  !^/cgi-bin/<br />
<br />
# vrifie la validit du nom du serveur pour le bon fonctionnement de la
# rgle RewriteRule<br />
RewriteCond  ${lowercase:%{SERVER_NAME}}  ^www\.[a-z-]+\.isp\.com$<br />
<br />
# ajoute le nom du serveur virtuel comme prfixe  l'URI<br />
# le drapeau [C] signifie que la rcriture suivante doit tre effectue
# sur le rsultat de la rgle courante<br />
RewriteRule  ^(.+)  ${lowercase:%{SERVER_NAME}}$1  [C]<br />
<br />
# et maintenant, on cre le vritable nom de fichier<br />
RewriteRule  ^www\.([a-z-]+)\.isp\.com/(.*) /home/$1/$2<br />
<br />
# dfinition du rpertoire des CGIs global<br />
ScriptAlias  /cgi-bin/  /www/std-cgi/
</code></p></div>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="xtra-conf" id="xtra-conf">Utilisation d'un fichier de configuration
spar pour les serveurs virtuels</a></h2>

    <p>Cette mthode utilise des fonctionnalits de
    <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> plus avances pour venir  bout de la
    traduction d'un serveur virtuel en une racine de documents,  partir
    d'un fichier de configuration spar. Elle procure d'avantage de
    souplesse, mais ncessite une configuration
    un peu plus complique.</p>

    <p>Le fichier <code>vhost.map</code> doit se prsenter sous cette
    forme :</p>

<div class="example"><p><code>
www.customer-1.com  /www/customers/1<br />
www.customer-2.com  /www/customers/2<br />
# ...<br />
www.customer-N.com  /www/customers/N<br />
</code></p></div>

    <p>Le fichier <code>httpd.conf</code> doit contenir les lignes
    suivantes :</p>

<div class="example"><p><code>
RewriteEngine on<br />
<br />
RewriteMap   lowercase  int:tolower<br />
<br />
# dfinition du fichier de correspondances<br />
RewriteMap   vhost      txt:/www/conf/vhost.map<br />
<br />
# traite les alias comme prcdemment<br />
RewriteCond  %{REQUEST_URI}               !^/icons/<br />
RewriteCond  %{REQUEST_URI}               !^/cgi-bin/<br />
RewriteCond  ${lowercase:%{SERVER_NAME}}  ^(.+)$<br />
# une nouvelle mise en correspondance par fichier<br />
RewriteCond  ${vhost:%1}                  ^(/.*)$<br />
RewriteRule  ^/(.*)$                      %1/docs/$1<br />
<br />
RewriteCond  %{REQUEST_URI}               ^/cgi-bin/<br />
RewriteCond  ${lowercase:%{SERVER_NAME}}  ^(.+)$<br />
RewriteCond  ${vhost:%1}                  ^(/.*)$<br />
RewriteRule  ^/(.*)$                      %1/cgi-bin/$1 [H=cgi-script]
</code></p></div>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/vhosts/mass.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/vhosts/mass.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/vhosts/mass.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/vhosts/mass.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2010 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>