<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_access_compat - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_access_compat</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_access_compat.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_access_compat.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_access_compat.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Autorisations de groupe  base de nom d'hte (nom ou
adresse IP)</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>access_compat_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_access_compat.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible dans la version 2.3 du serveur HTTP Apache
 des fins de compatibilit
avec les prcdentes versions d'Apache httpd 2.x. Les directives fournies par
ce module sont devenues obsoltes depuis la refonte d'authz. Voir
<code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code></td></tr></table>
<h3>Sommaire</h3>

    <p>Les directives fournies par le module
    <code class="module"><a href="../mod/mod_access_compat.html">mod_access_compat</a></code> s'utilisent dans les sections
    <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>,
    <code class="directive"><a href="../mod/core.html#files">&lt;Files&gt;</a></code> et
    <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code>, ainsi
    que dans les fichiers <code><a href="core.html#accessfilename">.htaccess</a></code> et permettent
    de contrler l'accs  certaines parties du serveur. On peut
    contrler cet accs en fonction du nom d'hte du client, de son
    adresse IP ou d'autres caractristiques de la requte, telles
    qu'elles sont enregistres dans les <a href="../env.html">variables
    d'environnement</a>. Les directives <code class="directive"><a href="#allow">Allow</a></code> et <code class="directive"><a href="#deny">Deny</a></code> permettent de spcifier
    quels clients sont ou ne sont pas autoriss  accder au serveur,
    alors que la directive <code class="directive"><a href="#order">Order</a></code> dfinit le statut
    d'accs par dfaut, et dtermine la manire dont les directives
    <code class="directive"><a href="#allow">Allow</a></code> et
    <code class="directive"><a href="#deny">Deny</a></code> interagissent
    entre elles.</p>

    <p>Les restrictions d'accs  base de nom d'hte et
    l'authentification  base de mot de passe peuvent tre implmentes
    simultanment. Dans ce cas, on utilise la directive <code class="directive"><a href="#satisfy">Satisfy</a></code> pour dterminer la
    manire dont ces deux modes de restrictions interagissent.</p>

    <div class="warning"><h3>Note</h3>
      <p>Les directives fournies par le module
      <code class="module"><a href="../mod/mod_access_compat.html">mod_access_compat</a></code> sont devenues obsoltes depuis
      la refonte d'authz. Voir <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code>.</p>
    </div>

    <p>En gnral, les directives de restriction d'accs s'appliquent 
    toutes les mthodes d'accs (<code>GET</code>, <code>PUT</code>,
    <code>POST</code>, etc...). C'est d'ailleurs ce que l'on souhaite
    dans la plupart des cas. Il est cependant possible de restreindre
    certaines mthodes, alors que les autres mthodes ne se verront
    impose aucune restriction, en regroupant les directives 
    l'intrieur d'une section <code class="directive"><a href="../mod/core.html#limit">&lt;Limit&gt;</a></code>.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#allow">Allow</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#deny">Deny</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#order">Order</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#satisfy">Satisfy</a></li>
</ul>
<h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code></li>
<li><code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code></li>
<li><code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code></li>
</ul></div>

<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="Allow" id="Allow">Allow</a> <a name="allow" id="allow">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Spcifie quels htes peuvent accder  une certaine zone du
serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code> Allow from all|<var>hte</var>|env=[!]<var>variable
d'environnement</var>
[<var>hte</var>|env=[!]<var>variable d'environnement</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Limit</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_access_compat</td></tr>
</table>
    <p>La directive <code class="directive">Allow</code> permet de dfinir quels
    htes ont le droit d'accder  une certaine partie du serveur. On
    peut contrler l'accs par nom d'hte, adresse IP, intervalle
    d'adresses IP, ou toute autre caractristique de la requte client
    enregistre dans les variables d'environnement.</p>

    <p>Le premier argument de cette directive est toujours
    <code>from</code>. Les arguments suivants peuvent prendre trois
    formes diffrentes. Si <code>Allow from all</code> est spcifi,
    tout hte se voit accord l'accs, en tenant compte des directives
    <code class="directive"><a href="#deny">Deny</a></code> et <code class="directive"><a href="#order">Order</a></code> comme dcrit plus loin.
    Pour ne permettre l'accs au serveur qu' un hte ou un groupe
    d'htes particuliers, on peut spcifier un <em>nom d'hte</em> sous
    une des formes suivantes :</p>

    <dl>
      <dt>Un nom de domaine (partiel)</dt>

      <dd>
      <div class="example"><h3>Exemple :</h3><p><code>
        Allow from apache.org<br />
        Allow from .net example.edu
      </code></p></div>
      <p>Les htes dont les noms correspondent ou se terminent par la
      chane spcifie ont l'autorisation d'accs. Seules les
      composantes entires du nom d'hte doivent correspondre ; ainsi,
      dans l'exemple ci-dessus, <code>foo.apache.org</code>
      correspondra, mais <code>fooapache.org</code> ne conviendra pas.
      Avec cette configuration, Apache httpd va effectuer une double recherche
      DNS sur l'adresse IP du client, sans tenir compte de la
      dfinition de la directive <code class="directive"><a href="../mod/core.html#hostnamelookups">HostnameLookups</a></code>. Tout d'abord, une
      recherche DNS inverse sur l'adresse IP est effectue pour
      dterminer le nom d'hte associ, puis une recherche directe sur
      le nom d'hte est effectue afin de s'assurer qu'il correspond
      bien  l'adresse IP originale. L'accs ne sera accord que si le
      nom d'hte correspond et si les recherches DNS inverse et directe
      concordent.</p></dd>

      <dt>Une adresse IP complte</dt>

      <dd>
      <div class="example"><h3>Exemple :</h3><p><code>
        Allow from 10.1.2.3<br />
        Allow from 192.168.1.104 192.168.1.205
      </code></p></div>
      <p>L'adresse IP d'un hte auquel on a accord l'accs</p></dd>

      <dt>Une adresse IP partielle</dt>

      <dd>
      <div class="example"><h3>Exemple :</h3><p><code>
        Allow from 10.1<br />
        Allow from 10 172.20 192.168.2
      </code></p></div>
      <p>De un  trois des premiers octets d'une adresse IP, afin de
      restreindre l'accs  un sous-rseau.</p></dd>

      <dt>Une paire rseau/masque de sous-rseau</dt>

      <dd>
      <div class="example"><h3>Exemple :</h3><p><code>
        Allow from 10.1.0.0/255.255.0.0
      </code></p></div>
      <p>Un rseau a.b.c.d, et un masque de sous-rseau w.x.y.z, pour
      une dfinition plus prcise de la restriction d'accs impose  un
      sous-rseau.</p></dd>

      <dt>Une spcification CIDR rseau/nnn</dt>

      <dd>
      <div class="example"><h3>Exemple :</h3><p><code>
        Allow from 10.1.0.0/16
      </code></p></div>
      <p>Identique au cas prcdent, mis  part que le masque est
      constitu des nnn bits de poids fort.</p></dd>
    </dl>

    <p>Notez que les trois derniers exemples dsignent le mme ensemble
    d'htes.</p>

    <p>On peut spcifier des adresses et sous-rseaux IPv6 de la manire
    suivante :</p>

    <div class="example"><p><code>
       Allow from 2001:db8::a00:20ff:fea7:ccea<br />
       Allow from 2001:db8::a00:20ff:fea7:ccea/10
    </code></p></div>

    <p>Le troisime format d'argument de la directive
    <code class="directive">Allow</code> permet de contrler l'accs au serveur
    en fonction de l'existence d'une <a href="../env.html">variable d'environnement</a>. Lorsque <code>Allow
    from env=<var>variable d'environnement</var></code> est spcifi, la
    requte est autorise si la variable d'environnement <var>variable
    d'environnement</var> existe. En revanche, lorsque <code>Allow from
    env=!<var>env-variable</var></code> est spcifi, la
    requte est autorise si la variable d'environnement <var>variable
    d'environnement</var> n'existe pas. Le serveur permet de dfinir
    avec souplesse des variables d'environnement en se basant sur les
    caractristiques de la requte client et en utilisant les directives
    fournies par le module <code class="module"><a href="../mod/mod_setenvif.html">mod_setenvif</a></code>. Ainsi, on peut
    utiliser la directive <code class="directive">Allow</code> pour permettre
    l'accs en fonction de paramtres comme le <code>User-Agent</code>
    (type de navigateur) des clients, le <code>Referer</code>, ou
    d'autres champs d'en-tte de la requte HTTP.</p>

    <div class="example"><h3>Exemple :</h3><p><code>
      SetEnvIf User-Agent ^KnockKnock/2\.0 laissez_moi_entrer<br />
      &lt;Directory /docroot&gt;<br />
      <span class="indent">
        Order Deny,Allow<br />
        Deny from all<br />
        Allow from env=laissez_moi_entrer<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <p>Dans cet exemple, les navigateurs dont la chane user-agent
    commence par <code>KnockKnock/2.0</code> se verront accorder
    l'accs, alors que tous les autres seront rejets.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="Deny" id="Deny">Deny</a> <a name="deny" id="deny">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit quels htes ne sont pas autoriss  accder au
serveur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code> Deny from all|<var>hte</var>|env=[!]<var>variable
d'environnement</var>
[<var>hte</var>|env=[!]<var>variable d'environnement</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Limit</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_access_compat</td></tr>
</table>
    <p>Cette directive permet de restreindre l'accs au serveur en
    fonction du nom d'hte, de l'adresse IP ou de variables
    d'environnement. Les arguments de la directive
    <code class="directive">Deny</code> sont identiques aux arguments de la
    directive <code class="directive"><a href="#allow">Allow</a></code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="Order" id="Order">Order</a> <a name="order" id="order">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le statut d'accs par dfaut et l'ordre dans lequel
les directives <code class="directive">Allow</code> et
<code class="directive">Deny</code> sont values.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code> Order <var>ordre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Order Deny,Allow</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Limit</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_access_compat</td></tr>
</table>

    <p>La directive <code class="directive">Order</code>, associe aux
    directives <code class="directive"><a href="#allow">Allow</a></code>
    et <code class="directive"><a href="#deny">Deny</a></code>,
    implmente un systme de contrle d'accs en trois passes. Au cours
    de la premire passe, ce sont soit toutes les directives <code class="directive"><a href="#allow">Allow</a></code>, soit toutes les
    directives <code class="directive"><a href="#deny">Deny</a></code> qui sont traites, selon
    la dfinition de la directive <code class="directive"><a href="#order">Order</a></code>. Le reste des
    directives (<code class="directive"><a href="#deny">Deny</a></code>
    ou <code class="directive"><a href="#allow">Allow</a></code>) est
    trait au cours de la seconde passe. La troisime passe s'applique 
    toutes les requtes qui ne sont concernes par aucune des deux
    premires passes.</p>

    <p>Notez que toutes les directives <code class="directive"><a href="#allow">Allow</a></code> et <code class="directive"><a href="#deny">Deny</a></code> sont traites,  la
    diffrence d'un pare-feu classique o seule la premire rgle qui
    correspond est utilise. La dernire directive qui correspond
    s'applique (  la diffrence l encore d'un pare-feu classique). De
    plus, l'ordre dans lequel les lignes apparaissent dans le fichier de
    configuration n'a pas d'incidence -- toutes les lignes <code class="directive"><a href="#allow">Allow</a></code> sont considres comme
    un groupe, toutes les lignes <code class="directive"><a href="#deny">Deny</a></code> comme un autre, et le
    statut par dfaut a son existence propre.</p>

    <p><em>Ordre</em> peut tre :</p>

    <dl>
      <dt><code>Allow,Deny</code></dt>

      <dd>Dans un premier temps, toutes les directives <code class="directive"><a href="#allow">Allow</a></code> sont values ; au
      moins une d'entre elles doit correspondre, sinon la requte est
      rejete. Ensuite, toutes les directives <code class="directive"><a href="#deny">Deny</a></code> sont values. Si au
      moins l'une d'entre elles correspond, la requte est rejete.
      Enfin, toute requte qui ne correspond  aucune directive
      <code class="directive"><a href="#allow">Allow</a></code> ou
      <code class="directive"><a href="#deny">Deny</a></code> est rejete
      par dfaut.</dd>

      <dt><code>Deny,Allow</code></dt>

      <dd>Dans un premier temps, toutes les directives <code class="directive"><a href="#deny">Deny</a></code> sont values ; Si au
      moins une d'entre elles correspond, la requte est rejete,
      <strong> moins</strong> qu'elle corresponde aussi  une directive
      <code class="directive"><a href="#allow">Allow</a></code>. Toute
      requte qui ne correspond  aucune directive <code class="directive"><a href="#allow">Allow</a></code> ou <code class="directive"><a href="#deny">Deny</a></code> est autorise.</dd>

      <dt><code>Mutual-failure</code></dt>

      <dd>Cet argument a le mme effet que <code>Allow,Deny</code> et
      est devenu de ce fait obsolte.</dd>
    </dl>

    <p>Les mots-cls ne peuvent tre spars que par des virgules ;
    <em>aucun espace</em> ne doit s'intercaler entre eux.</p>

    <table class="bordered">
      <tr>
        <th>Match</th>
        <th>Rsultat Allow,Deny</th>
        <th>Rsultat Deny,Allow</th>
      </tr><tr>
        <th>Correspond  Allow seulement</th>
        <td>Requte autorise</td>
        <td>Requte autorise</td>
      </tr><tr>
        <th>Correspond  Deny seulement</th>
        <td>Requte rejete</td>
        <td>Requte rejete</td>
      </tr><tr>
        <th>Aucune correspondance</th>
        <td>Par dfaut la seconde directive : rejet</td>
        <td>Par dfaut la seconde directive : autorisation</td>
      </tr><tr>
        <th>Correspond  Allow &amp; Deny</th>
        <td>La dernire correspondance l'emporte : rejet</td>
        <td>La dernire correspondance l'emporte : autorisation</td>
      </tr>
    </table>

    <p>Dans cet exemple, tous les htes du domaine apache.org ont
    l'autorisation d'accs ; tous les autres voient leur accs
    refus.</p>

    <div class="example"><p><code>
      Order Deny,Allow<br />
      Deny from all<br />
      Allow from apache.org
    </code></p></div>

    <p>Dans l'exemple suivant, tous les htes du domaine apache.org ont
    l'autorisation d'accs, sauf ceux du sous-domaine foo.apache.org qui
    voient leur accs refus. Tous les htes qui ne sont pas dans le
    domaine apache.org sont rejets car le statut par dfaut est positionn
    sur <code class="directive"><a href="#deny">Deny</a></code>, et consiste donc en un
    refus d'accs.</p>

    <div class="example"><p><code>
      Order Allow,Deny<br />
      Allow from apache.org<br />
      Deny from foo.apache.org
    </code></p></div>

    <p>Par contre, si la valeur de la directive
    <code class="directive">Order</code>, dans l'exemple prcdent, est
    <code>Deny,Allow</code>, tout le monde a l'autorisation d'accs.
    Ceci est d au fait que <code>Allow from apache.org</code> sera
    valu en dernier, sans tenir compte de l'ordre rel dans lequel les
    directives apparaissent dans le fichier de configuration, et va
    l'emporter sur <code>Deny from foo.apache.org</code>. Tout hte qui
    n'est pas dans le domaine <code>apache.org</code> aura aussi
    l'autorisation d'accs car le statut par dfaut est positionn sur
    <code class="directive"><a href="#allow">Allow</a></code> et constitue donc une
    autorisation d'accs.</p>

    <p>La prsence d'une directive <code class="directive">Order</code> peut
    affecter le contrle d'accs  une partie du serveur mme en
    l'abscence de directives <code class="directive"><a href="#allow">Allow</a></code> et <code class="directive"><a href="#deny">Deny</a></code> associes,  cause de
    son influence sur le statut par dfaut. Par exemple,</p>

    <div class="example"><p><code>
      &lt;Directory /www&gt;<br />
      <span class="indent">
        Order Allow,Deny<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <p>va interdire tout accs au rpertoire <code>/www</code>  cause
    du statut d'accs par dfaut qui est dfini  <code class="directive"><a href="#deny">Deny</a></code>.</p>

    <p>La directive <code class="directive">Order</code> ne contrle l'ordre
    dans lequel sont traites les directives d'accs qu'au cours de
    chaque phase du traitement de la configuration du serveur. Ceci
    implique, par exemple, qu'une directive <code class="directive"><a href="#allow">Allow</a></code> ou <code class="directive"><a href="#deny">Deny</a></code> situe dans une section
    <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code> sera
    toujours value aprs une directive <code class="directive"><a href="#allow">Allow</a></code> ou <code class="directive"><a href="#deny">Deny</a></code> situe dans une section
    <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> ou un
    fichier <code>.htaccess</code>, sans tenir compte de la
    dfinition de la directive <code class="directive">Order</code>. Pour plus
    de dtails  propos de la fusion des sections de configuration, voir
    le document <a href="../sections.html">Comment fonctionnent les sections Directory,
    Location et Files</a>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="Satisfy" id="Satisfy">Satisfy</a> <a name="satisfy" id="satisfy">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Interaction entre le contrle d'accs en fonction de l'hte
et l'authentification utilisateur</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Satisfy Any|All</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Satisfy All</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_access_compat</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Affect par <code class="directive"><a href="../mod/core.html#limit">&lt;Limit&gt;</a></code> et <code class="directive"><a href="../mod/core.html#limitexcept">&lt;LimitExcept&gt;</a></code>  partir de la version
2.0.51</td></tr>
</table>
    <p>Politique d'accs dans le cas o on utilise  la fois <code class="directive"><a href="#allow">Allow</a></code> et <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>. L'argument est soit
    <code>All</code>, soit <code>Any</code>. L'utilisation de cette
    directive n'a de sens que si l'accs  une zone particulire du
    serveur est restreinte par utilisateur/mot de passe et en fonction
    de l'adresse IP de l'hte client. Dans ce cas, par
    dfaut (<code>All</code>), le client doit satisfaire  la
    restriction d'adresse, <em>et</em> fournir un couple
    utilisateur/mot de passe valide. Avec l'argument <code>Any</code>,
    le client se verra accorder l'accs s'il satisfait  la restriction
    d'adresse ou fournit un couple utilisateur/mot de passe valide. On
    peut utiliser cette dernire dfinition pour restreindre l'accs 
    une zone par mot de passe, mais accorder l'accs aux clients
    possdant certaines adresses IP sans qu'ils aient  fournir de mot
    de passe.</p>

    <p>Par exemple, si vous souhaitez que les utilisateurs de votre
    rseau accdent  une zone de votre site web sans restriction, mais
    que l'accs  cette zone ncessite un mot de passe pour les autres
    utilisateurs, vous pouvez utiliser une configuration du style :</p>

    <div class="example"><p><code>
      Require valid-user<br />
      Allow from 192.168.1<br />
      Satisfy Any
    </code></p></div>

    <p>
    Une autre utilisation frquente de la directive
    <code class="directive">Satisfy</code> est l'allgement des restrictions
    d'accs  un sous-rpertoire par rapport aux restrictions d'accs au
    rpertoire parent :
    </p>

    <div class="example"><p><code>
      &lt;Directory /var/www/private&gt;<br />
        Require valid-user<br />
      &lt;/Directory&gt;<br />
      <br />
      &lt;Directory /var/www/private/public&gt;<br />
        Allow from all<br />
        Satisfy Any<br />
      &lt;/Directory&gt;
    </code></p></div>

    <p>Dans l'exemple ci-dessus, l'accs au rpertoire
    <code>/var/www/private</code> ncessitera une authentification,
    alors que l'accs au rpertoire <code>/var/www/private/public</code>
    sera accord sans restriction.</p>


    <p>Depuis la version 2.0.51, les directives
    <code class="directive">Satisfy</code> peuvent tre restreintes  certaines
    mthodes particulires  l'aide des sections <code class="directive"><a href="../mod/core.html#limit">&lt;Limit&gt;</a></code> et <code class="directive"><a href="../mod/core.html#limitexcept">&lt;LimitExcept&gt;</a></code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#allow">Allow</a></code></li>
<li><code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code></li>
</ul>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_access_compat.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_access_compat.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_access_compat.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2010 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>