<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_headers - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_headers</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_headers.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_headers.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_headers.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_headers.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Personnalisation des en-ttes de requtes et de rponses
HTTP</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>headers_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_headers.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module fournit des directives permettant de contrler et
    modifier les en-ttes de requtes et de rponses HTTP. Les en-ttes
    peuvent tre fusionns, remplacs ou supprims.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#header">Header</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#requestheader">RequestHeader</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#order">Chronologie du traitement</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#early">Traitement prcoce et traitement
tardif</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#examples">Exemples</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="order" id="order">Chronologie du traitement</a></h2>

    <p>Les directives fournies par <code class="module"><a href="../mod/mod_headers.html">mod_headers</a></code> peuvent
    s'insrer presque partout dans la configuration du serveur, et on
    peut limiter leur porte en les plaant dans des <a href="../sections.html">sections de configuration</a>.</p>

    <p>La chronologie du traitement est importante et est affecte par
    l'ordre d'apparition des directives dans le fichier de configuration
    et par leur placement dans les <a href="../sections.html#mergin">sections de configuration</a>. Ainsi,
    ces deux directives ont un effet diffrent si leur ordre est invers
    :</p>

    <div class="example"><p><code>
      RequestHeader append MirrorID "mirror 12"<br />
      RequestHeader unset MirrorID
    </code></p></div>

    <p>Dans cet ordre, l'en-tte <code>MirrorID</code> n'est pas dfini.
    Si l'ordre des directives tait invers, l'en-tte
    <code>MirrorID</code> serait dfini  "mirror 12".</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="early" id="early">Traitement prcoce et traitement
tardif</a></h2>
    <p><code class="module"><a href="../mod/mod_headers.html">mod_headers</a></code> peut agir soir prcocement, soit
    tardivement au niveau de la requte. Le mode normal est le mode
    tardif, lorsque les en-ttes de requte sont dfinis, immdiatement
    avant l'excution du gnrateur de contenu, et pour les en-ttes de
    rponse, juste au moment o la rponse est envoye sur le rseau.
    Utilisez toujours le mode tardif sur un serveur en production.</p>

    <p>Le mode prcoce a t conu  des fins d'aide aux tests et au
    dbogage pour les dveloppeurs. Les directives dfinies en utilisant
    le mot-cl <code>early</code> sont censes agir au tout dbut du
    traitement de la requte. Cela signifie que l'on peut les utiliser
    pour simuler diffrentes requtes et dfinir des situations de test,
    tout en gardant  l'esprit que les en-ttes peuvent tre modifis 
    tout moment par d'autres modules avant que le rponse ne soit
    gnre.</p>

    <p>Comme les directives prcoces sont traites avant que le
    chemin de la requte ne soit parcouru, les en-ttes
    prcoces ne peuvent tre dfinis que dans un contexte de serveur
    principal ou de serveur virtuel. Les directives prcoces ne peuvent
    pas dpendre d'un chemin de requte, si bien qu'elles choueront
    dans des contextes tels que <code>&lt;Directory&gt;</code> ou
    <code>&lt;Location&gt;</code>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples</a></h2>

    <ol>
      <li>
        Copie tous les en-ttes de requte qui commencent par "TS" vers
	les en-ttes de la rponse :

        <div class="example"><p><code>
          Header echo ^TS
        </code></p></div>
      </li>

      <li>
        Ajoute  la rponse un en-tte, <code>mon-en-tte</code>, qui
	contient un horodatage permettant de dterminer le moment o la
	requte a t reue, et le temps qui s'est coul jusqu' ce que
	la requte ait commenc  tre servie. Cet en-tte peut tre
	utilis par le client pour estimer la charge du serveur ou
	isoler les goulets d'tranglement entre le client et le
	serveur.

        <div class="example"><p><code>
          Header set mon-en-tte "%D %t"
        </code></p></div>

        <p>le rsultat est l'ajout  la rponse d'un en-tte du type :</p>

        <div class="example"><p><code>
          mon-en-tte: D=3775428 t=991424704447256
        </code></p></div>
      </li>

      <li>
        Dit Bonjour  Joe

        <div class="example"><p><code>
          Header set mon-en-tte "Bonjour Joe. Il a fallu %D microsecondes \<br />
           Apache pour servir cette requte."
        </code></p></div>

        <p>le rsultat est l'ajout  la rponse d'un en-tte du type :</p>

        <div class="example"><p><code>
          mon-en-tte: Bonjour Joe. Il a fallu D=3775428 microsecondes  Apache
          pour servir cette requte.
        </code></p></div>
      </li>

      <li>
        Ajoute l'en-tte <code>mon-en-tte</code>  la rponse si et
	seulement si l'en-tte <code>mon-en-tte-requte</code> est
	prsent dans la requte. Ceci peut s'avrer utile pour gnrer
	des en-ttes de rponse " la tte du client". Notez que cet
	exemple ncessite les services du module
	<code class="module"><a href="../mod/mod_setenvif.html">mod_setenvif</a></code>.

        <div class="example"><p><code>
          SetEnvIf mon-en-tte-requte mavaleur HAVE_MyRequestHeader<br />
          Header set mon-en-tte "%D %t montexte" env=HAVE_MyRequestHeader
        </code></p></div>

        <p>Si l'en-tte <code>mon-en-tte-requte: mavaleur</code> est
	prsent dans la requte HTTP, la rponse contiendra un en-tte
	du type :</p>

        <div class="example"><p><code>
          mon-en-tte: D=3775428 t=991424704447256 montexte
        </code></p></div>
      </li>

      <li>
        Permet  DAV de fonctionner avec Apache sur SSL (voir la <a href="http://svn.haxx.se/users/archive-2006-03/0549.shtml">description
	du problme</a>) en remplaant <var>https:</var> par
	<var>http:</var> dans l'en-tte <var>Destination</var> :

        <div class="example"><p><code>
          RequestHeader edit Destination ^https: http: early
        </code></p></div>
      </li>

      <li>
        Dfinit la valeur d'un mme en-tte sous de multiples conditions
	non exclusives, mais ne duplique pas une valeur dj dfinie
	dans l'en-tte qui en rsulte. Si toutes les conditions
	suivantes sont satisfaites pour une requte (en d'autres termes,
	si les trois variables d'environnement <code>CGI</code>,
	<code>NO_CACHE</code> et <code>NO_STORE</code> existent pour la
	requte) :

        <div class="example"><p><code>
          Header merge Cache-Control no-cache env=CGI<br />
          Header merge Cache-Control no-cache env=NO_CACHE<br />
          Header merge Cache-Control no-store env=NO_STORE
        </code></p></div>

        <p>alors, la rponse contiendra l'en-tte suivant :</p>

        <div class="example"><p><code>
          Cache-Control: no-cache, no-store
        </code></p></div>

        <p>Si <code>append</code> avait t utilis  la place de
	<code>merge</code>, la rponse aurait contenu l'en-tte suivant
	:</p>

        <div class="example"><p><code>
          Cache-Control: no-cache, no-cache, no-store
        </code></p></div>
      </li>
      <li>
        Dfinit un cookie de test si et seulement si le client n'envoie
	pas de cookie
        <div class="example"><p><code>
          Header set Set-Cookie testcookie !$req{Cookie}
        </code></p></div>
      </li>
    </ol>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="Header" id="Header">Header</a> <a name="header" id="header">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configure les en-ttes d'une rponse HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Header [<var>condition</var>] add|append|echo|edit|merge|set|unset
<var>en-tte</var> [<var>valeur</var>] [early|env=[!]<var>variable</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_headers</td></tr>
</table>
    <p>Cette directive permet de remplacer, fusionner, ou
    supprimer des en-ttes de rponse HTTP. L'en-tte est modifi juste
    aprs que le gestionnaire de contenu et les filtres en sortie ne
    s'excutent, ce qui permet la modification des en-ttes
    sortants.</p>

    <p>Par dfaut, cette directive n'affecte que les rponses positives
    (rponses dont le code de statut est dans la gamme
    <code>2<var>xx</var></code>). Le paramtre optionnel
    <var>condition</var> peut prendre pour valeur soit
    <code>onsuccess</code> (valeur par dfaut), soit <code>always</code>
    (tous les codes de statut, y compris les rponses positives).
    Dfinir cette valeur  <code>always</code> permet d'affecter des
    en-ttes dfinis par certains modules internes, y compris dans le
    cas d'une rponse positive, et s'avre mme ncessaire pour affecter
    des en-ttes de rponses dont le code de statut n'est pas dans la
    gamme <code>2<var>xx</var></code> comme les redirections ou les
    erreurs client.</p>

    <p>L'action que cette directive provoque est dtermine par le
    second argument. Il peut prendre une des valeurs suivantes :</p>

    <dl>
    <dt><code>add</code></dt>
    <dd>L'en-tte est ajout au jeu d'en-ttes prexistant, mme s'il
    existe dj. Ceci peut conduire  la prsence de deux (ou plusieurs)
    en-ttes possdant le mme nom et donc induire des consquences
    imprvues ; en gnral, il est prfrable d'utiliser
    <code>set</code>, <code>append</code> ou <code>merge</code>.</dd>

    <dt><code>append</code></dt>
    <dd>La valeur d'en-tte est ajoute  tout en-tte existant de mme
    nom. Lorsqu'une nouvelle valeur est ainsi ajoute, elle est spare
    de celles qui sont dj prsentes par une virgule. Il s'agit de la
    mthode HTTP standard permettant d'affecter plusieurs valeurs  un
    en-tte.</dd>

    <dt><code>echo</code></dt>
    <dd>Les en-ttes de la requte possdant le nom spcifi sont
    recopis vers les en-ttes de la rponse. <var>en-tte</var> peut
    tre une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a>, et
    <var>valeur</var> ne doit pas tre prsent.</dd>

    <dt><code>edit</code></dt>
    <dd>Si l'en-tte existe, sa valeur est modifie en fonction d'une
    <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a> de type
    recherche/remplacement. L'argument <var>valeur</var> est une
    <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a>, et
    l'argument <var>remplacement</var> une chane de caractres de
    remplacement qui peut contenir des rfrences arrires.</dd>

    <dt><code>merge</code></dt>
    <dd>La valeur d'en-tte est ajoute  tout en-tte de mme nom, sauf
    si elle apparat dj dans la liste des valeurs prexistantes de
    l'en-tte spares par des virgules. Lorsqu'une nouvelle valeur est
    ainsi ajoute, elle est spare de celles qui sont dj prsentes
    par une virgule. Il s'agit de la mthode HTTP standard permettant
    d'affecter plusieurs valeurs  un en-tte. Les valeurs sont
    compares en tenant compte de la casse, et aprs le traitement de
    tous les spcificateurs de format. Une valeur entoure de guillemets
    est considre comme diffrente de la mme valeur mais sans
    guillemets.</dd>

    <dt><code>set</code></dt>
    <dd>L'en-tte est dfini, remplaant tout en-tte prexistant avec
    le mme nom. L'argument <var>valeur</var> peut tre une chane de
    formatage.</dd>

    <dt><code>unset</code></dt>
    <dd>L'en-tte est supprim s'il existe. Si plusieurs en-ttes
    possdent le mme nom, ils seront tous supprims. L'argument
    <var>value</var> ne doit pas apparatre.</dd>
    </dl>

    <p>Cet argument est suivi d'un nom d'<var>en-tte</var> qui peut se
    terminer par un caractre ':', mais ce n'est pas obligatoire. La
    casse est ignore avec <code>set</code>, <code>append</code>,
    <code>merge</code>, <code>add</code>, <code>unset</code> et
    <code>edit</code>. Le nom d'<var>en-tte</var> est sensible  la
    casse pour <code>echo</code> et peut tre une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a>.</p>

    <p>Avec <code>set</code>, <code>append</code>, <code>merge</code> et
    <code>add</code>, une <var>valeur</var> est spcifie comme
    troisime argument. Si <var>valeur</var> contient des espaces, elle
    doit tre entoure de guillemets. <var>valeur</var> peut tre une
    chane de caractres, une chane contenant des spcificateurs de
    format, ou une combinaison des deux. <var>valeur</var> supporte les
    spcificateurs de format suivants :</p>

    <table class="bordered"><tr class="header"><th>Format</th><th>Description</th></tr>
<tr><td><code>%%</code></td>
        <td>Le caractre pourcentage</td></tr>
<tr class="odd"><td><code>%t</code></td>
        <td>Le moment de rception de la requte en temps
	universel coordonn depuis le temps epoch (Jan. 1, 1970) et
	exprim en microsecondes. La valeur est prcde de
	<code>t=</code>.</td></tr>
<tr><td><code>%D</code></td>
        <td>Le temps coul entre la rception de la requte et l'envoi
	des en-ttes sur le rseau. Il s'agit de la dure de traitement
	de la requte. La valeur est prcde de <code>D=</code>. La
	valeur est exprime en microsecondes.</td></tr>
<tr class="odd"><td><code>%{NOM_VARIABLE}e</code></td>
        <td>Le contenu de la <a href="../env.html">variable
	d'environnement</a> <code>NOM_VARIABLE</code>.</td></tr>
<tr><td><code>%{NOM_VARIABLE}s</code></td>
        <td>Le contenu de la <a href="../env.html">variable
	d'environnement SSL</a> <code>NOM_VARIABLE</code>, si
	<code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> est activ.</td></tr>
</table>

    <div class="note"><h3>Note</h3>
      <p>Le spcificateur de format <code>%s</code> est disponible
      depuis la version 2.1 d'Apache ; il peut tre utilis  la place
      de <code>%e</code> pour viter de devoir spcifier
      <code>SSLOptions +StdEnvVars</code>. Cependant, si
      <code>SSLOptions +StdEnvVars</code> doit tout de mme tre
      spcifi pour une raison quelconque, <code>%e</code> sera plus
      efficace que <code>%s</code>.</p>
    </div>

    <p><code>edit</code>ncessite les deux arguments
    <var>valeur</var>, qui est une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression
    rationnelle</a>, et une chane additionnelle
    <var>remplacement</var>.</p>

    <p>La directive <code class="directive">Header</code> peut tre suivie d'un
    argument additionnel qui peut prendre les valeurs suivantes :</p>

    <dl>
    <dt><code>early</code></dt>
    <dd>Spcifie <a href="#early">traitement pralable</a>.</dd>
    <dt><code>env=[!]variable</code></dt>
    <dd>La directive est applique si et seulement si la <a href="../env.html">variable d'environnement</a>
    <code>variable</code> existe. Un <code>!</code> devant
    <code>variable</code> inverse le test, et la directive ne
    s'appliquera alors que si <code>variable</code> n'est pas dfinie.</dd>
    <dt><code>expr</code></dt>
    <dd>Une chane qui correspond  toute valeur ci-dessus est
    interprte comme une expression. Les dtails  propos de la syntaxe
    des expressions et leur valuation sont pour l'instant mieux
    documents dans la page de <code class="module"><a href="../mod/mod_filter.html">mod_filter</a></code>.</dd>
    </dl>

    <p>Except le cas du mode <a href="#early">prcoce</a>, les
    directives <code class="directive">Header</code> sont traites juste avant
    l'envoi de la rponse sur le rseau. Cela signifie qu'il est
    possible de dfinir et/ou modifier la plupart des en-ttes, 
    l'exception de ceux qui sont ajouts par le filtre d'en-tte.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RequestHeader" id="RequestHeader">RequestHeader</a> <a name="requestheader" id="requestheader">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configure les en-ttes d'une requte HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RequestHeader add|append|edit|edit*|merge|set|unset <var>en-tte</var>
[<var>valeur</var>] [<var>remplacement</var>] [early|env=[!]<var>variable</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_headers</td></tr>
</table>
    <p>Cette directive permet de remplacer, fusionner, modifier ou
    supprimer des en-ttes de requte HTTP. L'en-tte est modifi juste
    avant que le gestionnaire de contenu ne s'excute, ce qui permet la
    modification des en-ttes entrants. L'action effectue est
    dtermine par le premier argument. Ce dernier accepte les valeurs
    suivantes :</p>

    <dl>

    <dt><code>add</code></dt>
    <dd>L'en-tte est ajout au jeu d'en-ttes prexistant, mme s'il
    existe dj. Ceci peut conduire  la prsence de deux (ou plusieurs)
    en-ttes possdant le mme nom et donc induire des consquences
    imprvues ; en gnral, il est prfrable d'utiliser
    <code>set</code>, <code>append</code> ou <code>merge</code>.</dd>

    <dt><code>append</code></dt>
    <dd>La valeur d'en-tte est ajoute  tout en-tte existant de mme
    nom. Lorsqu'une nouvelle valeur est ainsi ajoute, elle est spare
    de celles qui sont dj prsentes par une virgule. Il s'agit de la
    mthode HTTP standard permettant d'affecter plusieurs valeurs  un
    en-tte.</dd>

    <dt><code>edit*</code></dt>
    <dd>Si l'en-tte existe, sa valeur est modifie en fonction d'une
    <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a> de type
    recherche/remplacement. L'argument <var>valeur</var> est une
    <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a>, et
    l'argument <var>remplacement</var> une chane de caractres de
    remplacement qui peut contenir des rfrences arrires. Avec
    <code>edit</code>, la chane de l'en-tte correspondant au modle ne
    sera recherche et remplace qu'une seule fois, alors qu'avec
    <code>edit*</code>, elle le sera pour chacune de ses instances si
    elle apparat plusieurs fois.</dd>

    <dt><code>merge</code></dt>
    <dd>La valeur d'en-tte est ajoute  tout en-tte de mme nom, sauf
    si elle apparat dj dans la liste des valeurs prexistantes de
    l'en-tte spares par des virgules. Lorsqu'une nouvelle valeur est
    ainsi ajoute, elle est spare de celles qui sont dj prsentes
    par une virgule. Il s'agit de la mthode HTTP standard permettant
    d'affecter plusieurs valeurs  un en-tte. Les valeurs sont
    compares en tenant compte de la casse, et aprs le traitement de
    tous les spcificateurs de format. Une valeur entoure de guillemets
    est considre comme diffrente de la mme valeur mais sans
    guillemets.</dd>

    <dt><code>set</code></dt>
    <dd>L'en-tte est dfini, remplaant tout en-tte prexistant avec
    le mme nom.</dd>

    <dt><code>unset</code></dt>
    <dd>L'en-tte est supprim s'il existe. Si plusieurs en-ttes
    possdent le mme nom, ils seront tous supprims. L'argument
    <var>value</var> ne doit pas apparatre.</dd>
    </dl>

    <p>Cet argument est suivi d'un nom d'en-tte qui peut se terminer
    par un caractre ':', mais ce n'est pas obligatoire. La casse est
    ignore. Avec <code>set</code>, <code>append</code>,
    <code>merge</code> et <code>add</code>, une <var>valeur</var> est
    fournie en troisime argument. Si une <var>valeur</var> contient des
    espaces, elle doit tre entoure de guillemets. Avec
    <code>unset</code>, aucune <var>valeur</var> ne doit apparatre.
    <var>valeur</var> peut tre une chane de caractres, une chane
    contenant des spcificateurs de format, ou une combinaison des deux.
    Les spcificateurs de format supports sont les mmes que ceux de la
    directive <code class="directive"><a href="#header">Header</a></code>, 
    laquelle vous pouvez vous reporter pour plus de dtails. Avec
    <code>edit</code>, les deux arguments <var>valeur</var> et
    <var>remplacement</var> sont obligatoires, et correspondent
    respectivement  une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression
    rationnelle</a> et  une chane de remplacement.</p>

    <p>La directive <code class="directive">RequestHeader</code> peut tre
    suivie d'un argument supplmentaire, qui pourra prendre les valeurs
    suivantes :</p>
    <dl>
    <dt><code>early</code></dt>
    <dd>Spcifie <a href="#early">traitement pralable</a>.</dd>
    <dt><code>env=[!]variable</code></dt>
    <dd>La directive est applique si et seulement si la <a href="../env.html">variable d'environnement</a>
    <code>variable</code> existe. Un <code>!</code> devant
    <code>variable</code> inverse le test, et la directive ne
    s'appliquera alors que si <code>variable</code> n'est pas dfinie.</dd>
    <dt><code>expr</code></dt>
    <dd>Une chane qui correspond  toute valeur ci-dessus est
    interprte comme une expression. Les dtails  propos de la syntaxe
    des expressions et leur valuation sont pour l'instant mieux
    documents dans la page de <code class="module"><a href="../mod/mod_filter.html">mod_filter</a></code>.</dd>
    </dl>

    <p>Except le cas du mode <a href="#early">prcoce</a>, la directive
    <code class="directive">RequestHeader</code> est traite juste avant la
    prise en compte de la requte par son gestionnaire, au cours de la
    phase de vrification. Ceci permet la modification des en-ttes
    gnrs par le navigateur, ou par les filtres en entre
    d'Apache.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_headers.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_headers.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_headers.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_headers.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2010 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>