<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Problmes lis au DNS avec Apache - Serveur Apache HTTP</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.3</a></div><div id="page-content"><div id="preamble"><h1>Problmes lis au DNS avec Apache</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/dns-caveats.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/dns-caveats.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/dns-caveats.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/dns-caveats.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/dns-caveats.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

    <p>Cette page pourrait se rsumer ainsi : configurez Apache de faon
     ce qu'il n'ait pas besoin de rsolution DNS pour interprter les
    fichiers de configuration. Si Apache doit effectuer des rsolutions
    DNS pour interprter les fichiers de configuration, votre serveur
    pourra prsenter des problmes de fiabilit (en d'autres termes,
    il est possible qu'il refuse de dmarrer), ou d'attaques par dni ou
    usurpation de service (y compris le dtournement d'informations
    utilisateurs).</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#example">Un exemple simple</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#denial">Dni de service</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#main">L'adresse du "serveur principal"</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#tips">Conseils pour viter ce genre de problme</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#appendix">Appendice : orientations pour le futur</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="example" id="example">Un exemple simple</a></h2>
    

    <div class="example"><p><code>
      # Cet exemple de configuration est invalide, ne l'utilisez pas comme base <br />
      # de configuration <br />
      &lt;VirtualHost www.abc.dom&gt; <br />
      ServerAdmin webgirl@abc.dom <br />
      DocumentRoot /www/abc <br />
      &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Pour fonctionner correctement, Apache a absolument besoin de deux
    informations  propos de chaque serveur virtuel : le nom du serveur
    dfini par la directive <code class="directive"><a href="./mod/core.html#servername">ServerName</a></code>, et au moins une adresse IP 
    laquelle le serveur va se rattacher et rpondre. L'exemple ci-dessus
    ne comporte pas d'adresse IP, si bien qu'Apache devra utiliser le
    DNS pour trouver l'adresse IP de <code>www.abc.dom</code>. Si pour
    une raison quelconque, le DNS n'est pas disponible au moment o
    votre serveur interprte son fichier de configuration, ce serveur
    virtuel <strong>ne sera pas pris en compte dans la
    configuration</strong>. Il sera incapable de
    rpondre  toute requte pour ce serveur virtuel (avec les versions
    d'Apache antrieures  1.2, le serveur ne dmarrera tout simplement
    pas).</p>

    <p>Supposons que l'adresse de <code>www.abc.dom</code> soit
    192.0.2.1, et examinons cet extrait de configuration :</p>

    <div class="example"><p><code>
      # Cet exemple de configuration est invalide, ne l'utilisez pas comme base <br />
      # de configuration <br />
      &lt;VirtualHost 192.0.2.1&gt; <br />
      ServerAdmin webgirl@abc.dom <br />
      DocumentRoot /www/abc <br />
      &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Cette fois, Apache doit effectuer une recherche DNS inverse pour
    trouver le nom <code>ServerName</code> de ce serveur virtuel. Si
    cette recherche inverse choue, le serveur virtuel sera
    partiellement dsactiv (avec les versions d'Apache antrieures 
    1.2, le serveur ne dmarrera tout simplement pas). Si le serveur
    virtuel est  base de nom, il sera en fait totalement dsactiv,
    mais s'il est  base d'adresse IP, il fonctionnera probablement.
    Cependant, Apache chouera s'il doit gnrer une URL complte pour
    le serveur qui inclut ce nom de serveur.</p>

    <p>Voici un extrait de configuration qui permet d'viter ces deux
    types de problmes :</p>

    <div class="example"><p><code>
      &lt;VirtualHost 192.0.2.1&gt; <br />
      ServerName www.abc.dom <br />
      ServerAdmin webgirl@abc.dom <br />
      DocumentRoot /www/abc <br />
      &lt;/VirtualHost&gt;
    </code></p></div>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="denial" id="denial">Dni de service</a></h2>
    

    <p>Il existe (au moins) deux formes possibles de dni de service. Si
    vous utilisez une version d'Apache antrieure  1.2, votre serveur
    ne dmarrera pas si une des deux recherches DNS mentionnes
    ci-dessus choue pour au moins un de vos serveurs virtuels. Dans
    certains cas, cette recherche DNS ne sera mme pas sous votre
    contrle ; par exemple, si <code>abc.dom</code> est un de vos
    clients et s'il gre son propre DNS, il peut empcher votre
    serveur (pre-1.2) de dmarrer, simplement en supprimant
    l'enregistrement <code>www.abc.dom</code>.</p>

    <p>La deuxime forme de dni de service est beaucoup plus subtile.
    Examinons cet extrait de configuration :</p>

    <div class="example"><p><code>
      &lt;VirtualHost www.abc.dom&gt;<br />
      <span class="indent">
        ServerAdmin webgirl@abc.dom<br />
        DocumentRoot /www/abc<br />
      </span>
      &lt;/VirtualHost&gt;<br />
      <br />
      &lt;VirtualHost www.def.dom&gt;<br />
      <span class="indent">
        ServerAdmin webguy@def.dom<br />
        DocumentRoot /www/def<br />
      </span>
      &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Supposons que vous avez assign 192.0.2.1 
    <code>www.abc.dom</code> et 192.0.2.2  <code>www.def.dom</code>. En
    outre, supposons que <code>def.dom</code> gre son propre DNS. Avec
    cette configuration, <code>def.dom</code> sera en mesure de
    dtourner tout trafic destin  <code>abc.dom</code>. Pour y
    parvenir, tout ce qu'ils ont  faire consiste  assigner 192.0.2.1 
    <code>www.def.dom</code>. Comme ils grent leur propre DNS, vous ne
    pouvez pas les empcher de faire pointer l'enregistrement
    <code>www.def.dom</code> vers l'adresse qu'ils veulent.</p>

    <p>Les requtes  destination de 192.0.2.1 (y compris toutes celles
    o l'utilisateur  tap une URL de la forme
    <code>http://www.abc.dom/quelquepart</code>), seront toutes servies
    par le serveur virtuel <code>def.dom</code>. Une meilleur
    comprhension de la raison pour laquelle ceci peut se produire
    ncessite une discussion plus approfondie  propos de la manire
    dont Apache associe les requtes entrantes aux diffrents serveurs
    virtuels qui vont les servir. Un document de base dcrivant ceci <a href="vhosts/details.html">est disponible</a>.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="main" id="main">L'adresse du "serveur principal"</a></h2>
    

    <p>L'addition du <a href="vhosts/name-based.html">support des
    serveurs virtuels  base de nom</a> dans la version 1.1 d'Apache
    oblige ce dernier  connatre la/les adresse(s) IP de l'hte sur
    lequel <code class="program"><a href="./programs/httpd.html">httpd</a></code> s'excute. Pour obtenir cette
    adresse, soit il utilise la directive <code class="directive"><a href="./mod/core.html#servername">ServerName</a></code> globale (si elle est prsente),
    soit il fait appel  la fonction C <code>gethostname</code> (qui
    doit renvoyer le mme nom que la commande shell "hostname"). Il
    effectue ensuite une recherche DNS sur cette adresse. Pour le
    moment, il n'existe aucun moyen d'viter cette recherche DNS.</p>

    <p>Si vous craignez que cette recherche DNS choue parce que votre
    serveur DNS est arrt, vous pouvez insrer le nom d'hte dans le
    fichier <code>/etc/hosts</code> (o il est probablement dj
    enregistr afin que la machine dmarre correctement). Assurez-vous
    ensuite que la machine est configure pour utiliser
    <code>/etc/hosts</code> dans le cas o la recherche DNS choue.
    Suivant le systme d'exploitation que vous utilisez, vous y
    parviendrez en ditant <code>/etc/resolv.conf</code>, ou
    <code>/etc/nsswitch.conf</code>.</p>

    <p>Si votre serveur n'a aucune autre raison d'effectuer des
    recherches DNS, vous pouvez dfinir la variable d'environnement
    <code>HOSTRESORDER</code>  "local", et vous serez alors en mesure
    d'excuter Apache. Tout dpend du systme d'exploitation et des
    bibliothques de rsolution de noms que vous utilisez. Elle affecte
    aussi les programmes CGI,  moins que vous n'utilisiez
    <code class="module"><a href="./mod/mod_env.html">mod_env</a></code> pour contrler l'environnement. Il est
    conseill de consulter les pages de manuel ou les FAQs de votre
    systme d'exploitation.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="tips" id="tips">Conseils pour viter ce genre de problme</a></h2>
    

    <ul>
      <li>
        utilisez des adresses IP au sein des <code class="directive"><a href="./mod/core.html#virtualhost">VirtualHost</a></code>
      </li>

      <li>
        utilisez des adresses IP avec la directive <code class="directive"><a href="./mod/mpm_common.html#listen">Listen</a></code>
      </li>

      <li>
        vrifiez que tous les serveurs virtuels possdent un nom
	<code class="directive"><a href="./mod/core.html#servername">ServerName</a></code>	explicite
      </li>

      <li>crez un serveur virtuel <code>&lt;VirtualHost
      _default_:*&gt;</code> qui n'a aucune page  servir</li>
    </ul>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="appendix" id="appendix">Appendice : orientations pour le futur</a></h2>
    

    <p>La situation concernant le DNS apparat clairement comme non
    souhaitable. Avec Apache 1.2, nous avons fait en sorte que le
    serveur puisse au moins dmarrer en cas d'chec de recherche DNS,
    mais ce n'est pas ce que nous pouvons faire de mieux. En tout tat
    de cause, le fait de devoir spcifier des adresses IP explicites
    dans les fichiers de configuration est fortement non souhaitable
    avec l'Internet d'aujourd'hui o les changements de numrotation
    sont une ncessit.</p>

    <p>Il est possible d'viter les attaques par usurpation de service
    dcrites ci-dessus en effectuant une recherche DNS inverse sur
    l'adresse IP renvoye par la recherche DNS directe et en comparant
    les deux noms -- en cas de non correspondance, le serveur virtuel
    serait dsactiv. Ceci ncessite cependant une configuration
    correcte du DNS inverse (ce avec quoi les administrateurs sont
    familiers  cause de l'utilisation courante des doubles recherches
    DNS inverses par les serveurs FTP et les TCP wrappers).</p>

    <p>En tout tat de cause, il ne semble pas envisageable de dmarrer
    de manire fiable un serveur web avec serveurs virtuels losqu'une
    recherche DNS a chou, sauf si l'on utilise des adresses IP. Les
    solutions partielles consistant  dsactiver des portions de
    configuration pourraient s'avrer pires que ne pas dmarrer du tout
    ; tout dpend de ce que le serveur est suppos faire.</p>

    <p>Au fur et  mesure du dploiement de HTTP/1.1, et comme les
    navigateurs et les mandataires commencent  gnrer l'en-tte
    <code>Host</code>, il devient possible d'envisager de se passer
    compltement des serveurs virtuels  base d'adresses IP. Dans ce
    cas, un serveur web n'a besoin d'aucune recherche DNS pendant
    l'interprtation de ses fichiers de configuration. Cependant, au
    mois de mars 1997, ces fonctionnalits n'ont pas t assez largement
    dployes pour tre utilises sur des serveurs web critiques.</p>
  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/dns-caveats.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/dns-caveats.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/dns-caveats.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/dns-caveats.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/dns-caveats.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2010 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div>
</body></html>