<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Support des objets dynamiques partags (DSO) - Serveur Apache HTTP</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.3</a></div><div id="page-content"><div id="preamble"><h1>Support des objets dynamiques partags (DSO)</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/dso.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/dso.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/dso.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/dso.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/dso.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

    <p>La conception modulaire du serveur HTTP Apache permet  l'administrateur
    de choisir les fonctionnalits  inclure dans le serveur en slectionnant
    un certain nombre de modules. Les modules peuvent tre soit intgrs
    statiquement dans le binaire <code class="program"><a href="./programs/httpd.html">httpd</a></code> lors de la
    compilation du serveur, soit compils en tant qu'objets
    dynamiques partags (DSOs) qui existeront indpendamment du binaire
    principal <code class="program"><a href="./programs/httpd.html">httpd</a></code>. Les modules DSO peuvent tre compils
    au moment de la construction du serveur, ou bien compils sparment,
     l'aide de l'utilitaire des extensions d'Apache (<code class="program"><a href="./programs/apxs.html">apxs</a></code>),
    et associs au serveur ultrieurement.</p>

    <p>Ce document dcrit l'utilisation des modules DSO ainsi que les dessous
    de leur fonctionnement.</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#implementation">Implmentation</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#usage">Mode d'emploi succinct</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#background">Les dessous du fonctionnement des DSO</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#advantages">Avantages et inconvnients</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="implementation" id="implementation">Implmentation</a></h2>

<table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_so.html">mod_so</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code></li></ul></td></tr></table>

    <p>Le support DSO pour le chargement de modules individuels d'Apache est
    assur par un module nomm <code class="module"><a href="./mod/mod_so.html">mod_so</a></code> qui doit tre compil
    statiquement dans le coeur d'Apache. Il s'agit du seul module avec le
    module <code class="module"><a href="./mod/core.html">core</a></code>  ne pas pouvoir tre compil en tant que
    module DSO lui-mme. Pratiquement tous les autres modules d'Apache
    distribus peuvent tre compils en tant que modules DSO en slectionnant
    pour chacun d'entre eux le mode de construction DSO  l'aide de l'option
    <code>--enable-<em>module</em>=shared</code> du script
    <code class="program"><a href="./programs/configure.html">configure</a></code>, comme dcrit dans la
    <a href="install.html">Documentation de l'installation</a>. Une fois
    compil en tant que module DSO, un module peut tre charg en mmoire au
    dmarrage ou redmarrage du serveur  l'aide de la commande
    <code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code> du module
    <code class="module"><a href="./mod/mod_so.html">mod_so</a></code>, place
    dans votre fichier <code>httpd.conf</code>.</p>

    <p>Un nouvel utilitaire a t introduit afin de simplifier la cration de
    fichiers DSO pour les modules d'Apache
    (particulirement pour les modules tiers) ; il s'agit du programme nomm
    <code class="program"><a href="./programs/apxs.html">apxs</a></code> (<dfn>APache
    eXtenSion</dfn>). On peut l'utiliser pour construire des modules de type
    DSO <em>en dehors</em> de l'arborescence des sources d'Apache. L'ide est
    simple :  l'installation d'Apache, la procdure <code>make install</code>
    du script <code class="program"><a href="./programs/configure.html">configure</a></code> installe les fichiers d'en-ttes
    d'Apache et positionne, pour la plateforme de compilation,  les drapeaux du compilateur et de
    l'diteur de liens  l'intrieur du programme
    <code class="program"><a href="./programs/apxs.html">apxs</a></code>, qui sera utilis pour la construction de fichiers DSO.
    Il est ainsi possible d'utiliser le programme <code class="program"><a href="./programs/apxs.html">apxs</a></code>
    pour compiler ses sources de modules Apache sans avoir besoin de
    l'arborescence des sources de la distribution d'Apache, et sans avoir 
    rgler les drapeaux du compilateur et de l'diteur de liens pour le support DSO.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="usage" id="usage">Mode d'emploi succinct</a></h2>

    <p>Afin que vous puissiez vous faire une ide des fonctionnalits DSO
    d'Apache 2.x, en voici un rsum court et concis :</p>

    <ol>
      <li>
        Construire et installer un module Apache <em>faisant partie de la
	distribution</em>, par exemple <code>mod_foo.c</code>,
	en tant que module DSO <code>mod_foo.so</code> :

<div class="example"><p><code>
$ ./configure --prefix=/chemin/vers/rpertoire-installation
--enable-foo=shared<br />
$ make install
</code></p></div>
      </li>

      <li>
        Construire et installer un module Apache <em>tiers</em>, par exemple
        <code>mod_foo.c</code>, en tant que module DSO <code>mod_foo.so</code> :

<div class="example"><p><code>
$ ./configure --add-module=<var>type_de_module</var>:
/chemin/vers/module_tiers/mod_foo.c \<br />
<span class="indent">
  --enable-foo=shared<br />
</span>
$ make install
</code></p></div>
      </li>

      <li>
        Configurer Apache pour <em>pouvoir installer ultrieurement</em> des
	modules partags :

<div class="example"><p><code>
$ ./configure --enable-so<br />
$ make install
</code></p></div>
      </li>

      <li>
        Construire et installer un module Apache <em>tiers</em>, par exemple
        <code>mod_foo.c</code>, en tant que module DSO
        <code>mod_foo.so</code> <em>en dehors</em> de l'arborescence des sources
	d'Apache  l'aide du programme <code class="program"><a href="./programs/apxs.html">apxs</a></code> :

<div class="example"><p><code>
$ cd /chemin/vers/module_tiers<br />
$ apxs -c mod_foo.c<br />
$ apxs -i -a -n foo mod_foo.la
</code></p></div>
      </li>
    </ol>

    <p>Dans tous les cas, une fois le module partag compil, vous devez
    ajouter une directive <code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code>
    dans le fichier <code>httpd.conf</code> pour qu'Apache active le module.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="background" id="background">Les dessous du fonctionnement des DSO</a></h2>

    <p>Les clnes modernes d'UNIX proposent un astucieux mcanisme
    communment appel dition de liens et chargement dynamiques d'
    <em>Objets Dynamiques Partags</em> (DSO), qui permet de construire un
    morceau de programme dans un format spcial pour le rendre chargeable
     l'excution dans l'espace d'adressage d'un programme excutable.</p>

    <p>Ce chargement peut s'effectuer de deux manires : automatiquement par
    un programme systme appel <code>ld.so</code> quand un programme
    excutable est dmarr, ou manuellement  partir du programme en cours
    d'excution via sa propre interface systme vers le chargeur Unix  l'aide
    des appels systme <code>dlopen()/dlsym()</code>.</p>

    <p>Dans la premire mthode, les DSO sont en gnral appels
    <em>bibliothques partages</em> ou encore <em>bibliothques DSO</em>, et
    possdent des noms du style
    <code>libfoo.so</code> ou <code>libfoo.so.1.2</code>. Ils rsident dans un
    rpertoire systme (en gnral <code>/usr/lib</code>)
    et le lien avec le programme excutable est tabli  la compilation en
    ajoutant <code>-lfoo</code>  la commande de l'diteur de liens. Les
    rfrences  la bibliothque sont ainsi codes en dur dans le fichier du
    programme excutable de faon  ce qu'au dmarrage du programme, le
    chargeur Unix soit capable de localiser <code>libfoo.so</code> dans
    <code>/usr/lib</code>, dans des chemins cods en dur  l'aide d'options de
    l'diteur de liens comme <code>-R</code> ou dans des chemins dfinis par la
    variable d'environnement
    <code>LD_LIBRARY_PATH</code>. Le chargeur peut ds lors rsoudre tous les symboles
    (jusque l non encore rsolus) du DSO dans le programme excutable.</p>

    <p>Les symboles du programme excutable ne sont en gnral pas
    rfrencs par le DSO (car c'est une bibliothque de code  usage gnral
    et rutilisable),
    et ainsi aucune rsolution supplmentaire n'est ncessaire. De son ct,
    le programme excutable ne doit accomplir aucune action particulire
    pour utiliser les
    symboles du DSO car toutes les rsolutions sont effectues par le chargeur
    Unix. En fait, le code permettant d'invoquer
    <code>ld.so</code> fait partie du code de dmarrage pour l'excution qui
    est li dans tout programme excutable non statiquement li.
    L'avantage du chargement dynamique du code d'une bibliothque partage est
    vident : le code de la bibliothque ne doit tre stock qu'une seule fois
    dans une bibliothque systme telle que <code>libc.so</code>, ce qui permet
    d'conomiser de l'espace disque pour les autres programmes.</p>

    <p>Dans la seconde mthode, les DSO sont en gnral appels <em>objets
    partags</em> ou <em>fichiers DSO</em>, et peuvent tre nomms avec
    l'extension de son choix (bien que le nom conseill soit du style
    <code>foo.so</code>). Ces fichiers rsident en gnral dans un rpertoire
    spcifique  un programme, et aucun lien n'est automatiquement tabli avec
    le programme excutable dans lequel ils sont utiliss.
    Le programme excutable charge manuellement le DSO  l'excution dans son
    espace d'adressage  l'aide de l'appel systme <code>dlopen()</code>.
    A ce moment, aucune rsolution de symboles du DSO n'est effectue pour le
    programme excutable. Par contre le chargeur Unix
    rsoud automatiquement tout symbole du DSO (non encore rsolu)
    faisant partie de l'ensemble de symboles export par le programme
    excutable et ses bibliothques DSO dj charges (et en particulier tous
    les symboles de la bibliothque  tout faire <code>libc.so</code>).
    De cette faon, le DSO prend connaissance de l'ensemble de symboles du
    programme excutable comme s'il avait t li statiquement avec lui
    auparavant.</p>

    <p>Finalement, pour tirer profit de l'API des DSO, le programme excutable
    doit rsoudre certains symboles du DSO  l'aide de l'appel systme
    <code>dlsym()</code> pour une utilisation ultrieure dans les tables de
    distribution, <em>etc...</em> En d'autres termes, le programme excutable doit
    rsoudre manuellement tous les symboles dont il a besoin pour pouvoir les
    utiliser.
    Avantage d'un tel mcanisme : les modules optionnels du programme n'ont pas
    besoin d'tre chargs (et ne gaspillent donc pas de ressources mmoire)
    tant qu'il ne sont pas ncessaires au programme en question. Si ncessaire,
    ces modules peuvent tre chargs dynamiquement afin d'tendre les
    fonctionnalits de base du programme.</p>

    <p>Bien que ce mcanisme DSO paraisse vident, il comporte au moins une
    tape difficile : la rsolution des symboles depuis le programme excutable
    pour le DSO lorsqu'on utilise un DSO pour tendre les fonctionnalits d'un
    programme (la seconde mthode). Pourquoi ? Parce que la "rsolution
    inverse" des symboles DSO  partir du jeu de symboles du programme
    excutable dpend de la conception de la bibliothque (la bibliothque n'a
    aucune information sur le programme qui l'utilise) et n'est ni standardise
    ni disponible sur toutes les plateformes. En pratique, les symboles globaux
    du programme excutable ne sont en gnral pas rexports et donc
    indisponibles pour l'utilisation dans un DSO. Trouver une mthode pour
    forcer l'diteur de liens  exporter tous les symboles globaux est le
    principal problme que l'on doit rsoudre lorsqu'on utilise un DSO pour
    tendre les fonctionnalits d'un programme au moment de son excution.</p>

    <p>L'approche des bibliothques partages est la plus courante, parce que
    c'est dans cette optique que le mcanisme DSO a t conu ; c'est cette
    approche qui est ainsi
    utilise par pratiquement tous les types de bibliothques que fournit le
    systme d'exploitation. Par contre, les objets partags sont relativement
    peu utiliss pour tendre les fonctionnalits d'un programme.</p>

    <p>En 1998, seule une poigne de logiciels distribus
    utilisaient le mcanisme DSO pour rellement tendre leurs fonctionnalits
    au moment de l'excution : Perl 5 (via son mcanisme XS et le module
    DynaLoader), le serveur Netscape, <em>etc...</em> A partir de la
    version 1.3, Apache rejoignit ce groupe, car Apache
    prsentait dj un concept modulaire pour tendre ses fonctionnalits, et
    utilisait en interne une approche base sur une liste de distribution pour
    relier des modules externes avec les fonctionnalits de base d'Apache.
    Ainsi, Apache tait vraiment prdestin  l'utilisation des DSO pour
    charger ses modules au moment de l'excution.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="advantages" id="advantages">Avantages et inconvnients</a></h2>

    <p>Les fonctionnalits ci-dessus bases sur les DSO prsentent les
    avantages suivants :</p>

    <ul>
      <li>Le paquetage du serveur est plus flexible  l'excution car le
      processus serveur effectif peut tre assembl  l'excution via la
      directive <code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code> du fichier de
      configuration <code>httpd.conf</code> plutt que par des options du script
      <code class="program"><a href="./programs/configure.html">configure</a></code>  la compilation. Par exemple,
      on peut ainsi excuter diffrentes instances du serveur
      (standard et version SSL, version minimale et version toffe
      [mod_perl, PHP], <em>etc...</em>)  partir d'une seule installation
      d'Apache.</li>

      <li>Le paquetage du serveur peut tre facilement tendu avec des modules
      tiers, mme aprs l'installation. Ceci prsente en tout cas un gros
      avantage pour les mainteneurs de paquetages destins aux distributions,
      car ils peuvent crer un paquetage Apache de base, et des paquetages
      additionnels contenant des extensions telles que PHP, mod_perl, mod_fastcgi,
      <em>etc...</em></li>

      <li>Une facilit de prototypage des modules Apache car la paire
      DSO/<code class="program"><a href="./programs/apxs.html">apxs</a></code> vous permet d'une part de travailler en
      dehors de l'arborescence des sources d'Apache, et d'autre part de n'avoir
      besoin que de la commande <code>apxs -i</code>
      suivie d'un <code>apachectl restart</code> pour introduire une nouvelle
      version de votre module frachement dvelopp dans le serveur Apache
      en cours d'excution.</li>
    </ul>

    <p>Inconvnients des DSO :</p>

    <ul>
      <li>Le mcanisme DSO n'est pas disponible sur toutes les plates-formes
      car tous les systmes d'exploitation ne supportent pas le chargement
      dynamique de code dans l'espace d'adressage d'un programme.</li>

      <li>Le serveur est environ 20 % plus lent au dmarrage
       cause des rsolutions de symboles supplmentaires que le chargeur
      Unix doit effectuer.</li>

      <li>Le serveur est environ 5 % plus lent  l'excution
      sur certaines plates-formes, car le code indpendant de la position (PIC)
      ncessite parfois des manipulations compliques en assembleur pour
      l'adressage relatif qui ne sont pas toujours aussi rapides que celles
      que permet l'adressage absolu.</li>

      <li>Comme les modules DSO ne peuvent pas tre lis avec d'autres
      bibliothques bases sur DSO (<code>ld -lfoo</code>) sur toutes les
      plates-formes
      (par exemple, les plates-formes bases sur a.out ne fournissent en
      gnral pas cette fonctionnalit alors que les plates-formes bases sur
      ELF le font), vous ne pouvez pas utiliser le mcanisme DSO pour tous les
      types de modules. Ou en d'autres termes, les modules compils comme
      fichiers DSO sont contraints de n'utiliser que les symboles du coeur
      d'Apache, de la bibliothque C
      (<code>libc</code>) et toutes autres bibliothques statiques ou
      dynamiques utilises par le coeur d'Apache, ou d'archives statiques
      (<code>libfoo.a</code>) contenant du code indpendant de la
      position (PIC).
      Il y a deux solutions pour utiliser un autre type de code : soit le
      coeur d'Apache contient dj lui-mme une rfrence au code, soit vous
      chargez le code vous-mme via <code>dlopen()</code>.</li>
    </ul>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/dso.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/dso.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/dso.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/dso.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/dso.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2010 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div>
</body></html>