<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_cache - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_cache</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_cache.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_cache.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_cache.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_cache.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Mise en cache de contenu rfrenc par un
URI.</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>cache_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_cache.c</td></tr></table>
<h3>Sommaire</h3>

    <div class="warning">Ce module doit tre utilis avec prcautions
    car lorsque la directive <code class="directive"><a href="#cachequickhandler">CacheQuickHandler</a></code> est dfinie  sa
    valeur par dfaut <strong>on</strong>, les directives <code class="directive"><a href="../mod/mod_authz_host.html#allow">Allow</a></code> and <code class="directive"><a href="../mod/mod_authz_host.html#deny">Deny</a></code> sont court-circuites. Vous
    ne devez donc pas activer la gestion rapide de la mise en cache pour
    un contenu auquel vous souhaitez limiter l'accs en fonction du nom
    d'hte du client, de l'adresse IP ou d'une variable
    d'environnement.</div>

    <p><code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code> implmente une mise en cache de
    contenu HTTP compatible <a href="http://www.ietf.org/rfc/rfc2616.txt">RFC 2616</a> qui peut
    tre utilise pour mettre en cache des contenus locaux ou mandats.
    <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code> requiert les services d'un ou plusieurs
    modules de gestion de stockage. La distribution Apache de base
    inclut un module de gestion de stockage :</p>
    <dl>
    <dt><code class="module"><a href="../mod/mod_disk_cache.html">mod_disk_cache</a></code></dt>
    <dd>implmente un gestionnaire de stockage sur disque.</dd>
    </dl>

    <p>Les contenus sont stocks dans le cache et extraits de ce dernier
    en utilisant une cl  base d'URI. Un contenu dont l'accs est
    protg ne sera pas mis en cache.</p>
    <p>Pour de plus amples dtails, une description, et des exemples,
    reportez-vous au <a href="../caching.html">Guide de la mise en
    cache</a>.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#cachedefaultexpire">CacheDefaultExpire</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachedisable">CacheDisable</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cacheenable">CacheEnable</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cacheignorecachecontrol">CacheIgnoreCacheControl</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cacheignoreheaders">CacheIgnoreHeaders</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cacheignorenolastmod">CacheIgnoreNoLastMod</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cacheignorequerystring">CacheIgnoreQueryString</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cacheignoreurlsessionidentifiers">CacheIgnoreURLSessionIdentifiers</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachelastmodifiedfactor">CacheLastModifiedFactor</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachelock">CacheLock</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachelockmaxage">CacheLockMaxAge</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachelockpath">CacheLockPath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachemaxexpire">CacheMaxExpire</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cacheminexpire">CacheMinExpire</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachequickhandler">CacheQuickHandler</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachestorenostore">CacheStoreNoStore</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cachestoreprivate">CacheStorePrivate</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#related">Modules apparents et directives</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#sampleconf">Exemple de configuration</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#thunderingherd">Eviter une tempte de requte</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#finecontrol">Contrle fin via le filtre CACHE</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="../caching.html">Guide de la mise en
cache</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="related" id="related">Modules apparents et directives</a></h2>
    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="../mod/mod_disk_cache.html">mod_disk_cache</a></code></li></ul></td><td><ul><li><code class="directive"><a href="../mod/mod_disk_cache.html#cacheroot">CacheRoot</a></code></li><li><code class="directive"><a href="../mod/mod_disk_cache.html#cachedirlevels">CacheDirLevels</a></code></li><li><code class="directive"><a href="../mod/mod_disk_cache.html#cachedirlength">CacheDirLength</a></code></li><li><code class="directive"><a href="../mod/mod_disk_cache.html#cacheminfilesize">CacheMinFileSize</a></code></li><li><code class="directive"><a href="../mod/mod_disk_cache.html#cachemaxfilesize">CacheMaxFileSize</a></code></li></ul></td></tr></table>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="sampleconf" id="sampleconf">Exemple de configuration</a></h2>
    <div class="example"><h3>Extrait de httpd.conf</h3><p><code>
      #<br />
      # Exemple de configuration du cache<br />
      #<br />
      LoadModule cache_module modules/mod_cache.so<br />
      <br />
      &lt;IfModule mod_cache.c&gt;<br />
      <span class="indent">
        LoadModule disk_cache_module modules/mod_disk_cache.so<br />
        &lt;IfModule mod_disk_cache.c&gt;<br />
        <span class="indent">
          CacheRoot c:/cacheroot<br />
          CacheEnable disk  /<br />
          CacheDirLevels 5<br />
          CacheDirLength 3<br />
        </span>
        &lt;/IfModule&gt; <br />
        <br />
        # Lorsqu'on sert de mandataire, on ne met pas en cache la liste
	# des mises  jour de scurit<br />
        CacheDisable http://security.update.server/update-list/<br />
      </span>
      &lt;/IfModule&gt;
    </code></p></div>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="thunderingherd" id="thunderingherd">Eviter une tempte de requte</a></h2>
  <p>Lorsqu'une entre du cache est prime, <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code>
  soumet une requte conditionnelle au processus d'arrire-plan, qui est
  cens confirmer la validit de l'entre du cache, ou dans la ngative
  envoyer une entre mise  jour.</p>
  <p>Un court mais non ngligeable laps de temps existe entre le moment
  o l'entre du cache est prime, et le moment o elle est mise 
  jour. Sur un serveur fortement charg, un certain nombre de requtes
  peut arriver pendant ce laps de temps, et provoquer une
  <strong>tempte</strong> de requtes susceptibles de saturer le
  processus d'arrire-plan de manire soudaine et imprdictible.</p>
  <p>Pour contenir cette tempte, on peut utiliser la directive
  <code class="directive">CacheLock</code> afin de dfinir un rpertoire o
  seront crs <strong> la vole</strong> des verrous pour les URLs.
  Ces verrous sont utiliss comme autant d'<strong>indications</strong>
  par les autres requtes, soit pour empcher une tentative de mise en
  cache (un autre processus est en train de rcuprer l'entit), soit
  pour indiquer qu'une entre prime est en cours de mise  jour
  (pendant ce temps, c'est le contenu prim qui sera renvoy).
  </p>
  <h3>Mise en cache initiale d'une entre</h3>
    
    <p>Lorsqu'une entit est mise en cache pour la premire fois, un
    verrou est cr pour cette entit jusqu' ce que la rponse ait t
    entirement mise en cache. Pendant la dure de vie du verrou, le
    cache va empcher une seconde tentative de mise en cache de la mme
    entit. Bien que cela ne suffise pas  contenir la tempte de
    requtes, toute tentative de mettre en cache la mme entit
    plusieurs fois simultanment est stoppe.
    </p>
  
  <h3>Mise  jour d'une entre prime</h3>
    
    <p>Lorsqu'une entre atteint la limite de sa dure de vie, et
    devient par consquent prime, un verrou est cr pour cette entit
    jusqu' ce que la rponse ait t soit confirme comme encore
    valide, soit remplace par le processus d'arrire-plan. Pendant la
    dure de vie du verrou, une seconde requte entrante va provoquer le
    renvoi de la donne prime, et la tempte de requtes sera
    contenue.</p>
  
  <h3>Verrous et en-tte Cache-Control: no-cache</h3>
    
    <p>Les verrous ne sont utiliss <strong>qu' titre
    indicatif</strong> pour enjoindre le cache  tre plus coopratif
    avec les serveurs d'arrire-plan, et il est possible de passer outre
    si ncessaire. Si le client envoie une requte contenant un en-tte
    Cache-Control imposant un nouveau tlchargement de l'entit, tout
    verrou ventuel sera ignor, la requte du client sera honore
    immdiatement, et l'entre du cache mise  jour.</p>

    <p>Comme mcanisme de scurit supplmentaire, la dure de vie
    maximale des verrous est configurable. Lorsque cette limite est
    atteinte, le verrou est supprim et une autre requte peut alors en
    crer un nouveau. Cette dure de vie peut tre dfinie via la
    directive <code class="directive">CacheLockMaxAge</code>, et sa valeur par
    dfaut est de 5 secondes.
    </p>
  
  <h3>Exemple de configuration</h3>
    
    <div class="example"><h3>Activation du verrouillage du cache</h3><p><code>
      #<br />
      # Active le verrouillage du cache<br />
      #<br />
      &lt;IfModule mod_cache.c&gt;<br />
      <span class="indent">
        CacheLock on<br />
        CacheLockPath /tmp/mod_cache-lock<br />
        CacheLockMaxAge 5<br />
      </span>
      &lt;/IfModule&gt;
    </code></p></div>
  
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="finecontrol" id="finecontrol">Contrle fin via le filtre CACHE</a></h2>
  <p>Dans son mode de fonctionnement par dfaut, le cache s'excute sous
  la forme d'un gestionnaire rapide, court-circuitant la majorit des
  traitements du serveur et fournissant ainsi une mise en cache
  possdant les plus hautes performances disponibles.</p>

  <p>Dans ce mode, le cache <strong>s'incruste</strong> devant le
  serveur, comme si un mandataire de mise en cache indpendant RFC2616
  tait plac devant ce dernier.</p>

  <p>Bien que que ce mode offre les meilleures performances, les
  administrateurs peuvent souhaiter, dans certaines circonstances,
  effectuer des traitements sur la requte aprs que cette dernire ait
  t mise en cache, comme ajouter du contenu personnalis  la page
  mise en cache, ou appliquer des restrictions d'autorisations au
  contenu. Pour y parvenir, l'administrateur sera alors souvent forc de
  placer des serveurs mandataires inverses indpendants soit derrire,
  soit devant le serveur de mise en cache.</p>

  <p>Pour rsoudre ce problme, la directive <code class="directive"><a href="#cachequickhandler">CacheQuickHandler</a></code> peut tre dfinie 
  <strong>off</strong>, afin que le serveur traite toutes les phases
  normalement excutes par une requte non mise en cache, y compris les
  phases <strong>d'authentification et d'autorisation</strong>.</p>

  <p>En outre, l'administrateur peut ventuellement spcifier le
  <strong>point prcis dans la chane de filtrage</strong> o devra
  intervenir la mise en cache en ajoutant le filtre
  <strong>CACHE</strong>  la chane de filtrage en sortie.</p>

  <p>Par exemple, pour mettre en cache le contenu avant d'appliquer une
  compression  la rponse, placez le filtre <strong>CACHE</strong>
  avant le filtre <strong>DEFLATE</strong> comme dans l'exemple suivant
  :</p>

  <div class="example"><p><code>
    # Mise en cache du contenu avant la compression optionnelle<br />
    CacheQuickHandler off<br />
    AddOutputFilterByType CACHE;DEFLATE text/plain<br /><br />
  </code></p></div>

  <p>Une autre possibilit consiste  mettre en cache le contenu avant
  l'ajout de contenu personnalis via <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> (ou
  tout autre filtre de traitement de contenu). Dans l'exemple suivant,
  les modles contenant des balises comprises par
  <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> sont mis en cache avant d'tre
  interprts :</p>

  <div class="example"><p><code>
    # Mise en cache du contenu avant l'intervention de mod_include et
    # mod_deflate<br />
    CacheQuickHandler off<br />
    AddOutputFilterByType CACHE;INCLUDES;DEFLATE text/html<br /><br />
  </code></p></div>

  <p>Vous pouvez insrer le filtre <strong>CACHE</strong> en tout point
  de la chane de filtrage. Dans l'exemple suivant, le contenu est mis
  en cache aprs avoir t interprt par <code class="module"><a href="../mod/mod_include.html">mod_include</a></code>,
  mais avant d'tre trait par <code class="module"><a href="../mod/mod_deflate.html">mod_deflate</a></code> :</p>

  <div class="example"><p><code>
    # Mise en cache du contenu entre les interventions de mod_include et
    # mod_deflate<br />
    CacheQuickHandler off<br />
    AddOutputFilterByType INCLUDES;CACHE;DEFLATE text/html<br /><br />
  </code></p></div>

  <div class="warning"><h3>Avertissement :</h3>Si pour une raison
  ou pour une autre, le point d'insertion du filtre
  <strong>CACHE</strong> dans la chane de filtrage est modifi, vous
  devez <strong>vider votre cache</strong> pour tre sr que les donnes
  servies soient  jour. En effet, <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code> n'est pas
  en mesure d'effectuer cette opration  votre place.</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheDefaultExpire" id="CacheDefaultExpire">CacheDefaultExpire</a> <a name="cachedefaultexpire" id="cachedefaultexpire">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La dure par dfaut de mise en cache d'un document
lorsqu'aucune date d'expiration n'a t spcifie.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheDefaultExpire <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheDefaultExpire 3600 (une heure)</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>La directive <code class="directive">CacheDefaultExpire</code> permet de
    spcifier un temps par dfaut, en secondes, pendant lequel sera
    conserv dans le cache un document qui ne possde ni date
    d'expiration, ni date de dernire modification. La valeur de cette
    directive est crase par la valeur de la directive
    <code class="directive">CacheMaxExpire</code> si cette dernire est
    utilise.</p>

    <div class="example"><p><code>
      CacheDefaultExpire 86400
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheDisable" id="CacheDisable">CacheDisable</a> <a name="cachedisable" id="cachedisable">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dsactive la mise en cache des URLs
spcifies</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheDisable <var>chane-url</var> | <var>on</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>La directive <code class="directive">CacheDisable</code> enjoint
    <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code> de <em>ne pas</em> mettre en cache l'URL
    spcifie par <var>chane URL</var>, ainsi que les URLs de niveaux
    infrieurs.</p>

    <div class="example"><h3>Exemple</h3><p><code>
      CacheDisable /fichiers_locaux
    </code></p></div>

    <p>Si la directive se trouve  l'intrieur d'une section <code class="directive">&lt;Location&gt;</code>, le chemin doit tre spcifi en
    dessous de la Location, et si le mot "on" est utilis, la mise en
    cache sera dsactive pour l'ensemble de l'arborescence concerne
    par la section Location.</p>

    <div class="example"><h3>Exemple</h3><p><code>
      &lt;Location /foo&gt;<br />
        CacheDisable on<br />
      &lt;/Location&gt;<br />
    </code></p></div>

    <p>Avec les versions 2.2.12 et ultrieures, on peut dfinir la
    variable d'environnement <code>no-cache</code> pour une dfinition
    plus fine des ressources  mettre en cache.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="../env.html">Les variables d'environnement dans
Apache</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheEnable" id="CacheEnable">CacheEnable</a> <a name="cacheenable" id="cacheenable">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la mise en cache des URLs spcifies en utilisant le
gestionnaire de stockage prcis</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheEnable <var>type de cache</var> <var>chane URL</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>La directive <code class="directive">CacheEnable</code> enjoint
    <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code> de mettre en cache l'URL prcise par
    <var>chane URL</var>, ainsi que les URLs de niveaux infrieurs. Le
    gestionnaire de stockage du cache est spcifi  l'aide de
    l'argument <var>type de cache</var>. Si la directive
    <code class="directive">CacheEnable</code> est situe  l'intrieur d'une
    section <code class="directive">&lt;Location&gt;</code>, le paramtre
    <var>url-string</var> devient optionnel. Si <var>type de cache</var>
    a pour valeur <code>disk</code>, <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code>
    utilisera le gestionnaire de stockage sur disque implment par
    <code class="module"><a href="../mod/mod_disk_cache.html">mod_disk_cache</a></code>.</p>
    <p>Si les diffrentes directives <code class="directive">CacheEnable</code>
    spcifient des URLs qui se recoupent (comme dans l'exemple
    ci-dessous), tous les gestionnaires de stockage possibles seront
    lancs, jusqu'au premier d'entre eux qui traitera effectivement la
    requte.
    L'ordre dans lequel les gestionnaires de stockage sont lancs est
    dtermin par l'ordre dans lequel apparaissent les directives
    <code class="directive">CacheEnable</code> dans le fichier de
    configuration.</p>

    <p>En fonctionnement du type serveur mandataire direct, <var>chane
    URL</var> peut aussi tre utilis pour spcifier des sites distants
    et des protocoles de mandat pour lesquels la mise en cache devra
    tre active.</p>

    <div class="example"><p><code>
      # Mise en cache des URLs mandates<br />
      CacheEnable  disk  /<br /><br />
      # Mise en cache des URLs FTP mandates<br />
      CacheEnable  disk  ftp://<br /><br />
      # Mise en cache des contenus situs dans www.apache.org<br />
      CacheEnable  disk  http://www.apache.org/<br />
    </code></p></div>

    <p>Un nom d'hte commenant par un caractre <strong>"*"</strong>
    correspondra  tout nom d'hte se terminant par le suffixe
    considr. Un nom d'hte commenant par un caractre
    <strong>"."</strong> correspondra  tout nom d'hte contenant le
    composant de nom de domaine qui suit ce caractre.</p>

    <div class="example"><p><code>
      # Correspond  www.apache.org et fooapache.org<br />
      CacheEnable  disk  http://*apache.org/<br />
      # Correspond  www.apache.org, mais pas  fooapache.org<br />
      CacheEnable  disk  http://.apache.org/<br />
    </code></p></div>

    <p>Depuis la version 2.2.12, on peut dfinir la variable
    d'environnement <code>no-cache</code> pour une dfinition plus fine
    des ressources  mettre en cache.</p>


<h3>Voir aussi</h3>
<ul>
<li><a href="../env.html">Les variables d'environnement dans
Apache</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheIgnoreCacheControl" id="CacheIgnoreCacheControl">CacheIgnoreCacheControl</a> <a name="cacheignorecachecontrol" id="cacheignorecachecontrol">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ignore les en-ttes de requte enjoignant de ne pas servir
le contenu au client depuis le cache</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheIgnoreCacheControl On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheIgnoreCacheControl Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>Normalement, les requtes contenant des en-ttes tels que
    Cache-Control: no-cache ou Pragma: no-cache ne sont pas servies
    depuis le cache. La directive
    <code class="directive">CacheIgnoreCacheControl</code> permet de modifier ce
    comportement. Avec <code class="directive">CacheIgnoreCacheControl
    On</code>, le serveur tentera de servir la ressource depuis le
    cache, mme si la requte contient un des en-ttes cits plus haut.
    Les ressources qui requirent une autorisation ne seront
    <em>jamais</em> mises en cache.</p>

    <div class="example"><p><code>
      CacheIgnoreCacheControl On
    </code></p></div>

    <div class="warning"><h3>Avertissement :</h3>
       Cette directive permet de servir des ressources depuis le cache,
       mme si le client a demand  ce qu'il n'en soit pas ainsi. Le
       contenu servi est ainsi susceptible d'tre prim.
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#cachestoreprivate">CacheStorePrivate</a></code></li>
<li><code class="directive"><a href="#cachestorenostore">CacheStoreNoStore</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheIgnoreHeaders" id="CacheIgnoreHeaders">CacheIgnoreHeaders</a> <a name="cacheignoreheaders" id="cacheignoreheaders">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ne pas stocker le(s) en-tte(s) spcifi(s) dans le cache.
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheIgnoreHeaders <var>en-tte</var> [<var>en-tte</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheIgnoreHeaders None</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>En accord avec la RFC 2616, les en-ttes HTTP hop-by-hop ne sont
    pas stocks dans le cache. Les en-ttes HTTP suivant sont des
    en-ttes hop-by-hop, et en tant que tels, ne sont en  <em>aucun</em>
    cas stocks dans le cache, quelle que soit la dfinition de la
    directive <code class="directive">CacheIgnoreHeaders</code> :</p>

    <ul>
      <li><code>Connection</code></li>
      <li><code>Keep-Alive</code></li>
      <li><code>Proxy-Authenticate</code></li>
      <li><code>Proxy-Authorization</code></li>
      <li><code>TE</code></li>
      <li><code>Trailers</code></li>
      <li><code>Transfer-Encoding</code></li>
      <li><code>Upgrade</code></li>
    </ul>

    <p>La directive <code class="directive">CacheIgnoreHeaders</code> permet de
    spcifier quels en-ttes HTTP ne doivent pas tre stocks dans le
    cache. Par exemple, il peut s'avrer pertinent dans certains cas de
    ne pas stocker les cookies dans le cache.</p>

    <p>La directive <code class="directive">CacheIgnoreHeaders</code> accepte
    une liste d'en-ttes HTTP spars par des espaces, qui ne doivent
    pas tre stocks dans le cache. Si les en-ttes hop-by-hop sont les
    seuls  ne pas devoir tre stocks dans le cache (le comportement
    compatible RFC 2616), la directive
    <code class="directive">CacheIgnoreHeaders</code> peut tre dfinie 
    <code>None</code>.</p>

    <div class="example"><h3>Exemple 1</h3><p><code>
      CacheIgnoreHeaders Set-Cookie
    </code></p></div>

    <div class="example"><h3>Exemple 2</h3><p><code>
      CacheIgnoreHeaders None
    </code></p></div>

    <div class="warning"><h3>Avertissement :</h3>
      Si des en-ttes ncessaires  la bonne gestion du cache, comme
      <code>Expires</code>, ne sont pas stocks suite  la dfinition
      d'une directive <code class="directive">CacheIgnoreHeaders</code>, le
      comportement de mod_cache sera imprvisible.
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheIgnoreNoLastMod" id="CacheIgnoreNoLastMod">CacheIgnoreNoLastMod</a> <a name="cacheignorenolastmod" id="cacheignorenolastmod">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ignore le fait qu'une rponse ne possde pas d'en-tte Last
Modified.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheIgnoreNoLastMod On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheIgnoreNoLastMod Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>Normalement, les documents qui ne possdent pas de date de
    dernire modification ne sont pas mis en cache. Dans certaines
    circonstances, la date de dernire modification est supprime (au
    cours des traitements lis  <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> par
    exemple), ou n'existe tout simplement pas. La directive
    <code class="directive">CacheIgnoreNoLastMod</code> permet de spcifier si
    les documents ne possdant pas de date de dernire modification
    doivent tre mis en cache, mme sans date de dernire modification.
    Si le document ne possde ni date d'expiration, ni date de dernire
    modification, la valeur spcifie par la directive
    <code class="directive">CacheDefaultExpire</code> servira  gnrer une date
    d'expiration.
    </p>

    <div class="example"><p><code>
      CacheIgnoreNoLastMod On
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheIgnoreQueryString" id="CacheIgnoreQueryString">CacheIgnoreQueryString</a> <a name="cacheignorequerystring" id="cacheignorequerystring">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ignore la chane de paramtres lors de la mise en
cache</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheIgnoreQueryString On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheIgnoreQueryString Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>Normalement, les requtes comportant une chane de paramtres
    sont mises en cache sparment si leurs chanes de paramtres
    diffrent.
    En accord avec la RFC 2616/13.9, cette mise en cache n'est effectue
    sparment que si une date d'expiration est spcifie. La directive
    <code class="directive">CacheIgnoreQueryString</code> permet la mise en
    cache de requtes mme si aucune date d'expiration est spcifie, et
    de renvoyer une rponse depuis la cache mme si les chanes de
    paramtres diffrent. Du point de vue du cache, la requte est
    traite comme si elle ne possdait pas de chane de paramtres
    lorsque cette directive est active.</p>

    <div class="example"><p><code>
      CacheIgnoreQueryString On
    </code></p></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheIgnoreURLSessionIdentifiers" id="CacheIgnoreURLSessionIdentifiers">CacheIgnoreURLSessionIdentifiers</a> <a name="cacheignoreurlsessionidentifiers" id="cacheignoreurlsessionidentifiers">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ignore les identifiants de session dfinis encods dans
l'URL lors de la mise en cache
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheIgnoreURLSessionIdentifiers <var>identifiant</var>
[<var>identifiant</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheIgnoreURLSessionIdentifiers None</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>Certaines applications encodent l'identifiant de session dans
    l'URL comme dans l'exemple suivant :
    </p>
    <ul>
      <li><code>/une-application/image.gif;jsessionid=123456789</code></li>
      <li><code>/une-application/image.gif?PHPSESSIONID=12345678</code></li>
    </ul>
    <p>Ceci implique la mise en cache des ressources sparment pour
    chaque session, ce qui n'est en gnral pas souhait. La directive
    <code class="directive">CacheIgnoreURLSessionIdentifiers</code> permet de
    dfinir une liste d'identifiants qui seront supprims de la cl
    utilise pour identifier une entit dans le cache, de faon  ce que
    les ressources ne soient pas stockes sparment pour chaque
    session.
    </p>
    <p><code>CacheIgnoreURLSessionIdentifiers None</code> vide la liste
    des identifiants ignors. Autrement, chaque identifiant spcifi est
    ajout  la liste.</p>

    <div class="example"><h3>Exemple 1</h3><p><code>
      CacheIgnoreURLSessionIdentifiers jsessionid
    </code></p></div>

    <div class="example"><h3>Exemple 2</h3><p><code>
      CacheIgnoreURLSessionIdentifiers None
    </code></p></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheLastModifiedFactor" id="CacheLastModifiedFactor">CacheLastModifiedFactor</a> <a name="cachelastmodifiedfactor" id="cachelastmodifiedfactor">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le facteur utilis pour gnrer une date d'expiration en
fonction de la date de dernire modification.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheLastModifiedFactor <var>flottant</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheLastModifiedFactor 0.1</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>Si un document ne possde pas de date d'expiration, elle peut
    tre calcule en fonction de la date de dernire modification, si
    elle existe. La directive
    <code class="directive">CacheLastModifiedFactor</code> permet de spcifier
    un <var>facteur</var>  utiliser pour la gnration de cette date
    d'expiration au sein de la formule suivante :

    <code>dlai-expiration = dure-depuis-date-dernire-modification *
    <var>facteur</var>
    date-expiration = date-courante + dlai-expiration</code>

    Par exemple, si la dernire modification du document date de 10
    heures, et si <var>facteur</var> a pour valeur 0.1, le dlai
    d'expiration sera de 10*0.1 = 1 heure. Si l'heure courante est
    3:00pm, la date d'expiration calcule sera 3:00pm + 1 heure =
    4:00pm.

    Si le dlai d'expiration est suprieur  celui spcifi par la
    directive <code class="directive">CacheMaxExpire</code>, c'est ce dernier
    qui l'emporte.</p>

    <div class="example"><p><code>
      CacheLastModifiedFactor 0.5
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheLock" id="CacheLock">CacheLock</a> <a name="cachelock" id="cachelock">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la protection contre les temptes de requtes.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheLock <var>on|off</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheLock off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
  <p>La directive <code class="directive">CacheLock</code> active la protection
  contre les temptes de requtes pour l'espace d'adressage donn.</p>

  <p>La configuration minimale pour activer le verrouillage contre les
  temptes de requtes dans le rpertoire temp par dfaut du systme est
  la suivante :</p>

  <div class="example"><p><code>
    # Active le verrouillage du cache<br />
    CacheLock on<br /><br />
  </code></p></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheLockMaxAge" id="CacheLockMaxAge">CacheLockMaxAge</a> <a name="cachelockmaxage" id="cachelockmaxage">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la dure de vie maximale d'un verrou de cache.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheLockMaxAge <var>entier</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheLockMaxAge 5</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
  <p>La directive <code class="directive">CacheLockMaxAge</code> permet de
  spcifier la dure de vie maximale d'un verrou de cache.</p>

  <p>Un verrou plus ancien que cette valeur exprime en secondes sera
  ignor, et la prochaine requte entrante sera alors en mesure de
  recrer le verrou. Ce mcanisme permet d'viter les mises  jour trop
  longues inities par des clients lents.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheLockPath" id="CacheLockPath">CacheLockPath</a> <a name="cachelockpath" id="cachelockpath">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit le rpertoire des verrous.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheLockPath <var>rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheLockPath /tmp/mod_cache-lock</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
  <p>La directive <code class="directive">CacheLockPath</code> permet de
  spcifier le rpertoire dans lequel les verrous sont crs. Par
  dfaut, c'est le rpertoire temporaire du systme qui est utilis. Les
  verrous sont des fichiers vides qui n'existent que pour les URLs
  primes en cours de mise  jour, et consomment donc bien moins de
  ressources que le traditionnel cache sur disque.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheMaxExpire" id="CacheMaxExpire">CacheMaxExpire</a> <a name="cachemaxexpire" id="cachemaxexpire">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La dure maximale en secondes de mise en cache d'un
document</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheMaxExpire <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheMaxExpire 86400 (une journe)</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>La directive <code class="directive">CacheMaxExpire</code> permet de
    spcifier le nombre maximum de secondes pendant lequel les documents
    HTTP suceptibles d'tre mis en cache seront conservs sans vrifier
    leur contenu sur le serveur d'origine. Ce nombre de secondes
    correspond donc  la dure maximale pendant laquelle un document ne
    sera pas  jour. L'utilisation de cette valeur maximale est force,
    mme si le document possde une date d'expiration.</p>

    <div class="example"><p><code>
      CacheMaxExpire 604800
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheMinExpire" id="CacheMinExpire">CacheMinExpire</a> <a name="cacheminexpire" id="cacheminexpire">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>La dure minimale en secondes de mise en cache d'un
document</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheMinExpire <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheMinExpire 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>La directive <code class="directive">CacheMaxExpire</code> permet de
    spcifier le nombre maximum de secondes pendant lequel les documents
    HTTP suceptibles d'tre mis en cache seront conservs sans vrifier
    leur contenu sur le serveur d'origine. Elle n'est prise en compte
    que dans le cas o le document ne possde aucune date d'expiration
    valide.</p>

    <div class="example"><p><code>
      CacheMinExpire 3600
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheQuickHandler" id="CacheQuickHandler">CacheQuickHandler</a> <a name="cachequickhandler" id="cachequickhandler">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Excute le cache  partir d'un gestionnaire rapide.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheQuickHandler <var>on|off</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheQuickHandler on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>La directive <code class="directive"><a href="#cachequickhandler">CacheQuickHandler</a></code> permet de contrler
    la phase au cours de laquelle la mise en cache est effectue.</p>

    <p>Avec la configuration par dfaut, le cache agit au cours de la
    phase du gestionnaire rapide. Cette phase court-circuite la majorit
    des traitements du serveur, et constitue le mode d'opration le plus
    performant pour un serveur typique. Le cache
    <strong>s'incruste</strong> devant le serveur, et la majorit des
    traitements du serveur est court-circuite.</p>

    <p>Lorsque cette directive est dfinie  off, le cache agit comme un
    gestionnaire normal, et est concern par toutes les phases de
    traitement d'une requte. Bien que ce mode soit moins performant que
    le mode par dfaut, il permet d'utiliser le cache dans les cas o un
    traitement complet de la requte est ncessaire, comme par exemple
    lorsque le contenu est soumis  autorisation.</p>

    <div class="example"><p><code>
      # Excute le cache comme un gestionnaire normal<br />
      CacheQuickHandler off<br /><br />
    </code></p></div>

    <p>Lorsque le gestionnaire rapide est dsactiv, l'administrateur a
    aussi la possibilit de choisir avec prcision le point de la chane
    de filtrage o la mise en cache sera effectue, en utilisant le
    filtre <strong>CACHE</strong>.</p>

    <div class="example"><p><code>
      # Mise en cache du contenu avant l'intervention de mod_include et
      # mod_deflate<br />
      CacheQuickHandler off<br />
      AddOutputFilterByType CACHE;INCLUDES;DEFLATE text/html<br /><br />
    </code></p></div>

    <p>Si le filtre CACHE est spcifi plusieurs fois, c'est la dernire
    instance qui sera prise en compte.</p>

  
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheStoreNoStore" id="CacheStoreNoStore">CacheStoreNoStore</a> <a name="cachestorenostore" id="cachestorenostore">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Tente de mettre en cache les requtes ou rponses dont
l'entte Cache-Control: a pour valeur no-store.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheStoreNoStore On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheStoreNoStore Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>Normalement, les requtes ou rponses dont l'en-tte
    Cache-Control: a pour valeur no-store ne sont pas stockes dans le
    cache. La directive <code class="directive">CacheStoreNoCache</code> permet
    de modifier ce comportement. Si
    <code class="directive">CacheStoreNoCache</code> est dfinie  On, le
    serveur tente de mettre la ressource en cache mme si elle contient
    des en-ttes ayant pour valeur no-store. Les ressources
    ncessitant une autorisation ne sont <em>jamais</em> mises en
    cache.</p>

    <div class="example"><p><code>
      CacheStoreNoStore On
    </code></p></div>

    <div class="warning"><h3>Avertissement :</h3>
       Selon la RFC 2616, la valeur d'en-tte no-store est cense
       "prvenir la suppression ou la rtention par inadvertance
       d'informations sensibles (par exemple, sur des bandes de
       sauvegarde)". Autrement dit, l'activation de la directive
       <code class="directive">CacheStoreNoCache</code> pourrait provoquer le
       stockage d'informations sensibles dans le cache. Vous avez donc
       t prvenus.
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#cacheignorecachecontrol">CacheIgnoreCacheControl</a></code></li>
<li><code class="directive"><a href="#cachestoreprivate">CacheStorePrivate</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="CacheStorePrivate" id="CacheStorePrivate">CacheStorePrivate</a> <a name="cachestoreprivate" id="cachestoreprivate">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Tente de mettre en cache des rponses que le serveur a
marques comme prives</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>CacheStorePrivate On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>CacheStorePrivate Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_cache</td></tr>
</table>
    <p>Normalement, les rponse comportant un en-tte Cache-Control:
    dont la valeur est private ne seront pas stockes dans le cache. La
    directive <code class="directive">CacheStorePrivate</code> permet de
    modifier ce comportement. Si
    <code class="directive">CacheStorePrivate</code> est dfinie  On, le
    serveur tentera de mettre la ressource en cache, mme si elle
    contient des en-ttes ayant pour valeur private. Les ressources
    ncessitant une autorisation ne sont <em>jamais</em> mises en
    cache.</p>

    <div class="example"><p><code>
      CacheStorePrivate On
    </code></p></div>

    <div class="warning"><h3>Avertissement :</h3>
       Cette directive autorise la mise en cache mme si le serveur
       indique que la ressource ne doit pas tre mise en cache. Elle
       n'est de ce fait approprie que dans le cas d'un cache
       'priv'.
    </div>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#cacheignorecachecontrol">CacheIgnoreCacheControl</a></code></li>
<li><code class="directive"><a href="#cachestorenostore">CacheStoreNoStore</a></code></li>
</ul>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_cache.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_cache.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_cache.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_cache.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2010 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>