<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_authz_host - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_authz_host</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authz_host.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authz_host.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Autorisations de groupe bases sur l'hte (nom ou adresse
IP)</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>authz_host_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_authz_host.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis les versions 2.3 et suprieures
d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Les fournisseurs d'autorisation implments par le module
    <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code> sont enregistrs  l'aide des
    directives <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> ou
    <code class="directive"><a href="../mod/mod_authz_core.html#match">Match</a></code>. On peut
    utiliser ces directives  l'intrieur de sections <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>, <code class="directive"><a href="../mod/core.html#files">&lt;Files&gt;</a></code>, ou <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code> ou de fichiers
    <code><a href="core.html#accessfilename">.htaccess</a> </code> pour
    contrler l'accs  certaines zones du serveur. Le contrle d'accs
    peut tre effectu en fonction du nom d'hte, de l'adresse IP, ou
    d'autres caractristiques de la requte client, telles qu'elles sont
    enregistres dans des <a href="../env.html">variables
    d'environnement</a>.</p>

    <p>En gnral, les directives de restriction d'accs s'appliquent 
    toutes les mthodes d'accs (<code>GET</code>, <code>PUT</code>,
    <code>POST</code>, etc...). C'est d'ailleurs ce que l'on souhaite
    dans la plupart des cas. Il est cependant possible de ne restreindre
    l'accs que pour certaines mthodes, tout en laissant les autres
    mthodes sans protection, en plaant les directives dans une section
    <code class="directive"><a href="../mod/core.html#limit">&lt;Limit&gt;</a></code>.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<p>Ce module ne fournit aucune directive.</p>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#requiredirectives">Les directives Require</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="../howto/auth.html">Authentification, autorisation et
contrle d'accs</a></li>
<li><code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code></li>
<li><code class="directive"><a href="../mod/mod_authz_core.html#match">Match</a></code></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="requiredirectives" id="requiredirectives">Les directives Require</a></h2>

    <p>Les directives d'Apache <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> et <code class="directive"><a href="../mod/mod_authz_core.html#match">Match</a></code> sont utilises au cours de
    la phase d'autorisation pour vrifier si un utilisateur se voit
    accorder ou refuser l'accs  une ressource. mod_authz_host fournit
    les types d'autorisation <code>env</code>, <code>ip</code>,
    <code>host</code> et <code>all</code>. D'autres types d'autorisation
    sont aussi disponibles, mais ncessitent le chargement des modules
    d'autorisation appropris.</p>

    <p>Ces fournisseurs d'autorisation permettent de dterminer quels
    htes peuvent accder  une zone du serveur. On peut contrler
    l'accs en fonction du nom d'hte, de l'adresse IP, d'un intervalle
    d'adresses IP, ou d'autres caractristiques de la requte client
    enregistres dans des variables d'environnement.</p>

<h3><a name="reqenv" id="reqenv">Require env</a></h3>

    <p>Le fournisseur <code>env</code> permet de contrler l'accs au
    serveur en fonction de l'existence d'une <a href="../env.html">variable d'environnement</a>. Lorsque
    <code>Require env <var>env-var</var></code> est spcifi, la
    requte est autorise si la variable d'environnement
    <var>env-var</var> existe. Le serveur fournit la possibilit
    de dfinir des variables d'environnement avec une grande souplesse
    en fonction des caractristiques de la requte client  l'aide des
    directives fournies par le module <code class="module"><a href="../mod/mod_setenvif.html">mod_setenvif</a></code>. On
    peut ainsi utiliser cette directive pour contrler l'accs en
    fonction de certains en-ttes comme <code>User-Agent</code> (type de
    navigateur), <code>Referer</code>, etc...</p>

    <div class="example"><h3>Exemple :</h3><p><code>
      SetEnvIf User-Agent ^KnockKnock/2\.0 laisse_moi_entrer<br />
      &lt;Directory /docroot&gt;<br />
      <span class="indent">
        Require env laisse_moi_entrer<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>

    <p>Dans cet exemple, les navigateurs dont la chane de description
    de l'en-tte user-agent commence par <code>KnockKnock/2.0</code> se
    verront accorder l'accs, alors que tous les autres se le verront
    refuser.</p>



<h3><a name="reqip" id="reqip">Require ip</a></h3>

    <p>Le fournisseur <code>ip</code> permet de contrler l'accs au
    serveur en fonction de l'adresse IP du client distant. Lorsque
    <code>Require ip <var>adresse-ip</var></code> est spcifi, la
    requte est autorise si l'adresse IP du client distant correspond
    </p>

    <p>Une adresse IP complte :</p>

    <div class="example"><p><code>
      Require ip 10.1.2.3<br />
      Require ip 192.168.1.104 192.168.1.205
    </code></p></div>

    <p>L'adresse IP d'un hte pour qui l'accs est accord</p>

    <p>Une adresse IP partielle :</p>

    <div class="example"><p><code>
      Require ip 10.1<br />
      Require ip 10 172.20 192.168.2
    </code></p></div>
    <p>Les 1  3 premiers octets d'une adresse IP, pour une restriction
     un sous-rseau.</p>

    <p>Une paire rseau/masque de sous-rseau :</p>

    <div class="example"><p><code>
      Require ip 10.1.0.0/255.255.0.0
    </code></p></div>
    <p>Un rseau a.b.c.d, et un masque de sous-rseau w.x.y.z. pour une
    restriction de sous-rseau plus fine.</p>

    <p>Une spcification CIDR rseau/nnn :</p>

    <div class="example"><p><code>
      Require ip 10.1.0.0/16
    </code></p></div>
    <p>Identique au cas prcdent, except que le masque de sous-rseau
    reprsente les nnn premiers bits de poids fort.</p>

    <p>Notez que les trois derniers exemples correspondent exectement au
    mme ensemble d'htes.</p>

    <p>On peut spcifier des adresses et des sous-rseaux IPv6 comme
    suit :</p>

    <div class="example"><p><code>
     Require ip 2001:db8::a00:20ff:fea7:ccea<br />
     Require ip 2001:db8::a00:20ff:fea7:ccea/10
    </code></p></div>




<h3><a name="reqhost" id="reqhost">Require host</a></h3>

    <p>Le fournisseur <code>host</code> permet de contrler l'accs au
    serveur en fonction du nom d'hte du client distant. Lorsque
    <code>Require host <var>nom-hte</var></code> est spcifi, la
    requte est autorise si le nom d'hte correspond </p>

    <p>Un nom de domaine (ventuellement partiel)</p>

    <div class="example"><p><code>
    Require host apache.org<br />
    Require host .net example.edu
    </code></p></div>

    <p>Les htes dont les noms correspondent ou se terminent par la
    chane spcifie se voient accorder l'accs. Seuls les lment de
    nom de domaine complets sont mis en correspondance ; ainsi,
    l'exemple ci-dessus correspondra  <code>foo.apache.org</code>, mais
    ne correspondra pas  <code>fooapache.org</code>. Avec cette
    configuration, Apache va effectuer une double recherche DNS sur
    l'adresse IP du client, sans tenir compte de la dfinition de la
    directive  <code class="directive"><a href="../mod/core.html#hostnamelookups">HostnameLookups</a></code>. Il
    va effectuer une recherche DNS inverse sur l'adresse IP pour trouver
    le nom d'hte associ, puis une recherche DNS directe sur le nom
    d'hte pour vrifier qu'il correspond bien  l'adresse IP originale.
    L'accs ne sera accord que si le nom d'hte correspond et si les
    recherches DNS inverse et directe sont cohrentes.</p>



<h3><a name="reqall" id="reqall">Require all</a></h3>

    <p>Le fournisseur <code>all</code> imite la fonctionnalit
    prcdemment fournie par les directives 'Allow from all' et 'Deny
    from all'. Le fournisseur accepte un des deux arguments 'granted' ou
    'denied'. Dans les exemples suivants, le premier
    accorde l'accs  toutes les requtes, alors que le second le
    refuse.</p>

    <div class="example"><p><code>
    Require all granted<br />
    </code></p></div>

    <div class="example"><p><code>
    Require all denied<br />
    </code></p></div>




</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authz_host.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authz_host.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2010 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>