<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Chiffrement fort SSL/TLS : Mode d'emploi - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">SSL/TLS</a></div><div id="page-content"><div id="preamble"><h1>Chiffrement fort SSL/TLS : Mode d'emploi</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/ssl/ssl_howto.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/ssl/ssl_howto.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>

<blockquote>
<p>La solution  ce problme est vidente et le lecteur la recherchera
 titre d'exercice</p>

<p class="cite">-- <cite>Phrase standard des manuels</cite></p>
</blockquote>

<p>Rsoudre des problmes de scurit particuliers pour un serveur web
utilisant SSL n'est pas toujours vident  cause des interactions entre SSL,
HTTP et la manire dont Apache traite les requtes. Ce chapitre donne des
instructions pour rsoudre certaines situations typiques. Considrez-le
comme une premire tape sur le chemin de la solution dfinitive, mais
efforcez-vous toujours de comprendre ce que vous faites pour rsoudre le
problme avant d'utiliser la solution. Rien n'est pire que d'utiliser une
solution de scurit sans connatre ses restrictions et la manire dont elle
interagit avec les autres systmes.</p>
</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#ciphersuites">Suites de chiffrement et mise en application de la scurit
de haut niveau</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#accesscontrol">Authentification du client et contrle d'accs</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="ciphersuites" id="ciphersuites">Suites de chiffrement et mise en application de la scurit
de haut niveau</a></h2>

<ul>
<li><a href="#realssl">Comment crer un vritable serveur
SSLv2 seulement ?</a></li>
<li><a href="#onlystrong">Comment crer un serveur SSL
qui n'accepte que le chiffrement fort ?</a></li>
<li><a href="#upgradeenc">Comment crer un serveur SSL qui n'accepte que le
chiffrement fort, mais permet aux navigateurs imports des USA
d'voluer vers un chiffrement plus fort ?</a></li>
<li><a href="#strongurl">Comment crer un serveur qui accepte tous les types de
chiffrement en gnral, mais exige un chiffrement fort pour pouvoir
accder  une URL particulire ?</a></li>
</ul>

<h3><a name="realssl" id="realssl">Comment crer un vritable serveur SSLv2 seulement ?</a></h3>

    <p>Les directives suivantes crent un serveur SSL qui ne communique que
    selon le protocole SSLv2 et ses modes de chiffrement.</p>

    <div class="example"><h3>httpd.conf</h3><p><code>
      SSLProtocol -all +SSLv2<br />
      SSLCipherSuite SSLv2:+HIGH:+MEDIUM:+LOW:+EXP<br />
    </code></p></div>


<h3><a name="onlystrong" id="onlystrong">Comment crer un serveur SSL qui n'accepte
que le chiffrement fort ?</a></h3>

    <p>Les directives suivantes ne permettent que les
    chiffrements de plus haut niveau :</p>
    <div class="example"><h3>httpd.conf</h3><p><code>
      SSLProtocol all<br />
      SSLCipherSuite HIGH:MEDIUM<br />
    </code></p></div>


<h3><a name="upgradeenc" id="upgradeenc">Comment crer un serveur SSL qui n'accepte que le
chiffrement fort, mais permet aux navigateurs imports des USA
d'voluer vers un chiffrement plus fort ?</a></h3>

    <p>Cette fonctionnalit se nomme Cryptographie Transfre par Serveur
    (Server Gated Cryptography - SGC) et ncessite un certificat de serveur
     identifiant global, sign par un certificat de CA spcial de chez
    Verisign. Ceci permet d'activer le chiffrement fort dans les versions des
    navigateurs imports des US, qui n'en avaient habituellement pas la
    possibilit ( cause des restrictions  l'exportation imposes par les
    US).</p>
    <p>Quand un navigateur se connecte avec un mode de chiffrement import
    des US, le serveur prsente son certificat  identifiant global. le
    navigateur le vrifie, et peut ensuite faire voluer sa suite de
    chiffrement avant que la communication HTTP ne se mette en place. Le
    problme consiste  permettre au navigateur de se mettre  jour de cette
    faon, mais de ncessiter encore un chiffrement fort. En d'autres termes,
    nous voulons que les navigateurs dmarrent une connexion soit avec
    chiffrement fort, soit avec une version export du chiffrement mais que
    dans ce dernier cas, le navigateur fasse voluer sa suite de chiffrement
    vers un chiffrement fort avant de dmarrer la communication HTTP.</p>
    <p>Il est possible de parvenir  ceci de cette faon:</p>
    <div class="example"><h3>httpd.conf</h3><p><code>
      # autorise tout mode de chiffrement pour l'change de donnes
      initial,<br />
      # les navigateurs non US peuvent ainsi se mettre  jour
      via la fonctionnalit SGC<br />
      SSLCipherSuite ALL:!ADH:RC4+RSA:+HIGH:+MEDIUM:+LOW:+SSLv2:+EXP:+eNULL<br />
      <br />
      &lt;Directory /usr/local/apache2/htdocs&gt;<br />
      # et enfin interdit l'accs  tous les navigateurs qui n'ont pas fait
      voluer leur suite de chiffrement<br />
      SSLRequire %{SSL_CIPHER_USEKEYSIZE} &gt;= 128<br />
      &lt;/Directory&gt;
    </code></p></div>


<h3><a name="strongurl" id="strongurl">Comment crer un serveur qui accepte tous les types de
chiffrement en gnral, mais exige un chiffrement fort pour pouvoir
accder  une URL particulire ?</a></h3>

    <p>Dans ce cas bien videmment, une directive <code class="directive"><a href="../mod/mod_ssl.html#sslciphersuite">SSLCipherSuite</a></code> au niveau du serveur principal
    qui restreint le choix des suites de chiffrement aux versions les plus
    fortes ne conviendra pas. <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> peut cependant tre
    reconfigur au sein de blocs <code>Location</code> qui permettent
    d'adapter la configuration gnrale  un rpertoire spcifique ;
    <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> peut alors forcer automatiquement une
    rengociation des paramtres SSL pour parvenir au but recherch.
    Cette configuration peut se prsenter comme suit :</p>
    <div class="example"><p><code>
      # soyons trs tolrant a priori<br />
      SSLCipherSuite ALL:!ADH:RC4+RSA:+HIGH:+MEDIUM:+LOW:+SSLv2:+EXP:+eNULL<br />
      <br />
      &lt;Location /strong/area&gt;<br />
      # sauf pour https://hostname/strong/area/ et ses sous-rpertoires<br />
      # qui exigent des chiffrements forts<br />
      SSLCipherSuite HIGH:MEDIUM<br />
      &lt;/Location&gt;
    </code></p></div>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="accesscontrol" id="accesscontrol">Authentification du client et contrle d'accs</a></h2>

<ul>
<li><a href="#allclients">Comment forcer les clients
 s'authentifier  l'aide de certificats ?</a></li>
<li><a href="#arbitraryclients">Comment forcer les clients
 s'authentifier  l'aide de certificats pour une URL particulire,
mais autoriser quand-mme tout client anonyme
 accder au reste du serveur ?</a></li>
<li><a href="#certauthenticate">Comment n'autoriser l'accs  une URL
particulire qu'aux clients qui possdent des certificats, mais autoriser
l'accs au reste du serveur  tous les clients ?</a></li>
<li><a href="#intranet">Comment imposer HTTPS avec chiffrements forts,
et soit authentification de base, soit possession de certificats clients,
pour l'accs  une partie de l'Intranet, pour les clients en
provenance de l'Internet ?</a></li>
</ul>

<h3><a name="allclients" id="allclients">Comment forcer les clients
 s'authentifier  l'aide de certificats ?
</a></h3>


    <p>Lorsque vous connaissez tous vos clients (comme c'est en gnral le cas
    au sein d'un intranet d'entreprise), vous pouvez imposer une
    authentification base uniquement sur les certificats. Tout ce dont vous
    avez besoin pour y parvenir est de crer des certificats clients signs par
    le certificat de votre propre autorit de certification
    (<code>ca.crt</code>), et d'authentifier les clients  l'aide de ces
    certificats.</p>
    <div class="example"><h3>httpd.conf</h3><p><code>
      # exige un certificat client sign par le certificat de votre CA<br />
      # contenu dans ca.crt<br />
      SSLVerifyClient require<br />
      SSLVerifyDepth 1<br />
      SSLCACertificateFile conf/ssl.crt/ca.crt
    </code></p></div>


<h3><a name="arbitraryclients" id="arbitraryclients">Comment forcer les clients
 s'authentifier  l'aide de certificats pour une URL particulire,
mais autoriser quand-mme tout client anonyme
 accder au reste du serveur ?</a></h3>


<p>Pour forcer les clients  s'authentifier  l'aide de certificats pour une
URL particulire, vous pouvez utiliser les fonctionnalits de reconfiguration
de <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> en fonction du rpertoire :</p>

    <div class="example"><h3>httpd.conf</h3><p><code>
    SSLVerifyClient none<br />
    SSLCACertificateFile conf/ssl.crt/ca.crt<br />
    <br />
    &lt;Location /secure/area&gt;<br />
    SSLVerifyClient require<br />
    SSLVerifyDepth 1<br />
    &lt;/Location&gt;<br />
    </code></p></div>


<h3><a name="certauthenticate" id="certauthenticate">Comment n'autoriser l'accs  une URL
particulire qu'aux clients qui possdent des certificats, mais autoriser
l'accs au reste du serveur  tous les clients ?</a></h3>


    <p>La cl du problme consiste  vrifier si une partie du certificat
    client correspond  ce que vous attendez. Cela signifie en gnral
    consulter tout ou partie du nom distinctif (DN), afin de vrifier s'il
    contient une chane connue. Il existe deux mthodes pour y parvenir ;
    on utilise soit le module <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code>, soit la
    directive <code class="directive"><a href="../mod/mod_ssl.html#sslrequire">SSLRequire</a></code>.</p>

    <p>La mthode du module <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code> est en gnral
    incontournable lorsque les certificats ont un contenu arbitraire, ou
    lorsque leur DN ne contient aucun champ connu
    (comme l'organisation, etc...). Dans ce cas, vous devez construire une base
    de donnes de mots de passe contenant <em>tous</em> les clients
    autoriss, comme suit :</p>

    <div class="example"><h3>httpd.conf</h3><pre>
SSLVerifyClient      none
&lt;Directory /usr/local/apache2/htdocs/secure/area&gt;

SSLVerifyClient      require
SSLVerifyDepth       5
SSLCACertificateFile conf/ssl.crt/ca.crt
SSLCACertificatePath conf/ssl.crt
SSLOptions           +FakeBasicAuth
SSLRequireSSL
AuthName             "Snake Oil Authentication"
AuthType             Basic
AuthBasicProvider    file
AuthUserFile         /usr/local/apache2/conf/httpd.passwd
Require              valid-user
&lt;/Directory&gt;</pre></div>

    <p>Le mot de passe utilis dans cet exemple correspond  la chane de
    caractres "password" chiffre en DES. Voir la documentation de la
    directive <code class="directive"><a href="../mod/mod_ssl.html#ssloptions">SSLOptions</a></code> pour
    plus de dtails.</p>

    <div class="example"><h3>httpd.passwd</h3><pre>
/C=DE/L=Munich/O=Snake Oil, Ltd./OU=Staff/CN=Foo:xxj31ZMTZzkVA
/C=US/L=S.F./O=Snake Oil, Ltd./OU=CA/CN=Bar:xxj31ZMTZzkVA
/C=US/L=L.A./O=Snake Oil, Ltd./OU=Dev/CN=Quux:xxj31ZMTZzkVA</pre></div>

    <p>Lorsque vos clients font tous partie d'une mme hirarchie, ce qui
    apparat dans le DN, vous pouvez les authentifier plus facilement en
    utilisant la directive <code class="directive"><a href="../mod/mod_ssl.html#sslrequire">SSLRequire</a></code>, comme suit :</p>


    <div class="example"><h3>httpd.conf</h3><pre>
SSLVerifyClient      none
&lt;Directory /usr/local/apache2/htdocs/secure/area&gt;

  SSLVerifyClient      require
  SSLVerifyDepth       5
  SSLCACertificateFile conf/ssl.crt/ca.crt
  SSLCACertificatePath conf/ssl.crt
  SSLOptions           +FakeBasicAuth
  SSLRequireSSL
  SSLRequire       %{SSL_CLIENT_S_DN_O}  eq "Snake Oil, Ltd." \
               and %{SSL_CLIENT_S_DN_OU} in {"Staff", "CA", "Dev"}
&lt;/Directory&gt;</pre></div>


<h3><a name="intranet" id="intranet">Comment imposer HTTPS avec chiffrements forts,
et soit authentification de base, soit possession de certificats clients,
pour l'accs  une partie de l'Intranet, pour les clients en
provenance de l'Internet ? Je souhaite quand-mme autoriser l'accs en HTTP
aux clients de l'intranet.</a></h3>


   <p>On suppose dans ces exemples que les clients de l'intranet ont des
   adresses IP dans la gamme 192.168.1.0/24, et que la partie de l'intranet
    laquelle vous voulez autoriser l'accs depuis l'Internet est
   <code>/usr/local/apache2/htdocs/subarea</code>. Ces lignes de configuration
   doivent se trouver en dehors de votre hte virtuel HTTPS, afin qu'elles
   s'appliquent  la fois  HTTP et HTTPS.</p>

    <div class="example"><h3>httpd.conf</h3><pre>
SSLCACertificateFile conf/ssl.crt/company-ca.crt

&lt;Directory /usr/local/apache2/htdocs&gt;
#   En dehors de subarea, seul l'accs depuis l'intranet est autoris
Order                deny,allow
Deny                 from all
Allow                from 192.168.1.0/24
&lt;/Directory&gt;

&lt;Directory /usr/local/apache2/htdocs/subarea&gt;
#   Dans subarea, tout accs depuis l'intranet est autoris
#   mais depuis l'Internet, seul l'accs par HTTPS + chiffrement fort
 + Mot de passe
#   ou HTTPS + chiffrement fort + certificat client n'est autoris.

#   Si HTTPS est utilis, on s'assure que le niveau de chiffrement est fort.
#   Autorise en plus les certificats clients comme une alternative 
#   l'authentification basique.
SSLVerifyClient      optional
SSLVerifyDepth       1
SSLOptions           +FakeBasicAuth +StrictRequire
SSLRequire           %{SSL_CIPHER_USEKEYSIZE} &gt;= 128

#   ON oblige les clients venant d'Internet  utiliser HTTPS
RewriteEngine        on
RewriteCond          %{REMOTE_ADDR} !^192\.168\.1\.[0-9]+$
RewriteCond          %{HTTPS} !=on
RewriteRule          .* - [F]

#   On permet l'accs soit sur les critres rseaux, soit par authentification Basique
Satisfy              any

#   Contrle d'accs rseau
Order                deny,allow
Deny                 from all
Allow                192.168.1.0/24

#   Configuration de l'authentification HTTP Basique
AuthType             basic
AuthName             "Protected Intranet Area"
AuthBasicProvider    file
AuthUserFile         conf/protected.passwd
Require              valid-user
&lt;/Directory&gt;</pre></div>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/ssl/ssl_howto.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/ssl/ssl_howto.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2009 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>