<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Guide de rcriture des URLs - Sujets avancs - Serveur Apache HTTP</title>
<link href="/style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="/style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="/style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="/images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="/mod/">Modules</a> | <a href="/mod/directives.html">Directives</a> | <a href="/faq/">FAQ</a> | <a href="/glossary.html">Glossaire</a> | <a href="/sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="/images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="/images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="/">Version 2.3</a> &gt; <a href="./">Rewrite</a></div><div id="page-content"><div id="preamble"><h1>Guide de rcriture des URLs - Sujets avancs</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span></p>
</div>


    <p>Ce document complmente la
    <a href="../mod/mod_rewrite.html">documentation de rfrence</a> du
    module <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code>. Il dcrit les diffrentes
    manires d'utiliser le module d'Apache <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code>
    pour rsoudre les problmes d'URLs typiques auxquels sont souvent
    confronts les webmasters. Nous fournissons une description
    dtaille de la rsolution de chaque problme par la configuration
    d'un jeu de rgles de rcriture.</p>

    <div class="warning">ATTENTION: il pourra s'avrer ncessaire de
    modifier les exemples en fonction de la
    configuration de votre serveur, par exemple en ajoutant le drapeau
    <code>[PT]</code> si les modules <code class="module"><a href="/mod/mod_alias.html">mod_alias</a></code> et
    <code class="module"><a href="/mod/mod_userdir.html">mod_userdir</a></code> sont utiliss, etc... Les jeux de
    rgles devront galement tre adapts pour passer d'un contexte de
    serveur  un contexte de rpertoire (fichiers
    <code>.htaccess</code>). Essayez de toujours bien comprendre ce que
    fait un jeu de rgles avant de l'utiliser, ce qui pourra vous viter
    bien des problmes.</div>

  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="/images/down.gif" /> <a href="#cluster">Accs  une grappe de serveurs via un espace d'adressage
      compatible</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#structuredhomedirs">Rpertoires utilisateurs structurs</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#filereorg">Rorganisation du systme de fichiers</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#redirect404">Rediriger les URLs errones vers un autre serveur Web</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#archive-access-multiplexer">Multiplexeur d'accs aux archives</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#browser-dependent-content">Contenu dpendant du navigateur</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#dynamic-mirror">Miroir dynamique</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#reverse-dynamic-mirror">Miroir dynamique inverse</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#retrieve-missing-data">Rcuprer des donnes manquantes depuis l'Intranet</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#load-balancing">Rpartition de charge</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#new-mime-type">Nouveau type MIME, nouveau service</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#on-the-fly-content">Rgneration de contenu  la vole</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#autorefresh">Actualisation automatique d'un document</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#mass-virtual-hosting">Hbergement virtuel de masse</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#host-deny">Interdiction d'htes</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#proxy-deny">Interdiction du mandataire</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#special-authentication">Variante particulire d'authentification</a></li>
<li><img alt="" src="/images/down.gif" /> <a href="#referer-deflector">Redirection base sur le rfrent</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="../mod/mod_rewrite.html">Documentation du
module</a></li><li><a href="intro.html">Introduction 
mod_rewrite</a></li><li><a href="rewrite_guide.html">Guide de rcriture - exemples
utiles</a></li><li><a href="tech.html">Dtails techniques</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="cluster" id="cluster">Accs  une grappe de serveurs via un espace d'adressage
      compatible</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment crer un espace d'adressage homogne et compatible
	  avec
	  tous les serveurs WWW d'une grappe de serveurs d'un intranet ?
	  C'est  dire que toutes les URLs (par dfinition
	  locales  un
	  serveur et dpendant donc de celui-ci) deviennent
	  vritablement <em>indpendantes</em> du serveur ! Nous voulons
	  disposer, pour accder  l'espace de nommage WWW, d'un seul
	  espace d'adressage compatible : aucune URL ne
	  doit inclure d'information quelconque  propos du serveur
	  cible physique. La grappe de serveurs doit elle-mme nous
	  diriger automatiquement vers le bon serveur cible physique,
	  selon les besoins, et ceci de manire transparente.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Tout d'abord, la connaissance des serveurs cibles est issue
	  de tables de correspondances externes (distribues) qui
	  contiennent des informations sur la localisation de nos
	  utilisateurs, groupes et entits. Elles se prsentent sous la
	  forme :</p>

<div class="example"><pre>
utilisateur1  serveur_utilisateur1
utilisateur2  serveur_utilisateur2
:      :
</pre></div>

          <p>On les enregistre sous forme de fichiers
	  <code>map.xxx-vers-serveur</code>. On doit ensuite faire
	  rediriger  tous les serveurs les URLs de la forme :</p>

<div class="example"><pre>
/u/utilisateur/chemin
/g/groupe/chemin
/e/entit/chemin
</pre></div>

          <p>vers</p>

<div class="example"><pre>
http://serveur-physique/u/utilisateur/chemin
http://serveur-physique/g/groupe/chemin
http://serveur-physique/e/entit/chemin
</pre></div>

          <p>si il n'est pas ncessaire que chaque chemin d'URL tre valide sur chaque
	  serveur. Le jeu
	  de rgles suivant le fait pour nous  l'aide des fichiers de
	  correspondance (en supposant que serveur0 soit un serveur par
	  dfaut qui sera choisi si l'utilisateur ne possde aucune
	  entre dans la table) :</p>

<div class="example"><pre>
RewriteEngine on

RewriteMap      utilisateur-vers-serveur   txt:/chemin/vers/map.utilisateur-vers-serveur
RewriteMap     groupe-vers-serveur   txt:/chemin/vers/map.groupe-vers-serveur
RewriteMap    entit-vers-serveur   txt:/chemin/vers/map.entit-vers-serveur

RewriteRule   ^/u/<strong>([^/]+)</strong>/?(.*)
http://<strong>${utilisateur-vers-serveur:$1|serveur0}</strong>/u/$1/$2
RewriteRule   ^/g/<strong>([^/]+)</strong>/?(.*)
http://<strong>${groupe-vers-serveur:$1|serveur0}</strong>/g/$1/$2
RewriteRule   ^/e/<strong>([^/]+)</strong>/?(.*)
http://<strong>${entit-vers-serveur:$1|serveur0}</strong>/e/$1/$2

RewriteRule   ^/([uge])/([^/]+)/?$          /$1/$2/.www/
RewriteRule   ^/([uge])/([^/]+)/([^.]+.+)   /$1/$2/.www/$3\
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="structuredhomedirs" id="structuredhomedirs">Rpertoires utilisateurs structurs</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Certains sites possdant des milliers d'utilisateurs
	  organisent les rpertoires home de manire
	  structure, <em>c'est  dire</em> que chaque rpertoire home
	  se situe dans un sous-rpertoire dont le nom commence (par
	  exemple) par le premier caractre du nom de l'utilisateur.
	  Ainsi, <code>/~foo/chemin</code> est dans
	  <code>/home/<strong>f</strong>/foo/.www/chemin</code>, tandis
	  que <code>/~bar/chemin</code> est dans
	  <code>/home/<strong>b</strong>/bar/.www/chemin</code>.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Le jeu de rgles suivant permet de dvelopper les URLs avec
	  tilde selon la reprsentation ci-dessus.</p>

<div class="example"><pre>
RewriteEngine on
RewriteRule   ^/~(<strong>([a-z])</strong>[a-z0-9]+)(.*)  /home/<strong>$2</strong>/$1/.www$3
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="filereorg" id="filereorg">Rorganisation du systme de fichiers</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Voici un cas d'espce : une application trs efficace qui
	  fait un usage intensif de rgles <code>RewriteRule</code>
	  dans le contexte du rpertoire pour prsenter un aspect
	  comprhensible sur le Web sans modifier la structure des
	  donnes.
	  Les coulisses de l'affaire : <strong><em>net.sw</em></strong>
	  rassemble mes archives de paquetages de logiciels Unix
	  librement accessibles, que j'ai commenc  collectionner en
	  1992. Pour moi, c'est un passe-temps, mais aussi un travail,
	  car alors que j'tudie la science informatique, j'ai aussi
	  travaill depuis de nombreuses annes comme administrateur
	  systme et rseau  mes heures perdues. Chaque semaine j'ai
	  besoin de tel ou tel logiciel, et j'ai donc cr une
	  arborescence trs ramifie de rpertoires o je stocke les
	  paquetages :</p>

<div class="example"><pre>
drwxrwxr-x   2 netsw  users    512 Aug  3 18:39 Audio/
drwxrwxr-x   2 netsw  users    512 Jul  9 14:37 Benchmark/
drwxrwxr-x  12 netsw  users    512 Jul  9 00:34 Crypto/
drwxrwxr-x   5 netsw  users    512 Jul  9 00:41 Database/
drwxrwxr-x   4 netsw  users    512 Jul 30 19:25 Dicts/
drwxrwxr-x  10 netsw  users    512 Jul  9 01:54 Graphic/
drwxrwxr-x   5 netsw  users    512 Jul  9 01:58 Hackers/
drwxrwxr-x   8 netsw  users    512 Jul  9 03:19 InfoSys/
drwxrwxr-x   3 netsw  users    512 Jul  9 03:21 Math/
drwxrwxr-x   3 netsw  users    512 Jul  9 03:24 Misc/
drwxrwxr-x   9 netsw  users    512 Aug  1 16:33 Network/
drwxrwxr-x   2 netsw  users    512 Jul  9 05:53 Office/
drwxrwxr-x   7 netsw  users    512 Jul  9 09:24 SoftEng/
drwxrwxr-x   7 netsw  users    512 Jul  9 12:17 System/
drwxrwxr-x  12 netsw  users    512 Aug  3 20:15 Typesetting/
drwxrwxr-x  10 netsw  users    512 Jul  9 14:08 X11/
</pre></div>

          <p>J'ai dcid en 1996 de rendre cette archive disponible pour
	  le monde via une interface web agrable. "Agrable" signifie
	  que je voulais vous offrir une interface o vous pourriez
	  naviguer directement  travers la hirarchie des archives.
	  Mais "agrable" signifie aussi que je ne voulais rien changer
	  dans cette hirarchie - mme pas en ajoutant queques scripts
	  CGI  son sommet. Pourquoi ? Parceque j'avais prvu de rendre
	  ultrieurement la structure ci-dessus accessible aussi via
	  FTP, et je ne voulais pas voir de fichiers CGI ou Web  ce
	  niveau.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>La solution comporte deux parties : la premire consiste en
	  un ensemble de scripts CGI qui crent toutes les pages  tous
	  les niveaux de rpertoires  la vole. Je les ai placs dans
	  <code>/e/netsw/.www/</code> comme suit :</p>

<div class="example"><pre>
-rw-r--r--   1 netsw  users    1318 Aug  1 18:10 .wwwacl
drwxr-xr-x  18 netsw  users     512 Aug  5 15:51 DATA/
-rw-rw-rw-   1 netsw  users  372982 Aug  5 16:35 LOGFILE
-rw-r--r--   1 netsw  users     659 Aug  4 09:27 TODO
-rw-r--r--   1 netsw  users    5697 Aug  1 18:01 netsw-about.html
-rwxr-xr-x   1 netsw  users     579 Aug  2 10:33 netsw-access.pl
-rwxr-xr-x   1 netsw  users    1532 Aug  1 17:35 netsw-changes.cgi
-rwxr-xr-x   1 netsw  users    2866 Aug  5 14:49 netsw-home.cgi
drwxr-xr-x   2 netsw  users     512 Jul  8 23:47 netsw-img/
-rwxr-xr-x   1 netsw  users   24050 Aug  5 15:49 netsw-lsdir.cgi
-rwxr-xr-x   1 netsw  users    1589 Aug  3 18:43 netsw-search.cgi
-rwxr-xr-x   1 netsw  users    1885 Aug  1 17:41 netsw-tree.cgi
-rw-r--r--   1 netsw  users     234 Jul 30 16:35 netsw-unlimit.lst
</pre></div>

          <p>Le sous-rpertoire <code>DATA/</code> contient la structure
	  de rpertoires proprement dite mentionne plus haut, <em>c'est
	   dire</em> les vritables ressources
	  <strong><em>net.sw</em></strong> et est mis  jour
	  automatiquement via <code>rdist</code>  intervalles de temps
	  rguliers. Reste la seconde partie du problme : comment
	  relier ces deux structures selon une arborescence d'URL
	  facile d'accs ? Il nous faut cacher le rpertoire
	  <code>DATA/</code>  l'utilisateur durant l'excution des
	  scripts CGI appropris aux diffrentes URLs. Voici comment :
	  tout d'abord, j'ajoute ces deux rgles dans le fichier de
	  configuration du rpertoire racine <code class="directive"><a href="/mod/core.html#documentroot">DocumentRoot</a></code> du serveur afin de
	  rcrire le chemin d'URL public <code>/net.sw/</code> vers le
	  chemin interne <code>/e/netsw</code> :</p>

<div class="example"><pre>
RewriteRule  ^net.sw$       net.sw/        [R]
RewriteRule  ^net.sw/(.*)$  e/netsw/$1
</pre></div>

          <p>La premire rgle concerne les requtes qui ne comportent
	  pas de slash de fin ! C'est la seconde rgle qui fait le
	  vritable travail. Et maintenant vient la super configuration
	  qui se trouve dans le fichier de configuration de rpertoire
	  <code>/e/netsw/.www/.wwwacl</code> :</p>

<div class="example"><pre>
Options       ExecCGI FollowSymLinks Includes MultiViews

RewriteEngine on

#  l'accs s'effectue via le prfixe /net.sw/
RewriteBase   /net.sw/

#  tout d'abord, on rcrit le rpertoire racine vers
#  le script CGI qui lui est associ
RewriteRule   ^$                       netsw-home.cgi     [L]
RewriteRule   ^index\.html$            netsw-home.cgi     [L]

#  on supprime les sous-rpertoires lorsque
#  le navigateur nous atteint depuis des pages de rpertoire
RewriteRule   ^.+/(netsw-[^/]+/.+)$    $1                 [L]

#  on stoppe maintenant la rcriture pour les fichiers locaux
RewriteRule   ^netsw-home\.cgi.*       -                  [L]
RewriteRule   ^netsw-changes\.cgi.*    -                  [L]
RewriteRule   ^netsw-search\.cgi.*     -                  [L]
RewriteRule   ^netsw-tree\.cgi$        -                  [L]
RewriteRule   ^netsw-about\.html$      -                  [L]
RewriteRule   ^netsw-img/.*$           -                  [L]

#  ce qui reste est un sous-rpertoire qui peut tre trait
#  par un autre script CGI
RewriteRule   !^netsw-lsdir\.cgi.*     -                  [C]
RewriteRule   (.*)                     netsw-lsdir.cgi/$1
</pre></div>

          <p>Quelques indices pour l'interprtation :</p>

          <ol>
            <li>Remarquez le drapeau <code>L</code> (last) et l'absence
	    de chane de substitution ('<code>-</code>') dans la
	    quatrime partie.</li>

            <li>Remarquez le caractre <code>!</code> (not)  et le
	    drapeau <code>C</code> (chain) dans la premire rgle de la
	    dernire partie.</li>

            <li>Remarquez le modle qui correspond  tout dans la
	    dernire rgle.</li>
          </ol>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="redirect404" id="redirect404">Rediriger les URLs errones vers un autre serveur Web</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Une question typique de la FAQ  propos de la rcriture
	  revient souvent : comment rediriger vers un serveur B les
	  requtes qui chouent sur un serveur A ? On s'acquitte en
	  gnral de cette tche via des scripts CGI <code class="directive"><a href="/mod/core.html#errordocument">ErrorDocument</a></code> en Perl, mais il
	  existe aussi une solution avec <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code>.
	  Notez cependant que les performances sont moindres qu'avec
	  l'utilisation d'un script CGI <code class="directive"><a href="/mod/core.html#errordocument">ErrorDocument</a></code> !</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>La premire solution possde des performances suprieures
	  mais moins de souplesse, et est moins sure :</p>

<div class="example"><pre>
RewriteEngine on
RewriteCond  %{DOCUMENT_ROOT/%{REQUEST_URI}  <strong>!-f</strong>
RewriteRule   ^(.+)                             http://<strong>serveurB</strong>.dom/$1
</pre></div>

          <p>Le problme rside dans le fait que seules les pages
	  situes dans la racine <code class="directive"><a href="/mod/core.html#documentroot">DocumentRoot</a></code> seront rediriges. Mais
	  mme si vous pouvez ajouter des conditions supplmentaires (par
	  exemple pour traiter aussi les rpertoires home, etc...), il
	  existe une meilleure solution :</p>

<div class="example"><pre>
RewriteEngine on
RewriteCond   %{REQUEST_URI} <strong>!-U</strong>
RewriteRule   ^(.+)          http://<strong>serveurB</strong>.dom/$1
</pre></div>
reprendre ici
          <p>On utilise ici la fonctionnalit de prvision des URLs
	  futures de <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code>. Et cette solution
	  fonctionne pour tous les types d'URLs et de manire sre. Par
	  contre, cette mthode a un impact sur les performances du
	  serveur web, car chaque requte entrane le traitement d'une
	  sous-requte interne supplmentaire. Par consquent, vous
	  pouvez l'utiliser si votre serveur web s'excute sur un CPU
	  puissant. Dans le cas d'une machine plus lente, utilisez la
	  premire approche, ou mieux, un script CGI <code class="directive"><a href="/mod/core.html#errordocument">ErrorDocument</a></code>.</p>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="archive-access-multiplexer" id="archive-access-multiplexer">Multiplexeur d'accs aux archives</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Connaissez-vous la grande archive CPAN (Comprehensive Perl Archive
          Network) situe  <a href="http://www.perl.com/CPAN">http://www.perl.com/CPAN</a> ?
	  CPAN redirige automatiquement les navigateurs vers un des
	  nombreux serveurs FTP rpartis  travers le monde
	  (gnralement un serveur assez proche du client) ; chaque
	  serveur hberge l'intgralit d'un miroir CPAN. Il s'agit ni
	  plus ni moins qu'un service d'accs FTP multiplex. Alors que
	  le fonctionnement de l'archive CPAN repose sur des scripts
	  CGI, comment implmenter une approche similaire avec
	  <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code> ?</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Premirement, remarquons que depuis la version 3.0.0,
	  <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code> accepte aussi le prfixe
	  "<code>ftp:</code>" dans les redirections. Et deuximement,
	  l'approximation de la localisation peut tre effectue par une
	  table de correspondances <code class="directive"><a href="/mod/mod_rewrite.html#rewritemap">RewriteMap</a></code>, en se basant sur
	  la racine du domaine du client. Un jeu de rgles chanes
	  astucieux nous permet d'utiliser cette racine du domaine comme
	  cl de recherche dans notre table de correspondances de
	  multiplexage.</p>

<div class="example"><pre>
RewriteEngine on
RewriteMap    multiplex                txt:/chemin/vers/map.cxan
RewriteRule   ^/CxAN/(.*)              %{REMOTE_HOST}::$1                 [C]
RewriteRule   ^.+\.<strong>([a-zA-Z]+)</strong>::(.*)$
${multiplex:<strong>$1</strong>|ftp.dfaut.dom}$2  [R,L]
</pre></div>

<div class="example"><pre>
##
##  map.cxan -- Multiplexing Map for CxAN%{DOCUMENT_ROOT/%{REQUEST_URI}
##

de        ftp://ftp.cxan.de/CxAN/
uk        ftp://ftp.cxan.uk/CxAN/
com       ftp://ftp.cxan.com/CxAN/
 :
##EOF##
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="browser-dependent-content" id="browser-dependent-content">Contenu dpendant du navigateur</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Il est parfois ncessaire, au moins pour les pages
	  principales, de fournir un contenu optimum adapt  chaque
	  type de navigateur, c'est  dire que l'on doit
	  fournir une version pour les navigateurs courants, une version
	  diffrente pour les navigateurs en mode texte du style de
	  Lynx, et une autre pour les autres navigateurs.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On ne peut pas utiliser la ngociation de contenu car les
	  navigateurs ne fournissent pas leur type dans cette forme.
	  Nous devons nous baser sur l'en-tte HTTP "User-Agent". La
	  configuration ci-dessous effectue les actions suivantes : si
	  l'en-tte HTTP "User-Agent" commence par "Mozilla/3", la page
	  <code>foo.html</code> est rcrite en <code>foo.NS.html</code>
	  et la rcriture s'arrte. Si le navigateur est "Lynx" ou
	  "Mozilla" version 1 ou 2, la page
	  <code>foo.html</code> est rcrite en
	  <code>foo.20.html</code>. Tous les autres navigateurs
	  reoivent la page <code>foo.32.html</code>. Voici le jeu de
	  rgles :</p>

<div class="example"><pre>
RewriteCond %{HTTP_USER_AGENT}  ^<strong>Mozilla/3</strong>.*
RewriteRule ^foo\.html$         foo.<strong>NS</strong>.html          [<strong>L</strong>]

RewriteCond %{HTTP_USER_AGENT}  ^<strong>Lynx/</strong>.*         [OR]
RewriteCond %{HTTP_USER_AGENT}  ^<strong>Mozilla/[12]</strong>.*
RewriteRule ^foo\.html$         foo.<strong>20</strong>.html          [<strong>L</strong>]

RewriteRule ^foo\.html$         foo.<strong>32</strong>.html          [<strong>L</strong>]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="dynamic-mirror" id="dynamic-mirror">Miroir dynamique</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Supposons que nous voulions intgrer dans notre espace de
	  nommage de belles pages web situes sur un serveur distant.
	  Dans le cas d'un serveur FTP, nous aurions utilis le
	  programme <code>mirror</code> qui maintient vraiment une copie
	  des donnes distantes mise  jour explicitement sur le serveur
	  local. Pour un serveur web, nous pourrions utiliser le
	  programme <code>webcopy</code> qui utilise le protocole HTTP.
	  Ces deux techniques prsentent cependant un
	  inconvnient majeur : la copie locale n'est vritablement 
	  jour qu'au moment o nous avons lanc le programme. Plutt qu'
	  un miroir statique devant tre dfini explicitement, il serait
	  prfrable d'avoir un miroir dynamique dont le contenu serait
	  mis  jour automatiquement,  la demande, sur le(s) serveur(s)
	  distant(s).</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Pour y parvenir, on fait
	  correspondre la page web ou mme l'ensemble du
	  rpertoire web distants  notre espace de nommage en utilisant
	  la fonctionnalit <dfn>Mandataire</dfn> (drapeau
	  <code>[P]</code> ou <code>[proxy]</code>) :</p>

<div class="example"><pre>
RewriteEngine  on
RewriteBase    /~quux/
RewriteRule    ^<strong>page-convoite/</strong>(.*)$  <strong>http://www.tstimpreso.com/page-convoite/</strong>$1  [<strong>P</strong>]
</pre></div>

<div class="example"><pre>
RewriteEngine  on
RewriteBase    /~quux/
RewriteRule    ^<strong>usa-news\.html</strong>$   <strong>http://www.quux-corp.com/news/index.html</strong>  [<strong>P</strong>]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="reverse-dynamic-mirror" id="reverse-dynamic-mirror">Miroir dynamique inverse</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>...</dd>

        <dt>Solution :</dt>

        <dd>
<div class="example"><pre>
RewriteEngine on
RewriteCond   /miroir/du/site-distant/$1           -U
RewriteRule   ^http://www\.site-distant\.com/(.*)$ /miroir/du/site-distant/$1
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="retrieve-missing-data" id="retrieve-missing-data">Rcuprer des donnes manquantes depuis l'Intranet</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>C'est une mthode astucieuse permettant de faire
	  fonctionner virtuellement un serveur web d'entreprise
	  (<code>www.quux-corp.dom</code>) sur
	  l'Internet (extrieur  l'entreprise), tout en maintenant et
	  conservant dans la ralit ses donnes sur un serveur web
	  (<code>www2.quux-corp.dom</code>) de l'Intranet (interne 
	  l'entreprise) protg par un pare-feu. L'astuce consiste, sur
	  le serveur web externe,  rcuprer  la vole sur le serveur interne
	  les donnes demandes.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Tout d'abord, nous devons nous assurer que notre pare-feu
	  protge bien le serveur web interne, et que seul le serveur
	  web externe est autoris  y rcuprer des donnes. Dans le
	  cas d'un filtrage par paquets, nous pourrions par exemple
	  dfinir un jeu de rgles du pare-feu du style :</p>

<div class="example"><pre>
<strong>ALLOW</strong> serveur www.quux-corp.dom Port &gt;1024 --&gt;
serveur www2.quux-corp.dom Port <strong>80</strong>
<strong>DENY</strong>  serveur *                 Port *     --&gt;
serveur www2.quux-corp.dom Port <strong>80</strong>
</pre></div>

          <p>Il vous suffit d'adapter ces rgles  la syntaxe de votre
	  pare-feu. Nous pouvons maintenant dfinir les rgles de
	  <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code> qui serviront  rcuprer les
	  donnes manquantes en arrire-plan via la fonctionnalit de
	  mandataire :</p>

<div class="example"><pre>
RewriteRule ^/~([^/]+)/?(.*)          /home/$1/.www/$2 [C]
# L'utilisation de REQUEST_FILENAME ci dessous est correcte dans cet
# exemple de contexte au niveau serveur car la rgle qui fait rfrence
#  REQUEST_FILENAME est chane  une rgle qui dfinit
# REQUEST_FILENAME.
RewriteCond %{REQUEST_FILENAME}       <strong>!-f</strong>
RewriteCond %{REQUEST_FILENAME}       <strong>!-d</strong>
RewriteRule ^/home/([^/]+)/.www/?(.*) http://<strong>www2</strong>.quux-corp.dom/~$1/pub/$2 [<strong>P</strong>]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="load-balancing" id="load-balancing">Rpartition de charge</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Supposons que nous voulions rpartir la charge du trafic
	  vers <code>www.example.com</code> entre les serveurs
	  <code>www[0-5].example.com</code> (un total de 6 serveurs).
	  Comment y parvenir ?</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Il existe de nombreuses solutions  ce problme. Nous
	  dcrirons tout d'abord une variante assez connue base sur
	  DNS, puis une autre base sur <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code>
	  :</p>

          <ol>
            <li>
              <strong>Round-Robin (tourniquet) DNS</strong>

              <p>La mthode de rpartition de charge la plus simple
	      consiste  utiliser le "DNS round-robin"
	      (rotation d'adresses) de
	      <code>BIND</code>. Vous devez seulement enregistrer les
	      serveurs <code>www[0-9].example.com</code> de manire
	      habituelle dans votre DNS  l'aide d'enregistrements de
	      type A (adresse), comme suit :</p>

<div class="example"><pre>
www0   IN  A       1.2.3.1
www1   IN  A       1.2.3.2
www2   IN  A       1.2.3.3
www3   IN  A       1.2.3.4
www4   IN  A       1.2.3.5
www5   IN  A       1.2.3.6
</pre></div>

              <p>Puis vous ajoutez les entres suivantes :</p>

<div class="example"><pre>
www   IN  A       1.2.3.1
www   IN  A       1.2.3.2
www   IN  A       1.2.3.3
www   IN  A       1.2.3.4
www   IN  A       1.2.3.5
</pre></div>

              <p>Maintenant, lors de la rsolution de
	      <code>www.example.com</code>, <code>BIND</code> renvoie
	      <code>www0-www5</code> - mais selon une permutation
	      diffrente  chaque fois. De cette faon, les clients sont
	      rpartis entre les diffrents serveurs. Notez cependant
	      que cette mthode de rpartition de charge n'est pas
	      parfaite, car les rsolutions DNS sont mises en cache par
	      les clients et les autres serveurs DNS du rseau, si
	      bien que lorsqu'un client s'est vu rsoudre
	      <code>www.example.com</code> en un des
	      <code>wwwN.example.com</code>, toutes ses requtes ultrieures
	      continueront d'aller vers la mme adresse IP (et donc le
	      mme serveur), au lieu d'tre rparties entre les autres
	      serveurs. Le rsultat est cependant globalement
	      satisfaisant car les requtes sont rparties
	      collectivement entre chacun des serveurs web.</p>
            </li>

            <li>
              <strong>Rpartition de charge base sur DNS</strong>

              <p>Une mthode de rpartition de charge sophistique base
	      sur DNS consiste  utiliser le programme
	      <code>lbnamed</code> que l'on peut trouver  <a href="http://www.stanford.edu/~riepel/lbnamed/">
              http://www.stanford.edu/~riepel/lbnamed/</a>.
	      Associ  des outils auxiliaires, il s'agit d'un programme
	      en Perl 5 qui permet d'effectuer une vritable rpartition
	      de charge base sur DNS.</p>
            </li>

            <li>
              <strong>Round-Robin bas sur la fonctionnalit de
	      mandataire</strong>

              <p>Dans cette variante, nous utilisons
	      <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code> et sa fonctionnalit de
	      mandataire. Tout d'abord, nous dfinissons
	      <code>www0.example.com</code> comme un autre nom de
	      <code>www.example.com</code> en ajoutant l'entre</p>

<div class="example"><pre>
www    IN  CNAME   www0.example.com.
</pre></div>

              <p>dans le DNS. Puis nous dfinissons
	      <code>www0.example.com</code> comme serveur mandataire
	      seulement, c'est  dire que nous configurons cette machine
	      de telle sorte que toutes les URLs qui lui arrivent soient
	      simplement transmises, via le mandataire interne, vers un
	      des 5 autres serveurs (<code>www1-www5</code>). Pour y
	      parvenir, nous dfinissons tout d'abord un jeu de rgles
	      qui contacte un script de rpartition de charge
	      <code>lb.pl</code> pour toutes les URLs.</p>

<div class="example"><pre>
RewriteEngine on
RewriteMap    lb      prg:/chemin/vers/lb.pl
RewriteRule   ^/(.+)$ ${lb:$1}           [P,L]
</pre></div>

              <p>Puis nous crivons <code>lb.pl</code> :</p>

<div class="example"><pre>
#!/chemin/vers/perl
##
##  lb.pl -- script de rpartition de charge
##

$| = 1;

$name   = "www";     # la base du nom du serveur
$first  = 1;         # le premier serveur (pas 0 ici, car 0 correspond 
		     # moi-mme)
$last   = 5;         # le dernier serveur du tourniquet
$domain = "foo.dom"; # le nom de domaine

$cnt = 0;
while (&lt;STDIN&gt;) {
    $cnt = (($cnt+1) % ($last+1-$first));
    $server = sprintf("%s%d.%s", $name, $cnt+$first, $domain);
    print "http://$server/$_";
}

##EOF##
</pre></div>

              <div class="note">Une dernire remarque :  quoi cela sert-il ?
	      <code>www0.example.com</code>, quant  lui, n'est-il pas
	      toujours surcharg ? La rponse est oui, il est surcharg,
	      mais seulement avec des requtes de mandataire ! Tous les
	      traitements SSI, CGI, ePerl, etc... sont entirement
	      effectus sur les autres machines. Ceci peut fonctionner
	      correctement pour un site complexe. Le plus grand risque
	      rside ici dans le fait que www0 est un passage oblig et
	      que s'il est hors service, les autres serveurs deviennent
	      inaccessibles.</div>
            </li>

            <li>
              <strong>Rpartiteur de charge ddi</strong>

              <p>Il existe aussi des solutions plus sophistiques.
	      Cisco, F5, et de nombreuses autres socits proposent
	      des rpartiteurs de charge matriels (utiliss en gnral
	      en mode doubl  des fins de redondance), qui offrent une
	      rpartition de charge sophistique et des fonctionnalits
	      de passage automatique en mode de fonctionnement par dfaut
	      en cas de problme. Cependant, des solutions logicielles
	      offrent aussi des fonctionnalits similaires avec du
	      matriel standard. Si vos besoins correspondent et si vous
	      tes assez riche, vous pouvez envisager ces solutions. La
	      <a href="http://vegan.net/lb/">liste de diffusion lb-l</a>
	      est un bon point de dpart pour vos recherches.</p>
            </li>
          </ol>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="new-mime-type" id="new-mime-type">Nouveau type MIME, nouveau service</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>On trouve de nombreux programmes CGI attractifs sur le
	  rseau. Mais leur emploi est souvent rbarbatif, si bien que
	  de nombreux webmasters ne les utilisent pas. Mme la
	  fonctionnalit de gestionnaire Action d'Apache pour les types
	  MIME ne convient que lorsque les programmes CGI ne ncessitent
	  pas d'URLs spciales (rellement <code>PATH_INFO</code> et
	  <code>QUERY_STRINGS</code>) en entre. Tout d'abord,
	  dfinissons un nouveau type de fichier ayant pour extension
	  <code>.scgi</code> (pour CGI scuris) qui sera associ pour
	  traitement au programme populaire <code>cgiwrap</code>. Le
	  problme est le suivant : par exemple, si on utilise un style
	  d'URL bien dfini (voir ci-dessus), un fichier situ dans le
	  rpertoire home de l'utilisateur pourra correspondre  l'URL
	  <code>/u/user/foo/bar.scgi</code>. Mais <code>cgiwrap</code>
	  ncessite des URLs de la forme
	  <code>/~user/foo/bar.scgi/</code>. La rgle suivante apporte
	  la solution :</p>

<div class="example"><pre>
RewriteRule ^/[uge]/<strong>([^/]+)</strong>/\.www/(.+)\.scgi(.*) ...
... /interne/cgi/utilisateur/cgiwrap/~<strong>$1</strong>/$2.scgi$3  [NS,<strong>T=application/x-http-cgi</strong>]
</pre></div>

          <p>Ou considrons ces autres programmes attractifs :
	  <code>wwwlog</code> (qui affiche le journal des accs
	  <code>access.log</code> pour un sous rpertoire correspondant
	   une URL) et <code>wwwidx</code> (qui excute Glimpse sur un
	  sous rpertoire correspondant  une URL). Nous devons fournir
	  l'URL correspondante  ces programmes afin qu'ils sachent sur
	  quel rpertoire ils doivent agir. Mais c'est en gnral
	  compliqu, car ils peuvent tre appels  nouveau
	  par la forme d'URL alternative, c'est  dire que typiquement,
	  nous excuterions le programme <code>swwidx</code> depuis
	  <code>/u/user/foo/</code> via un hyperlien vers</p>

<div class="example"><pre>
/internal/cgi/user/swwidx?i=/u/user/foo/
</pre></div>

          <p>ce qui n'est pas satisfaisant, car nous devons expliciter
	  <strong> la fois</strong> la localisation du rpertoire
	  <strong>et</strong> la localisation du programme CGI dans
	  l'hyperlien. Si nous devons nous rorganiser, il nous faudra
	  beaucoup de temps pour modifier tous les hyperliens.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>La solution consiste ici  fournir un nouveau format d'URL
	  qui redirige automatiquement vers la requte CGI approprie.
	  Pour cela, on dfinit les rgles suivantes :</p>

<div class="example"><pre>
RewriteRule   ^/([uge])/([^/]+)(/?.*)/\*  /interne/cgi/utilisateur/wwwidx?i=/$1/$2$3/
RewriteRule   ^/([uge])/([^/]+)(/?.*):log /interne/cgi/utilisateur/wwwlog?f=/$1/$2$3
</pre></div>

          <p>Et maintenant l'hyperlien qui renvoie vers
	  <code>/u/user/foo/</code> se rduit </p>

<div class="example"><pre>
HREF="*"
</pre></div>

          <p>qui est automatiquement transform en interne en</p>

<div class="example"><pre>
/internal/cgi/user/wwwidx?i=/u/user/foo/
</pre></div>

          <p>Une approche similaire permet d'invoquer le programme CGI
	  du journal des accs lorsque l'hyperlien <code>:log</code> est
	  utilis.</p>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="on-the-fly-content" id="on-the-fly-content">Rgneration de contenu  la vole</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Voici une fonctionnalit vraiment sotrique : des pages
	  gnres dynamiquement mais servies statiquement, c'est 
	  dire que les pages doivent tre servies comme des pages
	  purement statiques (lues depuis le systme de fichiers et
	  servies en l'tat), mais doivent tre gnres dynamiquement
	  par le serveur web si elles sont absentes. Ainsi, vous pouvez
	  avoir des pages gnres par CGI qui sont servies statiquement
	   moins qu'un administrateur (ou une tche de
	  <code>cron</code>) ne supprime les
	  contenus statiques. Les contenus sont ensuite actualiss.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          A cet effet, on utilise le jeu de rgles suivant :

<div class="example"><pre>
# Cet exemple n'est valable que dans un contexte de rpertoire
RewriteCond %{REQUEST_FILENAME}   <strong>!-s</strong>
RewriteRule ^page\.<strong>html</strong>$          page.<strong>cgi</strong>   [T=application/x-httpd-cgi,L]
</pre></div>

          <p>Ainsi, une requte pour <code>page.html</code> entrane
	  l'excution interne de la page <code>page.cgi</code>
	  correspondante si <code>page.html</code> n'existe pas
	  ou possde une taille de fichier nulle. L'astuce rside ici
	  dans le fait que <code>page.cgi</code> est un script CGI
	  qui (en plus de <code>STDOUT</code>) crit sa sortie dans le
	  fichier <code>page.html</code>. Une fois le script excut, le
	  serveur sert la page <code>page.html</code> frachement
	  gnre. Si le webmaster
	  veut actualiser les contenus, il lui suffit de supprimer le
	  fichier <code>page.html</code> (le plus souvent via une tche
	  de <code>cron</code>).</p>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="autorefresh" id="autorefresh">Actualisation automatique d'un document</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Lorsque nous crons une page web complexe, ne serait-il pas
	  souhaitable que le navigateur web actualise automatiquement la
	  page chaque fois que nous en sauvegardons une nouvelle version
	   partir de notre diteur ? Impossible ?</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Non ! Nous allons pour cela combiner la fonctionnalit MIME
	  multipart, la fonctionnalit NPH du serveur web et la
	  puissance de <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code> pour la manipulation
	  d'URLs. Tout d'abord, nous dfinissons une nouvelle
	  fonctionnalit pour les URLs : l'ajout de
	  <code>:refresh</code>  toute URL fait que la 'page' est
	  actualise chaque fois que la ressource est mise  jour dans
	  le systme de fichiers.</p>

<div class="example"><pre>
RewriteRule   ^(/[uge]/[^/]+/?.*):refresh  /interne/cgi/apache/nph-refresh?f=$1
</pre></div>

          <p>Nous appelons maintenant cette URL</p>

<div class="example"><pre>
/u/foo/bar/page.html:refresh
</pre></div>

          <p>ce qui entrane en interne l'invocation de l'URL</p>

<div class="example"><pre>
/interne/cgi/apache/nph-refresh?f=/u/foo/bar/page.html
</pre></div>

          <p>Il ne reste plus qu' crire le script CGI. Bien que l'on
	  crive habituellement dans ces cas "laiss  la charge du
	  lecteur  titre d'exercice", ;-) je vous l'offre, aussi.</p>

<div class="example"><pre>
#!/sw/bin/perl
##
##  nph-refresh -- script NPH/CGI pour l'actualisation automatique de
##  pages
##  Copyright (c) 1997 Ralf S. Engelschall, All Rights Reserved.
##
$| = 1;

#   clate la variable QUERY_STRING
@pairs = split(/&amp;/, $ENV{'QUERY_STRING'});
foreach $pair (@pairs) {
    ($name, $value) = split(/=/, $pair);
    $name =~ tr/A-Z/a-z/;
    $name = 'QS_' . $name;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    eval "\$$name = \"$value\"";
}
$QS_s = 1 if ($QS_s eq '');
$QS_n = 3600 if ($QS_n eq '');
if ($QS_f eq '') {
    print "HTTP/1.0 200 OK\n";
    print "Content-type: text/html\n\n";
    print "&amp;lt;b&amp;gt;ERREUR&amp;lt;/b&amp;gt;: Aucun fichier fourni\n";
    exit(0);
}
if (! -f $QS_f) {
    print "HTTP/1.0 200 OK\n";
    print "Content-type: text/html\n\n";
    print "&amp;lt;b&amp;gt;ERREUR&amp;lt;/b&amp;gt;: Fichier $QS_f non trouv\n";
    exit(0);
}

sub print_http_headers_multipart_begin {
    print "HTTP/1.0 200 OK\n";
    $bound = "ThisRandomString12345";
    print "Content-type: multipart/x-mixed-replace;boundary=$bound\n";
    &amp;print_http_headers_multipart_next;
}

sub print_http_headers_multipart_next {
    print "\n--$bound\n";
}

sub print_http_headers_multipart_end {
    print "\n--$bound--\n";
}

sub displayhtml {
    local($buffer) = @_;
    $len = length($buffer);
    print "Content-type: text/html\n";
    print "Content-length: $len\n\n";
    print $buffer;
}

sub readfile {
    local($file) = @_;
    local(*FP, $size, $buffer, $bytes);
    ($x, $x, $x, $x, $x, $x, $x, $size) = stat($file);
    $size = sprintf("%d", $size);
    open(FP, "&amp;lt;$file");
    $bytes = sysread(FP, $buffer, $size);
    close(FP);
    return $buffer;
}

$buffer = &amp;readfile($QS_f);
&amp;print_http_headers_multipart_begin;
&amp;displayhtml($buffer);

sub mystat {
    local($file) = $_[0];
    local($time);

    ($x, $x, $x, $x, $x, $x, $x, $x, $x, $mtime) = stat($file);
    return $mtime;
}

$mtimeL = &amp;mystat($QS_f);
$mtime = $mtime;
for ($n = 0; $n &amp;lt; $QS_n; $n++) {
    while (1) {
        $mtime = &amp;mystat($QS_f);
        if ($mtime ne $mtimeL) {
            $mtimeL = $mtime;
            sleep(2);
            $buffer = &amp;readfile($QS_f);
            &amp;print_http_headers_multipart_next;
            &amp;displayhtml($buffer);
            sleep(5);
            $mtimeL = &amp;mystat($QS_f);
            last;
        }
        sleep($QS_s);
    }
}

&amp;print_http_headers_multipart_end;

exit(0);

##EOF##
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="mass-virtual-hosting" id="mass-virtual-hosting">Hbergement virtuel de masse</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>La fonctionnalit <code class="directive"><a href="/mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code> d'Apache est intressante et
	  fonctionne de manire satisfaisante jusqu' quelques
	  douzaines de serveurs virtuels. Par contre, si vous tes un
	  FAI et devez hberger des centaines de serveurs virtuels,
	  cette mthode n'est pas optimale.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Pour fournir cette fonctionnalit avec
	  <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code>, on fait correspondre  notre espace de
	  nommage la page web ou mme le rpertoire complet distants en
	  utilisant la fonctionnalit <dfn>Mandataire</dfn>
	  (drapeau <code>[P]</code>) :</p>

<div class="example"><pre>
##
##  vhost.map
##
www.vhost1.dom:80  /chemin/vers/racine-doc/vhost1
www.vhost2.dom:80  /chemin/vers/racine-doc/vhost2
     :
www.vhostN.dom:80  /chemin/vers/racine-doc/vhostN
</pre></div>

<div class="example"><pre>
##
##  httpd.conf
##
    :
#   utilisation du nom d'hte canonique pour les redirections, etc...
UseCanonicalName on

    :
#   ajout du serveur virtuel en tte du format CLF
CustomLog  /chemin/vers/access_log  "%{VHOST}e %h %l %u %t \"%r\" %&gt;s %b"
    :

#   activation du moteur de rcriture pour le serveur principal
RewriteEngine on

#   dfinition de deux tables de correspondances : une premire pour
#   corriger les URLs et une seconde qui associe les serveurs virtuels
#   disponibles avec leurs racines des documents correspondantes.
RewriteMap    lowercase    int:tolower
RewriteMap    vhost        txt:/chemin/vers/vhost.map

#   et enfin slection proprement dite du serveur virtuel appropri via
#   une seule rgle longue et complexe :
#
#   1. on s'assure de ne pas slectionner un hte virtuel pour les
#   adresses communes

RewriteCond   %{REQUEST_URI}  !^/adresse-commune1/.*
RewriteCond   %{REQUEST_URI}  !^/adresse-commune2/.*
    :
RewriteCond   %{REQUEST_URI}  !^/adresse-communeN/.*
#
#   2. on vrifie que l'on dispose bien d'un en-tte Host, car
#   actuellement, cette mthode ne peut faire de l'hbergement virtuel
#   qu'avec cet en-tte
RewriteCond   %{HTTP_HOST}  !^$
#
#   3. mise en minuscules du nom d'hte
RewriteCond   ${lowercase:%{HTTP_HOST}|NONE}  ^(.+)$
#
#   4. recherche ce ce nom d'hte dans vhost.map et
#      enregistrement de celui-ci seulement s'il s'agit d'un chemin
#      (et non "NONE" en provenance de la condition prcdente)
RewriteCond   ${vhost:%1}  ^(/.*)$
#
#   5. nous pouvons enfin faire correspondre l'URL avec la racine des
#   documents correspondant au serveur virtuel appropri et enregistrer
#   ce dernier  des fins de journalisation
RewriteRule   ^/(.*)$   %1/$1  [E=VHOST:${lowercase:%{HTTP_HOST}}]
    :
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="host-deny" id="host-deny">Interdiction d'htes</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment interdire l'accs  notre serveur  une liste
	  d'htes ?</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Pour Apache &gt;= 1.3b6 :</p>

<div class="example"><pre>
RewriteEngine on
RewriteMap    htes-interdits  txt:/chemin/vers/htes-interdits
RewriteCond   ${htes-interdits:%{REMOTE_HOST}|NOT-FOUND} !=NOT-FOUND [OR]
RewriteCond   ${htes-interdits:%{REMOTE_ADDR}|NOT-FOUND} !=NOT-FOUND
RewriteRule   ^/.*  -  [F]
</pre></div>

          <p>Pour Apache &lt;= 1.3b6 :</p>

<div class="example"><pre>
RewriteEngine on
RewriteMap    htes-interdits  txt:/chemin/vers/htes-interdits
RewriteRule   ^/(.*)$ ${htes-interdits:%{REMOTE_HOST}|NOT-FOUND}/$1
RewriteRule   !^NOT-FOUND/.* - [F]
RewriteRule   ^NOT-FOUND/(.*)$ ${htes-interdits:%{REMOTE_ADDR}|NOT-FOUND}/$1
RewriteRule   !^NOT-FOUND/.* - [F]
RewriteRule   ^NOT-FOUND/(.*)$ /$1
</pre></div>

<div class="example"><pre>
##
##  hosts.deny
##
##  ATTENTION! Ceci est une table de correspondances, pas une liste,
##  mme si on l'utilise en tant que telle. mod_rewrite l'interprte
##  comme un ensemble de paires cl/valeur ; chaque entre doit donc
##  au moins possder une valeur fictive "-".
##

193.102.180.41 -
bsdti1.sdm.de  -
192.76.162.40  -
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="proxy-deny" id="proxy-deny">Interdiction du mandataire</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment interdire l'utilisation du mandataire d'Apache pour
	  un certain hte, ou mme seulement pour un utilisateur
	  de cet hte ?</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>Nous devons tout d'abord nous assurer que
	  <code class="module"><a href="/mod/mod_rewrite.html">mod_rewrite</a></code> arrive aprs(!)
	  <code class="module"><a href="/mod/mod_proxy.html">mod_proxy</a></code> dans le fichier de configuration
	  lors de la compilation du serveur web Apache. De cette faon,
	  il est appel <em>avant</em> <code class="module"><a href="/mod/mod_proxy.html">mod_proxy</a></code>. Nous
	  pouvons ensuite dfinir cette rgle pour une interdiction
	  dpendant de l'hte :</p>

<div class="example"><pre>
RewriteCond %{REMOTE_HOST} <strong>^hte--rejeter\.mon-domaine\.com$</strong>
RewriteRule !^http://[^/.]\.mon-domaine.com.*  - [F]
</pre></div>

          <p>...et celle-ci pour une interdiction dpendant de
	  utilisateur@hte :</p>

<div class="example"><pre>
RewriteCond %{REMOTE_IDENT}@%{REMOTE_HOST}  <strong>^utilisateur--
rejeter@hte--rejeter\.mon-domaine\.com$</strong>
RewriteRule !^http://[^/.]\.mon-domaine.com.*  - [F]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="special-authentication" id="special-authentication">Variante particulire d'authentification</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>On a parfois besoin d'une authentification trs
	  particulire, par exemple une authentification qui vrifie la
	  prsence d'un utilisateur dans une liste explicitement
	  dfinie. Seuls ceux qui sont prsents dans la liste se voient
	  accorder un accs, et ceci sans avoir 
	  s'identifier/authentifier (comme c'est le cas avec une
	  authentification de base via <code class="module"><a href="/mod/mod_auth.html">mod_auth</a></code>).</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On dfinit une liste de conditions de rcriture pour
	  interdire l'accs  tout le monde, sauf aux utilisateurs
	  autoriss :</p>

<div class="example"><pre>
RewriteCond %{REMOTE_IDENT}@%{REMOTE_HOST} <strong>!^ami1@client1.quux-corp\.com$</strong>
RewriteCond %{REMOTE_IDENT}@%{REMOTE_HOST} <strong>!^ami2</strong>@client2.quux-corp\.com$
RewriteCond %{REMOTE_IDENT}@%{REMOTE_HOST} <strong>!^ami3</strong>@client3.quux-corp\.com$
RewriteRule ^/~quux/seulement-pour-les-amis/      -                                 [F]
</pre></div>
        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="/images/up.gif" /></a></div>
<div class="section">
<h2><a name="referer-deflector" id="referer-deflector">Redirection base sur le rfrent</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Comment crire un programme souple qui redirige certaines
	  URLs en se basant sur l'en-tte HTTP "Referer", et peut tre
	  configur avec autant de pages de rfrence
	  que l'on veut ?</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
          <p>On utilise le jeu de rgles vraiment astucieux suivant :</p>

<div class="example"><pre>
RewriteMap  deflector txt:/chemin/vers/deflector.map

RewriteCond %{HTTP_REFERER} !=""
RewriteCond ${deflector:%{HTTP_REFERER}} ^-$
RewriteRule ^.* %{HTTP_REFERER} [R,L]

RewriteCond %{HTTP_REFERER} !=""
RewriteCond ${deflector:%{HTTP_REFERER}|NOT-FOUND} !=NOT-FOUND
RewriteRule ^.* ${deflector:%{HTTP_REFERER}} [R,L]
</pre></div>

          <p>... en association avec la table de rcriture
	  correspondante :</p>

<div class="example"><pre>
##
##  deflector.map
##

http://www.mauvais-sujets.com/mauvais/index.html    -
http://www.mauvais-sujets.com/mauvais/index2.html   -
http://www.mauvais-sujets.com/mauvais/index3.html   http://quelque-part.com/
</pre></div>

          <p>Les requtes sont rediriges vers la page de rfrence
	  (lorsque la valeur correspondant  la cl extraite de la table
	  de correspondances est gale  "<code>-</code>"), ou vers une
	  URL spcifique (lorsqu'une URL est dfinie dans la table de
	  correspondances comme second argument).</p>
        </dd>
      </dl>

    </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span></p>
</div><div id="footer">
<p class="apache">Copyright 2009 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="/mod/">Modules</a> | <a href="/mod/directives.html">Directives</a> | <a href="/faq/">FAQ</a> | <a href="/glossary.html">Glossaire</a> | <a href="/sitemap.html">Plan du site</a></p></div>
</body></html>