<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Fichiers journaux - Serveur Apache HTTP</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.3</a></div><div id="page-content"><div id="preamble"><h1>Fichiers journaux</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/logs.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/logs.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/logs.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/logs.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/logs.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

    <p>Pour vritablement grer un serveur web,
    il est ncessaire de disposer d'un
    retour d'informations  propos de l'activit et des performances du
    serveur, ainsi que de tout problme qui pourrait survenir. Le serveur HTTP
    Apache propose des fonctionnalits de journalisation souples et trs
    compltes. Ce document dcrit comment configurer ces fonctionnalits de
    journalisation et interprter le contenu des journaux.</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#security">Avertissement  propos de la scurit</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#errorlog">Journal des erreurs</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#accesslog">Journal des accs</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#rotation">Rotation des journaux</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#piped">Journaux redirigs</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#virtualhost">Htes virtuels</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#other">Autres fichiers journaux</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="security" id="security">Avertissement  propos de la scurit</a></h2>
    

    <p>Tout utilisateur qui a les droits en criture sur le rpertoire dans
    lequel Apache crit ses journaux pourra quasi
    certainement avoir accs  l'uid sous lequel le serveur est dmarr, en
    l'occurrence habituellement root. N'accordez <em>PAS</em> aux utilisateurs
    l'accs en criture au rpertoire dans lequel les journaux sont stocks
    sans savoir exactement quelles en seraient les consquences ; voir le
    document <a href="misc/security_tips.html">conseils sur la scurit</a>
    pour plus de dtails.</p>

    <p>En outre, les journaux peuvent contenir des informations fournies
    directement par un client, sans caractres d'chappement. Des clients mal
    intentionns peuvent donc insrer des caractres de contrle dans les
    journaux, et il convient par consquent d'tre trs prudent lors de la
    manipulation des journaux bruts.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="errorlog" id="errorlog">Journal des erreurs</a></h2>
    

    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td /><td><ul><li><code class="directive"><a href="./mod/core.html#errorlog">ErrorLog</a></code></li><li><code class="directive"><a href="./mod/core.html#loglevel">LogLevel</a></code></li></ul></td></tr></table>

    <p>Le journal des erreurs du serveur, dont le nom et la localisation sont
    dfinis par la directive <code class="directive"><a href="./mod/core.html#errorlog">ErrorLog</a></code>,
    est le journal le plus important. C'est dans celui-ci
    que le dmon Apache httpd va envoyer les informations de diagnostic et
    enregistrer toutes les erreurs qui surviennent lors du traitement des
    requtes. Lorsqu'un problme survient au dmarrage du serveur ou pendant
    son fonctionnement, la premire chose  faire est de regarder dans ce
    journal, car il vous renseignera souvent sur le problme rencontr et
    la manire d'y remdier.</p>

    <p>Le journal des erreurs est habituellement enregistr dans un fichier
    (en gnral <code>error_log</code> sur les systmes de type Unix et
    <code>error.log</code> sur Windows et OS/2). Sur les systmes de type Unix,
    le serveur peut aussi enregistrer ses erreurs dans
    <code>syslog</code> ou les
    <a href="#piped">rediriger vers un programme</a> par l'intermdiaire d'un
    tube de communication (pipe).</p>

    <p>Le format du journal des erreurs est descriptif et de forme
    relativement libre. Certaines informations apparaissent cependant dans la
    plupart des entres du journal. Voici un message typique
     titre d'exemple : </p>

    <div class="example"><p><code>
      [Wed Oct 11 14:32:52 2000] [error] [client 127.0.0.1]
      client denied by server configuration:
      /export/home/live/ap/htdocs/test
    </code></p></div>

    <p>Le premier champ de l'entre du journal est la date et l'heure du
    message. Le second champ indique la svrit de l'erreur rapporte. La
    directive <code class="directive"><a href="./mod/core.html#loglevel">LogLevel</a></code> permet de
    restreindre le type des erreurs qui doivent tre enregistres
    dans le journal des erreurs en dfinissant leur niveau de svrit. Le
    troisime champ contient l'adresse IP du client qui a gnr l'erreur.
    Vient ensuite le message proprement dit, qui indique dans ce cas que le
    serveur a t configur pour interdire l'accs au client. Le serveur
    indique le chemin systme du document requis (et non
    son chemin web).</p>

    <p>Une grande varit de messages diffrents peuvent apparatre dans le
    journal des erreurs. La plupart d'entre eux sont similaires  l'exemple
    ci-dessus. Le journal des erreurs peut aussi contenir des informations de
    dbogage en provenance de scripts CGI. Toute information qu'un script CGI
    crit sur la sortie d'erreurs standard <code>stderr</code> sera recopie
    telle quelle dans le journal des erreurs.</p>

    <p>Il n'est pas possible de personnaliser le journal des erreurs en ajoutant ou en
    supprimant des informations. Cependant, les entres du journal des erreurs
    qui concernent certaines requtes possdent des entres correspondantes
    dans le <a href="#accesslog">journal des accs</a>. Ainsi, l'entre de
    l'exemple ci-dessus correspond  une entre du journal des accs avec un
    code de statut 403. Etant donn qu'il est possible de personnaliser le
    journal des accs, vous pouvez obtenir d'avantage d'informations sur les
    circonstances d'une erreur en consultant ce journal.</p>

    <p>Pendant la phase de test, il est souvent utile de visualiser en continu
    le journal des erreurs afin de dtecter tout problme ventuel. Sur les
    systmes de type Unix, ceci s'effectue  l'aide de la commande :</p>

    <div class="example"><p><code>
      tail -f error_log
    </code></p></div>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="accesslog" id="accesslog">Journal des accs</a></h2>
    

    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_log_config.html">mod_log_config</a></code></li><li><code class="module"><a href="./mod/mod_setenvif.html">mod_setenvif</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code></li><li><code class="directive"><a href="./mod/mod_log_config.html#logformat">LogFormat</a></code></li><li><code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code></li></ul></td></tr></table>

    <p>Le journal des accs au serveur
    enregistre toutes les requtes que traite
    ce dernier. La localisation et le contenu du journal des accs sont dfinis
    par la directive <code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code>.
    La directive <code class="directive"><a href="./mod/mod_log_config.html#logformat">LogFormat</a></code>
    permet de simplifier la slection du contenu du journal. Cette section
    dcrit comment configurer le serveur pour l'enregistrement des informations
    dans le journal des accs.</p>

    <p>Bien videmment, le stockage d'informations dans le journal des accs
    n'est que le point de dpart de la gestion de la journalisation. L'tape
    suivante consiste  analyser ces informations de faon  pouvoir en
    extraire des statistiques utiles. L'analyse de journaux en gnral est en
    dehors du sujet de ce document et ne fait pas vraiment partie intgrante
    du travail du serveur web lui-mme. Pour plus d'informations  propos de ce
    sujet et des applications ddies  l'analyse de journaux, vous pouvez vous
    rfrer  <a href="http://dmoz.org/Computers/Software/Internet/     Site_Management/Log_analysis/">Open Directory</a> ou
    <a href="http://dir.yahoo.com/Computers_and_Internet/Software/     Internet/World_Wide_Web/Servers/Log_Analysis_Tools/">Yahoo</a>.</p>

    <p>Diffrentes versions du dmon Apache httpd utilisaient d'autres modules
    et directives pour contrler la journalisation des accs,  l'instar de
    mod_log_referer, mod_log_agent, et de la directive
    <code>TransferLog</code>. La directive
    <code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code> rassemble
    dsormais les fonctionnalits de toutes les anciennes directives.</p>

    <p>Le format du journal des accs est hautement configurable. Il est
    dfini  l'aide d'une chane de format qui ressemble sensiblement  la
    chane de format de style langage C de printf(1). Vous trouverez quelques
    exemples dans les sections suivantes. Pour une liste exhaustive de ce que
    peut contenir une chane de format, vous pouvez vous rfrer au chapitre
    <a href="mod/mod_log_config.html#formats">chanes de format</a> de la
    documentation du module <code class="module"><a href="./mod/mod_log_config.html">mod_log_config</a></code>.</p>

    <h3><a name="common" id="common">Format habituel du journal</a></h3>
      

      <p>Voici une configuration typique pour le journal des accs :</p>

      <div class="example"><p><code>
        LogFormat "%h %l %u %t \"%r\" %&gt;s %b" common<br />
         CustomLog logs/access_log common
      </code></p></div>

      <p>Ici est dfinie l'<em>identit</em> <code>common</code> qui est
      ensuite associe  une chane de format de journalisation particulire.
      La chane de format est constitue de directives dbutant par le
      caractre %, chacune d'entre elles indiquant au serveur d'enregistrer
      un lment particulier d'information. Des caractres littraux peuvent
      aussi tre insrs dans la chane de format ; il seront copis tels
      quels dans le flux de sortie destin  la journalisation.
      Les guillemets (<code>"</code>) doivent tre chappes en les faisant
      prcder d'un anti-slash (<code>\</code>) afin qu'elles ne soient pas
      interprtes comme la fin de la chane de format. La chane de format
      peut aussi contenir les caractres de contrle spciaux
      "<code>\n</code>" et "<code>\t</code>" pour insrer respectivement
      un passage  la ligne et une tabulation.</p>

      <p>La directive <code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code>
      dfinit un nouveau fichier journal en l'associant  l'identit
      prcdemment dfinie. Le chemin du nom de fichier associ au journal
      des accs est relatif au chemin dfini par la directive
      <code class="directive"><a href="./mod/core.html#serverroot">ServerRoot</a></code>, sauf s'il
      dbute par un slash.</p>

      <p>La configuration ci-dessus va enregistrer les entres de
      journalisation selon un format connu sous le nom de
      Common Log Format (CLF) pour "Format de journalisation standard".
      Ce format standard peut tre produit par de nombreux serveurs web
      diffrents et lu par de nombreux programmes d'analyse de journaux.
      Les entres de fichier journal gnres selon le format CLF
      ressemblent  ceci :</p>

      <div class="example"><p><code>
        127.0.0.1 - frank [10/Oct/2000:13:55:36 -0700] "GET
        /apache_pb.gif HTTP/1.0" 200 2326
      </code></p></div>

      <p>Chaque partie de cette entre de journal est dcrite
      dans ce qui suit.</p>

      <dl>
        <dt><code>127.0.0.1</code> (<code>%h</code>)</dt>

        <dd>Il s'agit de l'adresse IP du client (l'hte distant) qui a envoy
	la requte au serveur. Si la directive
	<code class="directive"><a href="./mod/core.html#hostnamelookups">HostnameLookups</a></code> est positionne 
	<code>On</code>, le serveur va essayer de dterminer le nom de l'hte
	et de l'enregistrer  la place de l'adresse IP. Cette configuration
	n'est cependant pas recommande car elle peut ralentir le serveur de
	manire significative. Il est par consquent prfrable d'utiliser un
	processeur d'analyse de journaux a posteriori
	tel que <code class="program"><a href="./programs/logresolve.html">logresolve</a></code>
	pour dterminer les noms d'hte. L'adresse IP indique ici n'est pas
	ncessairement l'adresse IP de la machine devant laquelle se trouve
	l'utilisateur. Si un serveur mandataire s'intercale entre le serveur
	et l'utilisateur, l'adresse indique sera celle du mandataire et non
	celle de la machine  l'origine de la requte.</dd>

        <dt><code>-</code> (<code>%l</code>)</dt>

        <dd>Le "trait d'union" indique que la portion d'information
	correspondante n'est pas disponible. Dans le cas prsent, l'information
	non disponible est l'identit (RFC 1413) du client telle que dtermine
	par <code>identd</code> sur la machine cliente. Cette information est
	trs peu fiable et ne devrait jamais tre utilise, sauf dans le cas
	de rseaux internes troitement contrls. Le dmon httpd ne cherchera
	d'ailleurs  obtenir cette information que si la directive
	<code class="directive"><a href="./mod/core.html#identitycheck">IdentityCheck</a></code> est positionne
	 <code>On</code>.</dd>

        <dt><code>frank</code> (<code>%u</code>)</dt>

        <dd>Il s'agit de l'identifiant utilisateur de la personne qui a
	demand le document, issu d'une authentification HTTP.
	Ce mme identifiant est en gnral fourni aux scripts CGI par
	l'intermdiaire de la valeur de la variable d'environnement
	<code>REMOTE_USER</code>. Si le statut de la requte (voir plus loin)
	est 401, cette identifiant n'est pas fiable car l'utilisateur n'est
	pas encore authentifi. Si le document n'est pas protg par
	mot de passe, cette partie d'information sera reprsente par
	"<code>-</code>", comme la partie prcdente.</dd>

        <dt><code>[10/Oct/2000:13:55:36 -0700]</code>
        (<code>%t</code>)</dt>

        <dd>
          L'heure  laquelle la requte a t reue.
          Le format est le suivant :

          <p class="indent">
            <code>[jour/mois/anne:heure:minutes:secondes zone]<br />
             jour = 2*chiffre<br />
             mois = 3*lettre<br />
             anne = 4*chiffre<br />
             heure = 2*chiffre<br />
             minutes = 2*chiffre<br />
             secondes = 2*chiffre<br />
             zone = (`+' | `-') 4*chiffre</code>
          </p>Il est possible de modifier le format d'affichage de l'heure
	  en spcifiant <code>%{format}t</code> dans la chane de format du
	  journal, o <code>format</code> est une chane de format de mme
	  forme que celle de la fonction <code>strftime(3)</code> de la
	  bibliothque C standard.
        </dd>

        <dt><code>"GET /apache_pb.gif HTTP/1.0"</code>
        (<code>\"%r\"</code>)</dt>

        <dd>La ligne de la requte du client est place entre guillemets.
	Elle contient de nombreuses informations utiles. Tout d'abord, la
	mthode utilise par le client est <code>GET</code>. Ensuite, le
	client a demand la ressource <code>/apache_pb.gif</code>, et enfin,
	le client a utilis le protocole <code>HTTP/1.0</code>. Il est aussi
	possible d'enregistrer sparment une ou plusieurs parties de la
	requte. Par exemple, la chane de format "<code>%m %U %q %H</code>"
	va enregistrer la mthode, le chemin, la chane de la requte et le
	protocole, ce qui donnera le mme rsultat que
	"<code>%r</code>".</dd>

        <dt><code>200</code> (<code>%&gt;s</code>)</dt>

        <dd>C'est le code de statut que le serveur retourne au client. Cette
	information est trs importante car elle indique si la requte a fait
	l'objet d'une rponse positive (codes commenant par 2), une
	redirection (codes commenant par 3), une erreur due au client (codes
	commenant par 4), ou une erreur due au serveur (codes commenant
	par 5). Vous trouverez la liste complte des codes de statut possibles
	dans la <a href="http://www.w3.org/Protocols/rfc2616/  rfc2616.txt">specification HTTP</a> (RFC2616 section 10).</dd>

        <dt><code>2326</code> (<code>%b</code>)</dt>

        <dd>La dernire partie indique la taille de l'objet retourn au client,
	en-ttes non compris. Si aucun contenu n'a t retourn au client, cette
	partie contiendra "<code>-</code>". Pour indiquer l'absence de contenu
	par "<code>0</code>", utilisez <code>%B</code> au lieu de
	<code>%b</code>.</dd>
      </dl>
    

    <h3><a name="combined" id="combined">Combined Log Format (Format de journalisation combin)</a></h3>
      

      <p>Une autre chane de format couramment utilise est le
      "Combined Log Format" (Format de journalisation combin). Il s'utilise
      comme suit :</p>

      <div class="example"><p><code>
        LogFormat "%h %l %u %t \"%r\" %&gt;s %b \"%{Referer}i\"
        \"%{User-agent}i\"" combined<br />
         CustomLog log/access_log combined
      </code></p></div>

      <p>Ce format est identique au Common Log Format, avec deux champs
      supplmentaires. Chacun de ces deux champs utilise la directive
      commenant par le caractre "%" <code>%{<em>header</em>}i</code>,
      o <em>header</em> peut tre n'importe quel en-tte de requte HTTP.
      Avec ce format, le journal des accs se prsentera comme suit :</p>

      <div class="example"><p><code>
        127.0.0.1 - frank [10/Oct/2000:13:55:36 -0700] "GET
        /apache_pb.gif HTTP/1.0" 200 2326
        "http://www.example.com/start.html" "Mozilla/4.08 [en]
        (Win98; I ;Nav)"
      </code></p></div>

      <p>Les champs supplmentaires sont :</p>

      <dl>
        <dt><code>"http://www.example.com/start.html"</code>
        (<code>\"%{Referer}i\"</code>)</dt>

        <dd>L'en-tte "Referer" (sic) de la requte HTTP. Il indique le site
	depuis lequel le client prtend avoir lanc sa requte. (Ce doit tre
	la page qui contient un lien vers <code>/apache_pb.gif</code> ou
	inclut ce dernier fichier).</dd>

        <dt><code>"Mozilla/4.08 [en] (Win98; I ;Nav)"</code>
        (<code>\"%{User-agent}i\"</code>)</dt>

        <dd>L'en-tte User-Agent de la requte HTTP. C'est une information
	d'identification que le navigateur du client envoie  propos
	de lui-mme.</dd>
      </dl>
    

    <h3><a name="multiple" id="multiple">Journaux d'accs multiples</a></h3>
      

      <p>Plusieurs journaux d'accs peuvent tre crs en spcifiant tout
      simplement plusieurs directives
      <code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code> dans le
      fichier de configuration. Par exemple, les directives suivantes vont
      crer trois journaux d'accs. Le premier contiendra les informations
      de base CLF, le second les informations du Referer, et le troisime
      les informations sur le navigateur. Les deux dernires directives
      <code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code> montrent
      comment simuler les effets des directives <code>ReferLog</code> et
      <code>AgentLog</code>.</p>

      <div class="example"><p><code>
        LogFormat "%h %l %u %t \"%r\" %&gt;s %b" common<br />
        CustomLog logs/access_log common<br />
        CustomLog logs/referer_log "%{Referer}i -&gt; %U"<br />
        CustomLog logs/agent_log "%{User-agent}i"
      </code></p></div>

      <p>Cet exemple montre aussi qu'il n'est pas obligatoire d'associer
      une chane de format  un alias au moyen de la directive
      <code class="directive"><a href="./mod/mod_log_config.html#logformat">LogFormat</a></code>. Elle peut
      tre dfinie directement dans la ligne de la directive
      <code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code>.</p>
    

    <h3><a name="conditional" id="conditional">Journalisation conditionnelle</a></h3>
      

      <p>Il est parfois souhaitable d'exclure certaines entres des journaux
      d'accs en fonction des caractristiques de la requte du client. On
      peut aisment accomplir ceci  l'aide des
      <a href="env.html">variables d'environnement</a>. Tout d'abord, une
      variable d'environnement doit tre dfinie pour indiquer que la
      requte remplit certaines conditions. Pour ceci, on utilise en gnral
      la directive <code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code>,
      puis la clause <code>env=</code> de la directive
      <code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code> pour inclure
      ou exclure les requtes pour lesquelles
      la variable d'environnement est dfinie.
      Quelques exemples :</p>

      <div class="example"><p><code>
        # Marque les requtes en provenance de l'interface loop-back<br />
        SetEnvIf Remote_Addr "127\.0\.0\.1" dontlog<br />
        # Marque les requtes pour le fichier robots.txt<br />
        SetEnvIf Request_URI "^/robots\.txt$" dontlog<br />
        # Journalise toutes les autres requtes<br />
        CustomLog logs/access_log common env=!dontlog
      </code></p></div>

      <p>Autre exemple, imaginons l'enregistrement des requtes en provenance
      d'utilisateurs de langue anglaise dans un journal, et celles des autres
      utilisateurs dans un autre journal.</p>

      <div class="example"><p><code>
        SetEnvIf Accept-Language "en" english<br />
        CustomLog logs/english_log common env=english<br />
        CustomLog logs/non_english_log common env=!english
      </code></p></div>

      <p>Bien que nous venions de montrer que la journalisation conditionnelle
      est souple et trs puissante, cette mthode de contrle du contenu des
      journaux n'est pas la seule. Les fichiers journaux sont plus utiles
      quand ils contiennent un enregistrement complet de l'activit du serveur,
      et il est souvent plus ais de simplement traiter  posteriori les fichiers
      journaux pour supprimer les requtes que vous ne voulez pas y voir
      apparatre.</p>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="rotation" id="rotation">Rotation des journaux</a></h2>
    

    <p>Mme dans le cas d'un serveur modrment sollicit, la quantit
    d'informations stockes dans les fichiers journaux est trs importante.
    Le fichier journal des accs grossit en gnral d'1 Mo ou plus toutes
    les 10000 requtes. Il est par consquent ncessaire d'effectuer
    priodiquement la rotation des journaux en dplaant ou supprimant les
    fichiers correspondants. On ne peut pas le faire pendant que le serveur
    est en cours d'excution, car Apache va continuer  crire dans l'ancien
    fichier journal aussi longtemps qu'il le maintiendra ouvert.
    C'est pourquoi le serveur doit tre
    <a href="stopping.html">redmarr</a> aprs le dplacement ou la
    suppression des fichiers journaux de faon  ce qu'il en ouvre
    de nouveaux.</p>

    <p>Avec un redmarrage <em>graceful</em>, on peut faire en sorte que le
    serveur ouvre de nouveaux fichiers journaux sans perdre de connexions
    existantes ou en cours avec les clients. Cependant, pour que ceci soit
    possible, le serveur doit continuer  crire dans les anciens fichiers
    journaux pendant qu'il termine le traitement des requtes en cours.
    Il est donc ncessaire d'attendre un certain temps aprs le rdmarrage
    avant d'effectuer tout traitement sur les fichiers journaux. Voici un
    scnario typique dans lequel on effectue une simple rotation des
    journaux en compressant les anciens fichiers correspondants afin
    de gagner de l'espace disque :</p>

    <div class="example"><p><code>
      mv access_log access_log.old<br />
      mv error_log error_log.old<br />
      apachectl graceful<br />
      sleep 600<br />
      gzip access_log.old error_log.old
    </code></p></div>

    <p>La section suivante prsente une autre mthode de rotation des journaux
    qui consiste  utiliser les
    <a href="#piped">journaux redirigs</a>.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="piped" id="piped">Journaux redirigs</a></h2>
    

    <p>Nous avons vu que le dmon httpd crivait les informations de
    journalisation des erreurs et des accs dans un fichier journal ;
    il peut aussi
    rediriger ces informations vers un autre processus par l'intermdiaire d'un
    tube de communication (pipe). Cette fonctionnalit amliore
    considrablement la souplesse de la journalisation, sans ajouter de code
    au serveur principal. Pour rediriger les informations de journalisation
    vers un tube de communication, remplacez simplement le nom de fichier
    journal par
    le caractre pipe "<code>|</code>", suivi du nom de l'excutable qui va
    recueillir les entres de journal sur son entre standard. Apache va
    lancer le processus de redirection des journaux au moment du dmarrage du
    serveur, et le relancera s'il cesse de fonctionner
    pendant l'excution du serveur.
    (Nous dnommons cette technique "journalisation
    redirige fiable" grce  cette dernire fonctionnalit.)</p>

    <p>Les processus de journalisation redirige sont lancs par le processus
    httpd parent, et hritent de l'UID de ce dernier. Cela signifie que les
    programmes de journalisation dirige s'excutent gnralement en tant que
    root. Il est donc trs important que ces programmes soient simples et
    scuriss.</p>

    <p>Un des grands avantages de la journalisation redirige est la possibilit
    d'effectuer la rotation des journaux sans avoir  redmarrer le serveur. Pour
    accomplir cette tche, le serveur HTTP Apache fournit un programme simple
    appel <code class="program"><a href="./programs/rotatelogs.html">rotatelogs</a></code>. Par exemple, pour une rotation des
    journaux toutes les 24 heures, ajoutez ces lignes :</p>

    <div class="example"><p><code>
      CustomLog "|/usr/local/apache/bin/rotatelogs
      /var/log/access_log 86400" common
    </code></p></div>

    <p>Notez que l'ensemble de la commande qui sera appele par le tube de
    communication a t place entre guillemets. Bien que cet exemple
    concerne le journal des accs, la mme technique peut tre utilise
    pour le journal des erreurs.</p>

    <p>Il existe un autre programme de rotation des journaux similaire mais
    beaucoup plus souple : il s'agit de "cronolog", non fourni par Apache,
    mais disponible <a href="http://www.cronolog.org/">ici</a>.</p>

    <p>Comme la journalisation conditionnelle, la journalisation redirige est
    un outil trs puissant, mais si elle existe, il est prfrable d'utiliser
    une solution plus simple comme le traitement  posteriori hors ligne.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="virtualhost" id="virtualhost">Htes virtuels</a></h2>
    

    <p>Lorsqu'un serveur possde plusieurs <a href="vhosts/">htes virtuels</a>, il existe de nombreuses solutions pour grer
    les fichiers journaux. Par exemple, on peut utiliser les journaux comme
    s'il s'agissait d'un serveur avec un seul hte. Il suffit pour cela de
    placer les directives de journalisation en dehors des sections
    <code class="directive"><a href="./mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code> au niveau
    du serveur principal, ce qui a pour effet de journaliser toutes les
    requtes dans le mme journal des accs et des erreurs. Cette technique
    est cependant inapproprie pour recueillir des statistiques sur chaque
    hte virtuel individuellement.</p>

    <p>Si des directives <code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code> ou
    <code class="directive"><a href="./mod/core.html#errorlog">ErrorLog</a></code> sont places dans une section
    <code class="directive"><a href="./mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>, toutes les
    requtes ou erreurs pour cet hte virtuel ne seront enregistres que dans
    le fichier spcifi. Tout hte virtuel qui ne possde pas de directives de
    journalisation verra ses requtes enregistres dans le journal du serveur
    principal. Cette technique est approprie pour un petit nombre d'htes
    virtuels, mais si ce nombre est important, elle peut devenir complique 
    grer. En outre, des problmes de <a href="vhosts/fd-limits.html">nombre de descripteurs
    de fichiers insuffisant</a> peuvent rapidement apparatre.</p>

    <p>Il existe un trs bon compromis pour le journal des accs. En intgrant
    les informations  propos de l'hte virtuel  la chane de format du
    journal, il est possible de journaliser tous les htes dans le mme
    journal, puis de sparer ultrieurement le journal en plusieurs journaux
    individuels. Considrons par exemple les directives suivantes :</p>

    <div class="example"><p><code>
      LogFormat "%v %l %u %t \"%r\" %&gt;s %b"
      comonvhost<br />
      CustomLog logs/access_log comonvhost
    </code></p></div>

    <p>Le champ <code>%v</code> sert  enregistrer le nom de l'hte virtuel qui
    traite la requte. Un programme tel que <a href="programs/other.html">split-logfile</a> peut ensuite tre utilis
    pour gnrer " froid" autant de journaux que d'htes virtuels.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="other" id="other">Autres fichiers journaux</a></h2>
    

    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_logio.html">mod_logio</a></code></li><li><code class="module"><a href="./mod/mod_log_forensic.html">mod_log_forensic</a></code></li><li><code class="module"><a href="./mod/mod_cgi.html">mod_cgi</a></code></li><li><code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_log_config.html#logformat">LogFormat</a></code></li><li><code class="directive"><a href="./mod/mod_log_forensic.html#forensiclog">ForensicLog</a></code></li><li><code class="directive"><a href="./mod/mpm_common.html#pidfile">PidFile</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewritelog">RewriteLog</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewriteloglevel">RewriteLogLevel</a></code></li><li><code class="directive"><a href="./mod/mod_cgi.html#scriptlog">ScriptLog</a></code></li><li><code class="directive"><a href="./mod/mod_cgi.html#scriptlogbuffer">ScriptLogBuffer</a></code></li><li><code class="directive"><a href="./mod/mod_cgi.html#scriptloglength">ScriptLogLength</a></code></li></ul></td></tr></table>

    <h3>Enregistrement du nombre rel d'octets envoys et reus</h3>
      

      <p>Le module <code class="module"><a href="./mod/mod_logio.html">mod_logio</a></code> fournit deux champs
      <code class="directive"><a href="./mod/mod_log_config.html#logformat">LogFormat</a></code> supplmentaires
      (%I et %O) qui permettent d'enregistrer le nombre rel d'octets reus et
      envoys sur le rseau.</p>
    

    <h3>Journalisation de style investigation judiciaire (forensic logging)</h3>
      

      <p>Le module <code class="module"><a href="./mod/mod_log_forensic.html">mod_log_forensic</a></code> permet la journalisation
       des fins d'investigation judiciaire des requtes des clients. La
      journalisation est effectue avant et aprs le traitement de la requte,
      qui fait donc l'objet de deux entres dans le journal. Le gnrateur de
      journaux d'investigation est trs strict et ne permet aucune
      personnalisation. C'est un inestimable outil de dbogage et de scurit.</p>
    

    <h3><a name="pidfile" id="pidfile">Fichier PID</a></h3>
      

      <p>Au dmarrage, le dmon httpd Apache enregistre l'identifiant du
      processus httpd parent dans le fichier <code>logs/httpd.pid</code>.
      Le nom de ce fichier peut tre modifi  l'aide de la directive
      <code class="directive"><a href="./mod/mpm_common.html#pidfile">PidFile</a></code>. Cet identifiant
      permet  l'administrateur de redmarrer et arrter le dmon en
      envoyant des signaux au processus parent ; sous Windows, vous devez
      utiliser l'option de ligne de commande -k. Pour plus de dtails,
      consulter la page <a href="stopping.html">Arrt et redmarrage</a>.</p>
    

    <h3><a name="scriptlog" id="scriptlog">Journal des scripts</a></h3>
      

      <p>Afin de faciliter le dbogage, la directive
      <code class="directive"><a href="./mod/mod_cgi.html#scriptlog">ScriptLog</a></code> vous permet
      d'enregistrer les entres et sorties des scripts CGI. Elle ne doit tre
      utilise que pendant la phase de test, et en aucun cas sur un
      serveur en production. Vous trouverez plus d'informations dans la
      documentation du module <a href="mod/mod_cgi.html">mod_cgi</a>.</p>
    

    <h3><a name="rewritelog" id="rewritelog">Journal de rcriture</a></h3>
      

      <p>Lorsqu'on utilise les fonctionnalits puissantes et complexes du
      module <a href="mod/mod_rewrite.html">mod_rewrite</a>, il est presque
      toujours ncessaire d'utiliser la directive
      <code class="directive"><a href="./mod/mod_rewrite.html#rewritelog">RewriteLog</a></code> afin de
      faciliter le dbogage. Ce fichier journal fournit une analyse dtaille
      de la transformation des requtes par le moteur de rcriture. Le niveau
      de dtail est contrl par la directive
      <code class="directive"><a href="./mod/mod_rewrite.html#rewriteloglevel">RewriteLogLevel</a></code>.</p>
    
  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/logs.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/logs.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/logs.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/logs.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/logs.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2009 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div>
</body></html>