<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Tutoriel Apache : Introduction aux "Inclusions Ct Serveur"
(Server Side Includes - SSI) - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Recettes et tutoriels</a></div><div id="page-content"><div id="preamble"><h1>Tutoriel Apache : Introduction aux "Inclusions Ct Serveur"
(Server Side Includes - SSI)</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/howto/ssi.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/howto/ssi.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/howto/ssi.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/howto/ssi.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>

<p>Les SSI permettent d'ajouter du contenu dynamique  des documents
HTML prexistants.</p>
</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#related">Introduction</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#what">Qu'est-ce que SSI ?</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#configuring">Configurer votre serveur pour permettre les SSI</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#basic">Directives SSI de base</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#additionalexamples">Exemples additionnels</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#config">Que puis-je configurer d'autre ?</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#exec">Excution de commandes</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#advanced">Techniques SSI avances</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#conclusion">Conclusion</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="related" id="related">Introduction</a></h2>
 <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="../mod/mod_include.html">mod_include</a></code></li><li><code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code></li><li><code class="module"><a href="../mod/mod_expires.html">mod_expires</a></code></li></ul></td><td><ul><li><code class="directive"><a href="../mod/core.html#options">Options</a></code></li><li><code class="directive"><a href="../mod/mod_include.html#xbithack">XBitHack</a></code></li><li><code class="directive"><a href="../mod/mod_mime.html#addtype">AddType</a></code></li><li><code class="directive"><a href="../mod/core.html#setoutputfilter">SetOutputFilter</a></code></li><li><code class="directive"><a href="../mod/mod_setenvif.html#browsermatchnocase">BrowserMatchNoCase</a></code></li></ul></td></tr></table>

    <p>Cet article traite des Inclusions Ct Serveur (Server Side
    Includes), plus communment appels SSI. Vous trouverez ici la
    manire de configurer votre serveur pour permettre les SSI, ainsi
    qu'une introduction  quelques techniques SSI de base permettant
    d'ajouter du contenu dynamique  vos pages HTML prexistantes.</p>

    <p>La dernire partie de cet article sera consacre aux
    configurations SSI plus avances, telles que les expressions
    conditionnelles dans les directives SSI.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="what" id="what">Qu'est-ce que SSI ?</a></h2>

    <p>SSI (Server Side Includes) est constitu de directives places dans
    des pages HTML, et values par le serveur au moment o les pages
    sont servies. Elles vous permettent d'ajouter du contenu gnr
    dynamiquement  une page HTML prexistante, sans avoir  servir la
    page entire via un programme CGI, ou toute autre technologie de
    contenu dynamique.</p>

    <p>Le choix entre l'utilisation des SSI et la gnration entire de
    la page par un programme quelconque, est en gnral dict par la
    proportion de contenu statique et de contenu devant tre gnr
    chaque fois que la page est servie. SSI est idal pour ajouter de
    petites quantits d'information, comme l'heure courante. Mais si la
    plus grande partie de votre page est gnre au moment o elle est
    servie, vous devez vous tourner vers une autre solution.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="configuring" id="configuring">Configurer votre serveur pour permettre les SSI</a></h2>


    <p>Pour permettre l'utilisation des SSI sur votre serveur, vous
    devez ajouter la directive suivante dans votre fichier
    <code>httpd.conf</code>, ou dans un fichier <code>.htaccess</code>
    :</p>
<div class="example"><p><code>
        Options +Includes
</code></p></div>

    <p>Cette directive indique  Apache que vous dsirez permettre la
    recherche de directives SSI lors de l'interprtation des fichiers.
    Notez cependant que la plupart des configurations contiennent de
    nombreuses directives <code class="directive"><a href="../mod/core.html#options">Options</a></code>
    qui peuvent s'craser les unes les autres. Vous devrez probablement
    appliquer ces directives <code>Options</code> au rpertoire
    spcifique pour lequel vous voulez activer les SSI, afin d'tre sr
    qu'elles y seront bien actives.</p>

    <p>Tout fichier ne fera cependant pas l'objet de recherche de
    directives SSI. Vous devez indiquer  Apache quels fichiers seront
    concerns. Vous pouvez y parvenir en indiquant une extension, comme
    <code>.shtml</code>,  l'aide des directives suivantes :</p>
<div class="example"><p><code>
        AddType text/html .shtml<br />
        AddOutputFilter INCLUDES .shtml
</code></p></div>

    <p>Un des dsavantages de cette approche rside dans le fait que si
    vous voulez ajouter des directives SSI  une page prexistante, vous
    devrez changer le nom de cette page, et donc tout lien qui la
    contient, de faon  ce qu'elle possde l'extension
    <code>.shtml</code>, condition ncessaire pour que les directives
    SSI qu'elle contient soient traites.</p>

    <p>Une autre mthode consiste  utiliser la directive <code class="directive"><a href="../mod/mod_include.html#xbithack">XBitHack</a></code> :</p>
<div class="example"><p><code>
        XBitHack on
</code></p></div>

    <p>La directive <code class="directive"><a href="../mod/mod_include.html#xbithack">XBitHack</a></code>
    indique  Apache qu'il doit rechercher des directivves SSI dans les
    fichiers si leur bit d'excution est positionn. Il n'est ainsi plus
    ncessaire de changer le nom du fichier pour ajouter des directives
    SSI  une page prexistante ; vous devez simplement attribuer les
    droits d'excution au fichier  l'aide de <code>chmod</code>.</p>
<div class="example"><p><code>
        chmod +x pagename.html
</code></p></div>

    <p>Un bref commentaire sur ce qu'il ne faut pas faire. Certaines
    personnes peuvent vous conseiller de tout simplement indiquer 
    Apache de rechercher des directives SSI dans tous les fichiers
    <code>.html</code>, ce qui vous vite d'avoir  grer les noms de
    fichiers avec extension <code>.shtml</code>. Ils n'ont probablement
    pas entendu parler de la directive <code class="directive"><a href="../mod/mod_include.html#xbithack">XBitHack</a></code>. En effet, vous devez
    garder  l'esprit qu'en faisant ceci, Apache va devoir rechercher
    des directives SSI dans chaque fichier qu'il sert, mme s'il n'en
    contient aucune. Ce n'est donc pas une bonne ide car les
    performances peuvent en tre sensiblement affectes.</p>

    <p>Bien entendu, sous Windows, il n'y a pas de bit d'excution 
    positionner, ce qui limite un peu vos choix.</p>

    <p>Dans sa configuration par dfaut, Apache n'envoie pas la date de
    dernire modification ou les en-ttes HTTP relatifs  la taille des
    contenus dans les pages SSI, car ses valeurs sont difficiles 
    calculer pour les contenus dynamiques. Ceci peut induire une
    impression de diminution des performances ct client, en empchant
    la mise en cache de votre document. Il existe deux mthodes pour
    rsoudre ce problme :</p>

    <ol>
      <li>Utilisez la configuration <code>XBitHack Full</code>. Elle
      indique  Apache de dterminer la date de dernire modification en
      ne regardant que la date du fichier  l'origine de la requte,
      tout en ignorant la date de modification de tout fichier inclus.</li>

      <li>Utilisez les directives fournies par le module
      <code class="module"><a href="../mod/mod_expires.html">mod_expires</a></code> pour dfinir de manire explicite la
      date d'expiration de vos fichiers, laissant par la-mme
      aux navigateurs et aux mandataires le soin de dterminer s'il est
      opportun ou non de les mettre en cache.</li>
    </ol>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="basic" id="basic">Directives SSI de base</a></h2>

    <p>Les directives SSI adoptent la syntaxe suivante :</p>
<div class="example"><p><code>
        &lt;!--#lment attribut=valeur attribut=valeur ... --&gt;
</code></p></div>

    <p>Le format d'une directive SSI tant similaire  celui d'un
    commentaire HTML, si vous n'avez pas activ correctement SSI, le
    navigateur l'ignorera, mais elle sera encore visible dans le source
    HTML. Si SSI est correctement configur, la directive sera remplace
    par ses rsultats.</p>

    <p>"lment" peut prendre de nombreuses formes, et nous dcrirons
    plus prcisment la plupart d'entre eux dans la prochaine version de
    ce document. Pour le moment, voici quelques exemples de ce que vous
    pouvez faire avec SSI.</p>

<h3><a name="todaysdate" id="todaysdate">La date courante</a></h3>

<div class="example"><p><code>
        &lt;!--#echo var="DATE_LOCAL" --&gt;
</code></p></div>

    <p>L'lment <code>echo</code> permet d'afficher la valeur d'une
    variable. Il existe un grand nombre de variables standards, y
    compris l'ensemble des variables d'environnement disponibles pour
    les programmes CGI. De plus, vous pouvez dfinir vos propres
    variables  l'aide de l'lment <code>set</code>.</p>

    <p>Si vous n'aimez pas le format sous lequel la date s'affiche, vous
    pouvez utiliser l'lment <code>config</code> avec un attribut
    <code>timefmt</code>, pour le modifier.</p>

<div class="example"><p><code>
        &lt;!--#config timefmt="%A %B %d, %Y" --&gt;<br />
        Today is &lt;!--#echo var="DATE_LOCAL" --&gt;
</code></p></div>


<h3><a name="lastmodified" id="lastmodified">Date de modification du fichier</a></h3>

<div class="example"><p><code>
        Dernire modification du document &lt;!--#flastmod file="index.html" --&gt;
</code></p></div>

    <p>Le format peut l aussi tre modifi  l'aide de l'attribut
    <code>timefmt</code>.</p>


<h3><a name="cgi" id="cgi">Inclusion des rsultats d'un programme CGI</a></h3>

    <p>C'est le cas le plus courant d'utilisation des SSI - afficher les
    rsultats d'un programme CGI, comme l'universellement ador
    "compteur d'accs".</p>

<div class="example"><p><code>
        &lt;!--#include virtual="/cgi-bin/counter.pl" --&gt;
</code></p></div>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="additionalexamples" id="additionalexamples">Exemples additionnels</a></h2>


    <p>Vous trouverez dans ce qui suit quelques exemples spcifiques de
    ce que vous pouvez faire de vos documents HTML avec SSI.</p>

<h3><a name="docmodified" id="docmodified">Quand ce document a-t-il t modifi ?</a></h3>

    <p>Nous avons mentionn plus haut que vous pouviez utiliser SSI pour
    informer l'utilisateur de la date de dernire modification du
    document. Cependant, la mthode pour y parvenir n'a pas t vraiment
    aborde. Plac dans votre document HTML, le code suivant va insrer
    un repre de temps dans votre page. Bien entendu, SSI devra avoir
    t correctement activ, comme dcrit plus haut.</p>
<div class="example"><p><code>
        &lt;!--#config timefmt="%A %B %d, %Y" --&gt;<br />
        Dernire modification du fichier &lt;!--#flastmod file="ssi.shtml" --&gt;
</code></p></div>

    <p>Bien entendu, vous devez remplacer <code>ssi.shtml</code> par le
    nom du fichier auquel vous faites rfrence. Ceci ne conviendra pas
    si vous recherchez un morceau de code gnrique que vous pourrez
    insrer dans tout fichier ; dans ce cas, il est prfrable
    d'utiliser la variable <code>LAST_MODIFIED</code> :</p>
<div class="example"><p><code>
        &lt;!--#config timefmt="%D" --&gt;<br />
        This file last modified &lt;!--#echo var="LAST_MODIFIED" --&gt;
</code></p></div>

    <p>Pour plus de dtails sur le format <code>timefmt</code>, tapez
    <code>strftime</code> dans votre moteur de recherche prfer. La
    syntaxe est identique.</p>


<h3><a name="standard-footer" id="standard-footer">Inclusion d'un pied de page standard</a></h3>


    <p>Si le site que vous grez comporte plus que quelques pages, vous
    allez vite vous apercevoir qu'effectuer des modifications sur toutes
    ces pages peut devenir trs contraignant, en particulier si vous
    voulez qu'elles conservent un aspect homogne.</p>

    <p>Inclure un fichier pour un en-tte et/ou un pied de page peut
    simplifier cette corve de mises  jour. Il vous suffit de
    confectionner un fichier de pied de page, et de l'inclure dans
    chaque page  l'aide de l'lment SSI <code>include</code>. Pour
    dfinir le fichier  inclure, l'lment <code>include</code> peut
    utiliser soit l'attribut <code>file</code>, soit l'attribut
    <code>virtual</code>. L'attribut <code>file</code> est un chemin de
    fichier <em>relatif au rpertoire courant</em>. C'est  dire qu'il
    ne peut ni avoir pour valeur un chemin absolu (commenant par /), ni
    comporter "../" dans son chemin. L'attribut <code>virtual</code> est
    probablement plus commode, et peut spcifier une URL relative au
    document servi. Elle peut commencer par un /, mais le fichier inclus
    et le fichier servi doivent rsider sur le mme serveur.</p>
<div class="example"><p><code>
        &lt;!--#include virtual="/footer.html" --&gt;
</code></p></div>

    <p>Je combinerai souvent ces deux derniers points, en ajoutant une
    directive <code>LAST_MODIFIED</code> dans un fichier de pied de page
    destin  tre inclus. Le fichier inclus peut contenir des
    directives SSI, et les inclusions peuvent tre imbriques - 
    savoir, le fichier inclus peut inclure un autre fichier, etc...</p>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="config" id="config">Que puis-je configurer d'autre ?</a></h2>


    <p>En plus du format de date, vous pouvez utiliser l'lment
    <code>config</code> pour configurer deux autres choses.</p>

    <p>En gnral, lorsque quelque chose se passe mal avec votre
    directive SSI, vous recevez le message :</p>
<div class="example"><p><code>
        [an error occurred while processing this directive]
</code></p></div>

    <p>Pour modifier ce message, vous pouvez utiliser l'attribut
    <code>errmsg</code> avec l'lment <code>config</code> :</p>
<div class="example"><p><code>
        &lt;!--#config errmsg="[Il semblerait que vous ne sachiez pas
	utiliser les SSI]" --&gt;
</code></p></div>

    <p>Il est cependant probable que les utilisateurs finaux ne voient
    jamais ce message, car vous aurez rsolu tous les problmes issus de
    vos directives SSI avant que votre site ne soit mis en production.
    (N'est-ce pas ?)</p>

    <p>Vous pouvez aussi modifier le format sous lequel les tailles de
    fichiers sont affiches  l'aide de l'attribut <code>sizefmt</code>.
    Vous pouvez spcifier <code>bytes</code> pour un affichage en
    octets, ou <code>abbrev</code> pour un affichage plus concis en Ko
    ou Mo, selon le cas.</p>
    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="exec" id="exec">Excution de commandes</a></h2>
    

    <p>J'ai pour projet, dans les prochains mois, d'crire un article 
    propos de l'utilisation des SSI avec des petits programmes CGI. Pour
    l'instant, voici ce que vous pouvez faire avec l'lment
    <code>exec</code>. Vous pouvez vraiment faire excuter une commande
    par SSI en utilisant le shell (<code>/bin/sh</code>, pour tre plus
    prcis - ou le shell DOS, si vous tes sous Win32). Par exemple, ce
    qui suit vous permet d'afficher le contenu d'un rpertoire.</p>
<div class="example"><p><code>
        &lt;pre&gt;<br />
        &lt;!--#exec cmd="ls" --&gt;<br />
        &lt;/pre&gt;
</code></p></div>

    <p>ou, sous Windows</p>
<div class="example"><p><code>
        &lt;pre&gt;<br />
        &lt;!--#exec cmd="dir" --&gt;<br />
        &lt;/pre&gt;
</code></p></div>

    <p>Vous noterez probablement l'trange formatage provoqu par cette
    directive sous Windows, car la sortie de <code>dir</code> contient
    la chane  de caractres "&lt;<code>dir</code>&gt;", ce qui trompe le
    navigateur.</p>

    <p>Notez que cette fonctionnalit est trs dangereuse, car elle va
    permettre d'excuter tout code associ  l'lment
    <code>exec</code>. Si vous tes dans la situation o les
    utilisateurs peuvent diter le contenu de vos pages web, dans le cas
    d'un "livre d'or" par exemple, assurez-vous de dsactiver cette
    fonctionnalit. Vous pouvez, tout en permettant les SSI, dsactiver
    la fonctionnalit <code>exec</code>  l'aide de l'argument
    <code>IncludesNOEXEC</code> de la directive
    <code>Options</code>.</p>
    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="advanced" id="advanced">Techniques SSI avances</a></h2>


    <p>Outre l'affichage de contenu, les SSI d'Apache vous permettent de
    dfinir des variables, et de les utiliser dans des comparaisons et
    des conditions.</p>

<h3><a name="caveat" id="caveat">Mise en garde</a></h3>

    <p>La plupart des fonctionnalits dcrites dans cet article ne sont
    disponibles que si vous utilisez la version 1.2 ou suprieure
    d'Apache. Bien entendu, si ce n'est pas le cas, vous devez faire une
    mise  jour immdiatement, et mme plus tt. Allez-y. Faites-le
    maintenant. Nous attendrons.</p>


<h3><a name="variables" id="variables">Dfinition de variables</a></h3>

    <p>Avec l'lment <code>set</code>, vous pouvez dfinir des
    variables pour un usage ultrieur. Comme nous en aurons besoin plus
    loin, nous allons en parler tout de suite. La syntaxe se prsente
    comme suit :</p>
<div class="example"><p><code>
        &lt;!--#set var="name" value="Rich" --&gt;
</code></p></div>

    <p>Pour affecter une valeur  vos variables, en plus de la
    dfinition littrale de l'exemple ci-dessus, vous pouvez utiliser
    une autre variable, y compris les <a href="../env.html">variables d'environnement</a>, ou les variables
    dcrites plus haut (comme <code>LAST_MODIFIED</code> par exemple).
    Pour indiquer qu'il s'agit d'une variable et non d'une chane, vous
    devez utiliser le symbole dollar ($) devant le nom de la
    variable.</p>

    <div class="example"><p><code> &lt;!--#set var="modified" value="$LAST_MODIFIED" --&gt;
    </code></p></div>

    <p>Pour insrer un caractre $ dans la valeur de votre variable,
    vous devez l'chapper  l'aide d'un backslash.</p>
<div class="example"><p><code>
        &lt;!--#set var="cost" value="\$100" --&gt;
</code></p></div>

    <p>Enfin, si vous voulez insrer une variable dans une chane, et
    s'il y a une chance pour que le nom de la variable se confonde avec
    le reste de la chane, vous pouvez l'entourer d'accolades pour
    eviter toute confusion (Il est difficile de trouver un bon exemple
    pour illustrer ceci, mais j'espre que vous comprendrez).</p>
<div class="example"><p><code>
        &lt;!--#set var="date" value="${DATE_LOCAL}_${DATE_GMT}" --&gt;
</code></p></div>


<h3><a name="conditional" id="conditional">Expressions conditionnelles</a></h3>


    <p>Maintenent que nous avons des variables, et que nous pouvons
    dfinir et comparer leurs valeurs, nous sommes  mme de les
    utiliser dans des expressions conditionnelles. Ceci confre  SSI le
    statut de petit langage de programmation.
    <code class="module"><a href="../mod/mod_include.html">mod_include</a></code> fournit une structure <code>if</code>,
    <code>elif</code>, <code>else</code>, <code>endif</code> pour la
    construction d'expressions conditionnelles, ce qui vous permet de
    gnrer plusieurs pages logiques  partir d'une seule vraie
    page.</p>

    <p>La structure de l'expression conditionnelle est :</p>
<div class="example"><p><code>
    &lt;!--#if expr="condition" --&gt;<br />
    &lt;!--#elif expr="condition" --&gt;<br />
    &lt;!--#else --&gt;<br />
    &lt;!--#endif --&gt;
</code></p></div>

    <p>Une <em>condition</em> peut revtir la forme de toute comparaison
    logique - soit une comparaison de valeurs avec une autre, soit une
    vrification de la "vrit" d'une valeur particulire (Une chane
    donne est vraie si elle n'est pas vide). Pour une liste exhaustive
    des oprateurs de comparaison disponibles, voir la documentation du
    module <code class="module"><a href="../mod/mod_include.html">mod_include</a></code>. Voici quelques exemples
    illustrant l'utilisation de ces expressions.</p>

    <p>Vous pouvez ajouter les lignes suivantes dans votre fichier de
    configuration :</p>
<div class="example"><p><code>
        BrowserMatchNoCase macintosh Mac<br />
        BrowserMatchNoCase MSIE InternetExplorer
</code></p></div>

    <p>Ces lignes dfinissent les variables d'environnement "Mac" et
    "InternetExplorer"  true, si le client utilise InternetExplorer sur
    un Macintosh.</p>

    <p>Puis, dans votre document o les SSI sont actives, vous ajoutez
    ceci :</p>
<div class="example"><p><code>
        &lt;!--#if expr="${Mac} &amp;&amp; ${InternetExplorer}" --&gt;<br />
        Un texte d'excuses est insr ici<br />
        &lt;!--#else --&gt;<br />
        Ici se trouve du code JavaScipt sympa<br />
        &lt;!--#endif --&gt;
</code></p></div>

    <p>Notez que je n'ai rien contre IE sur Macintosh - J'ai juste
    phosphor quelques heures la semaine dernire pour faire fonctionner
    du JavaScript sous IE sur Macintosh, alors qu'il fonctionnait sous
    tout autre environnement. Ce qui prcde a constitu un
    contournement provisoire.</p>

    <p>Toute autre variable (que vous avez dfinie, ou une variable
    d'environnement normale) peut tre utilise dans les expressions
    conditionnelles. Associe  la possibilit avec Apache de dfinir
    des variables d'environnement  l'aide de directives
    <code>SetEnvIf</code>, ainsi que d'autres directives en rapport,
    cette fonctionnalit vous permet d'ajouter des contenus dynamiques
    assez volus sans avoir recours aux programmes CGI.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="conclusion" id="conclusion">Conclusion</a></h2>

    <p>SSI ne remplace certainement pas CGI, ou d'autres technologies
    utilises pour la gnration de pages web dynamiques. Mais c'est une
    bonne mthode pour ajouter des petits contenus dynamiques  vos
    pages, sans devoir fournir un gros effort supplmentaire.</p>
</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/howto/ssi.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/howto/ssi.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/howto/ssi.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/howto/ssi.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2009 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>