<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_alias - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_alias</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_alias.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_alias.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_alias.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_alias.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/mod/mod_alias.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Permet d'atteindre diffrentes parties du systme de
fichiers depuis l'arborescence des documents du site web, ainsi que la
redirection d'URL</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>alias_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_alias.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Les directives fournies par ce module permettent de manipuler et
    de contrler les URLs  l'arrive des requtes sur le serveur. Les
    directives <code class="directive"><a href="#alias">Alias</a></code> et
    <code class="directive"><a href="#scriptalias">ScriptAlias</a></code> permettent de
    faire correspondre des URLs avec des chemins du systme de fichiers.
    Ceci permet de servir des contenus qui ne sont pas situs dans
    l'arborescence de <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code> comme s'ils y taient
    rellement. La directive <code class="directive"><a href="#scriptalias">ScriptAlias</a></code> a pour effet
    supplmentaire de marquer le rpertoire cible comme conteneur de
    scripts CGI.</p>

    <p>Les directives <code class="directive"><a href="#redirect">Redirect</a></code>
    indiquent aux clients qu'ils doivent effectuer une nouvelle requte
    avec une URL diffrente. Elles sont souvent utilises lorsqu'une
    ressource a t dplace.</p>

    <p><code class="module"><a href="../mod/mod_alias.html">mod_alias</a></code> est conu pour traiter des tches
    simples de manipulation d'URL. Pour des tches plus complexes comme
    la manipulation des chanes d'arguments des requtes, utilisez
    plutt les outils fournis par le module <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code></p>

</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#alias">Alias</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#aliasmatch">AliasMatch</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#redirect">Redirect</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#redirectmatch">RedirectMatch</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#redirectpermanent">RedirectPermanent</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#redirecttemp">RedirectTemp</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#scriptalias">ScriptAlias</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#scriptaliasmatch">ScriptAliasMatch</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#order">Chronologie du traitement</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code></li>
<li><a href="../urlmapping.html">Mise en correspondance des URLs avec le
systme de fichiers</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="order" id="order">Chronologie du traitement</a></h2>

    <p>Les alias et redirections apparaissant dans diffrents contextes
    sont traits comme les autres directives en respectant les <a href="../sections.html#mergin">rgles de fusion</a> standards. Par
    contre, ils sont traits selon une chronologie particulire
    lorsqu'ils apparaissent dans le mme contexte (par exemple, dans la
    mme section <code class="directive"><a href="../mod/core.html#virtualhost">&lt;VirtualHost&gt;</a></code>).</p>

    <p>Premirement, toutes les redirections sont traites avant les
    alias, et ainsi, une requte qui correspond  une directive
    <code class="directive"><a href="#redirect">Redirect</a></code> ou <code class="directive"><a href="#redirectmatch">RedirectMatch</a></code> ne se verra jamais
    appliquer d'alias. Deuximement, les alias et redirections sont
    traits selon l'ordre dans lequel ils apparaissent dans le fichier
    de configuration, seule la premire correspondance tant prise en
    compte.</p>

    <p>Ainsi, lorsqu'une ou plusieurs de ces directives s'appliquent au
    mme sous-rpertoire, vous devez classer les chemins du plus prcis
    au moins prcis afin que toutes les directives puissent
    ventuellement s'appliquer, comme dans l'exemple suivant :</p>

    <div class="example"><p><code>
    Alias /foo/bar /baz<br />
    Alias /foo /gaq
    </code></p></div>

    <p>Si l'ordre des directives tait invers, la directive <code class="directive"><a href="#alias">Alias</a></code> ayant pour argument
    <code>/foo</code> serait toujours applique avant la directive
    <code class="directive"><a href="#alias">Alias</a></code> ayant pour argument
    <code>/foo/bar</code>, et cette dernire serait toujours
    ignore.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="Alias" id="Alias">Alias</a> <a name="alias" id="alias">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Met en correspondance des URLs avec des chemins du systme
de fichiers</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Alias <var>chemin URL</var>
<var>chemin fichier</var>|<var>chemin rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_alias</td></tr>
</table>

    <p>La directive <code class="directive">Alias</code> permet de stocker des
    documents (destins  tre servis) dans des zones du systme de
    fichiers situes en dehors de l'arborescence du site web <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code>. Les URLs dont le chemin
    (dcod avec caractres %) commence par <var>chemin URL</var> seront
    mises en correspondance avec des fichiers locaux dont le chemin
    commence par <var>chemin rpertoire</var>. Le <var>chemin URL</var>
    est sensible  la casse, mme sur les systmes de fichiers
    insensibles  la casse.</p>

    <div class="example"><h3>Exemple :</h3><p><code>
      Alias /image /ftp/pub/image
    </code></p></div>

    <p>Une requte pour <code>http://myserver/image/foo.gif</code> fera
    renvoyer par le serveur le fichier
    <code>/ftp/pub/image/foo.gif</code>. Seuls les lments de chemin
    complets sont tests ; ainsi l'alias prcdent ne conviendra pas
    pour une requte du style <code>http://myserver/imagefoo.gif</code>.
    Pour des mises en correspondance plus complexes faisant intervenir
    les expressions rationnelles, veuillez vous reporter  la directive
    <code class="directive"><a href="#aliasmatch">AliasMatch</a></code>.</p>

    <p>Notez que si vous ajoutez un slash de fin au <var>chemin
    URL</var>, vous devrez aussi ajouter un slash de fin au chemin de la
    requte. Autrement dit, si vous dfinissez</p>

    <dl><dd><code>Alias /icons/ /usr/local/apache/icons/</code></dd></dl>

    <p>l'alias prcdent ne s'appliquera pas  l'url
    <code>/icons</code>.</p>

    <p>Notez qu'il pourra s'avrer ncessaire de dfinir des sections
    <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>
    supplmentaires qui couvriront la  <em>destination</em> des alias.
    Le traitement des alias intervenant avant le traitement des sections
    <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>,
    seules les cibles des alias sont affectes (Notez cependant
    que les sections <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code> sont traites avant les alias, et
    s'appliqueront donc).</p>

    <p>En particulier, si vous crez un alias ayant pour cible un
    rpertoire situ en dehors de l'arborescence de votre site web
    <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code>, vous devrez
    probablement permettre explicitement l'accs  ce rpertoire.</p>

    <div class="example"><h3>Exemple :</h3><p><code>
        Alias /image /ftp/pub/image<br />
        &lt;Directory /ftp/pub/image&gt;<br />
        <span class="indent">
            Order allow,deny<br />
            Allow from all<br />
        </span>
        &lt;/Directory&gt;
    </code></p></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AliasMatch" id="AliasMatch">AliasMatch</a> <a name="aliasmatch" id="aliasmatch">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Met en correspondance des URLs avec le systme de fichiers
en faisant intervenir les expressions rationnelles</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AliasMatch <var>regex</var>
<var>chemin fichier</var>|<var>chemin rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_alias</td></tr>
</table>
    <p>Cette directive est identique  la directive <code class="directive"><a href="#alias">Alias</a></code>, mais fait appel aux <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expressions rationnelles</a>,  la place d'une
    simple mise en correspondance de prfixe. L'expression rationnelle
    fournie est mise en correspondance avec le chemin URL, et si elle
    correspond, le serveur va substituer toute partie de chemin
    correspondant  l'expression entre parenthses dans la chane
    fournie et l'utiliser comme nom de fichier.
    Par exemple, pour activer le rpertoire <code>/icons</code>, on peut
    utiliser :</p>

    <div class="example"><p><code>
      AliasMatch ^/icons(.*) /usr/local/apache/icons$1
    </code></p></div>

    <p>On peut aussi construire un alias qui met en correspondance le
    chemin URL sans tenir compte de la casse :</p>

    <div class="example"><p><code>
      AliasMatch (?i)^/image(.*) /ftp/pub/image$1
    </code></p></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="Redirect" id="Redirect">Redirect</a> <a name="redirect" id="redirect">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Envoie une redirection externe demandant au client
d'effectuer une autre requte avec une URL diffrente</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Redirect [<var>statut</var>] <var>chemin URL</var>
<var>URL</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_alias</td></tr>
</table>
    <p>La directive Redirect permet de faire correspondre une ancienne
    URL  une nouvelle en demandant au client d'aller chercher la ressource 
    une autre localisation.</p>

    <p>L'ancien <em>chemin URL</em> est un chemin sensible  la casse
    (dcod  l'aide de caractres %) commenant par un slash. Les
    chemins relatifs ne sont pas autoriss.</p>

    <p>La nouvelle <em>URL</em>
    peut tre une URL absolue commenant par un protocole et un nom
    d'hte, mais on peut aussi utiliser un chemin URL commenant par un
    slash, auquel cas le protocole et le nom d'hte du serveur local
    seront ajouts.</p>

    <p>Ensuite, toute requte commenant par <em>chemin URL</em> va
    renvoyer une redirection au client vers l'<em>URL</em> cible. Tout
    lment de chemin supplmentaire situ en aval du <em>chemin
    URL</em> sera ajout  l'URL cible.</p>

    <div class="example"><h3>Exemple :</h3><p><code>
      # Redirige vers une URL sur un serveur diffrent<br />
      Redirect /service http://foo2.exemple.com/service<br />
      <br />
      # Redirige vers une URL sur le mme serveur<br />
      Redirect /one /two
    </code></p></div>

    <p>Si le client effectue une requte pour l'URL
    <code>http://example.com/service/foo.txt</code>, il lui sera demand
    d'en effectuer une autre pour l'URL
    <code>http://foo2.example.com/service/foo.txt</code>. Seuls les
    lments de chemin complets sont tests, si bien que l'exemple
    prcdent ne s'appliquera pas  l'URL
    <code>http://example.com/servicefoo.txt</code>. Pour des mises en
    correspondance plus complexes faisant intervenir les expressions
    rationnelles, veuillez vous reporter  la directive <code class="directive"><a href="#redirectmatch">RedirectMatch</a></code>.</p>


    <div class="note"><h3>Note</h3>
    <p>Les directives de redirection ont priorit sur les directives
    Alias et ScriptAlias, quel que soit leur ordre d'apparition dans le
    fichier de configuration.</p></div>

    <p>Si aucun argument <var>statut</var> n'est spcifi, la
    redirection sera temporaire (statut HTTP 302). Le client est alors
    inform que la ressource a t temporairement dplace. On peut
    utiliser l'argument <var>statut</var> pour renvoyer d'autres codes
    de statut HTTP :</p>

    <dl>
      <dt>permanent</dt>

      <dd>Renvoie un statut de redirection permanente (301), indiquant
      que la ressource a t dfinitivement dplace.</dd>

      <dt>temp</dt>

      <dd>Renvoie un statut de redirection temporaire (302). C'est le
      comportement par dfaut.</dd>

      <dt>seeother</dt>

      <dd>Renvoie un statut "See Other" (303) indiquant que la ressource
      a t remplace par une autre.</dd>

      <dt>gone</dt>

      <dd>Renvoie un statut "Gone" (410) indiquant que la ressource a
      t dfinitivement supprime. Lorsque ce statut est dfini, on ne
      doit pas utiliser l'argument <var>URL</var>.</dd>
    </dl>

    <p>On peut renvoyer d'autres codes de statut en spcifiant le code
    de statut numrique comme valeur de l'argument of <var>statut</var>.
    Si le code de statut est compris entre 300 et 399, l'argument
    <var>URL</var> doit tre prsent, sinon il ne doit pas tre utilis.
    Notez que le statut doit tre connu du code d'Apache (voir la
    fonction <code>send_error_response</code> dans
    http_protocol.c).</p>

    <div class="example"><h3>Exemple :</h3><p><code>
      Redirect permanent /un http://exemple.com/deux<br />
      Redirect 303 /trois http://exemple.com/autre
    </code></p></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RedirectMatch" id="RedirectMatch">RedirectMatch</a> <a name="redirectmatch" id="redirectmatch">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Envoie une redirection externe faisant appel aux
expressions rationnelles pour la mise en correspondance de l'URL
courante</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RedirectMatch [<var>statut</var>] <var>regex</var>
<var>URL</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_alias</td></tr>
</table>
    <p>Cette directive est identique  la directive <code class="directive"><a href="#redirect">Redirect</a></code>, mais fait appel aux
    <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expressions rationnelles</a>,  la
    place d'une simple mise en correspondance de prfixe. L'expression
    rationnelle fournie est mise en correspondance avec le chemin URL,
    et si elle correspond, le serveur va substituer toute partie de
    chemin correspondante entre parenthses dans la chane spcifie et
    l'utiliser comme nom de fichier. Par exemple, pour rediriger tous
    les fichiers GIF vers les fichiers JPEG de mme nom sur un autre
    serveur, on peut utiliser :</p>

    <div class="example"><p><code>
      RedirectMatch (.*)\.gif$ http://www.autre-serveur.com$1.jpg
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RedirectPermanent" id="RedirectPermanent">RedirectPermanent</a> <a name="redirectpermanent" id="redirectpermanent">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Envoie une redirection externe permanente demandant au
client d'effectuer une nouvelle requte avec une URL
diffrente</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RedirectPermanent <var>chemin URL</var> <var>URL</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_alias</td></tr>
</table>
    <p>Cette directive informe le client que la redirection est
    permanente (statut 301). Son comportement est exactement le mme
    que celui de <code>Redirect permanent</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RedirectTemp" id="RedirectTemp">RedirectTemp</a> <a name="redirecttemp" id="redirecttemp">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Envoie une redirection externe temporaire demandant au
client d'effectuer une nouvelle requte avec une URL
diffrente</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RedirectTemp <var>chemin URL</var> <var>URL</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_alias</td></tr>
</table>
    <p>Cette directive informe le client que la redirection n'est
    que temporaire (statut 302). Son comportement est exactement le mme
    que celui de <code>Redirect temp</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ScriptAlias" id="ScriptAlias">ScriptAlias</a> <a name="scriptalias" id="scriptalias">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fait correspondre une URL  une zone du systme de fichiers
et dsigne la cible comme script CGI</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ScriptAlias <var>chemin URL</var>
<var>chemin fichier</var>|<var>chemin rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_alias</td></tr>
</table>
    <p>La directive <code class="directive">ScriptAlias</code> prsente le mme
    comportement que la directive <code class="directive"><a href="#alias">Alias</a></code>, mais dsigne en plus le
    rpertoire cible comme conteneur de scripts CGI qui seront traites
    par le gestionnaire cgi-script du module <code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code>.
    Les URLs dont le chemin URL sensible  la casse (dcod avec
    caractres %) commence par <var>chemin URL</var> seront mises en
    correspondance avec les scripts dont le chemin commence par le
    second argument, qui est un chemin complet dans le systme de
    fichiers local.</p>

    <div class="example"><h3>Exemple :</h3><p><code>
      ScriptAlias /cgi-bin/ /web/cgi-bin/
    </code></p></div>

    <p>Une requte pour <code>http://mon-serveur/cgi-bin/foo</code>
    ferait excuter par le serveur le script
    <code>/web/cgi-bin/foo</code>. Cette configuration est sensiblement
    quivalente  :</p>
    <div class="example"><p><code>
      Alias /cgi-bin/ /web/cgi-bin/<br />
      &lt;Location /cgi-bin &gt;<br />
      <span class="indent">
      SetHandler cgi-script<br />
      Options +ExecCGI<br />
      </span>
      &lt;/Location&gt;
    </code></p></div>

	<p>Vous pouvez aussi utiliser <code class="directive">ScriptAlias</code>
	avec un script ou gestionnaire de votre cru. Par exemple :</p>

	<div class="example"><p><code>
	  ScriptAlias /cgi-bin/ /web/cgi-handler.pl
    </code></p></div>

    <p>Dans ce scnario, tous les fichiers faisant l'objet d'une requte
    dans <code>/cgi-bin/</code> seront traits par le fichier que vous
    avez spcifi, ce qui vous permet d'utiliser votre propre
    gestionnaire. Vous pouvez l'utiliser comme enveloppe (wrapper) pour
    les scripts CGI afin d'ajouter du contenu, ou autre action "maison".</p>

    <div class="warning">Il est prfrable d'viter de placer les
    scripts CGI dans l'arborescence de <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code> afin d'viter de rvler
    accidentellement leur code source lors d'une modification de
    configuration. On y parvient aisment avec
    <code class="directive">ScriptAlias</code> en mettant en correspondance une
    URL et en dsignant la cible comme scripts CGI par la mme occasion.
    Si vous choisissez de placer vos scripts CGI dans un rpertoire
    accessible depuis le web, n'utilisez pas
    <code class="directive">ScriptAlias</code>. Utilisez plutt <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>, <code class="directive"><a href="../mod/core.html#sethandler">SetHandler</a></code>, et <code class="directive"><a href="../mod/core.html#options">Options</a></code> comme dans l'exemple suivant :
    <div class="example"><p><code>
      &lt;Directory /usr/local/apache2/htdocs/cgi-bin &gt;<br />
      <span class="indent">
      SetHandler cgi-script<br />
      Options ExecCGI<br />
      </span>
      &lt;/Directory&gt;
    </code></p></div>
    Ceci est ncessaire car plusieurs <var>chemins URL</var> peuvent
    correspondre  la mme zone du systme de fichiers, court-circuitant
    ainsi la directive <code class="directive">ScriptAlias</code> et rvlant le
    code source des scripts CGI s'ils ne sont pas protgs par une
    section <code class="directive"><a href="../mod/core.html#directory">Directory</a></code>.</div>


<h3>Voir aussi</h3>
<ul>
<li><a href="../howto/cgi.html">Tutoriel CGI</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ScriptAliasMatch" id="ScriptAliasMatch">ScriptAliasMatch</a> <a name="scriptaliasmatch" id="scriptaliasmatch">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fait correspondre une URL  une zone du systme de fichiers
en faisant appel aux expressions rationnelles et en dsignant la cible
comme un script CGI</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ScriptAliasMatch <var>regex</var>
<var>chemin fichier</var>|<var>chemin rpertoire</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_alias</td></tr>
</table>
    <p>Cette directive est quivalente  la directive <code class="directive"><a href="#scriptalias">ScriptAlias</a></code>, mais fait appel aux
    <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expressions rationnelles</a>,  la
    place d'une simple mise en correspondance de prfixe. L'expression
    rationnelle fournie est mise en correspondance avec le chemin URL,
    et si elle correspond, le serveur va substituer toute partie de
    chemin entre parenthses dans la chane spcifie et l'utiliser
    comme nom de fichier. Par exemple, pour activer le rpertoire
    standard <code>/cgi-bin</code>, on peut utiliser :</p>

    <div class="example"><p><code>
      ScriptAliasMatch ^/cgi-bin(.*) /usr/local/apache/cgi-bin$1
    </code></p></div>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_alias.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_alias.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_alias.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_alias.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/mod/mod_alias.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2009 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>