<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Conseils sur la scurit - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Documentations diverses</a></div><div id="page-content"><div id="preamble"><h1>Conseils sur la scurit</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/misc/security_tips.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/misc/security_tips.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/misc/security_tips.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/misc/security_tips.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

    <p>Ce document propose quelques conseils et astuces concernant les
    problmes de scurit lis
     l'installation d'un serveur web. Certaines suggestions seront  caractre
    gnral, tandis que d'autres seront spcifiques  Apache.</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#uptodate">Maintenez votre serveur  jour</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dos">Attaques de type "Dni de service"
    (Denial of Service - DoS)</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serverroot">Permissions sur les rpertoires de la racine du serveur</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ssi">Inclusions ct serveur</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cgi">Les CGI en gnral</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#nsaliasedcgi">CGI sans alias de script</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#saliasedcgi">CGI avec alias de script</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dynamic">Autres sources de contenu dynamique</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#systemsettings">Protection de la configuration du systme</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#protectserverfiles">Protection par dfaut des fichiers du serveur</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#watchyourlogs">Surveillez vos journaux</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="uptodate" id="uptodate">Maintenez votre serveur  jour</a></h2>

    <p>Le serveur HTTP Apache a une bonne rputation en matire de scurit
    et possde une communaut de dveloppeurs trs sensibiliss aux problmes
    de scurit. Mais il est invitable de trouver certains problmes
    -- petits ou grands -- une fois le logiciel mis  disposition. C'est pour
    cette raison qu'il est crucial de se tenir inform des mises  jour. Si
    vous avez obtenu votre version du serveur HTTP directement depuis Apache,
    nous vous conseillons grandement de vous abonner  la <a href="http://httpd.apache.org/lists.html#http-announce">Liste de diffusion
    des annonces du serveur HTTP</a> qui vous informera de
    la parution des nouvelles versions et des mises  jour de scurit. La
    plupart des distributeurs tiers d'Apache fournissent des services
    similaires.</p>

    <p>Gardez cependant  l'esprit que lorsqu'un serveur web est compromis, le
    code du serveur HTTP n'est la plupart du temps pas en cause. Les problmes
    proviennent plutt de code ajout, de scripts CGI, ou du systme
    d'exploitation sous-jacent. Vous devez donc vous tenir inform des
    problmes et mises  jour concernant tous les logiciels prsents sur
    votre systme.</p>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="dos" id="dos">Attaques de type "Dni de service"
    (Denial of Service - DoS)</a></h2>

    

    <p>Tous les services rseau peuvent faire l'objet d'attaques de type
    "Dni de service" qui tentent de les empcher de rpondre aux clients en
    saturant leurs ressources. Il est impossible de se prmunir totalement
    contre ce type d'attaques, mais vous pouvez accomplir certaines actions
    afin de minimiser les problmes qu'elles crent.</p>

    <p>Souvent, l'outil anti-DoS le plus efficace sera constitu par le
    pare-feu ou certaines configurations du systme d'exploitation. Par
    exemple, la plupart des pare-feu peuvent tre configurs de faon 
    limiter le nombre de connexions simultanes depuis une adresse IP ou un
    rseau, ce qui permet de prvenir toute une gamme d'attaques simples.
    Bien sr, ceci n'est d'aucun secours contre les attaques de type
    "Dni de service" distribues (DDoS).</p>

    <p>Certains rglages de la configuration d'Apache peuvent aussi
    minimiser les problmes :</p>

    <ul>
      <li>La valeur de la directive
      <code class="directive"><a href="../mod/core.html#timeout">TimeOut</a></code> doit tre diminue sur les
      sites sujets aux attaques DoS. Une valeur de quelques secondes devrait
      convenir. Cependant, comme <code class="directive"><a href="../mod/core.html#timeout">TimeOut</a></code>
      est actuellement concern par de nombreuses oprations diffrentes, lui
      attribuer une valeur trop faible peut provoquer des problmes avec les
      scripts CGI qui prsentent un long temps de rponse.</li>

      <li>La valeur de la directive
      <code class="directive"><a href="../mod/core.html#keepalivetimeout">KeepAliveTimeout</a></code> doit aussi tre
      diminue sur les sites sujets aux attaques DoS. Certains sites
      dsactivent mme compltement le "maintien en vie" (keepalives)
       l'aide de la directive
      <code class="directive"><a href="../mod/core.html#keepalive">KeepAlive</a></code>, ce qui bien sr
      prsente des inconvnients en matire de performances.</li>

      <li>Les valeurs des diffrentes directives fournies par d'autres modules
      et en rapport avec des dlais doivent aussi tre vrifies.</li>

      <li>Les directives
      <code class="directive"><a href="../mod/core.html#limitrequestbody">LimitRequestBody</a></code>,
      <code class="directive"><a href="../mod/core.html#limitrequestfields">LimitRequestFields</a></code>,
      <code class="directive"><a href="../mod/core.html#limitrequestfieldsize">LimitRequestFieldSize</a></code>,
      <code class="directive"><a href="../mod/core.html#limitrequestline">LimitRequestLine</a></code>, et
      <code class="directive"><a href="../mod/core.html#limitxmlrequestbody">LimitXMLRequestBody</a></code> doivent tre
      configures avec prudence afin de limiter la consommation de ressources
      induite par les demandes des clients.
      </li>

      <li>Sur les systmes d'exploitation qui le supportent, assurez-vous que
      la directive <code class="directive"><a href="../mod/core.html#acceptfilter">AcceptFilter</a></code> est
      active afin de dlguer une partie du traitement des requtes au
      systme d'exploitation. Elle est active par dfaut dans le dmon httpd
      d'Apache, mais peut ncessiter une reconfiguration de votre noyau.</li>

      <li>Optimisez la directive <code class="directive"><a href="../mod/mpm_common.html#maxclients">MaxClients</a></code> de faon  dfinir le nombre
      maximum de connexions simultanes au dessus duquel les ressources
      s'puisent. Voir aussi la <a href="perf-tuning.html">documentation sur l'optimisation des
      performances</a>.</li>

      <li>L'utilisation d'un <a href="../mpm.html">module mpm</a> thread
      vous permet de traiter d'avantage de connexions simultanes, ce qui
      minimise l'effet des attaques DoS. Dans le futur, le module mpm exprimental
      <code class="module"><a href="../mod/event.html">event</a></code> utilisera un traitement asynchrone afin de ne pas
      ddier un thread  chaque connexion. Il est en cours d'tude 
      l'heure actuelle et n'est pas encore entirement implment. En
      particulier, le mpm <code class="module"><a href="../mod/event.html">event</a></code> est actuellement incompatible
      avec le module <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> ainsi que d'autres filtres
      en entre.</li>

      <li>Il existe de nombreux modules tiers disponibles  <a href="http://modules.apache.org/">http://modules.apache.org/</a> qui
      peuvent retreindre les comportements de certains clients et ainsi
      minimiser les problmes de DoS.</li>

    </ul>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="serverroot" id="serverroot">Permissions sur les rpertoires de la racine du serveur</a></h2>

    

    <p>Typiquement, Apache est dmarr par l'utilisateur root, puis il devient
    la proprit de l'utilisateur dfini par la directive <code class="directive"><a href="../mod/mpm_common.html#user">User</a></code> afin de rpondre aux demandes. Comme
    pour toutes les commandes excutes par root, vous devez vous assurer
    qu'elle n'est pas modifiable par les utilisateurs autres que root. Les
    fichiers eux-mmes, mais aussi les rpertoires ainsi que leurs parents ne
    doivent tre modifiables que par root. Par exemple, si vous avez choisi de
    placer la racine du serveur dans <code>/usr/local/apache</code>, il est conseill de
    crer le rpertoire en tant que root, avec des commandes du style :</p>

    <div class="example"><p><code>
      mkdir /usr/local/apache <br />
      cd /usr/local/apache <br />
      mkdir bin conf logs <br />
      chown 0 . bin conf logs <br />
      chgrp 0 . bin conf logs <br />
      chmod 755 . bin conf logs
    </code></p></div>

    <p>Nous supposerons que <code>/</code>, <code>/usr</code> et
    <code>/usr/local</code> ne sont modifiables que par
    root. Quand vous installez l'excutable <code class="program"><a href="../programs/httpd.html">httpd</a></code>, vous
    devez vous assurer qu'il possde des protections similaires :</p>

    <div class="example"><p><code>
      cp httpd /usr/local/apache/bin <br />
      chown 0 /usr/local/apache/bin/httpd <br />
      chgrp 0 /usr/local/apache/bin/httpd <br />
      chmod 511 /usr/local/apache/bin/httpd
    </code></p></div>

    <p>Vous pouvez crer un sous-rpertoire htdocs modifiable par d'autres
    utilisateurs -- car root ne cre ni excute aucun fichier dans ce
    sous-rpertoire.</p>

    <p>Si vous permettez  des utilisateurs non root de modifier des fichiers
    que root crit ou excute, vous exposez votre systme  une compromission
    de l'utilisateur root. Par exemple, quelqu'un pourrait remplacer le binaire
    <code class="program"><a href="../programs/httpd.html">httpd</a></code> de faon  ce que la prochaine fois que vous le
    redmarrerez, il excutera un code arbitraire. Si le rpertoire des
    journaux a les droits en criture (pour un utilisateur non root), quelqu'un
    pourrait remplacer un fichier journal par un lien symbolique vers un autre
    fichier systme, et root pourrait alors craser ce fichier avec des donnes
    arbitraires. Si les fichiers journaux eux-mmes ont des droits en
    criture (pour un utilisateur non root), quelqu'un pourrait
    modifier les journaux eux-mmes avec des donnes fausses.</p>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="ssi" id="ssi">Inclusions ct serveur</a></h2>

    

    <p>Les inclusions ct serveur (Server Side Includes - SSI) exposent
    l'administrateur du serveur  de nombreux risques potentiels en matire de
    scurit.</p>

    <p>Le premier risque est l'augmentation de la charge du serveur. Tous les
    fichiers o SSI est activ doivent tre analyss par Apache, qu'ils
    contiennent des directives SSI ou non. L'augmentation de la charge induite
    est minime, mais peut devenir significative dans le contexte d'un
    serveur partag.</p>

    <p>Les fichiers SSI prsentent les mmes risques que les scripts CGI en
    gnral. Les fichiers o SSI est activ peuvent excuter tout script CGI
    ou autre programme  l'aide de la commande <code>"exec cmd"</code> avec les permissions
    des utilisateur et groupe sous lesquels Apache s'excute, comme dfini
    dans <code>httpd.conf</code>.</p>

    <p>Des mthodes existent pour amliorer la scurit des fichiers SSI, tout
    en tirant parti des bnfices qu'ils apportent.</p>

    <p>Pour limiter les dommages qu'un fichier SSI agressif pourrait causer,
    l'administrateur du serveur peut activer<a href="../suexec.html">suexec</a>
    comme dcrit dans la section <a href="#cgi">Les CGI en gnral</a>.</p>

    <p>L'activation des SSI pour des fichiers possdant des extensions
    <code>.html</code> ou
    <code>.htm</code> peut s'avrer dangereux. Ceci est particulirement vrai dans un
    environnement de serveur partag ou tant le sige d'un traffic lev. Les
    fichiers o SSI est activ doivent possder une extension spcifique, telle
    que la conventionnelle <code>.shtml</code>. Ceci permet de limiter la charge du serveur
     un niveau minimum et de simplifier la gestion des risques.</p>

    <p>Une autre solution consiste  interdire l'excution de scripts et
    programmes  partir de pages SSI. Pour ce faire, remplacez
    <code>Includes</code> par <code>IncludesNOEXEC</code> dans la directive
    <code class="directive"><a href="../mod/core.html#options">Options</a></code>. Notez que les utilisateurs
    pourront encore utiliser <code>&lt;--#include virtual="..." --&gt;</code> pour excuter
    des scripts CGI si ces scripts sont situs dans des rpertoires spcifis
    par une directive
    <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code>.</p>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="cgi" id="cgi">Les CGI en gnral</a></h2>

    

    <p>Tout d'abord, vous devez toujours garder  l'esprit que vous devez
    faire confiance aux dveloppeurs de scripts ou programmes CGI ainsi qu'
    vos comptences pour dceler les trous de scurit potentiels dans les
    CGI, que ceux-ci soient dlibrs ou accidentels. Les scripts CGI peuvent
    essentiellement excuter des commandes arbitraires sur votre systme avec
    les droits de l'utilisateur du serveur web, et peuvent par consquent tre
    extrmement dangereux s'ils ne sont pas vrifis avec soin.</p>

    <p>Tous les scripts CGI s'excutent sous le mme utilisateur, il peuvent
    donc entrer en conflit (accidentellement ou dlibrment) avec d'autres
    scripts. Par exemple, l'utilisateur A hait l'utilisateur B, il crit donc
    un script qui efface la base de donnes CGI de l'utilisateur B. Vous pouvez
    utiliser le programme <a href="../suexec.html">suEXEC</a> pour faire en
    sorte que les scripts s'excutent sous des utilisateurs diffrents. Ce
    programme est inclus dans la distribution d'Apache depuis la version 1.2
    et est appel  partir de certaines portions de code du serveur Apache. Une
    autre mthode plus connue est l'utilisation de
    <a href="http://cgiwrap.sourceforge.net/">CGIWrap</a>.</p>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="nsaliasedcgi" id="nsaliasedcgi">CGI sans alias de script</a></h2>

    

    <p>Vous ne devez permettre aux utilisateurs d'excuter des scripts CGI
    depuis n'importe quel rpertoire que dans l'ventualit o :</p>

    <ul>
      <li>Vous faites confiance  vos utilisateurs pour ne pas crire de
      scripts qui vont dlibrment ou accidentellement exposer votre
      systme  une attaque.</li>
      <li>Vous estimez que le niveau de scurit dans les autres parties de
      votre site est si faible qu'un trou de scurit de plus ou de moins
      n'est pas trs important.</li>
      <li>Votre systme ne comporte aucun utilisateur, et personne ne visite
      jamais votre site.</li>
    </ul>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="saliasedcgi" id="saliasedcgi">CGI avec alias de script</a></h2>

    

    <p>Le confinement des CGI dans des rpertoires spcifiques permet 
    l'administrateur de contrler ce que l'on met dans ces rpertoires. Ceci
    est bien entendu mieux scuris que les CGI sans alias de script, mais
    seulement  condition que les utilisateurs avec les droits en criture sur
    les rpertoires soient dignes de confiance, et que l'administrateur ait la
    volont de tester chaque programme ou script CGI  la recherche d'ventuels
    trous de scurit.</p>

    <p>La plupart des sites choisissent cette approche au dtriment des CGI
    sans alias de script.</p>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="dynamic" id="dynamic">Autres sources de contenu dynamique</a></h2>

  

  <p>
  Les options de scripting intgres qui s'excutent en tant que partie du
  serveur lui-mme, comme <code>mod_php</code>, <code>mod_perl</code>,
  <code>mod_tcl</code>, et <code>mod_python</code>,
  s'excutent sous le mme utilisateur que le serveur (voir la directive
  <code class="directive"><a href="../mod/mpm_common.html#user">User</a></code>), et par consquent,
  les scripts que ces moteurs excutent peuvent accder aux mmes ressources
  que le serveur. Certains moteurs de scripting peuvent proposer des
  restrictions, mais pour plus de sret, il vaut mieux partir du principe
  que ce n'est pas le cas.</p>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="systemsettings" id="systemsettings">Protection de la configuration du systme</a></h2>

    

    <p>Pour contrler troitement votre serveur, vous pouvez interdire
    l'utilisation des fichiers <code>.htaccess</code> qui permettent de
    passer outre les fonctionnalits de scurit que vous avez configures.
    Voici un moyen pour y parvenir :</p>

    <p>Ajoutez dans le fichier de configuration du serveur</p>

    <div class="example"><p><code>
      &lt;Directory /&gt; <br />
        AllowOverride None <br />
      &lt;/Directory&gt;
    </code></p></div>

    <p>Ceci interdit l'utilisation des fichiers <code>.htaccess</code> dans
    tous les rpertoires, sauf ceux pour lesquels c'est explicitement
    autoris.</p>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="protectserverfiles" id="protectserverfiles">Protection par dfaut des fichiers du serveur</a></h2>

    

    <p>Le concept d'accs par dfaut est un aspect d'Apache qui est parfois mal
    compris. C'est  dire que,  moins que vous ne changiez explicitement ce
    comportement, si le serveur trouve son chemin vers un fichier en suivant
    les rgles normales de correspondance URL - fichier, il peut le retourner
    aux clients.</p>

    <p>Considrons l'exemple suivant :</p>

    <div class="example"><p><code>
      # cd /; ln -s / public_html <br />
      puis accs  <code>http://localhost/~root/</code>
    </code></p></div>

    <p>Ceci permettrait aux clients de parcourir l'ensemble du systme de
    fichiers. Pour l'viter, ajoutez le bloc suivant  la configuration
    de votre serveur :</p>

    <div class="example"><p><code>
      &lt;Directory /&gt; <br />
      Order Deny,Allow <br />
      Deny from all <br />
      &lt;/Directory&gt;
    </code></p></div>

    <p>ceci va interdire l'accs par dfaut  tous les fichiers du systme de
    fichiers. Vous devrez ensuite ajouter les blocs
    <code class="directive"><a href="../mod/core.html#directory">Directory</a></code> appropris correspondant
    aux rpertoires auxquels vous voulez autorisez l'accs. Par exemple,</p>

    <div class="example"><p><code>
      &lt;Directory /usr/users/*/public_html&gt; <br />
        Order Deny,Allow <br />
        Allow from all <br />
      &lt;/Directory&gt; <br />
      &lt;Directory /usr/local/httpd&gt; <br />
        Order Deny,Allow <br />
        Allow from all <br />
      &lt;/Directory&gt;
    </code></p></div>

    <p>Portez une attention particulire aux interactions entre les directives
    <code class="directive"><a href="../mod/core.html#location">Location</a></code> et
    <code class="directive"><a href="../mod/core.html#directory">Directory</a></code> ; par exemple, si une
    directive <code>&lt;Directory /&gt;</code> interdit un accs, une
    directive <code>&lt;Location /&gt;</code> pourra passer outre.</p>

    <p>De mme, soyez mfiant en jouant avec la directive
    <code class="directive"><a href="../mod/mod_userdir.html#userdir">UserDir</a></code> ; la positionner 
    <code>"./"</code> aurait le mme effet, pour root, que le premier exemple plus haut.
    Si vous utilisez Apache version 1.3 ou suprieure, nous vous conseillons
    fortement d'inclure la ligne suivante dans le fichier de configuration de
    votre serveur :</p>

    <div class="example"><p><code>
      UserDir disabled root
    </code></p></div>

  </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="watchyourlogs" id="watchyourlogs">Surveillez vos journaux</a></h2>

    

    <p>Pour vous tenir inform de ce qui se passe rellement dans votre
    serveur, vous devez consulter vos
    <a href="../logs.html">fichiers journaux</a>. Mme si les fichiers journaux
    ne consignent que des vnements qui se sont dj produits, ils vous
    informeront sur la nature des attaques qui sont lances contre le serveur
    et vous permettront de vrifier si le niveau de scurit ncessaire est
    atteint.</p>

    <p>Quelques exemples :</p>

    <div class="example"><p><code>
      grep -c "/jsp/source.jsp?/jsp/ /jsp/source.jsp??" access_log <br />
      grep "client denied" error_log | tail -n 10
    </code></p></div>

    <p>Le premier exemple listera les attaques essayant d'exploiter la
    <a href="http://online.securityfocus.com/bid/4876/info/">vulnrabilit
    d'Apache Tomcat pouvant provoquer la divulgation d'informations par des
    requtes Source.JSP mal formes</a>, le second donnera la liste des dix
    dernires interdictions client ; par exemple :</p>

    <div class="example"><p><code>
      [Thu Jul 11 17:18:39 2002] [error] [client foo.example.com] client denied
      by server configuration: /usr/local/apache/htdocs/.htpasswd
    </code></p></div>

    <p>Comme vous le voyez, les fichiers journaux ne consignent que ce qui
    s'est dj produit ; ainsi, si le client a pu accder au fichier
    <code>.htpasswd</code>, vous devriez avoir quelque chose du style :</p>

    <div class="example"><p><code>
      foo.example.com - - [12/Jul/2002:01:59:13 +0200] "GET /.htpasswd HTTP/1.1"
    </code></p></div>

    <p>dans votre <a href="../logs.html#accesslog">journal des accs</a> ; ce
    qui signifie que vous avez probablement mis en commentaire ce qui suit dans
    le fichier de configuration de votre serveur :</p>

    <div class="example"><p><code>
      &lt;Files ~ "^\.ht"&gt; <br />
        Order allow,deny <br />
        Deny from all <br />
      &lt;/Files&gt;
    </code></p></div>

  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/misc/security_tips.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/misc/security_tips.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/misc/security_tips.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/misc/security_tips.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2009 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>