<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_rewrite - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.3</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.3</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_rewrite</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_rewrite.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_rewrite.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Ce module fournit un moteur de rcriture  base de
rgles permettant de rcrire les URLs des requtes
 la vole</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>rewrite_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_rewrite.c</td></tr></table>
<h3>Sommaire</h3>

      <p>Le module <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> utilise un moteur de
      rcriture  base de rgles, bas sur un interprteur
      d'expressions rationnelles, pour rcrire les URLs  la vole. Par
      dfaut, <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> met en correspondance une URL
      avec le systme de fichiers. Cependant, on peut aussi l'utiliser
      pour rediriger une URL vers une autre URL, ou pour invoquer une
      requte interne  destination du mandataire.</p>
      <p><code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> fournit une mthode souple et
      puissante pour manipuler les URLs en utilisant un nombre illimit
      de rgles. Chaque rgle peut tre associe  un nombre illimit de
      conditions, afin de vous permettre de rcrire les URLs en
      fonction de variables du serveur, de variables d'environnement,
      d'en-ttes HTTP, ou de repres temporels.</p>
      <p><code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> agit sur la totalit de l'URL, y
      compris la partie chemin. Une rgle de rcriture peut tre
      invoque dans <code>httpd.conf</code> ou dans un fichier
      <code>.htaccess</code>. Le chemin gnr par une rgle de
      rcriture peut inclure une chane de paramtres, ou peut renvoyer
      vers un traitement secondaire interne, une redirection vers une
      requte externe ou vers le mandataire interne.</p>

      <p>Vous trouverez d'avantage de dtails, discussions et exemples
      dans la
      <a href="../rewrite/">documentation dtaille
      sur mod_rewrite</a>.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#rewritebase">RewriteBase</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewritecond">RewriteCond</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewriteengine">RewriteEngine</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewritemap">RewriteMap</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewriteoptions">RewriteOptions</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#rewriterule">RewriteRule</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#logging">Journalisation</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="logging" id="logging">Journalisation</a></h2>

    <p><code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> offre une journalisation dtaille
    de ses actions aux niveaux de journalisation <code>trace1</code> 
    <code>trace8</code>. Le niveau de journalisation peut tre dfini de
    manire spcifique  <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> via la directive
    <code class="directive"><a href="../mod/core.html#loglevel">LogLevel</a></code> : jusqu'au niveau
    <code>debug</code> aucune action n'est journalise, alors qu'elles
    le sont pratiquement toutes au niveau <code>trace8</code>.</p>

    <div class="note">
      L'utilisation d'un niveau de journalisation lev pour
      <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> va ralentir votre serveur HTTP Apache
      de manire dramatique ! N'utilisez un niveau de journalisation
      suprieur  <code>trace2</code> qu' des fins de dbogage !
    </div>

    <div class="example"><h3>Exemple</h3><p><code>
      LogLevel alert rewrite:trace3
    </code></p></div>

    <div class="note"><h3>RewriteLog</h3>
      <p>Ceux qui sont familiers avec les versions prcdentes de
      <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> vont probablement rechercher en vain les
      directives <code>RewriteLog</code> et
      <code>RewriteLogLevel</code>. Elles ont t en effet remplaces
      par une configuration de la journalisation par module, comme
      mentionn plus haut.
      </p>

      <p>Pour extraire les traces spcifiques 
      <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>, affichez le fichier journal en
      redirigeant la sortie vers grep :</p>
    <div class="example"><p><code>
    tail -f error_log|fgrep '[rewrite:'
    </code></p></div>
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteBase" id="RewriteBase">RewriteBase</a> <a name="rewritebase" id="rewritebase">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit l'URL de base pour les rcritures au niveau
rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteBase <em>chemin URL</em></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Pas de valeur par dfaut</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
</table>
      <p>La directive <code class="directive">RewriteBase</code> dfinit
      explicitement le chemin URL de base (et non le chemin du
      rpertoire dans le systme de fichiers !) pour les rcritures dans un contexte
      de rpertoire dont le rsultat est la substitution d'un
      chemin relatif. Lorsque vous utilisez une directive <code class="directive"><a href="#rewriterule">RewriteRule</a></code> dans un fichier
      <code>.htaccess</code>, <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> enlve le
      prfixe de rpertoire local avant d'effectuer le traitement, puis
      rcrit ce qui reste de l'URL. Lorsque la rcriture est termine,
      <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> ajoute automatiquement le prfixe de
      rpertoire local (ou la valeur de la directive
      <code class="directive">RewriteBase</code> si cette dernire est dfinie)
       la chane de substitution avant de la remettre  disposition du
      serveur, comme s'il s'agissait de l'URL d'origine.</p>

	<p>Cette directive est <em>requise</em> pour les rcritures
	dans un contexte de rpertoire dfini via la directive
	<code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code> lorsque la
	substitution utilise un chemin relatif.</p>

      <p>Si votre chemin URL n'existe pas rellement dans le systme de
      fichiers, ou ne trouve pas directement sous le rpertoire dfini
      par la directive <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code>, vous devez utiliser la
      directive	<code class="directive">RewriteBase</code> dans chaque fichier
	<code>.htaccess</code> o vous voulez utiliser des directives <code class="directive"><a href="#rewriterule">RewriteRule</a></code>.</p>

      <p>L'exemple ci-dessous montre comment faire correspondre
      http://example.com/mon-appli/index.html 
      /home/www/exemple/nouveau_site.html dans un fichier
      <code>.htaccess</code>. On suppose que le contenu disponible 
      http://example.com/ se situe sur le disque 
      /home/www/exemple/.</p>
      
<div class="example"><pre>
RewriteEngine On
# Le chemin URL utilis pour arriver dans ce contexte, et non le chemin
# du systme de fichiers
RewriteBase /mon-appli/
RewriteRule ^index\.html$  nouveau_site.html
</pre></div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteCond" id="RewriteCond">RewriteCond</a> <a name="rewritecond" id="rewritecond">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit une condition qui devra tre satisfaite pour que
la rcriture soit effectue
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code> RewriteCond
      <em>chane de test</em> <em>expression de comparaison</em></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
</table>
      <p>La directive <code class="directive">RewriteCond</code> permet de dfinir une
      condition d'excution d'une rgle. Une ou plusieurs conditions
      <code class="directive">RewriteCond</code> peuvent prcder une
      directive <code class="directive"><a href="#rewriterule">RewriteRule</a></code>. La rgle de rcriture correspondante n'est
      ainsi excute que si ces conditions sont satisfaites,
      <strong>et</strong> si l'URI correspond au modle spcifi dans la
      rgle.</p>

      <p><em>TestString</em> est une chane qui peut contenir les
      extensions suivantes en plus du texte simple :</p>
      
      <ul>
        <li>
          <strong>rfrences arrires de rgle de rcriture</strong> :
	  ce sont des rfrences arrires de la forme
	  <strong><code>$N</code></strong> (0 &lt;= N &lt;= 9). $1  $9
	  permettent d'accder aux parties regroupes (entre
	  parenthses) du modle, issues de la <code>RewriteRule</code>
	  concerne par le jeu de conditions <code>RewriteCond</code>
	  courant. $0 donne accs  l'ensemble de la chane
	  correspondant au modle.</li>
        <li>
          <strong>Rfrences arrires de condition de rcriture
	  </strong> : ce sont des rfrences arrires de la forme
	  <strong><code>%N</code></strong> (0 &lt;= N &lt;= 9). %1  %9
	  permettent d'accder aux parties regroupes (entre
	  parenthses) du modle, issues de la <code>RewriteRule</code>
	  concerne par le jeu de conditions <code>RewriteCond</code>
	  courant. %0 donne accs  l'ensemble de la chane
	  correspondant au modle.</li>
        <li>
          <strong>extensions de table de rcriture</strong> :
	  ce sont des extensions de la forme <strong><code>${nomTable:cl|dfaut}</code></strong>. Voir la <a>href="#mapfunc"&gt;documentation sur RewriteMap</a>
	   pour plus de dtails.
        </li>
        <li>
          <strong>Variables du serveur</strong> :
	  ce sont des variables de la forme
	  <strong><code>%{</code> <em>NAME_OF_VARIABLE</em> <code>}</code></strong>,
            o <em>NOM_DE_VARIABLE</em> peut contenir une chane issue
	    de la liste suivante :

          <table>
          
            <tr>
              <th>En-ttes HTTP :</th> <th>connexion &amp; requte:</th> <th />
	    </tr>

            <tr>
	      <td>
		 HTTP_USER_AGENT<br />
                 HTTP_REFERER<br />
                 HTTP_COOKIE<br />
                 HTTP_FORWARDED<br />
                 HTTP_HOST<br />
                 HTTP_PROXY_CONNECTION<br />
                 HTTP_ACCEPT<br />
              </td>

              <td>
                 REMOTE_ADDR<br />
                 REMOTE_HOST<br />
                 REMOTE_PORT<br />
                 REMOTE_USER<br />
                 REMOTE_IDENT<br />
                 REQUEST_METHOD<br />
                 SCRIPT_FILENAME<br />
                 PATH_INFO<br />
                 QUERY_STRING<br />
                 AUTH_TYPE<br />
              </td>

	      <td />
            </tr>

            <tr>
              <th>variables internes au serveur :</th> <th>date et heure :</th> <th>spciaux :</th>
	    </tr>

            <tr>
	      <td>
	         DOCUMENT_ROOT<br />
                 SERVER_ADMIN<br />
                 SERVER_NAME<br />
                 SERVER_ADDR<br />
                 SERVER_PORT<br />
                 SERVER_PROTOCOL<br />
                 SERVER_SOFTWARE<br />
              </td>

              <td>
                 TIME_YEAR<br />
                 TIME_MON<br />
                 TIME_DAY<br />
                 TIME_HOUR<br />
                 TIME_MIN<br />
                 TIME_SEC<br />
                 TIME_WDAY<br />
                 TIME<br />
              </td>

              <td>
                 API_VERSION<br />
                 THE_REQUEST<br />
                 REQUEST_URI<br />
                 REQUEST_FILENAME<br />
                 IS_SUBREQ<br />
                 HTTPS<br />
		 REQUEST_SCHEME<br />
              </td>
            </tr>
          </table>
	
                <p>Ces variables correspondent toutes aux en-ttes MIME
		HTTP de mmes noms, au variables C du serveur HTTP Apache, ou
		aux champs <code>struct tm</code> du systme Unix. La
		plupart d'entre elles sont documentes ailleurs dans le
		manuel ou dans la spcification CGI.</p>

		<p>SERVER_NAME et SERVER_PORT dpendent respectivement
		des valeurs des directives <code class="directive"><a href="../mod/core.html#usecanonicalname">UseCanonicalName</a></code> et <code class="directive"><a href="../mod/core.html#usecanonicalphysicalport">UseCanonicalPhysicalPort</a></code>.</p>
		
		<p>Parmi les variables
		spcifiques  mod_rewrite, ou trouve les suivantes :</p>
        <div class="note">
                <dl>
                  <dt><code>IS_SUBREQ</code></dt>

                  <dd>Contient le texte "true" si la requte en cours
		  de traitement est une sous-requte, "false" dans le
		  cas contraire. Une sous-requte est gnre quand un
		  module a besoin de se rfrer  des fichiers ou URIs
		  addidionnels pour pouvoir mener  bien sa tche.</dd>

                  <dt><code>API_VERSION</code></dt>

                  <dd>C'est la version de l'API des modules Apache httpd
		  (l'interface interne entre le serveur et les modules)
		  pour la construction courante de httpd, telle qu'elle
		  est dfinie dans include/ap_mmn.h. La version de l'API
		  des modules correspond  la version du serveur Apache
		  httpd
		  utilis (par exemple, pour la version 1.3.14 d'Apache
		  httpd,
		  il s'agit de la version 19990320:10), mais intresse
		  principalement les auteurs de modules.</dd>

                  <dt><code>THE_REQUEST</code></dt>

                  <dd>La ligne de requte HTTP complte envoye par le
		  navigateur au serveur (par exemple, "<code>GET
                  /index.html HTTP/1.1</code>"),  l'exclusion de tout
		  en-tte ajout par le navigateur. Cette
		  valeur n'a pas t dschappe (dcode),  la
		  diffrence de la plupart des variables suivantes.</dd>

                  <dt><code>REQUEST_URI</code></dt>

                  <dd>La ressource demande dans la ligne de requte
		  HTTP ("/index.html" dans l'exemple ci-dessus).</dd>

                  <dt><code>REQUEST_FILENAME</code></dt>

                  <dd>Le chemin complet local au systme de fichiers
		  du fichier ou du script correspondant
		   la requte, s'il a dj t dtermin par le serveur
		  au moment o on y fait rfrence. Dans le cas
		  contraire, et en particulier dans le cas d'un serveur
		  virtuel, <code>REQUEST_FILENAME</code> contient la
		  valeur de <code>REQUEST_URI</code>.</dd>

                  <dt><code>HTTPS</code></dt>

                  <dd>Contient le texte "on" si la connexion
		  utilise SSL/TLS, "off" dans le cas contraire
		  (Cette variable peut tre utilise sans problme, que
		  <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> soit charg ou non.</dd>

		  <dt><code>REQUEST_SCHEME</code></dt>

                  <dd>Contient le protocole de la requte (en gnral
		  "http" ou "https"). La valeur peut tre modifie par
		  la directive <code class="directive"><a href="../mod/core.html#servername">ServerName</a></code>.</dd>

                </dl>
</div>
        </li>
      </ul>

      <p>Si la <em>chane de test</em> contient la valeur spciale
      <code>expr</code>, <em>expression de comparaison</em> sera trait
      en tant qu'expression rationnelle de type <a href="../expr.html">ap_expr</a>.</p>

      <p>Autres points  connatre ::</p>
      <ol>
        <li>
        <p>Les variables <code>SCRIPT_FILENAME</code> et
	<code>REQUEST_FILENAME</code> contiennent toutes deux la valeur
	du champ <code>filename</code> de la
	structure interne <code>request_rec</code>du serveur HTTP Apache.
	Le premier nom correspond au nom de variable bien connu CGI,
	alors que le second est l'quivalent de REQUEST_URI (qui
	contient la valeur du champ <code>uri</code> de
	<code>request_rec</code>).</p>
        <p>Si une substitution intervient et si la rcriture se
	poursuit, la valeur des deux variables sera mise  jour en
	consquence.</p>
        <p>Dans le contexte du serveur principal (c'est  dire avant que
	la requte ne soit mise en correspondance avec le systme de
	fichiers), SCRIPT_FILENAME et REQUEST_FILENAME  ne peuvent pas
	contenir le chemin entier dans le systme de fichiers local car
	ce chemin b'est pas connu  ce stade du traitement. Dans ce cas,
	les deux variables contiendront la valeur de REQUEST_URI. Pour
	obtenir le chemin complet de la requte dans le systme de
	fichiers local dans le contexte du serveur principal, utilisez une
	rfrence avant  base d'URL
	<code>%{LA-U:REQUEST_FILENAME}</code> pour dterminer la valeur
	finale de REQUEST_FILENAME.</p></li>


        <li>
	<code>%{ENV:<em>variable</em>}</code>, o <em>variable</em> peut
	correspondre  une variable d'environnement quelconque.</li>
	<li>
        <code>%{ENV:variable}</code> est aussi disponible, o
	<em>variable</em> peut correspondre  toute variable
	d'environnement. Peut tre consult via des structures internes
	d'Apache httpd et (si on ne les trouve pas ici) via la fonction
	<code>getenv()</code>  partir du processus du serveur Apache
	httpd.</li>

        <li>Que <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> soit charg ou non, on peut
	utiliser <code>%{SSL:variable}</code>, o <em>variable</em>
	peut tre remplac par le nom d'une
	<a href="mod_ssl.html#envvars">variable
	d'environnement SSL</a> . Si <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> n'est pas
	charg, cette variable contiendra toujours une chane vide.
	Exemple : <code>%{SSL:SSL_CIPHER_USEKEYSIZE}</code> pourra
	contenir la valeur <code>128</code>.</li>
	
	<li>
        On peut utiliser <code>%{HTTP:en-tte}</code>, o
	<em>en-tte</em> peut correspondre  tout nom d'en-tte MIME
	HTTP, pour extraire la valeur d'un en-tte envoy dans la
	requte HTTP. Par exemple, <code>%{HTTP:Proxy-Connection}</code>
	contiendra la valeur de l'en-tte HTTP
	"<code>Proxy-Connection:</code>".
	Si on utilise un en-tte HTTP
	dans une condition, et si cette condition est value 
	<code>vrai</code> pour la requte, cet en-tte sera ajout  l'en-tte Vary de
	la rponse. Il ne le sera pas si la condition est value 
	<code>faux</code>. L'ajout de l'en-tte HTTP  l'en-tte Vary
	est ncessaire  une mise en cache approprie.
	<p>Il faut garder  l'esprit que les conditions suivent une
	logique de cout-circuit si le drapeau
	'<strong><code>ornext|OR</code></strong>' est utilis, et que de
	ce fait, certaines d'entre elles ne seront pas values.</p>
	</li>

        <li>A des fins de rfrence avant, on peut utiliser,
	<code>%{LA-U:variable}</code>, qui
	permet d'effectuer une sous-requte interne  base d'URL, afin
	de dterminer la valeur finale de <em>variable</em>. Ceci permet
	d'accder  la valeur d'une variable pour la rcriture inconnue
	 ce stade du traitement, mais qui sera dfinie au
	cours d'une phase ultrieure.
	<p>Par exemple, pour effectuer une rcriture dpendant de la
	variable <code>REMOTE_USER</code> dans le contexte du serveur
	principal (fichier <code>httpd.conf</code>), vous devez utiliser
	<code>%{LA-U:REMOTE_USER}</code> - cette variable est dfinie
	par la phase d'autorisation qui intervient <em>aprs</em> la
	phase de traduction d'URL (pendant laquelle mod_rewrite opre).</p>
        <p>Par contre, comme mod_rewrite implmente son contexte de
	rpertoire (fichier <code>.htaccess</code>) via la phase Fixup
	de l'API, et comme la phase d'autorisation intervient
	<em>avant</em> cette dernire, vous pouvez vous contenter
	d'utiliser <code>%{REMOTE_USER}</code> dans ce contexte.</p></li>

        <li>
        <code>%{LA-F:variable}</code> peut tre utilise pour effectuer
	une sous-requte interne (base sur le nom de fichier), afin de
	dterminer la valeur finale de <em>variable</em>. La plupart du
	temps, elle est identique  LA-U (voir ci-dessus).</li>
      </ol>
	
 
      <p><em>expression de comparaison</em> est une expression
      rationnelle qui est applique  l'instance actuelle de
      <em>chane de test</em>. <em>chane de test</em> est d'abord
      value, puis compare 
      l'<em>expression de comparaison</em>.</p>

      <p><em>expression de comparaison</em> est en gnral une
      <em>expression rationnelle compatible perl</em>, mais vous
      disposez des syntaxes supplmentaires suivantes pour effectuer
      d'autres tests utiles sur <em>chane de test</em> :
      </p>

      <ol>
        <li>Vous pouvez prfixer l'expression avec un caractre
	'<code>!</code>' (point d'exclamation) pour indiquer une
	expression de <strong>non</strong>-correspondance.</li>

        <li>Vous pouvez effectuer des comparaisons lexicographiques de
	chanes	:

          <ul>
            <li>'<strong>&lt;expression</strong>' (infrieur au sens
	    lexicographique)<br />
	    Traite l'<em>expression</em> comme une chane de
	    caractres et la compare lexicographiquement 
	    <em>chane de test</em>. La condition est satisfaite si
	    <em>chane de test</em> est infrieure au sens
	    lexicographique  l'<em>expression</em>.</li>

            <li>'<strong>&gt;expression</strong>' (suprieur au sens
	    lexicographique)<br />
	    Traite l'<em>expression</em> comme une chane de
	    caractres et la compare lexicographiquement 
	    <em>chane de test</em>. La condition est satisfaite si
	    <em>chane de test</em> est suprieure au sens
	    lexicographique  l'<em>expression</em>.</li>

            <li>'<strong>=expression</strong>' (gal au sens
	    lexicographique)<br />
	    Traite l'<em>expression</em> comme une chane de
	    caractres et la compare lexicographiquement 
	    <em>chane de test</em>. La condition est satisfaite si
	    <em>chane de test</em> est gale au sens
	    lexicographique  l'<em>expression</em> (les deux chanes
	    sont exactement identiques, caractre pour caractre). Si
	    <em>expression</em> est <code>""</code> (deux guillemets),
	    <em>chane de test</em> est compare  la chane vide.</li>

	    <li>'<strong>&lt;=expression de comparaison</strong>' (infrieur ou gal 
	    au sens lexicographique)<br />
            Considre l'<em>expression de comparaison</em> comme une
	    chane de caractres et la compare au sens lexicographique 
	    la <em>chane de test</em>. Vrai si <em>chane de test</em>
	    prcde lexicographiquement <em>expression de comparaison</em>, ou est
	    gale  <em>expression de comparaison</em> (les deux chanes
	    sont identiques, caractre pour caractre).</li>

            <li>'<strong>&gt;=expression de comparaison</strong>'
	    (suprieur ou gal  au sens lexicographique)<br />
            Considre l'<em>expression de comparaison</em> comme une
	    chane de caractres et la compare au sens lexicographique 
	    la <em>chane de test</em>. Vrai si <em>chane de test</em>
	    suit lexicographiquement <em>expression de comparaison</em>, ou est
	    gale  <em>expression de comparaison</em> (les deux chanes
	    sont identiques, caractre pour caractre).</li>
        </ul></li>

        <li>
          Vous pouvez effectuer des comparaisons d'entiers :
          <ul>

            <li>'<strong>-eq</strong>' (est numriquement gal )<br />
            La <em>chane de test</em> est considre comme un entier,
	    et est compare numriquement  l'<em>expression de
	    comparaison</em>. Vrai si les deux expressions sont
	    numriquement gales.</li>

            <li>'<strong>-ge</strong>' (est numriquement suprieur ou
	    gal )<br />
            La <em>chane de test</em> est considre comme un entier,
	    et est compare numriquement  l'<em>expression de
	    comparaison</em>. Vrai si <em>chane de test</em> est
	    numriquement
	    suprieure ou gale  <em>expression de comparaison</em>.</li>
            
             <li>'<strong>-gt</strong>' (est numriquement suprieur )<br />
            La <em>chane de test</em> est considre comme un entier,
	    et est compare numriquement  l'<em>expression de
	    comparaison</em>. Vrai si <em>chane de test</em> est
	    numriquement
	    suprieure  <em>expression de comparaison</em>.</li>

            <li>'<strong>-le</strong>' (est numriquement infrieur ou
	    gal )<br />
            La <em>chane de test</em> est considre comme un entier,
	    et est compare numriquement  l'<em>expression de
	    comparaison</em>. Vrai si <em>chane de test</em> est
	    numriquement
	    infrieure ou gale  <em>expression de comparaison</em>.
	    Attention  la confusion avec le drapeau <strong>-l</strong>
	    en utilisant la variante the <strong>-L</strong> ou
	    <strong>-h</strong>.</li>
            
             <li>'<strong>-lt</strong>' (est numriquement infrieur )<br />
            La <em>chane de test</em> est considre comme un entier,
	    et est compare numriquement  l'<em>expression de
	    comparaison</em>. Vrai si <em>chane de test</em> est
	    numriquement
	    infrieure  <em>expression de comparaison</em>.
	    Attention  la confusion avec le drapeau <strong>-l</strong>
	    en utilisant la variante the <strong>-L</strong> ou
	    <strong>-h</strong>.</li>

           </ul>
        </li>

        <li>Vous pouvez effectuer diffrents tests sur les attributs de
	fichier :
          <ul>

            <li>'<strong>-d</strong>' (est un rpertoire -
	    <strong>d</strong>irectory)<br />
	    Traite <em>chane de test</em> comme un chemin et vrifie
	    s'il existe ou pas, et s'il s'agit d'un rpertoire.</li>

            <li>'<strong>-f</strong>' (est un
	    <strong>f</strong>ichier rgulier)<br />
	    Traite <em>chane de test</em> comme un chemin et vrifie
	    s'il existe ou pas, et s'il s'agit d'un fichier rgulier.</li>

            <li>'<strong>-F</strong>' (test de l'existence d'un fichier
	    via une sous-requte)<br />
	    Vrifie si <em>chane de test</em> est un fichier valide,
	    accessible  travers tous les contrles d'accs du serveur
	    actuellement configurs pour ce chemin. C'est une
	    sous-requte interne qui effectue cette vrification - 
	    utiliser avec prcautions car les performances du serveur
	    peuvent s'en trouver affectes !</li>

	    <li>'<strong>-H</strong>' (est un lien symbolique, selon la
	    convention bash)<br />
            Voir <strong>-l</strong>.</li>

            <li>'<strong>-l</strong>' (est un lien symbolique)<br />
            Considre la <em>chane de test</em> comme un chemin et
	    vrifie son existence et si elle est un lien symbolique. On
	    peut aussi utiliser la convention bash <strong>-L</strong>
	    ou <strong>-h</strong> lorsqu'il y a risque de confusion
	    avec les tests <strong>-lt</strong> ou <strong>-le</strong>.</li>

            <li>'<strong>-L</strong>' (est un lien symbolique, selon la
	    convention bash)<br />
            Voir <strong>-l</strong>.</li>

            <li>'<strong>-s</strong>' (est un fichier rgulier d'une
	    certaine taille)<br />
            Considre la <em>chane de test</em> comme un chemin et
	    vrifie son existence et si elle est un fichier rgulier
	    d'une taille suprieure  zro.</li>

            <li>'<strong>-U</strong>' (test de l'existence d'une
	    <strong>U</strong>RL via une sous-requte)<br />
	    Vrifie si <em>chane de test</em> est une URL valide,
	    accessible  travers tous les contrles d'accs du serveur
	    actuellement configurs pour ce chemin. C'est une
	    sous-requte interne qui effectue cette vrification - 
	    utiliser avec prcautions car les performances du serveur
	    peuvent s'en trouver affectes !</li>

	  <li>'<strong>-x</strong>' (a l'attribut d'excution positionn)<br />
            Considre la <em>chane de test</em> comme un chemin et
	    vrifie son existence et si elle a son attribut d'excution
	    positionn. Ce positionnement est dtermin en fonction de
	    l'OS sous-jacent.</li>

	    </ul>

<div class="note"><h3>Note :</h3>
              Tous ces tests peuvent aussi tre prfixs par un point
	      d'exclamation ('!') pour inverser leur signification.
</div>
        </li>

	<li>
           <p>Si la <em>chane de test</em> contient la valeur spciale
	   <code>expr</code>, la <em>chane de comparaison</em> sera
	   traite en tant qu'expression rationnelle de type <a href="../expr.html">ap_expr</a>.</p>

	   <p>
            Dans l'exemple ci-dessous, on utilise <code>-strmatch</code>
	    pour comparer le <code>REFERER</code> avec le nom d'hte du
	    site afin de bloquer le hotlinking (rfrencement direct)
	    non dsir.
           </p>

           <div class="example"><p><code>
           RewriteCond expr "! %{HTTP_REFERER} -strmatch '*://%{HTTP_HOST}/*'"<br />
           RewriteRule ^/images - [F]
           </code></p></div>
        </li>

	<li>Vous pouvez aussi dfinir certains drapeaux pour
	l'<em>expression de comparaison</em> en ajoutant ces
	<strong><code>[</code><em>drapeaux</em><code>]</code></strong>
	comme troisime argument de la directive
	<code>RewriteCond</code>, o <em>drapeaux</em> est un
	sous-ensemble spar par des virgules des drapeaux suivants :

      <ul>
        <li>'<strong><code>nocase|NC</code></strong>'
	(<strong>n</strong>o <strong>c</strong>ase)<br />
	Rend le test insensible  la casse - il n'est pas fait de
	distinction entre majuscules et minuscules,  la fois dans le
	dveloppement de <em>chane de test</em> et dans
	<em>expression de comparaison</em>. Ce drapeau n'est pris en
	compte que lors d'une comparaison entre <em>chane de test</em>
	et <em>expression de comparaison</em>. Il ne l'est pas pour les
	vrification par sous-requtes ou sur le systme de
	fichiers.</li>

        <li>
          '<strong><code>ornext|OR</code></strong>'
	  (<strong>ou</strong> condition suivante)<br />
	  Permet de chaner les conditions de rgles avec un OU au
	  lieu du AND implicite. Exemple typique :

<div class="example"><pre>
RewriteCond %{REMOTE_HOST}  ^host1  [OR]
RewriteCond %{REMOTE_HOST}  ^host2  [OR]
RewriteCond %{REMOTE_HOST}  ^host3
RewriteRule ...rgles concernant tous ces htes...
</pre></div>

          Sans ce drapeau, les paires
	  condition/rgle devraient tre crites trois fois.
        </li>

        <li>'<strong><code>novary|NV</code></strong>'
	(<strong>n</strong>o <strong>v</strong>ary)<br />
	Si la condition contient un en-tte HTTP, ce drapeau empche
	ce dernier d'tre ajout  l'en-tte Vary de la rponse. <br />
	L'utilisation de ce drapeau peut provoquer une mise en cache
	incorrecte de la rponse, si la reprsentation de cette rponse
	varie avec la valeur de l'en-tte considr. Ce drapeau ne
	devrait donc tre utilis que si l'on matrise parfaitement le
	fonctionnement de l'en-tte Vary.
        </li>
      </ul>
      </li>
     </ol>

      <p><strong>Exemple :</strong></p>

       <p>Pour rcrire la page d'accueil d'un site en fonction de
       l'en-tte ``<code>User-Agent:</code>'' de la requte, vous
       pouvez utiliser ce qui suit : </p>

<div class="example"><pre>
RewriteCond  %{HTTP_USER_AGENT}  ^Mozilla
RewriteRule  ^/$                 /homepage.max.html  [L]

RewriteCond  %{HTTP_USER_AGENT}  ^Lynx
RewriteRule  ^/$                 /homepage.min.html  [L]

RewriteRule  ^/$                 /homepage.std.html  [L]
</pre></div>

        <p>Explications : si vous utilisez un navigateur
	(Netscape Navigator, Mozilla etc) qui s'identifie comme
	'Mozilla', vous accderez  la page d'accueil max (qui
	peut contenir des frames, ou d'autres ressources
	particulires).
	Si vous utilisez le navigateur Lynx (qui est un navigateur
	en mode texte), vous accderez  une page d'accueil min
	(qui peut tre une version conue pour une navigation simple
	base sur le texte).
	Si aucune de ces conditions n'est satisfaite (vous utilisez tout
	autre navigateur, ou votre navigateur s'identifie de manire non
	standard), vous accderez  la page d'accueil std
	(standard).</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteEngine" id="RewriteEngine">RewriteEngine</a> <a name="rewriteengine" id="rewriteengine">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active ou dsactive l'excution du
moteur de rcriture</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteEngine on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>RewriteEngine off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
</table>

      <p>La directive <code class="directive">RewriteEngine</code> active ou
      dsactive l'excution du moteur de rcriture. Si sa valeur est
      <code>off</code>, ce module n'excutera aucun traitement et ne
      mettra pas  jour les variables d'environnement
      <code>SCRIPT_URx</code>.</p>

      <p>Pour dsactiver le module, il vaut mieux utiliser cette
      directive que commenter toutes les directives <code class="directive"><a href="#rewriterule">RewriteRule</a></code> !</p>

      <p>Notez que les  htes virtuels n'hritent pas des
      configurations de rcriture. Ceci implique que vous devez
      insrer une directive <code>RewriteEngine on</code> dans chaque
      hte virtuel pour lequel vous souhaitez utiliser des rgles
      de rcriture.</p>

      <p>Les directives <code class="directive">RewriteMap</code> du type
      <code>prg</code> ne sont pas prises en compte au cours de
      l'initialisation du serveur si elle ont t dfinies dans un
      contexte o la directive <code class="directive">RewriteEngine</code> n'a
      pas t dfinie  <code>on</code>.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteMap" id="RewriteMap">RewriteMap</a> <a name="rewritemap" id="rewritemap">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit une fonction de mise en correspondance pour la
recherche de mots-cls</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteMap <em>nom de la correspondance</em> <em>type de
correspondance</em>:<em>source de la correspondance</em>
</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Il est possible de choisir entre plusieurs types de
bases de donnes depuis la version 2.0.41 du serveur HTTP Apache</td></tr>
</table>
      <p>La directive <code class="directive">RewriteMap</code> dfinit une
      <em>Table de correspondance pour la rcriture</em> que les
      fonctions de mise en correspondance
      peuvent utiliser dans les chanes de substitution des rgles
      pour insrer/substituer des champs en recherchant des mots-cls.
      La source utilise pour cette recherche peut tre de plusieurs
      types.</p>

      <p><a id="mapfunc" name="mapfunc"><em>nom de la
      correspondance</em></a> est le nom de la table de correspondance
      et servira  spcifier une fonction de mise en correspondance
      pour les chanes de substitution d'une rgle de rcriture selon
      une des constructions suivantes :</p>

      <p class="indent">
        <strong><code>${</code> <em>nom de la
      correspondance</em> <code>:</code>
        <em>mot-cl</em> <code>}</code><br />
         <code>${</code> <em>nom de la
      correspondance</em> <code>:</code>
        <em>mot-cl</em> <code>|</code> <em>valeur par dfaut</em>
        <code>}</code></strong>
      </p>

      <p>Lorsqu'une telle construction est rencontre, la table de
      correspondance <em>Nom de la correspondance</em> est consulte
      et la cl <em>mot-cl</em> recherche. Si la cl est trouve, la
      construction est remplace par
      la <em>valeur de remplacement</em>. Si la cl n'est pas trouve,
      elle est remplace par la <em>valeur par dfaut</em>, ou par une
      chane vide si aucune <em>valeur par dfaut</em> n'est
      spcifie. La valeur vide se comporte comme si la
      cl tait absente ; il est donc impossible de distinguer une
      valeur vide d'une absence de cl.</p>

      <p>Par exemple, vous pouvez dfinir une directive
      <code class="directive">RewriteMap</code> comme suit </p>

      <div class="example"><p><code>
      RewriteMap map-exemple txt:/chemin/vers/fichier/map.txt
      </code></p></div>

      <p>Vous pourrez ensuite utiliser cette table dans une
      directive <code class="directive">RewriteRule</code> comme suit :</p>

      <div class="example"><p><code>
      RewriteRule ^/ex/(.*) ${map-exemple:$1}
      </code></p></div>

      <p>Les combinaisons suivantes pour <em>type de correspondance</em>
      et <em>source de la correspondance</em>
      peuvent tre utilises :</p>

<dl>
    <dt>txt</dt>
        <dd>Un fichier texte contenant des paires cl-valeur spares
	par des espaces, une paire par ligne (<a href="../rewrite/rewritemap.html#txt">Dtails ...</a>).</dd>

    <dt>rnd</dt>
        <dd>Slection alatoire d'une entre depuis un fichier texte (<a href="../rewrite/rewritemap.html#rnd">Dtails ...</a>).</dd>

    <dt>dbm</dt>
        <dd>Recherche une entre dans un fichier dbm contenant des
	paires nom-valeur. Le condens hash est labor  partir d'un
	format de fichier texte via l'utilitaire <code><a href="../programs/httxt2dbm.html">httxt2dbm</a></code> (<a href="../rewrite/rewritemap.html#dbm">Dtails ...</a>).</dd>

    <dt>int</dt>
        <dd>Une des quatre fonctions internes disponibles que fournit
	<code>RewriteMap</code>: toupper, tolower, escape ou unescape
	(<a href="../rewrite/rewritemap.html#int">Dtails ...</a>).</dd>

    <dt>prg</dt>
        <dd>Appelle un programme externe ou un script pour effectuer la
	rcriture (<a href="../rewrite/rewritemap.html#int">Dtails
	...</a>).</dd>

    <dt>dbd or fastdbd</dt>
        <dd>Une commande SQL SELECT  excuter pour rechercher la cible
	de rcriture (<a href="../rewrite/rewritemap.html#int">Dtails
	...</a>).</dd>
    </dl>    

<p>Vous trouverez plus de dtails et de nombreux exemples dans le <a href="../rewrite/rewritemap.html">RewriteMap HowTo</a>.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteOptions" id="RewriteOptions">RewriteOptions</a> <a name="rewriteoptions" id="rewriteoptions">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configure certaines options spciales
pour le moteur de rcriture</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteOptions <var>Options</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td><code>MaxRedirects</code> n'est plus disponible depuis
la version version 2.1</td></tr>
</table>

      <p>La directive <code class="directive">RewriteOptions</code> dfinit
      certaines options spciales pour la configuration au niveau du
      serveur ou du rpertoire. La chane de caractres <em>Option</em>
      ne peut actuellement prendre qu'une des valeurs suivantes :</p>

      <dl>
      <dt><code>Inherit</code></dt>
      <dd>

      <p>Ceci force la configuration locale  hriter de la
      configuration du niveau suprieur. Dans le contexte des htes
      virtuels, cela signifie que les correspondances, conditions et
      rgles du serveur principal sont hrites. Dans le contexte des
      rpertoires, cela signifie que les conditions et rgles de la
      configuration <code>.htaccess</code> ou les sections <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> du rpertoire
      parent sont hrites. Les rgles hrites sont virtuellement
      copies dans la section o cette directive est utilise. Si elles
      sont utilises avec des rgles locales, les rgles hrites sont
      places aprs ces dernires. La place de cette directive - avant
      ou aprs les rgles locales - n'a aucune influence sur ce
      comportement. Si des rgles locales ont forc l'arrt de la
      rcriture, les rgles hrites ne seront pas traites.</p>

      <div class="warning">
      Les rgles hrites du niveau parent sont appliques
      <strong>after</strong> aprs les rgles spcifies dans le niveau
      enfant.
      </div>
      </dd>

      <dt><code>InheritBefore</code></dt>
      <dd>
      <p>Mme effet que l'option <code>Inherit</code> ci-dessus, mais
      les rgles spcifies dans le niveau parent s'appliquent
      <strong>avant</strong> les rgles spcifies dans le niveau
      enfant. Disponible depuis la version 2.3.10 du serveur HTTP
      Apache.</p>
      </dd>

      </dl>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RewriteRule" id="RewriteRule">RewriteRule</a> <a name="rewriterule" id="rewriterule">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit les rgles pour le moteur de rcriture</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RewriteRule
      <em>Modle</em> <em>Substitution</em> [<em>drapeaux</em>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_rewrite</td></tr>
</table>
      <p>La directive <code class="directive">RewriteRule</code> est le
      vritable cheval de trait de la rcriture. La directive peut
      apparatre plusieurs fois, chaque instance dfinissant une
      rgle de rcriture particulire. L'ordre dans lequel ces rgles
      sont dfinies est important - il s'agit de l'ordre dans lequel
      les rgles seront appliques au cours du processus de
      rcriture.</p>

      <p><a id="patterns" name="patterns"><em>Modle</em></a> est une
      <a id="regexp" name="regexp">expression rationnelle</a>
      compatible perl. Dans la premire rgle de rcriture,
      l'expression est compare au (%-decoded)
      <a href="./directive-dict.html#Syntax">chemin de l'URL</a> de la
      requte ; les expressions suivantes sont compares  la sortie de
      la dernire rgle de rcriture qui a t applique.</p>

<div class="note"><h3>Qu'est-ce qui est compar ?</h3>
      
      <p>Dans un contexte de serveur virtuel <code class="directive"><a href="../mod/core.html#virtualhost">VirtualHost</a></code>, le <em>modle</em> est tout
      d'abord compar  la portion de l'URL situe entre le nom d'hte
      ventuellement accompagn du port, et la chane de paramtres (par
      exemple "/app1/index.html").</p>

      <p>Dans les contextes de rpertoire <code class="directive"><a href="../mod/core.html#directory">Directory</a></code> et htaccess, le
      <em>modle</em> est tout d'abord compar au chemin du <em>systme
      de fichiers</em>, aprs suppression du prfixe ou chemin de base
      ayant conduit  la rgle <code class="directive">RewriteRule</code> (par
      exemple "app1/index.html" ou
      "index.html" selon l'endroit o les directives sont dfinies).</p>
      
      <p>Si vous souhaitez faire une comparaison sur le nom
      d'hte, le port, ou la chane de requte, utilisez une
      directive <code class="directive"><a href="#rewritecond">RewriteCond</a></code>
      comportant respectivement les variables
      <code>%{HTTP_HOST}</code>, <code>%{SERVER_PORT}</code>, ou
      <code>%{QUERY_STRING}</code>.</p>
</div>

<div class="note"><h3>Rcritures dans un contexte de rpertoire</h3>
<ul>
<li>L'utilisation du moteur de rcriture dans les
fichiers <a href="../howto/htaccess.html">.htaccess</a> et les sections
<code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> est un peu plus
complexe.</li>

<li>Pour activer le moteur de rcriture dans ces contextes, vous devez
dfinir "<code>RewriteEngine On</code>" <strong>et</strong>
"<code>Options FollowSymLinks</code>". Si l'administrateur a dsactiv
la possibilit de modifier l'option <code>FollowSymLinks</code> au
niveau du rpertoire d'un utilisateur, vous ne pouvez pas utiliser le
moteur de rcriture. Cette restriction a t instaure  des fins de
scurit.</li>

<li>Lorsqu'on utilise le moteur de rcriture dans un fichier
<code>.htaccess</code>, le chemin de base du rpertoire courant (qui est
toujours le mme pour ce mme rpertoire) est automatiquement
<em>supprim</em> au cours de la comparaison avec le modle de la rgle
de rcriture, et automatiquement <em>ajout</em> lorsqu'une
substitution relative (ne dbutant pas par un slash ou un nom de
protocole) arrive  la fin d'un jeu de rgles. Voir la directive
<code class="directive"><a href="#rewritebase">RewriteBase</a></code> pour plus de
dtails  propos de l'ajout du prfixe aprs les substitutions
relatives.</li>

<li>Si vous souhaitez effectuer une comparaison en prenant en compte
l'intgralit du
chemin de l'URL dans un contexte de rpertoire (htaccess), vous devez
utiliser la variable <code>%{REQUEST_URI}</code> dans la directive
<code class="directive">RewriteCond</code>.</li>

<li>Le prefixe supprim se termine toujours par un slash, ce qui
signifie que la comparaison s'effectue avec une chane qui ne comporte
<em>jamais</em> de slash de dbut. Ainsi, un <em>modle</em> contenant
<code>^/</code> ne correspondra jamais dans un contexte de rpertoire.</li>

<li>Bien que les rgles de rcriture soient permises du point de vue de
la syntaxe dans les sections <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code> et <code class="directive"><a href="../mod/core.html#files">&lt;Files&gt;</a></code>, elles n'y sont pas prises en compte, et
n'y sont  priori d'aucune utilit.</li>
</ul>
</div>

	<p>Pour quelques conseils  propos des <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expressions rationnelles</a>, voir le
	document <a href="../rewrite/intro.html#regex">Introduction 
	mod_rewrite</a>.</p>

      <p>Dans mod_rewrite, on peut aussi utiliser le caractre NON
      ('<code>!</code>') comme prfixe de modle. Ceci vous permet
      d'inverser la signification d'un modle, soit pour dire
      ``<em>si l'URL considre ne correspond <strong>PAS</strong> 
      ce modle</em>''. Le caractre NON peut donc tre utilis 
      titre exceptionnel, lorsqu'il est plus simple d'effectuer une
      comparaison avec le modle invers, ou dans la dernire rgle
      par dfaut.</p>

<div class="note"><h3>Note</h3>
Si vous utilisez le caractre NON pour inverser la signification d'un
modle, vous ne pouvez pas inclure de parties gnriques groupes dans
le modle. Ceci est d au fait que, lorsque le modle ne correspond
pas (autrement dit, sa ngation correspond), les groupes sont vides.
Ainsi, si vous utilisez des modles inverss, vous ne pouvez
pas vous rfrer aux groupes par <code>$N</code> dans la chane de
substitution !
</div>

      <p>Dans une rgle de rcriture,
      <a id="rhs" name="rhs"><em>Substitution</em></a> est la chane
      de caractres qui remplace le chemin de l'URL original qui
      correspondait au <em>Modle</em>. <em>Substitution</em> peut
      tre :</p>

      <dl>

        <dt>un chemin du systme de fichiers</dt>

        <dd>Il indique alors la localisation dans le systme de
	fichiers de la ressource qui doit tre envoye au client.</dd>

        <dt>chemin d'URL</dt>

        <dd>Un chemin relatif  la valeur de <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code> vers la ressource qui
	doit tre servie. Notez que <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>
	essaie de deviner si vous avez spcifi un chemin du systme
	de fichiers ou un chemin d'URL en vrifiant si la premire
	partie du chemin existe  la racine du systme de fichiers.
	Par exemple, si vous avez spcifi comme chane de
	<em>Substitution</em> <code>/www/file.html</code>, cette
	dernire sera traite comme un chemin d'URL <em> moins</em>
	qu'un rpertoire nomm <code>www</code> n'existe  la racine
	de votre systme de fichiers, auquel cas la chane de
	substitution sera traite comme un chemin du systme de
	fichiers. Si vous dsirez que d'autres directives de
	correspondance d'URL (comme la directive <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code>) soient appliques au
	chemin d'URL rsultant, utilisez le drapeau <code>[PT]</code>
	comme dcrit ci-dessous.</dd>

        <dt>URL absolue</dt>

        <dd>Si une URL absolue est spcifie,
	<code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> vrifie si le nom d'hte
	correspond  celui de l'hte local. Si c'est le cas, le
	protocole et le nom d'hte sont supprims, et ce qui reste est
	trait comme un chemin d'URL. Dans le cas contraire, une
	redirection externe vers l'URL indique est effectue. Pour
	forcer une redirection externe vers l'hte local, voir le
	drapeau <code>[R]</code> ci-dessous.</dd>

        <dt><code>-</code> (tiret)</dt>

        <dd>Un tiret indique qu'aucune substitution ne doit tre
	effectue (le chemin considr est transmis sans changement).
	Ceci est utile quand un drapeau doit tre appliqu sans
	modifier le chemin (voir ci-dessous).</dd>

      </dl>

      <p>En plus du texte, la chane <em>Substition</em> peut
      comporter :</p>

      <ol>
        <li>des rfrences arrires (<code>$N</code>) vers le modle
	d'une directive RewriteRule</li>

        <li>des rfrences arrires (<code>%N</code>) vers le dernier
	modle d'une directive RewriteCond qui correspondait</li>

        <li>des variables du serveur comme dans les chanes de test de
	condition d'une rgle (<code>%{VARNAME}</code>)</li>

        <li>des appels de
	<a href="#mapfunc">fonctions de comparaison</a>
	(<code>${nom correspondance:cl|dfaut}</code>)</li>
      </ol>

      <p>Les rfrences arrires sont des identificateurs de la forme
      <code>$</code><strong>N</strong> (<strong>N</strong>=0..9), qui
      seront remplacs par le contenu du <strong>N</strong>me groupe
      du <em>Modle</em> qui correspondait. Les variables du serveur
      sont les mmes que dans la <em>Chane de test</em> d'une
      directive <code>RewriteCond</code>. Les fonctions de comparaison
      sont issues de la directive <code>RewriteMap</code> dans la
      section de laquelle elles sont dcrites. Ces trois types de
      variables sont values dans l'ordre ci-dessus.</p>

      <p>Comme mentionn prcdemment, toutes les rgles de
      rcriture sont appliques  la chane de <em>Substitution</em>
      (selon l'ordre dans lequel elles sont dfinies dans le fichier
      de configuration). L'URL est <strong>intgralement
      remplace</strong> par la chane de <em>Substitution</em> et le
      processus de rcriture se poursuit jusqu' ce que toutes les
      rgles aient t appliques, ou qu'il soit explicitement stopp
      par un drapeau <code><strong>L</strong></code>.</p>

     <div class="note"><h3>Modifier la chane de requte</h3>
      <p>Par dfaut, la chane de requte est transmise sans
      modification. Vous pouvez cependant crer dans la chane de
      substitution des URLs dont une partie constitue une chane de
      requte. Pour cela, ajoutez simplement un point d'interrogation
      dans la chane de substitution pour indiquer que le texte qui
      suit doit tre rinject dans la chane de requte. Pour
      supprimer une chane de requte, terminez simplement la chane de
      substitution par un point d'interrogation. Pour combiner les
      nouvelles chanes de requte avec les anciennes, utilisez le
      drapeau <code>[QSA]</code>.</p>
     </div>


      <p>En outre, vous pouvez spcifier des <a name="rewriteflags" id="rewriteflags">actions</a> spciales  effectuer en ajoutant
      des
      <strong><code>[</code><em>drapeaux</em><code>]</code></strong>
      comme troisime argument de la directive
      <code>RewriteRule</code>. Spars par des virgules au sein d'une
      liste encadre par des crochets, les <em>drapeaux</em> peuvent
      tre choisis dans la table suivante. Vous trouverez plus de
      dtails, et des exemples pour chaque drapeau dans le <a href="../rewrite/flags.html">document  propos des drapeaux de
      rcriture.</a></p>

      <table class="bordered">
    <tr><th>Drapeaux et syntaxe</th>
        <th>Fonction</th>
    </tr>
    <tr>
        <td>B</td>
        <td>Echappe les caractres non-alphanumriques <em>avant</em>
	d'appliquer la transformation. <em><a href="../rewrite/flags.html#flag_b">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>chain|C</td>
        <td>La rgle est chane avec la rgle suivante. Si la rgle
	choue, la ou les rgles avec lesquelles elle est est chane
	seront sautes. <em><a href="../rewrite/flags.html#flag_c">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>cookie|CO=<em>NAME</em>:<em>VAL</em></td>
        <td>Dfinit un cookie au niveau du navigateur client. La syntaxe
	complte est :
	CO=<em>NAME</em>:<em>VAL</em>[:<em>domain</em>[:<em>lifetime</em>[:<em>path</em>[:<em>secure</em>[:<em>httponly</em>]]]]]
	<em><a href="../rewrite/flags.html#flag_co">dtails ...</a></em>
        </td>
    </tr>
    <tr>
        <td>discardpath|DPI</td>
        <td>Supprime la partie PATH_INFO de l'URI rcrit. <em><a href="../rewrite/flags.html#flag_dpi">dtails 
        ...</a></em></td>
    </tr>
    <tr>
        <td>env|E=[!]<em>VAR</em>[:<em>VAL</em>]</td>
        <td>Dfinit la variable d'environnement <em>VAR</em> ( la valeur
	<em>VAL</em> si elle est fournie). La variante !<em>VAR</em>
	annule la dfinition de la variable <em>VAR</em>.<em><a href="../rewrite/flags.html#flag_e">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>forbidden|F</td>
        <td>Renvoie une rponse 403 FORBIDDEN au navigateur client.
	<em><a href="../rewrite/flags.html#flag_f">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>gone|G</td>
        <td>Renvoie un message d'erreur 410 GONE au navigateur client. <em><a href="../rewrite/flags.html#flag_g">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>Handler|H=<em>Gestionnaire de contenu</em></td>
        <td>L'URI rsultant est envoy au <em>Gestionnaire de
	contenu</em> pour traitement. <em><a href="../rewrite/flags.html#flag_h">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>last|L</td>
        <td>Arrte le processus de rcriture immdiatement et n'applique
	plus aucune rgle. Prtez une attention particulire aux mises
	en garde concernant les contextes de niveau rpertoire et
	.htaccess (voir aussi le drapeau END). <em><a href="../rewrite/flags.html#flag_l">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>next|N</td>
        <td>Rexcute le processus de rcriture  partir de la premire
	rgle, en utilisant le rsultat du jeu de rgles, sous rserve
	qu'il y ait un point de dpart. <em><a href="../rewrite/flags.html#flag_n">dtails
        ...</a></em></td>
    </tr>
    <tr>
        <td>nocase|NC</td>
        <td>Rend la comparaison entre modles insensible  la casse.
	<em><a href="../rewrite/flags.html#flag_nc">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>noescape|NE</td>
        <td>Empche mod_rewrite d'effectuer un chappement hexadcimal
	des caractres spciaux dans le rsultat de la rcriture. <em><a href="../rewrite/flags.html#flag_ne">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>nosubreq|NS</td>
        <td>La rgle est saute si la requte courante est une
	sous-requte interne. <em><a href="../rewrite/flags.html#flag_ns">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>proxy|P</td>
        <td>Force l'envoi en interne de l'URL de substitution en tant
	que requte mandataire. <em><a href="../rewrite/flags.html#flag_p">dtails
        ...</a></em></td>
    </tr>
    <tr>
        <td>passthrough|PT</td>
        <td>L'URI rsultant est repass au moteur de mise en
	correspondance des URLs pour y tre trait par d'autres
	traducteurs URI-vers-nom de fichier, comme <code>Alias</code> ou
	<code>Redirect</code>. <em><a href="../rewrite/flags.html#flag_pt">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>qsappend|QSA</td>
        <td>Ajoute toute chane de paramtres cre dans la cible de
	rcriture  toute chane de paramtres prsente dans l'URL de la
	requte originale. <em><a href="../rewrite/flags.html#flag_qsa">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>qsdiscard|QSD</td>
        <td>Supprime toute chane de paramtres de l'URI entrant. <em><a href="../rewrite/flags.html#flag_qsd">dtails
        ...</a></em></td>
    </tr>
    <tr>
        <td>redirect|R[=<em>code</em>]</td>
        <td>Force une redirection externe, avec un code de statut HTTP
	optionnel. <em><a href="../rewrite/flags.html#flag_r">dtails ...</a></em>
        </td>
    </tr>
    <tr>
        <td>END</td>
        <td>Arrte le processus de rcriture immdiatement et
	n'applique plus aucune rgle. Empche aussi l'excution
	ultrieure de rgles de rcriture dans des contextes de
	rpertoire et des fichiers .htaccess (disponible depuis la
	version 2.3.9) <em><a href="../rewrite/flags.html#flag_l">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>skip|S=<em>nombre</em></td>
        <td>Si la rgle courante s'applique, le moteur de rcriture
	doit sauter les <em>nombre</em> rgles suivantes. <em><a href="../rewrite/flags.html#flag_s">dtails ...</a></em></td>
    </tr>
    <tr>
        <td>tyle|T=<em>Type-MIME</em></td>
        <td>Force l'attribution du <a class="glossarylink" href="../glossary.html#type-mime" title="voir glossaire">Type-MIME</a>
	spcifi au fichier cible. <em><a href="../rewrite/flags.html#flag_t">dtails ...</a></em></td>
    </tr>
    </table>
        
<div class="note"><h3>Dveloppement du rpertoire home</h3>
<p> Quand la chane de substitution commence par quelque chose comme
"/~user" (de manire explicite ou par rfrences arrires), mod_rewrite
dveloppe le rpertoire home sans tenir compte de la prsence ou de la
configuration du module <code class="module"><a href="../mod/mod_userdir.html">mod_userdir</a></code>.</p>

<p> Ce dveloppement n'est pas effectu si le drapeau <em>PT</em> est
utilis dans la directive <code class="directive"><a href="#rewriterule">RewriteRule</a></code></p>
</div>

     <p>Voici toutes les combinaisons de substitution et leurs
     significations :</p>

      <p><strong>Dans la configuration au niveau du serveur principal
      (<code>httpd.conf</code>)<br />
       pour la requte ``<code>GET
      /chemin/infochemin</code>'':</strong><br />
      </p>

<table class="bordered">
<tr>
<th>Rgle</th>
<th>Rsultat de la substitution</th>
</tr>

<tr>
<td>^/un_chemin(.*) autre_chemin$1</td>
<td>invalide, non support</td>
</tr>

<tr>
<td>^/un_chemin(.*) autre_chemin$1  [R]</td>
<td>invalide, non support</td>
</tr>

<tr>
<td>^/un_chemin(.*) autre_chemin$1  [P]</td>
<td>invalide, non support</td>
</tr>

<tr>
<td>^/un_chemin(.*) /autre_chemin$1</td>
<td>/autre_chemin/info_chemin</td>
</tr>

<tr>
<td>^/un_chemin(.*) /autre_chemin$1 [R]</td>
<td>http://cet_hote/autre_chemin/info_chemin via une redirection externe</td>
</tr>

<tr>
<td>^/un_chemin(.*) /autre_chemin$1 [P]</td>
<td>sans objet, non support</td>
</tr>

<tr>
<td>^/un_chemin(.*) http://cet_hote/autre_chemin$1</td>
<td>/autre_chemin/info_chemin</td>
</tr>

<tr>
<td>^/un_chemin(.*) http://cet_hote/autre_chemin$1 [R]</td>
<td>http://cet_hote/autre_chemin/info_chemin via une redirection externe</td>
</tr>

<tr>
<td>^/un_chemin(.*) http://cet_hote/autre_chemin$1 [P]</td>
<td>sans objet, non support</td>
</tr>

<tr>
<td>^/un_chemin(.*) http://autre_hote/autre_chemin$1</td>
<td>http://autre_hote/autre_chemin/info_chemin via une redirection externe</td>
</tr>

<tr>
<td>^/un_chemin(.*) http://autre_hote/autre_chemin$1 [R]</td>
<td>http://autre_hote/autre_chemin/info_chemin (le drapeau [R] est
redondant)</td>
</tr>

<tr>
<td>^/somepath(.*) http://otherhost/otherpath$1 [P]</td>
<td>http://otherhost/otherpath/pathinfo via internal proxy</td>
</tr>
</table>      

      <p><strong>Dans une configuration de niveau rpertoire pour
      <code>/chemin</code><br />
       (<code>/chemin/physique/vers/chemin/.htacccess</code>, avec
      <code>RewriteBase /chemin</code>)<br />
       pour la requte ``<code>GET
      /chemin/chemin-local/infochemin</code>'':</strong><br />
     </p>

<table class="bordered">

<tr>
<th>Rgle</th>
<th>Rsultat de la substitution</th>
</tr>

<tr>
<td>^chemin-local(.*) autre-chemin$1</td>
<td>/chemin/autre-chemin/infochemin</td>
</tr>

<tr>
<td>^chemin-local(.*) autre-chemin$1  [R]</td>
<td>http://cet-hte/chemin/autre-chemin/infochemin via redirection
externe</td>
</tr>

<tr>
<td>^chemin-local(.*) autre-chemin$1  [P]</td>
<td>n'a pas lieu d'tre, non support</td>
</tr>

<tr>
<td>^chemin-local(.*) /autre-chemin$1</td>
<td>/autre-chemin/infochemin</td>
</tr>

<tr>
<td>^chemin-local(.*) /autre-chemin$1 [R]</td>
<td>http://cet-hte/autre-chemin/infochemin via redirection externe</td>
</tr>

<tr>
<td>^chemin-local(.*) /autre-chemin$1 [P]</td>
<td>n'a pas lieu d'tre, non support</td>
</tr>

<tr>
<td>^chemin-local(.*) http://cet-hte/autre-chemin$1</td>
<td>/autre-chemin/infochemin</td>
</tr>

<tr>
<td>^chemin-local(.*) http://cet-hte/autre-chemin$1 [R]</td>
<td>http://cet-hte/autre-chemin/infochemin via redirection externe</td>
</tr>

<tr>
<td>^chemin-local(.*) http://cet-hte/autre-chemin$1 [P]</td>
<td>n'a pas lieu d'tre, non support</td>
</tr>

<tr>
<td>^chemin-local(.*) http://autre hte/autre-chemin$1</td>
<td>http://autre hte/autre-chemin/infochemin via redirection externe</td>
</tr>

<tr>
<td>^chemin-local(.*) http://autre hte/autre-chemin$1 [R]</td>
<td>http://autre hte/autre-chemin/infochemin via redirection externe
(le drapeau [R] est redondant)</td>
</tr>

<tr>
<td>^chemin-local(.*) http://autre hte/autre-chemin$1 [P]</td>
<td>http://autre hte/autre-chemin/infochemin via un mandataire interne</td>
</tr>

</table>

  
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_rewrite.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_rewrite.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2011 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>