<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Compilation et Installation - Serveur Apache HTTP</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.2</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.2</a></div><div id="page-content"><div id="preamble"><h1>Compilation et Installation</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./de/install.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="./en/install.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/install.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/install.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/install.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/install.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<div class="outofdate">Cette traduction peut tre prime. Verifiez la version
            Anglaise pour les changements rcents.</div>


    <p>Ce document couvre la compilation et l'installation d'Apache sur les
    systmes Unix et clones d'Unix. Pour la compilation et l'installation sous
    Windows, voir <a href="platform/windows.html">Utiliser Apache sous Windows
    </a>. Pour les autres plates-formes, voir la documentation des <a href="platform/">plates-formes</a>.</p>

    <p>L'environnement de configuration et d'installation d'Apache 2.0 a t
    compltement revu par rapport  celui d'Apache 1.3. Apache 1.3 utilisait un
    ensemble de scripts pour permettre une installation facile. Apache 2.0
    utilise  prsent <code>libtool</code> et <code>autoconf</code> afin de
    crer un environnement le plus proche possible d'autres projets
    Logiciel Libre.</p>

    <p>Si vous faite une mise  niveau d'une version mineure  la suivante (par
    exemple, de 2.0.50  2.0.51), veuillez s'il vous plat passer directement 
    la section <a href="#upgrading">Mise  niveau</a>.</p>

</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#overview">Survol Rapide pour les
    impatients</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#requirements">Pr-requis</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#download">Tlcharger</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#extract">Extraire</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#configure">Configurer l'arborescence source</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#compile">Compiler</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#install">Installer</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#customize">Personnaliser la Configuration</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#test">Tester</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#upgrading">Mise  niveau</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="programs/configure.html">Configurer l'arborescence source</a></li><li><a href="invoking.html">Dmarrage d'Apache</a></li><li><a href="stopping.html">Arrt et Redmarrage</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="overview" id="overview">Survol Rapide pour les
    impatients</a></h2>

    <table>
      
      <tr>
        <td><a href="#download">Tlcharger</a></td>

        <td><code>$ lynx http://httpd.apache.org/download.cgi</code>
        </td>
      </tr>

      <tr>
        <td><a href="#extract">Extraire</a></td>

        <td><code>$ gzip -d httpd-2_1_<em>NN</em>.tar.gz<br />
         $ tar xvf httpd-2_1_<em>NN</em>.tar</code> </td>
      </tr>

      <tr>
        <td><a href="#configure">Configurer</a></td>

        <td><code>$ ./configure --prefix=<em>PREFIX</em></code>
        </td>
      </tr>

      <tr>
        <td><a href="#compile">Compiler</a></td>

        <td><code>$ make</code> </td>
      </tr>

      <tr>
        <td><a href="#install">Installer</a></td>

        <td><code>$ make install</code> </td>
      </tr>

      <tr>
        <td><a href="#customize">Personnaliser</a></td>

        <td><code>$ vi <em>PREFIX</em>/conf/httpd.conf</code> </td>
      </tr>

      <tr>
        <td><a href="#test">Tester</a></td>

        <td><code>$ <em>PREFIX</em>/bin/apachectl start</code>
        </td>
      </tr>
    </table>

    <p><em>NN</em> doit tre remplac par le numro de version mineure actuel, et
    <em>PREFIX</em> par le chemin o le serveur doit tre install. Si
    <em>PREFIX</em> n'est pas spcifi, l'installation se fait dans
    <code>/usr/local/apache2</code>.</p>

    <p>Chacune des sections du processus de compilation et d'installation est
    dcrite ci-aprs, en commenant par les pr-requis  la compilation et 
    l'installation d'Apache HTTPD.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="requirements" id="requirements">Pr-requis</a></h2>

    <p>Les pr-requis suivants sont ncessaire pour  l'installation d'Apache:</p>

    <dl>
      <dt>Espace Disque</dt>
      <dd>Au moins 50 Mo d'espace disque temporaire sont ncessaires. Aprs
      installation, Apache occupe environ 10 Mo sur le disque. L'espace disque
      occup par une installation complte dpend beaucoup de la configuration
      du serveur, ainsi que de la prsence ventuelle de modules tiers.</dd>

      <dt>Compilateur C ANSI et Build</dt>
      <dd>Un compilateur C ANSI doit tre utilis. Le <a href="http://www.gnu.org/software/gcc/gcc.html">compilateur C GNU
      (GCC)</a> de la <a href="http://www.gnu.org/">Free Software Foundation
      (FSF)</a> est recommand (la version 2.7.2 convient). En cas
      d'absence de GCC, vrifiez que le compilateur fourni avec l'architecture
      utilise est conforme aux normes ANSI. De plus, les outils de constructions
      de base, tel <code>make</code>, doivent tre prsents dans votre
      <code>PATH</code>.</dd>

      <dt>S'assurer que la machine est et reste  l'heure</dt>
      <dd>Certains lments du protocole HTTP sont exprims en tant qu'heure de
      la journe. Aussi est-il important de s'assurer que le systme o Apache
      doit tourner dispose de mcanismes de synchronisation temporelle. En
      gnral, les programmes <code>ntpdate</code> ou <code>xntpd</code> sont
      utiliss; ces programmes implmentent le Network Time Protocol (NTP).
      Voir le groupe Usenet <a href="news:comp.protocols.time.ntp">comp.protocols.time.ntp</a> et la <a href="http://www.eecis.udel.edu/~ntp/">page NTP</a> pour plus de dtails
      sur les logiciels NTP et les serveurs de temps publics.</dd>

      <dt><a href="http://www.perl.org/">Perl 5</a>
      [FACULTATIF]</dt>
      <dd>Certains des scripts fournis avec Apache, tel <a href="programs/apxs.html">apxs</a> ou <a href="programs/dbmmanage.html">dbmmanage</a> (qui sont crits en
      Perl) ncessitent l'interprteur Perl 5 (version 5.003 ou suprieure).
      Au cas o le script <code>configure</code> ne trouve pas d'interprteur
      Perl, la compilation sera quand mme ralise sans souci. Seuls ces
      scripts ne seront pas utilisables. Si plusieurs interprteurs Perl sont
      installs (par exemple, Perl 4 fourni avec l'OS, et Perl 5 install par
      l'administrateur), il est conseill de passer l'option
      <code>--with-perl</code> afin de garantir que le bon interprteur est
      utilis par <code>./configure</code>.</dd>
    </dl>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="download" id="download">Tlcharger</a></h2>

    <p>Apache est tlchargeable depuis le <a href="http://httpd.apache.org/download.cgi">site de tlchargement
    d'Apache</a> qui fournit la liste de plusieurs miroirs. L sont disponibles
    les dernires versions. La plupart des
    utilisateurs d'Apache sur des systmes de type Unix devraient
    probablement tlcharger et compiler une version  partir du code source.
    Le processus de construction (dcrit ci-dessous) est facile et
    vous permet d'adapter votre serveur pour convenir  vos besoins.
    En outre, les versions binaires ne sont souvent pas  jour avec
    les dernires versions du code source. Si vous tlchargez une
    version binaire, suivez les instructions dans le dossier
    <code>INSTALL.bindist</code>  l'intrieur de la distribution.</p>

    <p>Aprs le tlchargement, il est important de vrifier que les sources
    tlcharges sont bien compltes et non modifies, et ce surtout si un
    miroir a t utilis pour le tlchargement. Ceci peut tre fait en
    testant l'archive tar tlcharge avec la signature PGP. Cette procdure
    s'effectue en 2 tapes. D'abord, il faut rcuprer le fichier <a href="http://www.apache.org/dist/httpd/KEYS"><code>KEYS</code></a> du site
    de distribution d'Apache. (Pour vrifier que ce fichier <code>KEYS</code>
    n'a pas t modifi, une bonne ide peut tre d'utiliser un fichier d'une
    distribution prcdente d'Apache ou d'importer les cls d'un serveur de
    cls public.) Les cls peuvent tre importes dans le keyring de
    l'utilisateur au moyen d'une des commandes (selon la version de PGP):</p>

<div class="example"><p><code>$ pgp &lt; KEYS</code></p></div>

    <p>ou </p>

<div class="example"><p><code>$ gpg --import KEYS</code></p></div>

    <p>La prochaine tape est de tester l'archive tar au moyen de la signature
    PGP, qui devrait toujours tre disponible sur le <a href="http://httpd.apache.org/download.cgi">site principal d'Apache</a>.
    Un lien vers cette signature est plac derrire le lien de tlchargement
    correspondant ou peut tre trouv dans le rpertoire correspondant sur <a href="http://www.apache.org/dist/httpd/">le site de distribution
    d'Apache</a>. Le nom de ce fichier est le mme que celui de l'archive
    source, avec en plus l'extension <code>.asc</code>. La distribution
    tlcharge peut alors tre vrifie au moyen de la commande ( nouveau,
    selon la version de PGP):</p>

<div class="example"><p><code>$ pgp httpd-2_1_<em>NN</em>.tar.gz.asc</code></p></div>

    <p>ou</p>

<div class="example"><p><code>$ gpg --verify httpd-2_1_<em>NN</em>.tar.gz.asc</code></p></div>

    <p>Un message comme celui-ci devrait s'afficher</p>

<div class="example"><p><code>Good signature from user "Martin Kraemer
      &lt;martin@apache.org&gt;".</code></p></div>

    <p>Selon les relations de confiances contenues dans le keyring de
    l'utilisateur, un message peut s'afficher, spcifiant que la relation entre
    la cl et le signataire ne peut tre vrifie. Ceci n'est pas un problme si
    vous ne mettez pas en doute l'authenticit du fichier <code>KEYS</code>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="extract" id="extract">Extraire</a></h2>

    <p>Extraire les sources  partir de l'archive tar est une simple affaire de
    dcompression et d'extraction tar:</p>

<div class="example"><p><code>
$ gzip -d httpd-2_1_<em>NN</em>.tar.gz<br />
$ tar xvf httpd-2_1_<em>NN</em>.tar
</code></p></div>

    <p>Un nouveau rpertoire est cr dans le rpertoire courant, il contient le
    code source de la distribution. Il faut aller dans ce rpertoire au moyen
    de la commande <code>cd</code> avant de commencer la compilation du
    serveur.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="configure" id="configure">Configurer l'arborescence source</a></h2>

    <p>L'tape suivante est la configuration de l'arborescence source d'Apache,
    pour votre plate-forme et selon les ncessits du site. Cette configuration est
    ralise au moyen du script <code>configure</code> fourni dans le
    rpertoire racine de la distribution. (Les dveloppeurs qui tlchargent
    Apache via CVS devront utiliser les outils <code>autoconf</code> et
    <code>libtool</code> avant de passer  la suite. Ceci n'est pas ncessaire
    pour les versions officielles.)</p>

    <p>Pour configurer l'arborescence source en utilisant les options par
    dfaut, tapez <code>./configure</code>. Pour modifier les valeurs des
    options par dfaut, <code>configure</code> accepte un grand nombre de
    variables et d'options de ligne de commande.  </p>

    <p>La plus importante de ces options est le chemin du rpertoire o
    Apache sera install,
    car Apache doit tre configur pour que cet emplacement fonctionne
    correctement. Plusieurs autres options sont disponibles pour
    le contrle fin de l'emplacement des fichiers rsultants avec <a href="programs/configure.html#installationdirectories">options de
    configuration</a>.</p>

   <p>En outre,  ce moment, vous pouvez indiquer quels <a href="programs/configure.html#optionalfeatures">fonctionnalits</a>
    vous voulez inclure dans Apache en ajoutant et/ou en retranchant
    des <a href="mod/">modules</a>. Apache vient avec un ensemble
    de modules de <a href="mod/module-dict.html#Status">Base</a>
    inclus par dfaut. D'autres modules peuvent tre ajouts en utilisant
    l'option <code>--enable-<var>module</var></code>, o
    <var>module</var> est le nom du module avec la chane
    <code>mod_</code> coupe et avec les caractres de soulignement
    convertis en tirets. Vous pouvez galement choisir de compiler
    des modules en tant qu'<a href="dso.html">objets partags (DSOs)</a>,
    qui peuvent tre chargs ou dcharg  l'excution -- en employant
    l'option <code>--enable-<var>module</var>=shared</code>.
    De mme, vous pouvez retrancher les modules de Base avec l'option
    <code>--disable-<var>module</var></code>. Prenez garde lorsque
    vous employez ces options, puisque <code>configure</code> ne peut
    vous informer si le module cible n'existe pas; <code>configure</code>
    ignorera simplement l'option.</p>

    <p>Il est parfois ncessaire de fournir des
    informations supplmentaires au script
    <code>configure</code> sur l'emplacement de vos
    compilateur, bibliothques ou dossiers d'en-tte. Ceci se fait en
    passant les variables d'environnement ou des options incluses sur la ligne
    de commande  <code>configure</code>. Pour plus d'information
    sur ce sujet, consultez la page de documentation
    <a href="programs/configure.html">configurer</a>.</p>

    <p>L'exemple suivant compile Apache pour tre install
    dans <code>/sw/pkg/apache</code> avec un
    compilateur et des options de compilation particulires, ainsi que les deux
    modules <code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code> et <code class="module"><a href="./mod/mod_speling.html">mod_speling</a></code>, qui
    pourront tre chargs plus tard au moyen des mcanismes DSO:</p>

<div class="example"><p><code>
      $ CC="pgcc" CFLAGS="-O2" \<br />
       ./configure --prefix=/sw/pkg/apache \<br />
       --enable-rewrite=shared \<br />
       --enable-speling=shared
</code></p></div>

    <p>Une fois lanc, <code>configure</code> peut prendre quelques minutes
    pour tester les possibilits du systme et produire les fichiers
    <code>Makefile</code> qui seront utiliss pour construire le serveur.</p>

    <p>Les dtails de toutes les options <code>configure</code> sont
    disponibles sur la page de documentation <a href="programs/configure.html">configurer</a>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="compile" id="compile">Compiler</a></h2>

    <p>Les diffrents composants d'Apache sont  prsent prts 
    tre compils, en tapant simplement la commande:</p>

<div class="example"><p><code>$ make</code></p></div>

    <p>Un peu de patience est requise, une configuration standard met environ 3
    minutes  compiler sur un Pentium III sous Linux 2.2. Ce temps peut
    varier largement suivant le matriel utilis et les modules
    selectionns.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="install" id="install">Installer</a></h2>

    <p>Il est temps d'installer le 'package' dans le rpertoire d'installation
    <em>PREFIX</em> configur auparavant (voir l'option <code>--prefix</code>
    ci-dessus) en tapant:</p>

<div class="example"><p><code>$ make install</code></p></div>

    <p>En cas de mise  jour, l'installation n'crasera ni les fichiers de
    configuration du serveur, ni ses documents.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="customize" id="customize">Personnaliser la Configuration</a></h2>

    <p>Il reste  prsent  configurer le serveur HTTP Apache, en ditant les
    <a href="configuring.html">fichiers de configuration</a> placs dans
    <code><em>PREFIX</em>/conf/</code>.</p>

<div class="example"><p><code>$ vi <em>PREFIX</em>/conf/httpd.conf</code></p></div>

    <p>A consulter : le manuel d'Apache dans
    <a href="./">docs/manual/</a> ou bien <a href="http://httpd.apache.org/docs/2.2/">http://httpd.apache.org/docs/2.2/</a> pour la dernire
    version de ce manuel, ainsi qu'une rfrence complte de
    toutes les
    <a href="mod/directives.html">directives de configuration</a>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="test" id="test">Tester</a></h2>

    <p>Une fois configur, le serveur HTTP Apache peut tre
    <a href="invoking.html">dmarr</a> en tapant:</p>

<div class="example"><p><code>$ <em>PREFIX</em>/bin/apachectl start</code></p></div>

    <p>Vous devriez alors pouvoir tester l'URL <code>http://localhost/</code>.
    La page affiche se trouve dans le rpertoire
    <code class="directive"><a href="./mod/core.html#documentroot">DocumentRoot</a></code>, habituellement configur
    en tant que <code><em>PREFIX</em>/htdocs/</code>.
    Le serveur peut tre <a href="stopping.html">arrt</a> en tapant:</p>

<div class="example"><p><code>$ <em>PREFIX</em>/bin/apachectl stop</code></p></div>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="upgrading" id="upgrading">Mise  niveau</a></h2>

    <p>La premire tape pour une mise  niveau est de lire
    l'annonce de la nouvelle version et le fichier <code>CHANGES</code>
    dans la distribution afin de trouver tous les changements qui
    peuvent affecter votre site. Si la mise  jour est effectue
    entre deux versions principales (par exemple, de 1.3  2.0 ou
    de 2.0  2.2), attendez-vous  des diffrences majeures
    au moment de la compilation et de l'excution, exigeant probablement
    des ajustements manuels. Tous les modules devront galement
    tre mis  niveau pour tenir compte des changements de l'API.</p>

    <p>La mise  niveau d'une version mineure  une plus rcente
    (par exemple, de 2.0.55  2.0.57) est plus facile. Le processus
    <code>make install</code> n'crasera aucun de vos documents, 
    fichiers journaux, ou fichiers de configuration existants.
    En outre, les dveloppeurs font tous les efforts possibles
    pour viter les changements incompatibles des options 
    <code>configure</code>, de la configuration d'excution,
    ou de l'API entre les versions mineures. Dans la plupart
    des cas vous devriez pouvoir employer une ligne de commande
    <code>configure</code> et un fichier de configuration
    identiques. De plus, tous vos modules devraient continuer  fonctionner.
    (Ceci ne vaut que pour les versions postrieures  2.0.41;
    les versions antrieures ont des changements incompatibles.)</p>

    <p>Si vous avez gard l'arborescence source de votre dernire
    installation, la mise  niveau est encore plus facile.
    Le dossier <code>config.nice</code> dans la racine de l'ancienne
    arborescence contient la ligne de commande <code>configure</code>
    exacte que vous avez utilise pour configurer l'arborescence des
    sources. Pour faire la mise  niveau d'une version  la suivante,
    vous devez copier le dossier <code>config.nice</code> dans
    l'arborescence des sources de la nouvelle version, l'diter
    pour faire les changements dsirs, puis excuter:</p>

    <div class="example"><p><code>
    $ ./config.nice<br />
    $ make<br />
    $ make install<br />
    $ <em>PREFIX</em>/bin/apachectl stop<br />
    $ <em>PREFIX</em>/bin/apachectl start<br />
    </code></p></div>

    <div class="warning">Vous devriez toujours essayer une
    nouvelle version dans un environnement de test avant de la
    mettre dans un environnement de production. Par exemple, vous pouvez
    installer et excuter la nouvelle version cte  cte avec l'ancienne
    en employant un <code>--prefix</code> et un port diffrents 
    (ce qui est possible en ajustant la directive <code class="directive"><a href="./mod/mpm_common.html#listen">Listen</a></code>)
    dans le but de tester toutes les incompatibilits possibles avant de
    faire la mise  niveau finale.</div>
</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./de/install.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="./en/install.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/install.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/install.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/install.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/install.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 1995-2006 The Apache Software Foundation or its licensors, as applicable.<br />Authoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div>
</body></html>