<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="es" xml:lang="es"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Compilacin e Instalacin - Servidor HTTP Apache</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Mdulos</a> | <a href="./mod/directives.html">Directivas</a> | <a href="./faq/">Preguntas Frecuentes</a> | <a href="./glossary.html">Glosario</a> | <a href="./sitemap.html">Mapa de este sitio web</a></p>
<p class="apache">Versin 2.2 del Servidor HTTP Apache</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Servidor HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentacin</a> &gt; <a href="./">Versin 2.2</a></div><div id="page-content"><div id="preamble"><h1>Compilacin e Instalacin</h1>
<div class="toplang">
<p><span>Idiomas disponibles: </span><a href="./de/install.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="./en/install.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/install.html" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/install.html" hreflang="fr" rel="alternate" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/install.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/install.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<div class="outofdate">Esta traduccin podra estar
            obsoleta. Consulte la versin en ingls de la
            documentacin para comprobar si se han producido cambios
            recientemente.</div>


    <p>Este documento explica cmo compilar e instalar Apache en
    sistemas Unix y tipo Unix. Para obtener informacin sobre
    cmo compilar e instalar en Windows, consulte la seccin
    <a href="platform/windows.html">Usar Apache en Microsoft
    Windows</a>. Para otras plataformas, consulte la
    documentacin sobre <a href="platform/">plataformas</a>.</p>

    <p>El entorno de configuracin e instalacin de Apache
    2.0 ha cambiado completamente respecto al de Apache 1.3. Apache
    1.3 usaba un conjunto de scripts a medida para conseguir una
    instalacin fcil. Apache 2.0 usa <code>libtool</code> y
    <code>autoconf</code> para crear un entorno ms parecido al
    de muchos otros proyectos Open Source.</p>
    
    <p>Si lo que quiere hacer es actualizar su servidor Apache desde
    una versin menor (por ejemplo, desde la 2.0.50 a la 2.0.51),
    pase directamente a la seccin de <a href="#upgrading">actualizacin</a>.</p>

</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#overview">Visin general del proceso para
    impacientes</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#requirements">Requisitos</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#download">Descargar</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#extract">Descomprimir</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#configure">Configuracin de la estructura de
directorios</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#compile">Compilar</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#install">Instalar</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#customize">Personalizar</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#test">Comprobar que la instalacin
funciona</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#upgrading">Actualizar una instalacin
prrevia</a></li>
</ul><h3>Consulte tambin</h3><ul class="seealso"><li><a href="programs/configure.html">Configuracin de la
estructura de directorios</a></li><li><a href="invoking.html">Iniciar Apache</a></li><li><a href="stopping.html">Parar y reiniciar Apache</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="overview" id="overview">Visin general del proceso para
    impacientes</a></h2>

    <table>
      
      <tr>
        <td><a href="#download">Descargar</a></td>

        <td><code>$ lynx http://httpd.apache.org/download.cgi</code>
        </td>
      </tr>

      <tr>
        <td><a href="#extract">Descomprimir</a></td>

        <td><code>$ gzip -d httpd-2_1_<em>NN</em>.tar.gz<br />
         $ tar xvf httpd-2_1_<em>NN</em>.tar</code> </td>
      </tr>

      <tr>
        <td><a href="#configure">Ejecutar el script configure</a></td>

        <td><code>$ ./configure --prefix=<em>PREFIX</em></code>
        </td>
      </tr>

      <tr>
        <td><a href="#compile">Compilar</a></td>

        <td><code>$ make</code> </td>
      </tr>

      <tr>
        <td><a href="#install">Instalar</a></td>

        <td><code>$ make install</code> </td>
      </tr>

      <tr>
        <td><a href="#customize">Personalizar</a></td>

        <td><code>$ vi <em>PREFIX</em>/conf/httpd.conf</code> </td>
      </tr>

      <tr>
        <td><a href="#test">Comprobar que la instalacin
        funciona</a></td>

        <td><code>$ <em>PREFIX</em>/bin/apachectl start</code>
        </td>
      </tr>
    </table>

    <p><em>NN</em> hay que reemplazarlo por el nmero de la
    versin menor, y <em>PREFIX</em> hay que reemplazarlo por la
    ruta en la que se va a instalar Apache. Si no especifica
    ningn valor en <em>PREFIX</em>, el valor por defecto que se
    toma es <code>/usr/local/apache2</code>.</p>

    <p>Cada parte del proceso de configuracin e instalacin
    se describe detalladamente ms abajo, empezando por los
    requisitos para compilar e instalar Apache.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="requirements" id="requirements">Requisitos</a></h2>

    <p>Estos son los requisitos necesarios para compilar Apache:</p>
  
    <dl>
      <dt>Espacio en disco</dt> <dd>Compruebe que tiene disponibles al
      menos 50 MB de espacio libre en disco. Despus de la
      instalacin, Apache ocupa aproximadamente 10 MB. No
      obstante, la necesidad real de espacio en disco vara
      considerablemente en funcin de las opciones de
      configuracin que elija y de los mdulos externos que
      use.</dd>

      <dt>Compilador ANSI-C y Build System</dt> <dd>Compruebe que
      tiene instalado un compilador de ANSI-C. Se recomienda el <a href="http://www.gnu.org/software/gcc/gcc.html">Compilador GNU C
      (GCC)</a> de la <a href="http://www.gnu.org/">Free Software
      Foundation (FSF)</a> (con la versin 2.7.2 es
      suficiente). Si no tiene instaldo el GCC, entonces compruebe que
      el compilador que va a utilizar cumple con los estndares
      ANSI. Adems, su <code>PATH</code> debe contener la
      ubicacin donde de encuentran las herramientas bsicas
      para compilar tales como <code>make</code>.</dd>

      <dt>Ajuste exacto del reloj del sistema</dt> <dd>Los elementos
      del protocolo HTTP estn expresados segn la hora del
      dia. Por eso, si quiere puede investigar como instalar alguna
      utilidad para sincronizar la hora de su sistema. Para esto,
      normalmente, se usan los programas <code>ntpdate</code> o
      <code>xntpd</code>, que estn basados en el protocolo
      Network Time Protocol (NTP). Consulte el grupo de noticias <a href="news:comp.protocols.time.ntp">comp.protocols.time.ntp</a>
      y el <a href="http://www.eecis.udel.edu/~ntp/">sitio web de NTP
      </a> para obtener ms informacin sobre NTP y los
      servidores pblicos de tiempo.</dd>

      <dt><a href="http://www.perl.org/">Perl 5</a> [OPCIONAL]</dt>
      <dd>Para algunos de los scripts de soporte como <a href="programs/apxs.html">apxs</a> o <a href="programs/dbmmanage.html">dbmmanage</a> (que estn
      escritos en Perl) es necesario el intrprete de Perl 5 (las
      versiones 5.003 o posteriores son suficientes). Si el script
      `<code>configure</code>' no encuentra ese intrprete
      tampoco pasa nada. An puede compilar e instalar Apache
      2.0. Lo nico que ocurrir es que esos scripts de
      soporte no podrn ser usados. Si usted tiene varios
      interpretes de Perl instalados (quizs Perl 4 porque estaba
      ya incluido en su distribucin de Linux y Perl 5 porque lo
      ha instalado usted), entonces se recomienda usar la opcin
      <code>--with-perl</code> para asegurarse de que
      <code>./configure</code> usa el intrprete correcto.</dd>
    </dl>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="download" id="download">Descargar</a></h2>

    <p>Puede descargar Apache desde <a href="http://httpd.apache.org/download.cgi">la seccin de
    descargas del sitio web de Apache</a> el cual tiene varios
    mirrors. Para la mayora de los usuarios de Apache que tienen
    sistemas tipo Unix, se recomienda que se descarguen y compilen el
    cdigo fuente. El proceso de compilacin (descrito
    ms abajo) es fcil, y permite adaptar el servidor
    Apache a sus necesidades. Adems, las versiones de
    disponibles en archivos binarios no estn siempre actulizadas
    con las ltimas modificaciones en el codigo fuente. Si se
    descarga un binario, siga las instrucciones contenidas en el
    archivo <code>INSTALL.bindist</code> incluido en la
    distribucin</p>

    <p>Despus de la descarga, es importante que verifique que el
    archivo descargado del servidor HTTP Apache est completo y
    sin modificaciones.  Esto puede hacerlo comparando el archivo
    descargado (.tgz) con su firma PGP. Instrucciones detalladas de
    cmo hacer esto estn disponibles en <a href="http://httpd.apache.org/download.cgi#verify"> la
    seccin de descargas</a> junto con un ejemplo de cmo <a href="http://httpd.apache.org/dev/verification.html">usar
    PGP</a>.</p>
 
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="extract" id="extract">Descomprimir</a></h2>

    <p>Extraer el cdigo fuente del archivo .tgz que acabada de
    descargar es muy fcil. Ejecute los siguientes comandos:</p>

<div class="example"><p><code>
      $ gzip -d httpd-2_1_<em>NN</em>.tar.gz<br />
       $ tar xvf httpd-2_1_<em>NN</em>.tar
</code></p></div>

    <p>Estos comandos crearn un nuevo directorio dentro del
    directorio en el que se encuentra y que contendr el
    cdigo fuente de la distribucin. Debe cambiarse a ese
    directorio con <code>cd</code> para proceder a compilar el
    servidor Apache.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="configure" id="configure">Configuracin de la estructura de
directorios</a></h2>

    <p>El siguiente paso es configurar la estructura de directorios
    para su plataforma y sus necesidades personales. Esto se hace
    usando el script <code>configure</code> incluido en el directorio
    raiz de la distribucin que acaba de descargar. (Los
    desarrolladores que se descarguen la versin del CVS de la
    estructura de directorios necesitarn tener instalados
    <code>autoconf</code> y <code>libtool</code>, y necesitarn
    ejecutar <code>buildconf</code> antes de continuar con los
    siguientes pasos. Esto no es preciso para las versiones
    oficiales.)</p>

    <p>Para configurar la estructura de directorios a partir del
    cdigo fuente usando las opciones por defecto, solo tiene que
    ejecutar <code>./configure</code>. Para cambiar las opciones por
    defecto, <code>configure</code> acepta una serie de variables y
    opciones por la lnea de comandos.</p>

    <p>La opcin ms importante es <code>--prefix</code> que
    es el directorio en el que Apache va a ser instalado despus,
    porque Apache tiene que ser configurado para el directorio que se
    especifique para que funcione correctamente.  Es posible lograr un
    mayor control del lugar donde se van a instalar los ficheros de
    Apache con otras <a href="programs/configure.html#installationdirectories">opciones de
    configuracin</a>.</p>

    <p>En este momento, puede especificar que <a href="programs/configure.html#optionalfeatures">caractersticas
    o funcionalidades</a> quiere incluir en Apache activando o
    desactivando <a href="mod/">mdulos</a>.  Apache viene con
    una <a href="mod/module-dict.html#Status">seleccin
    bsica</a> de mdulos incluidos por defecto.  Se pueden
    activar otros mdulos usando la opcin
    <code>--enable-<var>module</var></code>, donde <var>module</var>
    es el nombre del mdulo sin el <code>mod_</code> y
    convirtiendo los guiones bajos que tenga en guiones normales.
    Tambin puede optar por compilar mdulos como <a href="dso.html">objetos dinmicos compartidos (DSOs)</a> --
    que pueden ser activados o desactivados al ejecutar -- usando la
    opcin <code>--enable-<var>module</var>=shared</code>.  De
    igual manera, puede desactivar alguno de los mdulos que
    vienen por defecto en la seleccin basica con la opcin
    <code>--disable-<var>module</var></code>.  Tenga cuidado cuando
    use estas opciones, porque <code>configure</code> no le
    avisar si el mdulo que especifica no existe;
    simplemente ignorar esa opcin.</p>

    <p>Adems, a veces es necesario pasarle al script
    <code>configure</code> informacin adicional sobre donde esta
    su compilador, librerias o ficheros de cabecera.  Esto se puede
    hacer, tanto pasando variables de entorno, como pasandole opciones
    a <code>configure</code> a travs de la lnea de
    comandos.  Para ms informacin, consulte el <a href="programs/configure.html">Manual del script
    configure</a>.</p>

    <p>Para que se haga una idea sobre las posibilidades que tiene,
    aqu tiene un ejemplo tpico que configura Apache para
    la ruta <code>/sw/pkg/apache</code> con un compilador y unos flags
    determinados, y adems, con dos mdulos adicionales
    <code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code> y <code class="module"><a href="./mod/mod_speling.html">mod_speling</a></code> para
    cargarlos despus a travs del mecanismo DSO:</p>

<div class="example"><p><code>
      $ CC="pgcc" CFLAGS="-O2" \<br />
       ./configure --prefix=/sw/pkg/apache \<br />
       --enable-rewrite=shared \<br />
       --enable-speling=shared
</code></p></div>

    <p>Cuando se ejecuta <code>configure</code> se comprueban que
    caractersticas o funcionalidades estn disponibles en
    su sistema y se crean los Makefiles que sern usados luego
    para compilar el servidor. Esto tardar algunos minutos.</p>

    <p>La informacin sobre todas las opciones de
    <code>configure</code> est disponible en el <a href="programs/configure.html">Manual del script
    configure</a>.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="compile" id="compile">Compilar</a></h2>

    <p>Ahora puede compilar las diferentes partes que forman Apache
    simplemente ejecutando el siguiente comando:</p>

<div class="example"><p><code>$ make</code></p></div>

    <p>Por favor, tanga un poco de paciencia ahora, porque una
    configuracin bsica tarda aproximadamente 3 minutos en
    compilar en un Pentium III con un sistema Linux 2.2, pero este
    tiempo puede variar considerablemente en funcin de su
    hardware y del nmero de mdulos que haya
    seleccionado.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="install" id="install">Instalar</a></h2>

    <p>Ahora es el momento de instalar el paquete en el diretorio
    elegido en <em>PREFIX</em> (consulte la opcin
    <code>--prefix</code> ms arriba) ejecutando:</p>

<div class="example"><p><code>$ make install</code></p></div>

    <p>Si usted est solo actualizando una instalacin
    anterior, la nueva instalacin no sobreescribir sus
    ficheros de configuracin ni otros documentos.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="customize" id="customize">Personalizar</a></h2>

    <p>El paso siguiente, es personalizar su servidor Apache editando
    los <a href="configuring.html">ficheros de configuracin</a>
    que estn en <code><em>PREFIX</em>/conf/</code>.</p>

<div class="example"><p><code>$ vi <em>PREFIX</em>/conf/httpd.conf</code></p></div>

    <p>chele un vistazo al Manual de Apache que est en <a href="./">docs/manual/</a> o consulte en <a href="http://httpd.apache.org/docs/2.2/">http://httpd.apache.org/docs/2.2/</a> la versin ms
    reciente de este manual y la Guia de Referencia de todas las <a href="mod/directives.html">directivas de configuracin</a>
    disponibles.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="test" id="test">Comprobar que la instalacin
funciona</a></h2>

    <p>Ahora puede <a href="invoking.html">iniciar</a> su servidor
    Apache cuando quiera ejecutando:</p>

<div class="example"><p><code>$ <em>PREFIX</em>/bin/apachectl start</code></p></div>

    <p>y entonces debe poder acceder al documento que tenga
    especificado por defecto usando el siguiente URL:
    <code>http://localhost/</code>. El documento que ver
    estar en <code class="directive"><a href="./mod/core.html#documentroot">DocumentRoot</a></code> y
    casi siempre estar en <code><em>PREFIX</em>/htdocs/</code>.
    Si quiere <a href="stopping.html">parar</a> el servidor, puede
    hacerlo ejecutando:</p>

<div class="example"><p><code>$ <em>PREFIX</em>/bin/apachectl stop</code></p></div>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="upgrading" id="upgrading">Actualizar una instalacin
prrevia</a></h2>

    <p>El primer paso para actualizar una instalacin anterior es
    leer las especificaciones de la versin y el fichero
    <code>CHANGES</code> en la distribucin de cdigo fuente
    que ha descargado para encontrar los cambios que puedan afectar a
    su instalacin actual. Cuando el cambio sea entre versiones
    mayores (por ejemplo, de la 1.3 a la 2.0 o de la 2.0 a la 2.2),
    entonces es ms probable que haya diferencias importantes en
    la compilacin y en la ejecucin que necesitarn
    ajustes manuales. Todos los mdulos necesitarn
    tambin ser actualizados para adaptarse a los cambios en el
    interfaz de programacin (API) de mdulos.</p>

    <p>La actualizacin cuando el cambio es entre versiones
    menores (por ejemplo, de la 2.0.55 a la 2.0.57) es ms
    fcil.  El proceso <code>make install</code> no
    sobreescribir ninguno de los documentos existentes, archivos
    log, o archivos de configuracin.  Adems, los
    desarrolladores hacen todos los esfuerzos posibles para evitar
    cambios que generen incompatibilidades en las opciones de
    <code>configure</code>, en la configuracin de la
    ejecucin o en la interfaz de programacin de
    mdulos. En la mayor parte de los casos debe poder usar un
    comando <code>configure</code> idntico, un fichero de
    configuracin idntico, y todos sus mdulos deben
    seguir funcionando.  (Esto es vlido solo para versiones
    posteriores a la 2.0.41; las versiones anteriores contienen
    cambios incompatibles.)</p>

    <p>Si va a conservar la estructura de directorios de su anterior
    instalacin, la actualizacin es ms fcil
    incluso.  El fichero <code>config.nice</code> que est en el
    directorio raiz de la estructura de directorios antigua contiene
    exactamente el comando <code>configure</code> que usted us
    para configurar la estructura de directorios de Apache.  Entonces,
    para actualizar su instalacin de una verson a la
    siguinete, solo tiene que copiar el archivo
    <code>config.nice</code> a la estructura de directorios del
    cdigo fuente de la nueva versin, editarlo, hacer
    cualquier cambio que desee, y ejecutarlo :</p>

    <div class="example"><p><code>
    $ ./config.nice<br />
    $ make<br />
    $ make install<br />
    $ <em>PREFIX</em>/bin/apachectl stop<br />
    $ <em>PREFIX</em>/bin/apachectl start<br />
    </code></p></div>

    <div class="warning">Tenga en cuenta que antes de poner una nueva
    versin de Apache en produccin, debe siempre probarla
    antes en su entorno. Por ejemplo, puede instalar y ejecutar la
    nueva versin junto con la antigua usando un
    <code>--prefix</code> diferente y un puerto diferente (modificando
    la directiva <code class="directive"><a href="./mod/mpm_common.html#listen">Listen</a></code>)
    para comprobar que no existe ninguna incompatibilidad antes de
    hacer la actualizacin definitiva.</div>
</div></div>
<div class="bottomlang">
<p><span>Idiomas disponibles: </span><a href="./de/install.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="./en/install.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/install.html" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/install.html" hreflang="fr" rel="alternate" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/install.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/install.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 1995-2006 The Apache Software Foundation or its licensors, as applicable.<br />Licencia bajo los trminos de la <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Mdulos</a> | <a href="./mod/directives.html">Directivas</a> | <a href="./faq/">Preguntas Frecuentes</a> | <a href="./glossary.html">Glosario</a> | <a href="./sitemap.html">Mapa de este sitio web</a></p></div>
</body></html>