<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Exemples d'utilisations de VirtualHost - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.2</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.2</a> &gt; <a href="./">Serveurs virtuels</a></div><div id="page-content"><div id="preamble"><h1>Exemples d'utilisations de VirtualHost</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/vhosts/examples.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/vhosts/examples.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/vhosts/examples.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/vhosts/examples.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/vhosts/examples.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>


    <p>Le but de ce document est d'essayer de rpondre aux questions 
    les plus rpandues sur la configuration des <a href="index.html">serveurs virtuels</a>. 
    Les scnarios prsents ici se rencontrent quand plusieurs 
    serveurs Webs doivent tourner sur une seule et mme machine au 
    moyen de serveurs virtuels <a href="name-based.html">par nom</a> 
    ou <a href="ip-based.html">par IP</a>.</p>

</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#purename">Fonctionnement de plusieurs serveurs 
  virtuels par nom sur une seule adresse IP.</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#twoips">Serveurs virtuels par nom sur plus 
    d'une seule adresse IP.</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#intraextra">Servir le mme contenu sur des 
    adresses IP diffrentes (telle qu'une adresse interne et une 
    externe).</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#port">Servir diffrents sites sur diffrents 
    ports.</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ip">Hbergement virtuel bas sur IP</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ipport">Hbergements virtuels mixtes bass sur 
    les ports et sur les IP</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#mixed">Hbergements virtuels mixtes bas sur 
    les noms et sur IP</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxy">Utilisation simultane de 
    <code>Virtual_host</code> et de mod_proxy</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#default">Utilisation de serveurs virtuels 
    <code>_default_</code></a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#migrate">Migration d'un serveur virtuel 
	par nom en un serveur virtuel par IP</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#serverpath">Utilisation de la directive 
    <code>ServerPath</code></a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="purename" id="purename">Fonctionnement de plusieurs serveurs 
  virtuels par nom sur une seule adresse IP.</a></h2>

    <p>Votre serveur ne dispose que d'une seule adresse IP, et de 
    nombreux alias (CNAMES) pointent vers cette adresse dans le DNS. 
    Pour l'exemple, <code>www.example.com</code> et 
    <code>www.example.org</code> doivent tourner sur cette machine.</p>

    <div class="note"><h3>Note&nbsp;:</h3><p>La configuration de serveurs virtuels 
    sous Apache ne provoque pas leur apparition magique dans la 
    configuration du DNS. Il <em>faut</em> que leurs noms soient 
    dfinis dans le DNS, et qu'ils y soient rsolus sur l'adresse IP 
    du serveur, faute de quoi personne ne pourra visiter votre site Web. 
    Il est possible d'ajouter des entres dans le fichier 
    <code>hosts</code> pour tests locaux, mais qui ne fonctionneront 
    que sur la machine possdant ces entres.</p>
    </div>

    <div class="example"><h3>Configuration du serveur</h3><p><code>
    

    # Apache doit couter sur le port 80<br />
    Listen 80<br />
    <br />
    # Toutes les adresses IP doivent rpondre aux requtes sur les 
    # serveurs virtuels
    NameVirtualHost *:80<br />
    <br />
    &lt;VirtualHost *:80&gt;<br />
    <span class="indent">
      DocumentRoot /www/example.com<br />
      ServerName www.example1.com<br />
      <br />
      # Autres directives ici<br />
      <br />
    </span>
    &lt;/VirtualHost&gt;<br />
    <br />
    &lt;VirtualHost *:80&gt;<br />
    <span class="indent">
      DocumentRoot /www/example.org<br />
      ServerName www.example2.org<br />
      <br />
      # Autres directives ici<br />
      <br />
    </span>
    &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Les astrisques correspondent  toutes les adresses, si bien que 
    le serveur principal ne rpondra jamais  aucune requte. Comme 
    <code>www.example.com</code> se trouve en premier dans le fichier 
    de configuration, il a la plus grande priorit et peut tre vu 
    comme serveur <cite>par dfaut</cite> ou <cite>primaire</cite>&nbsp;; 
    ce qui signifie que toute requte reue ne correspondant  aucune 
    des directives <code>ServerName</code> sera servie par ce premier 
    <code>VirtualHost</code>.</p>

    <div class="note">
            <h3>Note&nbsp;:</h3>

            <p>Si vous le souhaitez, vous pouvez remplacer <code>*</code> 
            par l'adresse IP du systme. Dans ce cas, l'argument de 
            <code>VirtualHost</code> <em>doit</em> correspondre  
            l'argument de <code>NameVirtualHost</code>&nbsp;:</p>

            <div class="example"><p><code>
            NameVirtualHost 172.20.30.40<br />
						<br />
            &lt;VirtualHost 172.20.30.40&gt;<br />
 		        # etc ...
            </code></p></div>

           <p>En gnral, il est commode d'utiliser <code>*</code> sur 
           les systmes dont l'adresse IP n'est pas constante - par 
           exemple, pour des serveurs dont l'adresse IP est attribue 
           dynamiquement par le FAI, et o le DNS est gr au moyen 
           d'un DNS dynamique quelconque. Comme <code>*</code> signifie 
           <cite>n'importe quelle adresse</cite>, cette configuration 
           fonctionne sans devoir tre modifie quand l'adresse IP du 
           systme est modifie.</p>
    </div>

    <p>La configuration ci-dessus est en pratique utilise dans la 
    plupart des cas pour les serveurs virtuels par nom. En fait, le 
    seul cas o cette configuration ne fonctionne pas est lorsque 
    diffrents contenus doivent tre servis en fonction de l'adresse IP 
    et du port contacts par le client.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="twoips" id="twoips">Serveurs virtuels par nom sur plus 
    d'une seule adresse IP.</a></h2>

  	<div class="note">
          <h3>Note&nbsp;:</h3><p>Toutes les techniques prsentes ici 
          peuvent tre tendues  un plus grand nombre d'adresses IP.</p>
    </div>

    <p>Le serveur a deux adresses IP. Sur l'une 
    (<code>172.20.30.40</code>), le serveur "principal" 
    <code>server.domain.com</code> doit rpondre, et sur l'autre 
    (<code>172.20.30.50</code>), deux serveurs virtuels (ou plus) 
    rpondront.</p>

    <div class="example"><h3>Configuration du serveur</h3><p><code>
    

    Listen 80<br />
        <br />
    # Serveur "principal" sur 172.20.30.40<br />
    ServerName server.domain.com<br />
    DocumentRoot /www/mainserver<br />
        <br />
    # l'autre adresse <br />
    NameVirtualHost 172.20.30.50<br />
        <br />
    &lt;VirtualHost 172.20.30.50&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.com<br />
        ServerName www.example.com<br />
   	        <br />
        # D'autres directives ici ...<br />
                   <br />
    </span>
    &lt;/VirtualHost&gt;<br />
        <br />
    &lt;VirtualHost 172.20.30.50&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.org<br />
        ServerName www.example.org<br />
                <br />
        # D'autres directives ici ...<br />
                <br />
    </span>
    &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Toute requte arrivant sur une autre adresse que 
    <code>172.20.30.50</code> sera servie par le serveur principal. 
    Les requtes vers <code>172.20.30.50</code> avec un nom de serveur 
    inconnu, ou sans en-tte <code>Host:</code>, seront servies par 
    <code>www.example.com</code>.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="intraextra" id="intraextra">Servir le mme contenu sur des 
    adresses IP diffrentes (telle qu'une adresse interne et une 
    externe).</a></h2>

    <p>La machine serveur dispose de deux adresses IP 
    (<code>192.168.1.1</code> et <code>172.20.30.40</code>). Cette 
    machine est place  la fois sur le rseau interne (l'Intranet) 
    et le rseau externe (Internet). Sur Internet, le nom 
    <code>server.example.com</code> pointe vers l'adresse externe 
    (<code>172.20.30.40</code>), mais sur le rseau interne, ce mme 
    nom pointe vers l'adresse interne (<code>192.168.1.1</code>).</p>

    <p>Le serveur peut tre configur pour rpondre de la mme manire 
    aux requtes internes et externes, au moyen d'une seule section 
    <code>VirtualHost</code>.</p>

    <div class="example"><h3>Configuration du serveur</h3><p><code>
    

    NameVirtualHost 192.168.1.1<br />
    NameVirtualHost 172.20.30.40<br />
        <br />
    &lt;VirtualHost 192.168.1.1 172.20.30.40&gt;<br />
    <span class="indent">
        DocumentRoot /www/server1<br />
        ServerName server.example.com<br />
        ServerAlias server<br />
    </span>
    &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Ainsi, les requtes en provenance de chacun des deux rseaux 
    seront servies par le mme <code>VirtualHost</code>.</p>

    <div class="note">
          <h3>Note&nbsp;:</h3><p>Sur le rseau interne, il est possible 
          d'utiliser le nom raccourci <code>server</code> au lieu du nom 
          complet <code>server.example.com</code>.</p>

          <p>Notez galement que dans l'exemple prcdent, vous pouvez 
          remplacer la liste des adresses IP par des <code>*</code> afin 
          que le serveur rponde de la mme manire sur toutes ses 
          adresses.</p>
    </div>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="port" id="port">Servir diffrents sites sur diffrents 
    ports.</a></h2>

    <p>Vous disposez de plusieurs domaines pointant sur la mme adresse 
    IP et vous voulez galement servir de multiples ports. Vous y 
    parviendrez en dfinissant les ports dans la directive 
    "NameVirtualHost". Si vous tentez d'utiliser &lt;VirtualHost 
    name:port&gt; sans directive NameVirtualHost name:port, ou tentez 
    d'utiliser la directive Listen, votre configuration ne fonctionnera 
    pas.</p>

    <div class="example"><h3>Configuration du serveur</h3><p><code>
    

    Listen 80<br />
    Listen 8080<br />
		<br />
    NameVirtualHost 172.20.30.40:80<br />
    NameVirtualHost 172.20.30.40:8080<br />
		<br />
    &lt;VirtualHost 172.20.30.40:80&gt;<br />
    <span class="indent">
        ServerName www.example.com<br />
        DocumentRoot /www/domain-80<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.40:8080&gt;<br />
    <span class="indent">
        ServerName www.example.com<br />
        DocumentRoot /www/domain-8080<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.40:80&gt;<br />
    <span class="indent">
        ServerName www.example.org<br />
        DocumentRoot /www/otherdomain-80<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.40:8080&gt;<br />
    <span class="indent">
        ServerName www.example.org<br />
        DocumentRoot /www/otherdomain-8080<br />
    </span>
    &lt;/VirtualHost&gt;
    </code></p></div>

	</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="ip" id="ip">Hbergement virtuel bas sur IP</a></h2>

    <p>Le serveur dispose de deux adresses IP (<code>172.20.30.40</code> 
    et <code>172.20.30.50</code>) correspondant respectivement aux noms 
    <code>www.example.com</code> et <code>www.example.org</code>.</p>

    <div class="example"><h3>Configuration du serveur</h3><p><code>
    

    Listen 80<br />
		<br />
    &lt;VirtualHost 172.20.30.40&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.com<br />
        ServerName www.example1.com<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.50&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.org<br />
        ServerName www.example2.org<br />
    </span>
    &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Les requtes provenant d'adresses non spcifies dans l'une des 
    directives <code>&lt;VirtualHost&gt;</code> (comme pour 
    <code>localhost</code> par exemple) seront diriges vers le serveur 
    principal, s'il en existe un.</p>

	</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="ipport" id="ipport">Hbergements virtuels mixtes bass sur 
    les ports et sur les IP</a></h2>

    <p>Le serveur dispose de deux adresses IP (<code>172.20.30.40</code> 
    et <code>172.20.30.50</code>) correspondant respectivement aux noms 
    <code>www.example.com</code> et <code>www.example.org</code>. 
    Pour chacun d'eux, nous voulons un hbergement sur les ports 80 
    et 8080.</p>

    <div class="example"><h3>Configuration du serveur</h3><p><code>
    

    Listen 172.20.30.40:80<br />
    Listen 172.20.30.40:8080<br />
    Listen 172.20.30.50:80<br />
    Listen 172.20.30.50:8080<br />
		<br />
    &lt;VirtualHost 172.20.30.40:80&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.com-80<br />
        ServerName www.example.com<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.40:8080&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.com-8080<br />
        ServerName www.example.com<br />
		</span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.50:80&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.org-80<br />
        ServerName www.example.org<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.50:8080&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.org-8080<br />
        ServerName www.example.org<br />
    </span>
    &lt;/VirtualHost&gt;
    </code></p></div>

	</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="mixed" id="mixed">Hbergements virtuels mixtes bas sur 
    les noms et sur IP</a></h2>

    <p>Pour certaines adresses, des serveurs virtuels seront dfinis 
    par nom, et pour d'autres, ils seront dfinis par IP.</p>

    <div class="example"><h3>Configuration du serveur</h3><p><code>
    

    Listen 80<br />
		<br />
    NameVirtualHost 172.20.30.40<br />
		<br />
    &lt;VirtualHost 172.20.30.40&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.com<br />
        ServerName www.example.com<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.40&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.org<br />
        ServerName www.example.org<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.40&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.net<br />
        ServerName www.example.net<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    # "par-IP"<br />
    &lt;VirtualHost 172.20.30.50&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.edu<br />
        ServerName www.example.edu<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.60&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.gov<br />
        ServerName www.example.gov<br />
    </span>
    &lt;/VirtualHost&gt;
    </code></p></div>

	</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="proxy" id="proxy">Utilisation simultane de 
    <code>Virtual_host</code> et de mod_proxy</a></h2>

    <p>L'exemple suivant montre comment une machine peut mandater 
    un serveur virtuel fonctionnant sur le serveur d'une autre machine. 
    Dans cet exemple, un serveur virtuel de mme nom est configur sur 
    une machine  l'adresse <code>192.168.111.2</code>. La directive 
    <code class="directive"><a href="../mod/mod_proxy.html#proxypreservehost on">ProxyPreserveHost On</a></code> est 
    employe pour permette au nom de domaine d'tre prserv lors du 
    transfert, au cas o plusieurs noms de domaines cohabitent sur 
    une mme machine.</p>

    <div class="example"><p><code>
    &lt;VirtualHost *:*&gt;<br />
        ProxyPreserveHost On<br />
        ProxyPass / http://192.168.111.2<br />
        ProxyPassReverse / http://192.168.111.2/<br />
        ServerName hostname.example.com<br />
    &lt;/VirtualHost&gt;
    </code></p></div>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="default" id="default">Utilisation de serveurs virtuels 
    <code>_default_</code></a></h2>

    <h3><a name="defaultallports" id="defaultallports">Serveurs virtuels 
    <code>_default_</code> pour tous les ports</a></h3>

    <p>Exemple de capture de <em>toutes</em> les requtes manant 
    d'adresses IP ou de ports non connus, <em>c'est--dire</em>, d'un 
    couple adresse/port non trait par aucun autre serveur virtuel.</p>

    <div class="example"><h3>Configuration du serveur</h3><p><code>
    

    &lt;VirtualHost _default_:*&gt;<br />
    <span class="indent">
        DocumentRoot /www/default<br />
    </span>
    &lt;/VirtualHost&gt;
    </code></p></div>

    <p>L'utilisation d'un tel serveur virtuel avec un joker pour le 
    port empche de manire efficace qu'une requte n'atteigne le 
    serveur principal.</p>

    <p>Un serveur virtuel par dfaut ne servira jamais une requte 
    qui est envoye vers un couple adresse/port utilise par un 
    serveur virtuel par nom. Si la requte contient un en-tte 
    <code>Host:</code> inconnu, ou si celui-ci est absent, elle 
    sera toujours servie par le serveur virtuel primaire par nom 
    (celui correspondant  ce couple adresse/port trouv en premier 
    dans le fichier de configuration).</p>

    <p>Vous pouvez utiliser une directive 
    <code class="directive"><a href="../mod/mod_alias.html#aliasmatch">AliasMatch</a></code> ou 
    <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> afin de 
    rcrire une requte pour une unique page d'information (ou pour 
    un script).</p>
    

    <h3><a name="defaultdifferentports" id="defaultdifferentports">Serveurs virtuels 
    <code>_default_</code> pour des ports diffrents</a></h3>

    <p>La configuration est similaire  l'exemple prcdent, mais 
    le serveur coute sur plusieurs ports et un second serveur virtuel 
    <code>_default_</code> pour le port 80 est ajout.</p>

    <div class="example"><h3>Configuration du serveur</h3><p><code>
    

    &lt;VirtualHost _default_:80&gt;<br />
    <span class="indent">
        DocumentRoot /www/default80<br />
        # ...<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost _default_:*&gt;<br />
    <span class="indent">
        DocumentRoot /www/default<br />
        # ...<br />
    </span>
    &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Le serveur virtuel par dfaut dfini pour le port 80 (il doit 
    imprativement tre plac avant un autre serveur virtuel par 
    dfaut traitant tous les ports grce au joker *) capture toutes 
    les requtes envoyes sur une adresse IP non spcifie. Le 
    serveur principal n'est jamais utilis pour servir une requte.</p>
    

    <h3><a name="defaultoneport" id="defaultoneport">Serveurs virtuels 
    <code>_default_</code> pour un seul port</a></h3>

    <p>Nous voulons crer un serveur virtuel par dfaut seulement 
    pour le port 80.</p>

    <div class="example"><h3>Configuration du serveur</h3><p><code>
    

    &lt;VirtualHost _default_:80&gt;<br />
    DocumentRoot /www/default<br />
    ...<br />
    &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Une requte vers une adresse non spcifie sur le port 80 
    sera servie par le serveur virtuel par dfaut, et toute autre 
    requte vers une adresse et un port non spcifis sera servie 
    par le serveur principal.</p>
    

	</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="migrate" id="migrate">Migration d'un serveur virtuel 
	par nom en un serveur virtuel par IP</a></h2>

    <p>Le serveur virtuel par nom avec le nom de domaine 
    <code>www.example.org</code> (de notre <a href="#name">exemple 
    par nom</a>) devrait obtenir sa propre adresse IP. Pendant la 
    phase de migration, il est possible d'viter les problmes avec 
    les noms de serveurs et autres serveurs mandataires qui mmorisent 
    les vielles adresses IP pour les serveurs virtuels par nom.<br />
    La solution est simple, car il suffit d'ajouter la nouvelle 
    adresse IP (<code>172.20.30.50</code>) dans la directive 
    <code>VirtualHost</code>.</p>

    <div class="example"><h3>Configuration du serveur</h3><p><code>
    

    Listen 80<br />
    ServerName www.example.com<br />
    DocumentRoot /www/example.com<br />
		<br />
    NameVirtualHost 172.20.30.40<br />
		<br />
    &lt;VirtualHost 172.20.30.40 172.20.30.50&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.org<br />
        ServerName www.example.org<br />
        # ...<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.40&gt;<br />
    <span class="indent">
        DocumentRoot /www/example.net<br />
        ServerName www.example.net<br />
        ServerAlias *.example.net<br />
        # ...<br />
    </span>
    &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Le serveur virtuel peut maintenant tre joint par la nouvelle 
    adresse (comme un serveur virtuel par IP) et par l'ancienne 
    adresse (comme un serveur virtuel par nom).</p>

	</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="serverpath" id="serverpath">Utilisation de la directive 
    <code>ServerPath</code></a></h2>

    <p>Dans le cas o vous disposez de deux serveurs virtuels par nom, 
    le client doit transmettre un en-tte <code>Host:</code> correct 
    pour dterminer le serveur concern. Les vieux clients HTTP/1.0 
    n'envoient pas un tel en-tte et Apache n'a aucun indice pour 
    connatre le serveur virtuel devant tre joint (il sert la 
    requte  partir d'un serveur virtuel primaire). Dans un soucis 
    de prserver la compatibilit descendante, il suffit de crer 
    un serveur virtuel primaire charg de retourner une page contenant 
    des liens dont les URLs auront un prfixe identifiant les serveurs 
    virtuels par nom.</p>

    <div class="example"><h3>Configuration du serveur</h3><p><code>
    

    NameVirtualHost 172.20.30.40<br />
		<br />
    &lt;VirtualHost 172.20.30.40&gt;<br />
    <span class="indent">
        # Serveur virtuel primaire<br />
        DocumentRoot /www/subdomain<br />
        RewriteEngine On<br />
        RewriteRule ^/.* /www/subdomain/index.html<br />
        # ...<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.40&gt;<br />
    DocumentRoot /www/subdomain/sub1<br />
    <span class="indent">
        ServerName www.sub1.domain.tld<br />
        ServerPath /sub1/<br />
        RewriteEngine On<br />
        RewriteRule ^(/sub1/.*) /www/subdomain$1<br />
        # ...<br />
    </span>
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 172.20.30.40&gt;<br />
    <span class="indent">
        DocumentRoot /www/subdomain/sub2<br />
        ServerName www.sub2.domain.tld<br />
        ServerPath /sub2/<br />
        RewriteEngine On<br />
        RewriteRule ^(/sub2/.*) /www/subdomain$1<br />
        # ...<br />
    </span>
    &lt;/VirtualHost&gt;
    </code></p></div>

    <p> cause de la directive 
    <code class="directive"><a href="../mod/core.html#serverpath">ServerPath</a></code>, une requte sur 
    une URL <code>http://www.sub1.domain.tld/sub1/</code> est 
    <em>toujours</em> servie par le serveur sub1-vhost.<br />
    Une requte sur une URL <code>http://www.sub1.domain.tld/</code> n'est 
    servie par le serveur sub1-vhost que si le client envoie un en-tte 
    <code>Host:</code> correct. Si aucun en-tte <code>Host:</code> 
    n'est transmis, le serveur primaire sera utilis.</p>
    <p>Notez qu'il y a une singularit&nbsp;: une requte sur 
    <code>http://www.sub2.domain.tld/sub1/</code> est galement servie 
    par le serveur sub1-vhost si le client n'envoie pas d'en-tte 
    <code>Host:</code>.</p>
    <p>Les directives <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> 
    sont employes pour s'assurer que le client qui envoie un en-tte 
    <code>Host:</code> correct puisse utiliser d'autres variantes d'URLs, 
    <em>c'est--dire</em> avec ou sans prfixe d'URL.</p>

	</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/vhosts/examples.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/vhosts/examples.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/vhosts/examples.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/vhosts/examples.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/vhosts/examples.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2011 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>