<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_autoindex - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.2</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.2</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_autoindex</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_autoindex.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_autoindex.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_autoindex.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_autoindex.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/mod/mod_autoindex.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Gnre automatiquement des index de rpertoires d'une
manire similaire  la commande Unix <code>ls</code>, ou  la commande
shell Win32 <code>dir</code></td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>autoindex_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_autoindex.c</td></tr></table>
<h3>Sommaire</h3>

      <p>L'index d'un rpertoire peut tre gnr de deux manires :</p>

    <ul>
      <li>Un fichier crit par l'utilisateur, en gnral appel
      <code>index.html</code>, mais dont le nom peut tre dfini par la
      directive <code class="directive"><a href="../mod/mod_dir.html#directoryindex">DirectoryIndex</a></code>. C'est le module
      <code class="module"><a href="../mod/mod_dir.html">mod_dir</a></code> qui traite alors cet index.</li>

      <li>Un listing gnr par le serveur, dont le format est contrl
      par un certain nombre de directives. Les directives <code class="directive"><a href="#addicon">AddIcon</a></code>, <code class="directive"><a href="#addiconbyencoding">AddIconByEncoding</a></code> et <code class="directive"><a href="#addiconbytype">AddIconByType</a></code> permettent de
      dfinir une liste d'icnes  afficher en fonction des diffrents
      types de fichiers ; pour chaque fichier list, le premier icne
      qui correspond au type du fichier est affich. C'est le module
      <code class="module"><a href="../mod/mod_autoindex.html">mod_autoindex</a></code> qui traite alors cet index.</li>
    </ul>
    <p>Les deux fonctions sont spares, si bien que vous pouvez
    entirement supprimer (ou remplacer) la gnration automatique
    d'index, si vous le souhaitez.</p>

    <p>On active la gnration automatique d'index en spcifiant
    <code>Options +Indexes</code>. Voir la directive <code class="directive"><a href="../mod/core.html#options">Options</a></code> pour plus de dtails.</p>

    <p>Si la directive <code class="directive"><a href="#indexoptions">IndexOptions</a></code> est spcifie avec
    l'option <code><a href="#indexoptions.fancyindexing">FancyIndexing</a></code>, les en-ttes de colonnes sont des liens
    qui permettent de contrler l'ordre de tri de l'affichage. Si vous
    actionnez le lien d'un en-tte, le listing sera gnr  nouveau,
    tri en fonction des valeurs de la colonne concerne. Si l'on
    actionne de manire rptitive le mme en-tte, l'ordre de tri est
    commut entre les ordres croissant et dcroissant. On peut supprimer
    ces liens d'en-ttes de colonnes  l'aide de l'option
    <code>SuppressColumnSorting</code> de la directive <code class="directive"><a href="#indexoptions">IndexOptions</a></code>.</p>

    <p>Notez que lorsque l'affichage est tri en fonction de la taille,
    c'est la taille <em>relle</em> qui est prise en compte, et non la
    valeur affiche - ainsi, un fichier de 1010 octets sera toujours
    affich avant un fichier de 1011 octets (en ordre croissant), mme
    si la taille affiche des deux fichiers est "1K".</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#addalt">AddAlt</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#addaltbyencoding">AddAltByEncoding</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#addaltbytype">AddAltByType</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#adddescription">AddDescription</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#addicon">AddIcon</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#addiconbyencoding">AddIconByEncoding</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#addiconbytype">AddIconByType</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#defaulticon">DefaultIcon</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#headername">HeaderName</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#indexheadinsert">IndexHeadInsert</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#indexignore">IndexIgnore</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#indexoptions">IndexOptions</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#indexorderdefault">IndexOrderDefault</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#indexstylesheet">IndexStyleSheet</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#readmename">ReadmeName</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#query">Arguments de la requte d'autoindexation</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="query" id="query">Arguments de la requte d'autoindexation</a></h2>
    

    <p>Apache 2.0.23 a rorganis les arguments de requte pour le tri
    des colonnes, et intoduit un groupe complet de nouvelles options de
    requte. Pour interdire effectivement au client tout contrle sur
    l'affichage, l'option <code><a href="#indexoptions.ignoreclient">IndexOptions
    IgnoreClient</a></code> a t ajoute.</p>

    <p>Les en-ttes de tri des colonnes eux-mmes sont des hyper-liens
    auto-rfrant qui ajoutent les options de tri  la requte numres
    ci-dessous qui peuvent tre ajoutes  toute requte concernant la
    ressource rpertoire.</p>

    <ul>
      <li><code>C=N</code> trie l'affichage en fonction du nom de
      fichier</li>

      <li><code>C=M</code> trie l'affichage en fonction de la date de
      dernire modification, puis du nom de fichier</li>

      <li><code>C=S</code> trie l'affichage en fonction de la taille,
      puis du nom de fichier</li>

      <li class="separate"><code>C=D</code> trie l'affichage en fonction
      de la description, puis du nom de fichier</li>

      <li><code>O=A</code> trie l'affichage selon l'ordre croissant</li>

      <li class="separate"><code>O=D</code> trie l'affichage selon
      l'ordre dcroissant</li>

      <li><code>F=0</code> affiche le listing sous la forme d'une simple
      liste (not FancyIndexed)</li>

      <li><code>F=1</code> affiche le listing avec en-ttes de colonnes
      sous forme de liens hyper-textes (FancyIndexed)</li>

      <li class="separate"><code>F=2</code> affiche le listing sous
      forme de table HTML avec en-ttes de colonnes contenant des liens
      hyper-textes (FancyIndexed)</li>

      <li><code>V=0</code> dsactive le tri en fonction de la
      version</li>

      <li class="separate"><code>V=1</code> active le tri en fonction de
      la version</li>

      <li><code>P=<var>modle</var></code> n'affiche que les fichiers
      correspondant au <var>modle</var> spcifi</li>
    </ul>

    <p>Notez que l'argument 'P' (pour Pattern) n'est test
    qu'<em>aprs</em> que les directives habituelles <code class="directive"><a href="#indexignore">IndexIgnore</a></code> n'aient t traites,
    et que tous les noms de fichiers sont encore assujettis aux mmes
    critres que pour tout autre listing auto-index. L'interprteur
    d'arguments de requte de <code class="module"><a href="../mod/mod_autoindex.html">mod_autoindex</a></code> s'arrte
    immdiatement s'il rencontre une option non reconnue. Les arguments
    de requte doivent tre bien forms, selon la table ci-dessus.</p>

    <p>Les options de requtes sont illustres par l'exemple ci-dessous,
    qui peut tre copi et coll dans un fichier header.html. Notez que
    l'argument inconnu "X", pour le bouton submit, est introduit en
    dernier afin de s'assurer que tous les arguments aient t
    interprts avant que mod_autoindex ne rencontre l'entre X=Go.</p>

    <div class="example"><p><code>
      &lt;form action="" method="get"&gt;<br />
      <span class="indent">
        Montre moi une &lt;select name="F"&gt;<br />
        <span class="indent">
          &lt;option value="0"&gt; simple liste&lt;/option&gt;<br />
          &lt;option value="1" selected="selected"&gt; liste avec
	  en-ttes&lt;/option&gt;<br />
          &lt;option value="2"&gt; liste avec en-tte sous forme de
	  table&lt;/option&gt;<br />
        </span>
        &lt;/select&gt;<br />
        trie par &lt;select name="C"&gt;<br />
        <span class="indent">
          &lt;option value="N" selected="selected"&gt; nom&lt;/option&gt;<br />
          &lt;option value="M"&gt; date de modification&lt;/option&gt;<br />
          &lt;option value="S"&gt; taille&lt;/option&gt;<br />
          &lt;option value="D"&gt; description&lt;/option&gt;<br />
        </span>
        &lt;/select&gt;<br />
        &lt;select name="O"&gt;<br />
        <span class="indent">
          &lt;option value="A" selected="selected"&gt; croissant&lt;/option&gt;<br />
          &lt;option value="D"&gt; dcroissant&lt;/option&gt;<br />
        </span>
        &lt;/select&gt;<br />
        &lt;select name="V"&gt;<br />
        <span class="indent">
          &lt;option value="0" selected="selected"&gt; dans l'ordre
	  normal&lt;/option&gt;<br />
          &lt;option value="1"&gt; en fonction de la version&lt;/option&gt;<br />
        </span>
        &lt;/select&gt;<br />
        correspondant  &lt;input type="text" name="P" value="*" /&gt;<br />
        &lt;input type="submit" name="X" value="Go" /&gt;<br />
      </span>
      &lt;/form&gt;
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AddAlt" id="AddAlt">AddAlt</a> <a name="addalt" id="addalt">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Texte optionnel  afficher  la place d'un icne pour un
fichier en fonction de son nom</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddAlt <var>texte</var> <var>fichier</var> [<var>fichier</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>La directive <code class="directive">AddAlt</code> permet d'afficher un
    texte optionnel pour un fichier,  la place d'un icne, dans le cas
    d'un affichage <code><a href="#indexoptions.fancyindexing">FancyIndexing</a></code>.
    <var>fichier</var> est une extension de fichier, un nom de fichier
    partiel, une expression avec caractres gnriques o un nom de
    fichier complet permettant de caractriser le(s) fichier(s)
    concern(s). Si <var>texte</var> contient des espaces, vous devez
    l'entourer de guillemets ou d'apostrophes (<code>"</code> ou
    <code>'</code>). Ce texte optionnel sera affich si le client ne
    peut pas afficher d'images, si le chargement d'images est dsactiv
    ou si l'icne ne peut pas tre trouv.</p>

    <div class="example"><h3>Exemples</h3><p><code>
      AddAlt "Fichier PDF" *.pdf<br />
      AddAlt Compress *.gz *.zip *.Z
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AddAltByEncoding" id="AddAltByEncoding">AddAltByEncoding</a> <a name="addaltbyencoding" id="addaltbyencoding">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Texte optionnel  afficher  la place d'un icne pour un
fichier en fonction de son codage MIME</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddAltByEncoding <var>texte</var> <var>codage MIME</var>
[<var>codage MIME</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>La directive <code class="directive">AddAltByEncoding</code> permet
    d'afficher un texte optionnel  la place d'un icne pour un fichier
    dans le cas d'un affichage <code><a href="#indexoptions.fancyindexing">FancyIndexing</a></code>.
    <var>codage MIME</var> doit tre un type valide, comme
    <code>x-compress</code>. Si <var>texte</var> contient des espaces,
    vous devez l'entourer de guillemets ou d'apostrophes (<code>"</code>
    ou <code>'</code>). Ce texte optionnel sera affich si le client ne
    peut pas afficher d'images, si le chargement d'images est dsactiv
    ou si l'icne ne peut pas tre trouv.</p>

    <div class="example"><h3>Exemple</h3><p><code>
      AddAltByEncoding gzip x-gzip
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AddAltByType" id="AddAltByType">AddAltByType</a> <a name="addaltbytype" id="addaltbytype">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Texte optionnel  afficher  la place d'un icne pour un
fichier en fonction de son type MIME</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddAltByType <var>texte</var> <var>type MIME</var>
[<var>type MIME</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>La directive <code class="directive">AddAltByType</code> permet
    d'afficher un texte optionnel  la place d'un icne pour un fichier
    dans le cas d'un affichage <code><a href="#indexoptions.fancyindexing">FancyIndexing</a></code>.
    <var>type MIME</var> doit tre un type MIME valide, comme
    <code>text/html</code>. Si <var>texte</var> contient des espaces,
    vous devez l'entourer de guillemets ou d'apostrophes (<code>"</code>
    ou <code>'</code>). Ce texte optionnel sera affich si le client ne
    peut pas afficher d'images, si le chargement d'images est dsactiv
    ou si l'icne ne peut pas tre trouv.</p>

    <div class="example"><h3>Exemple</h3><p><code>
      AddAltByType 'Fichier texte' text/plain
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AddDescription" id="AddDescription">AddDescription</a> <a name="adddescription" id="adddescription">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Afficher la description d'un fichier</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddDescription <var>texte</var> [<var>fichier</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>Cette directive permet d'afficher une description pour un
    fichier, dans le cas d'un affichage <code><a href="#indexoptions.fancyindexing">FancyIndexing</a></code>.
    <var>fichier</var> est une extension de fichier, un nom de fichier
    partiel, une expression avec caractres gnriques ou un nom de
    fichier complet permettant de caractriser le fichier.
    <var>texte</var> doit tre entour de guillemets
    (<code>"</code>).</p>

    <div class="example"><h3>Exemple</h3><p><code>
      AddDescription "La plante Mars" /web/pics/mars.gif
    </code></p></div>

    <p>La taille par dfaut, habituelle du champ de description est de
    23 octets. L'option <code><a href="#indexoptions.suppressicon">IndexOptions SuppressIcon</a></code> ajoute 6 octets, l'option
    <code><a href="#indexoptions.suppresssize">IndexOptions
    SuppressSize</a></code> en ajoute 7 et l'option <code><a href="#indexoptions.suppresslastmodified">IndexOptions
    SuppressLastModified</a></code> en ajoute 19. Ainsi, la plus grande
    taille par dfaut qui peut tre assigne  la colonne description
    est de 55 octets.</p>

    <p>Voir le mot-cl <a href="#indexoptions.descriptionwidth">DescriptionWidth</a> de la directive <code class="directive">module="mod_autoindex"&gt;IndexOptions</code> pour plus de
    dtails sur la manire d'augmenter la taille de cette colonne, ou
    pour permettre des descriptions de taille illimite.</p>

    <div class="note"><h3>Avertissement</h3>
      <p>Le texte descriptif dfini par la directive
      <code class="directive">AddDescription</code> peut contenir des marquages
      HTML, comme des balises ou des entits caractres. Si la limite de
      taille de la colonne description venait  tronquer une balise (par
      exemple couper la fin d'une phrase en caractres gras), le
      rsultat pourrait en affecter toute la suite du listing du
      rpertoire.</p>
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AddIcon" id="AddIcon">AddIcon</a> <a name="addicon" id="addicon">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Icne  afficher pour un fichier en fonction de son
nom</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddIcon <var>icne</var> <var>nom</var> [<var>nom</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>Cette directive permet de dterminer l'icne  afficher  ct
    d'un fichier dont le nom se termine par <var>nom</var>, dans le cas
    d'un affichage <code><a href="#indexoptions.fancyindexing">FancyIndexing</a></code>. <var>icne</var> est une URL relative
    (chappe par des caractres '%') vers
    l'icne, une URL pleinement qualifie, ou de la forme
    <code>(<var>alttext</var>,<var>url</var>)</code>, o
    <var>alttext</var> est le symbole texte correspondant  l'icne 
    afficher dans les navigateurs en mode texte.</p>

    <p><var>nom</var> correspond  <code>^^DIRECTORY^^</code> pour les
    rpertoires, <code>^^BLANKICON^^</code> pour les lignes vides
    (pour personnaliser la prsentation du listing), une extension de
    fichier, une expression avec caractres gnriques, un nom de
    fichier partiel ou un nom de fichier complet.</p>

    <p><code>^^BLANKICON^^</code> n'est utilis que pour le formatage,
    et n'est donc pas ncessaire si vous utilisez <code>IndexOptions
    HTMLTable</code>.</p>

    <div class="example"><h3>Exemples</h3><p><code>
      AddIcon (IMG,/icons/image.xbm) .gif .jpg .xbm<br />
      AddIcon /icons/dir.xbm ^^DIRECTORY^^<br />
      AddIcon /icons/backup.xbm *~
    </code></p></div>

    <p>Lorsque c'est possible, il est prfrable d'utiliser <code class="directive"><a href="#addiconbytype">AddIconByType</a></code> plutt que
    <code class="directive">AddIcon</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AddIconByEncoding" id="AddIconByEncoding">AddIconByEncoding</a> <a name="addiconbyencoding" id="addiconbyencoding">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Icne  afficher  ct d'un fichier en fonction de son
codage MIME</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddIconByEncoding <var>icne</var> <var>codage MIME</var>
[<var>codage MIME</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>Cette directive permet de dterminer l'icne  afficher  ct
    d'un fichier dans le cas d'un affichage <code><a href="#indexoptions.fancyindexing">FancyIndexing</a></code>.
    <var>icne</var> est une URL relative
    (chappe par des caractres '%') vers
    l'icne, une URL pleinement qualifie, ou de la forme
    <code>(<var>alttext</var>,<var>url</var>)</code>, o
    <var>alttext</var> est le symbole texte correspondant  l'icne 
    afficher dans les navigateurs en mode texte.</p>

    <p><var>codage MIME</var> doit tre un codage valide, comme
    <code>x-compress</code>.</p>

    <div class="example"><h3>Exemple</h3><p><code>
      AddIconByEncoding /icons/compress.xbm x-compress
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="AddIconByType" id="AddIconByType">AddIconByType</a> <a name="addiconbytype" id="addiconbytype">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Icne  afficher  ct d'un fichier en fonction de son
type MIME</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AddIconByType <var>icne</var> <var>type MIME</var>
[<var>type MIME</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>Cette directive permet de dterminer l'icne  afficher  ct
    d'un fichier de type MIME <var>type MIME</var> dans le cas d'un
    affichage <code><a href="#indexoptions.fancyindexing">FancyIndexing</a></code>.
    <var>icne</var> est une URL relative
    (chappe par des caractres '%') vers
    l'icne, une URL pleinement qualifie, ou de la forme
    <code>(<var>alttext</var>,<var>url</var>)</code>, o
    <var>alttext</var> est le symbole texte correspondant  l'icne 
    afficher dans les navigateurs en mode texte.</p>

    <p><var>type MIME</var> est une expression avec caractres
    gnriques reprsentant le type MIME.</p>

    <div class="example"><h3>Exemple</h3><p><code>
      AddIconByType (IMG,/icons/image.xbm) image/*
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="DefaultIcon" id="DefaultIcon">DefaultIcon</a> <a name="defaulticon" id="defaulticon">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Icne  afficher par dfaut lorsqu'aucun icne spcifique
n'est prcis</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>DefaultIcon <var>chemin URL</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>La directive <code class="directive">DefaultIcon</code> permet de dfinir
    l'icne  afficher  ct d'un fichier lorsqu'aucun icne spcifique
    n'a t prcis, dans le cas d'un affichage <code><a href="#indexoptions.fancyindexing">FancyIndexing</a></code>.
    <var>chemin URL</var> est une URL relative (chappe par des
    caractres '%') vers l'icne,ou une URL pleinement qualifie.</p>

    <div class="example"><h3>Exemple</h3><p><code>
      DefaultIcon /icon/inconnu.xbm
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="HeaderName" id="HeaderName">HeaderName</a> <a name="headername" id="headername">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nom du fichier qui sera insr au dbut de la page
contenant l'index</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>HeaderName <var>nom fichier</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>La directive <code class="directive">HeaderName</code> permet de dfinir
    le nom du fichier qui sera insr au dbut de la page contenant
    l'index. <var>nom fichier</var> est le nom du fichier  inclure.</p>

    <div class="example"><h3>Exemple</h3><p><code>
      HeaderName HEADER.html
    </code></p></div>

    <div class="note">
      <p>Les deux directives HeaderName et <code class="directive"><a href="#readmename">ReadmeName</a></code> traitent maintenant
      <var>nom fichier</var> comme un chemin URI relatif au chemin
      utilis pour accder au rpertoire faisant l'objet de l'index. Si
      <var>nom fichier</var> commence par un slash '/', il sera
      considr comme relatif au rpertoire dfini par la directive
      <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code>.</p>

      <div class="example"><h3>Exemple</h3><p><code>
        HeaderName /include/HEADER.html
      </code></p></div>

      <p><var>nom fichier</var> doit correspondre  un document dont le
      type MIME est du style <code>text/*</code> (<em>par exemple</em>
      <code>text/html</code>, <code>text/plain</code>, etc...). Cela
      signifie que <var>nom fichier</var> peut faire rfrence  un
      script CGI si le vritable type MIME du script (et non celui de sa
      sortie) est marqu comme <code>text/html</code> par exemple 
      l'aide d'une directive comme :</p>

      <div class="example"><p><code>
        AddType text/html .cgi
      </code></p></div>

      <p>Une <a href="../content-negotiation.html">ngociation de
      contenu</a> sera effectue si <code class="directive"><a href="../mod/core.html#options">Options</a></code> <code>MultiViews</code> a t
      prcis. Si <var>nom fichier</var> correspond  un document
      statique <code>text/html</code> (et non  un script CGI), et une
      des deux <code class="directive"><a href="../mod/core.html#options">options</a></code>
      <code>Includes</code> ou <code>IncludesNOEXEC</code> est active,
      le fichier sera trait en tant qu'inclusion ct serveur (Server
      Side Include) (voir la documentation de
      <code class="module"><a href="../mod/mod_include.html">mod_include</a></code>).</p>
    </div>

    <p>Si le fichier spcifi par la directive
    <code class="directive">HeaderName</code> contient les en-ttes d'un
    document HTML ((&lt;html&gt;, &lt;head&gt;, etc...), vous serez
    probablement amen  dfinir <a href="#indexoptions.suppresshtmlpreamble"><code>IndexOptions
    +SuppressHTMLPreamble</code></a>, de manire  ce que ces balises ne
    soient pas rptes.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="IndexHeadInsert" id="IndexHeadInsert">IndexHeadInsert</a> <a name="indexheadinsert" id="indexheadinsert">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Insre du texte dans la section HEAD de la page
d'index.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>IndexHeadInsert <var>"marque ..."</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.2.11
d'Apache</td></tr>
</table>
    <p>La directive <code class="directive">IndexHeadInsert</code> permet de
    spcifier une chane de caractres  insrer dans la section
    <var>&lt;head&gt;</var> du code HTML gnr pour la page
    d'index.</p>
    <div class="example"><h3>Exemple</h3><p><code>
      
      IndexHeadInsert "&lt;link rel=\"sitemap\" href=\"/sitemap.html\"&gt;"
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="IndexIgnore" id="IndexIgnore">IndexIgnore</a> <a name="indexignore" id="indexignore">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ajouts  la liste des fichiers  cacher lors de l'affichage
de l'index d'un rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>IndexIgnore <var>fichier</var> [<var>fichier</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>IndexIgnore "."</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>La directive <code class="directive">IndexIgnore</code> permet
    d'effectuer des ajouts  la liste des fichiers  cacher lors de
    l'affichage de l'index d'un rpertoire. <var>fichier</var> est une
    expression avec caractres gnriques de style shell ou un nom de
    fichier complet. Plusieurs directives IndexIgnore effectuent des
    ajouts  la liste, et ne remplacent pas la liste des fichiers 
    ignorer. Par dfaut, la liste contient <code>.</code> (le rpertoire
    courant).</p>

    <div class="example"><p><code>
      IndexIgnore .??* *~ *# HEADER* README* RCS CVS *,v *,t
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="IndexOptions" id="IndexOptions">IndexOptions</a> <a name="indexoptions" id="indexoptions">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Diverses options de configuration pour l'indexation d'un
rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>IndexOptions  [+|-]<var>option</var> [[+|-]<var>option</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Par dfaut, aucune option n'est active.</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>La directive <code class="directive">IndexOptions</code> permet de
    spcifier les options de configuration de l'indexation du
    rpertoire. <var>option</var> peut prendre l'une des valeurs
    suivantes :</p>

    <dl>
      <dt><a name="indexoptions.charset" id="indexoptions.charset">Charset=<var>jeu de caractres</var></a> (<em>Versions 2.0.61 et
      suprieures d'Apache</em>)</dt>

      <dd>Le mot-cl <code>Charset</code> vous permet de spcifier le
      jeu de caractres de la page gnre. La valeur par dfaut est
      soit <var>UTF-8</var>, <var>ISO-8859-1</var>, selon que le
      systme de fichiers sous-jacent est unicode ou non.

      <div class="example"><h3>Exemple :</h3><p><code>
        IndexOptions Charset=UTF-8
      </code></p></div>
      </dd>

      <dt><a name="indexoptions.type" id="indexoptions.type">Type=<var>type MIME</var></a> (<em>Versions 2.0.61 et
      suprieures d'Apache</em>)</dt>

      <dd>Le mot-cl <code>Type</code> vous permet de spcifier le type
      MIME de la page gnre. La valeur par dfaut est
      <var>text/html</var>.

      <div class="example"><h3>Exemple :</h3><p><code>
        IndexOptions Type=text/plain
      </code></p></div>
      </dd>

      <dt><a name="indexoptions.descriptionwidth" id="indexoptions.descriptionwidth">DescriptionWidth=[<var>n</var> | *]</a> (<em>Versions 2.0.23 et
      suprieures d'Apache</em>)</dt>

      <dd>Le mot-cl <code>DescriptionWidth</code> vous permet de
      spcifier la taille en caractres de la colonne description.</dd>

      <dd>Avec <code>-DescriptionWidth</code> (ou si l'option n'est pas
      dfinie), <code class="module"><a href="../mod/mod_autoindex.html">mod_autoindex</a></code> calcule la meilleure
      taille.</dd>

      <dd><code>DescriptionWidth=<var>n</var></code> fixe la taille de
      la colonne  <var>n</var> octets.</dd>

      <dd><code>DescriptionWidth=*</code> ajuste la taille de la colonne
       la plus longue chane de description.</dd>

      <dd><strong>Voir la section concernant <code class="directive"><a href="#adddescription">AddDescription</a></code> pour les dangers
      inhrants  la troncature des descriptions.</strong></dd>

      <dt><a name="indexoptions.fancyindexing" id="indexoptions.fancyindexing">FancyIndexing</a></dt>

      <dd>Cette option active l'indexation "amliore" des rpertoires,
      c'est  dire avec en-ttes de colonnes sous forme d'hyper-liens
      auto-rfrants.</dd>

      <dt><a name="indexoptions.foldersfirst" id="indexoptions.foldersfirst">FoldersFirst</a> (<em>Versions 2.0.23 et
      suprieures d'Apache</em>)</dt>

      <dd>Lorsque cette option est active, la liste des
      sous-rpertoires apparatra <em>toujours</em> en premier, suivie
      de la liste des fichiers normaux du rpertoire. Le listing
      comporte principalement deux parties, les fichiers et les
      sous-rpertoires, chacun d'eux tant tri sparment et les
      sous-rpertoires affichs en premier. Par exemple, si l'ordre de
      tri est dcroissant par nom, et si <code>FoldersFirst</code> est
      activ, le sous-rpertoire <code>Zed</code> sera affich avant le
      sous-rpertoire <code>Beta</code>, qui sera lui-mme affich avant
      les fichiers normaux <code>Gamma</code> et <code>Alpha</code>.
      <strong>Cette option n'a d'effet que si <a href="#indexoptions.fancyindexing"><code>FancyIndexing</code></a>
      est aussi activ.</strong></dd>

      <dt><a name="indexoptions.htmltable" id="indexoptions.htmltable">HTMLTable</a>
	       (<em>Exprimental, versions 2.0.23 et suprieures
	       d'Apache</em>)</dt>

      <dd>Cette option exprimentale pour l'affichage
      <code>FancyIndexing</code> permet de construire une table simple
      pour l'affichage de l'index du rpertoire. Notez que cela risque
      de perturber les anciens navigateurs. Cette option s'avrera
      particulirement ncessaire si les noms de fichiers ou les chanes
      de description alternent entre les ordres de lecture gauche 
      droite et droite  gauche, comme cela peut arriver sous WinNT ou
      d'autres plate-formes o utf-8 est activ.</dd>

      <dt><a name="indexoptions.iconsarelinks" id="indexoptions.iconsarelinks">IconsAreLinks</a></dt>

      <dd>Configure la partie rserve aux icnes de l'ancrage pour le
      nom de fichier, dans le cas d'un affichage "amlior".</dd>

      <dt><a name="indexoptions.iconheight" id="indexoptions.iconheight">IconHeight[=<var>pixels</var>]</a></dt>

      <dd>Si cette option est prsente, en combinaison avec
      <code>IconWidth</code>, le serveur va inclure les attributs
      <code>height</code> et <code>width</code> dans la balise
      <code>img</code> qui rfrence le fichier de l'icne. Ceci va
      permettre au navigateur de prvoir les caractristiques de la page
      sans devoir attendre que toutes les images aient t charges. En
      l'absence de cette option, c'est la hauteur standard dfinie par
      le logiciel Apache qui est choisie comme valeur par dfaut.</dd>

      <dt><a name="indexoptions.iconwidth" id="indexoptions.iconwidth">IconWidth[=<var>pixels</var>]</a></dt>

      <dd>Si cette option est prsente, en combinaison avec
      <code>IconHeight</code>, le serveur va inclure les attributs
      <code>height</code> et <code>width</code> dans la balise
      <code>img</code> qui rfrence le fichier de l'icne. Ceci va
      permettre au navigateur de prvoir les caractristiques de la page
      sans devoir attendre que toutes les images aient t charges. En
      l'absence de cette option, c'est la largeur standard dfinie par
      le logiciel Apache qui est choisie comme valeur par dfaut.</dd>

      <dt><a name="indexoptions.ignorecase" id="indexoptions.ignorecase">IgnoreCase</a></dt>

      <dd>Si cette option est active, les noms sont tris sans tenir
      compte de la casse. Par exemple, si le tri s'effectue sur les noms
      dans l'ordre croissant, et si <code>IgnoreCase</code> est activ,
      le fichier Zeta apparatra aprs le fichier alfa (Note : le
      fichier GAMMA apparatra toujours avant le fichier gamma).
      </dd>

      <dt><a name="indexoptions.ignoreclient" id="indexoptions.ignoreclient">IgnoreClient</a></dt>

      <dd>Si cette option est active, <code class="module"><a href="../mod/mod_autoindex.html">mod_autoindex</a></code> va
      ignorer toutes les variables de requte fournies par le client, y
      compris les informations de tri (ce qui implique l'activation de
      l'option <code><a href="#indexoptions.suppresscolumnsorting">SuppressColumnSorting</a></code>).</dd>

      <dt><a name="indexoptions.namewidth" id="indexoptions.namewidth">NameWidth=[<var>n</var>
               | *]</a></dt>

      <dd>Le mot-cl <code>NameWidth</code> vous permet de spcifier la
      largeur en octets de la colonne correspondant au nom du
      fichier.</dd>

      <dd>Avec <code>-NameWidth</code> (ou si l'option n'est pas
      dfinie), <code class="module"><a href="../mod/mod_autoindex.html">mod_autoindex</a></code> va calculer la meilleure largeur
      possible.</dd>

      <dd><code>NameWidth=<var>n</var></code> fixe la largeur de la
      colonne  <var>n</var> octets.</dd>

      <dd><code>NameWidth=*</code> dfinit la largeur de colonne  la
      valeur ncessaire.</dd>

      <dt><a name="indexoptions.scanhtmltitles" id="indexoptions.scanhtmltitles">ScanHTMLTitles</a></dt>

      <dd>L'activation de cette option permet d'extraire le titre des
      documents HTML dans le cas d'un affichage "amlior". Si le fichier
      ne possde aucune description dfinie par la directive <code class="directive"><a href="#adddescription">AddDescription</a></code>, httpd va lire
      le document pour tenter d'en extraire le <code>titre</code>. Ce
      processus est coteux en ressources disque et CPU.</dd>

      <dt><a name="indexoptions.showforbidden" id="indexoptions.showforbidden">ShowForbidden</a></dt>

      <dd>Si cette option est active, Apache affichera les fichiers
      normalement cachs suite au retour des valeurs
      <code>HTTP_UNAUTHORIZED</code> ou <code>HTTP_FORBIDDEN</code> par
      la sous-requte.</dd>

      <dt><a name="indexoptions.suppresscolumnsorting" id="indexoptions.suppresscolumnsorting">SuppressColumnSorting</a></dt>

      <dd>Si cette option est active, Apache supprimera les liens
      hyper-texte dans les en-ttes de colonnes dans le cas d'un
      affichage "amlior". Par dfaut, ces en-ttes constituent des liens
      hyper-texte, et la slection de l'un d'entre eux va trier l'index
      du rpertoire en fonction des valeurs de la colonne
      correspondante. <strong>Avant
      Apache 2.0.23, cette option dsactivait aussi l'interprtation des
      informations de tri transmises via les arguments de la
      requte.</strong> Depuis Apache 2.0.23, ce comportement est
      contrl par <a href="#indexoptions.ignoreclient"><code>IndexOptions
      IgnoreClient</code></a>.</dd>

      <dt><a name="indexoptions.suppressdescription" id="indexoptions.suppressdescription">SuppressDescription</a></dt>

      <dd>L'activation de cette option va supprimer la description des
      fichiers dans le cas d'un affichage "amlior". Par dfaut aucune
      description de fichier n'est dfinie, et par consquent
      l'utilisation de cette option va permettre de rcuprer un espace
       l'cran de 23 caractres pouvant tre utilis pour autre chose.
      Voir la directive <code class="directive"><a href="#adddescription">AddDescription</a></code> pour plus d'informations  propos de
      la dfinition des descriptions de fichiers. Voir aussi l'option
      d'index <code><a href="#indexoptions.descriptionwidth">DescriptionWidth</a></code>
      pour limiter la taille de la colonne description.</dd>

      <dt><a name="indexoptions.suppresshtmlpreamble" id="indexoptions.suppresshtmlpreamble">SuppressHTMLPreamble</a></dt>

      <dd>Si le rpertoire contient effectivement le fichier spcifi
      par la directive <code class="directive"><a href="#headername">HeaderName</a></code>, le module inclut
      en gnral le contenu du fichier aprs avoir insr un prambule
      HTML standard (<code>&lt;html&gt;</code>,
      <code>&lt;head&gt;</code>, <em>etc...</em>). L'activation de
      l'option <code>SuppressHTMLPreamble</code> supprime l'insertion de
      ce prambule, et le module va alors commencer l'affichage
      directement par le contenu du fichier d'en-tte. Dans ce cas par
      contre, le fichier d'en-tte doit contenir des instructions HTML
      appropries. S'il n'y a pas de fichier d'en-tte, le prambule est
      gnr comme dans le cas gnral.</dd>

      <dt><a name="indexoptions.suppressicon" id="indexoptions.suppressicon">SuppressIcon</a>
	       (<em>Versions 2.0.23 et suprieures d'Apache</em>)</dt>

      <dd>L'activation de cette option supprime l'affichage des icnes
      dans le cas d'un affichage "amlior". La combinaison de
      <code>SuppressIcon</code> et <code>SuppressRules</code> permet de
      gnrer une sortie au format HTML 3.2 qui, selon les dernires
      spcifications, interdit les lments <code>img</code> et
      <code>hr</code> dans les blocs <code>pre</code> (utiliss pour
      formater les affichages "amliors").</dd>

      <dt><a name="indexoptions.suppresslastmodified" id="indexoptions.suppresslastmodified">SuppressLastModified</a></dt>

      <dd>L'activation de cette option supprime l'affichage de la date
      de dernire modification dans le cas d'un affichage "amlior".</dd>

      <dt><a name="indexoptions.suppressrules" id="indexoptions.suppressrules">SuppressRules</a>
      (<em>Versions 2.0.23 et suprieures d'Apache</em>)</dt>

      <dd>L'activation de cette option supprime l'affichage des lignes
      horizontales (lments <code>hr</code>) dans les index de
      rpertoires. La combinaison de
      <code>SuppressIcon</code> et <code>SuppressRules</code> permet de
      gnrer une sortie au format HTML 3.2 qui, selon les dernires
      spcifications, interdit les lments <code>img</code> et
      <code>hr</code> dans les blocs <code>pre</code> (utiliss pour
      formater les affichages "amliors").</dd>

      <dt><a name="indexoptions.suppresssize" id="indexoptions.suppresssize">SuppressSize</a></dt>

      <dd>L'activation de cette option supprime l'affichage de la taille
      du fichier dans le cas d'un affichage "amlior".</dd>

      <dt><a name="indexoptions.trackmodified" id="indexoptions.trackmodified">TrackModified</a>
	       (<em>Versions 2.0.23 et suprieures d'Apache</em>)</dt>

      <dd>Cette option renvoie les valeurs <code>Last-Modified</code> et
      <code>ETag</code> pour le rpertoire index dans l'en-tte HTTP.
      Elle n'est valide que si le systme d'exploitation et le systme
      de fichiers renvoient des rsultats appropris pour la fonction
      stat(). C'est le cas de certains systmes Unix, ainsi que JFS sous
      OS2 et les volumes NTFS sous Win32. Ce n'est par contre pas le cas
      des volumes OS2 et FAT Win32. Lorsque cette option est active, le
      client ou le mandataire peuvent dtecter les changements dans la
      liste des fichiers lorsqu'ils effectuent une requte
      <code>HEAD</code>. Notez que certains systmes d'exploitation
      dtectent correctement les nouveaux fichiers et les fichiers
      supprims, mais ne dtectent pas les modifications de tailles ou
      de dates des fichiers du rpertoire. <strong>Les modifications de
      taille ou de date d'un fichier existant ne mettent pas  jour
      l'en-tte <code>Last-Modified</code> sur toutes les plate-formes
      Unix.</strong> Si c'est le cas, laissez cette option
      dsactive.</dd>

      <dt><a name="indexoptions.versionsort" id="indexoptions.versionsort">VersionSort</a>
      (<em>Apache 2.0a3 and later</em>)</dt>

      <dd>Le mot-cl <code>VersionSort</code> permet de trier les
      fichiers contenant des numros de version d'une manire
      spcifique. Les chanes sont tries comme d'habitude, except les
      sous-chanes de chiffres du nom de fichier et de sa description
      qui sont compares en fonction de leur valeur numrique.

      <div class="example"><h3>Exemple :</h3><p><code>
        foo-1.7<br />
        foo-1.7.2<br />
        foo-1.7.12<br />
        foo-1.8.2<br />
        foo-1.8.2a<br />
        foo-1.12
      </code></p></div>

      <p>Si le nombre commence par le chiffre 0, il est considr comme
      la partie fractionnaire d'un nombre :</p>

      <div class="example"><p><code>
        foo-1.001<br />
        foo-1.002<br />
        foo-1.030<br />
        foo-1.04
      </code></p></div>
      </dd>

      <dt><a name="indexoptions.xhtml" id="indexoptions.xhtml">XHTML</a>
      (<em>Versions 2.0.49 et suprieures d'Apache</em>)</dt>

      <dd>Le mot-cl <code>XHTML</code> enjoint
      <code class="module"><a href="../mod/mod_autoindex.html">mod_autoindex</a></code> de gnrer du code XHTML 1.0 au
      lieu de HTML 3.2.</dd>
    </dl>

   
   <dl><dt>Options d'index incrmentales</dt>
   <dd>
     <p>Apache 1.3.3 a apport d'importantes modifications dans la
     gestion des directives <code class="directive">IndexOptions</code>. En
     particulier :</p>

     <ul>
     <li>Plusieurs directives <code class="directive">IndexOptions</code>
     apparaissant dans la mme section directory sont maintenant
     fusionnes. Le rsultat de :

     <div class="example"><p><code>
       &lt;Directory /foo&gt;
       <span class="indent">
         IndexOptions HTMLTable<br />
         IndexOptions SuppressColumnsorting
       </span>
       &lt;/Directory&gt;
     </code></p></div>

     <p>est quivalent </p>

     <div class="example"><p><code>
       IndexOptions HTMLTable SuppressColumnsorting
     </code></p></div>
     </li>

     <li>L'ajout de la syntaxe incrmentale (en prfixant les mots-cls
     avec <code>+</code> ou <code>-</code>).</li>
     </ul>

     <p>Chaque fois qu'un mot-cl prfix par '+' ou '-' est trouv, il
     est appliqu aux dfinitions des
     <code class="directive">IndexOptions</code> courantes (qui ont t
     ventuellement hrites d'un directory de niveau suprieur). Par
     contre, si un mot-cl non prfix est trouv, il supprime toutes
     les definitions hrites, ainsi que toute
     dfinition incrmentale. Considrons l'exemple
     suivant :</p>

     <div class="example"><p><code>
       IndexOptions +ScanHTMLTitles -IconsAreLinks FancyIndexing<br />
       IndexOptions +SuppressSize
     </code></p></div>

     <p>L'effet global est quivalent  l'effet qu'aurait provoqu
     <code>IndexOptions FancyIndexing +SuppressSize</code>, car l'option
     non prfixe <code>FancyIndexing</code> annulent les mots-cls
     incrmentaux situs avant elle, mais leur permet ensuite de
     s'incrmenter  nouveau.</p>

     <p>Pour dfinir inconditionnellement les
     <code class="directive">IndexOptions</code> pour un rpertoire particulier,
     tout en supprimant les dfinitions hrites, spcifiez les
     mots-cls sans prfixe <code>+</code> ou <code>-</code></p>
   </dd>
   </dl>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="IndexOrderDefault" id="IndexOrderDefault">IndexOrderDefault</a> <a name="indexorderdefault" id="indexorderdefault">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit l'ordre d'affichage par dfaut d'un index de
rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>IndexOrderDefault Ascending|Descending
Name|Date|Size|Description</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>IndexOrderDefault Ascending Name</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>La directive <code class="directive">IndexOrderDefault</code> s'utilise
    en combinaison avec l'option d'index <code><a href="#indexoptions.fancyindexing">FancyIndexing</a></code>. Par
    dfaut, les index de rpertoire "amliors" sont affichs selon l'ordre
    croissant des noms de fichiers ; la directive
    <code class="directive">IndexOrderDefault</code> vous permet de modifier ce
    comportement.</p>

    <p>La directive <code class="directive">IndexOrderDefault</code> accepte
    deux arguments. Le premier est soit <code>Ascending</code>, soit
    <code>Descending</code>, et indique l'ordre de tri. Le second doit
    prendre une des valeurs <code>Name</code>, <code>Date</code>,
    <code>Size</code>, ou <code>Description</code>, et permet
    d'identifier la cl primaire. La cl secondaire est
    <em>toujours</em> le nom du fichier selon un ordre croissant.</p>

    <p>Si vous le dsirez, vous pouvez empcher le client de modifier
    l'ordre de tri de la liste en ajoutant l'option d'index  <code><a href="#indexoptions.suppresscolumnsorting">SuppressColumnSorting</a></code>
    qui supprime le lien de dfinition du tri de l'en-tte de la
    colonne, ainsi que l'option <code><a href="#indexoptions.ignoreclient">IgnoreClient</a></code> qui
    empche ce mme client de passer outre vos prfrences de tri en
    ajoutant manuellement des options de tri  la chane de paramtres
    de la requte.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="IndexStyleSheet" id="IndexStyleSheet">IndexStyleSheet</a> <a name="indexstylesheet" id="indexstylesheet">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ajoute une feuille de style CSS  l'index du
rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>IndexStyleSheet <var>chemin-url</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>La directive <code class="directive">IndexStyleSheet</code> permet de
    dfinir le nom du fichier qui servira de feuille de style CSS pour
    l'index.
    </p>
    <div class="example"><h3>Exemple</h3><p><code>
      
      IndexStyleSheet "/css/style.css"
    </code></p></div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ReadmeName" id="ReadmeName">ReadmeName</a> <a name="readmename" id="readmename">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nom du fichier dont le contenu sera insr  la fin de
l'index</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ReadmeName <var>nom-fichier</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">Annuler:</a></th><td>Indexes</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_autoindex</td></tr>
</table>
    <p>La directive <code class="directive">ReadmeName</code> permet de dfinir
    le nom du fichier dont le contenu sera ajout  la fin de l'index.
    <var>nom-fichier</var> est le nom du fichier  inclure, et est
    consid comme relatif au rpertoire faisant l'objet de l'index. Si
    <var>nom-fichier</var> commence par un slash '/', il sera considr
    comme relatif au rpertoire dfini par la directive <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code>.
    </p>

    <div class="example"><h3>Exemple</h3><p><code>
      ReadmeName FOOTER.html
    </code></p></div>

    <div class="example"><h3>Exemple 2</h3><p><code>
      ReadmeName /include/FOOTER.html
    </code></p></div>

    <p>Voir aussi la directive <code class="directive"><a href="#headername">HeaderName</a></code>, o cette fonctionnalit est dcrite plus en
    dtails.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_autoindex.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_autoindex.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_autoindex.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_autoindex.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/mod/mod_autoindex.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2011 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="../faq/">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div>
</body></html>