<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 574103 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- $LastChangedRevision: 2007091601 $ -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="install.xml.meta">

  <title>Compilation et installation</title>

<summary>

    <p>Ce document couvre l'installation et la compilation du serveur
    HTTP Apache
    sur les syst&egrave;mes Unix et similaires seulement. Pour la compilation et
    l'installation sous Windows, voir <a
    href="platform/windows.html">Utiliser Apache HTTPd avec Microsoft
    Windows</a>. Pour les autres plateformes, se r&eacute;f&eacute;rer &agrave; la documentation par
     <a href="platform/">plateforme</a>.</p>

    <p>Apache HTTPd utilise <code>libtool</code> et <code>autoconf</code>
    afin de cr&eacute;er un environnement de construction similaire &agrave; la plupart
    des projets Open Source .</p>

    <p>Si vous effectuez une mise &agrave; jour depuis une version mineure vers
    la suivante (par exemple, 2.2.50 &agrave; 2.2.51), veuillez passer &agrave; la section
    <a href="#upgrading">mise &agrave; jour</a>.</p>

</summary>

<seealso><a href="programs/configure.html">Configuration de l'arborescence
	des sources</a></seealso>
<seealso><a href="invoking.html">D&eacute;marrer le serveur HTTP Apache</a></seealso>
<seealso><a href="stopping.html">Arr&ecirc;t et red&eacute;marrage</a></seealso>

<section id="overview"><title>Aper&ccedil;u pour les plus press&eacute;s</title>

    <table>
      <columnspec><column width=".13"/><column width=".80"/></columnspec>
      <tr>
        <td><a href="#download">T&eacute;l&eacute;chargement</a></td>

        <td><code>$ lynx http://httpd.apache.org/download.cgi</code>
        </td>
      </tr>

      <tr>
        <td><a href="#extract">Extraction</a></td>

        <td><code>$ gzip -d httpd-<em>NN</em>.tar.gz<br />
         $ tar xvf httpd-<em>NN</em>.tar<br />
         $ cd httpd-<em>NN</em></code></td>
      </tr>

      <tr>
        <td><a href="#configure">Configuration</a></td>

        <td><code>$ ./configure --prefix=<em>PREFIX</em></code>
        </td>
      </tr>

      <tr>
        <td><a href="#compile">Compilation</a></td>

        <td><code>$ make</code> </td>
      </tr>

      <tr>
        <td><a href="#install">Installation</a></td>

        <td><code>$ make install</code> </td>
      </tr>

      <tr>
        <td><a href="#customize">Personnalisation</a></td>

        <td><code>$ vi <em>PREFIX</em>/conf/httpd.conf</code> </td>
      </tr>

      <tr>
        <td><a href="#test">Test</a></td>

        <td><code>$ <em>PREFIX</em>/bin/apachectl -k start</code>
        </td>
      </tr>
    </table>

    <p><em>NN</em> doit &ecirc;tre remplac&eacute; par le num&eacute;ro de version courant,
    et <em>PREFIX</em> par le
    chemin du r&eacute;pertoire d'installation. Si
    <em>PREFIX</em> n'est pas sp&eacute;cifi&eacute;, le chemin du r&eacute;pertoire
    d'installation prendra sa valeur par d&eacute;faut, &agrave; savoir
    <code>/usr/local/apache2</code>.</p>

    <p>Chaque &eacute;tape du processus de compilation et d'installation est
    d&eacute;crite plus en d&eacute;tails ci-dessous, &agrave; commencer par les pr&eacute;requis
    pour compiler et installer le serveur HTTP Apache.</p>
</section>

<section id="requirements"><title>Pr&eacute;requis</title>

    <p>Les pr&eacute;requis pour la construction d'Apache HTTPd sont les suivants:</p>

    <dl>
      <dt>Espace disque</dt>
      <dd>Assurez-vous d'avoir au moins 50 MB d'espace disque disponible
      temporaire. Apr&egrave;s l'installation Apache occupe
      approximativement 10 MB d'espace disque. L'espace disque r&eacute;ellement
      n&eacute;cessaire va varier consid&eacute;rablement en fonction de vos options
      de configuration et de la pr&eacute;sence &eacute;ventuelle de modules tiers.</dd>

      <dt>Compilateur ANSI-C et syst&egrave;me de construction</dt>
      <dd>Vous devez disposer d'un compilateur ANSI-C. Le compilateur <a
      href="http://www.gnu.org/software/gcc/gcc.html">GNU C
       (GCC)</a> de la <a
      href="http://www.gnu.org/">Free Software Foundation (FSF)</a>
      est recommand&eacute;. Si vous ne poss&eacute;dez pas GCC,
      assurez-vous au moins que votre compilateur soit compatible ANSI.
      En outre, votre <code>PATH</code> doit contenir
      les outils de construction de base tels que <code>make</code>.</dd>

      <dt>Connaissance de l'heure exacte</dt>
      <dd>Les &eacute;l&eacute;ments du protocole HTTP font r&eacute;f&eacute;rence &agrave; l'heure du jour.
      Par cons&eacute;quent, il est n&eacute;cessaire d'&eacute;quiper votre syst&egrave;me d'un
      dispositif de synchronisation du temps. Les programmes
      <code>ntpdate</code> ou <code>xntpd</code>, bas&eacute;s sur le protocole NTP,
      sont couramment utilis&eacute;s &agrave; cet effet.
      Voir la <a href="http://www.ntp.org">page d'accueil de NTP</a>
      pour plus de d&eacute;tails &agrave; propos du logiciel NTP et des serveurs
      de temps publics.</dd>

      <dt><a href="http://www.perl.org/">Perl 5</a>
      [OPTIONNEL]</dt>
      <dd>L'interpr&eacute;teur Perl 5 (les versions 5.003 ou sup&eacute;rieures conviennent)
      est n&eacute;cessaire pour l'ex&eacute;cution de certains scripts comme
      <program>apxs</program> ou <program>dbmmanage</program>
      (qui sont &eacute;crits en Perl). Si vous disposez de plusieurs interpr&eacute;teurs
      Perl (par exemple, une installation globale Perl 4, et
      votre installation personnelle de Perl 5), il vous faut utiliser l'option
      <code>--with-perl</code> (voir ci-dessous) afin de vous assurer que le
      bon interpr&eacute;teur sera utilis&eacute; par <program>configure</program>.
      Si le script <program>configure</program> ne trouve pas d'interpr&eacute;teur
      Perl 5, vous ne pourrez pas utiliser les scripts qui en ont besoin.
      Bien entendu, vous pourrez tout de m&ecirc;me construire et utiliser
      Apache httpd.</dd>

      <dt><a href="http://apr.apache.org">apr/apr-util >= 1.2</a></dt>
      <dd><code>apr</code> et <code>apr-util</code> sont inclus
      dans les sources d'Apache HTTPd, et peuvent &ecirc;tre utilis&eacute;s sans probl&egrave;me
      dans la plupart des cas. Cependant, si
      <code>apr</code> ou <code>apr-util</code>, versions 1.0 ou 1.1,
      sont install&eacute;s sur votre syst&egrave;me, vous devez soit mettre &agrave; jour vos
      installations <code>apr</code>/<code>apr-util</code> vers la version
      1.2, forcer l'utilisation des biblioth&egrave;ques int&eacute;gr&eacute;es,
      soit faire en sorte que httpd utilise des constructions s&eacute;par&eacute;es.
      Pour utiliser les sources de
      <code>apr</code>/<code>apr-util</code> incluses, utilisez l'option
      <code>--with-included-apr</code> du script configure :

      <note><title>Note</title>
        L'option --with-included-apr est disponible &agrave; partir
	de la version 2.2.3
      </note>
      <example>
        # Forcer l'utilisation des sources de apr/apr-util int&eacute;gr&eacute;es<br />
        ./configure --with-included-apr<br />
      </example>

      Pour construire Apache HTTPd suite  &agrave; une installation manuelle de
      <code>apr</code>/<code>apr-util</code> :

      <example>
        # Construction et installation apr 1.2<br />
        cd srclib/apr<br/>
        ./configure --prefix=/usr/local/apr-httpd/<br/>
        make<br/>
        make install<br />
        <br />
        # Construction et installation apr-util 1.2<br />
        cd ../apr-util<br />
        ./configure --prefix=/usr/local/apr-util-httpd/
          --with-apr=/usr/local/apr-httpd/<br />
        make<br/>
        make install<br />
        <br />
        # Configuration httpd<br />
        cd ../../<br />
        ./configure --with-apr=/usr/local/apr-httpd/
          --with-apr-util=/usr/local/apr-util-httpd/
      </example>
      </dd>


    </dl>
</section>

<section id="download"><title>T&eacute;l&eacute;chargement</title>

    <p>Le serveur HTTP Apache peut &ecirc;tre t&eacute;l&eacute;charg&eacute; &agrave; partir du
    <a href="http://httpd.apache.org/download.cgi">site de t&eacute;l&eacute;chargement
    du serveur HTTP Apache</a>, qui fournit la liste de nombreux miroirs.
    Il sera plus commode &agrave; la plupart des utilisateurs d'Apache HTTPd sur les
    syst&egrave;mes UNIX ou similaires de t&eacute;l&eacute;charger et de compiler
    la version sources.  Le processus de construction (d&eacute;crit ci-dessous) est
    simple, et vous permet de personnaliser votre serveur selon vos besoins.
    En outre, les versions binaires sont souvent plus anciennes que les
    derni&egrave;res versions sources  Si vous t&eacute;l&eacute;chargez une version binaire,
    suivez les instructions d&eacute;crites dans le fichier
    <code>INSTALL.bindist</code> inclus dans la distribution.</p>

    <p>Apr&egrave;s le t&eacute;l&eacute;chargement, il est important de v&eacute;rifier que vous
    disposez d'une version compl&egrave;te et non modifi&eacute;e du serveur HTTP Apache.
    Vous pouvez le faire en testant l'archive t&eacute;l&eacute;charg&eacute;e &agrave; l'aide de
    la signature PGP. Vous trouverez les d&eacute;tails de cette op&eacute;ration sur la <a
    href="http://httpd.apache.org/download.cgi#verify"
    >page de t&eacute;l&eacute;chargement</a> ainsi qu'un exemple pr&eacute;cis d&eacute;crivant <a
    href="http://httpd.apache.org/dev/verification.html">l'utilisation de
    PGP</a>.</p>

</section>

<section id="extract"><title>Extraction</title>

    <p>L'extraction des sources depuis l'archive Apache HTTPd consiste
    simplement &agrave; d&eacute;compresser et &agrave; d&eacute;sarchiver cette derni&egrave;re :</p>

<example>
$ gzip -d httpd-<em>NN</em>.tar.gz<br />
$ tar xvf httpd-<em>NN</em>.tar
</example>

    <p>Ceci cr&eacute;era, dans le r&eacute;pertoire courant, un nouveau r&eacute;pertoire
    contenant le code source de la distribution. Vous devrez vous positionner
    dans ce r&eacute;pertoire avant de proc&eacute;der &agrave; la compilation du serveur.</p>
</section>

<section id="configure"><title>Configuration de l'arborescence des sources</title>

    <p>L'&eacute;tape suivante consiste &agrave; configurer l'arborescence des sources
    d'Apache HTTPd en fonction de votre plateforme et de vos besoins personnels.
    Le script  <program>configure</program>, situ&eacute; &agrave; la racine du
    r&eacute;pertoire de la distribution, a &eacute;t&eacute; con&ccedil;u &agrave; cet effet.
    (Les d&eacute;veloppeurs qui t&eacute;l&eacute;chargent
    une version non officielle de l'arborescence des sources d'Apache HTTPd
    devront disposer de
    <code>autoconf</code> et <code>libtool</code> et
    ex&eacute;cuter <code>buildconf</code> avant de passer &agrave; l'&eacute;tape suivante,
    ce qui n'est pas n&eacute;cessaire pour les versions officielles.)</p>

    <p>Pour configurer l'arborescence des sources avec les valeurs par d&eacute;faut
    pour toutes les options, entrez simplement <code>./configure</code>.
    Pour modifier les valeurs des options, <program>configure</program>
    comprend toute une vari&eacute;t&eacute; de variables et
    d'options de ligne de commande.</p>

    <p>L'option la plus importante <code>--prefix</code> est le chemin
    du r&eacute;pertoire d'installation du serveur HTTP Apache, car Apache doit &ecirc;tre configur&eacute;
    en fonction de ce chemin pour pouvoir fonctionner correctement.
    Il est possible de d&eacute;finir plus finement le chemin d'installation des fichiers
    &agrave; l'aide d'<a href="programs/configure.html#installationdirectories">
    options suppl&eacute;mentaires de configure</a>.</p>

    <p>&Agrave; ce niveau, vous pouvez aussi sp&eacute;cifier de quelles <a
    href="programs/configure.html#optionalfeatures">fonctionnalit&eacute;s</a> vous
    voulez disposer dans Apache HTTPd en activant ou d&eacute;sactivant des <a
    href="mod/">modules</a>.  Apache est fourni avec un jeu de modules de
    <a href="mod/module-dict.html#Status">Base</a> inclus par d&eacute;faut.
    Les autres modules sont activ&eacute;s &agrave; l'aide de l'option
    <code>--enable-<var>module</var></code>, o&ugrave;
    <var>module</var> est le nom du module sans la cha&icirc;ne
    <code>mod_</code> et o&ugrave; tout caract&egrave;re de soulignement est converti
    en tiret.  Vous pouvez aussi choisir de compiler les modules comme
    <a href="dso.html">objets partag&eacute;s (DSOs)</a> -- qui peuvent &ecirc;tre charg&eacute;s
    ou d&eacute;charg&eacute;s &agrave; l'ex&eacute;cution -- &agrave; l'aide de l'option
    <code>--enable-<var>module</var>=shared</code>.  D'une mani&egrave;re similaire,
    vous pouvez d&eacute;sactiver des modules de base &agrave; l'aide de l'option
    <code>--disable-<var>module</var></code> option.  Faites tr&egrave;s attention
    en utilisant ces options, car <program>configure</program> n'est pas en
    mesure de vous avertir si le module que vous avez sp&eacute;cifi&eacute; n'existe pas;
    il ignorera tout simplement l'option.</p>

    <p>En outre, vous devrez peut-&ecirc;tre fournir au script
    <program>configure</program> des informations suppl&eacute;mentaires sur
    le chemin de votre compilateur, de vos librairies, ou de vos fichiers
    d'en-t&ecirc;tes.  A cet effet, vous pouvez passer des options de ligne de
    commande ou des variables d'environnement au script
    <program>configure</program>. Pour plus d'informations, voir la
    page de manuel de <program>configure</program>.</p>

    <p>Pour vous faire une id&eacute;e des possibilit&eacute;s qui s'offrent &agrave; vous, voici
    un exemple typique de compilation d'Apache avec le r&eacute;pertoire
    d'installation <code>/sw/pkg/apache</code>, un compilateur et des drapeaux
    particuliers et les deux modules additionnels <module>mod_rewrite</module>
    et <module>mod_speling</module> qui pourront &ecirc;tre charg&eacute;s plus tard
    &agrave; l'aide du m&eacute;canisme DSO:</p>

<example>
      $ CC="pgcc" CFLAGS="-O2" \<br />
       ./configure --prefix=/sw/pkg/apache \<br />
       --enable-rewrite=shared \<br />
       --enable-speling=shared
</example>

    <p>Quand <program>configure</program> est lanc&eacute;, il peut prendre
    plusieurs minutes pour tester la disponibilit&eacute; des fonctionnalit&eacute;s
    au sein de votre syst&egrave;me, et construire les Makefiles qui seront utilis&eacute;s
    par la suite pour compiler le serveur.</p>

    <p>Vous trouverez une description d&eacute;taill&eacute;e des options de
    <program>configure</program> dans sa page de manuel.</p>
</section>

<section id="compile"><title>Construction</title>

    <p>Vous pouvez maintenant construire les diff&eacute;rents &eacute;l&eacute;ments qui
    composent le paquet Apache HTTPd en lan&ccedil;ant tout simplement la commande :</p>

<example>$ make</example>

    <p>Vous devez &ecirc;tre patient, car il faut plusieurs minutes pour compiler
    une configuration de base, et cette dur&eacute;e peut varier consid&eacute;rablement
    en fonction de votre mat&eacute;riel et du nombre de modules que vous avez activ&eacute;s.</p>
</section>

<section id="install"><title>Installation</title>

    <p>Il est temps maintenant d'installer le paquet dans le r&eacute;pertoire
    d'installation d&eacute;fini par <em>PREFIX</em> (voir plus haut l'option
    <code>--prefix</code>) en lan&ccedil;ant:</p>

<example>$ make install</example>

    <p>Si vous effectuez une mise &agrave; jour, l'installation n'&eacute;crasera pas
    vos fichiers de configuration ou autres documents.</p>
</section>

<section id="customize"><title>Personnalisation</title>

    <p>Ensuite, vous pourrez personnaliser votre Serveur HTTP Apache en
    &eacute;ditant les <a href="configuring.html">fichiers de configuration</a>
    situ&eacute;s dans <code><em>PREFIX</em>/conf/</code>.</p>

<example>$ vi <em>PREFIX</em>/conf/httpd.conf</example>

    <p>Consultez le manuel du serveur HTTP Apache situ&eacute; dans
    <a href="./">docs/manual/</a> ou
    <a href="http://httpd.apache.org/docs/&httpd.docs;/"
    >http://httpd.apache.org/docs/&httpd.docs;/</a> pour la version la plus
    r&eacute;cente de ce manuel et la liste compl&egrave;te des <a
    href="mod/directives.html">directives de configuration</a> disponibles.</p>
</section>

<section id="test"><title>Test</title>

    <p>Vous pouvez maintenant <a href="invoking.html">d&eacute;marrer</a> votre
    Serveur HTTP Apache en lan&ccedil;ant:</p>

<example>$ <em>PREFIX</em>/bin/apachectl -k start</example>

    <p>Vous devriez alors pouvoir requ&eacute;rir votre premier document
    &agrave; l'aide de l'URL <code>http://localhost/</code>. La page web que vous
    voyez est situ&eacute;e dans le r&eacute;pertoire d&eacute;fini par la directive
    <directive module="core">DocumentRoot</directive>,
    qui est g&eacute;n&eacute;ralement <code><em>PREFIX</em>/htdocs/</code>.
    Pour <a href="stopping.html">arr&ecirc;ter</a> le serveur, lancez:</p>

<example>$ <em>PREFIX</em>/bin/apachectl -k stop</example>
</section>
<section id="upgrading"><title>Mise &agrave; jour</title>

    <p>La premi&egrave;re &eacute;tape d'une mise &agrave; jour consiste &agrave; lire l'annonce de la
    sortie de la nouvelle version et le fichier <code>CHANGES</code>
    dans la distribution des sources afin de d&eacute;celer toutes les modifications
    qui pourraient affecter votre site. Lors d'un changement majeur de version
    (par exemple de 1.3 &agrave; 2.0 ou de 2.0 &agrave; 2.2),
    il y aura certainement des diff&eacute;rences importantes quant &agrave; la
    configuration de la compilation et de l'ex&eacute;cution qui n&eacute;cessiteront des
    ajustements manuels.  Tous les
    modules devront aussi &ecirc;tre mis &agrave; jour pour qu'ils s'adaptent aux
    changements de l'API des modules.</p>

    <p>La mise &agrave; jour d'une version mineure &agrave; la suivante (par exemple, de
    2.2.55 &agrave; 2.2.57) est plus ais&eacute;e.  Le processus <code>make install</code>
    n'&eacute;crasera aucun de vos documents existants, fichiers de log,
    ou fichiers de configuration.  De plus, les d&eacute;veloppeurs font tout
    leur possible pour &eacute;viter les changements entra&icirc;nant une
    incompatibilit&eacute; dans les options de
    <program>configure</program>, la configuration de l'ex&eacute;cution, ou l'API
    des modules d'une version mineure &agrave; l'autre.  Dans la plupart des cas,
    vous pourrez utiliser une ligne de commande
    <program>configure</program> identique, le m&ecirc;me fichier de configuration,
    et tous vos modules continueront de fonctionner.</p>

    <p>Pour effectuer une mise &agrave; jour entre deux versions mineures,
    commencez par trouver le fichier
    <code>config.nice</code> dans le r&eacute;pertoire de <code>construction</code>
    de votre serveur install&eacute; ou &agrave; la racine de l'arborescence des sources
    de votre ancienne installation.  Il contient la reproduction exacte de la
    ligne de commande <program>configure</program> que vous avez utilis&eacute;e pour
    configurer l'arborescence des sources.  Ensuite, pour mettre &agrave; jour
    l'ancienne version vers la nouvelle,
    il vous suffit de copier le fichier <code>config.nice</code> dans
    l'arborescence des sources de la nouvelle version, de l'&eacute;diter pour
    effectuer toute modification souhait&eacute;e, et de lancer:</p>

    <example>
    $ ./config.nice<br />
    $ make<br />
    $ make install<br />
    $ <em>PREFIX</em>/bin/apachectl -k graceful-stop<br />
    $ <em>PREFIX</em>/bin/apachectl -k start<br />
    </example>

    <note type="warning">Vous devez toujours effectuer un test de la nouvelle
    version dans votre environnement avant de la mettre en production.
    Par exemple, vous pouvez installer et ex&eacute;cuter la nouvelle version
    en parall&egrave;le avec l'ancienne en utilisant une option
    <code>--prefix</code> et un port diff&eacute;rents (en ajustant la directive
    <directive module="mpm_common">Listen</directive>) afin de d&eacute;celer toute
    incompatibilit&eacute; avant d'effectuer la mise &agrave; jour d&eacute;finitive.</note>

    </section>
</manualpage>
