<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 421100 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="new_features_2_0.xml.meta">

    <title>Vue d'ensemble des nouvelles fonctionnalit&#233;s d'Apache 2.0</title>

    <summary>
        <p>Ce document d&#233;crit les changements majeurs apport&#233;s entre les 
        versions 1.3 et 2.0 du serveur HTTP Apache.</p>
    </summary>

    <seealso><a href="upgrading.html">Migrer &#224; 2.0 depuis la version 1.3</a></seealso>

    <section id="core">
        <title>Am&#233;liorations du Syst&#232;me de Base</title>

        <dl>
            <dt>Threading Unix</dt>

            <dd>Sur les syst&#232;mes Unix qui supportent les threads POSIX, Apache 
            peut &#224; pr&#233;sent tourner en mode hybride multi-processus et 
            multi-thread&#233;, ce qui augmente l'extensibilit&#233; et la performance 
            du serveur pour la plupart des configurations.</dd>

            <dt>Nouveau Syst&#232;me de Compilation</dt>

            <dd>Le processus de compilation a &#233;t&#233; refait de A &#224; Z; 
            il utilise &#224; pr&#233;sent <code>autoconf</code> et <code>libtool</code>, 
            ce qui rend la compilation d'Apache plus famili&#232;re aux utilisateurs 
            d'autre logiciels de m&#232;me type.</dd>

            <dt>Support Multiprotocole</dt>

            <dd>Apache dispose d&#233;sormais de l'infrastructure n&#233;cessaire pour supporter 
            d'autres protocoles. Le module <module>mod_echo</module> illustre ces 
            possibilit&#233;s.</dd>

            <dt>Support am&#233;lior&#233; des Plate-formes non-Unix</dt>
        
            <dd>Apache 2.0 se montre plus rapide et plus stable sur les plate-formes 
            non Unix, telles BeOS, OS/2, NetWare et Windows. L'apparition des 
            <a href="mpm.html">Modules Multi-Processus</a> (MPMs), ainsi que de 
            la biblioth&#232;que "Apache Portable Runtime" (APR) permet a Apache de 
            tirer parti des API natives de ces plate-formes, sans s'appuyer sur leurs 
            couches POSIX souvent bogu&#233;es et peu optimis&#233;es.</dd>

            <dt>Nouvelle API Apache</dt>

            <dd>L'Interface de Programmation (API) des modules a beaucoup chang&#233; 
            avec le passage &#224; la version 2.0.
            Les probl&#232;mes d'ordre et de priorit&#233; des modules, rencontr&#233;s 
            avec la version 1.3, devraient maintenant &#234;tre r&#233;solus. Apache 2.0 
            g&#232;re ces probl&#232;mes de fa&#231;on automatique. L'ordre des modules 
            est g&#233;r&#233; au moyen de "crochets" (hooks), ce qui rend la gestion 
            flexible. De nouveaux appels ont &#233;t&#233; &#233;galement cr&#233;&#233;s 
            afin de permettre l'impl&#233;mentation d'autres fonctions dans les modules, 
            sans devoir corriger le noyau du serveur Apache.</dd>

            <dt>Support IPv6</dt>

            <dd>Sur les syst&#232;mes o&#249; la biblioth&#232;que Apache Portable Runtime 
            supporte IPv6, Apache peut par d&#233;faut &#233;couter sur des interfaces 
            de connexions IPv6. Les directives <directive module="mpm_common">Listen</directive>, 
            <directive module="core">NameVirtualHost</directive> et 
            <directive module="core">VirtualHost</directive> supportent &#233;galement 
            les adresses IPv6 (comme par exemple, dans "<code>Listen[2001:db8::1]:8080</code>").</dd>

            <dt>Filtering</dt>

            <dd>Il est maintenant possible d'&#233;crire des modules Apache pour filtrer
            les flux de donn&#233;es entrant ou sortant du serveur. A titre d'exemple, 
            il est possible de filtrer des directives Server Side Include de la sortie 
            standard d'un script CGI, au moyen du filtre <code>INCLUDES</code> fourni
            par le module <module>mod_include</module>. Le module
            <module>mod_ext_filter</module> permet quant &#224; lui l'utilisation comme
            filtres de programmes externes &#224; Apache, de la m&#234;me mani&#232;re 
            qu'on peut utiliser des programmes CGI comme Handlers.</dd>

            <dt>R&#233;ponses d'Erreurs Multilangues</dt>

            <dd>Les messages d'erreur envoy&#233;s au navigateur existent &#224; pr&#233;sent en
            plusieurs langues avec des documents SSI. Ces messages peuvent &#234;tre
            personnalis&#233;s par l'administrateur afin de s'int&#233;grer avec le site web.</dd>

            <dt>Simplification de la Configuration</dt>

            <dd>Beaucoup de directives, auparavant peu claires, ont &#233;t&#233; simplifi&#233;es.
            Les directives <code>Port</code> et <code>BindAddress</code>, souvent
            sources d'incompr&#233;hension, ont disparus. D&#233;sormais seule la directive 
            <directive module="mpm_common">Listen</directive> sert de liaison pour les 
            adresses IP; la directive <directive module="core">ServerName</directive> ne 
            pr&#233;cise le nom du serveur et son port que pour les redirections et la
            gestion des h&#244;tes virtuels.</dd>

            <dt>Support natif de l'Unicode sous Windows NT</dt>

            <dd>Apache 2.0 sur Windows NT utilise &#224; pr&#233;sent l'utf-8 pour tous les 
            noms de fichiers. Ces noms de fichiers sont directement traduits vers
            l'encodage Unicode du syst&#232;me de fichiers, ce qui permet le support
            multilangue pour toutes les installations sur la famille NT de Windows, y
            compris Windows 2000 et Windows XP.<em>Ce support n'est pas fonctionnel
            pour Windows 95, 98 ni ME, qui utilisent les pages de code locales pour
            les acc&#232;s au syst&#232;me de fichiers, comme auparavant.</em></dd>

            <dt>Mise &#224; jour de la Biblioth&#232;que d'Expressions Rationnelles</dt>

            <dd>Apache 2.0 contient la <a href="http://www.pcre.org/">biblioth&#232;que 
            d'expressions rationnelles compatible Perl </a>(Perl Compatible Regular 
            Expression Library - PCRE). Toutes les expressions rationnelles sont dont
            g&#233;r&#233;es avec la syntaxe de Perl 5, plus puissante.</dd>

        </dl>
    </section>

    <section id="module">
        <title>Am&#233;lioration des Modules</title>

        <dl>
            <dt><module>mod_ssl</module></dt>

            <dd>Apparu dans Apache 2.0, ce module est une interface aux protocoles de 
            criffrement SSL/TLS fournis par OpenSSL.</dd>

            <dt><module>mod_dav</module></dt>

            <dd>Apparu dans Apache 2.0, ce module impl&#233;mente les sp&#233;cifications HTTP de 
            gestion distribu&#233;e de versions et de r&#233;daction (Distributed Authoring and 
            Versioning - DAV), destin&#233;es &#224; la mise en ligne et &#224; la maintenance des 
            contenus Web.</dd>

            <dt><module>mod_deflate</module></dt>

            <dd>Module apparu dans Apachge 2.0, mod_deflate permet aux navigateurs qui 
            le supportent de demander la compression des contenus envoy&#233;s par le serveur. 
            Cela &#224; l'avantage de r&#233;duite l'occupation de la bande passante.</dd>

            <dt><module>mod_auth_ldap</module></dt>

            <dd>Apparu dans Apache 2.0.41, ce module permet aux administrateurs
            d'utiliser un arbre LDAP pour g&#233;rer la base d'utilisateurs pour les 
            Authentifications Basiques HTTP. Un module voisin,
            <module>mod_ldap</module>, permet de globaliser les connexions &#224; l'arbre LDAP
            et de garder en m&#233;moire cache ces acc&#232;s.</dd>
    
            <dt><module>mod_auth_digest</module></dt>

            <dd>Am&#233;liore les fonctions de cache sur une session entre les diff&#233;rents
            processus, en utilisant de la m&#233;moire partag&#233;e.</dd>

            <dt><module>mod_charset_lite</module></dt>

            <dd>Apparu dans Apache 2.0, ce module exp&#233;rimental permet la conversion 
            et l'enregistrement entre jeux de caract&#232;res.</dd>

            <dt><module>mod_file_cache</module></dt>

            <dd>Apparu dans Apache 2.0, ce module impl&#233;mente les fonctionnalit&#233;s du 
            module <code>mod_mmap_static</code> pr&#233;sent dans Apache 1.3, et offre des 
            fonctions plus avanc&#233;es pour la gestion de la cache.</dd>

            <dt><module>mod_headers</module></dt>

            <dd>Ce module gagne beaucoup de flexibilit&#233; avec Apache 2.0 : on peut 
            d&#233;sormais l'utiliser pour modifier les en-t&#234;tes des requ&#234;tes 
            utilis&#233;s par <module>mod_proxy</module>, et peut aussi positionner les 
            en-t&#234;tes des r&#233;ponses de mani&#232;re conditionnelle.</dd>

            <dt><module>mod_proxy</module></dt>

            <dd>Le module proxy a &#233;t&#233; r&#233;&#233;crit de A &#224; Z. Il tire 
            maintenant avantage de la nouvelle infrastructure de filtrage, et impl&#233;mente 
            un mandataire plus fiable, et conforme aux normes HTTP/1.1. De nouvelles 
            sections de configuration ajout&#233;es &#224; 
            <directive module="mod_proxy" type="section">Proxy</directive> 
            donnent un contr&#244;le plus lisible et un traitement plus rapide des requ&#234;tes 
            proxifi&#233;s; les configurations surcharch&#233;es <code>&lt;Directory 
            "proxy:..."&gt;</code> ne sont pas support&#233;es. Le module a aussi &#233;t&#233; 
            fragment&#233; en plusieurs modules qui g&#233;rent chacun leur protocole : 
            <code>proxy_connect</code>, <code>proxy_ftp</code> et 
            <code>proxy_http</code>.</dd>

            <dt><module>mod_negotiation</module></dt>

            <dd>Une nouvelles directive, <directive
            module="mod_negotiation">ForceLanguagePriority</directive> a &#233;t&#233; ajout&#233;e, 
            elle permet de garantir que le client re&#231;oit un seul document dans tous les 
            cas, au lieu de r&#233;ponses NOT ACCEPTABLE ou MULTIPLE CHOICES. Les 
            algorithmes g&#233;rant la n&#233;gociation et les vues multiples (MultiViews) ont 
            &#233;t&#233; nettoy&#233;s et donnent des r&#233;ponses plus logiques. Un nouveau format de 
            carte de types (map type) qui peut aussi g&#233;rer le contenu de documents a 
            aussi &#233;t&#233; ajout&#233;.</dd>
    
            <dt><module>mod_autoindex</module></dt>

            <dd>Les listes auto-g&#233;n&#233;r&#233;s par Autoindex sont &#224; pr&#233;sent 
            configurables, et peuvent utiliser des tables HTML pour une mise en forme plus propre. 
            L'ordre d'affichage des fichiers est &#233;galement finement param&#232;trable, 
            comme pour le tri par version, et le filtrage par caract&#232;res jokers du 
            listage du r&#233;pertoire.</dd>

            <dt><module>mod_include</module></dt>

            <dd>De nouvelles directives permettent de modifier la valeur par d&#233;faut 
            des drapeaux <em>start</em> et <em>end</em> des &#233;l&#233;ments SSI. Ces directives 
            permettent &#224; la configuration d'affichage de dates et heures d'&#234;tre 
            effectu&#233;e dans le fichier de configuration principal, plut&#244;t que dans le 
            document SSI. Les r&#233;ponses donn&#233;es par des recherches par expressions 
            rationnelles (qui g&#232;rent &#224; pr&#233;sent les regex Perl) sont 
            recup&#233;r&#233;s au moyen des variables <code>$0</code> &#224; <code>$9</code>.</dd>

            <dt><module>mod_auth_dbm</module></dt>

            <dd>Plusieurs bases de donn&#233;es DBM sont support&#233;es, et s&#233;lectionnables 
            au moyen de la directive <directive 
            module="mod_auth_dbm">AuthDBMType</directive>.</dd>
        </dl>
    </section>
</manualpage>
