<?xml version='1.0' encoding='ISO-8859-1' ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.en.xsl"?>
<!-- English Revision: 151408 -->
<!-- French translation by alain B, review by Vincent Deffontaines -->

<!--
 Copyright 2005 The Apache Software Foundation or its licensors, as
 applicable.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="name-based.xml.meta">
<parentdocument href="./">Serveurs virtuels</parentdocument>
<title>Support Apache des serveurs virtuels par nom</title>

<summary>
    <p>Ce document dcrit quand et comment utiliser des serveurs 
    virtuels par nom.</p>
</summary>

<seealso><a href="ip-based.html">Support Apache des serveurs virtuels par IP</a></seealso>
<seealso><a href="details.html">Dtails sur le fonctionnement des serveurs virtuels</a></seealso>
<seealso><a href="mass.html">Configuration dynamique des hbergements virtuels de masse</a></seealso>
<seealso><a href="examples.html">Exemples d'utilisations de VirtualHost</a></seealso>
<seealso><a href="examples.html#serverpath">Utilisation de la directive ServerPath</a></seealso>

<section id="namevip"><title>Serveurs virtuels par nom vs. par IP</title>

    <p>Les hbergements virtuels par IP utilisent l'adresse IP 
    de la connexion afin de dterminer quel serveur virtuel doit 
    rpondre. Par consquent, vous devez disposer d'adresses IP 
    diffrentes pour chaque nom de domaine complet (FQDN) que vous hbergez. 
    Avec un hbergement 
    virtuel par nom, le serveur s'appuit sur les informations 
    transmises par le client dans les en-ttes HTTP de ses requtes. 
    La technique prsente ici vous permet de disposer de serveurs 
    virtuels diffrents partags sur une mme adresse IP.</p>

    <p>L'hbergement virtuel par nom est habituellement plus simple, 
    car il vous suffit de configurer votre serveur DNS pour que 
    chaque domaine pointe sur l'adresse IP dont vous disposez, et de 
    configurer votre serveur Apache HTTP afin qu'il reconnaisse 
    ces domaines. Il rduit aussi la pnurie en adresses IP. Par 
    consquent, vous devriez utiliser l'hbergement virtuel par 
    nom  moins d'avoir une raison spcifique de prfrer 
    l'hbergement virtuel par IP. Certaines de ces raisons vous 
    sont exposes ci-aprs&nbsp;:</p>

    <ul>
        <li>Certains anciens navigateurs ne sont pas compatibles 
        avec les serveurs virtuels par nom, car pour fonctionner, 
        un client doit transmettre un champ d'en-tte HTTP Host. 
        Cet en-tte est exig pour HTTP/1.1, et peut tre implment 
        sur des navigateurs modernes HTTP/1.0 grce  une extension. 
        Si vous devez maintenir des clients obsoltes tout en 
        utilisant l'hbergement virtuel par nom, il existe une 
        technique qui est traite  la fin de ce document.</li>

        <li>L'hbergement virtuel par nom ne peut pas tre utilis 
        avec des serveurs scuriss SSL  cause de la nature mme 
        du protocole SSL.</li>

        <li>Certains systmes d'exploitation et quipements rseaux 
        emploient des techniques de gestion de la bande passante 
        qui ne peuvent pas diffrencier des domaines autrement que 
        par des adresses IP spares.</li>
    </ul>

</section>

<section id="using"><title>Utilisation de serveurs virtuels par nom</title>

<related>
    <modulelist>
    <module>core</module>
    </modulelist>

    <directivelist>
	<directive module="core">DocumentRoot</directive>
	<directive module="core">NameVirtualHost</directive>
	<directive module="core">ServerAlias</directive>
	<directive module="core">ServerName</directive>
	<directive module="core">ServerPath</directive>
	<directive module="core" type="section">VirtualHost</directive>
    </directivelist>
</related>

    <p>Pour utiliser des serveurs virtuels par nom, vous devez 
    dsigner l'adresse IP (et si possible le port) sur le serveur 
    devant accepter les requtes pour des domaines. Cette 
    configuration utilise la directive 
    <directive module="core">NameVirtualHost</directive>. Dans un 
    cas normal o n'importe quelle adresse IP peut tre utilise, 
    vous pouvez ajouter <code>*</code> comme argument de la directive 
    <directive module="core">NameVirtualHost</directive>. Si vous 
    prvoyez d'utiliser de multiples ports (comme l'emploi de SSL), 
    vous devriez ajouter le port  cet argument tel que 
    <code>*:80</code>. Notez que la simple mention d'une adresse 
    IP dans une directive 
    <directive module="core">NameVirtualHost</directive> ne suffit 
    pas  faire couter le serveur sur cette IP. Consultez 
    <a href="../bind.html">la page sur les liaisons</a> pour plus 
    de dtails. Par ailleurs, chaque adresse IP spcifie ici doit 
    tre associe avec une interface rseau sur le serveur.</p>

    <p>L'tape suivante est la cration d'une section 
    <directive type="section" module="core">VirtualHost</directive> 
    pour chacun des serveurs  crer. L'argument de la directive 
    <directive type="section" module="core">VirtualHost</directive> 
    doit tre le mme que celui de la directive 
    <directive module="core">NameVirtualHost</directive> 
    (c'est--dire l'adresse IP ou <code>*</code> pour toutes les 
    adresses). Dans chaque section 
    <directive type="section" module="core">VirtualHost</directive>, 
    vous devez dfinir au minimum une directive 
    <directive module="core">ServerName</directive> pour dsigner 
    le serveur concern et une directive 
    <directive module="core">DocumentRoot</directive> pour prciser 
    l'emplacement sur le systme de fichiers du contenu de ce serveur.</p>

    <note><title>Le serveur principal disparat</title>
        <p>Si vous ajoutez des serveurs virtuels  un serveur Web 
        existant, vous devez galement crer une section 
        <directive type="section" module="core">VirtualHost</directive> 
        redfinissant ce serveur existant. Les directives 
        <directive module="core">ServerName</directive> et 
        <directive module="core">DocumentRoot</directive> incluses 
        dans ce serveur virtuel doivent tre les mmes que pour 
        les directives globales 
        <directive module="core">ServerName</directive> et 
        <directive module="core">DocumentRoot</directive>. Positionnez 
        ce serveur virtuel en premier dans le fichier de configuration 
        pour en faire le serveur par dfaut.</p>
    </note>

    <p>Par exemple, supposez que vous hbergez le domaine 
    <code>www.domain.tld</code> et que vous souhaitez ajouter le 
    serveur virtuel <code>www.otherdomain.tld</code> qui pointe sur 
    la mme adresse IP. Il vous suffit d'ajouter la configuration 
    suivante  <code>httpd.conf</code>&nbsp;:</p>

    <example>
        NameVirtualHost *:80<br />
        <br />
        &lt;VirtualHost *:80&gt;<br />
        <indent>
            ServerName www.domain.tld<br />
            ServerAlias domain.tld *.domain.tld<br />
            DocumentRoot /www/domain<br />
        </indent>
        &lt;/VirtualHost&gt;<br />
        <br />
        &lt;VirtualHost *:80&gt;<br />
        <indent>ServerName www.otherdomain.tld<br />
            DocumentRoot /www/otherdomain<br />
        </indent>
        &lt;/VirtualHost&gt;<br />
    </example>

    <p>Autrement, vous pouvez spcifiez une adresse IP explicite 
     la place de <code>*</code> dans les deux directives 
    <directive module="core" >NameVirtualHost</directive> et 
    <directive type="section" module="core" >VirtualHost</directive>. 
    Par exemple, cette mthode est utile si vous souhaitez faire 
    tourner quelques serveurs virtuels par nom sur une mme adresse 
    IP, et d'autres, soit par IP, soit bass sur un autre jeu de 
    serveurs virtuels par nom sur une autre adresse IP.</p>

    <p>Plusieurs serveurs sont accessibles par plus d'un nom. Il 
    suffit de placer la directive 
    <directive module="core">ServerAlias</directive> dans une section 
    <directive type="section" module="core">VirtualHost</directive>. 
    Par exemple, dans la premire section 
    <directive type="section" module="core">VirtualHost</directive> 
    ci-dessus, la directive <directive module="core">ServerAlias</directive> 
    indique aux utilisateurs les autres noms permis pour accder au 
    mme site Web&nbsp;:</p>

    <example>
        ServerAlias domain.tld *.domain.tld
    </example>

    <p>ainsi, toutes les requtes portant sur un domaine 
    <code>domain.tld</code> seront servies par le serveur virtuel 
    <code>www.domain.tld</code>. Les caractres joker <code>*</code> 
    et <code>?</code> peuvent tre utiliss pour les correspondances. 
    Bien entendu, vous ne pouvez pas inventer des noms et les placer 
    dans une directive <directive module="core">ServerName</directive> 
    ou <code>ServerAlias</code>. Tout d'abord, votre serveur DNS 
    doit tre correctement configur pour lier ces noms  une 
    adresse IP associe avec votre serveur.</p>

    <p>Finalement, vous pouvez affiner la configuration des serveurs 
    virtuels en plaant d'autres directives  l'intrieur des sections 
    <directive type="section" module="core">VirtualHost</directive>. 
    La plupart des directives peut tre place dans ces sections en 
    y changeant seulement la configuration du serveur virtuel associ. 
    Pour dterminer si une directive particulire est permise, 
    consultez <a href="../mod/directive-dict.html#Context">la page de 
    contexte</a>. Le jeu de directives configures dans le contexte 
    du <em>serveur principal</em> (en dehors de toutes sections 
    <directive type="section" module="core">VirtualHost</directive>) 
    sera utilis seulement s'il n'y a pas de configuration contraire 
    par un serveur virtuel.</p>

    <p>Maintenant, lorsqu'une requte arrive, le serveur va d'abord 
    tester si elle utilise une adresse IP qui correspond  
    <directive module="core" >NameVirtualHost</directive>. Si c'est 
    le cas, il regardera chaque section 
    <directive type="section" module="core">VirtualHost</directive> 
    avec l'adresse correspondante et essaiera d'en trouver une o 
    le nom de domaine requis correspond  
    <directive module="core">ServerName</directive> ou 
    <code>ServerAlias</code>. S'il en trouve une, il utilisera 
    sa configuration pour le serveur. Si aucun serveur virtuel ne 
    correspond, alors <em>le premier serveur virtuel list</em> 
    dont l'adresse IP correspond sera employ.</p>

    <p>En consquence, le premier serveur virtuel list est le 
    serveur virtuel <em>default</em>. La directive 
    <directive module="core">DocumentRoot</directive> du 
    <em>serveur principal</em> <strong>ne</strong> sera 
    <strong>jamais</strong> employe lorsqu'une adresse IP 
    correspond dans une directive 
    <directive module="core">NameVirtualHost</directive>. Si vous 
    ne voulez pas avoir de configuration spciale pour les requtes 
    qui ne sont pas attaches  un serveur virtuel en particulier, 
    mettez cette configuration dans une section 
    <directive type="section" module="core">VirtualHost</directive> 
    que vous placerez en premier dans le fichier de configuration.</p>

</section>

<section id="compat"><title>Compatibilit avec les navigateurs anciens</title>

    <p>Comme mentionn plus tt, certains clients ne transmettent 
    pas les donnes ncessaires pour le bon fonctionnement des 
    serveurs virtuels. Ces clients recevront toujours les pages 
    du premier serveur virtuel list pour cette adresse IP (le 
    serveur virtuel par nom <cite>primaire</cite>).</p>

    <note><title>De combien plus anciens&nbsp;?</title>
    <p>Veuillez noter que quand nous disons plus anciens, nous 
    disons vraiment plus anciens. Vous seriez malchanceux de rencontrer 
    de tels navigateurs encore utiliss de nos jours. Toutes les 
    versions actuelles des navigateurs transmettent leur en-tte 
    <code>Host</code> comme exig par les serveurs virtuels par nom.</p>
    </note>

    <p>Il existe une solution avec la directive 
    <directive module="core">ServerPath</directive>, bien que 
    lgrement complexe&nbsp;:</p>

    <p>Exemple de configuration&nbsp;:</p>

    <example>
        NameVirtualHost 111.22.33.44<br />
        <br />
        &lt;VirtualHost 111.22.33.44&gt;<br />
        <indent>
            ServerName www.domain.tld<br />
            ServerPath /domain<br />
            DocumentRoot /web/domain<br />
        </indent>
        &lt;/VirtualHost&gt;<br />
    </example>

    <p>Qu'est-ce que cela signifie&nbsp;? Il signifie qu'une requte 
    pour tout URI qui commence par "<code>/domain</code>" sera 
    servie par le serveur virtuel <code>www.domain.tld</code>. 
    Ainsi, les pages sont accessibles  
    <code>http://www.domain.tld/domain/</code> pour tous les 
    clients, bien que ceux qui transmettent un en-tte 
    <code>Host:</code> peuvent galement y accder  
    <code>http://www.domain.tld/</code>.</p>

    <p>Pour rendre cette technique fonctionnelle, mettez un lien 
    dans votre serveur virtuel primaire vers 
    <code>http://www.domain.tld/domain/</code>. Ensuite, dans les 
    pages de ce serveur virtuel, assurez vous ne n'utiliser que 
    des liens relatifs (<em>par exemple</em>, "<code>file.html</code>" 
    ou "<code>../icons/image.gif</code>") ou des liens contenant 
    le prfixe <code>/domain/</code> (<em>par exemple</em>, 
    "<code>http://www.domain.tld/domain/misc/file.html</code>" 
    ou "<code>/domain/misc/file.html</code>").</p>

    <p>Cela requiert un peu de discipline, mais si vous suivez 
    cette ligne de conduite, vous serez assur que vos pages 
    s'afficheront dans tous les navigateurs, nouveaux et anciens.</p>

</section>
</manualpage>
