<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 151408 -->

<!--
 Copyright 2004-2005 The Apache Software Foundation or its licensors,
                     as applicable.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="filter.xml.meta">

  <title>Filtres</title>

  <summary>
    <p>Ce document explique le fonctionnement des filtres avec Apache.</p>
  </summary>

  <section id="filters">
    <title>Filtres</title>
    <related>
      <modulelist>
        <module>mod_deflate</module>
        <module>mod_ext_filter</module>
        <module>mod_include</module>
      </modulelist>
      <directivelist>
        <directive module="mod_mime">AddInputFilter</directive>
        <directive module="mod_mime">AddOutputFilter</directive>
        <directive module="mod_mime">RemoveInputFilter</directive>
        <directive module="mod_mime">RemoveOutputFilter</directive>
        <directive module="mod_ext_filter">ExtFilterDefine</directive>
        <directive module="mod_ext_filter">ExtFilterOptions</directive>
        <directive module="core">SetInputFilter</directive>
        <directive module="core">SetOutputFilter</directive>
      </directivelist>
    </related>

    <p>On appelle <em>filtre</em> un processus qui s'applique aux donn&#233;es re&#231;ues
    ou envoy&#233;es par le serveur. Les <em>filtres en entr&#233;e ("input filters")</em>
    servent &#224; filtrer les donn&#233;es envoy&#233;es par les clients au serveur, tandis
    que les <em>filtres en sortie ("output filters")</em> travaillent sur les
    donn&#233;es envoy&#233;es par le serveur &#224; un client. Il est possible d'appliquer
    plusieurs filtres &#224; un flux de donn&#233;es, et l'ordre de ces filtres peux &#234;tre
    sp&#233;cifi&#233;e de fa&#231;on explicite.</p>
    
    <p>Apache utilise des filtres en interne pour par exemple g&#233;rer les "grosses" requ&#234;tes
    (chunked) ou les requ&#234;tes partielles (NDT : "byte-range" : requ&#234;tes sur seulement une
    partie d'un fichier sp&#233;cifi&#233;e par un pointeur de d&#233;part, et de fin). 
    Certains modules permettent en plus d'utiliser des filtres
    en utilisant des directives de configuration. Les filtres sont utilisables
    au moyen des directives
    <directive module="core">SetInputFilter</directive>,
    <directive module="core">SetOutputFilter</directive>,
    <directive module="mod_mime">AddInputFilter</directive>,
    <directive module="mod_mime">AddOutputFilter</directive>,
    <directive module="mod_mime">RemoveInputFilter</directive> et
    <directive module="mod_mime">RemoveOutputFilter</directive>
    .</p>

    <p>Les filtres list&#233;s ci-dessous sont fournis dans la distribution d'Apache, et
    peuvent &#234;tre utilis&#233;s par tout administrateur.</p>

    <dl>
      <dt>INCLUDES</dt>
      <dd>Le module <module>mod_include</module> travaille au moyen de
      "Server-Side Includes"</dd>
      <dt>DEFLATE</dt>
      <dd>Le module <module>mod_deflate</module> compresse les donn&#233;es avant leur envoi au 
      client (filtre en sortie).</dd>
    </dl>

    <p>En outre, le module <module>mod_ext_filter</module> permet d'utiliser des
    programes externes &#224; Apache en tant que filtres.</p>
  </section>
</manualpage>
