<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 421174 -->
<!-- French Translation by Vincent Deffontaines, review by alain B -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="filter.xml.meta">

  <title>Filtres</title>

  <summary>
    <p>Ce document explique le fonctionnement des filtres avec Apache.</p>
  </summary>

  <section id="filters">
    <title>Filtres</title>
    <related>
      <modulelist>
        <module>mod_deflate</module>
        <module>mod_ext_filter</module>
        <module>mod_include</module>
      </modulelist>
      <directivelist>
        <directive module="mod_mime">AddInputFilter</directive>
        <directive module="mod_mime">AddOutputFilter</directive>
        <directive module="mod_mime">RemoveInputFilter</directive>
        <directive module="mod_mime">RemoveOutputFilter</directive>
        <directive module="mod_ext_filter">ExtFilterDefine</directive>
        <directive module="mod_ext_filter">ExtFilterOptions</directive>
        <directive module="core">SetInputFilter</directive>
        <directive module="core">SetOutputFilter</directive>
      </directivelist>
    </related>

    <p>On appelle <em>filtre</em> un processus qui s'applique aux 
    donnes reues ou envoyes par le serveur. Les <em>filtres en 
    entre (input filters)</em> servent  filtrer les donnes envoyes 
    par les clients vers le serveur, tandis que les <em>filtres en sortie 
    (output filters)</em> traitent les donnes envoyes par le 
    serveur vers un client. Il est possible d'appliquer plusieurs 
    filtres sur un flux de donnes, et l'ordre de ces filtres est 
    configurable.</p>
    
    <p>Apache utilise des filtres en interne pour grer les &nbsp;grosses&nbsp; 
    requtes ou les requtes partielles (NdT sur "byte-range"&nbsp;: 
    requtes portant seulement sur une partie d'un fichier, partie 
    spcifie par un pointeur de dpart, et un pointeur de fin). 
    Certains modules permettent en plus d'utiliser des filtres en 
    utilisant des directives de configuration. Les filtres sont utilisables 
    au moyen des directives
    <directive module="core">SetInputFilter</directive>,
    <directive module="core">SetOutputFilter</directive>,
    <directive module="mod_mime">AddInputFilter</directive>,
    <directive module="mod_mime">AddOutputFilter</directive>,
    <directive module="mod_mime">RemoveInputFilter</directive>, et
    <directive module="mod_mime">RemoveOutputFilter</directive>
    .</p>

    <p>Les filtres lists ci-aprs sont fournis dans le paquetage Apache et
    sont utilisables par tout administrateur.</p>

    <dl>
      <dt>INCLUDES</dt>
      <dd>Gestion des "Server-Side Includes" grce au module 
      <module>mod_include</module></dd>
      <dt>DEFLATE</dt>
      <dd>Compression des donnes avant leur envoi au client (filtre en 
      sortie) au moyen de <module>mod_deflate</module>
      </dd>
    </dl>

    <p>Le module <module>mod_ext_filter</module> permet galement 
    d'utiliser des programmes externes  Apache en tant que filtres.</p>
  </section>
</manualpage>
