<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Support des objets partags dynamiques (DSO) - Serveur Apache HTTP</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.0</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.0</a></div><div id="page-content"><div id="preamble"><h1>Support des objets partags dynamiques (DSO)</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/dso.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/dso.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/dso.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/dso.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/dso.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>

    <p>Le serveur HTTP Apache est un programme modulaire permettant 
    l'administrateur de choisir les fonctionnalits qu'il souhaite 
    activer, au moyen de modules. Les modules peuvent tre intgrs
    dans le programme binaire <code>httpd</code> au moment de la 
    compilation. Il est galement possible de compiler  part des 
    modules en tant qu'objets dynamiques partags (Dynamic Shared 
    Objects&nbsp;: DSOs) existant sparment du fichier binaire principal 
    <code>httpd</code>. Les modules DSO peuvent tre compils en mme 
    temps que le serveur, ou aprs, au moyen de l'outil Apache pour 
    les extensions (<code class="program"><a href="./programs/apxs.html">apxs</a></code>).</p>

    <p>Ce document dcrit les principes de fonctionnement des modules DSO, et
    montre comment les utiliser.</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#implementation">Implmentation</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#usage">Rsum sur l'utilisation des DSO</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#background">Contexte</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#advantages">Avantages et Inconvnients</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="implementation" id="implementation">Implmentation</a></h2>

<table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_so.html">mod_so</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code></li></ul></td></tr></table>

    <p>Le support DSO servant  charger des modules Apache, est lui-mme 
    cod dans un module, nomm <code class="module"><a href="./mod/mod_so.html">mod_so</a></code>, qui doit tre 
    compil dans le noyau d'Apache. Ce module, ainsi que le module 
    <code class="module"><a href="./mod/core.html">core</a></code>, sont les deux seuls modules qui ne peuvent 
    tre compils sparment d'Apache. En pratique, tous les autres 
    modules d'Apache peuvent tre compils en tant que modules DSO, 
    en passant au script <code>configure</code> l'option 
    <code>--enable-<em>module</em>=shared</code>, comme prcis dans 
    la <a href="install.html">documentation d'installation</a>. Aprs 
    qu'un module ait t compil en DSO (nomm 
    <code>mod_monmodule.so</code>), il est possible d'utiliser la 
    directive de <code class="module"><a href="./mod/mod_so.html">mod_so</a></code>&nbsp;: <code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code> dans le fichier <code>httpd.conf</code>, 
    afin qu'Apache charge ledit module au dmarrage ou redmarrage du 
    serveur.</p>

    <p>Afin de simplifier la cration de fichiers DSO pour les 
    modules Apache (et en particulier les modules tiers), un nouveau 
    programme de support a t ajout&nbsp;: <a href="programs/apxs.html">apxs</a> (<em>APache eXtenSion</em>). Ce programme peut tre 
    utilis pour crer des modules DSO <em>en se passant de</em> 
    l'arborescence source d'Apache. L'ide en est simple&nbsp;: lors de 
    l'installation d'Apache, la commande <code>make install</code> 
    positionne les fichiers d'en-ttes C d'Apache, ainsi que les 
    options du compilateur et les options propres  la plate-forme 
    dans le programme <code>apxs</code>. Ceci permet  l'utilisateur 
    de compiler ses modules Apache, au moyen de <code>apxs</code>, 
    sans disposer de l'arborescence source d'Apache et sans devoir 
    manipuler les options de compilation ou les options propres  
    sa plate-forme.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="usage" id="usage">Rsum sur l'utilisation des DSO</a></h2>

    <p>Voici un rsum bref des fonctionnalits DSO d'Apache 2.0&nbsp;:</p>

    <ol>
      <li>
        Pour compiler et installer un module Apache <em>distribu 
        avec Apache</em>, par exemple <code>mod_foo.c</code>, en tant 
        que DSO, sous le nom <code>mod_foo.so</code>&nbsp;:

<div class="example"><p><code>
$ ./configure --prefix=/path/to/install --enable-foo=shared<br />
$ make install
</code></p></div>
      </li>

      <li>
        Pour compiler et installer un module Apache <em>fourni par un 
        tiers</em>, par exemple <code>mod_foo.c</code>, en tant que DSO, 
        sous le nom <code>mod_foo.so</code>&nbsp;:

<div class="example"><p><code>
$ ./configure --add-module=module_type:/chemin/vers/le/tiers/mod_foo.c --enable-foo=shared<br />
$ make install
</code></p></div>
      </li>

      <li>
        Pour configurer Apache afin qu'il puisse accepter les modules DSO&nbsp;:

<div class="example"><p><code>
$ ./configure --enable-so<br />
$ make install
</code></p></div>
      </li>

      <li>
        Pour compiler et installer un module Apache <em>fourni par un 
        tiers</em>, par exemple <code>mod_foo.c</code>, en tant que 
        DSO, et sans disposer de l'arborescence source d'Apache 
        (utilisation d'<a href="programs/apxs.html">apxs</a>)&nbsp;:

<div class="example"><p><code>
$ cd /chemin/vers/le/tiers<br />
$ apxs -c mod_foo.c<br />
$ apxs -i -a -n foo mod_foo.la
</code></p></div>
      </li>
    </ol>

    <p>Dans tous les cas, une fois qu'un module a t compil en tant 
    que DSO, vous devrez utiliser la directive 
    <code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code> dans le 
    fichier <code>httpd.conf</code> afin qu'Apache active le module.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="background" id="background">Contexte</a></h2>

    <p>Sur les systmes rcents, drivs d'Unix, il existe un procd 
    lgant, habituellement appel chargement dynamique d'objets 
    partags DSO,  permettant de compiler un morceau de code sous un 
    format spcial, et de pouvoir le charger en temps rel dans 
    l'espace d'adressage d'un programme excutable.</p>
    
    <p>Ce chargement peut tre ralis de deux manires&nbsp;: 
    automatiquement, grce  un programme systme nomm <code>ld.so</code> 
    lors du dmarrage d'un excutable, ou manuellement depuis un programme 
    en excution via une interface programme au moyen des appels 
    systmes <code>dlopen()/dlsym()</code> du "chargeur" Unix</p>
    
    <p>Dans le premier cas, il est courant d'appeler les DSO des 
    <em>bibliothques partages</em> ou des <em>bibliothques DSO</em>&nbsp;; 
    on les nomme <code>libfoo.so</code> ou <code>libfoo.so.1.2</code>. 
    Elles sont toutes places dans un rpertoire systme (souvent 
    <code>/usr/lib</code>) et sont lies par les programmes excutables 
    lors de la compilation de ces derniers, en prcisant au moment de 
    la compilation l'option <code>-lfoo</code>  la commande de link 
    (linker command). Cette manire de procder insre les rfrences 
    des bibliothques dans le coeur des programmes, afin qu'au moment 
    du dmarrage du programme, le "chargeur" Unix puisse trouver 
    <code>libfoo.so</code> dans <code>/usr/lib</code>, ou bien dans 
    les chemins cods en dur au moyen de l'option de link <code>-R</code>, 
    ou dans un chemin configur au moyen de la variable d'environnement 
    <code>LD_LIBRARY_PATH</code>. Tous les symboles non rsolus prsents 
    dans le programme sont alors rsolus au moyen de DSO.</p>

    <p>Les symboles propres au programme excutable ne sont gnralement 
    pas rfrencs par le DSO (puisque c'est une bibliothque de code 
    gnrique), et donc aucune rsolution ne doit tre suivie au del 
    de ce point. Le programme excutable n'a pas de travail particulier 
     faire pour rsoudre les symboles des DSO, puisque c'est le 
    "chargeur" Unix qui s'occupe de cette tche. (En ralit, le code 
    utilis pour invoquer <code>ld.so</code> fait partie du code de 
    dmarrage run-time, qui est li  chaque programme excutable 
    non statique). L'avantage du chargement dynamique des bibliothques 
    de code gnrique est vident&nbsp;: le code n'est conserv qu' un seul 
    endroit du disque, dans une bibliothque systme comme 
    <code>libc.so</code>, ce qui permet de gagner de l'espace disque 
    pour chaque programme.</p>

    <p>Dans le second cas, les DSO sont appels <em>objets partags</em> 
    ou <em>fichiers DSO</em> et on peut leur attribuer une extension au 
    choix (bien que leur nom soit habituellement <code>foo.so</code>). 
    Ces fichiers rsident normalement dans un rpertoire propre au 
    programme qui les utilise, et ils ne sont pas lis de manire 
    automatique au programme qui les appelle. Celui-ci les charge en 
    temps rel lors de son excution, au moyen de <code>dlopen()</code>. 
     cet instant, aucune rsolution des symboles du DSO n'est ralise. 
    C'est le "chargeur" Unix qui ralise la tche de rsoudre les 
    symboles non rsolus du DSO,  partir du jeu de symboles exports 
    par le programme et ses bibliothques DSO (en particulier, tous 
    les symboles de l'omniprsente <code>libc.so</code>). Ainsi, le DSO 
    gagne la connaissance des symboles du programme excutable, comme 
    s'il lui avait t li statiquement au dpart.</p>
    
    <p>Enfin, pour tirer parti de l'API DSO, l'excutable doit rsoudre 
    les symboles propres au DSO via <code>dlsym()</code>, pour les 
    utiliser plus tard dans les tables de rpartition (NdT&nbsp;: "dispatch 
    tables"), <em>etc.</em> En d'autres termes, le programme excutable 
    doit rsoudre lui-mme chaque symbole pour utiliser chacun d'entre 
    eux. L'avantage de ce mcanisme est que les parties optionnelles 
    d'un programme ne sont pas charges (et donc, n'encombrent pas la 
    mmoire) avant que le programme n'en ait effectivement besoin. 
    Quand elles deviennent ncessaires, ces parties du programme peuvent 
    tre charges dynamiquement pour tendre les fonctionnalits du 
    programme.</p>

    <p>Bien que ce fonctionnement de DSO puisse paratre simple  
    comprendre, il existe au moins une difficult d'implmentation&nbsp;: 
    permettre au DSO de rsoudre les symboles du programme quand un DSO 
    est utilis pour tendre un programme. Pourquoi cela&nbsp;? Parce que la 
    "rsolution  l'envers" des symboles DSO  partir des symboles du 
    programme excutable est contraire au principe de conception des 
    bibliothques (o, rappelons-le, la bibliothque ne sait rien du 
    programme qui l'utilise)&nbsp;; cette "rsolution  l'envers" n'est pas 
    standardise, et n'existe pas sur toutes les plates-formes. En 
    pratique, les symboles globaux d'un programme excutable ne sont 
    que rarement rexports vers un DSO, et donc ne sont pas accessibles. 
    Celui qui veut pouvoir tendre les fonctionnalits d'un programme 
    dynamiquement, lors de l'excution, doit trouver un moyen de forcer 
    le programme de liaison  exporter tous les symboles globaux de ce 
    programme.</p>

    <p>L'approche par bibliothques partages est de loin la plus courante
    parce que c'est celle pour laquelle les mcanismes DSO ont t conus&nbsp;; 
    elle est donc utilise par presque toutes les bibliothques du systme
    d'exploitation. De l'autre cot, l'utilisation des objets partags reste 
    une approche marginale.</p>
    
    <p>Depuis 1998, seules quelques solutions logiciels existantes 
    utilisent le mcanisme des DSO pour tendre leurs fonctionnalits 
    en cours excution&nbsp;: Perl 5 (via son "XS mechanism" et le module 
    DynaLoader), Netscape Server, <em>etc.</em> Depuis la version 1.3, 
    Apache a rejoint ce groupe, car Apache utilise une approche 
    modulaire pour tendre ses fonctionnalits, et utilise de manire 
    interne des mcanismes de rpartition par liste pour lier des 
    modules externes  son noyau. Apache tait vraiment prdestin, 
    par concept,  utiliser les DSO pour charger ses modules en temps 
    rel.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="advantages" id="advantages">Avantages et Inconvnients</a></h2>

    <p>Les possibilits des DSO dcrites ci-avant prsentent les
    avantages suivants&nbsp;:</p>

    <ul>
      <li>Le paquetage du serveur est plus flexible lors de son excution, 
      car les processus du serveur central peuvent tre tendus pendant 
      son excution, au moyen de la directive 
      <code class="directive"><a href="./mod/mod_so.html#loadmodule">LoadModule</a></code>, dans 
      <code>httpd.conf</code>, plutt que forcer les utilisateurs  
      recompiler le serveur pour modifier ses fonctionnalits. Par 
      exemple, ce mode de fonctionnement permet de faire tourner 
      plusieurs instances du serveur (version standard &amp; SSL 
      version, version minimaliste &amp; tendue [mod_perl, PHP3], 
      <em>etc.</em>) au moyen d'une seule installation d'Apache.</li>

      <li>Il est trs facile d'tendre les fonctionnalits du serveur 
      de base, mme aprs son installation. Ceci est d'un grand secours 
      aux mainteneurs des paquets qui peuvent facilement crer des 
      paquets pour l'installation de base d'Apache et d'autres paquets 
      diffrents pour les extensions, comme PHP3, mod_perl, 
      mod_fastcgi, <em>etc.</em></li>

      <li>Facilit de dveloppement des modules Apache&nbsp;; grce aux outils
      DSO/<code>apxs</code>, ce travail est faisable sans l'arborescence 
      source d'Apache, et ne ncessite qu'une commande <code>apxs -i</code> 
      suivi d'un <code>apachectl restart</code> pour ajouter au serveur 
      dj en marche les fonctionnalits du module dvelopp.</li>
    </ul>

    <p>Les inconvnients lis  l'utilisation des DSO&nbsp;:</p>

    <ul>
      <li>Les mcanismes de DSO ne sont pas portables sur toutes les
      plates-formes, car tous les systmes d'exploitation ne supportent 
      pas le chargement dynamique de code dans l'espace d'adressage d'un 
      programme en marche.</li>

      <li>Le serveur est  peu prs 20% plus lent au dmarrage,  cause de la
      charge prise par le "chargeur" Unix de la rsolution des symboles.</li>

      <li>Le serveur est  peu prs 5% plus lent en fonctionnement sur 
      certaines plates-formes parce que le code indpendant de la 
      position ("position independent code" - PIC) requiert parfois des 
      tours de passe-passe en assembleur pour l'adressage relatif, ce qui 
      n'est pas toujours aussi rapide que l'adressage absolu.</li>

      <li>Les modules DSO ne pouvant pas tre lis  d'autres bibliothques 
      DSO (<code>ld -lfoo</code>) sur toutes les plates-formes (par 
      exemple, les plates-formes bases sur a.out ne le permettent pas, 
      alors que celles bases sur ELF le permettent), il n'est pas possible
      d'utiliser les mcanismes de DSO pour tous les modules. En d'autres
      termes, les modules compils en tant que fichiers DSO sont limits 
       l'utilisation des symboles exports par le noyau d'Apache, par 
      la bibliothque C (<code>libc</code>) et toute autre bibliothque 
      dynamique ou statique utilise par le noyau d'Apache, ou par des 
      archives de bibliothques statiques (<code>libfoo.a</code>) qui 
      contiennent du code indpendant de la position. Les seuls moyens 
      d'utiliser du code  l'extrieur d'un fichier DSO sont, soit de 
      s'assurer que le noyau d'Apache contienne une rfrence vers ce 
      code, soit de charger ce code au moyen de <code>dlopen()</code>.</li>
    </ul>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/dso.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/dso.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/dso.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/dso.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/dso.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2007 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div>
</body></html>