<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Apache et les variables d'environnement - Serveur Apache HTTP</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.0</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.0</a></div><div id="page-content"><div id="preamble"><h1>Apache et les variables d'environnement</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/env.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/env.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/env.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/env.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/env.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<div class="outofdate">Cette traduction peut tre prime. Consultez la version
            Anglaise pour les changements rcents.</div>

    <p>Le serveur HTTP Apache permet de conserver et d'utiliser 
    certaines informations dans des variables appeles <em>variables 
    d'environnement</em>. Ces informations peuvent servir  contrler 
    divers paramtres tels que la journalisation ou le contrle d'accs. 
    Ces variables sont galement utilises pour communiquer avec d'autres 
    programmes, comme les scripts CGI. Ce document traite des manires 
    de manipuler et de tirer parti de ces variables.</p>

    <p>Bien qu'elles soient appeles <em>variables d'environnement</em>, 
    il ne s'agit pas de variables d'environnement contrles par le 
    systme d'exploitation. Ces variables sont conserves, et manipules 
    suivant des mcanismes internes  Apache. Elles sont transformes 
    en vritables variables d'environnement (au sens systme) seulement 
    quand elles doivent tre passes  des scripts CGI ou  des scripts 
    'Server Side Includes'. Pour manipuler l'environnement du systme 
    d'exploitation sur lequel tourne un serveur Apache, il suffit 
    d'utiliser les mthodes standard fournies par l'interprteur de 
    commandes du systme d'exploitation.</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#setting">Dfinir les variables d'environnement</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#using">Utilisation des variables d'environnement</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#special">Variables d'environnement spciales</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#examples">Exemples</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="setting" id="setting">Dfinir les variables d'environnement</a></h2>
    
    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_env.html">mod_env</a></code></li><li><code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code></li><li><code class="module"><a href="./mod/mod_setenvif.html">mod_setenvif</a></code></li><li><code class="module"><a href="./mod/mod_unique_id.html">mod_unique_id</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_setenvif.html#browsermatch">BrowserMatch</a></code></li><li><code class="directive"><a href="./mod/mod_setenvif.html#browsermatchnocase">BrowserMatchNoCase</a></code></li><li><code class="directive"><a href="./mod/mod_env.html#passenv">PassEnv</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewriterule">RewriteRule</a></code></li><li><code class="directive"><a href="./mod/mod_env.html#setenv">SetEnv</a></code></li><li><code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code></li><li><code class="directive"><a href="./mod/mod_setenvif.html#setenvifnocase">SetEnvIfNoCase</a></code></li><li><code class="directive"><a href="./mod/mod_env.html#unsetenv">UnsetEnv</a></code></li></ul></td></tr></table>

    <h3><a name="basic-manipulation" id="basic-manipulation">Manipulations simples de l'environnement</a></h3>
        

        <p>La mthode la plus simple pour dfinir une variable 
        d'environnement dans Apache est d'utiliser la directive 
        <code class="directive"><a href="./mod/mod_env.html#setenv">SetEnv</a></code>. Les variables 
        peuvent galement tre charges depuis l'interprteur de 
        commandes  partir duquel le serveur a t dmarr, au moyen 
        de la directive <code class="directive"><a href="./mod/mod_env.html#passenv">PassEnv</a></code>.</p>
        
    
    <h3><a name="conditional" id="conditional">Paramtrage selon les requtes</a></h3>
        

        <p>Dans un but de souplesse, les directives que mod_setenvif 
        permet d'utiliser sont ajustables en fonction de certaines 
        caractristiques des requtes parvenant au serveur. Par exemple, 
        il est possible de dfinir une variable seulement si la requte 
        provient d'un certain type de navigateur (User-Agent), ou bien 
        si un champ Referer bien prcis est trouv. Une souplesse encore 
        plus grande est offerte par la directive 
        <code class="directive"><a href="./mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> du 
        module mod_rewrite qui accepte le paramtre <code>[E=...]
        </code> pour dfinir des variables d'environnement.</p>

    
    <h3><a name="unique-identifiers" id="unique-identifiers">Identifiants uniques</a></h3>
        

        <p>Enfin, la variable d'environnement <code>UNIQUE_ID</code> 
        est cre par mod_unique_id pour chaque requte, de manire  
        tre unique et donc reprsentative de chaque requte.</p>

    
    <h3><a name="standard-cgi" id="standard-cgi">Variables CGI standard</a></h3>
        

        <p>En plus de toutes les variables d'environnement dfinies dans 
        la configuration d'Apache et celles du systme d'exploitation, 
        les <a href="http://cgi-spec.golux.com/">spcifications 
        CGI</a> demandent que certaines variables d'environnement 
        contenant des informations propres  la requte soient toujours 
        passes aux scripts CGI et aux pages SSI.</p>

    
    <h3><a name="caveats" id="caveats">Problmes possibles</a></h3>
        

        <ul>
          <li>Il n'est pas possible de remplacer la valeur des variables 
          CGI standard au moyen des directives qui manipulent les 
          variables d'environnement.</li>

          <li>Dans les cas o les scripts CGI sont lancs au moyen de 
          <a href="suexec.html">suexec</a>, l'environnement est nettoy et 
          les variables sont initialises avec des valeurs <em>sres</em>, 
          dfinies lors de la compilation de <code>suexec.c</code>.</li>

          <li>Pour des raisons d'interoprabilit, les noms des variables 
          d'environnement ne peuvent tre constitus que de lettres, de 
          chiffres et du caractre de soulignement '_'. De plus, le 
          premier caractre du nom ne peut pas tre un chiffre. Les 
          caractres en contradiction avec ces rgles sont remplacs par 
          des caractres de soulignement avant que les variables ne 
          soient transmises aux scripts CGI ou aux pages SSI.</li>
        </ul>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="using" id="using">Utilisation des variables d'environnement</a></h2>
    

    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_access.html">mod_access</a></code></li><li><code class="module"><a href="./mod/mod_cgi.html">mod_cgi</a></code></li><li><code class="module"><a href="./mod/mod_ext_filter.html">mod_ext_filter</a></code></li><li><code class="module"><a href="./mod/mod_headers.html">mod_headers</a></code></li><li><code class="module"><a href="./mod/mod_include.html">mod_include</a></code></li><li><code class="module"><a href="./mod/mod_log_config.html">mod_log_config</a></code></li><li><code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_access.html#allow">Allow</a></code></li><li><code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code></li><li><code class="directive"><a href="./mod/mod_access.html#deny">Deny</a></code></li><li><code class="directive"><a href="./mod/mod_ext_filter.html#extfilterdefine">ExtFilterDefine</a></code></li><li><code class="directive"><a href="./mod/mod_headers.html#header">Header</a></code></li><li><code class="directive"><a href="./mod/mod_log_config.html#logformat">LogFormat</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewritecond">RewriteCond</a></code></li><li><code class="directive"><a href="./mod/mod_rewrite.html#rewriterule">RewriteRule</a></code></li></ul></td></tr></table>

    <h3><a name="cgi-scripts" id="cgi-scripts">Scripts CGI</a></h3>
        

        <p>Une des principales utilisations des variables d'environnement 
        est l'envoi d'informations aux scripts CGI. Comme prcis ci-
        avant, l'environnement pass aux scripts CGI contient des 
        informations standard au sujet de la requte en plus de toutes 
        les variables initialises au travers de la configuration 
        d'Apache. Pour plus de dtails, consultez le 
        <a href="howto/cgi.html">tutorial CGI</a>.</p>

    
    <h3><a name="ssi-pages" id="ssi-pages">Pages SSI</a></h3>
        

        <p>Les documents analyss par le serveur (documents SSI), grs 
        par le filtre <code>INCLUDES</code> de mod_include, peuvent 
        demander l'affichage de variables d'environnement au moyen de 
        l'lment <code>echo</code>, et peuvent les utiliser pour 
        personnaliser des pages en fonctions de certaines caractristiques 
        de la requte. Apache permet aussi l'utilisation de pages SSI avec 
        les variables d'environnement standard CGI comme discut ci-avant. 
        Consultez le <a href="howto/ssi.html">tutorial SSI</a> 
        pour plus d'informations.</p>
	
    
    <h3><a name="access-control" id="access-control">Contrle d'accs</a></h3>
        

        <p>Les droits d'accs au serveur peuvent tre contrls au moyen 
        de variables d'environnement en utilisant les directives 
        <code>allow from env=</code> et <code>deny from env=</code>. 
        Celles ci, utilises avec <code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code>, permettent un contrle d'accs au serveur 
        trs souple en fonction de caractristiques propres au client. Par 
        exemple, il est possible d'utiliser ces directives pour refuser 
        l'accs au serveur  certains navigateurs (User-Agent).</p>

    
    <h3><a name="logging" id="logging">Journalisation sous certaines conditions</a></h3>
        

        <p>Les variables d'environnement peuvent tre enregistres dans 
        le journal des accs ('access log') au moyen de l'option 
        <code>%e</code> de <code class="directive"><a href="./mod/mod_log_config.html#logformat">LogFormat</a></code>. De plus, la dcision d'enregistrer ou 
        non certaines requtes peut tre prise en fonction des variables 
        d'environnement au moyen de la directive 
        <code class="directive"><a href="./mod/mod_log_config.html#customlog">CustomLog</a></code>. Cette 
        mthode, utilise avec la directive <code class="directive"><a href="./mod/mod_setenvif.html#setenvif">SetEnvIf</a></code>, permet un contrle trs souple de 
        l'enregistrement des requtes. Par exemple, il est possible de 
        ne pas garder de trace des requtes demandant des noms de fichiers 
        se terminant par <code>gif</code>, ou de n'enregistrer que les 
        requtes des clients situs hors du sous-rseau auquel appartient 
        le serveur.</p>

    
    <h3><a name="response-headers" id="response-headers">Personnaliser les en-ttes des rponses HTTP</a></h3>
        

        <p>La directive <code class="directive"><a href="./mod/mod_headers.html#header">Header</a></code> 
        peut tirer parti de l'existence ou non d'une variable 
        d'environnement afin de choisir d'inclure certains en-ttes 
        HTTP dans la rponse retourne au client. Ceci permet, par 
        exemple, d'envoyer un certain en-tte de rponse seulement si un 
        en-tte similaire a t positionn dans la requte manant du 
        client.</p>

    

    <h3><a name="external-filter" id="external-filter">Activation des filtres externes</a></h3>
        

        <p>Il est possible d'utiliser une variable d'environnement pour 
        activer les filtres externes (grs par 
        <code class="module"><a href="./mod/mod_ext_filter.html">mod_ext_filter</a></code> au moyen de la directive 
        <code class="directive"><a href="./mod/mod_ext_filter.html#extfilterdefine">ExtFilterDefine</a></code>) 
        grce aux options <code>disableenv=</code> et 
        <code>enableenv=</code>.</p>
    

    <h3><a name="url-rewriting" id="url-rewriting">Rcriture d'URL</a></h3>
        

        <p>La forme <code>%{ENV:...}</code> de <em>TestString</em>, dans 
        la directive <code class="directive"><a href="./mod/mod_rewrite.html#rewritecond">RewriteCond</a></code>, permet au moteur de rcriture de 
        mod_rewrite d'utiliser les variables d'environnement pour 
        contrler les rcritures. Notez que toutes les variables 
        internes  mod_rewrite, accessibles sans le prfixe 
        <code>ENV:</code>, ne sont pas des variables d'environnement 
        d'Apache. Elles sont uniquement propres  mod_rewrite et ne 
        peuvent pas tre utilises par d'autres modules.</p>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="special" id="special">Variables d'environnement spciales</a></h2>
    

        <p>Certains problmes lis  l'interoprabilit ont conduit  la 
        mise en place de mcanismes spciaux, qui modifient le 
        fonctionnement d'Apache selon le type des clients auxquels il 
        rpond. Afin de garantir la plus grande souplesse possible, ces 
        mcanismes sont contrls par des variables d'environnement 
        spciales, telles que <code class="directive"><a href="./mod/mod_setenvif.html#browsermatch">BrowserMatch</a></code>, bien qu'on puisse galement utiliser 
        <code class="directive"><a href="./mod/mod_env.html#setenv">SetEnv</a></code> et 
        <code class="directive"><a href="./mod/mod_env.html#passenv">PassEnv</a></code> par exemple.</p>
	
    <h3><a name="downgrade" id="downgrade">downgrade-1.0</a></h3>
        

        <p>Ceci oblige Apache  traiter la requte comme du HTTP/1.0 mme 
        si elle a t construite sur une norme plus rcente.</p>

    
    <h3><a name="force-no-vary" id="force-no-vary">force-no-vary</a></h3>
        

        <p>Ceci provoque l'effacement de tous les champs <code>Vary</code> 
        de l'en-tte de rponse avant qu'il ne soit envoy au client. 
        Certains clients interprtent mal ce champ (voir 
        <a href="misc/known_client_problems.html">les problmes avec 
        certains clients</a>), et initialiser cette variable peut 
        permettre de rsoudre ce problme. Cette variable requiert 
        galement l'utilisation de <strong>force-response-1.0</strong>.</p>

    
    <h3><a name="force-response" id="force-response">force-response-1.0</a></h3>
        

      <p>Ceci oblige Apache  n'envoyer que des rponses en HTTP/1.0 aux 
      clients ralisant une requte en HTTP/1.0. Cette fonction a t 
      implmente au dpart pour rsoudre un problme avec les serveurs 
      mandataires d'AOL. Certains clients HTTP/1.0 ragissent mal quand 
      ils reoivent une rponse en HTTP/1.1, ce qui peut poser des 
      problmes d'interoprabilit avec eux.</p>

    

    <h3><a name="gzip-only-text-html" id="gzip-only-text-html">gzip-only-text/html</a></h3>
        

        <p>Si cette variable est positionne avec une valeur de "1", le 
        filtre de sortie DEFLATE du module <code class="module"><a href="./mod/mod_deflate.html">mod_deflate</a></code> 
        se retrouve dsactiv pour les documents dont le type mime n'est 
        pas <code>text/html</code>.</p>
	
    

    <h3><a name="no-gzip" id="no-gzip">no-gzip</a></h3>

        <p>Si cette variable est initialise, le filtre <code>DEFLATE</code> 
        du module <code class="module"><a href="./mod/mod_deflate.html">mod_deflate</a></code> est totalement dsactiv.</p>

    

    <h3><a name="nokeepalive" id="nokeepalive">nokeepalive</a></h3>
        

        <p>Si cette variable est initialise, les fonctions 
        <code class="directive"><a href="./mod/core.html#keepalive">KeepAlive</a></code> sont dsactives.</p>

    

    <h3><a name="prefer-language" id="prefer-language">prefer-language</a></h3>

        <p>Cette variable modifie le fonctionnement de 
        <code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code>. Si la variable contient un 
        marqueur de langue (comme <code>en</code>, <code>ja</code> ou 
        <code>x-klingon</code>), le module <code class="module"><a href="./mod/mod_negotiation.html">mod_negotiation</a></code> 
        va tenter de fournir une rponse dans cette langue parmi les 
        variantes possibles. Si aucune de ces variantes n'existe, une 
        <a href="content-negotiation.html">ngociation</a> normale aura 
        lieu.</p>

    

    <h3><a name="redirect-carefully" id="redirect-carefully">redirect-carefully</a></h3>
        

        <p>Cette variable rend le serveur plus attentif quand il doit 
        envoyer une redirection au client. Cette variable est 
        habituellement utilise quand un client a un problme connu 
        pour grer les redirections. Cette variable a t implmente 
        pour pallier  un problme du logiciel WebFolders de Microsoft 
        qui ne sait pas grer correctement les redirections vers les 
        rpertoires via les mthodes DAV.</p>

    

   <h3><a name="suppress-error-charset" id="suppress-error-charset">suppress-error-charset</a></h3>
       

    <p><em>Existe depuis la version 2.0.40</em></p>

    <p>Quand Apache envoie une redirection en rponse  une requte, la 
    rponse contient un message  afficher par le client, au cas o il 
    ne peut suivre automatiquement la redirection. Le fonctionnement 
    par dfaut d'Apache est d'crire ce texte avec le jeu de caractre 
    qu'il utilise, c'est  dire ISO-8859-1.</p>
    <p>Cependant, si la redirection pointe vers une page prsentant un jeu 
    de caractres diffrent, certains navigateurs buggs utilisent le jeu 
    de caractres du texte de la redirection, au lieu de celui de la page 
    qu'ils affichaient. De ce fait, un texte en grec serait mal affich.</p>
    <p>Si cette variable d'environnement est utilise, Apache n'indiquera 
    pas le jeu de caractre dans le texte de la redirection, ce qui permet 
     ces navigateurs d'afficher correctement la page de destination.</p>

   

  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples</a></h2>
    

    <h3><a name="misbehaving" id="misbehaving">Modifier le fonctionnement d'un protocole pour les clients 
        qui le grent mal</a></h3>
        

        <p>Il est conseill de placer les lignes suivantes dans httpd.conf 
        afin de grer des problmes connus de certains clients.</p>
<div class="example"><pre>
#
# Les directives ci-aprs modifient le fonctionnement standard de HTTP.
# La premire directive dsactive les fonctions keepalive pour les 
# navigateurs disant s'appeler 'Netscape 2.x'
# Il existe des problmes connus avec ces navigateurs.
# La deuxime directive gre Internet Explorer 4.0b2 de Microsoft qui
# n'implmente pas correctement HTTP/1.1 et qui ne supporte pas les 
# fonctions keepalive quand la rponse du serveur contient des codes 301 
# ou 302 (redirections)
#
BrowserMatch "Mozilla/2" nokeepalive
BrowserMatch "MSIE 4\.0b2;" nokeepalive downgrade-1.0 force-response-1.0

#
# Les directives ci-dessous dsactivent HTTP/1.1 pour les navigateurs qui 
# violent les spcifications HTTP/1.0, en ne sachant pas analyser des 
# rponses basiques en HTTP/1.1.
#
BrowserMatch "RealPlayer 4\.0" force-response-1.0
BrowserMatch "Java/1\.0" force-response-1.0
BrowserMatch "JDK/1\.0" force-response-1.0</pre></div>

    
    <h3><a name="no-img-log" id="no-img-log">Ne pas enregistrer les requtes pour des images dans le 
        journal des accs</a></h3>
        

        <p>Cet exemple montre comment ne pas enregistrer les requtes  
        destination d'images dans le journal des accs. Il est facile 
        de le modifier, pour limiter l'enregistrement  certains 
        rpertoires, ou pour des requtes venant de machines prcises.</p>
    <div class="example"><pre>
SetEnvIf Request_URI \.gif image-request
SetEnvIf Request_URI \.jpg image-request
SetEnvIf Request_URI \.png image-request
CustomLog logs/access_log common env=!image-request</pre></div>

    
    <h3><a name="image-theft" id="image-theft">Empcher le &nbsp;vol d'images&nbsp;</a></h3>
        

        <p>Cet exemple montre comment empcher le chargement d'images de 
        votre serveur depuis des pages qui ne sont pas hberges sur 
        celui-ci. Cette configuration n'est pas conseille, mais elle 
        peut tre utile dans certaines circonstances. Il est suppos ici 
        que toutes les images sont stockes dans le rpertoire 
        /web/images.</p>
    <div class="example"><pre>
SetEnvIf Referer "^http://www.example.com/" local_referal
# Autorise les navigateurs qui n'envoient pas de champ Referer
SetEnvIf Referer "^$" local_referal
&lt;Directory /web/images&gt;
   Order Deny,Allow
   Deny from all
   Allow from env=local_referal
&lt;/Directory&gt;</pre></div>

        <p>Pour plus d'informations sur cette technique, consultez le 
        tutorial ApacheToday &nbsp;<a href="http://apachetoday.com/news_story.php3?ltsn=2000-06-14-002-01-PS">Keeping Your Images from Adorning Other Sites</a>&nbsp;.</p>
    
  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/env.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/env.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/env.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/env.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/env.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2006 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div>
</body></html>