#define ICONV_INTERNAL
#include <iconv.h>

static const iconv_ccs_convtable_7bit to_ucs_21 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4E28, 0x4E36, 0x4E3F, 0x4E85, 0x4E05, 0x4E04, 0x5182,
	0x5196, 0x5338, 0x5369, 0x53B6, 0x4E2A, 0x4E87, 0x4E49, 0x51E2,
	0x4E46, 0x4E8F, 0x4EBC, 0x4EBE, 0x5166, 0x51E3, 0x5204, 0x529C,
	0xFFFE, 0x5902, 0x590A, 0x5B80, 0x5DDB, 0x5E7A, 0x5E7F, 0x5EF4,
	0x5F50, 0x5F51, 0x5F61, 0x961D, 0xFFFE, 0x4E63, 0x4E62, 0x4EA3,
	0x5185, 0x4EC5, 0x4ECF, 0x4ECE, 0x4ECC, 0x5184, 0x5186, 0xFFFE,
	0xFFFE, 0x51E4, 0x5205, 0x529E, 0x529D, 0x52FD, 0x5300, 0x533A,
	0xFFFE, 0x5346, 0x535D, 0x5386, 0x53B7, 0xFFFE, 0x53CC, 0xFFFE,
	0x53CE, 0x5721, 0xFFFE, 0x5E00, 0x5F0C, 0x6237, 0x6238, 0x6534,
	0x6535, 0x65E0, 0xFFFE, 0x738D, 0x4E97, 0x4EE0, 0xFFFE, 0xFFFE,
	0x4EE7, 0xFFFE, 0x4EE6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x56D8,
	0x518B, 0x518C, 0x5199, 0x51E5, 0xFFFE, 0x520B, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_22 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5304, 0x5303, 0x5307, 0xFFFE, 0x531E, 0x535F,
	0x536D, 0x5389, 0x53BA, 0x53D0, 0xFFFE, 0x53F6, 0x53F7, 0x53F9,
	0xFFFE, 0x53F4, 0xFFFE, 0xFFFE, 0x5724, 0x5904, 0x5918, 0x5932,
	0x5930, 0x5934, 0xFFFE, 0x5975, 0xFFFE, 0x5B82, 0x5BF9, 0x5C14,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E81,
	0x5E83, 0x5F0D, 0x5F52, 0xFFFE, 0x5FCA, 0x5FC7, 0x6239, 0xFFFE,
	0x624F, 0x65E7, 0x672F, 0x6B7A, 0x6C39, 0xFFFE, 0xFFFE, 0x6C37,
	0x6C44, 0x6C45, 0x738C, 0x7592, 0x7676, 0x9093, 0x9092, 0xFFFE,
	0xFFFE, 0x4E21, 0x4E20, 0x4E22, 0x4E68, 0x4E89, 0x4E98, 0x4EF9,
	0x4EEF, 0xFFFE, 0xFFFE, 0x4EF8, 0x4F06, 0x4F03, 0x4EFC, 0x4EEE,
	0x4F16, 0xFFFE, 0x4F28, 0x4F1C, 0x4F07, 0x4F1A, 0x4EFA, 0x4F17,
	0x514A, 0xFFFE, 0x5172, 0xFFFE, 0x51B4, 0x51B3, 0x51B2, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_23 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x51E8, 0xFFFE, 0x5214, 0x520F, 0x5215, 0x5218,
	0x52A8, 0xFFFE, 0x534B, 0x534F, 0xFFFE, 0x5350, 0xFFFE, 0x538B,
	0xFFFE, 0x53BE, 0xFFFE, 0x53D2, 0x5416, 0x53FF, 0xFFFE, 0x5400,
	0xFFFE, 0x5405, 0x5413, 0x5415, 0xFFFE, 0xFFFE, 0x56E3, 0x5735,
	0x5736, 0x5731, 0x5732, 0x58EE, 0x5905, 0x4E54, 0xFFFE, 0x5936,
	0xFFFE, 0xFFFE, 0xFFFE, 0x597A, 0xFFFE, 0x5986, 0xFFFE, 0xFFFE,
	0x5B86, 0x5F53, 0x5C18, 0xFFFE, 0x5C3D, 0x5C78, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C80, 0xFFFE, 0x5E08, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5EF5, 0x5F0E, 0xFFFE, 0xFFFE, 0xFFFE, 0x5FD3, 0x5FDA,
	0xFFFE, 0x5FDB, 0xFFFE, 0x620F, 0x625D, 0x625F, 0x6267, 0x6257,
	0x9F50, 0xFFFE, 0x65EB, 0x65EA, 0xFFFE, 0x6737, 0xFFFE, 0x6732,
	0x6736, 0x6B22, 0x6BCE, 0xFFFE, 0x6C58, 0x6C51, 0x6C77, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_24 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6C3C, 0xFFFE, 0x6C5A, 0xFFFE, 0x6C53, 0x706F, 0x7072,
	0x706E, 0xFFFE, 0xFFFE, 0x7073, 0x72B1, 0x72B2, 0xFFFE, 0x738F,
	0xFFFE, 0xFFFE, 0xFFFE, 0x793C, 0xFFFE, 0x808D, 0x808E, 0xFFFE,
	0x827B, 0xFFFE, 0x8D71, 0x8FB9, 0x9096, 0x909A, 0xFFFE, 0x4E24,
	0x4E71, 0xFFFE, 0x4E9C, 0x4F45, 0x4F4A, 0x4F39, 0x4F37, 0xFFFE,
	0x4F32, 0x4F42, 0xFFFE, 0x4F44, 0x4F4B, 0xFFFE, 0x4F40, 0x4F35,
	0x4F31, 0x5151, 0xFFFE, 0x5150, 0x514E, 0xFFFE, 0xFFFE, 0x519D,
	0xFFFE, 0x51B5, 0x51B8, 0x51EC, 0x5223, 0x5227, 0x5226, 0x521F,
	0x522B, 0x5220, 0x52B4, 0x52B3, 0xFFFE, 0x5325, 0x533B, 0x5374,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x544D, 0xFFFE, 0xFFFE,
	0x543A, 0xFFFE, 0xFFFE, 0x5444, 0x544C, 0x5423, 0x541A, 0x5432,
	0x544B, 0x5421, 0xFFFE, 0x5434, 0x5449, 0x5450, 0x5422, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_25 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x543F, 0x5451, 0x545A, 0x542F, 0xFFFE, 0x56E9, 0x56F2,
	0x56F3, 0x56EF, 0x56ED, 0x56EC, 0x56E6, 0x5748, 0xFFFE, 0x5744,
	0x573F, 0x573C, 0x5753, 0x5756, 0xFFFE, 0x575F, 0x5743, 0x5758,
	0x5757, 0xFFFE, 0xFFFE, 0xFFFE, 0x5746, 0xFFFE, 0x573D, 0xFFFE,
	0x5742, 0x5754, 0x5755, 0x58F1, 0x58F2, 0x58F0, 0x590B, 0x9EA6,
	0x56F1, 0x593D, 0xFFFE, 0x5994, 0x598C, 0xFFFE, 0x599C, 0xFFFE,
	0xFFFE, 0x599F, 0xFFFE, 0x599B, 0xFFFE, 0x5989, 0x599A, 0xFFFE,
	0x6588, 0xFFFE, 0x5B8D, 0xFFFE, 0x5BFE, 0x5BFF, 0x5BFD, 0x5C2B,
	0xFFFE, 0x5C84, 0x5C8E, 0x5C9C, 0xFFFE, 0xFFFE, 0x5C85, 0x5DF5,
	0x5E09, 0xFFFE, 0xFFFE, 0x5E0B, 0xFFFE, 0x5E92, 0x5E90, 0x5F03,
	0xFFFE, 0x5F1E, 0x5F63, 0xFFFE, 0x5FE7, 0x5FFE, 0x5FE6, 0x5FDC,
	0x5FCE, 0xFFFE, 0x5FFC, 0x5FDF, 0x5FEC, 0x5FF6, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_26 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5FF2, 0x5FF0, 0x5FF9, 0xFFFE, 0x6213, 0xFFFE, 0xFFFE,
	0x623B, 0x623C, 0x6282, 0xFFFE, 0xFFFE, 0xFFFE, 0x6278, 0x628B,
	0xFFFE, 0x629E, 0x62A5, 0x629B, 0x629C, 0x6299, 0x628D, 0x6285,
	0x629D, 0x6275, 0xFFFE, 0xFFFE, 0xFFFE, 0x65F6, 0xFFFE, 0xFFFE,
	0xFFFE, 0x66F5, 0x675B, 0xFFFE, 0x6754, 0x6752, 0xFFFE, 0x6758,
	0x6744, 0x674A, 0x6761, 0xFFFE, 0x6C7F, 0x6C91, 0x6C9E, 0xFFFE,
	0x6C6E, 0x6C7C, 0x6C9F, 0x6C75, 0xFFFE, 0x6C56, 0x6CA2, 0x6C79,
	0xFFFE, 0x6CA1, 0xFFFE, 0x6CAA, 0x6CA0, 0xFFFE, 0x7079, 0x7077,
	0x707E, 0xFFFE, 0x7075, 0x707B, 0x7264, 0xFFFE, 0x72BB, 0x72BC,
	0x72C7, 0x72B9, 0x72BE, 0x72B6, 0xFFFE, 0xFFFE, 0x7398, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7593, 0x7680, 0xFFFE, 0x7683, 0x76C0,
	0x76C1, 0xFFFE, 0xFFFE, 0x77F4, 0x77F5, 0xFFFE, 0x7ACC, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_27 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7ACD, 0x7CFA, 0x809F, 0x8091, 0x8097, 0x8094, 0xFFFE,
	0x8286, 0x828C, 0xFFFE, 0x8295, 0xFFFE, 0x866C, 0xFFFE, 0x8FB5,
	0x8FBE, 0x8FC7, 0xFFFE, 0x8FC1, 0x90A9, 0x90A4, 0xFFFE, 0xFFFE,
	0xFFFE, 0x90A8, 0x9627, 0x9626, 0x962B, 0x9633, 0x9634, 0x9629,
	0x4E3D, 0xFFFE, 0x4E9D, 0x4F93, 0x4F8A, 0xFFFE, 0xFFFE, 0x4F6D,
	0x4F8E, 0x4FA0, 0x4FA2, 0x4FA1, 0x4F9F, 0x4FA3, 0xFFFE, 0x4F72,
	0xFFFE, 0x4F8C, 0x5156, 0xFFFE, 0xFFFE, 0x5190, 0xFFFE, 0xFFFE,
	0xFFFE, 0x51ED, 0x51FE, 0x522F, 0xFFFE, 0x523C, 0x5234, 0x5239,
	0x52B9, 0x52B5, 0x52BF, 0x5355, 0xFFFE, 0x5376, 0x537A, 0x5393,
	0xFFFE, 0x53C1, 0x53C2, 0x53D5, 0x5485, 0xFFFE, 0x545F, 0x5493,
	0x5489, 0x5479, 0x9EFE, 0x548F, 0x5469, 0x546D, 0xFFFE, 0x5494,
	0x546A, 0x548A, 0xFFFE, 0x56FD, 0x56FB, 0x56F8, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_28 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x56FC, 0x56F6, 0x5765, 0x5781, 0x5763, 0x5767, 0xFFFE,
	0x576E, 0x5778, 0x577F, 0xFFFE, 0xFFFE, 0x58F3, 0x594B, 0x594C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x59AD, 0xFFFE, 0x59C4, 0xFFFE, 0x59C2,
	0x59B0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x59BF, 0xFFFE, 0x59C9,
	0x59B8, 0x59AC, 0xFFFE, 0xFFFE, 0xFFFE, 0x59B7, 0x59D7, 0xFFFE,
	0x5B60, 0xFFFE, 0x5B96, 0x5B9E, 0x5B94, 0x5B9F, 0x5B9D, 0xFFFE,
	0x5C00, 0x5C19, 0xFFFE, 0xFFFE, 0x5C49, 0x5C4A, 0xFFFE, 0x5CBB,
	0x5CC1, 0xFFFE, 0xFFFE, 0xFFFE, 0x5CB9, 0x5C9E, 0x5CB4, 0x5CBA,
	0x5DF6, 0x5E13, 0x5E12, 0x5E77, 0xFFFE, 0x5E98, 0xFFFE, 0x5E99,
	0x5E9D, 0x5EF8, 0xFFFE, 0x5EF9, 0xFFFE, 0x5F06, 0x5F21, 0xFFFE,
	0x5F25, 0x5F55, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F84, 0x5F83, 0x6030,
	0x6007, 0xFFFE, 0x6036, 0xFFFE, 0xFFFE, 0xFFFE, 0x5FE9, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_29 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x603D, 0x6008, 0xFFFE, 0xFFFE, 0x62BA, 0x62B2, 0xFFFE,
	0x62B7, 0x62E4, 0x62A7, 0xFFFE, 0xFFFE, 0xFFFE, 0x62D5, 0x62E1,
	0x62DD, 0x62A6, 0x62C1, 0x62C5, 0x62C0, 0x62DF, 0x62E0, 0x62DE,
	0xFFFE, 0x6589, 0xFFFE, 0x65A6, 0x65BA, 0xFFFE, 0x65FF, 0xFFFE,
	0x6617, 0x6618, 0x6601, 0x65FE, 0xFFFE, 0x670C, 0xFFFE, 0x676B,
	0x6796, 0x6782, 0x678A, 0xFFFE, 0x67A3, 0xFFFE, 0x67A2, 0x678F,
	0xFFFE, 0x67F9, 0x6780, 0x6B26, 0x6B27, 0x6B68, 0x6B69, 0xFFFE,
	0x6B81, 0x6BB4, 0x6BD1, 0xFFFE, 0xFFFE, 0x6C1C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6C97, 0x6C6C, 0x6CDF, 0xFFFE, 0x6CEA,
	0xFFFE, 0x6CE4, 0x6CD8, 0x6CB2, 0x6CCE, 0x6CC8, 0xFFFE, 0x708B,
	0x7088, 0x7090, 0x708F, 0xFFFE, 0x7087, 0x7089, 0x708D, 0x7081,
	0xFFFE, 0x708C, 0xFFFE, 0xFFFE, 0x7240, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_2A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7265, 0x7266, 0x7268, 0xFFFE, 0xFFFE, 0x72CD, 0x72D3,
	0x72DB, 0xFFFE, 0x72CF, 0x73A7, 0x73A3, 0x739E, 0xFFFE, 0x73AF,
	0xFFFE, 0xFFFE, 0x73AA, 0x739C, 0xFFFE, 0x7542, 0x7544, 0x753B,
	0x7541, 0xFFFE, 0x759B, 0x759E, 0xFFFE, 0x79C4, 0x79C3, 0x79C6,
	0xFFFE, 0xFFFE, 0x79C7, 0xFFFE, 0x79CA, 0xFFFE, 0xFFFE, 0x7ACF,
	0x7C76, 0x7C74, 0x7CFF, 0x7CFC, 0xFFFE, 0xFFFE, 0x7F59, 0x80A8,
	0xFFFE, 0xFFFE, 0x80B0, 0xFFFE, 0x80B3, 0xFFFE, 0x80A4, 0x80B6,
	0x80A7, 0x80AC, 0xFFFE, 0x80A6, 0x5367, 0x820E, 0x82C4, 0x833E,
	0x829C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x82AA, 0xFFFE,
	0x82C9, 0xFFFE, 0xFFFE, 0x82A6, 0x82B2, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8FCC, 0x8FD9, 0x8FCA, 0x8FD8, 0x8FCF, 0x90B7, 0xFFFE, 0x90AD,
	0x90B9, 0x9637, 0xFFFE, 0x9641, 0x963E, 0x96B6, 0x9751, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_2B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9763, 0x4E57, 0x4E79, 0x4EB2, 0x4EB0, 0x4EAF, 0x4EB1,
	0x4FD2, 0x4FD5, 0xFFFE, 0x4FBE, 0x4FB8, 0x4FB0, 0x4FB1, 0x4FC8,
	0xFFFE, 0xFFFE, 0x4FC6, 0x4FCC, 0x4FE5, 0x4FE3, 0x4FB4, 0x516A,
	0xFFFE, 0x519F, 0xFFFE, 0x51C1, 0xFFFE, 0x51C2, 0x51C3, 0x5245,
	0x5248, 0xFFFE, 0xFFFE, 0x524F, 0xFFFE, 0xFFFE, 0x52C5, 0x52CA,
	0x52C4, 0x5327, 0x5358, 0x537D, 0xFFFE, 0x53DD, 0x53DC, 0x53DA,
	0x53D9, 0x54B9, 0xFFFE, 0x54D0, 0x54B4, 0x54CA, 0xFFFE, 0x54A3,
	0x54DA, 0x54A4, 0xFFFE, 0x54B2, 0x549E, 0x549F, 0x54B5, 0xFFFE,
	0xFFFE, 0x54CD, 0xFFFE, 0x54CC, 0xFFFE, 0x5700, 0x57AC, 0x5791,
	0x578E, 0x578D, 0x5792, 0x57A1, 0x5790, 0x57A6, 0x57A8, 0xFFFE,
	0x579C, 0x5796, 0x57A7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x58F5,
	0xFFFE, 0x5909, 0x5908, 0xFFFE, 0x5952, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_2C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x59DF, 0xFFFE, 0x59EB, 0x59EF, 0x59F0, 0x59D5, 0x5A0D,
	0x5A04, 0x59F9, 0x5A02, 0x59F8, 0x59E2, 0x59D9, 0x59E7, 0x5B6A,
	0xFFFE, 0xFFFE, 0x5BAB, 0xFFFE, 0x5C1B, 0x5C2F, 0xFFFE, 0x663C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5CD1, 0x5CDC, 0x5CE6, 0x5CE1, 0x5CCD,
	0xFFFE, 0x5CE2, 0x5CDD, 0x5CE5, 0x5DFB, 0x5DFA, 0x5E1E, 0xFFFE,
	0x5EA1, 0xFFFE, 0xFFFE, 0x5EFC, 0x5EFB, 0x5F2F, 0xFFFE, 0xFFFE,
	0x5F66, 0xFFFE, 0xFFFE, 0xFFFE, 0x605C, 0xFFFE, 0x604E, 0x6051,
	0xFFFE, 0xFFFE, 0x6023, 0x6031, 0x607C, 0x6052, 0xFFFE, 0x6060,
	0x604A, 0x6061, 0xFFFE, 0x6218, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x631F, 0x6317, 0x62EA, 0x6321, 0x6304,
	0x6305, 0xFFFE, 0x6531, 0x6544, 0x6540, 0xFFFE, 0x6542, 0x65BE,
	0xFFFE, 0x6629, 0x661B, 0xFFFE, 0x6623, 0x662C, 0x661A, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_2D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6630, 0x663B, 0x661E, 0x6637, 0x6638, 0xFFFE, 0x670E,
	0xFFFE, 0xFFFE, 0x67E8, 0x67D6, 0xFFFE, 0x67C7, 0x67BC, 0x6852,
	0x67BF, 0x67D5, 0x67FE, 0x8363, 0x67FB, 0xFFFE, 0x67B1, 0x6801,
	0x6805, 0x6800, 0x67D7, 0xFFFE, 0x6B2A, 0x6B6B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6BE1, 0xFFFE, 0xFFFE, 0x6D23, 0x6CFF, 0x6D14,
	0x6D05, 0x6D13, 0x6D06, 0x6D21, 0xFFFE, 0x6D15, 0x6CAF, 0x6CF4,
	0x6D02, 0x6D45, 0xFFFE, 0x6D26, 0xFFFE, 0x6D44, 0xFFFE, 0x6D24,
	0x70A5, 0xFFFE, 0x70A3, 0xFFFE, 0x70A2, 0x70BB, 0x70A0, 0x70AA,
	0xFFFE, 0xFFFE, 0x70A8, 0x70B6, 0x70B2, 0x70A7, 0xFFFE, 0xFFFE,
	0x70B9, 0x722E, 0xFFFE, 0x723C, 0xFFFE, 0x726D, 0xFFFE, 0xFFFE,
	0x72E7, 0x72ED, 0xFFFE, 0x72EC, 0x72E5, 0x72E2, 0xFFFE, 0x73C4,
	0x73BD, 0x73CF, 0x73C9, 0x73C1, 0x73D0, 0xFFFE, 0x73CE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_2E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x74ED, 0x74EB, 0xFFFE, 0x74EF, 0x7549, 0x7550, 0x7546,
	0x754A, 0xFFFE, 0x754D, 0x75A6, 0xFFFE, 0xFFFE, 0xFFFE, 0x75A8,
	0xFFFE, 0xFFFE, 0x76C7, 0x76FF, 0xFFFE, 0x76FD, 0x77E6, 0x780A,
	0xFFFE, 0x7804, 0x780B, 0x7807, 0xFFFE, 0x7815, 0x7808, 0xFFFE,
	0x79D3, 0x79D4, 0x79D0, 0x79D7, 0x7A7C, 0xFFFE, 0xFFFE, 0x7A7D,
	0x7A83, 0x7A82, 0xFFFE, 0x7AD4, 0x7AD5, 0x7AD3, 0x7AD0, 0x7AD2,
	0x7AFE, 0x7AFC, 0x7C77, 0x7C7C, 0x7C7B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7F8F, 0x80D3, 0xFFFE,
	0x80CB, 0x80D2, 0xFFFE, 0x8109, 0x80E2, 0x80DF, 0x80C6, 0xFFFE,
	0x8224, 0x82F7, 0x82D8, 0x82DD, 0xFFFE, 0xFFFE, 0x82F8, 0x82FC,
	0xFFFE, 0xFFFE, 0x82E9, 0xFFFE, 0x82EE, 0xFFFE, 0x82D0, 0x830E,
	0x82E2, 0x830B, 0x82FD, 0x5179, 0x8676, 0xFFFE, 0x8678, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_2F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8675, 0x867D, 0xFFFE, 0x8842, 0x8866,
	0xFFFE, 0x898C, 0x8A05, 0xFFFE, 0x8A06, 0xFFFE, 0x8C9F, 0xFFFE,
	0x8FF1, 0x8FE7, 0x8FE9, 0x8FEF, 0x90C2, 0x90BC, 0xFFFE, 0x90C6,
	0x90C0, 0xFFFE, 0xFFFE, 0x90CD, 0x90C9, 0xFFFE, 0x90C4, 0xFFFE,
	0x9581, 0xFFFE, 0x9CEC, 0x5032, 0x4FF9, 0x501D, 0x4FFF, 0x5004,
	0x4FF0, 0x5003, 0xFFFE, 0x5002, 0x4FFC, 0x4FF2, 0x5024, 0x5008,
	0x5036, 0x502E, 0xFFFE, 0x5010, 0x5038, 0x5039, 0x4FFD, 0x5056,
	0x4FFB, 0x51A3, 0x51A6, 0x51A1, 0xFFFE, 0xFFFE, 0x51C7, 0x51C9,
	0x5260, 0x5264, 0x5259, 0x5265, 0x5267, 0x5257, 0x5263, 0xFFFE,
	0x5253, 0xFFFE, 0x52CF, 0xFFFE, 0x52CE, 0x52D0, 0x52D1, 0x52CC,
	0xFFFE, 0xFFFE, 0xFFFE, 0x550D, 0x54F4, 0xFFFE, 0x5513, 0x54EF,
	0x54F5, 0x54F9, 0x5502, 0x5500, 0xFFFE, 0xFFFE, 0x5518, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_30 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x54F0, 0x54F6, 0xFFFE, 0xFFFE, 0x5519, 0xFFFE, 0x5705,
	0x57C9, 0xFFFE, 0x57B7, 0x57CD, 0xFFFE, 0xFFFE, 0xFFFE, 0x57BE,
	0x57BB, 0xFFFE, 0x57DB, 0x57C8, 0x57C4, 0x57C5, 0x57D1, 0x57CA,
	0x57C0, 0xFFFE, 0xFFFE, 0x5A21, 0x5A2A, 0xFFFE, 0x5A1D, 0xFFFE,
	0x5A0B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A22, 0xFFFE, 0xFFFE,
	0x5A24, 0xFFFE, 0x5A14, 0x5A31, 0xFFFE, 0x5A2F, 0x5A1A, 0x5A12,
	0xFFFE, 0xFFFE, 0x5A26, 0xFFFE, 0xFFFE, 0x5BBC, 0x5BBB, 0x5BB7,
	0x5C05, 0x5C06, 0x5C52, 0x5C53, 0xFFFE, 0xFFFE, 0x5CFA, 0x5CEB,
	0xFFFE, 0x5CF3, 0x5CF5, 0x5CE9, 0x5CEF, 0xFFFE, 0x5E2A, 0x5E30,
	0x5E2E, 0x5E2C, 0x5E2F, 0x5EAF, 0x5EA9, 0xFFFE, 0x5EFD, 0x5F32,
	0x5F8E, 0x5F93, 0x5F8F, 0x604F, 0x6099, 0xFFFE, 0x607E, 0xFFFE,
	0x6074, 0x604B, 0x6073, 0x6075, 0xFFFE, 0xFFFE, 0x6056, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_31 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x60A9, 0x608B, 0x60A6, 0xFFFE, 0x6093, 0x60AE, 0x609E,
	0x60A7, 0x6245, 0xFFFE, 0xFFFE, 0x632E, 0xFFFE, 0x6352, 0x6330,
	0x635B, 0xFFFE, 0x6319, 0x631B, 0xFFFE, 0x6331, 0x635D, 0x6337,
	0x6335, 0x6353, 0xFFFE, 0x635C, 0x633F, 0x654B, 0xFFFE, 0xFFFE,
	0x658B, 0xFFFE, 0x659A, 0x6650, 0x6646, 0x664E, 0x6640, 0xFFFE,
	0x664B, 0x6648, 0xFFFE, 0x6660, 0x6644, 0x664D, 0xFFFE, 0x6837,
	0x6824, 0xFFFE, 0xFFFE, 0x681B, 0x6836, 0xFFFE, 0x682C, 0x6819,
	0x6856, 0x6847, 0x683E, 0x681E, 0xFFFE, 0x6815, 0x6822, 0x6827,
	0x6859, 0x6858, 0x6855, 0x6830, 0x6823, 0x6B2E, 0x6B2B, 0x6B30,
	0x6B6C, 0xFFFE, 0x6B8B, 0xFFFE, 0x6BE9, 0x6BEA, 0x6BE5, 0x6D6B,
	0xFFFE, 0xFFFE, 0x6D73, 0x6D57, 0xFFFE, 0xFFFE, 0x6D5D, 0x6D56,
	0x6D8F, 0x6D5B, 0x6D1C, 0x6D9A, 0x6D9B, 0x6D99, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_32 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6D81, 0x6D71, 0xFFFE, 0xFFFE, 0x6D72, 0x6D5C, 0x6D96,
	0x70C4, 0x70DB, 0x70CC, 0x70D0, 0x70E3, 0x70DF, 0xFFFE, 0x70D6,
	0x70EE, 0x70D5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x727A, 0xFFFE,
	0x72F5, 0x7302, 0xFFFE, 0xFFFE, 0x73E2, 0x73EC, 0x73D5, 0x73F9,
	0x73DF, 0x73E6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x73E4, 0x73E1,
	0x74F3, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7556, 0x7555, 0x7558,
	0x7557, 0x755E, 0x75C3, 0xFFFE, 0xFFFE, 0x75B4, 0xFFFE, 0x75B1,
	0xFFFE, 0xFFFE, 0x76CB, 0x76CC, 0x772A, 0xFFFE, 0x7716, 0x770F,
	0xFFFE, 0xFFFE, 0x773F, 0x772B, 0x770E, 0x7724, 0xFFFE, 0x7721,
	0x7718, 0x77DD, 0xFFFE, 0xFFFE, 0x7824, 0x7836, 0xFFFE, 0x7958,
	0x7959, 0xFFFE, 0x7962, 0x79DA, 0x79D9, 0xFFFE, 0x79E1, 0x79E5,
	0x79E8, 0x79DB, 0xFFFE, 0x79E2, 0x79F0, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_33 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7ADA, 0x7ADD, 0xFFFE, 0x7ADB, 0x7ADC,
	0xFFFE, 0xFFFE, 0x7B0D, 0x7B0B, 0x7B14, 0x7C8E, 0x7C86, 0xFFFE,
	0x7C87, 0x7C83, 0x7C8B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7D24,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7D25, 0x7F62, 0x7F93, 0x7F99, 0x7F97,
	0xFFFE, 0xFFFE, 0x7FC4, 0x7FC6, 0x800A, 0xFFFE, 0xFFFE, 0x8040,
	0x803C, 0x803B, 0x80F6, 0x80FF, 0x80EE, 0x8104, 0x8103, 0x8107,
	0xFFFE, 0xFFFE, 0x80F7, 0xFFFE, 0xFFFE, 0x822D, 0xFFFE, 0x8227,
	0x8229, 0x831F, 0x8357, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8321,
	0xFFFE, 0xFFFE, 0x8318, 0x8358, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8684, 0x869F, 0x869B, 0x8689, 0x86A6, 0x8692, 0x868F,
	0x86A0, 0x884F, 0x8878, 0x887A, 0x886E, 0x887B, 0x8884, 0x8873,
	0xFFFE, 0xFFFE, 0x8A0D, 0x8A0B, 0x8A19, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_34 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8FF9, 0x9009, 0x9008,
	0xFFFE, 0x90DE, 0x9151, 0xFFFE, 0xFFFE, 0x91DB, 0x91DF, 0x91DE,
	0x91D6, 0x91E0, 0x9585, 0x9660, 0x9659, 0xFFFE, 0x9656, 0xFFFE,
	0xFFFE, 0x96BD, 0xFFFE, 0xFFFE, 0x5042, 0x5059, 0xFFFE, 0x5044,
	0x5066, 0x5052, 0x5054, 0x5071, 0x5050, 0x507B, 0x507C, 0x5058,
	0xFFFE, 0xFFFE, 0x5079, 0x506C, 0x5078, 0x51A8, 0x51D1, 0x51CF,
	0x5268, 0x5276, 0x52D4, 0xFFFE, 0x53A0, 0x53C4, 0xFFFE, 0x5558,
	0x554C, 0x5568, 0xFFFE, 0x5549, 0xFFFE, 0xFFFE, 0x555D, 0x5529,
	0xFFFE, 0x5554, 0x5553, 0xFFFE, 0x555A, 0xFFFE, 0x553A, 0x553F,
	0x552B, 0x57EA, 0xFFFE, 0x57EF, 0xFFFE, 0xFFFE, 0x57DD, 0x57FE,
	0xFFFE, 0x57DE, 0x57E6, 0xFFFE, 0x57E8, 0x57FF, 0x5803, 0x58F7,
	0x68A6, 0x591F, 0xFFFE, 0x595B, 0x595D, 0x595E, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_35 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5A2B, 0xFFFE, 0x5A3B, 0xFFFE, 0xFFFE, 0x5A61,
	0x5A3A, 0x5A6E, 0x5A4B, 0x5A6B, 0xFFFE, 0xFFFE, 0x5A45, 0x5A4E,
	0x5A68, 0x5A3D, 0x5A71, 0x5A3F, 0x5A6F, 0x5A75, 0xFFFE, 0x5A73,
	0x5A2C, 0x5A59, 0x5A54, 0x5A4F, 0x5A63, 0xFFFE, 0xFFFE, 0x5BC8,
	0xFFFE, 0x5BC3, 0xFFFE, 0x5C5B, 0x5C61, 0xFFFE, 0x5D21, 0x5D0A,
	0x5D09, 0xFFFE, 0x5D2C, 0x5D08, 0xFFFE, 0xFFFE, 0x5D2A, 0x5D15,
	0xFFFE, 0x5D10, 0x5D13, 0xFFFE, 0x5D2F, 0x5D18, 0xFFFE, 0x5DE3,
	0x5E39, 0x5E35, 0x5E3A, 0x5E32, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5EBB, 0x5EBA, 0x5F34, 0x5F39, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6098, 0xFFFE, 0x60D0, 0xFFFE, 0xFFFE, 0xFFFE, 0x60D7, 0x60AA,
	0xFFFE, 0x60A1, 0x60A4, 0xFFFE, 0x60EE, 0xFFFE, 0x60E7, 0xFFFE,
	0xFFFE, 0x60DE, 0xFFFE, 0xFFFE, 0x637E, 0x638B, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_36 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6379, 0x6386, 0x6393, 0xFFFE, 0x6373, 0x636A,
	0xFFFE, 0x636C, 0xFFFE, 0x637F, 0xFFFE, 0x63B2, 0x63BA, 0xFFFE,
	0xFFFE, 0x6366, 0x6374, 0xFFFE, 0x655A, 0xFFFE, 0x654E, 0x654D,
	0x658D, 0x658E, 0x65AD, 0xFFFE, 0x65C7, 0x65CA, 0xFFFE, 0x65C9,
	0xFFFE, 0x65E3, 0x6657, 0xFFFE, 0x6663, 0x6667, 0x671A, 0x6719,
	0x6716, 0xFFFE, 0xFFFE, 0x689E, 0x68B6, 0x6898, 0x6873, 0xFFFE,
	0x689A, 0x688E, 0x68B7, 0x68DB, 0x68A5, 0x686C, 0x68C1, 0x6884,
	0xFFFE, 0xFFFE, 0x6895, 0x687A, 0x6899, 0xFFFE, 0x68B8, 0x68B9,
	0x6870, 0xFFFE, 0x6B35, 0xFFFE, 0x6B90, 0x6BBB, 0x6BED, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6DC1, 0x6DC3, 0x6DCE, 0xFFFE, 0xFFFE, 0x6DAD,
	0x6E04, 0xFFFE, 0x6DB9, 0xFFFE, 0x6DE7, 0xFFFE, 0x6E08, 0x6E06,
	0xFFFE, 0x6E0A, 0x6DB0, 0xFFFE, 0x6DF8, 0x6E0C, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_37 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6DB1, 0xFFFE, 0x6E02, 0x6E07, 0x6E09, 0x6E01, 0x6E17,
	0x6DFF, 0x6E12, 0xFFFE, 0xFFFE, 0x7103, 0x7107, 0x7101, 0x70F5,
	0x70F1, 0x7108, 0x70F2, 0x710F, 0xFFFE, 0x70FE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x731A, 0x7310, 0x730E, 0x7402, 0x73F3, 0xFFFE, 0xFFFE,
	0x73FB, 0xFFFE, 0xFFFE, 0xFFFE, 0x751B, 0x7523, 0x7561, 0x7568,
	0xFFFE, 0x7567, 0x75D3, 0xFFFE, 0xFFFE, 0x7690, 0xFFFE, 0xFFFE,
	0x76D5, 0x76D7, 0x76D6, 0x7730, 0xFFFE, 0x7726, 0xFFFE, 0x7740,
	0xFFFE, 0x771E, 0xFFFE, 0xFFFE, 0xFFFE, 0x7847, 0xFFFE, 0x784B,
	0x7851, 0x784F, 0x7842, 0x7846, 0xFFFE, 0x796E, 0x796C, 0x79F2,
	0xFFFE, 0x79F1, 0x79F5, 0x79F3, 0x79F9, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7A9A, 0x7A93, 0x7A91, 0x7AE1, 0xFFFE, 0xFFFE, 0x7B21, 0x7B1C,
	0x7B16, 0x7B17, 0x7B36, 0x7B1F, 0xFFFE, 0x7C93, 0x7C99, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_38 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7C9A, 0x7C9C, 0xFFFE, 0x7D49, 0xFFFE, 0x7D34, 0x7D37,
	0xFFFE, 0x7D2D, 0xFFFE, 0x7D4C, 0xFFFE, 0xFFFE, 0x7D48, 0xFFFE,
	0xFFFE, 0x7F3B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8008, 0x801A,
	0xFFFE, 0x801D, 0xFFFE, 0x8049, 0x8045, 0x8044, 0x7C9B, 0xFFFE,
	0xFFFE, 0x812A, 0x812E, 0xFFFE, 0xFFFE, 0x8131, 0xFFFE, 0x811A,
	0x8134, 0x8117, 0xFFFE, 0xFFFE, 0xFFFE, 0x831D, 0x8371, 0x8384,
	0x8380, 0x8372, 0x83A1, 0xFFFE, 0x8379, 0x8391, 0xFFFE, 0x839F,
	0x83AD, 0xFFFE, 0xFFFE, 0x8323, 0xFFFE, 0x8385, 0x839C, 0x83B7,
	0x8658, 0x865A, 0xFFFE, 0x8657, 0x86B2, 0xFFFE, 0x86AE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8845, 0x889C, 0x8894, 0x88A3, 0x888F, 0x88A5,
	0x88A9, 0x88A6, 0x888A, 0x88A0, 0x8890, 0x8992, 0x8991, 0x8994,
	0xFFFE, 0x8A26, 0x8A32, 0x8A28, 0xFFFE, 0xFFFE, 0x8A1C, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_39 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8A2B, 0x8A20, 0xFFFE, 0x8A29, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8A21, 0x8C3A, 0xFFFE, 0x8C5B, 0x8C58, 0x8C7C, 0xFFFE,
	0x8CA6, 0x8CAE, 0x8CAD, 0x8D65, 0xFFFE, 0x8D7E, 0xFFFE, 0x8D7C,
	0x8D7F, 0x8D7A, 0x8DBD, 0xFFFE, 0xFFFE, 0x8DC0, 0x8DBB, 0x8EAD,
	0x8EAF, 0x8ED6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x8ED9,
	0xFFFE, 0xFFFE, 0x9012, 0x900E, 0x9025, 0xFFFE, 0x9013, 0x90EE,
	0xFFFE, 0x90AB, 0x90F7, 0xFFFE, 0x9159, 0x9154, 0x91F2, 0x91F0,
	0x91E5, 0x91F6, 0xFFFE, 0xFFFE, 0x9587, 0xFFFE, 0x965A, 0xFFFE,
	0xFFFE, 0x966E, 0xFFFE, 0xFFFE, 0xFFFE, 0x9679, 0xFFFE, 0x98E1,
	0x98E6, 0xFFFE, 0x9EC4, 0x9ED2, 0x4E80, 0xFFFE, 0x4E81, 0x508F,
	0x5097, 0x5088, 0x5089, 0xFFFE, 0xFFFE, 0x5081, 0x5160, 0xFFFE,
	0xFFFE, 0x5E42, 0x51D3, 0xFFFE, 0xFFFE, 0x51D2, 0x51D6, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_3A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5273, 0xFFFE, 0x5270, 0xFFFE, 0xFFFE, 0xFFFE, 0x53A8,
	0x53A6, 0x53C5, 0x5597, 0x55DE, 0xFFFE, 0xFFFE, 0x5596, 0x55B4,
	0xFFFE, 0x5585, 0xFFFE, 0x559B, 0x55A0, 0xFFFE, 0x5559, 0xFFFE,
	0x5586, 0xFFFE, 0xFFFE, 0x55AF, 0x557A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x559E, 0xFFFE, 0x55A9, 0x570F, 0x570E, 0x581A, 0xFFFE, 0x581F,
	0xFFFE, 0x583C, 0x5818, 0x583E, 0x5826, 0xFFFE, 0x583A, 0xFFFE,
	0x5822, 0xFFFE, 0x58FB, 0x5963, 0x5964, 0xFFFE, 0x5AA8, 0x5AA3,
	0x5A82, 0x5A88, 0x5AA1, 0x5A85, 0x5A98, 0xFFFE, 0x5A99, 0xFFFE,
	0x5A89, 0x5A81, 0x5A96, 0x5A80, 0xFFFE, 0xFFFE, 0x5A91, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5ACF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5A87, 0x5AA0, 0xFFFE, 0x5A79, 0xFFFE, 0x5A86,
	0x5AAB, 0x5AAA, 0x5AA4, 0x5A8D, 0x5A7E, 0xFFFE, 0x5BD5, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_3B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C1E, 0x5C5F, 0x5C5E, 0x5D44,
	0x5D3E, 0xFFFE, 0x5D48, 0x5D1C, 0xFFFE, 0x5D5B, 0x5D4D, 0xFFFE,
	0xFFFE, 0x5D57, 0xFFFE, 0x5D53, 0x5D4F, 0xFFFE, 0x5D3B, 0x5D46,
	0xFFFE, 0xFFFE, 0x5E46, 0x5E47, 0xFFFE, 0x5E48, 0x5EC0, 0x5EBD,
	0x5EBF, 0xFFFE, 0x5F11, 0xFFFE, 0x5F3E, 0x5F3B, 0xFFFE, 0x5F3A,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5FA7, 0xFFFE, 0x60EA, 0xFFFE, 0x6107,
	0x6122, 0x610C, 0xFFFE, 0xFFFE, 0x60B3, 0x60D6, 0x60D2, 0xFFFE,
	0x60E3, 0x60E5, 0x60E9, 0xFFFE, 0xFFFE, 0x6111, 0x60FD, 0xFFFE,
	0xFFFE, 0x611E, 0x6120, 0x6121, 0x621E, 0xFFFE, 0x63E2, 0x63DE,
	0x63E6, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x63F8, 0xFFFE, 0x63FE,
	0x63C1, 0x63BF, 0x63F7, 0x63D1, 0x655F, 0x6560, 0x6561, 0xFFFE,
	0xFFFE, 0x65D1, 0xFFFE, 0xFFFE, 0x667D, 0x666B, 0x667F, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_3C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6673, 0x6681, 0x666D, 0x6669, 0xFFFE,
	0xFFFE, 0x671E, 0x68ED, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6903,
	0xFFFE, 0x68FE, 0x68E5, 0x691E, 0x6902, 0xFFFE, 0xFFFE, 0x6909,
	0x68CA, 0x6900, 0xFFFE, 0x6901, 0x6918, 0x68E2, 0x68CF, 0xFFFE,
	0x692E, 0x68C5, 0x68FF, 0xFFFE, 0x691C, 0x68C3, 0xFFFE, 0x6B6F,
	0xFFFE, 0x6B6E, 0xFFFE, 0x6BBE, 0xFFFE, 0x6BF4, 0x6C2D, 0xFFFE,
	0x6DB6, 0x6E75, 0x6E1E, 0xFFFE, 0x6E18, 0xFFFE, 0x6E48, 0xFFFE,
	0x6E4F, 0xFFFE, 0x6E42, 0x6E6A, 0x6E70, 0x6DFE, 0xFFFE, 0xFFFE,
	0x6E6D, 0xFFFE, 0x6E7B, 0x6E7E, 0x6E59, 0xFFFE, 0x6E57, 0xFFFE,
	0x6E80, 0x6E50, 0xFFFE, 0x6E29, 0x6E76, 0x6E2A, 0x6E4C, 0x712A,
	0xFFFE, 0x7135, 0x712C, 0x7137, 0x711D, 0xFFFE, 0xFFFE, 0x7138,
	0xFFFE, 0x7134, 0x712B, 0x7133, 0x7127, 0x7124, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_3D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x712D, 0x7232, 0x7283, 0x7282, 0x7287, 0x7306, 0x7324,
	0x7338, 0x732A, 0x732C, 0x732B, 0xFFFE, 0x732F, 0x7328, 0x7417,
	0xFFFE, 0xFFFE, 0x7419, 0x7438, 0xFFFE, 0x741F, 0x7414, 0x743C,
	0x73F7, 0x741C, 0x7415, 0x7418, 0x7439, 0x74F9, 0x7524, 0xFFFE,
	0xFFFE, 0xFFFE, 0x756E, 0x756D, 0x7571, 0x758E, 0xFFFE, 0x75E5,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7694, 0x76B3, 0xFFFE, 0x76D9,
	0xFFFE, 0x7748, 0x7749, 0x7743, 0xFFFE, 0xFFFE, 0x7742, 0x77DF,
	0xFFFE, 0x7863, 0x7876, 0xFFFE, 0x785F, 0x7866, 0x7966, 0x7971,
	0xFFFE, 0xFFFE, 0x7976, 0x7984, 0x7975, 0x79FF, 0x7A07, 0xFFFE,
	0x7A0E, 0x7A09, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7AE7, 0x7AE2, 0x7B55, 0xFFFE, 0xFFFE, 0x7B43, 0x7B57, 0x7B6C,
	0x7B42, 0x7B53, 0xFFFE, 0x7B41, 0xFFFE, 0xFFFE, 0x7CA7, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_3E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7CA0, 0x7CA6, 0x7CA4, 0x7D74, 0xFFFE, 0x7D59, 0xFFFE,
	0x7D60, 0x7D57, 0x7D6C, 0x7D7E, 0x7D64, 0xFFFE, 0x7D5A, 0x7D5D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x7D76, 0x7D4D, 0x7D75, 0xFFFE, 0x7FD3,
	0x7FD6, 0xFFFE, 0xFFFE, 0x8060, 0x804E, 0x8145, 0x813B, 0xFFFE,
	0x8148, 0x8142, 0x8149, 0x8140, 0x8114, 0x8141, 0xFFFE, 0x81EF,
	0x81F6, 0x8203, 0xFFFE, 0x83ED, 0xFFFE, 0x83DA, 0x8418, 0x83D2,
	0x8408, 0xFFFE, 0x8400, 0xFFFE, 0xFFFE, 0xFFFE, 0x8417, 0x8346,
	0x8414, 0x83D3, 0x8405, 0x841F, 0x8402, 0x8416, 0x83CD, 0x83E6,
	0xFFFE, 0x865D, 0x86D5, 0x86E1, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x86EE, 0x8847, 0x8846, 0xFFFE, 0xFFFE, 0x88BB, 0xFFFE, 0x88BF,
	0x88B4, 0xFFFE, 0x88B5, 0xFFFE, 0x899A, 0x8A43, 0xFFFE, 0xFFFE,
	0x8A5A, 0xFFFE, 0xFFFE, 0xFFFE, 0x8A35, 0x8A38, 0x8A42, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_3F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8A49, 0x8A5D, 0x8A4B, 0x8A3D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8C60, 0x8C5E, 0x8C7F, 0x8C7E, 0x8C83, 0xFFFE, 0x8CB1,
	0x8D87, 0xFFFE, 0xFFFE, 0x8D88, 0x8D83, 0xFFFE, 0xFFFE, 0x8D86,
	0x8D8B, 0x8D82, 0x8DCA, 0x8DD2, 0xFFFE, 0xFFFE, 0x8DD4, 0x8DC9,
	0x8EB0, 0xFFFE, 0xFFFE, 0xFFFE, 0x8EF2, 0x8EE4, 0x8EF3, 0x8EEA,
	0xFFFE, 0x8EFD, 0xFFFE, 0x8F9D, 0x902B, 0x902A, 0xFFFE, 0x9028,
	0x9029, 0x902C, 0xFFFE, 0xFFFE, 0x903A, 0x9030, 0x9037, 0x903B,
	0xFFFE, 0x910A, 0xFFFE, 0xFFFE, 0xFFFE, 0x91FE, 0x9220, 0xFFFE,
	0x920B, 0xFFFE, 0x9218, 0x9222, 0xFFFE, 0x921B, 0x9208, 0xFFFE,
	0x920E, 0x9213, 0xFFFE, 0xFFFE, 0x9595, 0xFFFE, 0xFFFE, 0xFFFE,
	0x968C, 0x967B, 0x967F, 0x9681, 0xFFFE, 0x9682, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x96EE, 0x96ED, 0xFFFE, 0x96EC, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_40 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x975F, 0x976F, 0xFFFE, 0x976D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x98F0, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AA9,
	0xFFFE, 0xFFFE, 0x9AE0, 0x4EB7, 0xFFFE, 0xFFFE, 0x50CC, 0x50BC,
	0xFFFE, 0x50AA, 0x50B9, 0xFFFE, 0x50AB, 0x50C3, 0x50CD, 0x517E,
	0x527E, 0x5279, 0xFFFE, 0xFFFE, 0x52E1, 0x52E0, 0x52E7, 0x5380,
	0x53AB, 0x53AA, 0x53A9, 0x53E0, 0x55EA, 0xFFFE, 0x55D7, 0xFFFE,
	0xFFFE, 0x55C1, 0x5715, 0xFFFE, 0x586C, 0xFFFE, 0x585C, 0x5850,
	0x5861, 0x586A, 0x5869, 0x5856, 0x5860, 0x5866, 0x585F, 0x5923,
	0x5966, 0x5968, 0xFFFE, 0xFFFE, 0x5ACE, 0xFFFE, 0x5AC5, 0x5AC3,
	0xFFFE, 0xFFFE, 0x5AD0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5B74, 0x5B76, 0x5BDC, 0x5BD7, 0x5BDA, 0x5BDB, 0xFFFE,
	0x5C20, 0x5D6D, 0x5D66, 0xFFFE, 0x5D64, 0x5D6E, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_41 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5D60, 0x5F42, 0x5F5A, 0x5F6E, 0xFFFE, 0xFFFE, 0x6130,
	0x613A, 0x612A, 0x6143, 0x6119, 0x6131, 0xFFFE, 0x613D, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6408, 0x6432, 0x6438, 0xFFFE, 0x6431, 0xFFFE,
	0x6419, 0xFFFE, 0x6411, 0xFFFE, 0xFFFE, 0x6429, 0x641D, 0xFFFE,
	0xFFFE, 0xFFFE, 0x643C, 0xFFFE, 0x6446, 0x6447, 0xFFFE, 0xFFFE,
	0x643A, 0x6407, 0xFFFE, 0x656B, 0xFFFE, 0x6570, 0x656D, 0xFFFE,
	0x65E4, 0x6693, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x668F, 0xFFFE,
	0xFFFE, 0x6692, 0xFFFE, 0x668E, 0xFFFE, 0x6946, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6931, 0xFFFE, 0xFFFE,
	0x693E, 0xFFFE, 0x697C, 0x6943, 0xFFFE, 0x6973, 0xFFFE, 0x6955,
	0xFFFE, 0xFFFE, 0x6985, 0x694D, 0x6950, 0x6947, 0x6967, 0x6936,
	0x6964, 0x6961, 0xFFFE, 0x697D, 0x6B44, 0x6B40, 0x6B71, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_42 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6B73, 0x6B9C, 0xFFFE, 0xFFFE, 0xFFFE, 0x6BC1, 0xFFFE,
	0x6BFA, 0x6C31, 0x6C32, 0xFFFE, 0xFFFE, 0x6EB8, 0x6EA8, 0xFFFE,
	0x6E91, 0x6EBB, 0xFFFE, 0x6E9A, 0xFFFE, 0xFFFE, 0x6EA9, 0xFFFE,
	0xFFFE, 0x6EB5, 0x6E6C, 0x6EE8, 0xFFFE, 0x6EDD, 0x6EDA, 0x6EE6,
	0x6EAC, 0xFFFE, 0xFFFE, 0xFFFE, 0x6ED9, 0x6EE3, 0x6EE9, 0x6EDB,
	0xFFFE, 0x716F, 0xFFFE, 0xFFFE, 0x7148, 0xFFFE, 0x714A, 0x716B,
	0xFFFE, 0x714F, 0x7157, 0x7174, 0xFFFE, 0xFFFE, 0xFFFE, 0x7145,
	0x7151, 0x716D, 0xFFFE, 0x7251, 0x7250, 0x724E, 0xFFFE, 0x7341,
	0xFFFE, 0x732E, 0x7346, 0xFFFE, 0x7427, 0xFFFE, 0x7448, 0x7453,
	0x743D, 0xFFFE, 0x745D, 0x7456, 0xFFFE, 0x741E, 0x7447, 0x7443,
	0x7458, 0x7449, 0xFFFE, 0x744C, 0x7445, 0x743E, 0xFFFE, 0x7501,
	0x751E, 0xFFFE, 0xFFFE, 0x757A, 0x75EE, 0x7602, 0x7697, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_43 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7698, 0xFFFE, 0xFFFE, 0xFFFE, 0x775D, 0x7764, 0x7753,
	0x7758, 0x7882, 0x7890, 0x788A, 0xFFFE, 0x787A, 0x787D, 0xFFFE,
	0x788B, 0x7878, 0xFFFE, 0xFFFE, 0x788D, 0x7888, 0x7892, 0x7881,
	0x797E, 0x7983, 0xFFFE, 0xFFFE, 0xFFFE, 0x7980, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7A0F, 0xFFFE, 0xFFFE, 0x7A1D, 0xFFFE, 0x7AA1, 0x7AA4,
	0xFFFE, 0x7AE9, 0x7AEA, 0xFFFE, 0x7B62, 0x7B6B, 0xFFFE, 0x7B5E,
	0xFFFE, 0x7B79, 0xFFFE, 0xFFFE, 0x7B6F, 0x7B68, 0xFFFE, 0xFFFE,
	0x7CAE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7CB0, 0xFFFE, 0x7D90, 0xFFFE,
	0x7D8A, 0xFFFE, 0x7D8B, 0x7D99, 0x7D95, 0xFFFE, 0x7D87, 0x7D78,
	0x7D97, 0x7D89, 0x7D98, 0xFFFE, 0xFFFE, 0xFFFE, 0x7FA3, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7FDD, 0x8057, 0xFFFE, 0x8163, 0x816A, 0x816C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x815D, 0x8175, 0xFFFE, 0x815F, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_44 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x817D, 0x816D, 0xFFFE, 0xFFFE, 0x8241, 0x844F,
	0x8484, 0xFFFE, 0x847F, 0xFFFE, 0x8448, 0x842A, 0x847B, 0x8472,
	0x8464, 0x842E, 0x845C, 0x8453, 0xFFFE, 0x8441, 0x84C8, 0xFFFE,
	0x8462, 0x8480, 0x843E, 0x8483, 0x8471, 0xFFFE, 0x844A, 0x8455,
	0x8458, 0xFFFE, 0xFFFE, 0xFFFE, 0x86FC, 0x86FD, 0x8715, 0xFFFE,
	0x8716, 0x86FF, 0xFFFE, 0xFFFE, 0xFFFE, 0x8858, 0x88CF, 0x88E0,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x89E7, 0x8A6A, 0x8A80, 0xFFFE,
	0x8A6F, 0x8A65, 0xFFFE, 0x8A78, 0x8A7D, 0x8A88, 0xFFFE, 0xFFFE,
	0x8A64, 0x8A7E, 0xFFFE, 0x8A67, 0x8C63, 0x8C88, 0xFFFE, 0x8CCD,
	0xFFFE, 0x8CC9, 0xFFFE, 0x8DED, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8EB1, 0xFFFE, 0xFFFE, 0x8F04, 0x8F9E,
	0x8FA0, 0x9043, 0x9046, 0x9048, 0x9045, 0x9040, 0x904C, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_45 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x910C, 0x9113, 0x9115, 0xFFFE, 0x916B,
	0x9167, 0x925D, 0x9255, 0x9235, 0xFFFE, 0x9259, 0x922F, 0x923C,
	0x928F, 0x925C, 0x926A, 0x9262, 0x925F, 0x926B, 0x926E, 0x923B,
	0x9244, 0x9241, 0x959A, 0xFFFE, 0x9599, 0xFFFE, 0xFFFE, 0xFFFE,
	0x968F, 0xFFFE, 0x9696, 0xFFFE, 0xFFFE, 0xFFFE, 0x96F4, 0x96FC,
	0xFFFE, 0x9755, 0xFFFE, 0x9779, 0xFFFE, 0xFFFE, 0xFFFE, 0x97EE,
	0x97F5, 0xFFFE, 0x980B, 0xFFFE, 0x98F3, 0xFFFE, 0xFFFE, 0x98F7,
	0x98FF, 0x98F5, 0xFFFE, 0x98EC, 0x98F1, 0xFFFE, 0xFFFE, 0x999A,
	0xFFFE, 0x9AE2, 0x9B3D, 0x9B5D, 0x9CE8, 0xFFFE, 0x9CEB, 0x9CEF,
	0x9CEE, 0x9E81, 0x9F14, 0x50D0, 0x50D9, 0x50DC, 0x50D8, 0xFFFE,
	0x50E1, 0x50EB, 0xFFFE, 0xFFFE, 0x50F4, 0x50E2, 0x50DE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x51F4, 0xFFFE, 0xFFFE, 0xFFFE, 0x52ED, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_46 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x52EA, 0xFFFE, 0x5332, 0xFFFE, 0x53AE, 0x53B0, 0xFFFE,
	0x55FB, 0x5603, 0x560B, 0xFFFE, 0x5607, 0xFFFE, 0x55F8, 0xFFFE,
	0x5628, 0x561E, 0xFFFE, 0x5618, 0x5611, 0x5651, 0x5605, 0x5717,
	0x5892, 0xFFFE, 0x588C, 0xFFFE, 0x5878, 0x5884, 0x5873, 0x58AD,
	0x5897, 0x5895, 0x5877, 0x5872, 0x5896, 0x588D, 0x5910, 0xFFFE,
	0x596C, 0xFFFE, 0x5AE7, 0xFFFE, 0x5AE4, 0xFFFE, 0xFFFE, 0x5AEF,
	0x5626, 0xFFFE, 0xFFFE, 0x5AF0, 0x5D7B, 0xFFFE, 0x5D83, 0xFFFE,
	0xFFFE, 0x5D8B, 0x5D8C, 0xFFFE, 0x5D78, 0x5E52, 0xFFFE, 0xFFFE,
	0x5ED0, 0x5ECF, 0xFFFE, 0x5FB3, 0x5FB4, 0xFFFE, 0xFFFE, 0xFFFE,
	0x617B, 0xFFFE, 0x616F, 0x6181, 0x613C, 0x6142, 0x6138, 0x6133,
	0xFFFE, 0x6160, 0x6169, 0x617D, 0x6186, 0x622C, 0x6228, 0xFFFE,
	0x644C, 0xFFFE, 0x6457, 0x647C, 0xFFFE, 0xFFFE, 0x6455, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_47 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6462, 0x6471, 0x646A, 0x6456, 0x643B, 0x6481, 0xFFFE,
	0x644F, 0x647E, 0x6464, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6571, 0xFFFE, 0xFFFE, 0x66A5, 0x669A, 0x669C, 0xFFFE, 0x66A6,
	0xFFFE, 0x66A4, 0x698F, 0x69C5, 0x69C8, 0x6992, 0x69B2, 0xFFFE,
	0xFFFE, 0xFFFE, 0x69E3, 0x69C0, 0x69D6, 0x69D1, 0x699F, 0x69A2,
	0x69D2, 0xFFFE, 0xFFFE, 0xFFFE, 0x69E1, 0x69D5, 0x699D, 0xFFFE,
	0xFFFE, 0x6998, 0xFFFE, 0x6B74, 0x6BA1, 0xFFFE, 0x6EF0, 0x6EF3,
	0xFFFE, 0xFFFE, 0x6F1B, 0x6F0C, 0x6F1D, 0x6F34, 0x6F28, 0x6F17,
	0xFFFE, 0x6F44, 0x6F42, 0x6F04, 0x6F11, 0x6EFA, 0x6F4A, 0x7191,
	0x718E, 0xFFFE, 0x718B, 0x718D, 0x717F, 0x718C, 0x717E, 0x717C,
	0x7183, 0xFFFE, 0x7188, 0xFFFE, 0xFFFE, 0x7294, 0xFFFE, 0x7355,
	0x7353, 0x734F, 0x7354, 0x746C, 0x7465, 0x7466, 0x7461, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_48 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x746B, 0x7468, 0x7476, 0xFFFE, 0x7460, 0xFFFE, 0x7474,
	0x7506, 0x760E, 0xFFFE, 0x7607, 0xFFFE, 0xFFFE, 0x76B9, 0xFFFE,
	0x76B7, 0x76E2, 0xFFFE, 0x7774, 0x7777, 0x7776, 0x7775, 0xFFFE,
	0x7778, 0x7771, 0xFFFE, 0x777A, 0x715B, 0x777B, 0x78A6, 0x78AE,
	0x78B8, 0xFFFE, 0xFFFE, 0xFFFE, 0x78B1, 0x78AF, 0xFFFE, 0x7989,
	0x7987, 0xFFFE, 0xFFFE, 0x7A29, 0xFFFE, 0x7A2A, 0xFFFE, 0x7A2D,
	0x7A2C, 0xFFFE, 0x7A32, 0xFFFE, 0x7AEC, 0x7AF0, 0x7B81, 0x7B9E,
	0x7B83, 0xFFFE, 0x7B92, 0xFFFE, 0x7BA3, 0x7B9F, 0x7B93, 0xFFFE,
	0x7B86, 0x7CB8, 0x7CB7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7DC8, 0x7DB6, 0xFFFE, 0x7DD1, 0xFFFE, 0x7DA8, 0x7DAB, 0xFFFE,
	0x7DB3, 0x7DCD, 0xFFFE, 0x7DCF, 0x7DA4, 0xFFFE, 0xFFFE, 0x7F41,
	0x7F6F, 0x7F71, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_49 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8023, 0x805B, 0xFFFE, 0x8061, 0x805F, 0x8181,
	0xFFFE, 0xFFFE, 0x8184, 0x8213, 0xFFFE, 0x824A, 0x824C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x84BD, 0x8495, 0xFFFE, 0x8492, 0x84C3, 0xFFFE,
	0x8496, 0x84A5, 0x84B5, 0x84B3, 0x84A3, 0x84E4, 0x84D8, 0x84D5,
	0xFFFE, 0x84B7, 0x84AD, 0x84DA, 0x8493, 0x8736, 0xFFFE, 0xFFFE,
	0xFFFE, 0x873D, 0x872B, 0x8747, 0x8739, 0xFFFE, 0x8745, 0x871D,
	0xFFFE, 0x88FF, 0x88EA, 0xFFFE, 0x88F5, 0xFFFE, 0x8900, 0x88ED,
	0x8903, 0x88E9, 0xFFFE, 0xFFFE, 0x89EA, 0xFFFE, 0x8A9B, 0x8A8E,
	0x8AA2, 0xFFFE, 0x8A9C, 0x8A94, 0x8A90, 0x8AA9, 0x8AAC, 0xFFFE,
	0x8A9F, 0xFFFE, 0xFFFE, 0x8A9D, 0xFFFE, 0x8C67, 0xFFFE, 0xFFFE,
	0x8CD0, 0x8CD6, 0x8CD4, 0x8D98, 0x8D9A, 0x8D97, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8E0B, 0x8E08, 0x8E01, 0x8EB4, 0x8EB3, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8FA1, 0x8FA2, 0xFFFE, 0x905A, 0xFFFE, 0x9061, 0x905F,
	0xFFFE, 0xFFFE, 0x9125, 0x917B, 0x9176, 0x917C, 0xFFFE, 0x9289,
	0x92F6, 0x92B1, 0x92AD, 0x9292, 0x9281, 0x9284, 0xFFFE, 0x92AE,
	0x9290, 0x929E, 0xFFFE, 0xFFFE, 0xFFFE, 0x95A2, 0x95A7, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x96A0, 0x969D, 0x969F, 0x96D0,
	0xFFFE, 0x96D1, 0xFFFE, 0xFFFE, 0x9759, 0xFFFE, 0x9764, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9819, 0xFFFE, 0x9814, 0x9815, 0x981A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9906, 0xFFFE, 0x98F8, 0x9901, 0xFFFE,
	0x99BE, 0x99BC, 0x99B7, 0x99B6, 0x99C0, 0xFFFE, 0x99B8, 0xFFFE,
	0xFFFE, 0xFFFE, 0x99C4, 0xFFFE, 0x99BF, 0xFFFE, 0x9ADA, 0x9AE4,
	0x9AE9, 0x9AE8, 0x9AEA, 0x9AE5, 0xFFFE, 0x9B26, 0xFFFE, 0xFFFE,
	0x9B40, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9EBD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x510E,
	0xFFFE, 0x50F7, 0xFFFE, 0x50FC, 0x510D, 0x5101, 0x51DA, 0x51D9,
	0x51DB, 0x5286, 0x528E, 0x52EE, 0x5333, 0x53B1, 0xFFFE, 0x5647,
	0x562D, 0x5654, 0xFFFE, 0x564B, 0x5652, 0x5631, 0x5644, 0x5656,
	0x5650, 0x562B, 0xFFFE, 0x564D, 0x5637, 0x564F, 0x58A2, 0x58B7,
	0xFFFE, 0x58B2, 0xFFFE, 0x58AA, 0x58B5, 0x58B0, 0xFFFE, 0x58B4,
	0x58A4, 0x58A7, 0xFFFE, 0x5926, 0x5AFE, 0xFFFE, 0x5B04, 0xFFFE,
	0x5AFC, 0xFFFE, 0x5B06, 0x5B0A, 0x5AFA, 0x5B0D, 0x5B00, 0x5B0E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D91, 0xFFFE, 0x5D8F, 0x5D90, 0x5D98,
	0x5DA4, 0x5D9B, 0x5DA3, 0x5D96, 0x5DE4, 0x5E5A, 0xFFFE, 0xFFFE,
	0x5E5E, 0xFFFE, 0x5FB8, 0x6157, 0x615C, 0x61A6, 0x6195, 0x6188,
	0xFFFE, 0x61A3, 0x618F, 0xFFFE, 0x6164, 0xFFFE, 0x6159, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6178, 0xFFFE, 0x6185, 0x6187, 0x619E, 0xFFFE, 0xFFFE,
	0x6198, 0x619C, 0xFFFE, 0xFFFE, 0x622F, 0x6480, 0x649B, 0x648E,
	0x648D, 0x6494, 0x64C6, 0xFFFE, 0x64A8, 0x6483, 0xFFFE, 0x64B9,
	0x6486, 0x64B4, 0x64AF, 0x6491, 0xFFFE, 0x64AA, 0x64A1, 0x64A7,
	0x66B6, 0x66B3, 0xFFFE, 0x66BC, 0x66AC, 0xFFFE, 0x66AD, 0x6A0E,
	0xFFFE, 0x6A1C, 0x6A1A, 0xFFFE, 0xFFFE, 0x6A0B, 0xFFFE, 0x69EF,
	0x6A0C, 0x69F0, 0x6A22, 0xFFFE, 0x69D8, 0xFFFE, 0x6A12, 0x69FA,
	0xFFFE, 0x6A2A, 0xFFFE, 0x6A10, 0xFFFE, 0xFFFE, 0x6A29, 0x69F9,
	0x69EA, 0x6A2C, 0x6A24, 0xFFFE, 0x69E9, 0x6B52, 0x6B4F, 0x6B53,
	0xFFFE, 0xFFFE, 0x6F10, 0x6F65, 0x6F75, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6FD0, 0xFFFE, 0x6F5C, 0x6F3D, 0x6F71, 0xFFFE, 0x6F91,
	0x6F0B, 0x6F79, 0x6F81, 0x6F8F, 0xFFFE, 0x6F59, 0x6F74, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x71AE, 0xFFFE, 0x71A3, 0x71AD, 0xFFFE, 0xFFFE,
	0x71AB, 0x71A6, 0x71A2, 0xFFFE, 0x52F2, 0x7257, 0x7255, 0x7299,
	0x734B, 0x747A, 0xFFFE, 0xFFFE, 0xFFFE, 0x748C, 0x7484, 0xFFFE,
	0xFFFE, 0x7482, 0x7493, 0x747B, 0xFFFE, 0x7509, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x778A, 0xFFFE, 0x7790, 0xFFFE,
	0x78C6, 0x78D3, 0x78C0, 0x78D2, 0x78C7, 0x78C2, 0xFFFE, 0x799F,
	0x799D, 0x799E, 0xFFFE, 0x7A41, 0xFFFE, 0x7A38, 0x7A3A, 0x7A42,
	0xFFFE, 0xFFFE, 0x7A3E, 0x7AB0, 0x7BAE, 0x7BB3, 0xFFFE, 0xFFFE,
	0x7BBF, 0xFFFE, 0xFFFE, 0x7BCD, 0xFFFE, 0x7BB2, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7CC4, 0x7CCD, 0x7CC2,
	0x7CC6, 0x7CC3, 0x7CC9, 0x7CC7, 0xFFFE, 0x7DF8, 0xFFFE, 0x7DED,
	0x7DE2, 0xFFFE, 0xFFFE, 0xFFFE, 0x7DDC, 0x7E02, 0x7E01, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7DD6, 0xFFFE, 0x7DE4, 0x7DFE, 0xFFFE, 0x7E00,
	0x7DFC, 0x7DFD, 0xFFFE, 0x7DF5, 0x7DFF, 0xFFFE, 0x7DEB, 0x7DE5,
	0x7F78, 0x7FAE, 0x7FE7, 0xFFFE, 0x8065, 0x806A, 0x8066, 0x8068,
	0x806B, 0x8194, 0x81A1, 0x8192, 0x8196, 0x8193, 0xFFFE, 0xFFFE,
	0x8501, 0xFFFE, 0x84F8, 0xFFFE, 0x84F5, 0xFFFE, 0x8504, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x851B, 0x8503, 0x8533, 0x8534, 0x84ED,
	0xFFFE, 0xFFFE, 0x8535, 0xFFFE, 0x8505, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x877D, 0xFFFE, 0xFFFE, 0xFFFE, 0x8771, 0xFFFE, 0x885C,
	0x88E6, 0x890F, 0x891B, 0xFFFE, 0x89A9, 0x89A5, 0x89EE, 0x8AB1,
	0xFFFE, 0x8ACC, 0x8ACE, 0xFFFE, 0x8AB7, 0xFFFE, 0x8AB5, 0x8AE9,
	0x8AB4, 0xFFFE, 0x8AB3, 0x8AC1, 0x8AAF, 0x8ACA, 0x8AD0, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8C8E, 0xFFFE, 0xFFFE, 0x8CE9, 0x8CDB, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_4F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8CEB, 0x8DA4, 0xFFFE, 0x8DA2, 0x8D9D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8E2A, 0x8E28, 0xFFFE, 0xFFFE, 0x8EB8,
	0x8EB6, 0x8EB9, 0x8EB7, 0x8F22, 0x8F2B, 0x8F27, 0x8F19, 0x8FA4,
	0xFFFE, 0x8FB3, 0xFFFE, 0x9071, 0x906A, 0xFFFE, 0xFFFE, 0x9188,
	0x918C, 0x92BF, 0x92B8, 0x92BE, 0x92DC, 0x92E5, 0xFFFE, 0xFFFE,
	0x92D4, 0x92D6, 0xFFFE, 0x92DA, 0x92ED, 0x92F3, 0x92DB, 0xFFFE,
	0x92B9, 0x92E2, 0x92EB, 0x95AF, 0xFFFE, 0x95B2, 0x95B3, 0xFFFE,
	0xFFFE, 0xFFFE, 0x96A3, 0x96A5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x970A, 0xFFFE, 0x9787, 0x9789, 0x978C, 0x97EF, 0x982A, 0x9822,
	0xFFFE, 0x981F, 0xFFFE, 0x9919, 0xFFFE, 0x99CA, 0x99DA, 0xFFFE,
	0xFFFE, 0xFFFE, 0x99DE, 0x99C8, 0x99E0, 0xFFFE, 0x9AB6, 0x9AB5,
	0xFFFE, 0x9AF4, 0xFFFE, 0x9B6B, 0x9B69, 0x9B72, 0x9B63, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_50 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9D0D, 0xFFFE, 0x9D01, 0x9D0C, 0xFFFE, 0x9CF8,
	0xFFFE, 0xFFFE, 0x9CFE, 0x9D02, 0x9E84, 0xFFFE, 0x9EAB, 0x9EAA,
	0x511D, 0x5116, 0xFFFE, 0x512B, 0x511E, 0x511B, 0x5290, 0x5294,
	0x5314, 0xFFFE, 0xFFFE, 0x5667, 0xFFFE, 0x567B, 0xFFFE, 0x565F,
	0x5661, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x58C3, 0x58CA, 0x58BB, 0x58C0, 0x58C4, 0x5901, 0x5B1F, 0x5B18,
	0x5B11, 0x5B15, 0xFFFE, 0x5B12, 0x5B1C, 0xFFFE, 0x5B22, 0x5B79,
	0x5DA6, 0xFFFE, 0x5DB3, 0x5DAB, 0x5EEA, 0xFFFE, 0x5F5B, 0xFFFE,
	0xFFFE, 0x61B7, 0x61CE, 0x61B9, 0x61BD, 0x61CF, 0x61C0, 0x6199,
	0x6197, 0xFFFE, 0x61BB, 0x61D0, 0x61C4, 0x6231, 0xFFFE, 0x64D3,
	0x64C0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x64DC, 0x64D1, 0x64C8,
	0xFFFE, 0x64D5, 0x66C3, 0xFFFE, 0xFFFE, 0x66BF, 0x66C5, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_51 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x66CD, 0x66C1, 0x6706, 0xFFFE, 0x6724, 0x6A63,
	0x6A42, 0x6A52, 0xFFFE, 0x6A43, 0x6A33, 0xFFFE, 0x6A6C, 0x6A57,
	0xFFFE, 0x6A4C, 0x6A6E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6A37, 0xFFFE, 0x6A71, 0x6A4A, 0x6A36, 0xFFFE, 0x6A53, 0xFFFE,
	0x6A45, 0x6A70, 0xFFFE, 0xFFFE, 0x6A5C, 0x6B58, 0x6B57, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6FBB, 0xFFFE, 0xFFFE,
	0x6FBE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6FB5, 0x6FD3, 0x6F9F, 0xFFFE,
	0x6FB7, 0x6FF5, 0x71B7, 0xFFFE, 0x71BB, 0xFFFE, 0x71D1, 0xFFFE,
	0x71BA, 0xFFFE, 0x71B6, 0x71CC, 0xFFFE, 0xFFFE, 0x71D3, 0x749B,
	0xFFFE, 0xFFFE, 0x7496, 0x74A2, 0x749D, 0x750A, 0x750E, 0xFFFE,
	0x7581, 0x762C, 0x7637, 0x7636, 0x763B, 0xFFFE, 0x76A1, 0xFFFE,
	0xFFFE, 0x7798, 0xFFFE, 0x7796, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_52 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x78D6, 0x78EB, 0xFFFE, 0x78DC, 0xFFFE, 0x79A5, 0x79A9,
	0x9834, 0x7A53, 0x7A45, 0xFFFE, 0x7A4F, 0xFFFE, 0x7ABD, 0x7ABB,
	0x7AF1, 0xFFFE, 0xFFFE, 0x7BEC, 0x7BED, 0xFFFE, 0xFFFE, 0x7CD3,
	0xFFFE, 0x7CE1, 0xFFFE, 0x7E19, 0xFFFE, 0xFFFE, 0xFFFE, 0x7E27,
	0x7E26, 0xFFFE, 0xFFFE, 0x806E, 0x81AF, 0xFFFE, 0xFFFE, 0x81AD,
	0xFFFE, 0x81AA, 0x8218, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x856F,
	0x854C, 0xFFFE, 0x8542, 0xFFFE, 0x855C, 0x8570, 0x855F, 0xFFFE,
	0x855A, 0x854B, 0x853F, 0x878A, 0xFFFE, 0x878B, 0x87A1, 0x878E,
	0xFFFE, 0xFFFE, 0x8799, 0x885E, 0x885F, 0x8924, 0x89A7, 0x8AEA,
	0x8AFD, 0x8AF9, 0x8AE3, 0x8AE5, 0xFFFE, 0xFFFE, 0x8AEC, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8CF2, 0xFFFE, 0x8CEF, 0xFFFE, 0x8DA6,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8E3B, 0x8E43, 0xFFFE, 0x8E32, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_53 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8F31, 0x8F30, 0xFFFE, 0x8F2D, 0x8F3C, 0x8FA7, 0x8FA5,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9137, 0x9195, 0x918E, 0xFFFE, 0x9196,
	0xFFFE, 0x9345, 0x930A, 0xFFFE, 0xFFFE, 0x92FD, 0x9317, 0x931C,
	0x9307, 0x9331, 0x9332, 0x932C, 0x9330, 0x9303, 0x9305, 0xFFFE,
	0x95C2, 0xFFFE, 0x95B8, 0xFFFE, 0x95C1, 0xFFFE, 0xFFFE, 0xFFFE,
	0x96AB, 0x96B7, 0xFFFE, 0xFFFE, 0x9715, 0x9714, 0xFFFE, 0xFFFE,
	0x970C, 0x9717, 0xFFFE, 0x9793, 0xFFFE, 0x97D2, 0xFFFE, 0xFFFE,
	0x9836, 0x9831, 0x9833, 0x983C, 0x982E, 0x983A, 0xFFFE, 0x983D,
	0xFFFE, 0x98B5, 0x9922, 0x9923, 0x9920, 0x991C, 0x991D, 0xFFFE,
	0x99A0, 0xFFFE, 0x99EF, 0x99E8, 0x99EB, 0xFFFE, 0xFFFE, 0xFFFE,
	0x99E1, 0x99E6, 0xFFFE, 0xFFFE, 0x9AF8, 0x9AF5, 0xFFFE, 0xFFFE,
	0x9B83, 0x9B94, 0x9B84, 0xFFFE, 0x9B8B, 0x9B8F, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_54 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9B8C, 0xFFFE, 0x9B89, 0xFFFE, 0x9B8E, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9D24, 0x9D0F, 0xFFFE, 0x9D13, 0x9D0A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9D2A, 0x9D1A, 0xFFFE, 0x9D27, 0x9D16, 0x9D21,
	0xFFFE, 0x9E85, 0x9EAC, 0x9EC6, 0x9EC5, 0x9ED7, 0x9F53, 0xFFFE,
	0x5128, 0x5127, 0x51DF, 0xFFFE, 0x5335, 0x53B3, 0xFFFE, 0x568A,
	0x567D, 0x5689, 0xFFFE, 0x58CD, 0x58D0, 0xFFFE, 0x5B2B, 0x5B33,
	0x5B29, 0x5B35, 0x5B31, 0x5B37, 0x5C36, 0x5DBE, 0xFFFE, 0x5DB9,
	0xFFFE, 0x5DBB, 0xFFFE, 0x61E2, 0x61DB, 0x61DD, 0x61DC, 0x61DA,
	0xFFFE, 0x61D9, 0xFFFE, 0xFFFE, 0x64DF, 0xFFFE, 0xFFFE, 0x64E1,
	0xFFFE, 0x64EE, 0xFFFE, 0x65B5, 0x66D4, 0x66D5, 0xFFFE, 0x66D0,
	0x66D1, 0x66CE, 0x66D7, 0xFFFE, 0xFFFE, 0x6A7D, 0x6A8A, 0xFFFE,
	0x6AA7, 0xFFFE, 0x6A99, 0x6A82, 0x6A88, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_55 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6A86, 0xFFFE, 0x6A98, 0x6A9D, 0xFFFE, 0xFFFE, 0x6A8F,
	0xFFFE, 0x6AAA, 0xFFFE, 0x6B5D, 0xFFFE, 0x6C0A, 0xFFFE, 0x6FD7,
	0x6FD6, 0x6FE5, 0xFFFE, 0xFFFE, 0xFFFE, 0x6FD9, 0x6FDA, 0x6FEA,
	0xFFFE, 0x6FF6, 0xFFFE, 0xFFFE, 0x71E3, 0xFFFE, 0x71E9, 0xFFFE,
	0x71EB, 0x71EF, 0x71F3, 0x71EA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7371, 0xFFFE, 0x74AE, 0xFFFE, 0x74B3, 0xFFFE, 0x74AC,
	0xFFFE, 0xFFFE, 0x7583, 0x7645, 0x764E, 0x7644, 0x76A3, 0x76A5,
	0x77A6, 0x77A4, 0xFFFE, 0x77A9, 0x77AF, 0xFFFE, 0xFFFE, 0xFFFE,
	0x78F0, 0x78F8, 0x78F1, 0xFFFE, 0x7A49, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7AC2, 0x7AF2, 0x7AF3, 0x7BFA, 0xFFFE, 0x7BF6, 0x7BFC, 0x7C18,
	0x7C08, 0x7C12, 0xFFFE, 0xFFFE, 0x7CDB, 0x7CDA, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7E2C, 0x7E4D, 0xFFFE, 0xFFFE, 0x7F46, 0x7FF6, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_56 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x802B, 0x8074, 0x81B8, 0x81C8, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8592, 0x8593, 0xFFFE, 0x857F, 0x85AB, 0x8597, 0xFFFE, 0xFFFE,
	0x85AC, 0xFFFE, 0xFFFE, 0xFFFE, 0x87CE, 0xFFFE, 0x87CD, 0xFFFE,
	0xFFFE, 0x87C1, 0x87B1, 0x87C7, 0xFFFE, 0x8940, 0xFFFE, 0x893F,
	0x8939, 0xFFFE, 0x8943, 0xFFFE, 0xFFFE, 0xFFFE, 0x89AB, 0xFFFE,
	0x8B1F, 0x8B09, 0x8B0C, 0xFFFE, 0xFFFE, 0x8C40, 0xFFFE, 0x8C96,
	0xFFFE, 0x8CF6, 0x8CF7, 0xFFFE, 0x8E46, 0x8E4F, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8F3D, 0x8F41, 0x9366, 0x9378, 0x935D, 0x9369, 0x9374,
	0x937D, 0x936E, 0x9372, 0x9373, 0x9362, 0x9348, 0x9353, 0x935F,
	0x9368, 0xFFFE, 0x937F, 0x936B, 0xFFFE, 0x95C4, 0xFFFE, 0x96AF,
	0x96AD, 0x96B2, 0xFFFE, 0xFFFE, 0x971A, 0x971B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x979B, 0x979F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_57 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9840, 0xFFFE,
	0x9847, 0xFFFE, 0x98B7, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x99A2, 0xFFFE, 0xFFFE, 0x9A00, 0x99F3, 0xFFFE, 0xFFFE, 0x99F5,
	0xFFFE, 0xFFFE, 0x9ABD, 0x9B00, 0x9B02, 0xFFFE, 0x9B34, 0x9B49,
	0x9B9F, 0xFFFE, 0x9BA3, 0x9BCD, 0x9B99, 0x9B9D, 0xFFFE, 0xFFFE,
	0x9D39, 0xFFFE, 0x9D44, 0xFFFE, 0xFFFE, 0x9D35, 0xFFFE, 0xFFFE,
	0x9EAF, 0xFFFE, 0x512F, 0xFFFE, 0xFFFE, 0x9F8E, 0xFFFE, 0x569F,
	0x569B, 0x569E, 0x5696, 0x5694, 0x56A0, 0xFFFE, 0x5B3B, 0xFFFE,
	0xFFFE, 0x5B3A, 0x5DC1, 0x5F4D, 0x5F5D, 0x61F3, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x64F6, 0x64E5, 0x64EA, 0x64E7, 0x6505, 0xFFFE,
	0x64F9, 0xFFFE, 0xFFFE, 0xFFFE, 0x6AAB, 0x6AED, 0x6AB2, 0x6AB0,
	0x6AB5, 0x6ABE, 0x6AC1, 0x6AC8, 0xFFFE, 0x6AC0, 0x6ABC, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_58 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6AB1, 0x6AC4, 0x6ABF, 0xFFFE, 0xFFFE, 0x7008, 0x7003,
	0x6FFD, 0x7010, 0x7002, 0x7013, 0xFFFE, 0x71FA, 0x7200, 0x74B9,
	0x74BC, 0xFFFE, 0x765B, 0x7651, 0x764F, 0x76EB, 0x77B8, 0xFFFE,
	0x77B9, 0x77C1, 0x77C0, 0x77BE, 0x790B, 0xFFFE, 0x7907, 0x790A,
	0x7908, 0xFFFE, 0x790D, 0x7906, 0x7915, 0x79AF, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7AF5, 0xFFFE, 0xFFFE, 0x7C2E, 0xFFFE, 0x7C1B, 0xFFFE,
	0x7C1A, 0x7C24, 0xFFFE, 0xFFFE, 0x7CE6, 0x7CE3, 0xFFFE, 0xFFFE,
	0x7E5D, 0x7E4F, 0x7E66, 0x7E5B, 0x7F47, 0x7FB4, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7FFA, 0x802E, 0xFFFE, 0xFFFE, 0x81CE, 0xFFFE, 0xFFFE,
	0x8219, 0xFFFE, 0xFFFE, 0x85CC, 0x85B2, 0xFFFE, 0x85BB, 0x85C1,
	0xFFFE, 0xFFFE, 0xFFFE, 0x87E9, 0x87EE, 0x87F0, 0x87D6, 0x880E,
	0x87DA, 0x8948, 0x894A, 0x894E, 0x894D, 0x89B1, 0x89B0, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_59 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x89B3, 0xFFFE, 0x8B38, 0x8B32, 0xFFFE, 0x8B2D, 0xFFFE,
	0x8B34, 0xFFFE, 0x8B29, 0x8C74, 0xFFFE, 0xFFFE, 0x8D03, 0xFFFE,
	0xFFFE, 0x8DA9, 0x8E58, 0xFFFE, 0xFFFE, 0x8EBF, 0x8EC1, 0x8F4A,
	0x8FAC, 0xFFFE, 0x9089, 0x913D, 0x913C, 0x91A9, 0x93A0, 0xFFFE,
	0x9390, 0xFFFE, 0x9393, 0x938B, 0x93AD, 0x93BB, 0x93B8, 0xFFFE,
	0xFFFE, 0x939C, 0x95D8, 0x95D7, 0xFFFE, 0xFFFE, 0xFFFE, 0x975D,
	0x97A9, 0x97DA, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9854, 0xFFFE,
	0x9855, 0x984B, 0xFFFE, 0x983F, 0x98B9, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9938, 0x9936, 0x9940, 0xFFFE, 0x993B, 0x9939, 0x99A4,
	0xFFFE, 0xFFFE, 0x9A08, 0x9A0C, 0xFFFE, 0x9A10, 0xFFFE, 0x9B07,
	0xFFFE, 0x9BD2, 0xFFFE, 0x9BC2, 0x9BBB, 0x9BCC, 0x9BCB, 0xFFFE,
	0xFFFE, 0x9D4D, 0x9D63, 0x9D4E, 0xFFFE, 0x9D50, 0x9D55, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9D5E, 0xFFFE, 0x9E90, 0x9EB2, 0x9EB1, 0xFFFE,
	0x9ECA, 0x9F02, 0x9F27, 0x9F26, 0xFFFE, 0x56AF, 0x58E0, 0x58DC,
	0xFFFE, 0x5B39, 0xFFFE, 0xFFFE, 0x5B7C, 0x5BF3, 0xFFFE, 0xFFFE,
	0x5C6B, 0x5DC4, 0x650B, 0x6508, 0x650A, 0xFFFE, 0xFFFE, 0x65DC,
	0xFFFE, 0xFFFE, 0x66E1, 0x66DF, 0x6ACE, 0x6AD4, 0x6AE3, 0x6AD7,
	0x6AE2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6AD8, 0x6AD5, 0x6AD2,
	0xFFFE, 0xFFFE, 0x701E, 0x702C, 0x7025, 0x6FF3, 0x7204, 0x7208,
	0x7215, 0xFFFE, 0x74C4, 0x74C9, 0x74C7, 0x74C8, 0x76A9, 0x77C6,
	0x77C5, 0x7918, 0x791A, 0x7920, 0xFFFE, 0x7A66, 0x7A64, 0x7A6A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7C35, 0x7C34,
	0xFFFE, 0xFFFE, 0x7E6C, 0xFFFE, 0x7E6E, 0x7E71, 0xFFFE, 0x81D4,
	0x81D6, 0x821A, 0x8262, 0x8265, 0x8276, 0x85DB, 0x85D6, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x85E7, 0xFFFE, 0xFFFE, 0x85F4, 0xFFFE, 0x87FD,
	0x87D5, 0x8807, 0xFFFE, 0x880F, 0x87F8, 0xFFFE, 0xFFFE, 0x8987,
	0xFFFE, 0x89B5, 0x89F5, 0xFFFE, 0x8B3F, 0x8B43, 0x8B4C, 0xFFFE,
	0x8D0B, 0x8E6B, 0x8E68, 0x8E70, 0x8E75, 0x8E77, 0xFFFE, 0x8EC3,
	0xFFFE, 0x93E9, 0x93EA, 0x93CB, 0x93C5, 0x93C6, 0xFFFE, 0x93ED,
	0x93D3, 0xFFFE, 0x93E5, 0xFFFE, 0xFFFE, 0x93DB, 0x93EB, 0x93E0,
	0x93C1, 0xFFFE, 0xFFFE, 0x95DD, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x97B2, 0x97B4, 0x97B1,
	0x97B5, 0x97F2, 0xFFFE, 0xFFFE, 0xFFFE, 0x9856, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9944, 0xFFFE, 0x9A26, 0x9A1F, 0x9A18, 0x9A21, 0x9A17,
	0xFFFE, 0x9B09, 0xFFFE, 0xFFFE, 0x9BC5, 0x9BDF, 0xFFFE, 0x9BE3,
	0xFFFE, 0x9BE9, 0x9BEE, 0xFFFE, 0xFFFE, 0x9D66, 0x9D7A, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9D6E, 0x9D91, 0x9D83, 0x9D76, 0x9D7E, 0x9D6D,
	0xFFFE, 0x9E95, 0x9EE3, 0xFFFE, 0xFFFE, 0x9F03, 0x9F04, 0xFFFE,
	0x9F17, 0xFFFE, 0x5136, 0xFFFE, 0x5336, 0xFFFE, 0x5B42, 0xFFFE,
	0xFFFE, 0x5B44, 0x5B46, 0x5B7E, 0x5DCA, 0x5DC8, 0x5DCC, 0x5EF0,
	0xFFFE, 0x6585, 0x66E5, 0x66E7, 0xFFFE, 0xFFFE, 0xFFFE, 0x6AF4,
	0xFFFE, 0x6AE9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x703D,
	0xFFFE, 0x7036, 0xFFFE, 0x7216, 0xFFFE, 0x7212, 0x720F, 0x7217,
	0x7211, 0x720B, 0xFFFE, 0xFFFE, 0x74CD, 0x74D0, 0x74CC, 0x74CE,
	0x74D1, 0xFFFE, 0x7589, 0xFFFE, 0x7A6F, 0x7C4B, 0x7C44, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7E7F, 0x8B71, 0xFFFE, 0x802F,
	0x807A, 0x807B, 0x807C, 0xFFFE, 0xFFFE, 0xFFFE, 0x85FC, 0x8610,
	0x8602, 0xFFFE, 0xFFFE, 0x85EE, 0x8603, 0xFFFE, 0x860D, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8613, 0x8608, 0x860F, 0x8818, 0x8812, 0xFFFE, 0xFFFE,
	0x8967, 0x8965, 0x89BB, 0x8B69, 0x8B62, 0xFFFE, 0x8B6E, 0xFFFE,
	0x8B61, 0xFFFE, 0x8B64, 0x8B4D, 0x8C51, 0xFFFE, 0xFFFE, 0x8E83,
	0x8EC6, 0xFFFE, 0x941F, 0xFFFE, 0x9404, 0x9417, 0x9408, 0x9405,
	0xFFFE, 0x93F3, 0x941E, 0x9402, 0x941A, 0x941B, 0x9427, 0x941C,
	0xFFFE, 0x96B5, 0xFFFE, 0xFFFE, 0x9733, 0xFFFE, 0x9734, 0x9731,
	0x97B8, 0x97BA, 0xFFFE, 0x97FC, 0xFFFE, 0xFFFE, 0x98C3, 0xFFFE,
	0x994D, 0xFFFE, 0x9A2F, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AC9, 0xFFFE,
	0x9AC8, 0x9AC4, 0x9B2A, 0x9B38, 0x9B50, 0xFFFE, 0x9C0A, 0x9BFB,
	0x9C04, 0x9BFC, 0x9BFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x9C02, 0x9BF6,
	0x9C1B, 0x9BF9, 0x9C15, 0x9C10, 0x9BFF, 0x9C00, 0x9C0C, 0xFFFE,
	0xFFFE, 0x9D95, 0x9DA5, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9E98, 0x9EC1, 0xFFFE, 0x9F5A, 0x5164, 0x56BB, 0xFFFE,
	0x58E6, 0x5B49, 0x5BF7, 0xFFFE, 0xFFFE, 0x5DD0, 0xFFFE, 0x5FC2,
	0xFFFE, 0x6511, 0xFFFE, 0x6AFF, 0x6AFE, 0x6AFD, 0xFFFE, 0x6B01,
	0xFFFE, 0xFFFE, 0x704B, 0x704D, 0x7047, 0x74D3, 0x7668, 0x7667,
	0xFFFE, 0xFFFE, 0x77D1, 0x7930, 0x7932, 0x792E, 0xFFFE, 0x9F9D,
	0x7AC9, 0x7AC8, 0xFFFE, 0x7C56, 0x7C51, 0xFFFE, 0xFFFE, 0xFFFE,
	0x7E85, 0x7E89, 0x7E8E, 0x7E84, 0xFFFE, 0x826A, 0x862B, 0x862F,
	0x8628, 0xFFFE, 0x8616, 0x8615, 0x861D, 0x881A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x89BC, 0x8B75, 0x8B7C, 0xFFFE, 0x8D11, 0x8D12, 0x8F5C,
	0x91BB, 0xFFFE, 0x93F4, 0xFFFE, 0xFFFE, 0x942D, 0xFFFE, 0xFFFE,
	0x96E4, 0x9737, 0x9736, 0x9767, 0x97BE, 0x97BD, 0x97E2, 0x9868,
	0x9866, 0x98C8, 0x98CA, 0x98C7, 0x98DC, 0xFFFE, 0x994F, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_5F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x99A9, 0x9A3C, 0xFFFE, 0x9A3B, 0x9ACE, 0xFFFE, 0x9B14,
	0x9B53, 0xFFFE, 0x9C2E, 0xFFFE, 0x9C1F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9DB0, 0x9DBD, 0xFFFE, 0xFFFE, 0x9DAE, 0x9DC4, 0x9E7B,
	0xFFFE, 0xFFFE, 0x9E9E, 0xFFFE, 0x9F05, 0xFFFE, 0x9F69, 0x9FA1,
	0x56C7, 0x571D, 0x5B4A, 0x5DD3, 0xFFFE, 0x5F72, 0x6202, 0xFFFE,
	0x6235, 0x6527, 0x651E, 0x651F, 0xFFFE, 0xFFFE, 0x6B07, 0x6B06,
	0xFFFE, 0xFFFE, 0x7054, 0x721C, 0x7220, 0x7AF8, 0xFFFE, 0x7C5D,
	0x7C58, 0xFFFE, 0x7E92, 0x7F4E, 0xFFFE, 0xFFFE, 0xFFFE, 0x8827,
	0xFFFE, 0x8B81, 0x8B83, 0xFFFE, 0x8C44, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9442, 0x944D, 0x9454, 0x944E, 0xFFFE, 0x9443, 0xFFFE,
	0xFFFE, 0x973C, 0x9740, 0x97C0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x995A, 0x9A51, 0xFFFE, 0x9ADD, 0xFFFE, 0xFFFE, 0x9C38, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_60 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x9C45, 0x9C3A, 0xFFFE, 0x9C35, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9EF1, 0xFFFE, 0x9F93, 0x529A, 0xFFFE, 0xFFFE, 0x8641,
	0x5DD7, 0xFFFE, 0x6528, 0xFFFE, 0xFFFE, 0xFFFE, 0x7053, 0x7059,
	0xFFFE, 0x7221, 0xFFFE, 0x766F, 0x7937, 0x79B5, 0x7C62, 0x7C5E,
	0x7CF5, 0xFFFE, 0xFFFE, 0x863D, 0xFFFE, 0x882D, 0x8989, 0x8B8D,
	0x8B87, 0x8B90, 0x8D1A, 0x8E99, 0xFFFE, 0xFFFE, 0xFFFE, 0x945F,
	0xFFFE, 0xFFFE, 0x9456, 0x9461, 0x945B, 0x945A, 0x945C, 0x9465,
	0xFFFE, 0x9741, 0xFFFE, 0xFFFE, 0x986E, 0x986C, 0x986D, 0xFFFE,
	0x99AA, 0x9A5C, 0x9A58, 0x9ADE, 0xFFFE, 0x9C4F, 0x9C51, 0xFFFE,
	0x9C53, 0xFFFE, 0xFFFE, 0xFFFE, 0x9DFC, 0x9F39, 0xFFFE, 0x513E,
	0xFFFE, 0x56D2, 0xFFFE, 0x5B4F, 0x6B14, 0xFFFE, 0x7A72, 0x7A73,
	0xFFFE, 0xFFFE, 0xFFFE, 0x8B91, 0xFFFE, 0xFFFE, 0x91BF, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_61 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x946C, 0xFFFE, 0xFFFE, 0x96E6, 0x9745, 0xFFFE,
	0x97C8, 0x97E4, 0x995D, 0xFFFE, 0x9B21, 0xFFFE, 0x9B2C, 0x9B57,
	0xFFFE, 0xFFFE, 0x9C5D, 0x9C61, 0x9C65, 0x9E08, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9F45, 0xFFFE, 0xFFFE, 0x6205, 0x66EF,
	0x6B1B, 0x6B1D, 0x7225, 0x7224, 0x7C6D, 0xFFFE, 0x8642, 0x8649,
	0xFFFE, 0x8978, 0x898A, 0x8B97, 0xFFFE, 0x8C9B, 0x8D1C, 0xFFFE,
	0x8EA2, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x9C6C, 0xFFFE, 0x9C6F, 0xFFFE, 0x9E0E, 0xFFFE, 0x9F08,
	0x9F1D, 0x9FA3, 0xFFFE, 0xFFFE, 0x5F60, 0x6B1C, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7CF3, 0xFFFE, 0x8B9B, 0x8EA7, 0x91C4, 0xFFFE, 0x947A,
	0xFFFE, 0xFFFE, 0x9A61, 0x9A63, 0x9AD7, 0x9C76, 0xFFFE, 0x9FA5,
	0xFFFE, 0x7067, 0xFFFE, 0x72AB, 0x864A, 0x897D, 0x8B9D, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_62 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x8C53, 0x8F65, 0x947B, 0xFFFE, 0x98CD, 0x98DD, 0xFFFE,
	0x9B30, 0x9E16, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x96E7,
	0x9E18, 0x9EA2, 0xFFFE, 0x9F7C, 0xFFFE, 0x7E9E, 0x9484, 0xFFFE,
	0x9E1C, 0xFFFE, 0x7C71, 0x97CA, 0xFFFE, 0xFFFE, 0xFFFE, 0x9EA3,
	0xFFFE, 0x9C7B, 0x9F97, 0xFFFE, 0xFFFE, 0x9750, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5727, 0x5C13, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5FC8, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6765,
	0xFFFE, 0xFFFE, 0x52BD, 0xFFFE, 0x5B66, 0xFFFE, 0x65F9, 0x6788,
	0x6CE6, 0x6CCB, 0xFFFE, 0x4FBD, 0x5F8D, 0xFFFE, 0x6018, 0x6048,
	0xFFFE, 0x6B29, 0x70A6, 0xFFFE, 0x7706, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5A10, 0x5CFC, 0x5CFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x70C9, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_63 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9579, 0xFFFE, 0x96BA, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x7B29, 0x8128, 0xFFFE,
	0x8A2E, 0xFFFE, 0xFFFE, 0xFFFE, 0x9AD9, 0xFFFE, 0x582B, 0x5845,
	0xFFFE, 0x63FA, 0xFFFE, 0xFFFE, 0xFFFE, 0x6E86, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5867, 0xFFFE, 0x5BDD, 0x656E, 0xFFFE,
	0xFFFE, 0xFFFE, 0x8C87, 0xFFFE, 0x50D2, 0x50DF, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x69BA, 0xFFFE, 0x6B9D, 0xFFFE, 0x8059, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6F8A, 0xFFFE, 0xFFFE, 0x7BC3, 0x7BC2,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x90F6, 0xFFFE, 0x9823, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x71CD, 0x7499, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x9842, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_64 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x7F84, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x8D0E, 0xFFFE, 0x9861, 0xFFFE, 0xFFFE, 0x8B73, 0xFFFE, 0x9C27,
	0xFFFE, 0x9458, 0x77D6, 0x9B2D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4F66, 0x4F68, 0x4FE7, 0x503F, 0xFFFE, 0x50A6, 0x510F, 0x523E,
	0x5324, 0x5365, 0x539B, 0x517F, 0x54CB, 0x5573, 0x5571, 0x556B,
	0x55F4, 0x5622, 0x5620, 0x5692, 0x56BA, 0x5691, 0x56B0, 0x5759,
	0x578A, 0x580F, 0x5812, 0x5813, 0x5847, 0x589B, 0x5900, 0x594D,
	0x5AD1, 0x5AD3, 0x5B67, 0x5C57, 0x5C77, 0x5CD5, 0x5D75, 0x5D8E,
	0x5DA5, 0x5DB6, 0x5DBF, 0x5E65, 0x5ECD, 0x5EED, 0x5F94, 0x5F9A,
	0x5FBA, 0x6125, 0x6150, 0x62A3, 0x6360, 0x6364, 0x63B6, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_65 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6403, 0x64B6, 0x651A, 0x7A25, 0x5C21, 0x66E2, 0x6702,
	0x67A4, 0x67AC, 0x6810, 0x6806, 0x685E, 0x685A, 0x692C, 0x6929,
	0x6A2D, 0x6A77, 0x6A7A, 0x6ACA, 0x6AE6, 0x6AF5, 0x6B0D, 0x6B0E,
	0x6BDC, 0x6BDD, 0x6BF6, 0x6C1E, 0x6C63, 0x6DA5, 0x6E0F, 0x6E8A,
	0x6E84, 0x6E8B, 0x6E7C, 0x6F4C, 0x6F48, 0x6F49, 0x6F9D, 0x6F99,
	0x6FF8, 0x702E, 0x702D, 0x705C, 0x79CC, 0x70BF, 0x70EA, 0x70E5,
	0x7111, 0x7112, 0x713F, 0x7139, 0x713B, 0x713D, 0x7177, 0x7175,
	0x7176, 0x7171, 0x7196, 0x7193, 0x71B4, 0x71DD, 0x71DE, 0x720E,
	0x5911, 0x7218, 0x7347, 0x7348, 0x73EF, 0x7412, 0x743B, 0x74A4,
	0x748D, 0x74B4, 0x7673, 0x7677, 0x76BC, 0x7819, 0x781B, 0x783D,
	0x7853, 0x7854, 0x7858, 0x78B7, 0x78D8, 0x78EE, 0x7922, 0x794D,
	0x7986, 0x7999, 0x79A3, 0x79BC, 0x7AA7, 0x7B37, 0x7B59, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_66 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x7BD0, 0x7C2F, 0x7C32, 0x7C42, 0x7C4E, 0x7C68, 0x7CA9,
	0x7CED, 0x7DD0, 0x7E07, 0x7DD3, 0x7E64, 0x7F40, 0xFFFE, 0x8041,
	0x8063, 0x80BB, 0x6711, 0x6725, 0x8248, 0x8310, 0x8362, 0x8312,
	0x8421, 0x841E, 0x84E2, 0x84DE, 0x84E1, 0x8573, 0x85D4, 0x85F5,
	0x8637, 0x8645, 0x8672, 0x874A, 0x87A9, 0x87A5, 0x87F5, 0x8834,
	0x8850, 0x8887, 0x8954, 0x8984, 0x8B03, 0x8C52, 0x8CD8, 0x8D0C,
	0x8D18, 0x8DB0, 0x8EBC, 0x8ED5, 0x8FAA, 0x909C, 0xFFFE, 0x915C,
	0x922B, 0x9221, 0x9273, 0x92F4, 0x92F5, 0x933F, 0x9342, 0x9386,
	0x93BE, 0x93BC, 0x93BD, 0x93F1, 0x93F2, 0x93EF, 0x9422, 0x9423,
	0x9424, 0x9467, 0x9466, 0x9597, 0x95CE, 0x95E7, 0x973B, 0x974D,
	0x98E4, 0x9942, 0x9B1D, 0x9B98, 0xFFFE, 0x9D49, 0x6449, 0x5E71,
	0x5E85, 0x61D3, 0x990E, 0x8002, 0x781E, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_7bit to_ucs_67 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5528, 0x5572, 0x55BA, 0x55F0, 0x55EE, 0x56B8, 0x56B9,
	0x56C4, 0x8053, 0x92B0, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_14bit to_ucs = { {
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, &to_ucs_21, &to_ucs_22, &to_ucs_23, &to_ucs_24, &to_ucs_25, &to_ucs_26, &to_ucs_27,
	&to_ucs_28, &to_ucs_29, &to_ucs_2A, &to_ucs_2B, &to_ucs_2C, &to_ucs_2D, &to_ucs_2E, &to_ucs_2F,
	&to_ucs_30, &to_ucs_31, &to_ucs_32, &to_ucs_33, &to_ucs_34, &to_ucs_35, &to_ucs_36, &to_ucs_37,
	&to_ucs_38, &to_ucs_39, &to_ucs_3A, &to_ucs_3B, &to_ucs_3C, &to_ucs_3D, &to_ucs_3E, &to_ucs_3F,
	&to_ucs_40, &to_ucs_41, &to_ucs_42, &to_ucs_43, &to_ucs_44, &to_ucs_45, &to_ucs_46, &to_ucs_47,
	&to_ucs_48, &to_ucs_49, &to_ucs_4A, &to_ucs_4B, &to_ucs_4C, &to_ucs_4D, &to_ucs_4E, &to_ucs_4F,
	&to_ucs_50, &to_ucs_51, &to_ucs_52, &to_ucs_53, &to_ucs_54, &to_ucs_55, &to_ucs_56, &to_ucs_57,
	&to_ucs_58, &to_ucs_59, &to_ucs_5A, &to_ucs_5B, &to_ucs_5C, &to_ucs_5D, &to_ucs_5E, &to_ucs_5F,
	&to_ucs_60, &to_ucs_61, &to_ucs_62, &to_ucs_63, &to_ucs_64, &to_ucs_65, &to_ucs_66, &to_ucs_67,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
} };

static const iconv_ccs_convtable_8bit from_ucs_4E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2126, 0x2125, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2262, 0x2261, 0x2263, 0xFFFE, 0x243F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2121, 0xFFFE, 0x212C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2122, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2740, 0xFFFE, 0x2123,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2130, 0xFFFE,
	0xFFFE, 0x212E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2345, 0xFFFE, 0xFFFE, 0x2B22,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2146, 0x2145, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2264, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2440, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2B23, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x396C, 0x396E, 0xFFFE, 0xFFFE, 0xFFFE, 0x2124, 0xFFFE, 0x212D,
	0xFFFE, 0x2265, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2131,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x216C,
	0x2266, 0xFFFE, 0xFFFE, 0xFFFE, 0x2442, 0x2742, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2147, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B26,
	0x2B25, 0x2B27, 0x2B24, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4033,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2132, 0xFFFE, 0x2133, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2149, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x214C, 0xFFFE, 0x214B, 0x214A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x216D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2172, 0x2170,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x226F, 0x2268,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x226B, 0x2267, 0x2276, 0xFFFE, 0x226E, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_4F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x226D, 0xFFFE, 0xFFFE, 0x226C, 0x2274,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2270, 0x2277,
	0xFFFE, 0xFFFE, 0x2275, 0xFFFE, 0x2273, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2272, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2450, 0x2448, 0xFFFE, 0xFFFE, 0x244F, 0xFFFE, 0x2446,
	0xFFFE, 0x2445, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x244E, 0xFFFE, 0x2449, 0xFFFE, 0x244B, 0x2443, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2444, 0x244C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6448, 0xFFFE,
	0x6449, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2747, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x274F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2744, 0xFFFE, 0x2751, 0xFFFE, 0x2748, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2743, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x274C,
	0x2749, 0x274B, 0x274A, 0x274D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2B2D, 0x2B2E, 0xFFFE, 0xFFFE, 0x2B36, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2B2C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6263, 0x2B2B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B32, 0xFFFE,
	0x2B2F, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B33, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2B28, 0xFFFE, 0xFFFE, 0x2B29, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2B35, 0xFFFE, 0x2B34, 0xFFFE, 0x644A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2F48, 0xFFFE, 0x2F4D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2F44, 0xFFFE, 0x2F58, 0x2F4C, 0x2F56, 0xFFFE, 0x2F46
} };

static const iconv_ccs_convtable_8bit from_ucs_50 = { {
	0xFFFE, 0xFFFE, 0x2F4B, 0x2F49, 0x2F47, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2F4F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2F53, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F45, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F4E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F51, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2F43, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F50, 0xFFFE,
	0x2F54, 0x2F55, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x644B,
	0xFFFE, 0xFFFE, 0x343C, 0xFFFE, 0x343F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3444, 0xFFFE, 0x3441, 0xFFFE, 0x3442, 0xFFFE, 0x2F57, 0xFFFE,
	0x3447, 0x343D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3440, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x344B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3443, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x344C, 0x344A, 0xFFFE, 0x3445, 0x3446, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3975, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3971, 0x3972, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x396F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3970,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x644D, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4039, 0x403C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x403A, 0xFFFE, 0xFFFE, 0x4037, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x403D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4036, 0x403E, 0xFFFE, 0xFFFE,
	0x456B, 0xFFFE, 0x634C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x456E, 0x456C, 0xFFFE, 0xFFFE, 0x456D, 0xFFFE, 0x4576, 0x634D,
	0xFFFE, 0x4570, 0x4575, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4571, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4574, 0xFFFE, 0xFFFE, 0x4B29,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B2B, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_51 = { {
	0xFFFE, 0x4B2D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B2C, 0x4B27, 0x644E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5031, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5035, 0xFFFE, 0x5030, 0x5034, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5441,
	0x5440, 0xFFFE, 0xFFFE, 0x5033, 0xFFFE, 0xFFFE, 0xFFFE, 0x5752,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C32, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x606F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2278, 0xFFFE, 0xFFFE, 0xFFFE, 0x2454, 0xFFFE,
	0x2453, 0x2451, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2752, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3976, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E25, 0xFFFE, 0x2134, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2B37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x227A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2E7B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x403F, 0x6453,
	0xFFFE, 0xFFFE, 0x2127, 0xFFFE, 0x214D, 0x2148, 0x214E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2178, 0x2179, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2755, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2128, 0xFFFE,
	0xFFFE, 0x217A, 0xFFFE, 0xFFFE, 0xFFFE, 0x2457, 0xFFFE, 0x2B39,
	0xFFFE, 0x2F5B, 0xFFFE, 0x2F59, 0xFFFE, 0xFFFE, 0x2F5A, 0xFFFE,
	0x344D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x227E, 0x227D, 0x227C, 0x2459, 0xFFFE, 0xFFFE,
	0x245A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2B3B, 0x2B3D, 0x2B3E, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F5E,
	0xFFFE, 0x2F5F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x344F,
	0xFFFE, 0x344E, 0x397D, 0x397A, 0xFFFE, 0xFFFE, 0x397E, 0xFFFE,
	0xFFFE, 0x4B2F, 0x4B2E, 0x4B30, 0xFFFE, 0xFFFE, 0xFFFE, 0x5442,
	0xFFFE, 0xFFFE, 0x212F, 0x2135, 0x2151, 0x217B, 0xFFFE, 0xFFFE,
	0x2322, 0xFFFE, 0xFFFE, 0xFFFE, 0x245B, 0x2759, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x457A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x275A, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_52 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2136, 0x2152, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x217D, 0xFFFE, 0xFFFE, 0xFFFE, 0x2325,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2324, 0x2326, 0xFFFE, 0xFFFE,
	0x2327, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x245F,
	0x2461, 0xFFFE, 0xFFFE, 0x245C, 0xFFFE, 0xFFFE, 0x245E, 0x245D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2460, 0xFFFE, 0xFFFE, 0xFFFE, 0x275B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x275E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x275F, 0xFFFE, 0xFFFE, 0x275D, 0xFFFE, 0x644F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B3F, 0xFFFE, 0xFFFE,
	0x2B40, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B43,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2F68, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F65,
	0xFFFE, 0x2F62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2F60, 0xFFFE, 0xFFFE, 0x2F66, 0x2F61, 0x2F63, 0xFFFE, 0x2F64,
	0x3450, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3A23, 0xFFFE, 0xFFFE, 0x3A21, 0xFFFE, 0xFFFE, 0x3451, 0xFFFE,
	0xFFFE, 0x4041, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4040, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B31, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B32, 0xFFFE,
	0x5036, 0xFFFE, 0xFFFE, 0xFFFE, 0x5037, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x602C, 0xFFFE, 0x2137, 0x2154, 0x2153, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2328, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2463, 0x2462, 0x2761, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2760, 0xFFFE, 0xFFFE, 0xFFFE, 0x625A, 0xFFFE, 0x2762,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B48, 0x2B46, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2B47, 0xFFFE, 0x2F6F, 0xFFFE, 0x2F6C, 0x2F6A,
	0x2F6D, 0x2F6E, 0xFFFE, 0xFFFE, 0x3452, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4045, 0x4044, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4046,
	0xFFFE, 0xFFFE, 0x4621, 0xFFFE, 0xFFFE, 0x457E, 0x4B33, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4D2C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2155, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_53 = { {
	0x2156, 0xFFFE, 0xFFFE, 0x2223, 0x2222, 0xFFFE, 0xFFFE, 0x2224,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5038, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2226, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6450, 0x2465, 0xFFFE, 0x2B49,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4623, 0x4B34, 0xFFFE, 0x5444, 0x5C34, 0xFFFE,
	0x2129, 0xFFFE, 0x2157, 0x2466, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2159, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x232A, 0xFFFE, 0xFFFE, 0xFFFE, 0x232B,
	0x232D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2763, 0xFFFE, 0xFFFE,
	0x2B4A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x215A, 0xFFFE, 0x2227,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6451, 0xFFFE, 0x2A5C,
	0xFFFE, 0x212A, 0xFFFE, 0xFFFE, 0xFFFE, 0x2228, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2467, 0xFFFE, 0x2765, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2766, 0xFFFE, 0xFFFE, 0x2B4B, 0xFFFE, 0xFFFE,
	0x4047, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x215B, 0xFFFE,
	0xFFFE, 0x2229, 0xFFFE, 0x232F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2767, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6452, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3454, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A28, 0xFFFE,
	0x3A27, 0x404A, 0x4049, 0x4048, 0xFFFE, 0xFFFE, 0x4625, 0xFFFE,
	0x4626, 0x4B35, 0xFFFE, 0x5445, 0xFFFE, 0xFFFE, 0x212B, 0x215C,
	0xFFFE, 0xFFFE, 0x222A, 0xFFFE, 0xFFFE, 0xFFFE, 0x2331, 0xFFFE,
	0xFFFE, 0x2769, 0x276A, 0xFFFE, 0x3455, 0x3A29, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x215E, 0xFFFE, 0x2160, 0xFFFE,
	0x222B, 0xFFFE, 0x2333, 0xFFFE, 0xFFFE, 0x276B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2B50, 0x2B4F, 0xFFFE, 0x2B4E, 0x2B4D, 0xFFFE, 0xFFFE,
	0x404B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2231, 0xFFFE, 0x222D, 0x222E,
	0xFFFE, 0x222F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2335
} };

static const iconv_ccs_convtable_8bit from_ucs_54 = { {
	0x2337, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2339, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x233A, 0xFFFE, 0x233B, 0x2334, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2476, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2479, 0x247E, 0x2475, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2524,
	0xFFFE, 0xFFFE, 0x2477, 0xFFFE, 0x247B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2470, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2521,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2473, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x247C, 0xFFFE, 0x2478, 0x2474, 0x246D, 0xFFFE, 0xFFFE,
	0x247D, 0x2522, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2523, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x276E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2774, 0x2778, 0xFFFE, 0xFFFE, 0x2775, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2771, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x276C, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2770, 0x2779, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2773,
	0xFFFE, 0xFFFE, 0xFFFE, 0x276F, 0x2777, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B5C, 0x2B5D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2B57, 0x2B59, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2B5B, 0xFFFE, 0x2B54, 0x2B5E, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2B51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2B55, 0x6454, 0x2B63, 0x2B61, 0xFFFE, 0xFFFE,
	0x2B53, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2B58, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F77,
	0x3021, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F74, 0x2F78, 0x3022, 0xFFFE,
	0xFFFE, 0x2F79, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_55 = { {
	0x2F7B, 0xFFFE, 0x2F7A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F73, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2F76, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2F7E, 0x3025, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6721, 0x345F, 0xFFFE, 0x3468, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3466, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3467,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x345B, 0xFFFE, 0xFFFE, 0x3458, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3462, 0x3461, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3457, 0x3A36, 0x3464, 0xFFFE, 0xFFFE, 0x345E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3459, 0xFFFE, 0xFFFE, 0x6457, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6456, 0x6722, 0x6455, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3A3C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A31, 0x3A38, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A2E, 0x3A2A,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3A33, 0xFFFE, 0xFFFE, 0x3A40, 0xFFFE,
	0x3A34, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3A42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A3B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A2F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6723, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4051, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x404E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A2B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x404C, 0xFFFE, 0xFFFE, 0xFFFE, 0x6725, 0xFFFE,
	0x6724, 0xFFFE, 0xFFFE, 0xFFFE, 0x6458, 0xFFFE, 0xFFFE, 0xFFFE,
	0x462E, 0xFFFE, 0xFFFE, 0x4628, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_56 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x4629, 0xFFFE, 0x4636, 0xFFFE, 0x462C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x462A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4634, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4633, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4631, 0xFFFE,
	0x645A, 0xFFFE, 0x6459, 0xFFFE, 0xFFFE, 0xFFFE, 0x4650, 0xFFFE,
	0x4630, 0xFFFE, 0xFFFE, 0x4B41, 0xFFFE, 0x4B38, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4B3D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B44,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B3E, 0xFFFE, 0xFFFE, 0x4B37,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B3B, 0xFFFE, 0x4B43, 0xFFFE, 0x4B45,
	0x4B40, 0x4635, 0x4B3C, 0xFFFE, 0x4B39, 0xFFFE, 0x4B3F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x503F,
	0xFFFE, 0x5040, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x503B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x503D, 0xFFFE, 0x5448, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5449, 0x5447, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x645D, 0x645B, 0xFFFE, 0x575B, 0xFFFE, 0x575A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5758, 0xFFFE, 0xFFFE, 0x5759, 0x5757,
	0x575C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A2D,
	0x645E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6726, 0x6727, 0x645C, 0x5E26, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6728, 0xFFFE, 0xFFFE, 0x5F40,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6071, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2177, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x233E, 0xFFFE, 0xFFFE, 0x252C, 0xFFFE,
	0xFFFE, 0x2526, 0xFFFE, 0xFFFE, 0x252B, 0x252A, 0xFFFE, 0x2529,
	0xFFFE, 0x2548, 0x2527, 0x2528, 0xFFFE, 0xFFFE, 0x2822, 0xFFFE,
	0x277D, 0xFFFE, 0xFFFE, 0x277C, 0x2821, 0x277B, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_57 = { {
	0x2B65, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3027, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A44, 0x3A43,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4052, 0xFFFE, 0x4637,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F41, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2161, 0xFFFE, 0xFFFE, 0x2234, 0xFFFE, 0xFFFE, 0x6249,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2341, 0x2342, 0xFFFE, 0xFFFE, 0x233F, 0x2340, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2531, 0x253E, 0xFFFE, 0x2530,
	0xFFFE, 0xFFFE, 0x2540, 0x2536, 0x252F, 0xFFFE, 0x253C, 0xFFFE,
	0x252D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2532, 0x2541, 0x2542, 0x2533, 0x2538,
	0x2537, 0x645F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2535,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2825, 0xFFFE, 0x2823, 0xFFFE, 0x2826,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2828, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2829, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x282A,
	0xFFFE, 0x2824, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6460, 0xFFFE, 0xFFFE, 0x2B69, 0x2B68, 0xFFFE,
	0x2B6C, 0x2B67, 0x2B6A, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B71, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B70, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2B6B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B6D, 0x2B72,
	0x2B6E, 0xFFFE, 0xFFFE, 0xFFFE, 0x2B66, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x302A,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3030, 0xFFFE, 0xFFFE, 0x302F, 0xFFFE,
	0x3038, 0xFFFE, 0xFFFE, 0xFFFE, 0x3034, 0x3035, 0xFFFE, 0xFFFE,
	0x3033, 0x3028, 0x3037, 0xFFFE, 0xFFFE, 0x302B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3036, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3032, 0xFFFE, 0x346E, 0x3471, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3472, 0xFFFE,
	0x3474, 0xFFFE, 0x3469, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x346B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x346F, 0x3475
} };

static const iconv_ccs_convtable_8bit from_ucs_58 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x3476, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6461,
	0xFFFE, 0xFFFE, 0x6462, 0x6463, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3A4A, 0xFFFE, 0x3A45, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A47,
	0xFFFE, 0xFFFE, 0x3A50, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A4C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6336, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3A4E, 0xFFFE, 0x3A49, 0xFFFE, 0x3A4B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6337, 0xFFFE, 0x6464,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4057, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x405B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4056, 0xFFFE, 0xFFFE, 0x405E,
	0x405C, 0x4058, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x405D, 0x6343,
	0xFFFE, 0x405A, 0x4059, 0xFFFE, 0x4054, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4643, 0x463E, 0xFFFE, 0xFFFE, 0xFFFE, 0x4642,
	0x463C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x463D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x463A, 0x4645, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4638, 0xFFFE, 0xFFFE, 0x4641, 0x4644, 0x4640,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6465, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B46, 0xFFFE, 0x4B50, 0xFFFE, 0xFFFE, 0x4B51,
	0xFFFE, 0xFFFE, 0x4B4B, 0xFFFE, 0xFFFE, 0x463F, 0xFFFE, 0xFFFE,
	0x4B4D, 0xFFFE, 0x4B49, 0xFFFE, 0x4B4F, 0x4B4C, 0xFFFE, 0x4B47,
	0xFFFE, 0xFFFE, 0xFFFE, 0x504A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x504B, 0xFFFE, 0xFFFE, 0x5048, 0x504C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5049, 0xFFFE, 0xFFFE, 0x544B, 0xFFFE, 0xFFFE,
	0x544C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A2F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5A2E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E28, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2343, 0xFFFE,
	0x2545, 0x2543, 0x2544, 0x282D, 0xFFFE, 0x2B77, 0xFFFE, 0x3477,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3A52, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_59 = { {
	0x6466, 0x504D, 0x2139, 0xFFFE, 0x2235, 0x2344, 0xFFFE, 0xFFFE,
	0x2B7A, 0x2B79, 0x213A, 0x2546, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4646, 0x6560, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2236, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3479,
	0xFFFE, 0xFFFE, 0xFFFE, 0x405F, 0xFFFE, 0xFFFE, 0x4B53, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2238, 0xFFFE, 0x2237, 0xFFFE, 0x2239, 0xFFFE, 0x2347, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2549, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x282E, 0x282F, 0x6467, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2B7C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x347B, 0xFFFE, 0x347C, 0x347D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3A53, 0x3A54, 0xFFFE, 0x4060, 0xFFFE,
	0x4061, 0xFFFE, 0xFFFE, 0xFFFE, 0x4648, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x223B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x234B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x234D, 0xFFFE,
	0xFFFE, 0x2555, 0xFFFE, 0xFFFE, 0x254C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x254B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2556, 0x2553, 0x254E, 0xFFFE, 0xFFFE, 0x2551,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2841, 0x2833, 0xFFFE, 0xFFFE,
	0x2838, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2845,
	0x2840, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x283D,
	0xFFFE, 0xFFFE, 0x2837, 0xFFFE, 0x2835, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x283F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C26, 0xFFFE, 0x2846,
	0xFFFE, 0x2C2D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C21,
	0xFFFE, 0xFFFE, 0x2C2C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C2E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2C23, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C24,
	0x2C25, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2C2B, 0x2C29, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5A = { {
	0xFFFE, 0xFFFE, 0x2C2A, 0xFFFE, 0x2C28, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3040, 0xFFFE, 0x2C27, 0xFFFE, 0xFFFE,
	0x6270, 0xFFFE, 0x304F, 0xFFFE, 0x304A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x304E, 0xFFFE, 0xFFFE, 0x303E, 0xFFFE, 0xFFFE,
	0xFFFE, 0x303B, 0x3045, 0xFFFE, 0x3048, 0xFFFE, 0x3052, 0xFFFE,
	0xFFFE, 0xFFFE, 0x303C, 0x3522, 0x3538, 0xFFFE, 0xFFFE, 0x304D,
	0xFFFE, 0x304B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3528, 0x3524, 0xFFFE, 0x3531, 0xFFFE, 0x3533,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x352E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x352A, 0xFFFE, 0xFFFE, 0x352F, 0x353B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x353A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3539, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3527, 0xFFFE, 0x353C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3530, 0xFFFE, 0xFFFE, 0x352B, 0xFFFE, 0xFFFE, 0x3529, 0x3534,
	0xFFFE, 0x3532, 0xFFFE, 0x3537, 0xFFFE, 0x3535, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3A75, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A7C, 0xFFFE,
	0x3A63, 0x3A61, 0x3A58, 0xFFFE, 0xFFFE, 0x3A5B, 0x3A77, 0x3A72,
	0x3A59, 0x3A60, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A7B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3A66, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A62, 0xFFFE,
	0x3A5C, 0x3A5E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3A73, 0x3A5A, 0xFFFE, 0x3A57, 0x3A7A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3A56, 0xFFFE, 0x3A79, 0x3A78, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4067, 0xFFFE, 0x4066, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4064, 0x3A6B,
	0x406A, 0x6468, 0xFFFE, 0x6469, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x464C, 0xFFFE, 0xFFFE, 0x464A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x464F,
	0x4653, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B5C, 0xFFFE, 0x4B58, 0xFFFE, 0x4B54, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5B = { {
	0x4B5E, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B56, 0xFFFE, 0x4B5A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B5B, 0xFFFE, 0xFFFE, 0x4B5D, 0x4B5F, 0xFFFE,
	0xFFFE, 0x5050, 0x5053, 0xFFFE, 0xFFFE, 0x5051, 0xFFFE, 0xFFFE,
	0x504F, 0xFFFE, 0xFFFE, 0xFFFE, 0x5054, 0xFFFE, 0xFFFE, 0x504E,
	0xFFFE, 0xFFFE, 0x5056, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5450, 0xFFFE, 0x544E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5452, 0xFFFE, 0x544F, 0xFFFE, 0x5451, 0xFFFE, 0x5453,
	0xFFFE, 0x5A31, 0x5761, 0x575E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C36, 0xFFFE, 0x5C39, 0xFFFE, 0x5C3A, 0xFFFE,
	0xFFFE, 0x5E29, 0x5F42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6073,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2848, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x625C, 0x646A,
	0xFFFE, 0xFFFE, 0x2C2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4071, 0xFFFE, 0x4072, 0xFFFE,
	0xFFFE, 0x5057, 0xFFFE, 0xFFFE, 0x5A34, 0xFFFE, 0x5C3B, 0xFFFE,
	0x213B, 0xFFFE, 0x223D, 0xFFFE, 0xFFFE, 0xFFFE, 0x2350, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x255A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x284C, 0xFFFE, 0x284A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x284E, 0x284B, 0x284D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2C32, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3057,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3056, 0x3055, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3541, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x353F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3A7E, 0xFFFE, 0x4074,
	0xFFFE, 0xFFFE, 0x4075, 0x4076, 0x4073, 0x6345, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5A35, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E2A,
	0xFFFE, 0x223E, 0xFFFE, 0xFFFE, 0xFFFE, 0x255E, 0x255C, 0x255D
} };

static const iconv_ccs_convtable_8bit from_ucs_5C = { {
	0x2850, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3058, 0x3059, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x624A, 0x223F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2352, 0x2851, 0xFFFE, 0x2C34, 0xFFFE, 0xFFFE, 0x3B24, 0xFFFE,
	0x4078, 0x6525, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x255F, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C35,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5454, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2354, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2854, 0x2855, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x305A, 0x305B, 0xFFFE, 0xFFFE, 0xFFFE, 0x646B,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3543, 0xFFFE, 0xFFFE, 0x3B26, 0x3B25,
	0xFFFE, 0x3544, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5A38, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x646C,
	0x2355, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x235A, 0xFFFE, 0xFFFE, 0xFFFE, 0x2561, 0x2566, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2562, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2563, 0xFFFE, 0x285D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x285E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x285C, 0x285F, 0x2857, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2858, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C3F, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2C3B, 0xFFFE, 0xFFFE, 0xFFFE, 0x646D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C3C, 0x2C42, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2C3E, 0x2C41, 0xFFFE, 0xFFFE, 0x2C43, 0x2C3D, 0xFFFE,
	0xFFFE, 0x3063, 0xFFFE, 0x305F, 0xFFFE, 0xFFFE, 0xFFFE, 0x3064,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3061, 0xFFFE, 0x3062, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x305E, 0xFFFE, 0x6271, 0xFFFE, 0x6272, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x354B, 0x3548, 0x3547, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3551, 0xFFFE, 0xFFFE, 0x3552, 0xFFFE, 0x354F, 0xFFFE, 0xFFFE,
	0x3555, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B2B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3546, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x354E, 0xFFFE, 0x354A, 0xFFFE, 0xFFFE, 0x3554,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3B36, 0xFFFE, 0xFFFE, 0x3B28, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B27, 0xFFFE, 0x3B37, 0xFFFE,
	0x3B2A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B2E, 0xFFFE, 0x3B34,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3B33, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B31,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3B2D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4121, 0xFFFE, 0xFFFE, 0xFFFE, 0x407C, 0xFFFE, 0x407A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4079, 0x407D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x646E, 0xFFFE, 0xFFFE,
	0x465C, 0xFFFE, 0xFFFE, 0x4654, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4656, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4659, 0x465A, 0xFFFE, 0x646F, 0x4B65,
	0x4B66, 0x4B63, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B6B, 0xFFFE,
	0x4B67, 0xFFFE, 0xFFFE, 0x4B69, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B6A, 0x4B68, 0x6470, 0x5058, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x505B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x505A, 0xFFFE, 0xFFFE, 0x6471, 0xFFFE,
	0xFFFE, 0x5457, 0xFFFE, 0x5459, 0xFFFE, 0xFFFE, 0x5455, 0x6472,
	0xFFFE, 0x5762, 0xFFFE, 0xFFFE, 0x5A39, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5C3D, 0xFFFE, 0x5C3C, 0xFFFE, 0x5C3E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5E2D, 0xFFFE, 0xFFFE, 0x5F43, 0xFFFE, 0xFFFE, 0xFFFE, 0x6030,
	0xFFFE, 0xFFFE, 0xFFFE, 0x213C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3557, 0x4B6C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2567, 0x2860, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2C45, 0x2C44, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5E = { {
	0x2163, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x235C, 0x2568, 0xFFFE, 0x256B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2862, 0x2861, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C46, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3066, 0xFFFE, 0x3069, 0xFFFE, 0x3068, 0x306A,
	0x3067, 0xFFFE, 0x355B, 0xFFFE, 0xFFFE, 0x3559, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3558, 0x355A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3979, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B3A, 0x3B3B,
	0x3B3D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x465D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4B6D, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B70, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6473, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6677, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2863,
	0xFFFE, 0xFFFE, 0x213D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x213E,
	0xFFFE, 0x2247, 0xFFFE, 0x2248, 0xFFFE, 0x6678, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x256E, 0xFFFE, 0x256D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2865, 0x2867, 0xFFFE, 0xFFFE, 0xFFFE, 0x2868, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2C48, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x306C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x306B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3561, 0x3560, 0xFFFE, 0x3B3F, 0xFFFE, 0x3B40,
	0x3B3E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6474, 0xFFFE, 0x4661,
	0x4660, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x505C, 0xFFFE, 0xFFFE, 0x6475, 0xFFFE, 0xFFFE,
	0x5C3F, 0xFFFE, 0xFFFE, 0xFFFE, 0x213F, 0x2361, 0xFFFE, 0xFFFE,
	0x2869, 0x286B, 0xFFFE, 0x2C4C, 0x2C4B, 0x306E, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_5F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x256F, 0xFFFE, 0xFFFE, 0x286D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2164, 0x2249, 0x2362, 0xFFFE,
	0xFFFE, 0x3B42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2571, 0xFFFE,
	0xFFFE, 0x286E, 0xFFFE, 0xFFFE, 0xFFFE, 0x2870, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C4D,
	0xFFFE, 0xFFFE, 0x306F, 0xFFFE, 0x3562, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3563, 0x3B47, 0x3B45, 0xFFFE, 0xFFFE, 0x3B44, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4122, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5763, 0xFFFE, 0xFFFE,
	0x2140, 0x2141, 0x224A, 0x2351, 0xFFFE, 0x2871, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4123, 0x505E, 0xFFFE, 0x5764, 0xFFFE, 0xFFFE,
	0x6164, 0x2142, 0xFFFE, 0x2572, 0xFFFE, 0xFFFE, 0x2C50, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4124, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5F45, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2876, 0x2875, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6264, 0x3070, 0x3072,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3071, 0x6476, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6477, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B4B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4663, 0x4664, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4B72, 0xFFFE, 0x6478, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5E2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x224D,
	0x6251, 0xFFFE, 0x224C, 0xFFFE, 0xFFFE, 0xFFFE, 0x2578, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2366, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2367, 0x2369, 0x2577, 0xFFFE, 0xFFFE, 0x257B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2576, 0x2574,
	0xFFFE, 0x287E, 0xFFFE, 0xFFFE, 0x257C, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2622, 0xFFFE, 0x2621, 0xFFFE, 0xFFFE, 0xFFFE, 0x257D, 0xFFFE,
	0xFFFE, 0x2623, 0xFFFE, 0xFFFE, 0x257A, 0xFFFE, 0x2575, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_60 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2878,
	0x2922, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6266, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2C5A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2877, 0x2C5B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x287A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2921, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6267, 0xFFFE, 0x2C60, 0x3079, 0xFFFE, 0xFFFE, 0x2C56, 0x3073,
	0xFFFE, 0x2C57, 0x2C5D, 0xFFFE, 0xFFFE, 0xFFFE, 0x307E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C54, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2C5F, 0x2C61, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x307A, 0x3078, 0x307B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C5C, 0xFFFE, 0x3076, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3122, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3125, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3568, 0x3074, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3127, 0xFFFE,
	0xFFFE, 0x3571, 0xFFFE, 0xFFFE, 0x3572, 0xFFFE, 0x3123, 0x3128,
	0xFFFE, 0x3121, 0x356F, 0xFFFE, 0xFFFE, 0xFFFE, 0x3126, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3B54, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x356A, 0xFFFE, 0x3B56, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B55, 0x356E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3579, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3B58, 0xFFFE, 0x3B59, 0xFFFE, 0x3576,
	0xFFFE, 0x3B5A, 0x3B4D, 0xFFFE, 0xFFFE, 0xFFFE, 0x3574, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B5E, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_61 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B4F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B51, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3B5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x412B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B61, 0xFFFE,
	0x3B62, 0x3B63, 0x3B50, 0xFFFE, 0xFFFE, 0x6479, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4129, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4127, 0x412C, 0xFFFE, 0x466F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x466E, 0xFFFE, 0x4128, 0xFFFE, 0x466C, 0x412E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x466D, 0x412A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x647A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B73,
	0xFFFE, 0x4B7E, 0xFFFE, 0xFFFE, 0x4B74, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4671, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B7C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4672, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x466A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4C21, 0xFFFE, 0xFFFE, 0x4668, 0xFFFE, 0x4673, 0xFFFE, 0xFFFE,
	0xFFFE, 0x466B, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C23, 0x4674, 0x4C24,
	0x4B77, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B7A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B76, 0xFFFE, 0x5068,
	0x4C28, 0x5067, 0xFFFE, 0xFFFE, 0x4C29, 0xFFFE, 0x4C25, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4B79, 0xFFFE, 0xFFFE, 0x4B75, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5061,
	0xFFFE, 0x5063, 0xFFFE, 0x506A, 0xFFFE, 0x5064, 0xFFFE, 0xFFFE,
	0x5066, 0xFFFE, 0xFFFE, 0xFFFE, 0x506C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5062, 0x5065,
	0x506B, 0xFFFE, 0xFFFE, 0x6679, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5461, 0x545F, 0x545C, 0x545E, 0x545D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x545B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5765, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_62 = { {
	0xFFFE, 0xFFFE, 0x5F46, 0xFFFE, 0xFFFE, 0x613E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x236B,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2625, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2C63, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B64, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4676, 0xFFFE, 0xFFFE, 0xFFFE, 0x4675, 0xFFFE, 0xFFFE, 0x4C2C,
	0xFFFE, 0x506D, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F48, 0xFFFE, 0x2165,
	0x2166, 0x224E, 0xFFFE, 0x2628, 0x2629, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3129, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2250,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x236F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x236C, 0xFFFE, 0x236D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x236E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2639, 0xFFFE, 0xFFFE,
	0x262E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x262A, 0xFFFE, 0xFFFE, 0x2637, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x262F, 0xFFFE, 0x2636, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2635, 0xFFFE, 0x2633, 0x2634, 0x2638, 0x2631, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x647B, 0xFFFE, 0x2632, 0x2931, 0x292A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2926, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2928,
	0xFFFE, 0xFFFE, 0x2925, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2934, 0x2932, 0xFFFE, 0xFFFE, 0xFFFE, 0x2933, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x292E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2930, 0x2937, 0x2935,
	0x2936, 0x292F, 0xFFFE, 0xFFFE, 0x2929, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2C6D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_63 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C6F, 0x2C70, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C6C,
	0xFFFE, 0x3132, 0xFFFE, 0x3133, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C6B,
	0xFFFE, 0x2C6E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x312C, 0xFFFE,
	0x312F, 0x3135, 0xFFFE, 0xFFFE, 0xFFFE, 0x3138, 0xFFFE, 0x3137,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x313C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x312E, 0x3139, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3130, 0x313B, 0x3136, 0xFFFE, 0xFFFE,
	0x647C, 0xFFFE, 0xFFFE, 0xFFFE, 0x647D, 0xFFFE, 0x3631, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3627, 0xFFFE, 0x3629, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3626, 0x3632, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3622, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x357C, 0x362B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3623, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x357D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3624, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x362D, 0xFFFE, 0xFFFE, 0xFFFE, 0x647E, 0xFFFE,
	0xFFFE, 0xFFFE, 0x362E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B71,
	0xFFFE, 0x3B70, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3B73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B67, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3B66, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B68, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B72,
	0x3B6D, 0xFFFE, 0x6339, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B6F, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_64 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x6521, 0xFFFE, 0xFFFE, 0xFFFE, 0x4149,
	0x4132, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x413A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4138, 0xFFFE, 0xFFFE, 0xFFFE, 0x413E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x413D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4136, 0x4133, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4134, 0xFFFE, 0x4148, 0x4725, 0x4142, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4144, 0x4145,
	0xFFFE, 0x6676, 0xFFFE, 0xFFFE, 0x4678, 0xFFFE, 0xFFFE, 0x4728,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x467E, 0x4724, 0x467A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4721, 0xFFFE, 0x472A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4723, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4722, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x467B, 0xFFFE, 0x4729, 0xFFFE,
	0x4C2D, 0x4726, 0xFFFE, 0x4C35, 0xFFFE, 0xFFFE, 0x4C38, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C30, 0x4C2F, 0xFFFE,
	0xFFFE, 0x4C3B, 0xFFFE, 0xFFFE, 0x4C31, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4C2E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C3E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C3F,
	0x4C34, 0xFFFE, 0x4C3D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C3A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C39, 0xFFFE, 0x6522, 0xFFFE,
	0xFFFE, 0x4C37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5070, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C32, 0xFFFE,
	0x5077, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5076, 0xFFFE, 0x506F, 0xFFFE, 0x5079, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5075, 0xFFFE, 0xFFFE, 0x5464,
	0xFFFE, 0x5467, 0xFFFE, 0xFFFE, 0xFFFE, 0x576B, 0xFFFE, 0x576D,
	0xFFFE, 0xFFFE, 0x576C, 0xFFFE, 0xFFFE, 0xFFFE, 0x5469, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x576A, 0xFFFE,
	0xFFFE, 0x5770, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_65 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x576E, 0xFFFE, 0xFFFE,
	0x5A3B, 0xFFFE, 0x5A3C, 0x5A3A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5E31, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6523, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F4A, 0x5F4B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F49,
	0x6032, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2C72, 0xFFFE, 0xFFFE, 0x2167, 0x2168, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2C74, 0xFFFE, 0x2C76, 0xFFFE, 0x2C73, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x313D, 0xFFFE, 0x3637, 0x3636, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3634, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B74,
	0x3B75, 0x3B76, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x414B, 0xFFFE, 0x414E, 0x6346, 0xFFFE,
	0x414D, 0x4730, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C41, 0xFFFE, 0xFFFE,
	0x2558, 0x2939, 0xFFFE, 0x3140, 0xFFFE, 0x3638, 0x3639, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3142, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x293B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x363A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x546B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x293C, 0xFFFE, 0xFFFE, 0xFFFE, 0x2C77, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x363C,
	0xFFFE, 0x363F, 0x363D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3B79, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A3F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2169, 0xFFFE, 0xFFFE, 0x3641, 0x4150, 0xFFFE, 0xFFFE, 0x2251,
	0xFFFE, 0xFFFE, 0x2373, 0x2372, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x263D, 0xFFFE,
	0xFFFE, 0x625E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2943, 0x293E
} };

static const iconv_ccs_convtable_8bit from_ucs_66 = { {
	0xFFFE, 0x2942, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2940,
	0x2941, 0xFFFE, 0x2C7E, 0x2C7A, 0xFFFE, 0xFFFE, 0x2D23, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2C7C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2C79, 0xFFFE, 0xFFFE, 0x2C7D, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2D21, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D24,
	0x2D25, 0xFFFE, 0xFFFE, 0x2D22, 0x2C37, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3146, 0xFFFE, 0xFFFE, 0xFFFE, 0x314C, 0xFFFE, 0x3144, 0xFFFE,
	0x3149, 0xFFFE, 0xFFFE, 0x3148, 0xFFFE, 0x314D, 0x3145, 0xFFFE,
	0x3143, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3642,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x314B, 0xFFFE, 0xFFFE, 0x3644, 0xFFFE, 0xFFFE, 0xFFFE, 0x3645,
	0xFFFE, 0x3C26, 0xFFFE, 0x3B7D, 0xFFFE, 0x3C25, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3C23, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3B7C, 0xFFFE, 0x3B7E,
	0xFFFE, 0x3C24, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x415B, 0x4156,
	0xFFFE, 0xFFFE, 0x4159, 0x4151, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4734, 0xFFFE, 0x4735, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4739, 0x4733, 0x4737, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C44, 0x4C46, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4C41, 0xFFFE, 0xFFFE, 0x4C40, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C43, 0xFFFE, 0xFFFE, 0x507D,
	0xFFFE, 0x5123, 0xFFFE, 0x507A, 0xFFFE, 0x507E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5122, 0x5471, 0xFFFE,
	0x546F, 0x5470, 0xFFFE, 0xFFFE, 0x546C, 0x546D, 0xFFFE, 0x5472,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A43,
	0xFFFE, 0x5A42, 0x6526, 0xFFFE, 0xFFFE, 0x5C42, 0xFFFE, 0x5C43,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x613F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2641, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_67 = { {
	0xFFFE, 0xFFFE, 0x6527, 0xFFFE, 0xFFFE, 0xFFFE, 0x5124, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2945, 0xFFFE, 0x2D27, 0xFFFE,
	0xFFFE, 0x6632, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3648, 0xFFFE,
	0xFFFE, 0x3647, 0x3646, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C29, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5126, 0x6633, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2252,
	0xFFFE, 0xFFFE, 0x2377, 0xFFFE, 0xFFFE, 0xFFFE, 0x2378, 0x2375,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2648, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2649, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2645, 0xFFFE, 0x2644, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2647, 0xFFFE, 0xFFFE, 0x2642, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x264A, 0xFFFE, 0xFFFE, 0xFFFE, 0x6257, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2947, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2952, 0xFFFE, 0x2949, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x625F, 0xFFFE, 0x294A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x294F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2948, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x294E, 0x294C, 0x6528, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6529, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2D36, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D2E, 0xFFFE, 0xFFFE, 0x2D30,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D2D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D31, 0x2D2B, 0x2D3A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2D2A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2951, 0xFFFE, 0x2D34, 0xFFFE, 0xFFFE, 0x2D32, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_68 = { {
	0x2D39, 0x2D37, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D38, 0x652B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x652A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x315D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3157, 0xFFFE, 0x3153, 0xFFFE, 0xFFFE, 0x315B, 0xFFFE,
	0xFFFE, 0xFFFE, 0x315E, 0x3164, 0x3150, 0xFFFE, 0xFFFE, 0x315F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3156, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3163, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3154, 0x314F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x315A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3159,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2D2F, 0xFFFE, 0xFFFE, 0x3162, 0x3158, 0xFFFE,
	0x3161, 0x3160, 0x652D, 0xFFFE, 0xFFFE, 0xFFFE, 0x652C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3655, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3660, 0xFFFE, 0xFFFE, 0x364E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x365B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3657, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3651, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x365A, 0xFFFE, 0xFFFE,
	0x364D, 0x365C, 0x3650, 0xFFFE, 0xFFFE, 0xFFFE, 0x364B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3654, 0x3478, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x364C, 0x3652,
	0x365E, 0x365F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3656, 0xFFFE, 0x3C45, 0xFFFE, 0x3C41, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3C38, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C3E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3653, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3C3D, 0xFFFE, 0xFFFE, 0x3C32, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C2A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C31, 0x3C42
} };

static const iconv_ccs_convtable_8bit from_ucs_69 = { {
	0x3C39, 0x3C3B, 0x3C34, 0x3C2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3C37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3C3C, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C44, 0xFFFE, 0x3C33, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x652F, 0xFFFE, 0xFFFE, 0x652E, 0xFFFE, 0x3C40, 0xFFFE,
	0xFFFE, 0x4165, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4177, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4168, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x416B, 0xFFFE, 0xFFFE, 0x415D, 0x4175,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4173, 0xFFFE, 0xFFFE,
	0x4174, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x416F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4179, 0xFFFE, 0xFFFE, 0x4178, 0xFFFE, 0xFFFE, 0x4176,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x416D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x416A, 0x417B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4172, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x473A,
	0xFFFE, 0xFFFE, 0x473D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4751, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x474E, 0xFFFE, 0x4746,
	0xFFFE, 0xFFFE, 0x4747, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x473E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6352, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4743, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x473B, 0xFFFE, 0xFFFE,
	0x473C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4745, 0x4748, 0xFFFE, 0xFFFE, 0x474D, 0x4744, 0xFFFE,
	0x4C54, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x474C, 0xFFFE, 0x4742, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C64, 0x4C60, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C4F,
	0x4C51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C5F, 0x4C57, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4C4D, 0x4C50, 0xFFFE, 0x4C47, 0xFFFE,
	0x4C5B, 0xFFFE, 0x4C56, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4C4A, 0xFFFE, 0x4C49, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4C52, 0xFFFE, 0x4C62, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C5E, 0x4C59, 0xFFFE, 0x4C61, 0x6530, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x512C, 0xFFFE, 0xFFFE, 0x513C, 0x5138,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5128, 0x512B, 0xFFFE, 0x5140, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x513B, 0xFFFE, 0x5131, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5129, 0x513E, 0xFFFE, 0xFFFE, 0xFFFE, 0x512F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5144, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5127, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x512E, 0xFFFE, 0x5132, 0xFFFE,
	0x5141, 0x513A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6531,
	0xFFFE, 0xFFFE, 0x6532, 0xFFFE, 0xFFFE, 0x5475, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x547B, 0xFFFE, 0xFFFE, 0xFFFE, 0x5521, 0xFFFE,
	0x547C, 0xFFFE, 0x5476, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5527,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5523, 0x547A, 0xFFFE, 0xFFFE, 0xFFFE, 0x5524, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5478,
	0xFFFE, 0xFFFE, 0x5529, 0x5774, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5777, 0x5821, 0x5776, 0xFFFE, 0xFFFE, 0x5778, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x577E, 0xFFFE, 0x5779, 0x5823,
	0x577D, 0x577A, 0xFFFE, 0xFFFE, 0x5822, 0xFFFE, 0xFFFE, 0xFFFE,
	0x577B, 0xFFFE, 0x6533, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A44, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5A4F, 0xFFFE, 0x5A45, 0x5A4E, 0xFFFE, 0x5A47,
	0x5A4D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5A48, 0x5A46, 0xFFFE, 0xFFFE, 0x6534, 0xFFFE,
	0xFFFE, 0x5C49, 0xFFFE, 0xFFFE, 0xFFFE, 0x5775, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C47, 0x6535, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E35, 0x5E34, 0x5E33
} };

static const iconv_ccs_convtable_8bit from_ucs_6B = { {
	0xFFFE, 0x5E37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F4F, 0x5F4E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6536, 0x6537, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6074, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6140, 0x6165, 0x6141, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2379, 0xFFFE, 0xFFFE, 0xFFFE, 0x2953, 0x2954,
	0xFFFE, 0x6269, 0x2D3C, 0x3166, 0xFFFE, 0xFFFE, 0x3165, 0xFFFE,
	0x3167, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3662, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x417D, 0xFFFE, 0xFFFE, 0xFFFE, 0x417C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C66,
	0xFFFE, 0xFFFE, 0x4C65, 0x4C67, 0xFFFE, 0xFFFE, 0xFFFE, 0x5146,
	0x5145, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x552B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2955, 0x2956, 0xFFFE, 0x2D3D, 0x3168, 0xFFFE, 0x3C49, 0x3C47,
	0xFFFE, 0x417E, 0xFFFE, 0x4221, 0x4753, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2253, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2958, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x316A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3664, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4222, 0x6354, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4754, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2959, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3665, 0xFFFE, 0xFFFE, 0x3C4B, 0xFFFE,
	0xFFFE, 0x4226, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x237A, 0xFFFE,
	0xFFFE, 0x295A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6538, 0x6539, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2D42, 0xFFFE, 0xFFFE, 0xFFFE, 0x316E, 0xFFFE, 0xFFFE,
	0xFFFE, 0x316C, 0x316D, 0xFFFE, 0xFFFE, 0x3666, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C4D, 0xFFFE, 0x653A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4228, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x552D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x295D, 0xFFFE, 0x653B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C4E, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4229, 0x422A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2257,
	0xFFFE, 0x2254, 0xFFFE, 0xFFFE, 0x2421, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2258, 0x2259, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x237D, 0xFFFE, 0x2425, 0xFFFE, 0xFFFE, 0x2655, 0xFFFE,
	0x237C, 0xFFFE, 0x2423, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x653C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2964, 0xFFFE, 0x2650, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2653, 0xFFFE, 0x237E,
	0xFFFE, 0x2657, 0xFFFE, 0xFFFE, 0x2651, 0xFFFE, 0xFFFE, 0x264C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x264D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2963,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x264E, 0x2652,
	0x265C, 0x2659, 0x2656, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x265B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D4E,
	0xFFFE, 0xFFFE, 0x296B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x296D, 0xFFFE, 0xFFFE, 0x6261, 0xFFFE, 0xFFFE, 0x296C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x296A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2965,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2969, 0xFFFE, 0x6260, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2967, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D4F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D46
} };

static const iconv_ccs_convtable_8bit from_ucs_6D = { {
	0xFFFE, 0xFFFE, 0x2D50, 0xFFFE, 0xFFFE, 0x2D48, 0x2D4A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2D49, 0x2D47, 0x2D4D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x317A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2D4B, 0xFFFE, 0x2D45, 0x2D57, 0xFFFE, 0x2D53, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D55, 0x2D51, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3177, 0x3173,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3179, 0x3226, 0x3176, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x316F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3222, 0x3225, 0x3172, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3221, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3178,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3227, 0xFFFE,
	0xFFFE, 0x317D, 0x317B, 0x317C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x653D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x366F, 0xFFFE, 0xFFFE,
	0x367A, 0x3721, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C50, 0xFFFE,
	0xFFFE, 0x3672, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x366A, 0xFFFE, 0x366B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x366C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3674,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x367C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C5D, 0x3728
} };

static const iconv_ccs_convtable_8bit from_ucs_6E = { {
	0xFFFE, 0x3726, 0x3723, 0xFFFE, 0x3670, 0xFFFE, 0x3677, 0x3724,
	0x3676, 0x3725, 0x3679, 0xFFFE, 0x367D, 0xFFFE, 0xFFFE, 0x653E,
	0xFFFE, 0xFFFE, 0x3729, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3727,
	0x3C54, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C52, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3C6B, 0x3C6D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3C5A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3C56, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C6E, 0xFFFE, 0xFFFE, 0x3C58,
	0x3C69, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C66,
	0xFFFE, 0x3C64, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3C5B, 0xFFFE, 0x423A, 0x3C60, 0xFFFE, 0xFFFE,
	0x3C5C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C51, 0x3C6C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3C62, 0x6542, 0xFFFE, 0x3C63, 0xFFFE,
	0x3C68, 0xFFFE, 0xFFFE, 0xFFFE, 0x6540, 0xFFFE, 0x633D, 0xFFFE,
	0xFFFE, 0xFFFE, 0x653F, 0x6541, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4230, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4233, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x422E, 0x4236, 0xFFFE, 0xFFFE, 0x4240, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4239, 0xFFFE, 0xFFFE,
	0x422D, 0xFFFE, 0xFFFE, 0x4231, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4244, 0x423E, 0x4247, 0xFFFE, 0x423D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4245, 0xFFFE, 0xFFFE, 0x423F, 0xFFFE,
	0x423B, 0x4246, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4756, 0xFFFE, 0xFFFE, 0x4757, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4765, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_6F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4763, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4C78, 0x475B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4C6A, 0x4764, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x475F,
	0xFFFE, 0xFFFE, 0xFFFE, 0x475A, 0xFFFE, 0x475C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x475E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x475D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C74, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4762, 0xFFFE, 0x4761, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6544, 0x6545, 0x4766, 0xFFFE, 0x6543, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C7D, 0xFFFE, 0xFFFE, 0x4C73, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C6B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C75, 0xFFFE, 0xFFFE, 0x4C7E, 0x4C6C, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C79, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4C7A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6363, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4C7B,
	0xFFFE, 0x4C77, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6547, 0xFFFE, 0xFFFE, 0xFFFE, 0x6546, 0xFFFE, 0x5156,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5154, 0xFFFE, 0x5158,
	0xFFFE, 0xFFFE, 0xFFFE, 0x514D, 0xFFFE, 0xFFFE, 0x5150, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4C71, 0xFFFE, 0xFFFE, 0x5155, 0xFFFE, 0xFFFE, 0x5530, 0x552F,
	0xFFFE, 0x5535, 0x5536, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5531, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5537, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5A55, 0xFFFE, 0x5159, 0x5539, 0xFFFE,
	0x6548, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5828, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_70 = { {
	0xFFFE, 0xFFFE, 0x582A, 0x5827, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5826, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5829, 0xFFFE, 0xFFFE, 0x582B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A52, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A54, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A53, 0x654A, 0x6549, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C51, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C4F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E3C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5E3A, 0xFFFE, 0x5E3B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6036, 0x5F52, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6037, 0xFFFE, 0xFFFE, 0x654B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6179,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2428, 0x2426,
	0xFFFE, 0xFFFE, 0x2427, 0x242B, 0xFFFE, 0x2662, 0xFFFE, 0x265F,
	0xFFFE, 0x265E, 0xFFFE, 0x2663, 0xFFFE, 0xFFFE, 0x2660, 0xFFFE,
	0xFFFE, 0x2977, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2974,
	0x2970, 0x2975, 0xFFFE, 0x296F, 0x2979, 0x2976, 0xFFFE, 0x2972,
	0x2971, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2D5E, 0xFFFE, 0x2D5C, 0x2D5A, 0xFFFE, 0x2D58, 0x626A, 0x2D65,
	0x2D62, 0xFFFE, 0x2D5F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2D64, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D63, 0xFFFE,
	0xFFFE, 0x2D68, 0xFFFE, 0x2D5D, 0xFFFE, 0xFFFE, 0xFFFE, 0x654D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3228, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6279, 0xFFFE, 0xFFFE, 0x322A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x322B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3231, 0x322F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3229, 0xFFFE, 0xFFFE, 0xFFFE, 0x322D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x322C, 0xFFFE, 0x654F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x654E, 0xFFFE, 0xFFFE, 0xFFFE, 0x3230, 0xFFFE,
	0xFFFE, 0x3730, 0x3732, 0xFFFE, 0xFFFE, 0x372F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3735, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_71 = { {
	0xFFFE, 0x372E, 0xFFFE, 0x372C, 0xFFFE, 0xFFFE, 0xFFFE, 0x372D,
	0x3731, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3733,
	0xFFFE, 0x6550, 0x6551, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C74, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3C7D, 0xFFFE, 0xFFFE, 0x3C7C,
	0xFFFE, 0xFFFE, 0x3C6F, 0x3C7A, 0x3C72, 0x3D21, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3C7B, 0x3C79, 0x3C71, 0xFFFE, 0x3C73,
	0x3C77, 0x6553, 0xFFFE, 0x6554, 0xFFFE, 0x6555, 0xFFFE, 0x6552,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4257, 0xFFFE, 0xFFFE,
	0x424C, 0xFFFE, 0x424E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4251,
	0xFFFE, 0x4258, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4252,
	0xFFFE, 0xFFFE, 0xFFFE, 0x483C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x424F, 0xFFFE, 0x4259, 0xFFFE, 0x4249,
	0xFFFE, 0x6559, 0xFFFE, 0xFFFE, 0x4253, 0x6557, 0x6558, 0x6556,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x476F, 0xFFFE, 0x476E, 0x476C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4770, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4772, 0xFFFE, 0xFFFE, 0x476A, 0x476D, 0x476B, 0x4768, 0xFFFE,
	0xFFFE, 0x4767, 0xFFFE, 0x655B, 0xFFFE, 0xFFFE, 0x655A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4D2A, 0x4D24, 0xFFFE, 0xFFFE, 0x4D29, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4D28, 0xFFFE, 0x4D25, 0x4D22, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x655C, 0xFFFE, 0x5162, 0x515A,
	0xFFFE, 0xFFFE, 0x5160, 0x515C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5163, 0x6374, 0xFFFE, 0xFFFE,
	0xFFFE, 0x515E, 0xFFFE, 0x5166, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x655D, 0x655E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x553C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x553E, 0x5543, 0x5540, 0xFFFE, 0xFFFE, 0xFFFE, 0x5541,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5542, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x582D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_72 = { {
	0x582E, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A56, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5A57, 0xFFFE, 0xFFFE, 0x5C59, 0xFFFE, 0xFFFE, 0x655F, 0x5C56,
	0xFFFE, 0x5C58, 0x5C55, 0xFFFE, 0xFFFE, 0x5A58, 0x5C53, 0x5C57,
	0x6561, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F53, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5F54, 0x6039, 0xFFFE, 0xFFFE, 0x6143, 0x6142, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D69, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3D22, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D6B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x297C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x425D, 0xFFFE,
	0x425C, 0x425B, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D2E, 0xFFFE, 0x4D2D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2664, 0x2A21, 0x2A22, 0xFFFE,
	0x2A23, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D6D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3236, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3D24, 0x3D23, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D25,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4775, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4D2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x617B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x242C, 0x242D, 0xFFFE, 0xFFFE, 0xFFFE, 0x266B, 0xFFFE,
	0xFFFE, 0x2669, 0xFFFE, 0x2666, 0x2667, 0xFFFE, 0x266A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2668,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A26, 0xFFFE, 0x2A2A,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2A27, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2A28, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2D75, 0xFFFE, 0xFFFE, 0x2D74, 0xFFFE, 0x2D70,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D73, 0x2D71, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3238, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_73 = { {
	0xFFFE, 0xFFFE, 0x3239, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D26, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x373B, 0xFFFE,
	0x373A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3739, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D27, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3D2E, 0xFFFE, 0x3D29, 0x3D2B, 0x3D2A, 0xFFFE, 0x4261, 0x3D2D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3D28, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x425F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4262, 0x6562,
	0x6563, 0xFFFE, 0xFFFE, 0x4D30, 0xFFFE, 0xFFFE, 0xFFFE, 0x4779,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4778, 0x477A, 0x4777, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5549, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x225A, 0x216B, 0xFFFE, 0x242F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x266E, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A33, 0xFFFE, 0x2A2D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2A2C, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A2B,
	0xFFFE, 0xFFFE, 0x2A32, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A2F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D78, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2D7B, 0xFFFE, 0xFFFE, 0x2D77, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2D7A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2D7E, 0x2D79,
	0x2D7C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x323E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3240,
	0xFFFE, 0x3247, 0x323C, 0xFFFE, 0x3246, 0xFFFE, 0x3241, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x323D, 0xFFFE, 0xFFFE, 0x6564,
	0xFFFE, 0xFFFE, 0xFFFE, 0x373D, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D38,
	0xFFFE, 0x323F, 0xFFFE, 0x3740, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_74 = { {
	0xFFFE, 0xFFFE, 0x373C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6565, 0xFFFE, 0x3D36, 0x3D3A, 0xFFFE, 0x3D2F,
	0x3D3B, 0x3D32, 0xFFFE, 0xFFFE, 0x3D39, 0xFFFE, 0x426D, 0x3D35,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4264,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3D33, 0x3D3C, 0xFFFE, 0x6566, 0x3D37, 0x4268, 0x4275, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x426F, 0xFFFE, 0x4274, 0xFFFE, 0x426E,
	0x4266, 0x4271, 0xFFFE, 0xFFFE, 0x4273, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4267, 0xFFFE, 0xFFFE, 0x426B, 0xFFFE,
	0x4270, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x426A, 0xFFFE, 0xFFFE,
	0x4825, 0x477E, 0xFFFE, 0xFFFE, 0xFFFE, 0x477C, 0x477D, 0xFFFE,
	0x4822, 0xFFFE, 0xFFFE, 0x4821, 0x477B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4827, 0xFFFE, 0x4823, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4D31, 0x4D3B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4D39, 0xFFFE, 0x4D36, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D35, 0x6568, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4D3A, 0xFFFE, 0xFFFE, 0x516A, 0xFFFE,
	0xFFFE, 0x6375, 0xFFFE, 0x5167, 0xFFFE, 0x516C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x516B, 0xFFFE, 0x6567, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x554F, 0xFFFE, 0x554B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x554D, 0x6569, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x582F, 0xFFFE, 0xFFFE, 0x5830, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A5A, 0xFFFE, 0xFFFE, 0x5A5C,
	0x5A5D, 0x5A5B, 0xFFFE, 0xFFFE, 0x5C5E, 0x5C5C, 0x5C5F, 0xFFFE,
	0x5C5D, 0x5C60, 0xFFFE, 0x5E3D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2E22, 0xFFFE, 0x2E21, 0xFFFE, 0x2E24,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3248, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3D3D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_75 = { {
	0xFFFE, 0x4277, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4828, 0xFFFE,
	0xFFFE, 0x4D3D, 0x516D, 0xFFFE, 0xFFFE, 0xFFFE, 0x516E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3744, 0xFFFE, 0xFFFE, 0x4278, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3745, 0x3D3E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2A37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2A38, 0x2A35, 0xFFFE, 0x2A36, 0xFFFE, 0x2E27, 0xFFFE,
	0xFFFE, 0x2E25, 0x2E28, 0xFFFE, 0xFFFE, 0x2E2A, 0xFFFE, 0xFFFE,
	0x2E26, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x324E, 0x324D, 0x3250,
	0x324F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3251, 0xFFFE,
	0xFFFE, 0x3746, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3749,
	0x3747, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D43, 0x3D42, 0xFFFE,
	0xFFFE, 0x3D44, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x427B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5170, 0xFFFE, 0x5552, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5C62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D45, 0xFFFE,
	0xFFFE, 0xFFFE, 0x225B, 0x2673, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2A3A, 0xFFFE, 0xFFFE, 0x2A3B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E2B, 0xFFFE,
	0x2E2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3257, 0xFFFE, 0xFFFE, 0x3255, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3252, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x374A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D47, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x427C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_76 = { {
	0xFFFE, 0xFFFE, 0x427D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x482B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4829, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5171, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5173, 0x5172,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5174, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5555, 0x5553, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5554, 0x5834,
	0xFFFE, 0x5833, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5832, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E3F,
	0x5E3E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x603B,
	0xFFFE, 0xFFFE, 0xFFFE, 0x656A, 0xFFFE, 0xFFFE, 0x225C, 0x656B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2674, 0xFFFE, 0xFFFE, 0x2676, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x374D, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D4C, 0xFFFE, 0xFFFE, 0x427E,
	0x4321, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5176, 0xFFFE, 0x5556, 0xFFFE, 0x5557, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5A5E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3D4D, 0xFFFE, 0xFFFE, 0xFFFE, 0x4830,
	0xFFFE, 0x482E, 0xFFFE, 0xFFFE, 0x656C, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2677, 0x2678, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E32,
	0xFFFE, 0xFFFE, 0xFFFE, 0x325A, 0x325B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3750, 0x3752, 0x3751,
	0xFFFE, 0x3D4F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4831, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5835, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E35, 0xFFFE, 0x2E33
} };

static const iconv_ccs_convtable_8bit from_ucs_77 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x626C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3264, 0x325F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x325E, 0xFFFE,
	0x3268, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3759, 0xFFFE,
	0xFFFE, 0x3267, 0xFFFE, 0xFFFE, 0x3265, 0xFFFE, 0x3755, 0xFFFE,
	0xFFFE, 0xFFFE, 0x325C, 0x3263, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3753, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3262,
	0x3757, 0xFFFE, 0x3D56, 0x3D53, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3D51, 0x3D52, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4327, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4328, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4325, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4326, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4839, 0xFFFE, 0xFFFE, 0x4833, 0x4836, 0x4835, 0x4834,
	0x4838, 0xFFFE, 0x483B, 0x483D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4D44, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4D46, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x517B, 0xFFFE,
	0x5179, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5559, 0xFFFE, 0x5558, 0xFFFE,
	0xFFFE, 0x555B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x555C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5836, 0x5838, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x583B, 0xFFFE,
	0x583A, 0x5839, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A60, 0x5A5F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5E42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6432, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3269, 0xFFFE, 0x3D57,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E36, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x267B, 0x267C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_78 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E39, 0xFFFE, 0xFFFE, 0x2E3B,
	0x2E3E, 0xFFFE, 0x2E37, 0x2E3A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E3D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x656D, 0xFFFE, 0x656E, 0xFFFE, 0xFFFE, 0x667C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x326C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x326D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x656F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3762, 0xFFFE, 0xFFFE, 0xFFFE, 0x3763, 0x375D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x375F, 0xFFFE, 0xFFFE, 0xFFFE, 0x3761,
	0xFFFE, 0x3760, 0xFFFE, 0x6570, 0x6571, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6572, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D5C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3D59, 0xFFFE, 0xFFFE, 0x3D5D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D5A, 0xFFFE,
	0x4331, 0xFFFE, 0x432D, 0xFFFE, 0xFFFE, 0x432E, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4337, 0x4329, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4335, 0xFFFE, 0x432B, 0x4330, 0xFFFE, 0x4334, 0xFFFE, 0xFFFE,
	0x432A, 0xFFFE, 0x4336, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x483E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x483F, 0x4845,
	0xFFFE, 0x4844, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6573,
	0x4840, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4D4A, 0xFFFE, 0x4D4D, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D48, 0x4D4C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4D4B, 0x4D49, 0xFFFE, 0xFFFE, 0x5221, 0xFFFE,
	0x6574, 0xFFFE, 0xFFFE, 0xFFFE, 0x5224, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5222, 0xFFFE, 0xFFFE, 0x6575, 0xFFFE,
	0x5560, 0x5562, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5561, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_79 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5843, 0x583E,
	0x5840, 0xFFFE, 0x583F, 0x583C, 0xFFFE, 0x5842, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5844, 0xFFFE, 0xFFFE,
	0x5A61, 0xFFFE, 0x5A62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5A63, 0xFFFE, 0x6576, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E45, 0xFFFE,
	0x5E43, 0xFFFE, 0x5E44, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x603C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2433, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6577, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x326F, 0x3270, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3272, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D5E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3766, 0xFFFE, 0x3765, 0xFFFE,
	0xFFFE, 0x3D5F, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D64, 0x3D62, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4338, 0xFFFE,
	0x433D, 0xFFFE, 0xFFFE, 0x4339, 0x3D63, 0xFFFE, 0x6578, 0x4848,
	0xFFFE, 0x4847, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6579, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D50, 0x4D51, 0x4D4F,
	0xFFFE, 0xFFFE, 0xFFFE, 0x657A, 0xFFFE, 0x5226, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5227, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5845,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x603D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x657B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2A3E, 0x2A3D, 0xFFFE, 0x2A3F, 0x2A42,
	0xFFFE, 0xFFFE, 0x2A44, 0xFFFE, 0x654C, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2E42, 0xFFFE, 0xFFFE, 0x2E40, 0x2E41, 0xFFFE, 0xFFFE, 0x2E43,
	0xFFFE, 0x3274, 0x3273, 0x3279, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3276, 0x327B, 0xFFFE, 0xFFFE, 0x3277, 0xFFFE, 0xFFFE,
	0x3278, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x327C, 0x3769, 0x3767, 0x376B, 0xFFFE, 0x376A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x376C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D65
} };

static const iconv_ccs_convtable_8bit from_ucs_7A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D66,
	0xFFFE, 0x3D69, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D68, 0x4341,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4344, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6524, 0xFFFE, 0xFFFE,
	0xFFFE, 0x484B, 0x484D, 0xFFFE, 0x4850, 0x484F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4852, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4D55, 0xFFFE, 0x4D56, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D5A, 0xFFFE,
	0xFFFE, 0x4D53, 0x4D57, 0xFFFE, 0xFFFE, 0x522A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5564, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x522C,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5229, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A66, 0xFFFE, 0x5A65, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5A67, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C64,
	0xFFFE, 0xFFFE, 0x6076, 0x6077, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E44, 0x2E47, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2E49, 0x2E48, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3772, 0xFFFE, 0x3771, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3770, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4346, 0xFFFE, 0xFFFE, 0x4347, 0xFFFE, 0xFFFE, 0x657C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4D5B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x522F, 0xFFFE, 0x522E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5568, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5E49, 0x5E48, 0xFFFE, 0xFFFE, 0x267E, 0x2721, 0xFFFE, 0x2A47,
	0x2E4E, 0xFFFE, 0x2E4F, 0x2E4D, 0x2E4B, 0x2E4C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3323, 0x3326, 0x3327, 0x3324, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3773, 0x3D71, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3D70,
	0xFFFE, 0x4349, 0x434A, 0xFFFE, 0x4854, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4855, 0x5230, 0x5569, 0x556A, 0xFFFE, 0x5849, 0xFFFE, 0xFFFE,
	0x5F55, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E51, 0xFFFE, 0x2E50, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x332B, 0xFFFE, 0x332A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x332C, 0xFFFE, 0x3778, 0x3779,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3777, 0xFFFE, 0xFFFE, 0x377B,
	0xFFFE, 0x3776, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x632D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x377A, 0x657D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3D7B, 0x3D78, 0x3D75, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3D79, 0xFFFE, 0x3D72, 0xFFFE, 0x3D76,
	0xFFFE, 0x657E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x434F, 0xFFFE,
	0xFFFE, 0xFFFE, 0x434C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4355, 0xFFFE, 0xFFFE, 0x434D, 0x3D77, 0xFFFE, 0xFFFE, 0x4354,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4351, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4856, 0xFFFE, 0x4858, 0xFFFE, 0xFFFE, 0x4860, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x485A, 0x485E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4857, 0x485D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x485C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D5C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4D65, 0x4D5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D60,
	0xFFFE, 0xFFFE, 0x6367, 0x6366, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D63, 0xFFFE, 0xFFFE,
	0x6621, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5233, 0x5234, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x556D, 0xFFFE,
	0xFFFE, 0xFFFE, 0x556B, 0xFFFE, 0x556E, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5570, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5571, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x556F, 0xFFFE, 0x5850, 0x584E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5851, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x584C, 0x6622,
	0xFFFE, 0xFFFE, 0x6623, 0xFFFE, 0x5A6F, 0x5A6E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6624, 0xFFFE, 0x5C66, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5C65, 0xFFFE, 0xFFFE, 0x6625, 0xFFFE,
	0xFFFE, 0x5E4C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E4B, 0xFFFE,
	0x5F58, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F57, 0x603F, 0xFFFE,
	0xFFFE, 0xFFFE, 0x603E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6626, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6144, 0xFFFE, 0xFFFE,
	0xFFFE, 0x623A, 0xFFFE, 0xFFFE, 0x2A49, 0xFFFE, 0x2A48, 0x2E52,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2E54, 0x2E53, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3331, 0xFFFE, 0xFFFE, 0x332E, 0x3330,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3332, 0xFFFE, 0xFFFE, 0x332D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x377D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x377E, 0x3821, 0x383E, 0x3822, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3E21, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E23, 0xFFFE, 0x3E22, 0x3D7E,
	0xFFFE, 0x6627, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4358, 0xFFFE,
	0x435C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4862,
	0x4861, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4D6F, 0x4D71, 0x4D6D, 0xFFFE, 0x4D70, 0x4D73,
	0xFFFE, 0x4D72, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D6E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5237, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5575, 0x5574, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5239, 0xFFFE, 0x5855, 0xFFFE, 0xFFFE, 0x5854, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6628, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6169, 0xFFFE, 0x6040, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2722, 0xFFFE, 0x2A4B, 0xFFFE, 0xFFFE, 0x2A4A
} };

static const iconv_ccs_convtable_8bit from_ucs_7D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3337, 0x333B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3829, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3826, 0xFFFE, 0xFFFE, 0x3827,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x382E, 0x3824, 0xFFFE, 0xFFFE, 0x382B, 0x3E34, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E29,
	0xFFFE, 0x3E26, 0x3E2E, 0xFFFE, 0xFFFE, 0x3E2F, 0xFFFE, 0xFFFE,
	0x3E28, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E2C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E2A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E24, 0x3E35, 0x3E33, 0xFFFE,
	0x4367, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E2B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4366,
	0xFFFE, 0x4369, 0x4360, 0x4362, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x435E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4364, 0xFFFE, 0x4368,
	0x436A, 0x4363, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4874, 0xFFFE, 0xFFFE, 0xFFFE,
	0x486D, 0xFFFE, 0xFFFE, 0x486E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4870, 0xFFFE, 0xFFFE, 0x4869, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4868, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4871, 0xFFFE, 0x4873,
	0x6629, 0x486B, 0xFFFE, 0x662B, 0xFFFE, 0xFFFE, 0x4E22, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4D7C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4D78, 0xFFFE, 0x4E24, 0x4E2F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4E2E, 0xFFFE, 0x4D77, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E2B, 0xFFFE, 0xFFFE,
	0x4D75, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E28, 0x4E29, 0x4E25, 0x4E2C
} };

static const iconv_ccs_convtable_8bit from_ucs_7E = { {
	0x4E27, 0x4D7E, 0x4D7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x662A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x523B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5240, 0x523F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5579, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x557A, 0xFFFE, 0x5859,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x585B, 0xFFFE, 0x5858, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x662C, 0xFFFE, 0x585A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A72, 0xFFFE, 0x5A74, 0xFFFE,
	0xFFFE, 0x5A75, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C6C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E53, 0x5E50, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5E51, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E52, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5F5A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6235, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_7F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3831, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x662D, 0x4877, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x557D, 0x585C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F5B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2A4E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x333C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4878,
	0xFFFE, 0x4879, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4E30, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6422, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E5D,
	0xFFFE, 0xFFFE, 0xFFFE, 0x333D, 0xFFFE, 0xFFFE, 0xFFFE, 0x333F,
	0xFFFE, 0x333E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x436E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E31, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x585D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3342, 0xFFFE, 0x3343, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3E37, 0xFFFE, 0xFFFE, 0x3E38, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4372, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E32,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x557E, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5861, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_80 = { {
	0xFFFE, 0xFFFE, 0x667B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3836, 0xFFFE, 0x3344, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3837, 0xFFFE, 0xFFFE, 0x3839, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4922, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5621, 0xFFFE, 0xFFFE, 0x5862, 0x5C6F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3349, 0x3348, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3347, 0x662F, 0xFFFE, 0xFFFE, 0x383D, 0x383C, 0xFFFE, 0xFFFE,
	0xFFFE, 0x383B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E3C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6729, 0xFFFE, 0xFFFE, 0xFFFE, 0x4373,
	0xFFFE, 0x6356, 0xFFFE, 0x4923, 0xFFFE, 0xFFFE, 0xFFFE, 0x4926,
	0x3E3B, 0x4925, 0xFFFE, 0x6630, 0xFFFE, 0x4E34, 0x4E36, 0xFFFE,
	0x4E37, 0xFFFE, 0x4E35, 0x4E38, 0xFFFE, 0xFFFE, 0x5243, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5622, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5C70, 0x5C71, 0x5C72, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2435, 0x2436, 0xFFFE,
	0xFFFE, 0x2724, 0xFFFE, 0xFFFE, 0x2726, 0xFFFE, 0xFFFE, 0x2725,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2723,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A56, 0xFFFE, 0x2A5B, 0x2A58,
	0x2A4F, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A59, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2A52, 0xFFFE, 0xFFFE, 0x2A54, 0xFFFE, 0xFFFE, 0x2A57, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6631, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E66, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2E60, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2E61, 0x2E5E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E65,
	0xFFFE, 0xFFFE, 0x2E64, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x334C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x334A, 0x3352,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x334B
} };

static const iconv_ccs_convtable_8bit from_ucs_81 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x334E, 0x334D, 0xFFFE, 0xFFFE, 0x334F,
	0xFFFE, 0x2E63, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E44, 0xFFFE, 0xFFFE, 0x3849,
	0xFFFE, 0xFFFE, 0x3847, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x632E, 0xFFFE, 0x3841, 0xFFFE, 0xFFFE, 0xFFFE, 0x3842, 0xFFFE,
	0xFFFE, 0x3845, 0xFFFE, 0xFFFE, 0x3848, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3E3E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3E43, 0x3E45, 0x3E41, 0xFFFE, 0xFFFE, 0x3E3D, 0xFFFE, 0xFFFE,
	0x3E40, 0x3E42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x437B, 0xFFFE, 0x437E,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4375, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4376, 0xFFFE, 0x4377, 0x4423, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x437C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4422, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4927, 0xFFFE, 0xFFFE, 0x492A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4E3B, 0x4E3D, 0x4E39, 0xFFFE, 0x4E3C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4E3A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5249, 0xFFFE, 0xFFFE, 0x5247, 0xFFFE, 0x5244,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5623, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5624, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5865, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A77, 0xFFFE, 0x5A78, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E47,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E48, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_82 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x3E49, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A5D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x492B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x524A, 0x5868, 0x5A79, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E68, 0xFFFE, 0xFFFE, 0x3357,
	0xFFFE, 0x3358, 0xFFFE, 0xFFFE, 0xFFFE, 0x3355, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4426, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6634, 0xFFFE, 0x492D, 0xFFFE, 0x492E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5A7A, 0xFFFE, 0xFFFE, 0x5A7B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5E55, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A7C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2438, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2728, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2729, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x272B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A60, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A6B, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2A66, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2A6C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A5E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2A68, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2E76, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2E6A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E6B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2E78, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2E72, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E74, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E69,
	0x2E6E, 0xFFFE, 0xFFFE, 0xFFFE, 0x2E6F, 0x2E7A, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_83 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2E79, 0xFFFE, 0xFFFE, 0x2E77, 0xFFFE,
	0x6635, 0xFFFE, 0x6637, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3362, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x384D, 0xFFFE, 0x3359,
	0xFFFE, 0x335F, 0xFFFE, 0x385B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A5F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E57, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x335A,
	0x3363, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6636, 0x2D33, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x384E, 0x3851, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3854, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3850, 0xFFFE, 0xFFFE, 0xFFFE, 0x384F, 0x385D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3855, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x385E, 0xFFFE, 0xFFFE, 0x3857,
	0xFFFE, 0x3852, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3858, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x385F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E5E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3E4F, 0x3E59, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3E4D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E5F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E4B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_84 = { {
	0x3E52, 0xFFFE, 0x3E5C, 0xFFFE, 0xFFFE, 0x3E5A, 0xFFFE, 0xFFFE,
	0x3E50, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E58, 0xFFFE, 0x3E5D, 0x3E56,
	0x3E4E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6639, 0x3E5B,
	0xFFFE, 0x6638, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x442D, 0xFFFE, 0xFFFE, 0xFFFE, 0x4431, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x443A, 0xFFFE,
	0xFFFE, 0x4435, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x442C, 0xFFFE, 0x443E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4427,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4433, 0xFFFE, 0x443F, 0xFFFE, 0xFFFE,
	0x4440, 0xFFFE, 0xFFFE, 0xFFFE, 0x4432, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4438, 0xFFFE, 0x4430, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x443C, 0x442F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x442E, 0xFFFE, 0xFFFE, 0xFFFE, 0x442A,
	0x4439, 0xFFFE, 0xFFFE, 0x443B, 0x4428, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4935, 0x4944, 0xFFFE, 0x4933, 0x4938, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x493C, 0xFFFE, 0x4939, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4942, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x493B, 0xFFFE, 0x493A, 0xFFFE, 0x4941,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4932, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4936, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4436, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x493F, 0xFFFE, 0xFFFE,
	0x493E, 0xFFFE, 0x4943, 0xFFFE, 0xFFFE, 0xFFFE, 0x663B, 0xFFFE,
	0xFFFE, 0x663C, 0x663A, 0xFFFE, 0x493D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E4F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E44, 0xFFFE, 0xFFFE,
	0x4E42, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_85 = { {
	0xFFFE, 0x4E40, 0xFFFE, 0x4E4C, 0x4E46, 0x4E54, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4E4B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4E4D, 0x4E4E, 0x4E52, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x525A,
	0xFFFE, 0xFFFE, 0x5252, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5259, 0x5250, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5258, 0xFFFE, 0x5254, 0xFFFE, 0xFFFE, 0x5256,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x524F,
	0x5255, 0xFFFE, 0xFFFE, 0x663D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x562B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5628, 0x5629, 0xFFFE, 0xFFFE, 0xFFFE, 0x562D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x562C, 0x5630, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x586C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x586E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x586F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x586B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x663E, 0xFFFE, 0x5A7E, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5A7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B22,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C7B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B25, 0x663F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C76, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_86 = { {
	0xFFFE, 0xFFFE, 0x5C78, 0x5C7C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D22, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C7E, 0xFFFE, 0x5D23,
	0x5C77, 0xFFFE, 0xFFFE, 0x5D21, 0xFFFE, 0x5E5B, 0x5E5A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E5C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5E58, 0xFFFE, 0xFFFE, 0x5E56, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E57,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6640,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6043, 0xFFFE, 0xFFFE,
	0xFFFE, 0x602F, 0x6146, 0xFFFE, 0xFFFE, 0x6641, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6147, 0x617C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3863,
	0x3860, 0xFFFE, 0x3861, 0xFFFE, 0xFFFE, 0x3E61, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x272D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6642, 0xFFFE, 0xFFFE, 0x2F23, 0x2E7C, 0xFFFE,
	0x2E7E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F24, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3369, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x336C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x336F,
	0xFFFE, 0xFFFE, 0x336E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x336B, 0xFFFE, 0xFFFE, 0xFFFE, 0x336A,
	0x3370, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x336D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3866, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3864, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E62, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3E63, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E68, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4444, 0x4445, 0xFFFE, 0x4449
} };

static const iconv_ccs_convtable_8bit from_ucs_87 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4446, 0x4448, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x494F, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x494A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4945, 0xFFFE,
	0xFFFE, 0x494C, 0xFFFE, 0xFFFE, 0xFFFE, 0x4949, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x494E, 0xFFFE, 0x494B,
	0xFFFE, 0xFFFE, 0x6643, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4E5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E59, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x525B, 0x525D, 0xFFFE, 0xFFFE, 0x525F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5262, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x525E, 0xFFFE, 0xFFFE, 0xFFFE, 0x6645, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6644, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x563A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5639, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x563B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5636, 0x5634, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B28, 0x5876, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5878, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5873, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5874, 0xFFFE,
	0x5875, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6646, 0xFFFE, 0xFFFE,
	0x5B2C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B27, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_88 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B29,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5877, 0x5B2B,
	0xFFFE, 0xFFFE, 0x5D25, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D24, 0xFFFE, 0x5E5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F5F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6045, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6647, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x2F26, 0xFFFE, 0xFFFE, 0x386A, 0x3E6A, 0x3E69,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3371,
	0x6648, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x444D, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E5F, 0xFFFE, 0x5263, 0x5264,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F27, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3374, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3377, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3372, 0xFFFE, 0x3373, 0x3375, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3376, 0xFFFE, 0xFFFE, 0x6649,
	0xFFFE, 0xFFFE, 0x3872, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x386E,
	0x3874, 0xFFFE, 0xFFFE, 0xFFFE, 0x386C, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x386B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3873, 0xFFFE, 0xFFFE, 0x386D, 0xFFFE, 0x386F, 0x3871, 0xFFFE,
	0xFFFE, 0x3870, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E70, 0x3E72, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3E6D, 0xFFFE, 0xFFFE, 0xFFFE, 0x3E6F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x444E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x444F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E60, 0xFFFE,
	0xFFFE, 0x4959, 0x4952, 0xFFFE, 0xFFFE, 0x4957, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4954, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4951
} };

static const iconv_ccs_convtable_8bit from_ucs_89 = { {
	0x4956, 0xFFFE, 0xFFFE, 0x4958, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E61,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4E62, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5265, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5640, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x563F,
	0x563D, 0xFFFE, 0xFFFE, 0x5642, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5879, 0xFFFE, 0x587A, 0xFFFE, 0xFFFE, 0x587C, 0x587B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x664A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D29, 0xFFFE, 0x5D28,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6149, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x617D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x664B, 0xFFFE, 0xFFFE, 0x5B2F,
	0xFFFE, 0x6046, 0x614A, 0xFFFE, 0x2F29, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3876, 0x3875, 0xFFFE, 0x3877, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3E74, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E65, 0xFFFE, 0x5266,
	0xFFFE, 0x4E64, 0xFFFE, 0x5646, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x587E, 0x587D, 0xFFFE, 0x5921, 0xFFFE, 0x5B31, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D2A, 0x5E61, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4454,
	0xFFFE, 0xFFFE, 0x495C, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E66, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B32, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8A = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F2A, 0x2F2C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x337B, 0xFFFE, 0x337A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x337C, 0xFFFE, 0xFFFE, 0x387E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3923, 0x3929, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3879, 0xFFFE,
	0x387B, 0x3925, 0xFFFE, 0x3922, 0xFFFE, 0xFFFE, 0x6330, 0xFFFE,
	0xFFFE, 0xFFFE, 0x387A, 0xFFFE, 0xFFFE, 0x3E7C, 0xFFFE, 0xFFFE,
	0x3E7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F24, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3E7E, 0x3E75, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3F21, 0xFFFE, 0x3F23, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3E78, 0xFFFE, 0xFFFE, 0x3F22, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4460, 0x4459, 0xFFFE, 0x4463,
	0xFFFE, 0xFFFE, 0x4455, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4458,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x445B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x445C, 0x4461, 0xFFFE,
	0x4456, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x445D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x495F, 0xFFFE,
	0x4964, 0xFFFE, 0xFFFE, 0xFFFE, 0x4963, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x495E, 0x4962, 0x496B, 0xFFFE, 0x4968,
	0xFFFE, 0xFFFE, 0x4960, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4965, 0xFFFE, 0xFFFE, 0x4966, 0xFFFE, 0xFFFE, 0x4E74,
	0xFFFE, 0x4E67, 0xFFFE, 0x4E72, 0x4E70, 0x4E6E, 0xFFFE, 0x4E6C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4E73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4E75, 0xFFFE, 0x4E69, 0xFFFE, 0x4E6A, 0xFFFE,
	0x4E76, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x526A, 0xFFFE, 0x526B, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4E6F, 0x5267, 0xFFFE, 0x526E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5269, 0xFFFE, 0xFFFE, 0xFFFE, 0x5268, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8B = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x664C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5649, 0xFFFE, 0xFFFE, 0x564A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5648,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x592A, 0xFFFE, 0xFFFE, 0xFFFE, 0x5926, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5924, 0xFFFE, 0x5928, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5923, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B34,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B35, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B36, 0x5D33, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5D30, 0x5D2C, 0xFFFE, 0x5D32, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5D2B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D2E, 0xFFFE,
	0xFFFE, 0x5C6D, 0xFFFE, 0x642D, 0xFFFE, 0x5E62, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E63, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F61, 0xFFFE, 0x5F62, 0xFFFE, 0xFFFE, 0xFFFE, 0x6048,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6047, 0xFFFE, 0xFFFE,
	0x6049, 0x607B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x614B,
	0xFFFE, 0xFFFE, 0xFFFE, 0x616B, 0xFFFE, 0x617E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8C = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x392A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x564D, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F64, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5D34, 0x664D, 0x6221, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x392D, 0xFFFE, 0xFFFE, 0x392C, 0xFFFE, 0xFFFE, 0x3F2A, 0xFFFE,
	0x3F29, 0xFFFE, 0xFFFE, 0x4464, 0xFFFE, 0xFFFE, 0xFFFE, 0x496D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x592B, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x392E, 0xFFFE, 0x3F2C, 0x3F2B,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3F2D, 0xFFFE, 0xFFFE, 0xFFFE, 0x634A,
	0x4465, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4E7A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x564F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x614D, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F2E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3930, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3932, 0x3931, 0xFFFE,
	0xFFFE, 0x3F2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4469, 0xFFFE, 0xFFFE, 0xFFFE, 0x4467, 0xFFFE, 0xFFFE,
	0x4970, 0xFFFE, 0xFFFE, 0xFFFE, 0x4972, 0xFFFE, 0x4971, 0xFFFE,
	0x664E, 0xFFFE, 0xFFFE, 0x4E7E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4E7D, 0xFFFE, 0x4F22, 0xFFFE, 0xFFFE, 0xFFFE, 0x5275,
	0xFFFE, 0xFFFE, 0x5273, 0xFFFE, 0xFFFE, 0xFFFE, 0x5651, 0x5652,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8D = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x592E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B38, 0x664F, 0xFFFE, 0x6428, 0xFFFE,
	0xFFFE, 0x5E65, 0x5E66, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6650, 0xFFFE, 0x604A, 0xFFFE, 0x614E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3933, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x243A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3939, 0xFFFE, 0x3937, 0xFFFE, 0x3935, 0x3938,
	0xFFFE, 0xFFFE, 0x3F39, 0x3F34, 0xFFFE, 0xFFFE, 0x3F37, 0x3F30,
	0x3F33, 0xFFFE, 0xFFFE, 0x3F38, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4975,
	0x4973, 0xFFFE, 0x4974, 0xFFFE, 0xFFFE, 0x4F26, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F25, 0xFFFE, 0x4F23, 0xFFFE, 0x5277, 0xFFFE,
	0xFFFE, 0x5931, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6651, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x393E, 0xFFFE, 0x393A, 0xFFFE, 0xFFFE,
	0x393D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3F3F, 0x3F3A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3F3B, 0xFFFE, 0x3F3E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x446B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8E = { {
	0xFFFE, 0x497B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x497A, 0xFFFE, 0xFFFE, 0x4979, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4F2C, 0xFFFE, 0x4F2B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x527E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x527B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x527C, 0xFFFE, 0xFFFE, 0x5654, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5655,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5932, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5B3A, 0xFFFE, 0xFFFE, 0x5B39, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5B3B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B3C, 0xFFFE, 0x5B3D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x604B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6150, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x616C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x393F, 0xFFFE, 0x3940,
	0x3F40, 0x4473, 0xFFFE, 0x497D, 0x497C, 0xFFFE, 0x4F30, 0x4F32,
	0x4F2F, 0x4F31, 0xFFFE, 0xFFFE, 0x6652, 0xFFFE, 0xFFFE, 0x5935,
	0xFFFE, 0x5936, 0xFFFE, 0x5B3F, 0xFFFE, 0xFFFE, 0x5D38, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6653, 0x3941, 0xFFFE,
	0xFFFE, 0x3947, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F45, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3F47, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3F44, 0x3F46, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F49, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_8F = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4476, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F36, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F33, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F35,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4F34, 0xFFFE, 0x5324, 0xFFFE, 0xFFFE,
	0x5322, 0x5321, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5325, 0x5659, 0xFFFE, 0xFFFE,
	0xFFFE, 0x565A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5937, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E67, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6222, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F4B, 0x4477, 0xFFFE,
	0x4478, 0x4A21, 0x4A22, 0xFFFE, 0x4F37, 0x5327, 0xFFFE, 0x5326,
	0xFFFE, 0xFFFE, 0x6654, 0xFFFE, 0x5938, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4F39, 0xFFFE, 0x272F, 0xFFFE, 0xFFFE,
	0xFFFE, 0x243B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2730, 0xFFFE,
	0xFFFE, 0x2733, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2731,
	0xFFFE, 0xFFFE, 0x2A72, 0xFFFE, 0x2A70, 0xFFFE, 0xFFFE, 0x2A74,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2A73, 0x2A71, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F31,
	0xFFFE, 0x2F32, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F33,
	0xFFFE, 0x2F30, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3425, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_90 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3427, 0x3426, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x394B, 0xFFFE,
	0xFFFE, 0xFFFE, 0x394A, 0x394E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x394C, 0xFFFE, 0xFFFE,
	0x3F4F, 0x3F50, 0x3F4D, 0x3F4C, 0x3F51, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3F55, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F56,
	0xFFFE, 0xFFFE, 0x3F54, 0x3F57, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x447D, 0xFFFE, 0xFFFE, 0x4479, 0xFFFE, 0x447C, 0x447A, 0xFFFE,
	0x447B, 0xFFFE, 0xFFFE, 0xFFFE, 0x447E, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4A24, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A27,
	0xFFFE, 0x4A26, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F3C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F3B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x593A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x225E, 0x225D, 0xFFFE, 0xFFFE, 0x243C, 0xFFFE,
	0xFFFE, 0xFFFE, 0x243D, 0xFFFE, 0x6655, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2735, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2739, 0x2734, 0xFFFE, 0x3951, 0xFFFE, 0x2A77, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A75,
	0xFFFE, 0x2A78, 0xFFFE, 0xFFFE, 0x2F35, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2F38, 0xFFFE, 0x2F34, 0xFFFE, 0x2F3E, 0xFFFE, 0x2F37, 0xFFFE,
	0xFFFE, 0x2F3C, 0xFFFE, 0xFFFE, 0xFFFE, 0x2F3B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3429, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x394F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x636C, 0x3952,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_91 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x3F59, 0xFFFE, 0x4523, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4524, 0xFFFE, 0x4525, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A2A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x532B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x593C, 0x593B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x342A, 0xFFFE, 0xFFFE, 0x3955, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3954, 0xFFFE, 0xFFFE, 0x6657, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4528,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4527, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A2C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4A2B, 0x4A2D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4F3F, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F40, 0xFFFE, 0x532D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x532C, 0x532F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x593D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5E68, 0xFFFE, 0xFFFE, 0xFFFE, 0x607E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x616D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3430, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x342D, 0xFFFE, 0xFFFE, 0x342F, 0x342E,
	0x3431, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3958, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3957, 0xFFFE, 0x3956, 0xFFFE, 0xFFFE, 0xFFFE, 0x3959, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F5D, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_92 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3F66, 0xFFFE, 0xFFFE, 0x3F60, 0xFFFE, 0xFFFE, 0x3F68, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x3F69, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3F62, 0xFFFE, 0xFFFE, 0x3F65, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3F5E, 0x6659, 0x3F63, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6658, 0xFFFE, 0xFFFE, 0xFFFE, 0x452E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x452B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4537, 0x452F, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4539, 0xFFFE, 0xFFFE, 0x4538, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x452A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x452D, 0xFFFE, 0xFFFE, 0x4531, 0x4529, 0xFFFE, 0x4534,
	0xFFFE, 0xFFFE, 0x4533, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4532, 0x4535, 0xFFFE, 0xFFFE, 0x4536, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x665A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4A34, 0xFFFE, 0xFFFE, 0x4A35, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4A2F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4530,
	0x4A38, 0xFFFE, 0x4A33, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A39, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A32, 0x4A37, 0xFFFE,
	0x672A, 0x4A31, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4F42, 0x4F50, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F43, 0x4F41,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F48, 0xFFFE, 0x4F49, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F4B, 0x4F4E, 0x4F44, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F51, 0xFFFE, 0xFFFE, 0x4F45, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4F52, 0xFFFE, 0x4F4C, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4F4D, 0x665B, 0x665C, 0x4A30, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5335, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_93 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0x533D, 0xFFFE, 0x533E, 0xFFFE, 0x5338,
	0xFFFE, 0xFFFE, 0x5332, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5336,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5337, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x533B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x533C, 0x5339, 0x533A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x665D,
	0xFFFE, 0xFFFE, 0x665E, 0xFFFE, 0xFFFE, 0x5331, 0xFFFE, 0xFFFE,
	0x5665, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5666, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x565D, 0xFFFE, 0x5667,
	0xFFFE, 0xFFFE, 0x5664, 0xFFFE, 0xFFFE, 0xFFFE, 0x565B, 0xFFFE,
	0x5668, 0x565E, 0xFFFE, 0x566B, 0xFFFE, 0xFFFE, 0x5661, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5662, 0x5663, 0x565F, 0xFFFE, 0xFFFE, 0xFFFE,
	0x565C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5660, 0xFFFE, 0x566A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x665F, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5943, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5940, 0xFFFE, 0xFFFE, 0x5942, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5949, 0xFFFE, 0xFFFE, 0xFFFE,
	0x593E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5944, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5946, 0xFFFE, 0xFFFE, 0x5945, 0x6661, 0x6662, 0x6660, 0xFFFE,
	0xFFFE, 0x5B50, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B44, 0x5B45, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B43, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B48, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B4D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5B4F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B4A, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5B41, 0x5B42, 0x5B4E, 0xFFFE, 0x5B47, 0xFFFE, 0x6665,
	0xFFFE, 0x6663, 0x6664, 0x5D41, 0x5E6A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_94 = { {
	0xFFFE, 0xFFFE, 0x5D43, 0xFFFE, 0x5D3C, 0x5D3F, 0xFFFE, 0xFFFE,
	0x5D3E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D3D,
	0xFFFE, 0xFFFE, 0x5D44, 0x5D45, 0x5D47, 0xFFFE, 0x5D42, 0x5D3A,
	0xFFFE, 0xFFFE, 0x6666, 0x6667, 0x6668, 0xFFFE, 0xFFFE, 0x5D46,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E6D, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5F69, 0x5F6E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F6A, 0x5F6C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F6B, 0xFFFE, 0x6052, 0xFFFE,
	0x6431, 0xFFFE, 0x6055, 0x6054, 0x6056, 0xFFFE, 0xFFFE, 0x604F,
	0xFFFE, 0x6053, 0xFFFE, 0xFFFE, 0xFFFE, 0x6057, 0x666A, 0x6669,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6122, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x616F, 0x6223, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6236, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_95 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6323, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x2F40, 0xFFFE, 0xFFFE, 0xFFFE, 0x3432, 0xFFFE, 0x395C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F6C, 0xFFFE, 0x666B,
	0xFFFE, 0x453C, 0x453A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4A3D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A3E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F53,
	0xFFFE, 0xFFFE, 0x4F55, 0x4F56, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5342, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5344, 0x5340, 0xFFFE, 0x566D, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x666C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x594B,
	0x594A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B53, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x666D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_96 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2143, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x273B, 0x273A,
	0xFFFE, 0x273F, 0xFFFE, 0x273C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x273D, 0x273E, 0xFFFE, 0xFFFE, 0x2A79,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2A7C, 0xFFFE,
	0xFFFE, 0x2A7B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3436, 0xFFFE,
	0xFFFE, 0x3434, 0x395E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x3433, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3961, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3965, 0xFFFE, 0x3F71, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F72,
	0xFFFE, 0x3F73, 0x3F75, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F70, 0xFFFE, 0xFFFE, 0x4540,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4542, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A45, 0xFFFE, 0x4A46,
	0x4A44, 0xFFFE, 0xFFFE, 0x4F5A, 0xFFFE, 0x4F5B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5348, 0xFFFE, 0x5670, 0xFFFE, 0x566F,
	0xFFFE, 0xFFFE, 0x5671, 0xFFFE, 0xFFFE, 0x5D49, 0x2A7D, 0x5349,
	0xFFFE, 0xFFFE, 0x6325, 0xFFFE, 0xFFFE, 0x3439, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4A47, 0x4A49, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E70, 0xFFFE, 0x6125, 0x622F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x3F7E, 0x3F7C, 0x3F7B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4546, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4547, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_97 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F60, 0xFFFE, 0x5350, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x534D, 0x534C, 0xFFFE, 0x5351,
	0xFFFE, 0xFFFE, 0x5674, 0x5675, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5D4F, 0xFFFE, 0x5D4C, 0x5D4E, 0xFFFE, 0x5E72, 0x5E71,
	0xFFFE, 0xFFFE, 0xFFFE, 0x666E, 0x5F71, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5F72, 0x6059, 0xFFFE, 0xFFFE, 0xFFFE, 0x6126, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x666F, 0xFFFE, 0xFFFE,
	0x6245, 0x2A7E, 0xFFFE, 0xFFFE, 0xFFFE, 0x4549, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4A4C, 0xFFFE, 0xFFFE, 0xFFFE, 0x594F, 0xFFFE, 0x4021,
	0xFFFE, 0xFFFE, 0xFFFE, 0x2B21, 0x4A4E, 0xFFFE, 0xFFFE, 0x5E73,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4024, 0xFFFE, 0x4022,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x454B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F62,
	0xFFFE, 0x4F63, 0xFFFE, 0xFFFE, 0x4F64, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5353, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x567A, 0xFFFE, 0xFFFE, 0xFFFE, 0x567B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5950, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5B5F, 0x5B5D, 0xFFFE, 0x5B5E, 0x5B60, 0xFFFE, 0xFFFE,
	0x5D50, 0xFFFE, 0x5D51, 0xFFFE, 0xFFFE, 0x5E75, 0x5E74, 0xFFFE,
	0x5F73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6128, 0xFFFE, 0x623B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5355, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5951, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5E76, 0xFFFE, 0x6129, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x454F, 0x4F65,
	0xFFFE, 0xFFFE, 0x5B61, 0xFFFE, 0xFFFE, 0x4550, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D53, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_98 = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4552, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A54, 0x4A55, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4A52, 0x4A56, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F69,
	0xFFFE, 0xFFFE, 0x4F67, 0x636E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F66, 0xFFFE, 0xFFFE, 0xFFFE, 0x535C, 0xFFFE,
	0xFFFE, 0x5359, 0xFFFE, 0x535A, 0x5228, 0xFFFE, 0x5358, 0xFFFE,
	0xFFFE, 0xFFFE, 0x535D, 0xFFFE, 0x535B, 0x535F, 0xFFFE, 0x595B,
	0x5726, 0xFFFE, 0x637B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5728,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5959, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5956, 0x5958, 0x5B65, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x642A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E78, 0xFFFE,
	0x5E77, 0xFFFE, 0xFFFE, 0xFFFE, 0x605D, 0x605E, 0x605C, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5361, 0xFFFE, 0x572A,
	0xFFFE, 0x595C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D56, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E7B,
	0x5E79, 0xFFFE, 0x5E7A, 0xFFFE, 0xFFFE, 0x6225, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E7C, 0x6226, 0xFFFE, 0xFFFE,
	0xFFFE, 0x3967, 0xFFFE, 0xFFFE, 0x6670, 0xFFFE, 0x3968, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x455B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x402B, 0x455C, 0xFFFE, 0x4554, 0xFFFE, 0x4559, 0xFFFE, 0x4557,
	0x4A5D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4558
} };

static const iconv_ccs_convtable_8bit from_ucs_99 = { {
	0xFFFE, 0x4A5E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A5B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x667A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F6B, 0xFFFE, 0xFFFE, 0x5365, 0x5366, 0xFFFE, 0xFFFE,
	0x5364, 0xFFFE, 0x5362, 0x5363, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5962, 0xFFFE,
	0x5961, 0x5966, 0xFFFE, 0x5965, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5963, 0xFFFE, 0x6671, 0xFFFE, 0x5B69, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D58, 0xFFFE, 0x5E7E,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5F78, 0xFFFE, 0xFFFE, 0x612A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x455F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5368, 0xFFFE, 0x5730, 0xFFFE, 0x5967, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F21, 0x6060, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A63, 0x4A62,
	0x4A66, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A61, 0xFFFE, 0x4A60, 0x4A6C,
	0x4A64, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A6A, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4F73, 0xFFFE, 0x4F6D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F6E, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F72, 0xFFFE,
	0x4F74, 0x5370, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5371, 0xFFFE,
	0x536B, 0xFFFE, 0xFFFE, 0x536C, 0xFFFE, 0xFFFE, 0xFFFE, 0x536A,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5734, 0xFFFE, 0x5737, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9A = { {
	0x5733, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x596A, 0xFFFE, 0xFFFE, 0xFFFE, 0x596B, 0xFFFE, 0xFFFE, 0xFFFE,
	0x596D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B6F,
	0x5B6D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B6C,
	0xFFFE, 0x5B6E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B6B, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D5A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5F24, 0x5F22, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F79, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6062, 0xFFFE, 0xFFFE, 0xFFFE, 0x6061, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6172, 0xFFFE, 0x6173, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x402F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F77, 0x4F76, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x573A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D61, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D60, 0x5D5E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F25, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6174,
	0xFFFE, 0x6334, 0x4A6E, 0xFFFE, 0xFFFE, 0x5F7B, 0x6063, 0xFFFE,
	0x4032, 0xFFFE, 0x4561, 0xFFFE, 0x4A6F, 0x4A73, 0xFFFE, 0xFFFE,
	0x4A71, 0x4A70, 0x4A72, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4F79, 0x5375, 0xFFFE, 0xFFFE,
	0x5374, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9B = { {
	0x573B, 0xFFFE, 0x573C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x596F,
	0xFFFE, 0x5B71, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F27, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6672, 0xFFFE, 0xFFFE,
	0xFFFE, 0x612C, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4A75, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5D62, 0xFFFE, 0x612E, 0x6433, 0xFFFE, 0xFFFE,
	0x6228, 0xFFFE, 0xFFFE, 0xFFFE, 0x573E, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D63, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4562, 0xFFFE, 0xFFFE,
	0x4A78, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x573F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D64, 0xFFFE, 0xFFFE, 0x5F28, 0xFFFE, 0xFFFE, 0xFFFE, 0x612F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4563, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x4F7E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4F7C, 0xFFFE, 0x4F7B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x4F7D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5378, 0x537A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5423, 0xFFFE, 0x537C, 0x5421, 0xFFFE, 0x5425, 0x537D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5379, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6673, 0x5744, 0xFFFE, 0xFFFE, 0xFFFE, 0x5745, 0xFFFE, 0x5740,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5742, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5974, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5973, 0xFFFE, 0xFFFE, 0x5B74, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5976, 0x5975, 0x5743, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5971, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B75,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5B77, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5B79, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5B7A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D6F, 0xFFFE,
	0xFFFE, 0x5D71, 0xFFFE, 0x5D67, 0x5D69, 0xFFFE, 0x5D6A, 0x5D74
} };

static const iconv_ccs_convtable_8bit from_ucs_9C = { {
	0x5D75, 0xFFFE, 0x5D6E, 0xFFFE, 0x5D68, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5D66, 0xFFFE, 0x5D76, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5D73, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D72, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5D70, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F2C,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x642F,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F2A, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6025, 0xFFFE, 0xFFFE,
	0x5F7E, 0xFFFE, 0x6023, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6022, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6065,
	0xFFFE, 0x6066, 0xFFFE, 0x6068, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6132, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6133, 0xFFFE, 0xFFFE, 0xFFFE, 0x6134, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6159, 0xFFFE, 0xFFFE, 0x615B,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6175, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x6241, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x4564, 0xFFFE, 0xFFFE, 0x4566, 0x2F42, 0xFFFE, 0x4568, 0x4567,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5027, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x502A, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9D = { {
	0xFFFE, 0x5024, 0x502B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x542D, 0xFFFE, 0x5025, 0x5022, 0xFFFE, 0x542A,
	0xFFFE, 0xFFFE, 0xFFFE, 0x542C, 0xFFFE, 0xFFFE, 0x5436, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5433, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5437, 0xFFFE, 0xFFFE, 0x5429, 0xFFFE, 0xFFFE, 0x5435,
	0xFFFE, 0xFFFE, 0x5432, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x574D, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5748, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x574A, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6675, 0xFFFE, 0xFFFE, 0xFFFE, 0x5979, 0x597B, 0xFFFE,
	0x597D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x597E, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A22, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x597A, 0xFFFE, 0xFFFE, 0x5B7D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C27, 0x5C22, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C25, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5B7E, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C26, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5C24, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5C23, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D79, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5D7A, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F35, 0xFFFE,
	0x5F31, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F32, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F36, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x606C, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9E = { {
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x6135, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x615D, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6229, 0xFFFE,
	0x6230, 0xFFFE, 0xFFFE, 0xFFFE, 0x6238, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5F37, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x4569, 0xFFFE, 0xFFFE, 0x502C, 0x5439, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x5A24, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5C29, 0xFFFE, 0xFFFE,
	0x5E21, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5F3A, 0xFFFE,
	0xFFFE, 0xFFFE, 0x6231, 0x623F, 0xFFFE, 0xFFFE, 0x2547, 0xFFFE,
	0xFFFE, 0xFFFE, 0x502F, 0x502E, 0x543A, 0xFFFE, 0xFFFE, 0x5750,
	0xFFFE, 0x5A26, 0x5A25, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x4B22, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5E22, 0xFFFE, 0xFFFE, 0x396A, 0x543C, 0x543B, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5A28, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x396B, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x543D,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x5C2A, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x6029, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x2772, 0xFFFE
} };

static const iconv_ccs_convtable_8bit from_ucs_9F = { {
	0xFFFE, 0xFFFE, 0x5A29, 0x5C2D, 0x5C2E, 0x5F3C, 0xFFFE, 0xFFFE,
	0x615F, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x456A, 0xFFFE, 0xFFFE, 0x5C30,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6160, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5A2B, 0x5A2A,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x606D, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x613B, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0x2370, 0xFFFE, 0xFFFE, 0x543E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0x5E24, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F3E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x6233, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5755, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0x602B, 0xFFFE, 0xFFFE, 0xFFFE, 0x6242,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0x5E47, 0xFFFE, 0xFFFE,
	0xFFFE, 0x5F3F, 0xFFFE, 0x6161, 0xFFFE, 0x6177, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
} };

static const iconv_ccs_convtable_16bit from_ucs = { {
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, &from_ucs_4E, &from_ucs_4F,
	&from_ucs_50, &from_ucs_51, &from_ucs_52, &from_ucs_53, &from_ucs_54, &from_ucs_55, &from_ucs_56, &from_ucs_57,
	&from_ucs_58, &from_ucs_59, &from_ucs_5A, &from_ucs_5B, &from_ucs_5C, &from_ucs_5D, &from_ucs_5E, &from_ucs_5F,
	&from_ucs_60, &from_ucs_61, &from_ucs_62, &from_ucs_63, &from_ucs_64, &from_ucs_65, &from_ucs_66, &from_ucs_67,
	&from_ucs_68, &from_ucs_69, &from_ucs_6A, &from_ucs_6B, &from_ucs_6C, &from_ucs_6D, &from_ucs_6E, &from_ucs_6F,
	&from_ucs_70, &from_ucs_71, &from_ucs_72, &from_ucs_73, &from_ucs_74, &from_ucs_75, &from_ucs_76, &from_ucs_77,
	&from_ucs_78, &from_ucs_79, &from_ucs_7A, &from_ucs_7B, &from_ucs_7C, &from_ucs_7D, &from_ucs_7E, &from_ucs_7F,
	&from_ucs_80, &from_ucs_81, &from_ucs_82, &from_ucs_83, &from_ucs_84, &from_ucs_85, &from_ucs_86, &from_ucs_87,
	&from_ucs_88, &from_ucs_89, &from_ucs_8A, &from_ucs_8B, &from_ucs_8C, &from_ucs_8D, &from_ucs_8E, &from_ucs_8F,
	&from_ucs_90, &from_ucs_91, &from_ucs_92, &from_ucs_93, &from_ucs_94, &from_ucs_95, &from_ucs_96, &from_ucs_97,
	&from_ucs_98, &from_ucs_99, &from_ucs_9A, &from_ucs_9B, &from_ucs_9C, &from_ucs_9D, &from_ucs_9E, &from_ucs_9F,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
} };

#define NBITS 14

static ucs2_t convert_from_ucs(ucs2_t ch)
{
	return iconv_ccs_convert_16bit((const iconv_ccs_convtable *)&from_ucs, ch);
}

static ucs2_t convert_to_ucs(ucs2_t ch)
{
	return iconv_ccs_convert_14bit((const iconv_ccs_convtable *)&to_ucs, ch);
}

static const char * const names[] = {
	"cns11643-plane14", NULL
};

static const struct iconv_ccs_desc iconv_ccs_desc = {
	names, NBITS,
	(const iconv_ccs_convtable *)&from_ucs,
	(const iconv_ccs_convtable *)&to_ucs,
	convert_from_ucs, convert_to_ucs,
};

struct iconv_module_desc iconv_module = {
	ICMOD_UC_CCS,
	apr_iconv_mod_noevent,
	NULL,
	&iconv_ccs_desc
};
