/* GENERATED CODE -- DO NOT EDIT                     -*- C -*-
 * Use the following command to regenerate this file:
 *     awk -f ../build/gen_aliases.awk \
 *            ../ccs/charset.aliases \
 *            ../ces/charset.aliases > charset_alias.h
 */
#ifndef API_HAVE_CHARSET_ALIAS_TABLE
#define API_HAVE_CHARSET_ALIAS_TABLE

#include <stdlib.h>
#include <string.h>

/* This is a sorted table of alias -> true name mappings. */
static struct charset_alias {
    const char *name;
    const char *target;
} const charset_alias_list[] = {
    {"424", "cp424"},
    {"437", "cp437"},
    {"850", "cp850"},
    {"851", "cp851"},
    {"852", "cp852"},
    {"855", "cp855"},
    {"857", "cp857"},
    {"860", "cp860"},
    {"861", "cp861"},
    {"862", "cp862"},
    {"863", "cp863"},
    {"865", "cp865"},
    {"866", "cp866"},
    {"869", "cp869"},
    {"904", "cp904"},
    {"ansi_x3.110-1983", "iso-ir-99"},
    {"ansi_x3.4-1968", "us-ascii"},
    {"ansi_x3.4-1986", "us-ascii"},
    {"arabic", "iso-8859-6"},
    {"arabic7", "iso-ir-89"},
    {"ascii", "us-ascii"},
    {"asmo-708", "iso-8859-6"},
    {"asmo_449", "iso-ir-89"},
    {"bs_4730", "iso-ir-4"},
    {"bs_viewdata", "iso-ir-47"},
    {"ca", "iso-ir-121"},
    {"chinese", "gb_2312-80"},
    {"cp-ar", "cp868"},
    {"cp-gr", "cp869"},
    {"cp-is", "cp861"},
    {"cp037_ibmuscanada", "cp037"},
    {"cp10000_macroman", "cp10000"},
    {"cp10006_macgreek", "cp10006"},
    {"cp10007_maccyrillic", "cp10007"},
    {"cp10029_maclatin2", "cp10029"},
    {"cp10079_macicelandic", "cp10079"},
    {"cp10081_macturkish", "cp10081"},
    {"cp1250", "windows-1250"},
    {"cp1251", "windows-1251"},
    {"cp1252", "windows-1252"},
    {"cp1253", "windows-1253"},
    {"cp1254", "windows-1254"},
    {"cp1255", "windows-1255"},
    {"cp1256", "windows-1256"},
    {"cp1257", "windows-1257"},
    {"cp1258", "windows-1258"},
    {"cp367", "us-ascii"},
    {"cp737latingreek", "cp737"},
    {"cp819", "iso-8859-1"},
    {"cp856_hebrew_pc", "cp856"},
    {"cp875_ibmgreek", "cp875"},
    {"csa7-1", "iso-ir-121"},
    {"csa7-2", "iso-ir-122"},
    {"csa_t500-1983", "iso-ir-99"},
    {"csa_z243.4-1985-1", "iso-ir-121"},
    {"csa_z243.4-1985-2", "iso-ir-122"},
    {"csa_z243.4-1985-gr", "iso-ir-123"},
    {"csascii", "us-ascii"},
    {"csbig5", "big5"},
    {"cshalfwidthkatakana", "jis_x0201"},
    {"csibm1026", "cp1026"},
    {"csibm424", "cp424"},
    {"csibm500", "cp500"},
    {"csibm855", "cp855"},
    {"csibm857", "cp857"},
    {"csibm860", "cp860"},
    {"csibm861", "cp861"},
    {"csibm863", "cp863"},
    {"csibm864", "cp864"},
    {"csibm865", "cp865"},
    {"csibm866", "cp866"},
    {"csibm869", "cp869"},
    {"csiso2022jp", "iso-2022-jp"},
    {"csiso2022jp2", "iso-2022-jp-2"},
    {"csisolatin1", "iso-8859-1"},
    {"csisolatin2", "iso-8859-2"},
    {"csisolatin3", "iso-8859-3"},
    {"csisolatin4", "iso-8859-4"},
    {"csisolatin5", "iso-8859-9"},
    {"csisolatin6", "iso-8859-10"},
    {"csisolatinarabic", "iso-8859-6"},
    {"csisolatincyrillic", "iso-8859-5"},
    {"csisolatingreek", "iso-8859-7"},
    {"csisolatinhebrew", "iso-8859-8"},
    {"cskoi8r", "koi8-r"},
    {"csn_369103", "iso-ir-139"},
    {"cspc775baltic", "cp775"},
    {"cspc850multilingual", "cp850"},
    {"cspc862latinhebrew", "cp862"},
    {"cspc8codepage437", "cp437"},
    {"cspcp852", "cp852"},
    {"csshiftjis", "shift_jis"},
    {"cuba", "iso-ir-151"},
    {"cyrillic", "iso-8859-5"},
    {"de", "iso-ir-21"},
    {"dec", "dec-mcs"},
    {"din_66003", "iso-ir-21"},
    {"dk", "iso646-dk"},
    {"ds2089", "iso646-dk"},
    {"ds_2089", "iso646-dk"},
    {"e13b", "iso-ir-98"},
    {"ebcdic-be", "cp274"},
    {"ebcdic-br", "cp275"},
    {"ebcdic-cp-ar1", "cp420"},
    {"ebcdic-cp-ar2", "cp918"},
    {"ebcdic-cp-be", "cp500"},
    {"ebcdic-cp-ca", "cp037"},
    {"ebcdic-cp-ch", "cp500"},
    {"ebcdic-cp-dk", "cp277"},
    {"ebcdic-cp-es", "cp284"},
    {"ebcdic-cp-fi", "cp278"},
    {"ebcdic-cp-fr", "cp297"},
    {"ebcdic-cp-gb", "cp285"},
    {"ebcdic-cp-gr", "cp423"},
    {"ebcdic-cp-he", "cp424"},
    {"ebcdic-cp-is", "cp871"},
    {"ebcdic-cp-it", "cp280"},
    {"ebcdic-cp-nl", "cp037"},
    {"ebcdic-cp-no", "cp277"},
    {"ebcdic-cp-roece", "cp870"},
    {"ebcdic-cp-se", "cp278"},
    {"ebcdic-cp-tr", "cp905"},
    {"ebcdic-cp-us", "cp037"},
    {"ebcdic-cp-wt", "cp037"},
    {"ebcdic-cp-yu", "cp870"},
    {"ebcdic-cyrillic", "cp880"},
    {"ebcdic-int", "cp038"},
    {"ebcdic-jp-e", "cp281"},
    {"ebcdic-jp-kana", "cp290"},
    {"ecma-114", "iso-8859-6"},
    {"ecma-118", "iso-8859-7"},
    {"ecma-cyrillic", "iso-ir-111"},
    {"elot_928", "iso-8859-7"},
    {"es", "iso-ir-17"},
    {"es2", "iso-ir-85"},
    {"fi", "iso-ir-10"},
    {"fr", "iso-ir-69"},
    {"gb", "iso-ir-4"},
    {"gb_1988-80", "iso-ir-57"},
    {"gost_19768-74", "iso-ir-153"},
    {"greek", "iso-8859-7"},
    {"greek-ccitt", "iso-ir-150"},
    {"greek7", "iso-ir-88"},
    {"greek7-old", "iso-ir-18"},
    {"greek8", "iso-8859-7"},
    {"hebrew", "iso-8859-8"},
    {"hu", "iso-ir-86"},
    {"ibm037", "cp037"},
    {"ibm038", "cp038"},
    {"ibm1026", "cp1026"},
    {"ibm273", "cp273"},
    {"ibm274", "cp274"},
    {"ibm275", "cp275"},
    {"ibm277", "cp277"},
    {"ibm278", "cp278"},
    {"ibm280", "cp280"},
    {"ibm281", "cp281"},
    {"ibm284", "cp284"},
    {"ibm285", "cp285"},
    {"ibm290", "cp290"},
    {"ibm297", "cp297"},
    {"ibm367", "us-ascii"},
    {"ibm420", "cp420"},
    {"ibm423", "cp423"},
    {"ibm424", "cp424"},
    {"ibm437", "cp437"},
    {"ibm500", "cp500"},
    {"ibm737", "cp737"},
    {"ibm775", "cp775"},
    {"ibm819", "iso-8859-1"},
    {"ibm850", "cp850"},
    {"ibm851", "cp851"},
    {"ibm852", "cp852"},
    {"ibm855", "cp855"},
    {"ibm857", "cp857"},
    {"ibm860", "cp860"},
    {"ibm861", "cp861"},
    {"ibm862", "cp862"},
    {"ibm863", "cp863"},
    {"ibm864", "cp864"},
    {"ibm865", "cp865"},
    {"ibm866", "cp866"},
    {"ibm868", "cp868"},
    {"ibm869", "cp869"},
    {"ibm870", "cp870"},
    {"ibm871", "cp871"},
    {"ibm874", "cp874"},
    {"ibm880", "cp880"},
    {"ibm891", "cp891"},
    {"ibm903", "cp903"},
    {"ibm904", "cp904"},
    {"ibm905", "cp905"},
    {"ibm918", "cp918"},
    {"iec_p27-1", "iso-ir-143"},
    {"inis", "iso-ir-49"},
    {"inis-8", "iso-ir-50"},
    {"inis-cyrillic", "iso-ir-51"},
    {"irv", "iso-ir-2"},
    {"iso-ir-100", "iso-8859-1"},
    {"iso-ir-101", "iso-8859-2"},
    {"iso-ir-109", "iso-8859-3"},
    {"iso-ir-110", "iso-8859-4"},
    {"iso-ir-126", "iso-8859-7"},
    {"iso-ir-127", "iso-8859-6"},
    {"iso-ir-138", "iso-8859-8"},
    {"iso-ir-144", "iso-8859-5"},
    {"iso-ir-148", "iso-8859-9"},
    {"iso-ir-157", "iso-8859-10"},
    {"iso-ir-58", "gb_2312-80"},
    {"iso-ir-87", "jis_x0208-1983"},
    {"iso646-ca", "iso-ir-121"},
    {"iso646-ca2", "iso-ir-122"},
    {"iso646-cu", "iso-ir-151"},
    {"iso646-de", "iso-ir-21"},
    {"iso646-es", "iso-ir-17"},
    {"iso646-es2", "iso-ir-85"},
    {"iso646-fi", "iso-ir-10"},
    {"iso646-fr", "iso-ir-69"},
    {"iso646-fr1", "iso-ir-25"},
    {"iso646-gb", "iso-ir-4"},
    {"iso646-hu", "iso-ir-86"},
    {"iso646-it", "iso-ir-15"},
    {"iso646-jp", "iso-ir-14"},
    {"iso646-jp-ocr-a", "iso-ir-91"},
    {"iso646-jp-ocr-b", "iso-ir-92"},
    {"iso646-no", "iso-ir-60"},
    {"iso646-no2", "iso-ir-61"},
    {"iso646-pt", "iso-ir-16"},
    {"iso646-pt2", "iso-ir-84"},
    {"iso646-se", "iso-ir-10"},
    {"iso646-se2", "iso-ir-11"},
    {"iso646-us", "us-ascii"},
    {"iso646-yu", "iso-ir-141"},
    {"iso_10367-box", "iso-ir-155"},
    {"iso_2033-1983", "iso-ir-98"},
    {"iso_5427", "iso-ir-37"},
    {"iso_5427:1981", "iso-ir-54"},
    {"iso_5428:1980", "iso-ir-55"},
    {"iso_646.irv:1983", "iso-ir-2"},
    {"iso_646.irv:1991", "us-ascii"},
    {"iso_6937-2-25", "iso-ir-152"},
    {"iso_6937-2-add", "iso-ir-142"},
    {"iso_8859-1", "iso-8859-1"},
    {"iso_8859-10", "iso-8859-10"},
    {"iso_8859-10:1992", "iso-8859-10"},
    {"iso_8859-13", "iso-8859-13"},
    {"iso_8859-13:1998", "iso-8859-13"},
    {"iso_8859-14", "iso-8859-14"},
    {"iso_8859-14:1998", "iso-8859-14"},
    {"iso_8859-15", "iso-8859-15"},
    {"iso_8859-15:1998", "iso-8859-15"},
    {"iso_8859-1:1987", "iso-8859-1"},
    {"iso_8859-2", "iso-8859-2"},
    {"iso_8859-2:1987", "iso-8859-2"},
    {"iso_8859-3", "iso-8859-3"},
    {"iso_8859-3:1988", "iso-8859-3"},
    {"iso_8859-4", "iso-8859-4"},
    {"iso_8859-4:1988", "iso-8859-4"},
    {"iso_8859-5", "iso-8859-5"},
    {"iso_8859-5:1988", "iso-8859-5"},
    {"iso_8859-6", "iso-8859-6"},
    {"iso_8859-6:1987", "iso-8859-6"},
    {"iso_8859-7", "iso-8859-7"},
    {"iso_8859-7:1987", "iso-8859-7"},
    {"iso_8859-8", "iso-8859-8"},
    {"iso_8859-8:1988", "iso-8859-8"},
    {"iso_8859-9", "iso-8859-9"},
    {"iso_8859-9:1989", "iso-8859-9"},
    {"iso_8859-supp", "iso-ir-154"},
    {"iso_9036", "iso-ir-89"},
    {"it", "iso-ir-15"},
    {"jis_c6220-1969", "iso-ir-13"},
    {"jis_c6220-1969-jp", "iso-ir-13"},
    {"jis_c6220-1969-ro", "iso-ir-14"},
    {"jis_c6226-1983", "jis_x0208-1983"},
    {"jis_c6229-1984-a", "iso-ir-91"},
    {"jis_c6229-1984-b", "iso-ir-92"},
    {"jis_c6229-1984-b-add", "iso-ir-93"},
    {"jis_c6229-1984-hand", "iso-ir-94"},
    {"jis_c6229-1984-hand-add", "iso-ir-95"},
    {"jis_c6229-1984-kana", "iso-ir-96"},
    {"jp", "iso-ir-14"},
    {"jp-ocr-a", "iso-ir-91"},
    {"jp-ocr-b", "iso-ir-92"},
    {"jp-ocr-b-add", "iso-ir-93"},
    {"jp-ocr-hand", "iso-ir-94"},
    {"jp-ocr-hand-add", "iso-ir-95"},
    {"js", "iso-ir-141"},
    {"jus_i.b1.002", "iso-ir-141"},
    {"jus_i.b1.003-mac", "iso-ir-147"},
    {"jus_i.b1.003-serb", "iso-ir-146"},
    {"katakana", "iso-ir-13"},
    {"ks_x_1001", "ksx1001"},
    {"ksc5636", "iso646-kr"},
    {"l1", "iso-8859-1"},
    {"l2", "iso-8859-2"},
    {"l3", "iso-8859-3"},
    {"l4", "iso-8859-4"},
    {"l5", "iso-8859-9"},
    {"l6", "iso-8859-10"},
    {"lap", "iso-ir-158"},
    {"latin-greek", "iso-ir-19"},
    {"latin-greek-1", "iso-ir-27"},
    {"latin-lap", "iso-ir-158"},
    {"latin1", "iso-8859-1"},
    {"latin1-2-5", "iso-ir-154"},
    {"latin2", "iso-8859-2"},
    {"latin3", "iso-8859-3"},
    {"latin4", "iso-8859-4"},
    {"latin5", "iso-8859-9"},
    {"latin6", "iso-8859-10"},
    {"mac", "macintosh"},
    {"maccenteuro", "mac-ce"},
    {"maccroatian", "mac-croatian"},
    {"maccyrillic", "mac-cyrillic"},
    {"macdingbats", "mac-dingbats"},
    {"macedonian", "iso-ir-147"},
    {"macgreek", "mac-greek"},
    {"maciceland", "mac-iceland"},
    {"macroman", "mac-roman"},
    {"macromania", "mac-romania"},
    {"macthai", "mac-thai"},
    {"macturkish", "mac-turkish"},
    {"macukraine", "mac-ukraine"},
    {"ms_kanji", "shift_jis"},
    {"msz_7795.3", "iso-ir-86"},
    {"naplps", "iso-ir-99"},
    {"nats-dano", "iso-ir-9-1"},
    {"nats-dano-add", "iso-ir-9-2"},
    {"nats-sefi", "iso-ir-8-1"},
    {"nats-sefi-add", "iso-ir-8-2"},
    {"nc_nc00-10:81", "iso-ir-151"},
    {"nf_z_62-010", "iso-ir-69"},
    {"nf_z_62-010_(1973)", "iso-ir-25"},
    {"no", "iso-ir-60"},
    {"no2", "iso-ir-61"},
    {"ns_4551-1", "iso-ir-60"},
    {"ns_4551-2", "iso-ir-61"},
    {"pt", "iso-ir-16"},
    {"pt2", "iso-ir-84"},
    {"r8", "hp-roman8"},
    {"roman8", "hp-roman8"},
    {"se", "iso-ir-10"},
    {"se2", "iso-ir-11"},
    {"sen_850200_b", "iso-ir-10"},
    {"sen_850200_c", "iso-ir-11"},
    {"serbian", "iso-ir-146"},
    {"st_sev_358-88", "iso-ir-153"},
    {"t.101-g2", "iso-ir-128"},
    {"t.61", "iso-ir-103"},
    {"t.61-7bit", "iso-ir-102"},
    {"t.61-8bit", "iso-ir-103"},
    {"uk", "iso-ir-4"},
    {"us", "us-ascii"},
    {"utf-7", "unicode-1-1-utf-7"},
    {"videotex-suppl", "iso-ir-70"},
    {"x0201", "jis_x0201"},
    {"x0201-7", "iso-ir-13"},
    {"x0208", "jis_x0208-1983"},
    {"yu", "iso-ir-141"},
    {NULL, NULL} };

static const size_t charset_alias_count =
    sizeof(charset_alias_list)/sizeof(charset_alias_list[0]) - 1;

/* Compare two aliases. */
static int charset_alias_compare (const void *u, const void *v)
{
    const struct charset_alias *const a = u;
    const struct charset_alias *const b = v;
    return strcmp(a->name, b->name);
}

/* Look up an alias in the sorted table and return its name,
   or NULL if it's not in the table. */
static const char *charset_alias_find (const char *name)
{
    struct charset_alias key;
    struct charset_alias *alias;
    key.name = name;
    alias = bsearch(&key, charset_alias_list, charset_alias_count,
                    sizeof(charset_alias_list[0]),
                    charset_alias_compare);
    if (alias)
        return alias->target;
    else
        return NULL;
}

#endif /* API_HAVE_CHARSET_ALIAS_TABLE */
