# Copyright 2000-2004 The Apache Software Foundation
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
#

#
# rules.mk: standard rules for APR
#



#
# Configuration variables
#
apr_builddir=/home/aaron/downloads/httpd-2.0.50/srclib/apr
apr_builders=/home/aaron/downloads/httpd-2.0.50/srclib/apr/build

# Some layouts require knowing what version we are at.
APR_MAJOR_VERSION=0
APR_DOTTED_VERSION=0.9.5

CC=gcc
RM=rm
AWK=gawk
SHELL=/bin/bash
LIBTOOL=$(SHELL) $(apr_builddir)/libtool

# compilation and linking flags that are supposed to be set only by the user.
# configure adds to them for tests, but we restore them at the end.
#
CFLAGS=
CPPFLAGS=
LDFLAGS=
LIBS=
DEFS=-DHAVE_CONFIG_H

# anything added to the standard flags by configure is moved to EXTRA_*
# at the end of the process.
#
EXTRA_CFLAGS=-g -O2
EXTRA_CPPFLAGS=-DSOLARIS2=9 -D_POSIX_PTHREAD_SEMANTICS -D_REENTRANT
EXTRA_LDFLAGS=
EXTRA_LIBS=-lsendfile -lrt -lm -lsocket -lnsl -lresolv  -lpthread -ldl
EXTRA_INCLUDES=

# NOTEST_* are flags and libraries that can be added by the user without
# causing them to be used in configure tests (necessary for things like
# -Werror and other strict warnings that maintainers like to use).
#
NOTEST_CFLAGS=
NOTEST_CPPFLAGS=
NOTEST_LDFLAGS=
NOTEST_LIBS=

# Finally, combine all of the flags together in the proper order so that
# the user-defined flags can always override the configure ones, if needed.
# Note that includes are listed after the flags because -I options have
# left-to-right precedence and CPPFLAGS may include user-defined overrides.
#
ALL_CFLAGS   = $(EXTRA_CFLAGS) $(NOTEST_CFLAGS) $(CFLAGS)
ALL_CPPFLAGS = $(DEFS) $(EXTRA_CPPFLAGS) $(NOTEST_CPPFLAGS) $(CPPFLAGS)
ALL_LDFLAGS  = $(EXTRA_LDFLAGS) $(NOTEST_LDFLAGS) $(LDFLAGS)
ALL_LIBS     = $(LIBS) $(NOTEST_LIBS) $(EXTRA_LIBS)
ALL_INCLUDES = $(INCLUDES) $(EXTRA_INCLUDES)

LTFLAGS      = --silent
LT_LDFLAGS   = 

#
# Basic macro setup
#
COMPILE      = $(CC) $(ALL_CFLAGS) $(ALL_CPPFLAGS) $(ALL_INCLUDES)
LT_COMPILE   = $(LIBTOOL) $(LTFLAGS) --mode=compile $(COMPILE) -c $< && touch $@

LINK         = $(LIBTOOL) $(LTFLAGS) --mode=link $(LT_LDFLAGS) $(COMPILE) -version-info 9:5:9 $(ALL_LDFLAGS) -o $@

MKEXPORT     = $(AWK) -f $(apr_builders)/make_export.awk
MKDEP        = $(CC) -MM

#
# Standard build rules
#
all: all-recursive
depend: depend-recursive
clean: clean-recursive
distclean: distclean-recursive
extraclean: extraclean-recursive

install: all-recursive


all-recursive depend-recursive:
	@otarget=`echo $@ | sed s/-recursive//`; \
	list='$(SUBDIRS)'; \
	for i in $$list; do \
	    if test -d "$$i"; then \
		target="$$otarget"; \
		echo "Making $$target in $$i"; \
		if test "$$i" = "."; then \
		    made_local=yes; \
		    target="local-$$target"; \
		fi; \
		(cd $$i && $(MAKE) $$target) || exit 1; \
	    fi; \
	done; \
        if test "$$otarget" = "all" && test -z "$(TARGETS)"; then \
	    made_local=yes; \
	fi; \
	if test "$$made_local" != "yes"; then \
	    $(MAKE) "local-$$otarget" || exit 1; \
	fi

clean-recursive distclean-recursive extraclean-recursive:
	@otarget=`echo $@ | sed s/-recursive//`; \
	list='$(SUBDIRS) $(CLEAN_SUBDIRS)'; \
	for i in $$list; do \
	    if test -d "$$i"; then \
		target="$$otarget"; \
		echo "Making $$target in $$i"; \
		if test "$$i" = "."; then \
		    made_local=yes; \
		    target="local-$$target"; \
		fi; \
		(cd $$i && $(MAKE) $$target); \
	    fi; \
	done; \
        if test "$$otarget" = "all" && test -z "$(TARGETS)"; then \
	    made_local=yes; \
	fi; \
	if test "$$made_local" != "yes"; then \
	    $(MAKE) "local-$$otarget"; \
	fi

# autoconf 2.5x is creating a 'autom4te.cache' directory
# In case someone ran autoconf by hand, get rid of that directory
# aswell.
local-clean: x-local-clean
	$(RM) -f *.o *.lo *.a *.la *.so *.obj $(CLEAN_TARGETS) $(PROGRAMS)
	$(RM) -rf .libs autom4te.cache

local-distclean: local-clean x-local-distclean
	$(RM) -f Makefile $(DISTCLEAN_TARGETS)

local-extraclean: local-distclean x-local-extraclean
	@if test -n "$(EXTRACLEAN_TARGETS)"; then \
	    echo $(RM) -f $(EXTRACLEAN_TARGETS) ; \
	    $(RM) -f $(EXTRACLEAN_TARGETS) ; \
	fi

local-all: $(TARGETS)

local-depend: x-local-depend
	@if test -n "`ls $(srcdir)/*.c 2> /dev/null`"; then \
		$(RM) -f .deps; \
		list='$(srcdir)/*.c'; \
		for i in $$list; do \
			$(MKDEP) $(ALL_CPPFLAGS) $(ALL_INCLUDES) $$i | sed 's/\.o:/.lo:/' >> .deps; \
		done; \
	fi

# to be filled in by the actual Makefile
x-local-depend x-local-clean x-local-distclean x-local-extraclean:

#
# Implicit rules for creating outputs from input files
#
.SUFFIXES:
.SUFFIXES: .c .lo .o

.c.o:
	$(COMPILE) -c $<

.c.lo:
	$(LT_COMPILE)

.PHONY: all all-recursive local-all install \
	depend depend-recursive local-depend x-local-depend \
	clean clean-recursive local-clean x-local-clean \
	distclean distclean-recursive local-distclean x-local-distclean \
	extraclean extraclean-recursive local-extraclean x-local-extraclean
