#!/perl/bin/perl -w
#
# Quick hack to change APRxx symbol prefix in multiple NLM files.
#
# Written by G. Knauf <fuankg@apache.org>
# 28-Aug-2014 last change.
#
#######################################################################
$VERSION = '0.1.1';

$opt_i = 1;
$opt_d = 0;
$opt_s = "APR13@|APR14@";
$opt_t = "APR15@";

#######################################################################
if ($ARGV[0]) {
  $source_dir = $ARGV[0];
  die("Source dir not found!\n") if (!-d $source_dir);
} else {
  die("Usage: $0 <sourcedir>\n");
}
print "\rPerl Version: $]\tScript Version: $VERSION\n\n" if ($opt_i);
print "\rChecking for NLM modules in directory: $source_dir\n\n";
my $fcnt = 0;
chdir $source_dir;
opendir(DIR,$source_dir);
while($entry = readdir(DIR)) {
  if ((-f $entry) && ($entry =~ /\.nlm/i)) {
    my $file = "$source_dir/$entry";
    my $fsize = (lstat($file))[7];
    print "\rProcessing file: $file ($fsize bytes) ...\n" if ($opt_d);
    open(FH, "+<$file") or die "Couldn't open $file: $!";
    binmode FH;
    my $bcnt = sysread(FH, $tmp, $fsize);
    die("\rError sysread() at $file: size mismatch\n") if ($fsize != $bcnt);
    if ($tmp =~ /${opt_s}/) {
      $tmp =~ s/${opt_s}/${opt_t}/g;
      print "\rWriting ".length($tmp)." bytes to file $file ...\n" if ($opt_i);
      sysseek(FH, 0, 0);
      $bcnt = syswrite(FH, $tmp);
      if ($fsize != $bcnt) {
        print "Error syswrite() at $file: $!\n";
      } else {
        $fcnt++;
      }
    }
    close(FH) or die "Couldn't close $file: $!";
  }
}
print "\n";
print "\rTotal files fixed: $fcnt\n" if ($opt_i);
exit;


