/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#ifndef APR_H
#define APR_H

/* GENERATED FILE WARNING!  DO NOT EDIT apr.h
 *
 * You must modify apr.hnw instead.
 *
 * And please, make an effort to stub apr.hw and apr.h.in in the process.
 *
 * This is the NetWare specific version of apr.h.  It is copied from
 * apr.hnw at the start of a NetWare build by prebuildNW.bat. 
 */

/**
 * @file apr.h
 * @brief APR Platform Definitions
 * @remark This is a generated header generated from include/apr.h.in by
 * ./configure, or copied from include/apr.hw or include/apr.hnw 
 * for Win32 or Netware by those build environments, respectively.
 */

#if defined(NETWARE) || defined(DOXYGEN)

#define FD_SETSIZE 1024

#include <sys/types.h>
#include <stddef.h>
#include <stdio.h>
#include <time.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <nks/thread.h>
#include <nks/synch.h>
#include <nks/time.h>
#include <signal.h>
#include <novsock2.h>
#ifdef NW_BUILD_IPV6
#include <novtcpip.h>
#endif
#include <sys/types.h>

#define _POSIX_THREAD_SAFE_FUNCTIONS    1
#define READDIR_IS_THREAD_SAFE          1

/* Keep #include'd headers from within the __cplusplus or doxyblocks */

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @defgroup apr_platform Platform Definitions
 * @ingroup APR 
 * @{
 */

#define APR_INLINE 
#define APR_HAS_INLINE		0
#ifndef __attribute__
#define __attribute__(__x)
#endif
#define ENUM_BITFIELD(e,n,w)  signed int n : w

#define APR_HAVE_ARPA_INET_H    0
#define APR_HAVE_CONIO_H        0
#define APR_HAVE_CRYPT_H        0
#define APR_HAVE_CTYPE_H        1
#define APR_HAVE_DIRENT_H       1
#define APR_HAVE_ERRNO_H        1
#define APR_HAVE_FCNTL_H        1
#define APR_HAVE_IO_H           0
#define APR_HAVE_LIMITS_H       1
#define APR_HAVE_NETDB_H        0
#define APR_HAVE_NETINET_IN_H   0
#define APR_HAVE_NETINET_SCTP_H 0
#define APR_HAVE_NETINET_SCTP_UIO_H 0
#define APR_HAVE_NETINET_TCP_H  0
#define APR_HAVE_PTHREAD_H      0
#define APR_HAVE_SIGNAL_H       1
#define APR_HAVE_STDARG_H       1
#define APR_HAVE_STDINT_H       0
#define APR_HAVE_STDIO_H        1
#define APR_HAVE_STDLIB_H       1
#define APR_HAVE_STRING_H       1
#define APR_HAVE_STRINGS_H      0
#define APR_HAVE_STRTOLL	1
#define APR_HAVE_SYS_SENDFILE_H 0
#define APR_HAVE_SYS_SIGNAL_H   0
#define APR_HAVE_SYS_SOCKET_H   0
#define APR_HAVE_SYS_SOCKIO_H   0
#define APR_HAVE_SYS_SYSLIMITS_H 0
#define APR_HAVE_SYS_TIME_H     0
#define APR_HAVE_SYS_TYPES_H    1
#define APR_HAVE_SYS_UIO_H      1
#define APR_HAVE_SYS_UN_H       0
#define APR_HAVE_SYS_WAIT_H     0
#define APR_HAVE_TIME_H         1
#define APR_HAVE_UNISTD_H       1

#define APR_HAVE_SHMEM_MMAP_TMP     0
#define APR_HAVE_SHMEM_MMAP_SHM     0
#define APR_HAVE_SHMEM_MMAP_ZERO    0
#define APR_HAVE_SHMEM_SHMGET_ANON  0
#define APR_HAVE_SHMEM_SHMGET       0
#define APR_HAVE_SHMEM_MMAP_ANON    0
#define APR_HAVE_SHMEM_BEOS         0

#define APR_USE_SHMEM_MMAP_TMP     0
#define APR_USE_SHMEM_MMAP_SHM     0
#define APR_USE_SHMEM_MMAP_ZERO    0
#define APR_USE_SHMEM_SHMGET_ANON  0
#define APR_USE_SHMEM_SHMGET       0
#define APR_USE_SHMEM_MMAP_ANON    0
#define APR_USE_SHMEM_BEOS         0

#define APR_USE_FLOCK_SERIALIZE           0 
#define APR_USE_SYSVSEM_SERIALIZE         0
#define APR_USE_FCNTL_SERIALIZE           0
#define APR_USE_PROC_PTHREAD_SERIALIZE    0 
#define APR_USE_PTHREAD_SERIALIZE         0

#define APR_HAS_FLOCK_SERIALIZE           0
#define APR_HAS_SYSVSEM_SERIALIZE         0
#define APR_HAS_FCNTL_SERIALIZE           0
#define APR_HAS_PROC_PTHREAD_SERIALIZE    0
#define APR_HAS_RWLOCK_SERIALIZE          0 

#define APR_HAS_LOCK_CREATE_NP            0

#define APR_PROCESS_LOCK_IS_GLOBAL        1

#define APR_FILE_BASED_SHM      0

#define APR_HAVE_CORKABLE_TCP	0
#define APR_HAVE_GETRLIMIT      0
#define APR_HAVE_ICONV          0
#define APR_HAVE_IN_ADDR        1
#define APR_HAVE_INET_ADDR      1
#define APR_HAVE_INET_NETWORK   0
#ifdef NW_BUILD_IPV6
#define APR_HAVE_IPV6           1
#else
#define APR_HAVE_IPV6           0
#endif
#define APR_HAVE_MEMCHR         1
#define APR_HAVE_MEMMOVE        1
#define APR_HAVE_SETRLIMIT      0
#define APR_HAVE_SIGACTION      0
#define APR_HAVE_SIGSUSPEND     0
#define APR_HAVE_SIGWAIT        0
#define APR_HAVE_STRCASECMP     1
#define APR_HAVE_STRDUP         1
#define APR_HAVE_STRICMP        1
#define APR_HAVE_STRNCASECMP    1
#define APR_HAVE_STRNICMP       1
#define APR_HAVE_STRSTR         1
#define APR_HAVE_STRUCT_RLIMIT  0
#define APR_HAVE_UNION_SEMUN    0
#define APR_HAVE_SCTP           0

/*  APR Feature Macros */
#define APR_HAS_SHARED_MEMORY     0
#define APR_HAS_THREADS           1
#define APR_HAS_SENDFILE          0
#define APR_HAS_MMAP              0
#define APR_HAS_FORK              0
#define APR_HAS_RANDOM            1
#define APR_HAS_OTHER_CHILD       0
#define APR_HAS_DSO               1
#define APR_HAS_SO_ACCEPTFILTER   0
#define APR_HAS_UNICODE_FS        0
#define APR_HAS_PROC_INVOKED      0
#define APR_HAS_USER              1
#define APR_HAS_LARGE_FILES       0
#define APR_HAS_XTHREAD_FILES     0
#define APR_HAS_OS_UUID           0

/* Netware can poll on files/pipes.
 */
#define APR_FILES_AS_SOCKETS      1

/* Not all platforms have a real INADDR_NONE.  This macro replaces INADDR_NONE
 * on all platforms.
 */
#define APR_INADDR_NONE           INADDR_NONE

/* This macro indicates whether or not EBCDIC is the native character set.
 */
#define APR_CHARSET_EBCDIC        0

/* Is the TCP_NODELAY socket option inherited from listening sockets?
*/
#define APR_TCP_NODELAY_INHERITED 1

/* Is the O_NONBLOCK flag inherited from listening sockets?
*/
#define APR_O_NONBLOCK_INHERITED  1

/* Typedefs that APR needs. */

typedef  unsigned char     apr_byte_t;

typedef  short             apr_int16_t;
typedef  unsigned short    apr_uint16_t;
                                               
typedef  int               apr_int32_t;
typedef  unsigned int      apr_uint32_t;
                                               
typedef  long long		   apr_int64_t;
typedef  unsigned long long apr_uint64_t;

typedef  size_t            apr_size_t;
typedef  ssize_t           apr_ssize_t;
typedef  off_t             apr_off_t;
typedef  int               apr_socklen_t;

typedef apr_uint64_t       apr_ino_t;

#ifdef UNKNOWN_NETWARE_64BIT_FLAG_NEEDED
#define APR_SIZEOF_VOIDP   8
#else
#define APR_SIZEOF_VOIDP   4
#endif

/* Mechanisms to properly type numeric literals */

#ifdef __GNUC__
#define APR_INT64_C(val) (val)
#else
#define APR_INT64_C(val) (val##i64)
#endif

/* PROC mutex is a GLOBAL mutex on Netware */
#define APR_PROC_MUTEX_IS_GLOBAL      1

/* Definitions that APR programs need to work properly. */

/** 
 * Thread callbacks from APR functions must be declared with APR_THREAD_FUNC, 
 * so that they follow the platform's calling convention.
 * @example
 */
/** void* APR_THREAD_FUNC my_thread_entry_fn(apr_thread_t *thd, void *data);
 */
#define APR_THREAD_FUNC

/**
 * The public APR functions are declared with APR_DECLARE(), so they may
 * use the most appropriate calling convention.  Public APR functions with 
 * variable arguments must use APR_DECLARE_NONSTD().
 *
 * @remark Both the declaration and implementations must use the same macro.
 * @example
 */
/** APR_DECLARE(rettype) apr_func(args)
 * @see APR_DECLARE_NONSTD @see APR_DECLARE_DATA
 * @remark Note that when APR compiles the library itself, it passes the 
 * symbol -DAPR_DECLARE_EXPORT to the compiler on some platforms (e.g. Win32) 
 * to export public symbols from the dynamic library build.\n
 * The user must define the APR_DECLARE_STATIC when compiling to target
 * the static APR library on some platforms (e.g. Win32.)  The public symbols 
 * are neither exported nor imported when APR_DECLARE_STATIC is defined.\n
 * By default, compiling an application and including the APR public
 * headers, without defining APR_DECLARE_STATIC, will prepare the code to be
 * linked to the dynamic library.
 */
#define APR_DECLARE(type)            type 

/**
 * The public APR functions using variable arguments are declared with 
 * APR_DECLARE_NONSTD(), as they must follow the C language calling convention.
 * @see APR_DECLARE @see APR_DECLARE_DATA
 * @remark Both the declaration and implementations must use the same macro.
 * @example
 */
/** APR_DECLARE_NONSTD(rettype) apr_func(args, ...);
 */
#define APR_DECLARE_NONSTD(type)     type

/**
 * The public APR variables are declared with AP_MODULE_DECLARE_DATA.
 * This assures the appropriate indirection is invoked at compile time.
 * @see APR_DECLARE @see APR_DECLARE_NONSTD
 * @remark Note that the declaration and implementations use different forms,
 * but both must include the macro.
 * @example
 */
/** extern APR_DECLARE_DATA type apr_variable;\n
 * APR_DECLARE_DATA type apr_variable = value;
 */
#define APR_DECLARE_DATA

#define APR_SSIZE_T_FMT          "d"

#define APR_SIZE_T_FMT           "d"

#define APR_OFF_T_FMT            "ld"

#define APR_PID_T_FMT            "d"

/* Local machine definition for console and log output. */
#define APR_EOL_STR              "\r\n"

typedef int apr_wait_t;

#define APR_PATH_MAX PATH_MAX

#define APR_INT64_T_FMT          "lld"
#define APR_INT64_T_FMT_LEN      3
#define APR_UINT64_T_FMT         "llu"
#define APR_UINT64_T_FMT_LEN     3
#define APR_UINT64_T_HEX_FMT     "llx"
#define APR_UINT64_T_HEX_FMT_LEN (sizeof(APR_UINT64_T_HEX_FMT) - 1)
#define APR_TIME_T_FMT APR_INT64_T_FMT

/* Deal with atoi64 variables ... these should move to apr_private.h */
#define APR_HAVE_INT64_STRFN  1
#define APR_INT64_STRFN	      strtoll

/** @} */

#ifdef __cplusplus
}
#endif

#endif /* NETWARE */

#endif /* APR_H */
