# ====================================================================
# The Apache Software License, Version 1.1
#
# Copyright (c) 2000-2002 The Apache Software Foundation.  All rights
# reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
#
# 3. The end-user documentation included with the redistribution,
#    if any, must include the following acknowledgment:
#       "This product includes software developed by the
#        Apache Software Foundation (http://www.apache.org/)."
#    Alternately, this acknowledgment may appear in the software itself,
#    if and wherever such third-party acknowledgments normally appear.
#
# 4. The names "Apache" and "Apache Software Foundation" must
#    not be used to endorse or promote products derived from this
#    software without prior written permission. For written
#    permission, please contact apache@apache.org.
#
# 5. Products derived from this software may not be called "Apache",
#    nor may "Apache" appear in their name, without prior written
#    permission of the Apache Software Foundation.
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
# ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
# USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
# OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
# ====================================================================
#
# This software consists of voluntary contributions made by many
# individuals on behalf of the Apache Software Foundation.  For more
# information on the Apache Software Foundation, please see
# <http://www.apache.org/>.
#
# The build environment was originally provided by Sascha Schumann.
#

include $(top_builddir)/build/config_vars.mk

# Combine all of the flags together in the proper order so that
# the user-defined flags can always override the configure ones, if needed.
# Note that includes are listed after the flags because -I options have
# left-to-right precedence and CPPFLAGS may include user-defined overrides.
#
ALL_CFLAGS   = $(EXTRA_CFLAGS) $(NOTEST_CFLAGS) $(CFLAGS)
ALL_CPPFLAGS = $(DEFS) $(EXTRA_CPPFLAGS) $(NOTEST_CPPFLAGS) $(CPPFLAGS)
ALL_CXXFLAGS = $(EXTRA_CXXFLAGS) $(NOTEST_CXXFLAGS) $(CXXFLAGS)
ALL_LDFLAGS  = $(EXTRA_LDFLAGS) $(NOTEST_LDFLAGS) $(LDFLAGS)
ALL_LIBS     = $(EXTRA_LIBS) $(NOTEST_LIBS) $(LIBS)
ALL_INCLUDES = $(INCLUDES) $(EXTRA_INCLUDES)

# Compile commands

COMPILE      = $(CC)  $(ALL_CFLAGS) $(ALL_CPPFLAGS) $(ALL_INCLUDES)
CXX_COMPILE  = $(CXX) $(ALL_CXXFLAGS) $(ALL_CPPFLAGS) $(ALL_INCLUDES)

SH_COMPILE     = $(LIBTOOL) --mode=compile $(COMPILE) -prefer-pic -c $< && touch $@
SH_CXX_COMPILE = $(LIBTOOL) --mode=compile $(CXX_COMPILE) -prefer-pic -c $< && touch $@

LT_COMPILE     = $(LIBTOOL) --mode=compile $(COMPILE) -prefer-non-pic -static -c $< && touch $@
LT_CXX_COMPILE = $(LIBTOOL) --mode=compile $(CXX_COMPILE) -prefer-non-pic -static -c $< && touch $@

# Link-related commands

LINK     = $(LIBTOOL) --mode=link $(COMPILE) $(LT_LDFLAGS) $(ALL_LDFLAGS) -o $@
SH_LINK  = $(SH_LIBTOOL) --mode=link $(COMPILE) $(LT_LDFLAGS) $(ALL_LDFLAGS) $(SH_LDFLAGS) $(CORE_IMPLIB) $(SH_LIBS) -o $@
MOD_LINK = $(LIBTOOL) --mode=link $(COMPILE) -module $(LT_LDFLAGS) $(ALL_LDFLAGS) -o $@

# Cross compile commands

# Helper programs

MKINSTALLDIRS = $(abs_srcdir)/build/mkdir.sh
INSTALL = $(LIBTOOL) --mode=install $(abs_srcdir)/build/install.sh -c
INSTALL_DATA = $(INSTALL) -m 644
INSTALL_PROGRAM = $(INSTALL) -m 755 $(INSTALL_PROG_FLAGS)

#
# Standard build rules
#
all: all-recursive
depend: depend-recursive
clean: clean-recursive
distclean: distclean-recursive
extraclean: extraclean-recursive
install: install-recursive
shared-build: shared-build-recursive

all-recursive install-recursive depend-recursive:
	@otarget=`echo $@|sed s/-recursive//`; \
	list=' $(BUILD_SUBDIRS) $(SUBDIRS)'; \
	for i in $$list; do \
	    if test -d "$$i"; then \
		target="$$otarget"; \
		echo "Making $$target in $$i"; \
		if test "$$i" = "."; then \
			made_local=yes; \
			target="local-$$target"; \
		fi; \
		(cd $$i && $(MAKE) $$target) || exit 1; \
	    fi; \
	done; \
	if test "$$otarget" = "all" && test -z '$(TARGETS)'; then \
	    made_local=yes; \
	fi; \
	if test "$$made_local" != "yes"; then \
	    $(MAKE) "local-$$otarget" || exit 1; \
	fi

clean-recursive distclean-recursive extraclean-recursive:
	@otarget=`echo $@|sed s/-recursive//`; \
	list='$(CLEAN_SUBDIRS) $(SUBDIRS)'; \
	for i in $$list; do \
	    if test -d "$$i"; then \
		target="$$otarget"; \
		echo "Making $$target in $$i"; \
		if test "$$i" = "."; then \
			made_local=yes; \
			target="local-$$target"; \
		fi; \
		(cd $$i && $(MAKE) $$target); \
	    fi; \
	done; \
	if test "$$otarget" = "all" && test -z '$(TARGETS)'; then \
	    made_local=yes; \
	fi; \
	if test "$$made_local" != "yes"; then \
	    $(MAKE) "local-$$otarget"; \
	fi

shared-build-recursive:
	@if test `pwd` = "$(top_builddir)"; then \
	    $(PRE_SHARED_CMDS) ; \
	fi; \
	list='$(SUBDIRS)'; for i in $$list; do \
	    target="shared-build"; \
	    if test "$$i" = "."; then \
		made_local=yes; \
		target="local-shared-build"; \
	    fi; \
	    if test "$$i" != "srclib"; then \
		(cd $$i && $(MAKE) $$target) || exit 1; \
	    fi; \
	done; \
	if test -f 'modules.mk'; then \
	    if test -n '$(SHARED_TARGETS)'; then \
		echo "Building shared: $(SHARED_TARGETS)"; \
		if test "$$made_local" != "yes"; then \
			$(MAKE) "local-shared-build" || exit 1; \
		fi; \
	    fi; \
	fi; \
	if test `pwd` = "$(top_builddir)"; then \
		$(POST_SHARED_CMDS) ; \
	fi

local-all: $(TARGETS)

local-shared-build: $(SHARED_TARGETS)

local-depend: x-local-depend
	if test -n "`ls $(srcdir)/*.c 2> /dev/null`"; then \
		$(CC) -MM $(ALL_CPPFLAGS) $(ALL_INCLUDES) $(srcdir)/*.c | sed 's/\.o:/.lo:/' > $(builddir)/.deps || true;           \
	fi

local-clean: x-local-clean
	rm -f *.o *.lo *.slo *.obj *.a *.la $(CLEAN_TARGETS) $(TARGETS)
	rm -rf .libs

local-distclean: local-clean x-local-distclean
	rm -f .deps Makefile $(DISTCLEAN_TARGETS)

local-extraclean: local-distclean x-local-extraclean
	@if test -n "$(EXTRACLEAN_TARGETS)"; then \
	    echo "rm -f $(EXTRACLEAN_TARGETS)"; \
	    rm -f $(EXTRACLEAN_TARGETS) ; \
	fi

local-install: $(TARGETS) $(SHARED_TARGETS) $(INSTALL_TARGETS)
	@if test -n '$(PROGRAMS)'; then \
	    test -d $(sbindir) || $(MKINSTALLDIRS) $(sbindir); \
	    list='$(PROGRAMS)'; for i in $$list; do \
	        $(INSTALL_PROGRAM) $$i $(sbindir); \
	    done; \
	fi

# to be filled in by the actual Makefile if extra commands are needed
x-local-depend x-local-clean x-local-distclean x-local-extraclean:

#
# Implicit rules for creating outputs from input files
#
CXX_SUFFIX = cpp
SHLIB_SUFFIX = so

.SUFFIXES:
.SUFFIXES: .S .c .$(CXX_SUFFIX) .lo .o .s .y .l .slo .def .la

.c.o:
	$(COMPILE) -c $<

.s.o:
	$(COMPILE) -c $<

.c.lo:
	$(LT_COMPILE)

.s.lo:
	$(LT_COMPILE)

.c.slo:
	$(SH_COMPILE)

.$(CXX_SUFFIX).lo:
	$(LT_CXX_COMPILE)

.$(CXX_SUFFIX).slo:
	$(SH_CXX_COMPILE)

.y.c:
	$(YACC) $(YFLAGS) $< && mv y.tab.c $*.c
	if test -f y.tab.h; then \
	if cmp -s y.tab.h $*.h; then rm -f y.tab.h; else mv y.tab.h $*.h; fi; \
	else :; fi

.l.c:
	$(LEX) $(LFLAGS) $< && mv $(LEX_OUTPUT_ROOT).c $@

# Makes an import library from a def file
.def.la:
	$(LIBTOOL) --mode=compile $(MK_IMPLIB) -o $@ $<

#
# Dependencies
#
include $(builddir)/.deps

.PHONY: all all-recursive install-recursive local-all $(PHONY_TARGETS) \
	shared-build shared-build-recursive local-shared-build \
	depend depend-recursive local-depend x-local-depend \
	clean clean-recursive local-clean x-local-clean \
	distclean distclean-recursive local-distclean x-local-distclean \
	extraclean extraclean-recursive local-extraclean x-local-extraclean \
	install local-install $(INSTALL_TARGETS)

