#!/bin/sh
#
# Usage: install-bindist.sh [ServerRoot]
# This script installs the Apache binary distribution and
# was automatically created by binbuild.sh.
 
lmkdir()
{
  path=""
  dirs=`echo $1 | sed -e 's%/% %g'`
  mode=$2
 
  set -- ${dirs}
 
  for d in ${dirs}
  do
    path="${path}/$d"
    if test ! -d "${path}" ; then
      mkdir ${path}
      if test $? -ne 0 ; then
        echo "Failed to create directory: ${path}"
        exit 1
      fi
      chmod ${mode} ${path}
    fi
  done
}
 
lcopy()
{
  from=$1
  to=$2
  dmode=$3
  fmode=$4
 
  test -d ${to} || lmkdir ${to} ${dmode}
  (cd ${from} && tar -cf - *) | (cd ${to} && tar -xf -)
 
  if test "X${fmode}" != X ; then
    find ${to} -type f -print | xargs chmod ${fmode}
  fi
  if test "X${dmode}" != X ; then
    find ${to} -type d -print | xargs chmod ${dmode}
  fi
}
 
##
##  determine path to (optional) Perl interpreter
##
PERL=no-perl5-on-this-system
perls='perl5 perl'
path=`echo $PATH | sed -e 's/:/ /g'`
 
for dir in ${path} ;  do
  for pperl in ${perls} ; do
    if test -f "${dir}/${pperl}" ; then
      if `${dir}/${pperl} -v | grep 'version 5\.' >/dev/null 2>&1` ; then
        PERL="${dir}/${pperl}"
        break
      fi
    fi
  done
done
 
if [ .$1 = . ]
then
  SR=/usr/local/apache
else
  SR=$1
fi
echo "Installing binary distribution for platform i386-whatever-freebsd4.6"
echo "into directory $SR ..."
lmkdir $SR 755
lmkdir $SR/proxy 750
lmkdir $SR/logs 750
lcopy bindist/man $SR/man 755 644
lcopy bindist/libexec $SR/libexec 750 750
lcopy bindist/include $SR/include 755 644
lcopy bindist/icons $SR/icons 755 644
lcopy bindist/cgi-bin $SR/cgi-bin 750 750
lcopy bindist/bin $SR/bin 750 750
if [ -d $SR/conf ]
then
  echo "[Preserving existing configuration files.]"
  cp bindist/conf/*.default $SR/conf/
else
  lcopy bindist/conf $SR/conf 750 640
fi
if [ -d $SR/htdocs ]
then
  echo "[Preserving existing htdocs directory.]"
else
  lcopy bindist/htdocs $SR/htdocs 755 644
fi
 
sed -e "s;^#!/.*;#!$PERL;" -e "s;\@prefix\@;$SR;" -e "s;\@sbindir\@;$SR/bin;" \
	-e "s;\@libexecdir\@;$SR/libexec;" -e "s;\@includedir\@;$SR/include;" \
	-e "s;\@sysconfdir\@;$SR/conf;" bindist/bin/apxs > $SR/bin/apxs
sed -e "s;^#!/.*;#!$PERL;" bindist/bin/dbmmanage > $SR/bin/dbmmanage
sed -e "s%/usr/local/apache%$SR%" $SR/conf/httpd.conf.default > $SR/conf/httpd.conf
sed -e "s%PIDFILE=%PIDFILE=$SR/%" -e "s%HTTPD=%HTTPD=\"$SR/%" -e "s%httpd$%httpd -d $SR -R $SR/libexec\"%" bindist/bin/apachectl > $SR/bin/apachectl
 
echo "Ready."
echo " +--------------------------------------------------------+"
echo " | You now have successfully installed the Apache 1.3.26  |"
echo " | HTTP server. To verify that Apache actually works      |"
echo " | correctly you should first check the (initially        |"
echo " | created or preserved) configuration files:             |"
echo " |                                                        |"
echo " |   $SR/conf/httpd.conf"
echo " |                                                        |"
echo " | You should then be able to immediately fire up         |"
echo " | Apache the first time by running:                      |"
echo " |                                                        |"
echo " |   $SR/bin/apachectl start "
echo " |                                                        |"
echo " | Thanks for using Apache.       The Apache Group        |"
echo " |                                http://www.apache.org/  |"
echo " +--------------------------------------------------------+"
echo " "
